package software.amazon.awscdk.services.s3;

/**
 * The intelligent tiering configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.core.*;
 * IntelligentTieringConfiguration intelligentTieringConfiguration = IntelligentTieringConfiguration.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .archiveAccessTierTime(Duration.minutes(30))
 *         .deepArchiveAccessTierTime(Duration.minutes(30))
 *         .prefix("prefix")
 *         .tags(List.of(Tag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-31T18:44:09.379Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.IntelligentTieringConfiguration")
@software.amazon.jsii.Jsii.Proxy(IntelligentTieringConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IntelligentTieringConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * Configuration name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * When enabled, Intelligent-Tiering will automatically move objects that haven’t been accessed for a minimum of 90 days to the Archive Access tier.
     * <p>
     * Default: Objects will not move to Glacier
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getArchiveAccessTierTime() {
        return null;
    }

    /**
     * When enabled, Intelligent-Tiering will automatically move objects that haven’t been accessed for a minimum of 180 days to the Deep Archive Access tier.
     * <p>
     * Default: Objects will not move to Glacier Deep Access
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getDeepArchiveAccessTierTime() {
        return null;
    }

    /**
     * Add a filter to limit the scope of this configuration to a single prefix.
     * <p>
     * Default: this configuration will apply to **all** objects in the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
        return null;
    }

    /**
     * You can limit the scope of this rule to the key value pairs added below.
     * <p>
     * Default: No filtering will be performed on tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.Tag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link IntelligentTieringConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IntelligentTieringConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IntelligentTieringConfiguration> {
        java.lang.String name;
        software.amazon.awscdk.core.Duration archiveAccessTierTime;
        software.amazon.awscdk.core.Duration deepArchiveAccessTierTime;
        java.lang.String prefix;
        java.util.List<software.amazon.awscdk.services.s3.Tag> tags;

        /**
         * Sets the value of {@link IntelligentTieringConfiguration#getName}
         * @param name Configuration name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link IntelligentTieringConfiguration#getArchiveAccessTierTime}
         * @param archiveAccessTierTime When enabled, Intelligent-Tiering will automatically move objects that haven’t been accessed for a minimum of 90 days to the Archive Access tier.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder archiveAccessTierTime(software.amazon.awscdk.core.Duration archiveAccessTierTime) {
            this.archiveAccessTierTime = archiveAccessTierTime;
            return this;
        }

        /**
         * Sets the value of {@link IntelligentTieringConfiguration#getDeepArchiveAccessTierTime}
         * @param deepArchiveAccessTierTime When enabled, Intelligent-Tiering will automatically move objects that haven’t been accessed for a minimum of 180 days to the Deep Archive Access tier.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deepArchiveAccessTierTime(software.amazon.awscdk.core.Duration deepArchiveAccessTierTime) {
            this.deepArchiveAccessTierTime = deepArchiveAccessTierTime;
            return this;
        }

        /**
         * Sets the value of {@link IntelligentTieringConfiguration#getPrefix}
         * @param prefix Add a filter to limit the scope of this configuration to a single prefix.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefix(java.lang.String prefix) {
            this.prefix = prefix;
            return this;
        }

        /**
         * Sets the value of {@link IntelligentTieringConfiguration#getTags}
         * @param tags You can limit the scope of this rule to the key value pairs added below.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.services.s3.Tag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.services.s3.Tag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IntelligentTieringConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IntelligentTieringConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IntelligentTieringConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntelligentTieringConfiguration {
        private final java.lang.String name;
        private final software.amazon.awscdk.core.Duration archiveAccessTierTime;
        private final software.amazon.awscdk.core.Duration deepArchiveAccessTierTime;
        private final java.lang.String prefix;
        private final java.util.List<software.amazon.awscdk.services.s3.Tag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.archiveAccessTierTime = software.amazon.jsii.Kernel.get(this, "archiveAccessTierTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.deepArchiveAccessTierTime = software.amazon.jsii.Kernel.get(this, "deepArchiveAccessTierTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.Tag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.archiveAccessTierTime = builder.archiveAccessTierTime;
            this.deepArchiveAccessTierTime = builder.deepArchiveAccessTierTime;
            this.prefix = builder.prefix;
            this.tags = (java.util.List<software.amazon.awscdk.services.s3.Tag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getArchiveAccessTierTime() {
            return this.archiveAccessTierTime;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getDeepArchiveAccessTierTime() {
            return this.deepArchiveAccessTierTime;
        }

        @Override
        public final java.lang.String getPrefix() {
            return this.prefix;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.Tag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getArchiveAccessTierTime() != null) {
                data.set("archiveAccessTierTime", om.valueToTree(this.getArchiveAccessTierTime()));
            }
            if (this.getDeepArchiveAccessTierTime() != null) {
                data.set("deepArchiveAccessTierTime", om.valueToTree(this.getDeepArchiveAccessTierTime()));
            }
            if (this.getPrefix() != null) {
                data.set("prefix", om.valueToTree(this.getPrefix()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.IntelligentTieringConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IntelligentTieringConfiguration.Jsii$Proxy that = (IntelligentTieringConfiguration.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.archiveAccessTierTime != null ? !this.archiveAccessTierTime.equals(that.archiveAccessTierTime) : that.archiveAccessTierTime != null) return false;
            if (this.deepArchiveAccessTierTime != null ? !this.deepArchiveAccessTierTime.equals(that.deepArchiveAccessTierTime) : that.deepArchiveAccessTierTime != null) return false;
            if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.archiveAccessTierTime != null ? this.archiveAccessTierTime.hashCode() : 0);
            result = 31 * result + (this.deepArchiveAccessTierTime != null ? this.deepArchiveAccessTierTime.hashCode() : 0);
            result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
