package software.amazon.awscdk.services.s3;

/**
 * Properties for defining a `AWS::S3::BucketPolicy`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.3.0 (build 8ae966b)", date = "2020-04-17T19:11:16.991Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucketPolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnBucketPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnBucketPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::S3::BucketPolicy.Bucket`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-bucket
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @org.jetbrains.annotations.NotNull java.lang.String getBucket();

    /**
     * `AWS::S3::BucketPolicy.PolicyDocument`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-policydocument
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @org.jetbrains.annotations.NotNull java.lang.Object getPolicyDocument();

    /**
     * @return a {@link Builder} of {@link CfnBucketPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnBucketPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String bucket;
        private java.lang.Object policyDocument;

        /**
         * Sets the value of {@link CfnBucketPolicyProps#getBucket}
         * @param bucket `AWS::S3::BucketPolicy.Bucket`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder bucket(java.lang.String bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketPolicyProps#getPolicyDocument}
         * @param policyDocument `AWS::S3::BucketPolicy.PolicyDocument`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder policyDocument(java.lang.Object policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnBucketPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnBucketPolicyProps build() {
            return new Jsii$Proxy(bucket, policyDocument);
        }
    }

    /**
     * An implementation for {@link CfnBucketPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnBucketPolicyProps {
        private final java.lang.String bucket;
        private final java.lang.Object policyDocument;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = this.jsiiGet("bucket", java.lang.String.class);
            this.policyDocument = this.jsiiGet("policyDocument", java.lang.Object.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String bucket, final java.lang.Object policyDocument) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = java.util.Objects.requireNonNull(bucket, "bucket is required");
            this.policyDocument = java.util.Objects.requireNonNull(policyDocument, "policyDocument is required");
        }

        @Override
        public java.lang.String getBucket() {
            return this.bucket;
        }

        @Override
        public java.lang.Object getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucket", om.valueToTree(this.getBucket()));
            data.set("policyDocument", om.valueToTree(this.getPolicyDocument()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucketPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnBucketPolicyProps.Jsii$Proxy that = (CfnBucketPolicyProps.Jsii$Proxy) o;

            if (!bucket.equals(that.bucket)) return false;
            return this.policyDocument.equals(that.policyDocument);
        }

        @Override
        public int hashCode() {
            int result = this.bucket.hashCode();
            result = 31 * result + (this.policyDocument.hashCode());
            return result;
        }
    }
}
