package software.amazon.awscdk.services.s3;

/**
 * An interface that represents the location of a specific object in an S3 Bucket.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-24T11:26:55.260Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.Location")
@software.amazon.jsii.Jsii.Proxy(Location.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Location extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the S3 Bucket the object is in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

    /**
     * The path inside the Bucket where the object is located at.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getObjectKey();

    /**
     * The S3 object version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getObjectVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Location}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Location}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String bucketName;
        private java.lang.String objectKey;
        private java.lang.String objectVersion;

        /**
         * Sets the value of {@link Location#getBucketName}
         * @param bucketName The name of the S3 Bucket the object is in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(java.lang.String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        /**
         * Sets the value of {@link Location#getObjectKey}
         * @param objectKey The path inside the Bucket where the object is located at. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectKey(java.lang.String objectKey) {
            this.objectKey = objectKey;
            return this;
        }

        /**
         * Sets the value of {@link Location#getObjectVersion}
         * @param objectVersion The S3 object version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectVersion(java.lang.String objectVersion) {
            this.objectVersion = objectVersion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Location}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Location build() {
            return new Jsii$Proxy(bucketName, objectKey, objectVersion);
        }
    }

    /**
     * An implementation for {@link Location}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Location {
        private final java.lang.String bucketName;
        private final java.lang.String objectKey;
        private final java.lang.String objectVersion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucketName = this.jsiiGet("bucketName", java.lang.String.class);
            this.objectKey = this.jsiiGet("objectKey", java.lang.String.class);
            this.objectVersion = this.jsiiGet("objectVersion", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String bucketName, final java.lang.String objectKey, final java.lang.String objectVersion) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucketName = java.util.Objects.requireNonNull(bucketName, "bucketName is required");
            this.objectKey = java.util.Objects.requireNonNull(objectKey, "objectKey is required");
            this.objectVersion = objectVersion;
        }

        @Override
        public java.lang.String getBucketName() {
            return this.bucketName;
        }

        @Override
        public java.lang.String getObjectKey() {
            return this.objectKey;
        }

        @Override
        public java.lang.String getObjectVersion() {
            return this.objectVersion;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucketName", om.valueToTree(this.getBucketName()));
            data.set("objectKey", om.valueToTree(this.getObjectKey()));
            if (this.getObjectVersion() != null) {
                data.set("objectVersion", om.valueToTree(this.getObjectVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.Location"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Location.Jsii$Proxy that = (Location.Jsii$Proxy) o;

            if (!bucketName.equals(that.bucketName)) return false;
            if (!objectKey.equals(that.objectKey)) return false;
            return this.objectVersion != null ? this.objectVersion.equals(that.objectVersion) : that.objectVersion == null;
        }

        @Override
        public int hashCode() {
            int result = this.bucketName.hashCode();
            result = 31 * result + (this.objectKey.hashCode());
            result = 31 * result + (this.objectVersion != null ? this.objectVersion.hashCode() : 0);
            return result;
        }
    }
}
