package software.amazon.awscdk.services.s3;

/**
 * Specifies a metrics configuration for the CloudWatch request metrics from an Amazon S3 bucket.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-14T08:19:35.547Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BucketMetrics extends software.amazon.jsii.JsiiSerializable {
    /**
     * The ID used to identify the metrics configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getId();
    /**
     * The prefix that an object must have to be included in the metrics results.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getPrefix();
    /**
     * Specifies a list of tag filters to use as a metrics configuration filter. The metrics configuration includes only objects that meet the filter's criteria.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.Map<java.lang.String, java.lang.Object> getTagFilters();

    /**
     * @return a {@link Builder} of {@link BucketMetrics}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BucketMetrics}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String _id;
        @javax.annotation.Nullable
        private java.lang.String _prefix;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.Object> _tagFilters;

        /**
         * Sets the value of Id
         * @param value The ID used to identify the metrics configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withId(final java.lang.String value) {
            this._id = java.util.Objects.requireNonNull(value, "id is required");
            return this;
        }
        /**
         * Sets the value of Prefix
         * @param value The prefix that an object must have to be included in the metrics results.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
            this._prefix = value;
            return this;
        }
        /**
         * Sets the value of TagFilters
         * @param value Specifies a list of tag filters to use as a metrics configuration filter. The metrics configuration includes only objects that meet the filter's criteria.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTagFilters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
            this._tagFilters = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketMetrics}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public BucketMetrics build() {
            return new BucketMetrics() {
                private final java.lang.String $id = java.util.Objects.requireNonNull(_id, "id is required");
                @javax.annotation.Nullable
                private final java.lang.String $prefix = _prefix;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.Object> $tagFilters = _tagFilters;

                @Override
                public java.lang.String getId() {
                    return this.$id;
                }

                @Override
                public java.lang.String getPrefix() {
                    return this.$prefix;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.Object> getTagFilters() {
                    return this.$tagFilters;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("id", om.valueToTree(this.getId()));
                    if (this.getPrefix() != null) {
                        obj.set("prefix", om.valueToTree(this.getPrefix()));
                    }
                    if (this.getTagFilters() != null) {
                        obj.set("tagFilters", om.valueToTree(this.getTagFilters()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.BucketMetrics {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ID used to identify the metrics configuration.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getId() {
            return this.jsiiGet("id", java.lang.String.class);
        }

        /**
         * The prefix that an object must have to be included in the metrics results.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getPrefix() {
            return this.jsiiGet("prefix", java.lang.String.class);
        }

        /**
         * Specifies a list of tag filters to use as a metrics configuration filter. The metrics configuration includes only objects that meet the filter's criteria.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.Object> getTagFilters() {
            return this.jsiiGet("tagFilters", java.util.Map.class);
        }
    }
}
