package software.amazon.awscdk.services.s3;

/**
 * Specifies a redirect behavior of all requests to a website endpoint of a bucket.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-14T08:19:35.589Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RedirectTarget extends software.amazon.jsii.JsiiSerializable {
    /**
     * Name of the host where requests are redirected.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getHostName();
    /**
     * Protocol to use when redirecting requests.
     * 
     * Default: - The protocol used in the original request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.s3.RedirectProtocol getProtocol();

    /**
     * @return a {@link Builder} of {@link RedirectTarget}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link RedirectTarget}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String _hostName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.s3.RedirectProtocol _protocol;

        /**
         * Sets the value of HostName
         * @param value Name of the host where requests are redirected.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withHostName(final java.lang.String value) {
            this._hostName = java.util.Objects.requireNonNull(value, "hostName is required");
            return this;
        }
        /**
         * Sets the value of Protocol
         * @param value Protocol to use when redirecting requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.RedirectProtocol value) {
            this._protocol = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RedirectTarget}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public RedirectTarget build() {
            return new RedirectTarget() {
                private final java.lang.String $hostName = java.util.Objects.requireNonNull(_hostName, "hostName is required");
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.s3.RedirectProtocol $protocol = _protocol;

                @Override
                public java.lang.String getHostName() {
                    return this.$hostName;
                }

                @Override
                public software.amazon.awscdk.services.s3.RedirectProtocol getProtocol() {
                    return this.$protocol;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("hostName", om.valueToTree(this.getHostName()));
                    if (this.getProtocol() != null) {
                        obj.set("protocol", om.valueToTree(this.getProtocol()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.RedirectTarget {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Name of the host where requests are redirected.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getHostName() {
            return this.jsiiGet("hostName", java.lang.String.class);
        }

        /**
         * Protocol to use when redirecting requests.
         * 
         * Default: - The protocol used in the original request.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.s3.RedirectProtocol getProtocol() {
            return this.jsiiGet("protocol", software.amazon.awscdk.services.s3.RedirectProtocol.class);
        }
    }
}
