package software.amazon.awscdk.services.s3;

/**
 * Rule that define when a redirect is applied and the redirect behavior.
 * 
 * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-14T08:19:35.589Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RoutingRule extends software.amazon.jsii.JsiiSerializable {
    /**
     * Specifies a condition that must be met for the specified redirect to apply.
     * 
     * Default: - No condition
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.s3.RoutingRuleCondition getCondition();
    /**
     * The host name to use in the redirect request.
     * 
     * Default: - The host name used in the original request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getHostName();
    /**
     * The HTTP redirect code to use on the response.
     * 
     * Default: "301" - Moved Permanently
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getHttpRedirectCode();
    /**
     * Protocol to use when redirecting requests.
     * 
     * Default: - The protocol used in the original request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.s3.RedirectProtocol getProtocol();
    /**
     * Specifies the object key prefix to use in the redirect request.
     * 
     * Default: - The key will not be replaced
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.s3.ReplaceKey getReplaceKey();

    /**
     * @return a {@link Builder} of {@link RoutingRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link RoutingRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.s3.RoutingRuleCondition _condition;
        @javax.annotation.Nullable
        private java.lang.String _hostName;
        @javax.annotation.Nullable
        private java.lang.String _httpRedirectCode;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.s3.RedirectProtocol _protocol;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.s3.ReplaceKey _replaceKey;

        /**
         * Sets the value of Condition
         * @param value Specifies a condition that must be met for the specified redirect to apply.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withCondition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.RoutingRuleCondition value) {
            this._condition = value;
            return this;
        }
        /**
         * Sets the value of HostName
         * @param value The host name to use in the redirect request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withHostName(@javax.annotation.Nullable final java.lang.String value) {
            this._hostName = value;
            return this;
        }
        /**
         * Sets the value of HttpRedirectCode
         * @param value The HTTP redirect code to use on the response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withHttpRedirectCode(@javax.annotation.Nullable final java.lang.String value) {
            this._httpRedirectCode = value;
            return this;
        }
        /**
         * Sets the value of Protocol
         * @param value Protocol to use when redirecting requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.RedirectProtocol value) {
            this._protocol = value;
            return this;
        }
        /**
         * Sets the value of ReplaceKey
         * @param value Specifies the object key prefix to use in the redirect request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withReplaceKey(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.ReplaceKey value) {
            this._replaceKey = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RoutingRule}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public RoutingRule build() {
            return new RoutingRule() {
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.s3.RoutingRuleCondition $condition = _condition;
                @javax.annotation.Nullable
                private final java.lang.String $hostName = _hostName;
                @javax.annotation.Nullable
                private final java.lang.String $httpRedirectCode = _httpRedirectCode;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.s3.RedirectProtocol $protocol = _protocol;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.s3.ReplaceKey $replaceKey = _replaceKey;

                @Override
                public software.amazon.awscdk.services.s3.RoutingRuleCondition getCondition() {
                    return this.$condition;
                }

                @Override
                public java.lang.String getHostName() {
                    return this.$hostName;
                }

                @Override
                public java.lang.String getHttpRedirectCode() {
                    return this.$httpRedirectCode;
                }

                @Override
                public software.amazon.awscdk.services.s3.RedirectProtocol getProtocol() {
                    return this.$protocol;
                }

                @Override
                public software.amazon.awscdk.services.s3.ReplaceKey getReplaceKey() {
                    return this.$replaceKey;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getCondition() != null) {
                        obj.set("condition", om.valueToTree(this.getCondition()));
                    }
                    if (this.getHostName() != null) {
                        obj.set("hostName", om.valueToTree(this.getHostName()));
                    }
                    if (this.getHttpRedirectCode() != null) {
                        obj.set("httpRedirectCode", om.valueToTree(this.getHttpRedirectCode()));
                    }
                    if (this.getProtocol() != null) {
                        obj.set("protocol", om.valueToTree(this.getProtocol()));
                    }
                    if (this.getReplaceKey() != null) {
                        obj.set("replaceKey", om.valueToTree(this.getReplaceKey()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.RoutingRule {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Specifies a condition that must be met for the specified redirect to apply.
         * 
         * Default: - No condition
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.s3.RoutingRuleCondition getCondition() {
            return this.jsiiGet("condition", software.amazon.awscdk.services.s3.RoutingRuleCondition.class);
        }

        /**
         * The host name to use in the redirect request.
         * 
         * Default: - The host name used in the original request.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getHostName() {
            return this.jsiiGet("hostName", java.lang.String.class);
        }

        /**
         * The HTTP redirect code to use on the response.
         * 
         * Default: "301" - Moved Permanently
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getHttpRedirectCode() {
            return this.jsiiGet("httpRedirectCode", java.lang.String.class);
        }

        /**
         * Protocol to use when redirecting requests.
         * 
         * Default: - The protocol used in the original request.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.s3.RedirectProtocol getProtocol() {
            return this.jsiiGet("protocol", software.amazon.awscdk.services.s3.RedirectProtocol.class);
        }

        /**
         * Specifies the object key prefix to use in the redirect request.
         * 
         * Default: - The key will not be replaced
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.s3.ReplaceKey getReplaceKey() {
            return this.jsiiGet("replaceKey", software.amazon.awscdk.services.s3.ReplaceKey.class);
        }
    }
}
