package software.amazon.awscdk.services.s3;

/**
 * Specifies a cross-origin access rule for an Amazon S3 bucket.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-05-20T13:23:13.976Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CorsRule")
@software.amazon.jsii.Jsii.Proxy(CorsRule.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CorsRule extends software.amazon.jsii.JsiiSerializable {

    /**
     * An HTTP method that you allow the origin to execute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.s3.HttpMethods> getAllowedMethods();

    /**
     * One or more origins you want customers to be able to access the bucket from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAllowedOrigins();

    /**
     * Headers that are specified in the Access-Control-Request-Headers header.
     * <p>
     * Default: - No headers allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedHeaders() {
        return null;
    }

    /**
     * One or more headers in the response that you want customers to be able to access from their applications.
     * <p>
     * Default: - No headers exposed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExposedHeaders() {
        return null;
    }

    /**
     * A unique identifier for this rule.
     * <p>
     * Default: - No id specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getId() {
        return null;
    }

    /**
     * The time in seconds that your browser is to cache the preflight response for the specified resource.
     * <p>
     * Default: - No caching.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxAge() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CorsRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CorsRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.util.List<software.amazon.awscdk.services.s3.HttpMethods> allowedMethods;
        private java.util.List<java.lang.String> allowedOrigins;
        private java.util.List<java.lang.String> allowedHeaders;
        private java.util.List<java.lang.String> exposedHeaders;
        private java.lang.String id;
        private java.lang.Number maxAge;

        /**
         * Sets the value of {@link CorsRule#getAllowedMethods}
         * @param allowedMethods An HTTP method that you allow the origin to execute. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedMethods(java.util.List<software.amazon.awscdk.services.s3.HttpMethods> allowedMethods) {
            this.allowedMethods = allowedMethods;
            return this;
        }

        /**
         * Sets the value of {@link CorsRule#getAllowedOrigins}
         * @param allowedOrigins One or more origins you want customers to be able to access the bucket from. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedOrigins(java.util.List<java.lang.String> allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
            return this;
        }

        /**
         * Sets the value of {@link CorsRule#getAllowedHeaders}
         * @param allowedHeaders Headers that are specified in the Access-Control-Request-Headers header.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedHeaders(java.util.List<java.lang.String> allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
            return this;
        }

        /**
         * Sets the value of {@link CorsRule#getExposedHeaders}
         * @param exposedHeaders One or more headers in the response that you want customers to be able to access from their applications.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exposedHeaders(java.util.List<java.lang.String> exposedHeaders) {
            this.exposedHeaders = exposedHeaders;
            return this;
        }

        /**
         * Sets the value of {@link CorsRule#getId}
         * @param id A unique identifier for this rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link CorsRule#getMaxAge}
         * @param maxAge The time in seconds that your browser is to cache the preflight response for the specified resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAge(java.lang.Number maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CorsRule}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public CorsRule build() {
            return new Jsii$Proxy(allowedMethods, allowedOrigins, allowedHeaders, exposedHeaders, id, maxAge);
        }
    }

    /**
     * An implementation for {@link CorsRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CorsRule {
        private final java.util.List<software.amazon.awscdk.services.s3.HttpMethods> allowedMethods;
        private final java.util.List<java.lang.String> allowedOrigins;
        private final java.util.List<java.lang.String> allowedHeaders;
        private final java.util.List<java.lang.String> exposedHeaders;
        private final java.lang.String id;
        private final java.lang.Number maxAge;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowedMethods = this.jsiiGet("allowedMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.HttpMethods.class)));
            this.allowedOrigins = this.jsiiGet("allowedOrigins", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.allowedHeaders = this.jsiiGet("allowedHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.exposedHeaders = this.jsiiGet("exposedHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.id = this.jsiiGet("id", java.lang.String.class);
            this.maxAge = this.jsiiGet("maxAge", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<software.amazon.awscdk.services.s3.HttpMethods> allowedMethods, final java.util.List<java.lang.String> allowedOrigins, final java.util.List<java.lang.String> allowedHeaders, final java.util.List<java.lang.String> exposedHeaders, final java.lang.String id, final java.lang.Number maxAge) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowedMethods = java.util.Objects.requireNonNull(allowedMethods, "allowedMethods is required");
            this.allowedOrigins = java.util.Objects.requireNonNull(allowedOrigins, "allowedOrigins is required");
            this.allowedHeaders = allowedHeaders;
            this.exposedHeaders = exposedHeaders;
            this.id = id;
            this.maxAge = maxAge;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.s3.HttpMethods> getAllowedMethods() {
            return this.allowedMethods;
        }

        @Override
        public java.util.List<java.lang.String> getAllowedOrigins() {
            return this.allowedOrigins;
        }

        @Override
        public java.util.List<java.lang.String> getAllowedHeaders() {
            return this.allowedHeaders;
        }

        @Override
        public java.util.List<java.lang.String> getExposedHeaders() {
            return this.exposedHeaders;
        }

        @Override
        public java.lang.String getId() {
            return this.id;
        }

        @Override
        public java.lang.Number getMaxAge() {
            return this.maxAge;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
            data.set("allowedOrigins", om.valueToTree(this.getAllowedOrigins()));
            if (this.getAllowedHeaders() != null) {
                data.set("allowedHeaders", om.valueToTree(this.getAllowedHeaders()));
            }
            if (this.getExposedHeaders() != null) {
                data.set("exposedHeaders", om.valueToTree(this.getExposedHeaders()));
            }
            if (this.getId() != null) {
                data.set("id", om.valueToTree(this.getId()));
            }
            if (this.getMaxAge() != null) {
                data.set("maxAge", om.valueToTree(this.getMaxAge()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CorsRule"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CorsRule.Jsii$Proxy that = (CorsRule.Jsii$Proxy) o;

            if (!allowedMethods.equals(that.allowedMethods)) return false;
            if (!allowedOrigins.equals(that.allowedOrigins)) return false;
            if (this.allowedHeaders != null ? !this.allowedHeaders.equals(that.allowedHeaders) : that.allowedHeaders != null) return false;
            if (this.exposedHeaders != null ? !this.exposedHeaders.equals(that.exposedHeaders) : that.exposedHeaders != null) return false;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
            return this.maxAge != null ? this.maxAge.equals(that.maxAge) : that.maxAge == null;
        }

        @Override
        public int hashCode() {
            int result = this.allowedMethods.hashCode();
            result = 31 * result + (this.allowedOrigins.hashCode());
            result = 31 * result + (this.allowedHeaders != null ? this.allowedHeaders.hashCode() : 0);
            result = 31 * result + (this.exposedHeaders != null ? this.exposedHeaders.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.maxAge != null ? this.maxAge.hashCode() : 0);
            return result;
        }
    }
}
