package software.amazon.awscdk.services.s3;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-06-30T10:27:02.431Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.BucketProps")
@software.amazon.jsii.Jsii.Proxy(BucketProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BucketProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies a canned ACL that grants predefined permissions to the bucket.
     * <p>
     * Default: BucketAccessControl.PRIVATE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketAccessControl getAccessControl() {
        return null;
    }

    /**
     * The block public access configuration of this bucket.
     * <p>
     * Default: false New buckets and objects don't allow public access, but users can modify bucket
     * policies or object permissions to allow public access.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BlockPublicAccess getBlockPublicAccess() {
        return null;
    }

    /**
     * Physical name of this bucket.
     * <p>
     * Default: - Assigned by CloudFormation (recommended).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBucketName() {
        return null;
    }

    /**
     * The CORS configuration of this bucket.
     * <p>
     * Default: - No CORS configuration.
     * <p>
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.CorsRule> getCors() {
        return null;
    }

    /**
     * The kind of server-side encryption to apply to this bucket.
     * <p>
     * If you choose KMS, you can specify a KMS key via <code>encryptionKey</code>. If
     * encryption key is not specified, a key will automatically be created.
     * <p>
     * Default: - `Kms` if `encryptionKey` is specified, or `Unencrypted` otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketEncryption getEncryption() {
        return null;
    }

    /**
     * External KMS key to use for bucket encryption.
     * <p>
     * The 'encryption' property must be either not specified or set to "Kms".
     * An error will be emitted if encryption is set to "Unencrypted" or
     * "Managed".
     * <p>
     * Default: - If encryption is set to "Kms" and this property is undefined,
     * a new KMS key will be created and associated with this bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * Rules that define how Amazon S3 manages objects during their lifetime.
     * <p>
     * Default: - No lifecycle rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> getLifecycleRules() {
        return null;
    }

    /**
     * The metrics configuration of this bucket.
     * <p>
     * Default: - No metrics configuration.
     * <p>
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.BucketMetrics> getMetrics() {
        return null;
    }

    /**
     * Grants public read access to all objects in the bucket.
     * <p>
     * Similar to calling <code>bucket.grantPublicAccess()</code>
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPublicReadAccess() {
        return null;
    }

    /**
     * Policy to apply when the bucket is removed from this stack.
     * <p>
     * Default: - The bucket will be orphaned.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * Destination bucket for the server access logs.
     * <p>
     * Default: - If "serverAccessLogsPrefix" undefined - access logs disabled, otherwise - log to current bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getServerAccessLogsBucket() {
        return null;
    }

    /**
     * Optional log file prefix to use for the bucket's access logs.
     * <p>
     * If defined without "serverAccessLogsBucket", enables access logs to current bucket with this prefix.
     * <p>
     * Default: - No log file prefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServerAccessLogsPrefix() {
        return null;
    }

    /**
     * Whether this bucket should have versioning turned on or not.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getVersioned() {
        return null;
    }

    /**
     * The name of the error document (e.g. "404.html") for the website. `websiteIndexDocument` must also be set if this is set.
     * <p>
     * Default: - No error document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWebsiteErrorDocument() {
        return null;
    }

    /**
     * The name of the index document (e.g. "index.html") for the website. Enables static website hosting for this bucket.
     * <p>
     * Default: - No index document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWebsiteIndexDocument() {
        return null;
    }

    /**
     * Specifies the redirect behavior of all requests to a website endpoint of a bucket.
     * <p>
     * If you specify this property, you can't specify "websiteIndexDocument", "websiteErrorDocument" nor , "websiteRoutingRules".
     * <p>
     * Default: - No redirection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.RedirectTarget getWebsiteRedirect() {
        return null;
    }

    /**
     * Rules that define when a redirect is applied and the redirect behavior.
     * <p>
     * Default: - No redirection rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.RoutingRule> getWebsiteRoutingRules() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BucketProps> {
        private software.amazon.awscdk.services.s3.BucketAccessControl accessControl;
        private software.amazon.awscdk.services.s3.BlockPublicAccess blockPublicAccess;
        private java.lang.String bucketName;
        private java.util.List<software.amazon.awscdk.services.s3.CorsRule> cors;
        private software.amazon.awscdk.services.s3.BucketEncryption encryption;
        private software.amazon.awscdk.services.kms.IKey encryptionKey;
        private java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> lifecycleRules;
        private java.util.List<software.amazon.awscdk.services.s3.BucketMetrics> metrics;
        private java.lang.Boolean publicReadAccess;
        private software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private software.amazon.awscdk.services.s3.IBucket serverAccessLogsBucket;
        private java.lang.String serverAccessLogsPrefix;
        private java.lang.Boolean versioned;
        private java.lang.String websiteErrorDocument;
        private java.lang.String websiteIndexDocument;
        private software.amazon.awscdk.services.s3.RedirectTarget websiteRedirect;
        private java.util.List<software.amazon.awscdk.services.s3.RoutingRule> websiteRoutingRules;

        /**
         * Sets the value of {@link BucketProps#getAccessControl}
         * @param accessControl Specifies a canned ACL that grants predefined permissions to the bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessControl(software.amazon.awscdk.services.s3.BucketAccessControl accessControl) {
            this.accessControl = accessControl;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getBlockPublicAccess}
         * @param blockPublicAccess The block public access configuration of this bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockPublicAccess(software.amazon.awscdk.services.s3.BlockPublicAccess blockPublicAccess) {
            this.blockPublicAccess = blockPublicAccess;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getBucketName}
         * @param bucketName Physical name of this bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(java.lang.String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getCors}
         * @param cors The CORS configuration of this bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cors(java.util.List<software.amazon.awscdk.services.s3.CorsRule> cors) {
            this.cors = cors;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getEncryption}
         * @param encryption The kind of server-side encryption to apply to this bucket.
         *                   If you choose KMS, you can specify a KMS key via <code>encryptionKey</code>. If
         *                   encryption key is not specified, a key will automatically be created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(software.amazon.awscdk.services.s3.BucketEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getEncryptionKey}
         * @param encryptionKey External KMS key to use for bucket encryption.
         *                      The 'encryption' property must be either not specified or set to "Kms".
         *                      An error will be emitted if encryption is set to "Unencrypted" or
         *                      "Managed".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getLifecycleRules}
         * @param lifecycleRules Rules that define how Amazon S3 manages objects during their lifetime.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleRules(java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> lifecycleRules) {
            this.lifecycleRules = lifecycleRules;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getMetrics}
         * @param metrics The metrics configuration of this bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metrics(java.util.List<software.amazon.awscdk.services.s3.BucketMetrics> metrics) {
            this.metrics = metrics;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getPublicReadAccess}
         * @param publicReadAccess Grants public read access to all objects in the bucket.
         *                         Similar to calling <code>bucket.grantPublicAccess()</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicReadAccess(java.lang.Boolean publicReadAccess) {
            this.publicReadAccess = publicReadAccess;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getRemovalPolicy}
         * @param removalPolicy Policy to apply when the bucket is removed from this stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getServerAccessLogsBucket}
         * @param serverAccessLogsBucket Destination bucket for the server access logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverAccessLogsBucket(software.amazon.awscdk.services.s3.IBucket serverAccessLogsBucket) {
            this.serverAccessLogsBucket = serverAccessLogsBucket;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getServerAccessLogsPrefix}
         * @param serverAccessLogsPrefix Optional log file prefix to use for the bucket's access logs.
         *                               If defined without "serverAccessLogsBucket", enables access logs to current bucket with this prefix.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverAccessLogsPrefix(java.lang.String serverAccessLogsPrefix) {
            this.serverAccessLogsPrefix = serverAccessLogsPrefix;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getVersioned}
         * @param versioned Whether this bucket should have versioning turned on or not.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versioned(java.lang.Boolean versioned) {
            this.versioned = versioned;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getWebsiteErrorDocument}
         * @param websiteErrorDocument The name of the error document (e.g. "404.html") for the website. `websiteIndexDocument` must also be set if this is set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteErrorDocument(java.lang.String websiteErrorDocument) {
            this.websiteErrorDocument = websiteErrorDocument;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getWebsiteIndexDocument}
         * @param websiteIndexDocument The name of the index document (e.g. "index.html") for the website. Enables static website hosting for this bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteIndexDocument(java.lang.String websiteIndexDocument) {
            this.websiteIndexDocument = websiteIndexDocument;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getWebsiteRedirect}
         * @param websiteRedirect Specifies the redirect behavior of all requests to a website endpoint of a bucket.
         *                        If you specify this property, you can't specify "websiteIndexDocument", "websiteErrorDocument" nor , "websiteRoutingRules".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteRedirect(software.amazon.awscdk.services.s3.RedirectTarget websiteRedirect) {
            this.websiteRedirect = websiteRedirect;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getWebsiteRoutingRules}
         * @param websiteRoutingRules Rules that define when a redirect is applied and the redirect behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteRoutingRules(java.util.List<software.amazon.awscdk.services.s3.RoutingRule> websiteRoutingRules) {
            this.websiteRoutingRules = websiteRoutingRules;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BucketProps build() {
            return new Jsii$Proxy(accessControl, blockPublicAccess, bucketName, cors, encryption, encryptionKey, lifecycleRules, metrics, publicReadAccess, removalPolicy, serverAccessLogsBucket, serverAccessLogsPrefix, versioned, websiteErrorDocument, websiteIndexDocument, websiteRedirect, websiteRoutingRules);
        }
    }

    /**
     * An implementation for {@link BucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BucketProps {
        private final software.amazon.awscdk.services.s3.BucketAccessControl accessControl;
        private final software.amazon.awscdk.services.s3.BlockPublicAccess blockPublicAccess;
        private final java.lang.String bucketName;
        private final java.util.List<software.amazon.awscdk.services.s3.CorsRule> cors;
        private final software.amazon.awscdk.services.s3.BucketEncryption encryption;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> lifecycleRules;
        private final java.util.List<software.amazon.awscdk.services.s3.BucketMetrics> metrics;
        private final java.lang.Boolean publicReadAccess;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.services.s3.IBucket serverAccessLogsBucket;
        private final java.lang.String serverAccessLogsPrefix;
        private final java.lang.Boolean versioned;
        private final java.lang.String websiteErrorDocument;
        private final java.lang.String websiteIndexDocument;
        private final software.amazon.awscdk.services.s3.RedirectTarget websiteRedirect;
        private final java.util.List<software.amazon.awscdk.services.s3.RoutingRule> websiteRoutingRules;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessControl = this.jsiiGet("accessControl", software.amazon.awscdk.services.s3.BucketAccessControl.class);
            this.blockPublicAccess = this.jsiiGet("blockPublicAccess", software.amazon.awscdk.services.s3.BlockPublicAccess.class);
            this.bucketName = this.jsiiGet("bucketName", java.lang.String.class);
            this.cors = this.jsiiGet("cors", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.CorsRule.class)));
            this.encryption = this.jsiiGet("encryption", software.amazon.awscdk.services.s3.BucketEncryption.class);
            this.encryptionKey = this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IKey.class);
            this.lifecycleRules = this.jsiiGet("lifecycleRules", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.LifecycleRule.class)));
            this.metrics = this.jsiiGet("metrics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.BucketMetrics.class)));
            this.publicReadAccess = this.jsiiGet("publicReadAccess", java.lang.Boolean.class);
            this.removalPolicy = this.jsiiGet("removalPolicy", software.amazon.awscdk.core.RemovalPolicy.class);
            this.serverAccessLogsBucket = this.jsiiGet("serverAccessLogsBucket", software.amazon.awscdk.services.s3.IBucket.class);
            this.serverAccessLogsPrefix = this.jsiiGet("serverAccessLogsPrefix", java.lang.String.class);
            this.versioned = this.jsiiGet("versioned", java.lang.Boolean.class);
            this.websiteErrorDocument = this.jsiiGet("websiteErrorDocument", java.lang.String.class);
            this.websiteIndexDocument = this.jsiiGet("websiteIndexDocument", java.lang.String.class);
            this.websiteRedirect = this.jsiiGet("websiteRedirect", software.amazon.awscdk.services.s3.RedirectTarget.class);
            this.websiteRoutingRules = this.jsiiGet("websiteRoutingRules", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.RoutingRule.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.s3.BucketAccessControl accessControl, final software.amazon.awscdk.services.s3.BlockPublicAccess blockPublicAccess, final java.lang.String bucketName, final java.util.List<software.amazon.awscdk.services.s3.CorsRule> cors, final software.amazon.awscdk.services.s3.BucketEncryption encryption, final software.amazon.awscdk.services.kms.IKey encryptionKey, final java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> lifecycleRules, final java.util.List<software.amazon.awscdk.services.s3.BucketMetrics> metrics, final java.lang.Boolean publicReadAccess, final software.amazon.awscdk.core.RemovalPolicy removalPolicy, final software.amazon.awscdk.services.s3.IBucket serverAccessLogsBucket, final java.lang.String serverAccessLogsPrefix, final java.lang.Boolean versioned, final java.lang.String websiteErrorDocument, final java.lang.String websiteIndexDocument, final software.amazon.awscdk.services.s3.RedirectTarget websiteRedirect, final java.util.List<software.amazon.awscdk.services.s3.RoutingRule> websiteRoutingRules) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessControl = accessControl;
            this.blockPublicAccess = blockPublicAccess;
            this.bucketName = bucketName;
            this.cors = cors;
            this.encryption = encryption;
            this.encryptionKey = encryptionKey;
            this.lifecycleRules = lifecycleRules;
            this.metrics = metrics;
            this.publicReadAccess = publicReadAccess;
            this.removalPolicy = removalPolicy;
            this.serverAccessLogsBucket = serverAccessLogsBucket;
            this.serverAccessLogsPrefix = serverAccessLogsPrefix;
            this.versioned = versioned;
            this.websiteErrorDocument = websiteErrorDocument;
            this.websiteIndexDocument = websiteIndexDocument;
            this.websiteRedirect = websiteRedirect;
            this.websiteRoutingRules = websiteRoutingRules;
        }

        @Override
        public software.amazon.awscdk.services.s3.BucketAccessControl getAccessControl() {
            return this.accessControl;
        }

        @Override
        public software.amazon.awscdk.services.s3.BlockPublicAccess getBlockPublicAccess() {
            return this.blockPublicAccess;
        }

        @Override
        public java.lang.String getBucketName() {
            return this.bucketName;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.s3.CorsRule> getCors() {
            return this.cors;
        }

        @Override
        public software.amazon.awscdk.services.s3.BucketEncryption getEncryption() {
            return this.encryption;
        }

        @Override
        public software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> getLifecycleRules() {
            return this.lifecycleRules;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.s3.BucketMetrics> getMetrics() {
            return this.metrics;
        }

        @Override
        public java.lang.Boolean getPublicReadAccess() {
            return this.publicReadAccess;
        }

        @Override
        public software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public software.amazon.awscdk.services.s3.IBucket getServerAccessLogsBucket() {
            return this.serverAccessLogsBucket;
        }

        @Override
        public java.lang.String getServerAccessLogsPrefix() {
            return this.serverAccessLogsPrefix;
        }

        @Override
        public java.lang.Boolean getVersioned() {
            return this.versioned;
        }

        @Override
        public java.lang.String getWebsiteErrorDocument() {
            return this.websiteErrorDocument;
        }

        @Override
        public java.lang.String getWebsiteIndexDocument() {
            return this.websiteIndexDocument;
        }

        @Override
        public software.amazon.awscdk.services.s3.RedirectTarget getWebsiteRedirect() {
            return this.websiteRedirect;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.s3.RoutingRule> getWebsiteRoutingRules() {
            return this.websiteRoutingRules;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccessControl() != null) {
                data.set("accessControl", om.valueToTree(this.getAccessControl()));
            }
            if (this.getBlockPublicAccess() != null) {
                data.set("blockPublicAccess", om.valueToTree(this.getBlockPublicAccess()));
            }
            if (this.getBucketName() != null) {
                data.set("bucketName", om.valueToTree(this.getBucketName()));
            }
            if (this.getCors() != null) {
                data.set("cors", om.valueToTree(this.getCors()));
            }
            if (this.getEncryption() != null) {
                data.set("encryption", om.valueToTree(this.getEncryption()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getLifecycleRules() != null) {
                data.set("lifecycleRules", om.valueToTree(this.getLifecycleRules()));
            }
            if (this.getMetrics() != null) {
                data.set("metrics", om.valueToTree(this.getMetrics()));
            }
            if (this.getPublicReadAccess() != null) {
                data.set("publicReadAccess", om.valueToTree(this.getPublicReadAccess()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getServerAccessLogsBucket() != null) {
                data.set("serverAccessLogsBucket", om.valueToTree(this.getServerAccessLogsBucket()));
            }
            if (this.getServerAccessLogsPrefix() != null) {
                data.set("serverAccessLogsPrefix", om.valueToTree(this.getServerAccessLogsPrefix()));
            }
            if (this.getVersioned() != null) {
                data.set("versioned", om.valueToTree(this.getVersioned()));
            }
            if (this.getWebsiteErrorDocument() != null) {
                data.set("websiteErrorDocument", om.valueToTree(this.getWebsiteErrorDocument()));
            }
            if (this.getWebsiteIndexDocument() != null) {
                data.set("websiteIndexDocument", om.valueToTree(this.getWebsiteIndexDocument()));
            }
            if (this.getWebsiteRedirect() != null) {
                data.set("websiteRedirect", om.valueToTree(this.getWebsiteRedirect()));
            }
            if (this.getWebsiteRoutingRules() != null) {
                data.set("websiteRoutingRules", om.valueToTree(this.getWebsiteRoutingRules()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.BucketProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BucketProps.Jsii$Proxy that = (BucketProps.Jsii$Proxy) o;

            if (this.accessControl != null ? !this.accessControl.equals(that.accessControl) : that.accessControl != null) return false;
            if (this.blockPublicAccess != null ? !this.blockPublicAccess.equals(that.blockPublicAccess) : that.blockPublicAccess != null) return false;
            if (this.bucketName != null ? !this.bucketName.equals(that.bucketName) : that.bucketName != null) return false;
            if (this.cors != null ? !this.cors.equals(that.cors) : that.cors != null) return false;
            if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.lifecycleRules != null ? !this.lifecycleRules.equals(that.lifecycleRules) : that.lifecycleRules != null) return false;
            if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) return false;
            if (this.publicReadAccess != null ? !this.publicReadAccess.equals(that.publicReadAccess) : that.publicReadAccess != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.serverAccessLogsBucket != null ? !this.serverAccessLogsBucket.equals(that.serverAccessLogsBucket) : that.serverAccessLogsBucket != null) return false;
            if (this.serverAccessLogsPrefix != null ? !this.serverAccessLogsPrefix.equals(that.serverAccessLogsPrefix) : that.serverAccessLogsPrefix != null) return false;
            if (this.versioned != null ? !this.versioned.equals(that.versioned) : that.versioned != null) return false;
            if (this.websiteErrorDocument != null ? !this.websiteErrorDocument.equals(that.websiteErrorDocument) : that.websiteErrorDocument != null) return false;
            if (this.websiteIndexDocument != null ? !this.websiteIndexDocument.equals(that.websiteIndexDocument) : that.websiteIndexDocument != null) return false;
            if (this.websiteRedirect != null ? !this.websiteRedirect.equals(that.websiteRedirect) : that.websiteRedirect != null) return false;
            return this.websiteRoutingRules != null ? this.websiteRoutingRules.equals(that.websiteRoutingRules) : that.websiteRoutingRules == null;
        }

        @Override
        public int hashCode() {
            int result = this.accessControl != null ? this.accessControl.hashCode() : 0;
            result = 31 * result + (this.blockPublicAccess != null ? this.blockPublicAccess.hashCode() : 0);
            result = 31 * result + (this.bucketName != null ? this.bucketName.hashCode() : 0);
            result = 31 * result + (this.cors != null ? this.cors.hashCode() : 0);
            result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.lifecycleRules != null ? this.lifecycleRules.hashCode() : 0);
            result = 31 * result + (this.metrics != null ? this.metrics.hashCode() : 0);
            result = 31 * result + (this.publicReadAccess != null ? this.publicReadAccess.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.serverAccessLogsBucket != null ? this.serverAccessLogsBucket.hashCode() : 0);
            result = 31 * result + (this.serverAccessLogsPrefix != null ? this.serverAccessLogsPrefix.hashCode() : 0);
            result = 31 * result + (this.versioned != null ? this.versioned.hashCode() : 0);
            result = 31 * result + (this.websiteErrorDocument != null ? this.websiteErrorDocument.hashCode() : 0);
            result = 31 * result + (this.websiteIndexDocument != null ? this.websiteIndexDocument.hashCode() : 0);
            result = 31 * result + (this.websiteRedirect != null ? this.websiteRedirect.hashCode() : 0);
            result = 31 * result + (this.websiteRoutingRules != null ? this.websiteRoutingRules.hashCode() : 0);
            return result;
        }
    }
}
