package software.amazon.awscdk.services.s3;

/**
 * Specifies a redirect behavior of all requests to a website endpoint of a bucket.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-06-30T10:27:06.507Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.RedirectTarget")
@software.amazon.jsii.Jsii.Proxy(RedirectTarget.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RedirectTarget extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name of the host where requests are redirected.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHostName();

    /**
     * Protocol to use when redirecting requests.
     * <p>
     * Default: - The protocol used in the original request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.RedirectProtocol getProtocol() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RedirectTarget}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RedirectTarget}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RedirectTarget> {
        private java.lang.String hostName;
        private software.amazon.awscdk.services.s3.RedirectProtocol protocol;

        /**
         * Sets the value of {@link RedirectTarget#getHostName}
         * @param hostName Name of the host where requests are redirected. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostName(java.lang.String hostName) {
            this.hostName = hostName;
            return this;
        }

        /**
         * Sets the value of {@link RedirectTarget#getProtocol}
         * @param protocol Protocol to use when redirecting requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.s3.RedirectProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RedirectTarget}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RedirectTarget build() {
            return new Jsii$Proxy(hostName, protocol);
        }
    }

    /**
     * An implementation for {@link RedirectTarget}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedirectTarget {
        private final java.lang.String hostName;
        private final software.amazon.awscdk.services.s3.RedirectProtocol protocol;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hostName = this.jsiiGet("hostName", java.lang.String.class);
            this.protocol = this.jsiiGet("protocol", software.amazon.awscdk.services.s3.RedirectProtocol.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String hostName, final software.amazon.awscdk.services.s3.RedirectProtocol protocol) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostName = java.util.Objects.requireNonNull(hostName, "hostName is required");
            this.protocol = protocol;
        }

        @Override
        public java.lang.String getHostName() {
            return this.hostName;
        }

        @Override
        public software.amazon.awscdk.services.s3.RedirectProtocol getProtocol() {
            return this.protocol;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("hostName", om.valueToTree(this.getHostName()));
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.RedirectTarget"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RedirectTarget.Jsii$Proxy that = (RedirectTarget.Jsii$Proxy) o;

            if (!hostName.equals(that.hostName)) return false;
            return this.protocol != null ? this.protocol.equals(that.protocol) : that.protocol == null;
        }

        @Override
        public int hashCode() {
            int result = this.hostName.hashCode();
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            return result;
        }
    }
}
