package software.amazon.awscdk.services.s3;

/**
 * A CloudFormation `AWS::S3::Bucket`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-07-02T12:03:12.047Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket")
public class CfnBucket extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnBucket(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnBucket(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.s3.CfnBucket.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::S3::Bucket`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucketProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::S3::Bucket`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * A factory method that creates a new instance of this class from an object containing the CloudFormation properties of this resource.
     * <p>
     * Used in the &#64;aws-cdk/cloudformation-include module.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param resourceAttributes This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.CfnBucket fromCloudFormation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.Object resourceAttributes, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FromCloudFormationOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.CfnBucket.class, "fromCloudFormation", software.amazon.awscdk.services.s3.CfnBucket.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), resourceAttributes, java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return this.jsiiGet("attrArn", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomainName() {
        return this.jsiiGet("attrDomainName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDualStackDomainName() {
        return this.jsiiGet("attrDualStackDomainName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRegionalDomainName() {
        return this.jsiiGet("attrRegionalDomainName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWebsiteUrl() {
        return this.jsiiGet("attrWebsiteUrl", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::S3::Bucket.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::S3::Bucket.AccelerateConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accelerateconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAccelerateConfiguration() {
        return this.jsiiGet("accelerateConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.AccelerateConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accelerateconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccelerateConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.AccelerateConfigurationProperty value) {
        this.jsiiSet("accelerateConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.AccelerateConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accelerateconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccelerateConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("accelerateConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.AccessControl`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accesscontrol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAccessControl() {
        return this.jsiiGet("accessControl", java.lang.String.class);
    }

    /**
     * `AWS::S3::Bucket.AccessControl`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accesscontrol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessControl(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("accessControl", value);
    }

    /**
     * `AWS::S3::Bucket.AnalyticsConfigurations`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-analyticsconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAnalyticsConfigurations() {
        return this.jsiiGet("analyticsConfigurations", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.AnalyticsConfigurations`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-analyticsconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnalyticsConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("analyticsConfigurations", value);
    }

    /**
     * `AWS::S3::Bucket.AnalyticsConfigurations`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-analyticsconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnalyticsConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("analyticsConfigurations", value);
    }

    /**
     * `AWS::S3::Bucket.BucketEncryption`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-bucketencryption
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBucketEncryption() {
        return this.jsiiGet("bucketEncryption", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.BucketEncryption`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-bucketencryption
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBucketEncryption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("bucketEncryption", value);
    }

    /**
     * `AWS::S3::Bucket.BucketEncryption`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-bucketencryption
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBucketEncryption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.BucketEncryptionProperty value) {
        this.jsiiSet("bucketEncryption", value);
    }

    /**
     * `AWS::S3::Bucket.BucketName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBucketName() {
        return this.jsiiGet("bucketName", java.lang.String.class);
    }

    /**
     * `AWS::S3::Bucket.BucketName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBucketName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("bucketName", value);
    }

    /**
     * `AWS::S3::Bucket.CorsConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-crossoriginconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCorsConfiguration() {
        return this.jsiiGet("corsConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.CorsConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-crossoriginconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCorsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("corsConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.CorsConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-crossoriginconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCorsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.CorsConfigurationProperty value) {
        this.jsiiSet("corsConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.InventoryConfigurations`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-inventoryconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInventoryConfigurations() {
        return this.jsiiGet("inventoryConfigurations", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.InventoryConfigurations`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-inventoryconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInventoryConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("inventoryConfigurations", value);
    }

    /**
     * `AWS::S3::Bucket.InventoryConfigurations`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-inventoryconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInventoryConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("inventoryConfigurations", value);
    }

    /**
     * `AWS::S3::Bucket.LifecycleConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-lifecycleconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLifecycleConfiguration() {
        return this.jsiiGet("lifecycleConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.LifecycleConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-lifecycleconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLifecycleConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("lifecycleConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.LifecycleConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-lifecycleconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLifecycleConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.LifecycleConfigurationProperty value) {
        this.jsiiSet("lifecycleConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.LoggingConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-loggingconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLoggingConfiguration() {
        return this.jsiiGet("loggingConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.LoggingConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-loggingconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("loggingConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.LoggingConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-loggingconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.LoggingConfigurationProperty value) {
        this.jsiiSet("loggingConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.MetricsConfigurations`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-metricsconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMetricsConfigurations() {
        return this.jsiiGet("metricsConfigurations", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.MetricsConfigurations`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-metricsconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricsConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("metricsConfigurations", value);
    }

    /**
     * `AWS::S3::Bucket.MetricsConfigurations`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-metricsconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricsConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("metricsConfigurations", value);
    }

    /**
     * `AWS::S3::Bucket.NotificationConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-notification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNotificationConfiguration() {
        return this.jsiiGet("notificationConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.NotificationConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-notification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("notificationConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.NotificationConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-notification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.NotificationConfigurationProperty value) {
        this.jsiiSet("notificationConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.ObjectLockConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getObjectLockConfiguration() {
        return this.jsiiGet("objectLockConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.ObjectLockConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObjectLockConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("objectLockConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.ObjectLockConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObjectLockConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.ObjectLockConfigurationProperty value) {
        this.jsiiSet("objectLockConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.ObjectLockEnabled`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getObjectLockEnabled() {
        return this.jsiiGet("objectLockEnabled", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.ObjectLockEnabled`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObjectLockEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        this.jsiiSet("objectLockEnabled", value);
    }

    /**
     * `AWS::S3::Bucket.ObjectLockEnabled`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObjectLockEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("objectLockEnabled", value);
    }

    /**
     * `AWS::S3::Bucket.PublicAccessBlockConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-publicaccessblockconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPublicAccessBlockConfiguration() {
        return this.jsiiGet("publicAccessBlockConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.PublicAccessBlockConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-publicaccessblockconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPublicAccessBlockConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("publicAccessBlockConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.PublicAccessBlockConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-publicaccessblockconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPublicAccessBlockConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.PublicAccessBlockConfigurationProperty value) {
        this.jsiiSet("publicAccessBlockConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.ReplicationConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-replicationconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getReplicationConfiguration() {
        return this.jsiiGet("replicationConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.ReplicationConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-replicationconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("replicationConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.ReplicationConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-replicationconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.ReplicationConfigurationProperty value) {
        this.jsiiSet("replicationConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.VersioningConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-versioning
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVersioningConfiguration() {
        return this.jsiiGet("versioningConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.VersioningConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-versioning
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersioningConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("versioningConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.VersioningConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-versioning
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersioningConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.VersioningConfigurationProperty value) {
        this.jsiiSet("versioningConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.WebsiteConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-websiteconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWebsiteConfiguration() {
        return this.jsiiGet("websiteConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.WebsiteConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-websiteconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWebsiteConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("websiteConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.WebsiteConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-websiteconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWebsiteConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnBucket.WebsiteConfigurationProperty value) {
        this.jsiiSet("websiteConfiguration", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.AbortIncompleteMultipartUploadProperty")
    @software.amazon.jsii.Jsii.Proxy(AbortIncompleteMultipartUploadProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AbortIncompleteMultipartUploadProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDaysAfterInitiation();

        /**
         * @return a {@link Builder} of {@link AbortIncompleteMultipartUploadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AbortIncompleteMultipartUploadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AbortIncompleteMultipartUploadProperty> {
            private java.lang.Number daysAfterInitiation;

            /**
             * Sets the value of {@link AbortIncompleteMultipartUploadProperty#getDaysAfterInitiation}
             * @param daysAfterInitiation `CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder daysAfterInitiation(java.lang.Number daysAfterInitiation) {
                this.daysAfterInitiation = daysAfterInitiation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AbortIncompleteMultipartUploadProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AbortIncompleteMultipartUploadProperty build() {
                return new Jsii$Proxy(daysAfterInitiation);
            }
        }

        /**
         * An implementation for {@link AbortIncompleteMultipartUploadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AbortIncompleteMultipartUploadProperty {
            private final java.lang.Number daysAfterInitiation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.daysAfterInitiation = this.jsiiGet("daysAfterInitiation", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number daysAfterInitiation) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.daysAfterInitiation = java.util.Objects.requireNonNull(daysAfterInitiation, "daysAfterInitiation is required");
            }

            @Override
            public java.lang.Number getDaysAfterInitiation() {
                return this.daysAfterInitiation;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("daysAfterInitiation", om.valueToTree(this.getDaysAfterInitiation()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.AbortIncompleteMultipartUploadProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AbortIncompleteMultipartUploadProperty.Jsii$Proxy that = (AbortIncompleteMultipartUploadProperty.Jsii$Proxy) o;

                return this.daysAfterInitiation.equals(that.daysAfterInitiation);
            }

            @Override
            public int hashCode() {
                int result = this.daysAfterInitiation.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.AccelerateConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AccelerateConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccelerateConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.AccelerateConfigurationProperty.AccelerationStatus`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAccelerationStatus();

        /**
         * @return a {@link Builder} of {@link AccelerateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccelerateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccelerateConfigurationProperty> {
            private java.lang.String accelerationStatus;

            /**
             * Sets the value of {@link AccelerateConfigurationProperty#getAccelerationStatus}
             * @param accelerationStatus `CfnBucket.AccelerateConfigurationProperty.AccelerationStatus`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accelerationStatus(java.lang.String accelerationStatus) {
                this.accelerationStatus = accelerationStatus;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccelerateConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccelerateConfigurationProperty build() {
                return new Jsii$Proxy(accelerationStatus);
            }
        }

        /**
         * An implementation for {@link AccelerateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccelerateConfigurationProperty {
            private final java.lang.String accelerationStatus;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accelerationStatus = this.jsiiGet("accelerationStatus", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String accelerationStatus) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accelerationStatus = java.util.Objects.requireNonNull(accelerationStatus, "accelerationStatus is required");
            }

            @Override
            public java.lang.String getAccelerationStatus() {
                return this.accelerationStatus;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("accelerationStatus", om.valueToTree(this.getAccelerationStatus()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.AccelerateConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccelerateConfigurationProperty.Jsii$Proxy that = (AccelerateConfigurationProperty.Jsii$Proxy) o;

                return this.accelerationStatus.equals(that.accelerationStatus);
            }

            @Override
            public int hashCode() {
                int result = this.accelerationStatus.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.AccessControlTranslationProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessControlTranslationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessControlTranslationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.AccessControlTranslationProperty.Owner`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOwner();

        /**
         * @return a {@link Builder} of {@link AccessControlTranslationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessControlTranslationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccessControlTranslationProperty> {
            private java.lang.String owner;

            /**
             * Sets the value of {@link AccessControlTranslationProperty#getOwner}
             * @param owner `CfnBucket.AccessControlTranslationProperty.Owner`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder owner(java.lang.String owner) {
                this.owner = owner;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessControlTranslationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccessControlTranslationProperty build() {
                return new Jsii$Proxy(owner);
            }
        }

        /**
         * An implementation for {@link AccessControlTranslationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessControlTranslationProperty {
            private final java.lang.String owner;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.owner = this.jsiiGet("owner", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String owner) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.owner = java.util.Objects.requireNonNull(owner, "owner is required");
            }

            @Override
            public java.lang.String getOwner() {
                return this.owner;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("owner", om.valueToTree(this.getOwner()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.AccessControlTranslationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessControlTranslationProperty.Jsii$Proxy that = (AccessControlTranslationProperty.Jsii$Proxy) o;

                return this.owner.equals(that.owner);
            }

            @Override
            public int hashCode() {
                int result = this.owner.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.AnalyticsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalyticsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalyticsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.AnalyticsConfigurationProperty.Id`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * `CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStorageClassAnalysis();

        /**
         * `CfnBucket.AnalyticsConfigurationProperty.Prefix`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * `CfnBucket.AnalyticsConfigurationProperty.TagFilters`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagFilters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalyticsConfigurationProperty> {
            private java.lang.String id;
            private java.lang.Object storageClassAnalysis;
            private java.lang.String prefix;
            private java.lang.Object tagFilters;

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getId}
             * @param id `CfnBucket.AnalyticsConfigurationProperty.Id`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getStorageClassAnalysis}
             * @param storageClassAnalysis `CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageClassAnalysis(software.amazon.awscdk.core.IResolvable storageClassAnalysis) {
                this.storageClassAnalysis = storageClassAnalysis;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getStorageClassAnalysis}
             * @param storageClassAnalysis `CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageClassAnalysis(software.amazon.awscdk.services.s3.CfnBucket.StorageClassAnalysisProperty storageClassAnalysis) {
                this.storageClassAnalysis = storageClassAnalysis;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getPrefix}
             * @param prefix `CfnBucket.AnalyticsConfigurationProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getTagFilters}
             * @param tagFilters `CfnBucket.AnalyticsConfigurationProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(software.amazon.awscdk.core.IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getTagFilters}
             * @param tagFilters `CfnBucket.AnalyticsConfigurationProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(java.util.List<java.lang.Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalyticsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalyticsConfigurationProperty build() {
                return new Jsii$Proxy(id, storageClassAnalysis, prefix, tagFilters);
            }
        }

        /**
         * An implementation for {@link AnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalyticsConfigurationProperty {
            private final java.lang.String id;
            private final java.lang.Object storageClassAnalysis;
            private final java.lang.String prefix;
            private final java.lang.Object tagFilters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = this.jsiiGet("id", java.lang.String.class);
                this.storageClassAnalysis = this.jsiiGet("storageClassAnalysis", java.lang.Object.class);
                this.prefix = this.jsiiGet("prefix", java.lang.String.class);
                this.tagFilters = this.jsiiGet("tagFilters", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String id, final java.lang.Object storageClassAnalysis, final java.lang.String prefix, final java.lang.Object tagFilters) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(id, "id is required");
                this.storageClassAnalysis = java.util.Objects.requireNonNull(storageClassAnalysis, "storageClassAnalysis is required");
                this.prefix = prefix;
                this.tagFilters = tagFilters;
            }

            @Override
            public java.lang.String getId() {
                return this.id;
            }

            @Override
            public java.lang.Object getStorageClassAnalysis() {
                return this.storageClassAnalysis;
            }

            @Override
            public java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public java.lang.Object getTagFilters() {
                return this.tagFilters;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                data.set("storageClassAnalysis", om.valueToTree(this.getStorageClassAnalysis()));
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getTagFilters() != null) {
                    data.set("tagFilters", om.valueToTree(this.getTagFilters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.AnalyticsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalyticsConfigurationProperty.Jsii$Proxy that = (AnalyticsConfigurationProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (!storageClassAnalysis.equals(that.storageClassAnalysis)) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                return this.tagFilters != null ? this.tagFilters.equals(that.tagFilters) : that.tagFilters == null;
            }

            @Override
            public int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.storageClassAnalysis.hashCode());
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.tagFilters != null ? this.tagFilters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.BucketEncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(BucketEncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BucketEncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getServerSideEncryptionConfiguration();

        /**
         * @return a {@link Builder} of {@link BucketEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BucketEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BucketEncryptionProperty> {
            private java.lang.Object serverSideEncryptionConfiguration;

            /**
             * Sets the value of {@link BucketEncryptionProperty#getServerSideEncryptionConfiguration}
             * @param serverSideEncryptionConfiguration `CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverSideEncryptionConfiguration(software.amazon.awscdk.core.IResolvable serverSideEncryptionConfiguration) {
                this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link BucketEncryptionProperty#getServerSideEncryptionConfiguration}
             * @param serverSideEncryptionConfiguration `CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverSideEncryptionConfiguration(java.util.List<java.lang.Object> serverSideEncryptionConfiguration) {
                this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BucketEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BucketEncryptionProperty build() {
                return new Jsii$Proxy(serverSideEncryptionConfiguration);
            }
        }

        /**
         * An implementation for {@link BucketEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BucketEncryptionProperty {
            private final java.lang.Object serverSideEncryptionConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.serverSideEncryptionConfiguration = this.jsiiGet("serverSideEncryptionConfiguration", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object serverSideEncryptionConfiguration) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.serverSideEncryptionConfiguration = java.util.Objects.requireNonNull(serverSideEncryptionConfiguration, "serverSideEncryptionConfiguration is required");
            }

            @Override
            public java.lang.Object getServerSideEncryptionConfiguration() {
                return this.serverSideEncryptionConfiguration;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("serverSideEncryptionConfiguration", om.valueToTree(this.getServerSideEncryptionConfiguration()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.BucketEncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BucketEncryptionProperty.Jsii$Proxy that = (BucketEncryptionProperty.Jsii$Proxy) o;

                return this.serverSideEncryptionConfiguration.equals(that.serverSideEncryptionConfiguration);
            }

            @Override
            public int hashCode() {
                int result = this.serverSideEncryptionConfiguration.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.CorsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CorsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CorsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.CorsConfigurationProperty.CorsRules`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCorsRules();

        /**
         * @return a {@link Builder} of {@link CorsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CorsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CorsConfigurationProperty> {
            private java.lang.Object corsRules;

            /**
             * Sets the value of {@link CorsConfigurationProperty#getCorsRules}
             * @param corsRules `CfnBucket.CorsConfigurationProperty.CorsRules`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder corsRules(software.amazon.awscdk.core.IResolvable corsRules) {
                this.corsRules = corsRules;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigurationProperty#getCorsRules}
             * @param corsRules `CfnBucket.CorsConfigurationProperty.CorsRules`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder corsRules(java.util.List<java.lang.Object> corsRules) {
                this.corsRules = corsRules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CorsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CorsConfigurationProperty build() {
                return new Jsii$Proxy(corsRules);
            }
        }

        /**
         * An implementation for {@link CorsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CorsConfigurationProperty {
            private final java.lang.Object corsRules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.corsRules = this.jsiiGet("corsRules", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object corsRules) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.corsRules = java.util.Objects.requireNonNull(corsRules, "corsRules is required");
            }

            @Override
            public java.lang.Object getCorsRules() {
                return this.corsRules;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("corsRules", om.valueToTree(this.getCorsRules()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.CorsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CorsConfigurationProperty.Jsii$Proxy that = (CorsConfigurationProperty.Jsii$Proxy) o;

                return this.corsRules.equals(that.corsRules);
            }

            @Override
            public int hashCode() {
                int result = this.corsRules.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.CorsRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(CorsRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CorsRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.CorsRuleProperty.AllowedMethods`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAllowedMethods();

        /**
         * `CfnBucket.CorsRuleProperty.AllowedOrigins`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAllowedOrigins();

        /**
         * `CfnBucket.CorsRuleProperty.AllowedHeaders`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedHeaders() {
            return null;
        }

        /**
         * `CfnBucket.CorsRuleProperty.ExposedHeaders`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExposedHeaders() {
            return null;
        }

        /**
         * `CfnBucket.CorsRuleProperty.Id`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId() {
            return null;
        }

        /**
         * `CfnBucket.CorsRuleProperty.MaxAge`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxAge() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CorsRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CorsRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CorsRuleProperty> {
            private java.util.List<java.lang.String> allowedMethods;
            private java.util.List<java.lang.String> allowedOrigins;
            private java.util.List<java.lang.String> allowedHeaders;
            private java.util.List<java.lang.String> exposedHeaders;
            private java.lang.String id;
            private java.lang.Number maxAge;

            /**
             * Sets the value of {@link CorsRuleProperty#getAllowedMethods}
             * @param allowedMethods `CfnBucket.CorsRuleProperty.AllowedMethods`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedMethods(java.util.List<java.lang.String> allowedMethods) {
                this.allowedMethods = allowedMethods;
                return this;
            }

            /**
             * Sets the value of {@link CorsRuleProperty#getAllowedOrigins}
             * @param allowedOrigins `CfnBucket.CorsRuleProperty.AllowedOrigins`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedOrigins(java.util.List<java.lang.String> allowedOrigins) {
                this.allowedOrigins = allowedOrigins;
                return this;
            }

            /**
             * Sets the value of {@link CorsRuleProperty#getAllowedHeaders}
             * @param allowedHeaders `CfnBucket.CorsRuleProperty.AllowedHeaders`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedHeaders(java.util.List<java.lang.String> allowedHeaders) {
                this.allowedHeaders = allowedHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CorsRuleProperty#getExposedHeaders}
             * @param exposedHeaders `CfnBucket.CorsRuleProperty.ExposedHeaders`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exposedHeaders(java.util.List<java.lang.String> exposedHeaders) {
                this.exposedHeaders = exposedHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CorsRuleProperty#getId}
             * @param id `CfnBucket.CorsRuleProperty.Id`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link CorsRuleProperty#getMaxAge}
             * @param maxAge `CfnBucket.CorsRuleProperty.MaxAge`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxAge(java.lang.Number maxAge) {
                this.maxAge = maxAge;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CorsRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CorsRuleProperty build() {
                return new Jsii$Proxy(allowedMethods, allowedOrigins, allowedHeaders, exposedHeaders, id, maxAge);
            }
        }

        /**
         * An implementation for {@link CorsRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CorsRuleProperty {
            private final java.util.List<java.lang.String> allowedMethods;
            private final java.util.List<java.lang.String> allowedOrigins;
            private final java.util.List<java.lang.String> allowedHeaders;
            private final java.util.List<java.lang.String> exposedHeaders;
            private final java.lang.String id;
            private final java.lang.Number maxAge;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowedMethods = this.jsiiGet("allowedMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowedOrigins = this.jsiiGet("allowedOrigins", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowedHeaders = this.jsiiGet("allowedHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.exposedHeaders = this.jsiiGet("exposedHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.id = this.jsiiGet("id", java.lang.String.class);
                this.maxAge = this.jsiiGet("maxAge", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.util.List<java.lang.String> allowedMethods, final java.util.List<java.lang.String> allowedOrigins, final java.util.List<java.lang.String> allowedHeaders, final java.util.List<java.lang.String> exposedHeaders, final java.lang.String id, final java.lang.Number maxAge) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowedMethods = java.util.Objects.requireNonNull(allowedMethods, "allowedMethods is required");
                this.allowedOrigins = java.util.Objects.requireNonNull(allowedOrigins, "allowedOrigins is required");
                this.allowedHeaders = allowedHeaders;
                this.exposedHeaders = exposedHeaders;
                this.id = id;
                this.maxAge = maxAge;
            }

            @Override
            public java.util.List<java.lang.String> getAllowedMethods() {
                return this.allowedMethods;
            }

            @Override
            public java.util.List<java.lang.String> getAllowedOrigins() {
                return this.allowedOrigins;
            }

            @Override
            public java.util.List<java.lang.String> getAllowedHeaders() {
                return this.allowedHeaders;
            }

            @Override
            public java.util.List<java.lang.String> getExposedHeaders() {
                return this.exposedHeaders;
            }

            @Override
            public java.lang.String getId() {
                return this.id;
            }

            @Override
            public java.lang.Number getMaxAge() {
                return this.maxAge;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
                data.set("allowedOrigins", om.valueToTree(this.getAllowedOrigins()));
                if (this.getAllowedHeaders() != null) {
                    data.set("allowedHeaders", om.valueToTree(this.getAllowedHeaders()));
                }
                if (this.getExposedHeaders() != null) {
                    data.set("exposedHeaders", om.valueToTree(this.getExposedHeaders()));
                }
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getMaxAge() != null) {
                    data.set("maxAge", om.valueToTree(this.getMaxAge()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.CorsRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CorsRuleProperty.Jsii$Proxy that = (CorsRuleProperty.Jsii$Proxy) o;

                if (!allowedMethods.equals(that.allowedMethods)) return false;
                if (!allowedOrigins.equals(that.allowedOrigins)) return false;
                if (this.allowedHeaders != null ? !this.allowedHeaders.equals(that.allowedHeaders) : that.allowedHeaders != null) return false;
                if (this.exposedHeaders != null ? !this.exposedHeaders.equals(that.exposedHeaders) : that.exposedHeaders != null) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                return this.maxAge != null ? this.maxAge.equals(that.maxAge) : that.maxAge == null;
            }

            @Override
            public int hashCode() {
                int result = this.allowedMethods.hashCode();
                result = 31 * result + (this.allowedOrigins.hashCode());
                result = 31 * result + (this.allowedHeaders != null ? this.allowedHeaders.hashCode() : 0);
                result = 31 * result + (this.exposedHeaders != null ? this.exposedHeaders.hashCode() : 0);
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.maxAge != null ? this.maxAge.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.DataExportProperty")
    @software.amazon.jsii.Jsii.Proxy(DataExportProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataExportProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.DataExportProperty.Destination`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestination();

        /**
         * `CfnBucket.DataExportProperty.OutputSchemaVersion`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOutputSchemaVersion();

        /**
         * @return a {@link Builder} of {@link DataExportProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataExportProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataExportProperty> {
            private java.lang.Object destination;
            private java.lang.String outputSchemaVersion;

            /**
             * Sets the value of {@link DataExportProperty#getDestination}
             * @param destination `CfnBucket.DataExportProperty.Destination`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.core.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link DataExportProperty#getDestination}
             * @param destination `CfnBucket.DataExportProperty.Destination`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.services.s3.CfnBucket.DestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link DataExportProperty#getOutputSchemaVersion}
             * @param outputSchemaVersion `CfnBucket.DataExportProperty.OutputSchemaVersion`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputSchemaVersion(java.lang.String outputSchemaVersion) {
                this.outputSchemaVersion = outputSchemaVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataExportProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataExportProperty build() {
                return new Jsii$Proxy(destination, outputSchemaVersion);
            }
        }

        /**
         * An implementation for {@link DataExportProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataExportProperty {
            private final java.lang.Object destination;
            private final java.lang.String outputSchemaVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = this.jsiiGet("destination", java.lang.Object.class);
                this.outputSchemaVersion = this.jsiiGet("outputSchemaVersion", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object destination, final java.lang.String outputSchemaVersion) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(destination, "destination is required");
                this.outputSchemaVersion = java.util.Objects.requireNonNull(outputSchemaVersion, "outputSchemaVersion is required");
            }

            @Override
            public java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public java.lang.String getOutputSchemaVersion() {
                return this.outputSchemaVersion;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destination", om.valueToTree(this.getDestination()));
                data.set("outputSchemaVersion", om.valueToTree(this.getOutputSchemaVersion()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.DataExportProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataExportProperty.Jsii$Proxy that = (DataExportProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                return this.outputSchemaVersion.equals(that.outputSchemaVersion);
            }

            @Override
            public int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.outputSchemaVersion.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.DefaultRetentionProperty")
    @software.amazon.jsii.Jsii.Proxy(DefaultRetentionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefaultRetentionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.DefaultRetentionProperty.Days`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html#cfn-s3-bucket-defaultretention-days
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDays() {
            return null;
        }

        /**
         * `CfnBucket.DefaultRetentionProperty.Mode`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html#cfn-s3-bucket-defaultretention-mode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMode() {
            return null;
        }

        /**
         * `CfnBucket.DefaultRetentionProperty.Years`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html#cfn-s3-bucket-defaultretention-years
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getYears() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DefaultRetentionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefaultRetentionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefaultRetentionProperty> {
            private java.lang.Number days;
            private java.lang.String mode;
            private java.lang.Number years;

            /**
             * Sets the value of {@link DefaultRetentionProperty#getDays}
             * @param days `CfnBucket.DefaultRetentionProperty.Days`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder days(java.lang.Number days) {
                this.days = days;
                return this;
            }

            /**
             * Sets the value of {@link DefaultRetentionProperty#getMode}
             * @param mode `CfnBucket.DefaultRetentionProperty.Mode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Sets the value of {@link DefaultRetentionProperty#getYears}
             * @param years `CfnBucket.DefaultRetentionProperty.Years`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder years(java.lang.Number years) {
                this.years = years;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultRetentionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefaultRetentionProperty build() {
                return new Jsii$Proxy(days, mode, years);
            }
        }

        /**
         * An implementation for {@link DefaultRetentionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultRetentionProperty {
            private final java.lang.Number days;
            private final java.lang.String mode;
            private final java.lang.Number years;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.days = this.jsiiGet("days", java.lang.Number.class);
                this.mode = this.jsiiGet("mode", java.lang.String.class);
                this.years = this.jsiiGet("years", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number days, final java.lang.String mode, final java.lang.Number years) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.days = days;
                this.mode = mode;
                this.years = years;
            }

            @Override
            public java.lang.Number getDays() {
                return this.days;
            }

            @Override
            public java.lang.String getMode() {
                return this.mode;
            }

            @Override
            public java.lang.Number getYears() {
                return this.years;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDays() != null) {
                    data.set("days", om.valueToTree(this.getDays()));
                }
                if (this.getMode() != null) {
                    data.set("mode", om.valueToTree(this.getMode()));
                }
                if (this.getYears() != null) {
                    data.set("years", om.valueToTree(this.getYears()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.DefaultRetentionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefaultRetentionProperty.Jsii$Proxy that = (DefaultRetentionProperty.Jsii$Proxy) o;

                if (this.days != null ? !this.days.equals(that.days) : that.days != null) return false;
                if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) return false;
                return this.years != null ? this.years.equals(that.years) : that.years == null;
            }

            @Override
            public int hashCode() {
                int result = this.days != null ? this.days.hashCode() : 0;
                result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
                result = 31 * result + (this.years != null ? this.years.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-deletemarkerreplication.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.DeleteMarkerReplicationProperty")
    @software.amazon.jsii.Jsii.Proxy(DeleteMarkerReplicationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeleteMarkerReplicationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.DeleteMarkerReplicationProperty.Status`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-deletemarkerreplication.html#cfn-s3-bucket-deletemarkerreplication-status
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeleteMarkerReplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeleteMarkerReplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeleteMarkerReplicationProperty> {
            private java.lang.String status;

            /**
             * Sets the value of {@link DeleteMarkerReplicationProperty#getStatus}
             * @param status `CfnBucket.DeleteMarkerReplicationProperty.Status`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeleteMarkerReplicationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeleteMarkerReplicationProperty build() {
                return new Jsii$Proxy(status);
            }
        }

        /**
         * An implementation for {@link DeleteMarkerReplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeleteMarkerReplicationProperty {
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = this.jsiiGet("status", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String status) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = status;
            }

            @Override
            public java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.DeleteMarkerReplicationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeleteMarkerReplicationProperty.Jsii$Proxy that = (DeleteMarkerReplicationProperty.Jsii$Proxy) o;

                return this.status != null ? this.status.equals(that.status) : that.status == null;
            }

            @Override
            public int hashCode() {
                int result = this.status != null ? this.status.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.DestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.DestinationProperty.BucketArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketArn();

        /**
         * `CfnBucket.DestinationProperty.Format`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFormat();

        /**
         * `CfnBucket.DestinationProperty.BucketAccountId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketAccountId() {
            return null;
        }

        /**
         * `CfnBucket.DestinationProperty.Prefix`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DestinationProperty> {
            private java.lang.String bucketArn;
            private java.lang.String format;
            private java.lang.String bucketAccountId;
            private java.lang.String prefix;

            /**
             * Sets the value of {@link DestinationProperty#getBucketArn}
             * @param bucketArn `CfnBucket.DestinationProperty.BucketArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketArn(java.lang.String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            /**
             * Sets the value of {@link DestinationProperty#getFormat}
             * @param format `CfnBucket.DestinationProperty.Format`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Sets the value of {@link DestinationProperty#getBucketAccountId}
             * @param bucketAccountId `CfnBucket.DestinationProperty.BucketAccountId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketAccountId(java.lang.String bucketAccountId) {
                this.bucketAccountId = bucketAccountId;
                return this;
            }

            /**
             * Sets the value of {@link DestinationProperty#getPrefix}
             * @param prefix `CfnBucket.DestinationProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DestinationProperty build() {
                return new Jsii$Proxy(bucketArn, format, bucketAccountId, prefix);
            }
        }

        /**
         * An implementation for {@link DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationProperty {
            private final java.lang.String bucketArn;
            private final java.lang.String format;
            private final java.lang.String bucketAccountId;
            private final java.lang.String prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketArn = this.jsiiGet("bucketArn", java.lang.String.class);
                this.format = this.jsiiGet("format", java.lang.String.class);
                this.bucketAccountId = this.jsiiGet("bucketAccountId", java.lang.String.class);
                this.prefix = this.jsiiGet("prefix", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String bucketArn, final java.lang.String format, final java.lang.String bucketAccountId, final java.lang.String prefix) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketArn = java.util.Objects.requireNonNull(bucketArn, "bucketArn is required");
                this.format = java.util.Objects.requireNonNull(format, "format is required");
                this.bucketAccountId = bucketAccountId;
                this.prefix = prefix;
            }

            @Override
            public java.lang.String getBucketArn() {
                return this.bucketArn;
            }

            @Override
            public java.lang.String getFormat() {
                return this.format;
            }

            @Override
            public java.lang.String getBucketAccountId() {
                return this.bucketAccountId;
            }

            @Override
            public java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketArn", om.valueToTree(this.getBucketArn()));
                data.set("format", om.valueToTree(this.getFormat()));
                if (this.getBucketAccountId() != null) {
                    data.set("bucketAccountId", om.valueToTree(this.getBucketAccountId()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.DestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationProperty.Jsii$Proxy that = (DestinationProperty.Jsii$Proxy) o;

                if (!bucketArn.equals(that.bucketArn)) return false;
                if (!format.equals(that.format)) return false;
                if (this.bucketAccountId != null ? !this.bucketAccountId.equals(that.bucketAccountId) : that.bucketAccountId != null) return false;
                return this.prefix != null ? this.prefix.equals(that.prefix) : that.prefix == null;
            }

            @Override
            public int hashCode() {
                int result = this.bucketArn.hashCode();
                result = 31 * result + (this.format.hashCode());
                result = 31 * result + (this.bucketAccountId != null ? this.bucketAccountId.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.EncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.EncryptionConfigurationProperty.ReplicaKmsKeyID`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getReplicaKmsKeyId();

        /**
         * @return a {@link Builder} of {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionConfigurationProperty> {
            private java.lang.String replicaKmsKeyId;

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getReplicaKmsKeyId}
             * @param replicaKmsKeyId `CfnBucket.EncryptionConfigurationProperty.ReplicaKmsKeyID`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replicaKmsKeyId(java.lang.String replicaKmsKeyId) {
                this.replicaKmsKeyId = replicaKmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionConfigurationProperty build() {
                return new Jsii$Proxy(replicaKmsKeyId);
            }
        }

        /**
         * An implementation for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionConfigurationProperty {
            private final java.lang.String replicaKmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.replicaKmsKeyId = this.jsiiGet("replicaKmsKeyId", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String replicaKmsKeyId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.replicaKmsKeyId = java.util.Objects.requireNonNull(replicaKmsKeyId, "replicaKmsKeyId is required");
            }

            @Override
            public java.lang.String getReplicaKmsKeyId() {
                return this.replicaKmsKeyId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("replicaKmsKeyId", om.valueToTree(this.getReplicaKmsKeyId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.EncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionConfigurationProperty.Jsii$Proxy that = (EncryptionConfigurationProperty.Jsii$Proxy) o;

                return this.replicaKmsKeyId.equals(that.replicaKmsKeyId);
            }

            @Override
            public int hashCode() {
                int result = this.replicaKmsKeyId.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.FilterRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.FilterRuleProperty.Name`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * `CfnBucket.FilterRuleProperty.Value`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link FilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterRuleProperty> {
            private java.lang.String name;
            private java.lang.String value;

            /**
             * Sets the value of {@link FilterRuleProperty#getName}
             * @param name `CfnBucket.FilterRuleProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link FilterRuleProperty#getValue}
             * @param value `CfnBucket.FilterRuleProperty.Value`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterRuleProperty build() {
                return new Jsii$Proxy(name, value);
            }
        }

        /**
         * An implementation for {@link FilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterRuleProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.value = this.jsiiGet("value", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String name, final java.lang.String value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.value = java.util.Objects.requireNonNull(value, "value is required");
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.lang.String getValue() {
                return this.value;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.FilterRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterRuleProperty.Jsii$Proxy that = (FilterRuleProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.InventoryConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(InventoryConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InventoryConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.InventoryConfigurationProperty.Destination`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestination();

        /**
         * `CfnBucket.InventoryConfigurationProperty.Enabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * `CfnBucket.InventoryConfigurationProperty.Id`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * `CfnBucket.InventoryConfigurationProperty.IncludedObjectVersions`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIncludedObjectVersions();

        /**
         * `CfnBucket.InventoryConfigurationProperty.ScheduleFrequency`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScheduleFrequency();

        /**
         * `CfnBucket.InventoryConfigurationProperty.OptionalFields`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOptionalFields() {
            return null;
        }

        /**
         * `CfnBucket.InventoryConfigurationProperty.Prefix`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InventoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InventoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InventoryConfigurationProperty> {
            private java.lang.Object destination;
            private java.lang.Object enabled;
            private java.lang.String id;
            private java.lang.String includedObjectVersions;
            private java.lang.String scheduleFrequency;
            private java.util.List<java.lang.String> optionalFields;
            private java.lang.String prefix;

            /**
             * Sets the value of {@link InventoryConfigurationProperty#getDestination}
             * @param destination `CfnBucket.InventoryConfigurationProperty.Destination`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.core.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link InventoryConfigurationProperty#getDestination}
             * @param destination `CfnBucket.InventoryConfigurationProperty.Destination`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.services.s3.CfnBucket.DestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link InventoryConfigurationProperty#getEnabled}
             * @param enabled `CfnBucket.InventoryConfigurationProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link InventoryConfigurationProperty#getEnabled}
             * @param enabled `CfnBucket.InventoryConfigurationProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link InventoryConfigurationProperty#getId}
             * @param id `CfnBucket.InventoryConfigurationProperty.Id`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link InventoryConfigurationProperty#getIncludedObjectVersions}
             * @param includedObjectVersions `CfnBucket.InventoryConfigurationProperty.IncludedObjectVersions`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includedObjectVersions(java.lang.String includedObjectVersions) {
                this.includedObjectVersions = includedObjectVersions;
                return this;
            }

            /**
             * Sets the value of {@link InventoryConfigurationProperty#getScheduleFrequency}
             * @param scheduleFrequency `CfnBucket.InventoryConfigurationProperty.ScheduleFrequency`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleFrequency(java.lang.String scheduleFrequency) {
                this.scheduleFrequency = scheduleFrequency;
                return this;
            }

            /**
             * Sets the value of {@link InventoryConfigurationProperty#getOptionalFields}
             * @param optionalFields `CfnBucket.InventoryConfigurationProperty.OptionalFields`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optionalFields(java.util.List<java.lang.String> optionalFields) {
                this.optionalFields = optionalFields;
                return this;
            }

            /**
             * Sets the value of {@link InventoryConfigurationProperty#getPrefix}
             * @param prefix `CfnBucket.InventoryConfigurationProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InventoryConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InventoryConfigurationProperty build() {
                return new Jsii$Proxy(destination, enabled, id, includedObjectVersions, scheduleFrequency, optionalFields, prefix);
            }
        }

        /**
         * An implementation for {@link InventoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InventoryConfigurationProperty {
            private final java.lang.Object destination;
            private final java.lang.Object enabled;
            private final java.lang.String id;
            private final java.lang.String includedObjectVersions;
            private final java.lang.String scheduleFrequency;
            private final java.util.List<java.lang.String> optionalFields;
            private final java.lang.String prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = this.jsiiGet("destination", java.lang.Object.class);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
                this.id = this.jsiiGet("id", java.lang.String.class);
                this.includedObjectVersions = this.jsiiGet("includedObjectVersions", java.lang.String.class);
                this.scheduleFrequency = this.jsiiGet("scheduleFrequency", java.lang.String.class);
                this.optionalFields = this.jsiiGet("optionalFields", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.prefix = this.jsiiGet("prefix", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object destination, final java.lang.Object enabled, final java.lang.String id, final java.lang.String includedObjectVersions, final java.lang.String scheduleFrequency, final java.util.List<java.lang.String> optionalFields, final java.lang.String prefix) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(destination, "destination is required");
                this.enabled = java.util.Objects.requireNonNull(enabled, "enabled is required");
                this.id = java.util.Objects.requireNonNull(id, "id is required");
                this.includedObjectVersions = java.util.Objects.requireNonNull(includedObjectVersions, "includedObjectVersions is required");
                this.scheduleFrequency = java.util.Objects.requireNonNull(scheduleFrequency, "scheduleFrequency is required");
                this.optionalFields = optionalFields;
                this.prefix = prefix;
            }

            @Override
            public java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public java.lang.String getId() {
                return this.id;
            }

            @Override
            public java.lang.String getIncludedObjectVersions() {
                return this.includedObjectVersions;
            }

            @Override
            public java.lang.String getScheduleFrequency() {
                return this.scheduleFrequency;
            }

            @Override
            public java.util.List<java.lang.String> getOptionalFields() {
                return this.optionalFields;
            }

            @Override
            public java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destination", om.valueToTree(this.getDestination()));
                data.set("enabled", om.valueToTree(this.getEnabled()));
                data.set("id", om.valueToTree(this.getId()));
                data.set("includedObjectVersions", om.valueToTree(this.getIncludedObjectVersions()));
                data.set("scheduleFrequency", om.valueToTree(this.getScheduleFrequency()));
                if (this.getOptionalFields() != null) {
                    data.set("optionalFields", om.valueToTree(this.getOptionalFields()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.InventoryConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InventoryConfigurationProperty.Jsii$Proxy that = (InventoryConfigurationProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                if (!enabled.equals(that.enabled)) return false;
                if (!id.equals(that.id)) return false;
                if (!includedObjectVersions.equals(that.includedObjectVersions)) return false;
                if (!scheduleFrequency.equals(that.scheduleFrequency)) return false;
                if (this.optionalFields != null ? !this.optionalFields.equals(that.optionalFields) : that.optionalFields != null) return false;
                return this.prefix != null ? this.prefix.equals(that.prefix) : that.prefix == null;
            }

            @Override
            public int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.enabled.hashCode());
                result = 31 * result + (this.id.hashCode());
                result = 31 * result + (this.includedObjectVersions.hashCode());
                result = 31 * result + (this.scheduleFrequency.hashCode());
                result = 31 * result + (this.optionalFields != null ? this.optionalFields.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.LambdaConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.LambdaConfigurationProperty.Event`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEvent();

        /**
         * `CfnBucket.LambdaConfigurationProperty.Function`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFunction();

        /**
         * `CfnBucket.LambdaConfigurationProperty.Filter`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaConfigurationProperty> {
            private java.lang.String event;
            private java.lang.String function;
            private java.lang.Object filter;

            /**
             * Sets the value of {@link LambdaConfigurationProperty#getEvent}
             * @param event `CfnBucket.LambdaConfigurationProperty.Event`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder event(java.lang.String event) {
                this.event = event;
                return this;
            }

            /**
             * Sets the value of {@link LambdaConfigurationProperty#getFunction}
             * @param function `CfnBucket.LambdaConfigurationProperty.Function`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder function(java.lang.String function) {
                this.function = function;
                return this;
            }

            /**
             * Sets the value of {@link LambdaConfigurationProperty#getFilter}
             * @param filter `CfnBucket.LambdaConfigurationProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.core.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link LambdaConfigurationProperty#getFilter}
             * @param filter `CfnBucket.LambdaConfigurationProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaConfigurationProperty build() {
                return new Jsii$Proxy(event, function, filter);
            }
        }

        /**
         * An implementation for {@link LambdaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaConfigurationProperty {
            private final java.lang.String event;
            private final java.lang.String function;
            private final java.lang.Object filter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.event = this.jsiiGet("event", java.lang.String.class);
                this.function = this.jsiiGet("function", java.lang.String.class);
                this.filter = this.jsiiGet("filter", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String event, final java.lang.String function, final java.lang.Object filter) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.event = java.util.Objects.requireNonNull(event, "event is required");
                this.function = java.util.Objects.requireNonNull(function, "function is required");
                this.filter = filter;
            }

            @Override
            public java.lang.String getEvent() {
                return this.event;
            }

            @Override
            public java.lang.String getFunction() {
                return this.function;
            }

            @Override
            public java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("event", om.valueToTree(this.getEvent()));
                data.set("function", om.valueToTree(this.getFunction()));
                if (this.getFilter() != null) {
                    data.set("filter", om.valueToTree(this.getFilter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.LambdaConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaConfigurationProperty.Jsii$Proxy that = (LambdaConfigurationProperty.Jsii$Proxy) o;

                if (!event.equals(that.event)) return false;
                if (!function.equals(that.function)) return false;
                return this.filter != null ? this.filter.equals(that.filter) : that.filter == null;
            }

            @Override
            public int hashCode() {
                int result = this.event.hashCode();
                result = 31 * result + (this.function.hashCode());
                result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.LifecycleConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LifecycleConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LifecycleConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.LifecycleConfigurationProperty.Rules`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link LifecycleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LifecycleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LifecycleConfigurationProperty> {
            private java.lang.Object rules;

            /**
             * Sets the value of {@link LifecycleConfigurationProperty#getRules}
             * @param rules `CfnBucket.LifecycleConfigurationProperty.Rules`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(software.amazon.awscdk.core.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of {@link LifecycleConfigurationProperty#getRules}
             * @param rules `CfnBucket.LifecycleConfigurationProperty.Rules`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(java.util.List<java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LifecycleConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LifecycleConfigurationProperty build() {
                return new Jsii$Proxy(rules);
            }
        }

        /**
         * An implementation for {@link LifecycleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LifecycleConfigurationProperty {
            private final java.lang.Object rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rules = this.jsiiGet("rules", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object rules) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rules = java.util.Objects.requireNonNull(rules, "rules is required");
            }

            @Override
            public java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("rules", om.valueToTree(this.getRules()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.LifecycleConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LifecycleConfigurationProperty.Jsii$Proxy that = (LifecycleConfigurationProperty.Jsii$Proxy) o;

                return this.rules.equals(that.rules);
            }

            @Override
            public int hashCode() {
                int result = this.rules.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.LoggingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.LoggingConfigurationProperty.DestinationBucketName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationBucketName() {
            return null;
        }

        /**
         * `CfnBucket.LoggingConfigurationProperty.LogFilePrefix`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogFilePrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingConfigurationProperty> {
            private java.lang.String destinationBucketName;
            private java.lang.String logFilePrefix;

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getDestinationBucketName}
             * @param destinationBucketName `CfnBucket.LoggingConfigurationProperty.DestinationBucketName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationBucketName(java.lang.String destinationBucketName) {
                this.destinationBucketName = destinationBucketName;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getLogFilePrefix}
             * @param logFilePrefix `CfnBucket.LoggingConfigurationProperty.LogFilePrefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logFilePrefix(java.lang.String logFilePrefix) {
                this.logFilePrefix = logFilePrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingConfigurationProperty build() {
                return new Jsii$Proxy(destinationBucketName, logFilePrefix);
            }
        }

        /**
         * An implementation for {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingConfigurationProperty {
            private final java.lang.String destinationBucketName;
            private final java.lang.String logFilePrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationBucketName = this.jsiiGet("destinationBucketName", java.lang.String.class);
                this.logFilePrefix = this.jsiiGet("logFilePrefix", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String destinationBucketName, final java.lang.String logFilePrefix) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationBucketName = destinationBucketName;
                this.logFilePrefix = logFilePrefix;
            }

            @Override
            public java.lang.String getDestinationBucketName() {
                return this.destinationBucketName;
            }

            @Override
            public java.lang.String getLogFilePrefix() {
                return this.logFilePrefix;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinationBucketName() != null) {
                    data.set("destinationBucketName", om.valueToTree(this.getDestinationBucketName()));
                }
                if (this.getLogFilePrefix() != null) {
                    data.set("logFilePrefix", om.valueToTree(this.getLogFilePrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.LoggingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingConfigurationProperty.Jsii$Proxy that = (LoggingConfigurationProperty.Jsii$Proxy) o;

                if (this.destinationBucketName != null ? !this.destinationBucketName.equals(that.destinationBucketName) : that.destinationBucketName != null) return false;
                return this.logFilePrefix != null ? this.logFilePrefix.equals(that.logFilePrefix) : that.logFilePrefix == null;
            }

            @Override
            public int hashCode() {
                int result = this.destinationBucketName != null ? this.destinationBucketName.hashCode() : 0;
                result = 31 * result + (this.logFilePrefix != null ? this.logFilePrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.MetricsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.MetricsConfigurationProperty.Id`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * `CfnBucket.MetricsConfigurationProperty.Prefix`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * `CfnBucket.MetricsConfigurationProperty.TagFilters`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagFilters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricsConfigurationProperty> {
            private java.lang.String id;
            private java.lang.String prefix;
            private java.lang.Object tagFilters;

            /**
             * Sets the value of {@link MetricsConfigurationProperty#getId}
             * @param id `CfnBucket.MetricsConfigurationProperty.Id`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link MetricsConfigurationProperty#getPrefix}
             * @param prefix `CfnBucket.MetricsConfigurationProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link MetricsConfigurationProperty#getTagFilters}
             * @param tagFilters `CfnBucket.MetricsConfigurationProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(software.amazon.awscdk.core.IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Sets the value of {@link MetricsConfigurationProperty#getTagFilters}
             * @param tagFilters `CfnBucket.MetricsConfigurationProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(java.util.List<java.lang.Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricsConfigurationProperty build() {
                return new Jsii$Proxy(id, prefix, tagFilters);
            }
        }

        /**
         * An implementation for {@link MetricsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricsConfigurationProperty {
            private final java.lang.String id;
            private final java.lang.String prefix;
            private final java.lang.Object tagFilters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = this.jsiiGet("id", java.lang.String.class);
                this.prefix = this.jsiiGet("prefix", java.lang.String.class);
                this.tagFilters = this.jsiiGet("tagFilters", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String id, final java.lang.String prefix, final java.lang.Object tagFilters) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(id, "id is required");
                this.prefix = prefix;
                this.tagFilters = tagFilters;
            }

            @Override
            public java.lang.String getId() {
                return this.id;
            }

            @Override
            public java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public java.lang.Object getTagFilters() {
                return this.tagFilters;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getTagFilters() != null) {
                    data.set("tagFilters", om.valueToTree(this.getTagFilters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.MetricsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricsConfigurationProperty.Jsii$Proxy that = (MetricsConfigurationProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                return this.tagFilters != null ? this.tagFilters.equals(that.tagFilters) : that.tagFilters == null;
            }

            @Override
            public int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.tagFilters != null ? this.tagFilters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metrics.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.MetricsProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.MetricsProperty.EventThreshold`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metrics.html#cfn-s3-bucket-metrics-eventthreshold
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEventThreshold();

        /**
         * `CfnBucket.MetricsProperty.Status`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metrics.html#cfn-s3-bucket-metrics-status
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * @return a {@link Builder} of {@link MetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricsProperty> {
            private java.lang.Object eventThreshold;
            private java.lang.String status;

            /**
             * Sets the value of {@link MetricsProperty#getEventThreshold}
             * @param eventThreshold `CfnBucket.MetricsProperty.EventThreshold`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventThreshold(software.amazon.awscdk.core.IResolvable eventThreshold) {
                this.eventThreshold = eventThreshold;
                return this;
            }

            /**
             * Sets the value of {@link MetricsProperty#getEventThreshold}
             * @param eventThreshold `CfnBucket.MetricsProperty.EventThreshold`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventThreshold(software.amazon.awscdk.services.s3.CfnBucket.ReplicationTimeValueProperty eventThreshold) {
                this.eventThreshold = eventThreshold;
                return this;
            }

            /**
             * Sets the value of {@link MetricsProperty#getStatus}
             * @param status `CfnBucket.MetricsProperty.Status`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricsProperty build() {
                return new Jsii$Proxy(eventThreshold, status);
            }
        }

        /**
         * An implementation for {@link MetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricsProperty {
            private final java.lang.Object eventThreshold;
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventThreshold = this.jsiiGet("eventThreshold", java.lang.Object.class);
                this.status = this.jsiiGet("status", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object eventThreshold, final java.lang.String status) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventThreshold = java.util.Objects.requireNonNull(eventThreshold, "eventThreshold is required");
                this.status = java.util.Objects.requireNonNull(status, "status is required");
            }

            @Override
            public java.lang.Object getEventThreshold() {
                return this.eventThreshold;
            }

            @Override
            public java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("eventThreshold", om.valueToTree(this.getEventThreshold()));
                data.set("status", om.valueToTree(this.getStatus()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.MetricsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricsProperty.Jsii$Proxy that = (MetricsProperty.Jsii$Proxy) o;

                if (!eventThreshold.equals(that.eventThreshold)) return false;
                return this.status.equals(that.status);
            }

            @Override
            public int hashCode() {
                int result = this.eventThreshold.hashCode();
                result = 31 * result + (this.status.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.NoncurrentVersionTransitionProperty")
    @software.amazon.jsii.Jsii.Proxy(NoncurrentVersionTransitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NoncurrentVersionTransitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.NoncurrentVersionTransitionProperty.StorageClass`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStorageClass();

        /**
         * `CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTransitionInDays();

        /**
         * @return a {@link Builder} of {@link NoncurrentVersionTransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NoncurrentVersionTransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NoncurrentVersionTransitionProperty> {
            private java.lang.String storageClass;
            private java.lang.Number transitionInDays;

            /**
             * Sets the value of {@link NoncurrentVersionTransitionProperty#getStorageClass}
             * @param storageClass `CfnBucket.NoncurrentVersionTransitionProperty.StorageClass`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageClass(java.lang.String storageClass) {
                this.storageClass = storageClass;
                return this;
            }

            /**
             * Sets the value of {@link NoncurrentVersionTransitionProperty#getTransitionInDays}
             * @param transitionInDays `CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitionInDays(java.lang.Number transitionInDays) {
                this.transitionInDays = transitionInDays;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NoncurrentVersionTransitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NoncurrentVersionTransitionProperty build() {
                return new Jsii$Proxy(storageClass, transitionInDays);
            }
        }

        /**
         * An implementation for {@link NoncurrentVersionTransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NoncurrentVersionTransitionProperty {
            private final java.lang.String storageClass;
            private final java.lang.Number transitionInDays;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.storageClass = this.jsiiGet("storageClass", java.lang.String.class);
                this.transitionInDays = this.jsiiGet("transitionInDays", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String storageClass, final java.lang.Number transitionInDays) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.storageClass = java.util.Objects.requireNonNull(storageClass, "storageClass is required");
                this.transitionInDays = java.util.Objects.requireNonNull(transitionInDays, "transitionInDays is required");
            }

            @Override
            public java.lang.String getStorageClass() {
                return this.storageClass;
            }

            @Override
            public java.lang.Number getTransitionInDays() {
                return this.transitionInDays;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("storageClass", om.valueToTree(this.getStorageClass()));
                data.set("transitionInDays", om.valueToTree(this.getTransitionInDays()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.NoncurrentVersionTransitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NoncurrentVersionTransitionProperty.Jsii$Proxy that = (NoncurrentVersionTransitionProperty.Jsii$Proxy) o;

                if (!storageClass.equals(that.storageClass)) return false;
                return this.transitionInDays.equals(that.transitionInDays);
            }

            @Override
            public int hashCode() {
                int result = this.storageClass.hashCode();
                result = 31 * result + (this.transitionInDays.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.NotificationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NotificationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotificationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.NotificationConfigurationProperty.LambdaConfigurations`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaConfigurations() {
            return null;
        }

        /**
         * `CfnBucket.NotificationConfigurationProperty.QueueConfigurations`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQueueConfigurations() {
            return null;
        }

        /**
         * `CfnBucket.NotificationConfigurationProperty.TopicConfigurations`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTopicConfigurations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NotificationConfigurationProperty> {
            private java.lang.Object lambdaConfigurations;
            private java.lang.Object queueConfigurations;
            private java.lang.Object topicConfigurations;

            /**
             * Sets the value of {@link NotificationConfigurationProperty#getLambdaConfigurations}
             * @param lambdaConfigurations `CfnBucket.NotificationConfigurationProperty.LambdaConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaConfigurations(software.amazon.awscdk.core.IResolvable lambdaConfigurations) {
                this.lambdaConfigurations = lambdaConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link NotificationConfigurationProperty#getLambdaConfigurations}
             * @param lambdaConfigurations `CfnBucket.NotificationConfigurationProperty.LambdaConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaConfigurations(java.util.List<java.lang.Object> lambdaConfigurations) {
                this.lambdaConfigurations = lambdaConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link NotificationConfigurationProperty#getQueueConfigurations}
             * @param queueConfigurations `CfnBucket.NotificationConfigurationProperty.QueueConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queueConfigurations(software.amazon.awscdk.core.IResolvable queueConfigurations) {
                this.queueConfigurations = queueConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link NotificationConfigurationProperty#getQueueConfigurations}
             * @param queueConfigurations `CfnBucket.NotificationConfigurationProperty.QueueConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queueConfigurations(java.util.List<java.lang.Object> queueConfigurations) {
                this.queueConfigurations = queueConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link NotificationConfigurationProperty#getTopicConfigurations}
             * @param topicConfigurations `CfnBucket.NotificationConfigurationProperty.TopicConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicConfigurations(software.amazon.awscdk.core.IResolvable topicConfigurations) {
                this.topicConfigurations = topicConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link NotificationConfigurationProperty#getTopicConfigurations}
             * @param topicConfigurations `CfnBucket.NotificationConfigurationProperty.TopicConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicConfigurations(java.util.List<java.lang.Object> topicConfigurations) {
                this.topicConfigurations = topicConfigurations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NotificationConfigurationProperty build() {
                return new Jsii$Proxy(lambdaConfigurations, queueConfigurations, topicConfigurations);
            }
        }

        /**
         * An implementation for {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationConfigurationProperty {
            private final java.lang.Object lambdaConfigurations;
            private final java.lang.Object queueConfigurations;
            private final java.lang.Object topicConfigurations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lambdaConfigurations = this.jsiiGet("lambdaConfigurations", java.lang.Object.class);
                this.queueConfigurations = this.jsiiGet("queueConfigurations", java.lang.Object.class);
                this.topicConfigurations = this.jsiiGet("topicConfigurations", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object lambdaConfigurations, final java.lang.Object queueConfigurations, final java.lang.Object topicConfigurations) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lambdaConfigurations = lambdaConfigurations;
                this.queueConfigurations = queueConfigurations;
                this.topicConfigurations = topicConfigurations;
            }

            @Override
            public java.lang.Object getLambdaConfigurations() {
                return this.lambdaConfigurations;
            }

            @Override
            public java.lang.Object getQueueConfigurations() {
                return this.queueConfigurations;
            }

            @Override
            public java.lang.Object getTopicConfigurations() {
                return this.topicConfigurations;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLambdaConfigurations() != null) {
                    data.set("lambdaConfigurations", om.valueToTree(this.getLambdaConfigurations()));
                }
                if (this.getQueueConfigurations() != null) {
                    data.set("queueConfigurations", om.valueToTree(this.getQueueConfigurations()));
                }
                if (this.getTopicConfigurations() != null) {
                    data.set("topicConfigurations", om.valueToTree(this.getTopicConfigurations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.NotificationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotificationConfigurationProperty.Jsii$Proxy that = (NotificationConfigurationProperty.Jsii$Proxy) o;

                if (this.lambdaConfigurations != null ? !this.lambdaConfigurations.equals(that.lambdaConfigurations) : that.lambdaConfigurations != null) return false;
                if (this.queueConfigurations != null ? !this.queueConfigurations.equals(that.queueConfigurations) : that.queueConfigurations != null) return false;
                return this.topicConfigurations != null ? this.topicConfigurations.equals(that.topicConfigurations) : that.topicConfigurations == null;
            }

            @Override
            public int hashCode() {
                int result = this.lambdaConfigurations != null ? this.lambdaConfigurations.hashCode() : 0;
                result = 31 * result + (this.queueConfigurations != null ? this.queueConfigurations.hashCode() : 0);
                result = 31 * result + (this.topicConfigurations != null ? this.topicConfigurations.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.NotificationFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(NotificationFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotificationFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.NotificationFilterProperty.S3Key`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Key();

        /**
         * @return a {@link Builder} of {@link NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NotificationFilterProperty> {
            private java.lang.Object s3Key;

            /**
             * Sets the value of {@link NotificationFilterProperty#getS3Key}
             * @param s3Key `CfnBucket.NotificationFilterProperty.S3Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Key(software.amazon.awscdk.core.IResolvable s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            /**
             * Sets the value of {@link NotificationFilterProperty#getS3Key}
             * @param s3Key `CfnBucket.NotificationFilterProperty.S3Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Key(software.amazon.awscdk.services.s3.CfnBucket.S3KeyFilterProperty s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NotificationFilterProperty build() {
                return new Jsii$Proxy(s3Key);
            }
        }

        /**
         * An implementation for {@link NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationFilterProperty {
            private final java.lang.Object s3Key;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Key = this.jsiiGet("s3Key", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object s3Key) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Key = java.util.Objects.requireNonNull(s3Key, "s3Key is required");
            }

            @Override
            public java.lang.Object getS3Key() {
                return this.s3Key;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Key", om.valueToTree(this.getS3Key()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.NotificationFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotificationFilterProperty.Jsii$Proxy that = (NotificationFilterProperty.Jsii$Proxy) o;

                return this.s3Key.equals(that.s3Key);
            }

            @Override
            public int hashCode() {
                int result = this.s3Key.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockconfiguration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ObjectLockConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ObjectLockConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ObjectLockConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.ObjectLockConfigurationProperty.ObjectLockEnabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockconfiguration.html#cfn-s3-bucket-objectlockconfiguration-objectlockenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObjectLockEnabled() {
            return null;
        }

        /**
         * `CfnBucket.ObjectLockConfigurationProperty.Rule`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockconfiguration.html#cfn-s3-bucket-objectlockconfiguration-rule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRule() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ObjectLockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ObjectLockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ObjectLockConfigurationProperty> {
            private java.lang.String objectLockEnabled;
            private java.lang.Object rule;

            /**
             * Sets the value of {@link ObjectLockConfigurationProperty#getObjectLockEnabled}
             * @param objectLockEnabled `CfnBucket.ObjectLockConfigurationProperty.ObjectLockEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectLockEnabled(java.lang.String objectLockEnabled) {
                this.objectLockEnabled = objectLockEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ObjectLockConfigurationProperty#getRule}
             * @param rule `CfnBucket.ObjectLockConfigurationProperty.Rule`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rule(software.amazon.awscdk.core.IResolvable rule) {
                this.rule = rule;
                return this;
            }

            /**
             * Sets the value of {@link ObjectLockConfigurationProperty#getRule}
             * @param rule `CfnBucket.ObjectLockConfigurationProperty.Rule`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rule(software.amazon.awscdk.services.s3.CfnBucket.ObjectLockRuleProperty rule) {
                this.rule = rule;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObjectLockConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ObjectLockConfigurationProperty build() {
                return new Jsii$Proxy(objectLockEnabled, rule);
            }
        }

        /**
         * An implementation for {@link ObjectLockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObjectLockConfigurationProperty {
            private final java.lang.String objectLockEnabled;
            private final java.lang.Object rule;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.objectLockEnabled = this.jsiiGet("objectLockEnabled", java.lang.String.class);
                this.rule = this.jsiiGet("rule", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String objectLockEnabled, final java.lang.Object rule) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.objectLockEnabled = objectLockEnabled;
                this.rule = rule;
            }

            @Override
            public java.lang.String getObjectLockEnabled() {
                return this.objectLockEnabled;
            }

            @Override
            public java.lang.Object getRule() {
                return this.rule;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getObjectLockEnabled() != null) {
                    data.set("objectLockEnabled", om.valueToTree(this.getObjectLockEnabled()));
                }
                if (this.getRule() != null) {
                    data.set("rule", om.valueToTree(this.getRule()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ObjectLockConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ObjectLockConfigurationProperty.Jsii$Proxy that = (ObjectLockConfigurationProperty.Jsii$Proxy) o;

                if (this.objectLockEnabled != null ? !this.objectLockEnabled.equals(that.objectLockEnabled) : that.objectLockEnabled != null) return false;
                return this.rule != null ? this.rule.equals(that.rule) : that.rule == null;
            }

            @Override
            public int hashCode() {
                int result = this.objectLockEnabled != null ? this.objectLockEnabled.hashCode() : 0;
                result = 31 * result + (this.rule != null ? this.rule.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockrule.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ObjectLockRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(ObjectLockRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ObjectLockRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.ObjectLockRuleProperty.DefaultRetention`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockrule.html#cfn-s3-bucket-objectlockrule-defaultretention
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultRetention() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ObjectLockRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ObjectLockRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ObjectLockRuleProperty> {
            private java.lang.Object defaultRetention;

            /**
             * Sets the value of {@link ObjectLockRuleProperty#getDefaultRetention}
             * @param defaultRetention `CfnBucket.ObjectLockRuleProperty.DefaultRetention`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultRetention(software.amazon.awscdk.core.IResolvable defaultRetention) {
                this.defaultRetention = defaultRetention;
                return this;
            }

            /**
             * Sets the value of {@link ObjectLockRuleProperty#getDefaultRetention}
             * @param defaultRetention `CfnBucket.ObjectLockRuleProperty.DefaultRetention`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultRetention(software.amazon.awscdk.services.s3.CfnBucket.DefaultRetentionProperty defaultRetention) {
                this.defaultRetention = defaultRetention;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObjectLockRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ObjectLockRuleProperty build() {
                return new Jsii$Proxy(defaultRetention);
            }
        }

        /**
         * An implementation for {@link ObjectLockRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObjectLockRuleProperty {
            private final java.lang.Object defaultRetention;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultRetention = this.jsiiGet("defaultRetention", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object defaultRetention) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultRetention = defaultRetention;
            }

            @Override
            public java.lang.Object getDefaultRetention() {
                return this.defaultRetention;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefaultRetention() != null) {
                    data.set("defaultRetention", om.valueToTree(this.getDefaultRetention()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ObjectLockRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ObjectLockRuleProperty.Jsii$Proxy that = (ObjectLockRuleProperty.Jsii$Proxy) o;

                return this.defaultRetention != null ? this.defaultRetention.equals(that.defaultRetention) : that.defaultRetention == null;
            }

            @Override
            public int hashCode() {
                int result = this.defaultRetention != null ? this.defaultRetention.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.PublicAccessBlockConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PublicAccessBlockConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PublicAccessBlockConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicacls
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlockPublicAcls() {
            return null;
        }

        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicpolicy
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlockPublicPolicy() {
            return null;
        }

        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-ignorepublicacls
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIgnorePublicAcls() {
            return null;
        }

        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-restrictpublicbuckets
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRestrictPublicBuckets() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PublicAccessBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PublicAccessBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PublicAccessBlockConfigurationProperty> {
            private java.lang.Object blockPublicAcls;
            private java.lang.Object blockPublicPolicy;
            private java.lang.Object ignorePublicAcls;
            private java.lang.Object restrictPublicBuckets;

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getBlockPublicAcls}
             * @param blockPublicAcls `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockPublicAcls(java.lang.Boolean blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getBlockPublicAcls}
             * @param blockPublicAcls `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockPublicAcls(software.amazon.awscdk.core.IResolvable blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getBlockPublicPolicy}
             * @param blockPublicPolicy `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockPublicPolicy(java.lang.Boolean blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getBlockPublicPolicy}
             * @param blockPublicPolicy `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockPublicPolicy(software.amazon.awscdk.core.IResolvable blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getIgnorePublicAcls}
             * @param ignorePublicAcls `CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignorePublicAcls(java.lang.Boolean ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getIgnorePublicAcls}
             * @param ignorePublicAcls `CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignorePublicAcls(software.amazon.awscdk.core.IResolvable ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getRestrictPublicBuckets}
             * @param restrictPublicBuckets `CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictPublicBuckets(java.lang.Boolean restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getRestrictPublicBuckets}
             * @param restrictPublicBuckets `CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictPublicBuckets(software.amazon.awscdk.core.IResolvable restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PublicAccessBlockConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PublicAccessBlockConfigurationProperty build() {
                return new Jsii$Proxy(blockPublicAcls, blockPublicPolicy, ignorePublicAcls, restrictPublicBuckets);
            }
        }

        /**
         * An implementation for {@link PublicAccessBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublicAccessBlockConfigurationProperty {
            private final java.lang.Object blockPublicAcls;
            private final java.lang.Object blockPublicPolicy;
            private final java.lang.Object ignorePublicAcls;
            private final java.lang.Object restrictPublicBuckets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blockPublicAcls = this.jsiiGet("blockPublicAcls", java.lang.Object.class);
                this.blockPublicPolicy = this.jsiiGet("blockPublicPolicy", java.lang.Object.class);
                this.ignorePublicAcls = this.jsiiGet("ignorePublicAcls", java.lang.Object.class);
                this.restrictPublicBuckets = this.jsiiGet("restrictPublicBuckets", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object blockPublicAcls, final java.lang.Object blockPublicPolicy, final java.lang.Object ignorePublicAcls, final java.lang.Object restrictPublicBuckets) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blockPublicAcls = blockPublicAcls;
                this.blockPublicPolicy = blockPublicPolicy;
                this.ignorePublicAcls = ignorePublicAcls;
                this.restrictPublicBuckets = restrictPublicBuckets;
            }

            @Override
            public java.lang.Object getBlockPublicAcls() {
                return this.blockPublicAcls;
            }

            @Override
            public java.lang.Object getBlockPublicPolicy() {
                return this.blockPublicPolicy;
            }

            @Override
            public java.lang.Object getIgnorePublicAcls() {
                return this.ignorePublicAcls;
            }

            @Override
            public java.lang.Object getRestrictPublicBuckets() {
                return this.restrictPublicBuckets;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlockPublicAcls() != null) {
                    data.set("blockPublicAcls", om.valueToTree(this.getBlockPublicAcls()));
                }
                if (this.getBlockPublicPolicy() != null) {
                    data.set("blockPublicPolicy", om.valueToTree(this.getBlockPublicPolicy()));
                }
                if (this.getIgnorePublicAcls() != null) {
                    data.set("ignorePublicAcls", om.valueToTree(this.getIgnorePublicAcls()));
                }
                if (this.getRestrictPublicBuckets() != null) {
                    data.set("restrictPublicBuckets", om.valueToTree(this.getRestrictPublicBuckets()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.PublicAccessBlockConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PublicAccessBlockConfigurationProperty.Jsii$Proxy that = (PublicAccessBlockConfigurationProperty.Jsii$Proxy) o;

                if (this.blockPublicAcls != null ? !this.blockPublicAcls.equals(that.blockPublicAcls) : that.blockPublicAcls != null) return false;
                if (this.blockPublicPolicy != null ? !this.blockPublicPolicy.equals(that.blockPublicPolicy) : that.blockPublicPolicy != null) return false;
                if (this.ignorePublicAcls != null ? !this.ignorePublicAcls.equals(that.ignorePublicAcls) : that.ignorePublicAcls != null) return false;
                return this.restrictPublicBuckets != null ? this.restrictPublicBuckets.equals(that.restrictPublicBuckets) : that.restrictPublicBuckets == null;
            }

            @Override
            public int hashCode() {
                int result = this.blockPublicAcls != null ? this.blockPublicAcls.hashCode() : 0;
                result = 31 * result + (this.blockPublicPolicy != null ? this.blockPublicPolicy.hashCode() : 0);
                result = 31 * result + (this.ignorePublicAcls != null ? this.ignorePublicAcls.hashCode() : 0);
                result = 31 * result + (this.restrictPublicBuckets != null ? this.restrictPublicBuckets.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.QueueConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(QueueConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueueConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.QueueConfigurationProperty.Event`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEvent();

        /**
         * `CfnBucket.QueueConfigurationProperty.Queue`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQueue();

        /**
         * `CfnBucket.QueueConfigurationProperty.Filter`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link QueueConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueueConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QueueConfigurationProperty> {
            private java.lang.String event;
            private java.lang.String queue;
            private java.lang.Object filter;

            /**
             * Sets the value of {@link QueueConfigurationProperty#getEvent}
             * @param event `CfnBucket.QueueConfigurationProperty.Event`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder event(java.lang.String event) {
                this.event = event;
                return this;
            }

            /**
             * Sets the value of {@link QueueConfigurationProperty#getQueue}
             * @param queue `CfnBucket.QueueConfigurationProperty.Queue`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queue(java.lang.String queue) {
                this.queue = queue;
                return this;
            }

            /**
             * Sets the value of {@link QueueConfigurationProperty#getFilter}
             * @param filter `CfnBucket.QueueConfigurationProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.core.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link QueueConfigurationProperty#getFilter}
             * @param filter `CfnBucket.QueueConfigurationProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueueConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QueueConfigurationProperty build() {
                return new Jsii$Proxy(event, queue, filter);
            }
        }

        /**
         * An implementation for {@link QueueConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueueConfigurationProperty {
            private final java.lang.String event;
            private final java.lang.String queue;
            private final java.lang.Object filter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.event = this.jsiiGet("event", java.lang.String.class);
                this.queue = this.jsiiGet("queue", java.lang.String.class);
                this.filter = this.jsiiGet("filter", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String event, final java.lang.String queue, final java.lang.Object filter) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.event = java.util.Objects.requireNonNull(event, "event is required");
                this.queue = java.util.Objects.requireNonNull(queue, "queue is required");
                this.filter = filter;
            }

            @Override
            public java.lang.String getEvent() {
                return this.event;
            }

            @Override
            public java.lang.String getQueue() {
                return this.queue;
            }

            @Override
            public java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("event", om.valueToTree(this.getEvent()));
                data.set("queue", om.valueToTree(this.getQueue()));
                if (this.getFilter() != null) {
                    data.set("filter", om.valueToTree(this.getFilter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.QueueConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueueConfigurationProperty.Jsii$Proxy that = (QueueConfigurationProperty.Jsii$Proxy) o;

                if (!event.equals(that.event)) return false;
                if (!queue.equals(that.queue)) return false;
                return this.filter != null ? this.filter.equals(that.filter) : that.filter == null;
            }

            @Override
            public int hashCode() {
                int result = this.event.hashCode();
                result = 31 * result + (this.queue.hashCode());
                result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.RedirectAllRequestsToProperty")
    @software.amazon.jsii.Jsii.Proxy(RedirectAllRequestsToProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedirectAllRequestsToProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.RedirectAllRequestsToProperty.HostName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHostName();

        /**
         * `CfnBucket.RedirectAllRequestsToProperty.Protocol`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedirectAllRequestsToProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedirectAllRequestsToProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedirectAllRequestsToProperty> {
            private java.lang.String hostName;
            private java.lang.String protocol;

            /**
             * Sets the value of {@link RedirectAllRequestsToProperty#getHostName}
             * @param hostName `CfnBucket.RedirectAllRequestsToProperty.HostName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostName(java.lang.String hostName) {
                this.hostName = hostName;
                return this;
            }

            /**
             * Sets the value of {@link RedirectAllRequestsToProperty#getProtocol}
             * @param protocol `CfnBucket.RedirectAllRequestsToProperty.Protocol`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedirectAllRequestsToProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedirectAllRequestsToProperty build() {
                return new Jsii$Proxy(hostName, protocol);
            }
        }

        /**
         * An implementation for {@link RedirectAllRequestsToProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedirectAllRequestsToProperty {
            private final java.lang.String hostName;
            private final java.lang.String protocol;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hostName = this.jsiiGet("hostName", java.lang.String.class);
                this.protocol = this.jsiiGet("protocol", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String hostName, final java.lang.String protocol) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hostName = java.util.Objects.requireNonNull(hostName, "hostName is required");
                this.protocol = protocol;
            }

            @Override
            public java.lang.String getHostName() {
                return this.hostName;
            }

            @Override
            public java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("hostName", om.valueToTree(this.getHostName()));
                if (this.getProtocol() != null) {
                    data.set("protocol", om.valueToTree(this.getProtocol()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.RedirectAllRequestsToProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedirectAllRequestsToProperty.Jsii$Proxy that = (RedirectAllRequestsToProperty.Jsii$Proxy) o;

                if (!hostName.equals(that.hostName)) return false;
                return this.protocol != null ? this.protocol.equals(that.protocol) : that.protocol == null;
            }

            @Override
            public int hashCode() {
                int result = this.hostName.hashCode();
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.RedirectRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(RedirectRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedirectRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.RedirectRuleProperty.HostName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostName() {
            return null;
        }

        /**
         * `CfnBucket.RedirectRuleProperty.HttpRedirectCode`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpRedirectCode() {
            return null;
        }

        /**
         * `CfnBucket.RedirectRuleProperty.Protocol`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
            return null;
        }

        /**
         * `CfnBucket.RedirectRuleProperty.ReplaceKeyPrefixWith`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReplaceKeyPrefixWith() {
            return null;
        }

        /**
         * `CfnBucket.RedirectRuleProperty.ReplaceKeyWith`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReplaceKeyWith() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedirectRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedirectRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedirectRuleProperty> {
            private java.lang.String hostName;
            private java.lang.String httpRedirectCode;
            private java.lang.String protocol;
            private java.lang.String replaceKeyPrefixWith;
            private java.lang.String replaceKeyWith;

            /**
             * Sets the value of {@link RedirectRuleProperty#getHostName}
             * @param hostName `CfnBucket.RedirectRuleProperty.HostName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostName(java.lang.String hostName) {
                this.hostName = hostName;
                return this;
            }

            /**
             * Sets the value of {@link RedirectRuleProperty#getHttpRedirectCode}
             * @param httpRedirectCode `CfnBucket.RedirectRuleProperty.HttpRedirectCode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpRedirectCode(java.lang.String httpRedirectCode) {
                this.httpRedirectCode = httpRedirectCode;
                return this;
            }

            /**
             * Sets the value of {@link RedirectRuleProperty#getProtocol}
             * @param protocol `CfnBucket.RedirectRuleProperty.Protocol`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link RedirectRuleProperty#getReplaceKeyPrefixWith}
             * @param replaceKeyPrefixWith `CfnBucket.RedirectRuleProperty.ReplaceKeyPrefixWith`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replaceKeyPrefixWith(java.lang.String replaceKeyPrefixWith) {
                this.replaceKeyPrefixWith = replaceKeyPrefixWith;
                return this;
            }

            /**
             * Sets the value of {@link RedirectRuleProperty#getReplaceKeyWith}
             * @param replaceKeyWith `CfnBucket.RedirectRuleProperty.ReplaceKeyWith`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replaceKeyWith(java.lang.String replaceKeyWith) {
                this.replaceKeyWith = replaceKeyWith;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedirectRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedirectRuleProperty build() {
                return new Jsii$Proxy(hostName, httpRedirectCode, protocol, replaceKeyPrefixWith, replaceKeyWith);
            }
        }

        /**
         * An implementation for {@link RedirectRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedirectRuleProperty {
            private final java.lang.String hostName;
            private final java.lang.String httpRedirectCode;
            private final java.lang.String protocol;
            private final java.lang.String replaceKeyPrefixWith;
            private final java.lang.String replaceKeyWith;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hostName = this.jsiiGet("hostName", java.lang.String.class);
                this.httpRedirectCode = this.jsiiGet("httpRedirectCode", java.lang.String.class);
                this.protocol = this.jsiiGet("protocol", java.lang.String.class);
                this.replaceKeyPrefixWith = this.jsiiGet("replaceKeyPrefixWith", java.lang.String.class);
                this.replaceKeyWith = this.jsiiGet("replaceKeyWith", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String hostName, final java.lang.String httpRedirectCode, final java.lang.String protocol, final java.lang.String replaceKeyPrefixWith, final java.lang.String replaceKeyWith) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hostName = hostName;
                this.httpRedirectCode = httpRedirectCode;
                this.protocol = protocol;
                this.replaceKeyPrefixWith = replaceKeyPrefixWith;
                this.replaceKeyWith = replaceKeyWith;
            }

            @Override
            public java.lang.String getHostName() {
                return this.hostName;
            }

            @Override
            public java.lang.String getHttpRedirectCode() {
                return this.httpRedirectCode;
            }

            @Override
            public java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public java.lang.String getReplaceKeyPrefixWith() {
                return this.replaceKeyPrefixWith;
            }

            @Override
            public java.lang.String getReplaceKeyWith() {
                return this.replaceKeyWith;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHostName() != null) {
                    data.set("hostName", om.valueToTree(this.getHostName()));
                }
                if (this.getHttpRedirectCode() != null) {
                    data.set("httpRedirectCode", om.valueToTree(this.getHttpRedirectCode()));
                }
                if (this.getProtocol() != null) {
                    data.set("protocol", om.valueToTree(this.getProtocol()));
                }
                if (this.getReplaceKeyPrefixWith() != null) {
                    data.set("replaceKeyPrefixWith", om.valueToTree(this.getReplaceKeyPrefixWith()));
                }
                if (this.getReplaceKeyWith() != null) {
                    data.set("replaceKeyWith", om.valueToTree(this.getReplaceKeyWith()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.RedirectRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedirectRuleProperty.Jsii$Proxy that = (RedirectRuleProperty.Jsii$Proxy) o;

                if (this.hostName != null ? !this.hostName.equals(that.hostName) : that.hostName != null) return false;
                if (this.httpRedirectCode != null ? !this.httpRedirectCode.equals(that.httpRedirectCode) : that.httpRedirectCode != null) return false;
                if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
                if (this.replaceKeyPrefixWith != null ? !this.replaceKeyPrefixWith.equals(that.replaceKeyPrefixWith) : that.replaceKeyPrefixWith != null) return false;
                return this.replaceKeyWith != null ? this.replaceKeyWith.equals(that.replaceKeyWith) : that.replaceKeyWith == null;
            }

            @Override
            public int hashCode() {
                int result = this.hostName != null ? this.hostName.hashCode() : 0;
                result = 31 * result + (this.httpRedirectCode != null ? this.httpRedirectCode.hashCode() : 0);
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                result = 31 * result + (this.replaceKeyPrefixWith != null ? this.replaceKeyPrefixWith.hashCode() : 0);
                result = 31 * result + (this.replaceKeyWith != null ? this.replaceKeyWith.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ReplicationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.ReplicationConfigurationProperty.Role`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRole();

        /**
         * `CfnBucket.ReplicationConfigurationProperty.Rules`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link ReplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicationConfigurationProperty> {
            private java.lang.String role;
            private java.lang.Object rules;

            /**
             * Sets the value of {@link ReplicationConfigurationProperty#getRole}
             * @param role `CfnBucket.ReplicationConfigurationProperty.Role`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder role(java.lang.String role) {
                this.role = role;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationConfigurationProperty#getRules}
             * @param rules `CfnBucket.ReplicationConfigurationProperty.Rules`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(software.amazon.awscdk.core.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationConfigurationProperty#getRules}
             * @param rules `CfnBucket.ReplicationConfigurationProperty.Rules`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(java.util.List<java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicationConfigurationProperty build() {
                return new Jsii$Proxy(role, rules);
            }
        }

        /**
         * An implementation for {@link ReplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationConfigurationProperty {
            private final java.lang.String role;
            private final java.lang.Object rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.role = this.jsiiGet("role", java.lang.String.class);
                this.rules = this.jsiiGet("rules", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String role, final java.lang.Object rules) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.role = java.util.Objects.requireNonNull(role, "role is required");
                this.rules = java.util.Objects.requireNonNull(rules, "rules is required");
            }

            @Override
            public java.lang.String getRole() {
                return this.role;
            }

            @Override
            public java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("role", om.valueToTree(this.getRole()));
                data.set("rules", om.valueToTree(this.getRules()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ReplicationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationConfigurationProperty.Jsii$Proxy that = (ReplicationConfigurationProperty.Jsii$Proxy) o;

                if (!role.equals(that.role)) return false;
                return this.rules.equals(that.rules);
            }

            @Override
            public int hashCode() {
                int result = this.role.hashCode();
                result = 31 * result + (this.rules.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ReplicationDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicationDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.ReplicationDestinationProperty.Bucket`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * `CfnBucket.ReplicationDestinationProperty.AccessControlTranslation`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAccessControlTranslation() {
            return null;
        }

        /**
         * `CfnBucket.ReplicationDestinationProperty.Account`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccount() {
            return null;
        }

        /**
         * `CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
            return null;
        }

        /**
         * `CfnBucket.ReplicationDestinationProperty.Metrics`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-metrics
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetrics() {
            return null;
        }

        /**
         * `CfnBucket.ReplicationDestinationProperty.ReplicationTime`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-replicationtime
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReplicationTime() {
            return null;
        }

        /**
         * `CfnBucket.ReplicationDestinationProperty.StorageClass`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStorageClass() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReplicationDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicationDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicationDestinationProperty> {
            private java.lang.String bucket;
            private java.lang.Object accessControlTranslation;
            private java.lang.String account;
            private java.lang.Object encryptionConfiguration;
            private java.lang.Object metrics;
            private java.lang.Object replicationTime;
            private java.lang.String storageClass;

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getBucket}
             * @param bucket `CfnBucket.ReplicationDestinationProperty.Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getAccessControlTranslation}
             * @param accessControlTranslation `CfnBucket.ReplicationDestinationProperty.AccessControlTranslation`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessControlTranslation(software.amazon.awscdk.core.IResolvable accessControlTranslation) {
                this.accessControlTranslation = accessControlTranslation;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getAccessControlTranslation}
             * @param accessControlTranslation `CfnBucket.ReplicationDestinationProperty.AccessControlTranslation`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessControlTranslation(software.amazon.awscdk.services.s3.CfnBucket.AccessControlTranslationProperty accessControlTranslation) {
                this.accessControlTranslation = accessControlTranslation;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getAccount}
             * @param account `CfnBucket.ReplicationDestinationProperty.Account`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder account(java.lang.String account) {
                this.account = account;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration `CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.core.IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration `CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.services.s3.CfnBucket.EncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getMetrics}
             * @param metrics `CfnBucket.ReplicationDestinationProperty.Metrics`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metrics(software.amazon.awscdk.core.IResolvable metrics) {
                this.metrics = metrics;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getMetrics}
             * @param metrics `CfnBucket.ReplicationDestinationProperty.Metrics`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metrics(software.amazon.awscdk.services.s3.CfnBucket.MetricsProperty metrics) {
                this.metrics = metrics;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getReplicationTime}
             * @param replicationTime `CfnBucket.ReplicationDestinationProperty.ReplicationTime`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replicationTime(software.amazon.awscdk.core.IResolvable replicationTime) {
                this.replicationTime = replicationTime;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getReplicationTime}
             * @param replicationTime `CfnBucket.ReplicationDestinationProperty.ReplicationTime`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replicationTime(software.amazon.awscdk.services.s3.CfnBucket.ReplicationTimeProperty replicationTime) {
                this.replicationTime = replicationTime;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getStorageClass}
             * @param storageClass `CfnBucket.ReplicationDestinationProperty.StorageClass`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageClass(java.lang.String storageClass) {
                this.storageClass = storageClass;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicationDestinationProperty build() {
                return new Jsii$Proxy(bucket, accessControlTranslation, account, encryptionConfiguration, metrics, replicationTime, storageClass);
            }
        }

        /**
         * An implementation for {@link ReplicationDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationDestinationProperty {
            private final java.lang.String bucket;
            private final java.lang.Object accessControlTranslation;
            private final java.lang.String account;
            private final java.lang.Object encryptionConfiguration;
            private final java.lang.Object metrics;
            private final java.lang.Object replicationTime;
            private final java.lang.String storageClass;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = this.jsiiGet("bucket", java.lang.String.class);
                this.accessControlTranslation = this.jsiiGet("accessControlTranslation", java.lang.Object.class);
                this.account = this.jsiiGet("account", java.lang.String.class);
                this.encryptionConfiguration = this.jsiiGet("encryptionConfiguration", java.lang.Object.class);
                this.metrics = this.jsiiGet("metrics", java.lang.Object.class);
                this.replicationTime = this.jsiiGet("replicationTime", java.lang.Object.class);
                this.storageClass = this.jsiiGet("storageClass", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String bucket, final java.lang.Object accessControlTranslation, final java.lang.String account, final java.lang.Object encryptionConfiguration, final java.lang.Object metrics, final java.lang.Object replicationTime, final java.lang.String storageClass) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(bucket, "bucket is required");
                this.accessControlTranslation = accessControlTranslation;
                this.account = account;
                this.encryptionConfiguration = encryptionConfiguration;
                this.metrics = metrics;
                this.replicationTime = replicationTime;
                this.storageClass = storageClass;
            }

            @Override
            public java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public java.lang.Object getAccessControlTranslation() {
                return this.accessControlTranslation;
            }

            @Override
            public java.lang.String getAccount() {
                return this.account;
            }

            @Override
            public java.lang.Object getEncryptionConfiguration() {
                return this.encryptionConfiguration;
            }

            @Override
            public java.lang.Object getMetrics() {
                return this.metrics;
            }

            @Override
            public java.lang.Object getReplicationTime() {
                return this.replicationTime;
            }

            @Override
            public java.lang.String getStorageClass() {
                return this.storageClass;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                if (this.getAccessControlTranslation() != null) {
                    data.set("accessControlTranslation", om.valueToTree(this.getAccessControlTranslation()));
                }
                if (this.getAccount() != null) {
                    data.set("account", om.valueToTree(this.getAccount()));
                }
                if (this.getEncryptionConfiguration() != null) {
                    data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
                }
                if (this.getMetrics() != null) {
                    data.set("metrics", om.valueToTree(this.getMetrics()));
                }
                if (this.getReplicationTime() != null) {
                    data.set("replicationTime", om.valueToTree(this.getReplicationTime()));
                }
                if (this.getStorageClass() != null) {
                    data.set("storageClass", om.valueToTree(this.getStorageClass()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ReplicationDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationDestinationProperty.Jsii$Proxy that = (ReplicationDestinationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (this.accessControlTranslation != null ? !this.accessControlTranslation.equals(that.accessControlTranslation) : that.accessControlTranslation != null) return false;
                if (this.account != null ? !this.account.equals(that.account) : that.account != null) return false;
                if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
                if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) return false;
                if (this.replicationTime != null ? !this.replicationTime.equals(that.replicationTime) : that.replicationTime != null) return false;
                return this.storageClass != null ? this.storageClass.equals(that.storageClass) : that.storageClass == null;
            }

            @Override
            public int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.accessControlTranslation != null ? this.accessControlTranslation.hashCode() : 0);
                result = 31 * result + (this.account != null ? this.account.hashCode() : 0);
                result = 31 * result + (this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0);
                result = 31 * result + (this.metrics != null ? this.metrics.hashCode() : 0);
                result = 31 * result + (this.replicationTime != null ? this.replicationTime.hashCode() : 0);
                result = 31 * result + (this.storageClass != null ? this.storageClass.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationruleandoperator.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ReplicationRuleAndOperatorProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicationRuleAndOperatorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationRuleAndOperatorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.ReplicationRuleAndOperatorProperty.Prefix`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationruleandoperator.html#cfn-s3-bucket-replicationruleandoperator-prefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * `CfnBucket.ReplicationRuleAndOperatorProperty.TagFilters`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationruleandoperator.html#cfn-s3-bucket-replicationruleandoperator-tagfilters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagFilters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReplicationRuleAndOperatorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicationRuleAndOperatorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicationRuleAndOperatorProperty> {
            private java.lang.String prefix;
            private java.lang.Object tagFilters;

            /**
             * Sets the value of {@link ReplicationRuleAndOperatorProperty#getPrefix}
             * @param prefix `CfnBucket.ReplicationRuleAndOperatorProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleAndOperatorProperty#getTagFilters}
             * @param tagFilters `CfnBucket.ReplicationRuleAndOperatorProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(software.amazon.awscdk.core.IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleAndOperatorProperty#getTagFilters}
             * @param tagFilters `CfnBucket.ReplicationRuleAndOperatorProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(java.util.List<java.lang.Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationRuleAndOperatorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicationRuleAndOperatorProperty build() {
                return new Jsii$Proxy(prefix, tagFilters);
            }
        }

        /**
         * An implementation for {@link ReplicationRuleAndOperatorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationRuleAndOperatorProperty {
            private final java.lang.String prefix;
            private final java.lang.Object tagFilters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.prefix = this.jsiiGet("prefix", java.lang.String.class);
                this.tagFilters = this.jsiiGet("tagFilters", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String prefix, final java.lang.Object tagFilters) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.prefix = prefix;
                this.tagFilters = tagFilters;
            }

            @Override
            public java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public java.lang.Object getTagFilters() {
                return this.tagFilters;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getTagFilters() != null) {
                    data.set("tagFilters", om.valueToTree(this.getTagFilters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ReplicationRuleAndOperatorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationRuleAndOperatorProperty.Jsii$Proxy that = (ReplicationRuleAndOperatorProperty.Jsii$Proxy) o;

                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                return this.tagFilters != null ? this.tagFilters.equals(that.tagFilters) : that.tagFilters == null;
            }

            @Override
            public int hashCode() {
                int result = this.prefix != null ? this.prefix.hashCode() : 0;
                result = 31 * result + (this.tagFilters != null ? this.tagFilters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationrulefilter.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ReplicationRuleFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicationRuleFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationRuleFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.ReplicationRuleFilterProperty.And`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationrulefilter.html#cfn-s3-bucket-replicationrulefilter-and
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAnd() {
            return null;
        }

        /**
         * `CfnBucket.ReplicationRuleFilterProperty.Prefix`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationrulefilter.html#cfn-s3-bucket-replicationrulefilter-prefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * `CfnBucket.ReplicationRuleFilterProperty.TagFilter`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationrulefilter.html#cfn-s3-bucket-replicationrulefilter-tagfilter
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagFilter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReplicationRuleFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicationRuleFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicationRuleFilterProperty> {
            private java.lang.Object and;
            private java.lang.String prefix;
            private java.lang.Object tagFilter;

            /**
             * Sets the value of {@link ReplicationRuleFilterProperty#getAnd}
             * @param and `CfnBucket.ReplicationRuleFilterProperty.And`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder and(software.amazon.awscdk.core.IResolvable and) {
                this.and = and;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleFilterProperty#getAnd}
             * @param and `CfnBucket.ReplicationRuleFilterProperty.And`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder and(software.amazon.awscdk.services.s3.CfnBucket.ReplicationRuleAndOperatorProperty and) {
                this.and = and;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleFilterProperty#getPrefix}
             * @param prefix `CfnBucket.ReplicationRuleFilterProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleFilterProperty#getTagFilter}
             * @param tagFilter `CfnBucket.ReplicationRuleFilterProperty.TagFilter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilter(software.amazon.awscdk.core.IResolvable tagFilter) {
                this.tagFilter = tagFilter;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleFilterProperty#getTagFilter}
             * @param tagFilter `CfnBucket.ReplicationRuleFilterProperty.TagFilter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilter(software.amazon.awscdk.services.s3.CfnBucket.TagFilterProperty tagFilter) {
                this.tagFilter = tagFilter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationRuleFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicationRuleFilterProperty build() {
                return new Jsii$Proxy(and, prefix, tagFilter);
            }
        }

        /**
         * An implementation for {@link ReplicationRuleFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationRuleFilterProperty {
            private final java.lang.Object and;
            private final java.lang.String prefix;
            private final java.lang.Object tagFilter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.and = this.jsiiGet("and", java.lang.Object.class);
                this.prefix = this.jsiiGet("prefix", java.lang.String.class);
                this.tagFilter = this.jsiiGet("tagFilter", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object and, final java.lang.String prefix, final java.lang.Object tagFilter) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.and = and;
                this.prefix = prefix;
                this.tagFilter = tagFilter;
            }

            @Override
            public java.lang.Object getAnd() {
                return this.and;
            }

            @Override
            public java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public java.lang.Object getTagFilter() {
                return this.tagFilter;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAnd() != null) {
                    data.set("and", om.valueToTree(this.getAnd()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getTagFilter() != null) {
                    data.set("tagFilter", om.valueToTree(this.getTagFilter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ReplicationRuleFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationRuleFilterProperty.Jsii$Proxy that = (ReplicationRuleFilterProperty.Jsii$Proxy) o;

                if (this.and != null ? !this.and.equals(that.and) : that.and != null) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                return this.tagFilter != null ? this.tagFilter.equals(that.tagFilter) : that.tagFilter == null;
            }

            @Override
            public int hashCode() {
                int result = this.and != null ? this.and.hashCode() : 0;
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.tagFilter != null ? this.tagFilter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ReplicationRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicationRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.ReplicationRuleProperty.Destination`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestination();

        /**
         * `CfnBucket.ReplicationRuleProperty.Status`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * `CfnBucket.ReplicationRuleProperty.DeleteMarkerReplication`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-deletemarkerreplication
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteMarkerReplication() {
            return null;
        }

        /**
         * `CfnBucket.ReplicationRuleProperty.Filter`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-filter
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilter() {
            return null;
        }

        /**
         * `CfnBucket.ReplicationRuleProperty.Id`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId() {
            return null;
        }

        /**
         * `CfnBucket.ReplicationRuleProperty.Prefix`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * `CfnBucket.ReplicationRuleProperty.Priority`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-priority
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
            return null;
        }

        /**
         * `CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourceSelectionCriteria() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReplicationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicationRuleProperty> {
            private java.lang.Object destination;
            private java.lang.String status;
            private java.lang.Object deleteMarkerReplication;
            private java.lang.Object filter;
            private java.lang.String id;
            private java.lang.String prefix;
            private java.lang.Number priority;
            private java.lang.Object sourceSelectionCriteria;

            /**
             * Sets the value of {@link ReplicationRuleProperty#getDestination}
             * @param destination `CfnBucket.ReplicationRuleProperty.Destination`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.core.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getDestination}
             * @param destination `CfnBucket.ReplicationRuleProperty.Destination`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.services.s3.CfnBucket.ReplicationDestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getStatus}
             * @param status `CfnBucket.ReplicationRuleProperty.Status`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getDeleteMarkerReplication}
             * @param deleteMarkerReplication `CfnBucket.ReplicationRuleProperty.DeleteMarkerReplication`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteMarkerReplication(software.amazon.awscdk.core.IResolvable deleteMarkerReplication) {
                this.deleteMarkerReplication = deleteMarkerReplication;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getDeleteMarkerReplication}
             * @param deleteMarkerReplication `CfnBucket.ReplicationRuleProperty.DeleteMarkerReplication`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteMarkerReplication(software.amazon.awscdk.services.s3.CfnBucket.DeleteMarkerReplicationProperty deleteMarkerReplication) {
                this.deleteMarkerReplication = deleteMarkerReplication;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getFilter}
             * @param filter `CfnBucket.ReplicationRuleProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.core.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getFilter}
             * @param filter `CfnBucket.ReplicationRuleProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.services.s3.CfnBucket.ReplicationRuleFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getId}
             * @param id `CfnBucket.ReplicationRuleProperty.Id`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getPrefix}
             * @param prefix `CfnBucket.ReplicationRuleProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getPriority}
             * @param priority `CfnBucket.ReplicationRuleProperty.Priority`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getSourceSelectionCriteria}
             * @param sourceSelectionCriteria `CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceSelectionCriteria(software.amazon.awscdk.core.IResolvable sourceSelectionCriteria) {
                this.sourceSelectionCriteria = sourceSelectionCriteria;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationRuleProperty#getSourceSelectionCriteria}
             * @param sourceSelectionCriteria `CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceSelectionCriteria(software.amazon.awscdk.services.s3.CfnBucket.SourceSelectionCriteriaProperty sourceSelectionCriteria) {
                this.sourceSelectionCriteria = sourceSelectionCriteria;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicationRuleProperty build() {
                return new Jsii$Proxy(destination, status, deleteMarkerReplication, filter, id, prefix, priority, sourceSelectionCriteria);
            }
        }

        /**
         * An implementation for {@link ReplicationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationRuleProperty {
            private final java.lang.Object destination;
            private final java.lang.String status;
            private final java.lang.Object deleteMarkerReplication;
            private final java.lang.Object filter;
            private final java.lang.String id;
            private final java.lang.String prefix;
            private final java.lang.Number priority;
            private final java.lang.Object sourceSelectionCriteria;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = this.jsiiGet("destination", java.lang.Object.class);
                this.status = this.jsiiGet("status", java.lang.String.class);
                this.deleteMarkerReplication = this.jsiiGet("deleteMarkerReplication", java.lang.Object.class);
                this.filter = this.jsiiGet("filter", java.lang.Object.class);
                this.id = this.jsiiGet("id", java.lang.String.class);
                this.prefix = this.jsiiGet("prefix", java.lang.String.class);
                this.priority = this.jsiiGet("priority", java.lang.Number.class);
                this.sourceSelectionCriteria = this.jsiiGet("sourceSelectionCriteria", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object destination, final java.lang.String status, final java.lang.Object deleteMarkerReplication, final java.lang.Object filter, final java.lang.String id, final java.lang.String prefix, final java.lang.Number priority, final java.lang.Object sourceSelectionCriteria) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(destination, "destination is required");
                this.status = java.util.Objects.requireNonNull(status, "status is required");
                this.deleteMarkerReplication = deleteMarkerReplication;
                this.filter = filter;
                this.id = id;
                this.prefix = prefix;
                this.priority = priority;
                this.sourceSelectionCriteria = sourceSelectionCriteria;
            }

            @Override
            public java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public java.lang.Object getDeleteMarkerReplication() {
                return this.deleteMarkerReplication;
            }

            @Override
            public java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            public java.lang.String getId() {
                return this.id;
            }

            @Override
            public java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            public java.lang.Object getSourceSelectionCriteria() {
                return this.sourceSelectionCriteria;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destination", om.valueToTree(this.getDestination()));
                data.set("status", om.valueToTree(this.getStatus()));
                if (this.getDeleteMarkerReplication() != null) {
                    data.set("deleteMarkerReplication", om.valueToTree(this.getDeleteMarkerReplication()));
                }
                if (this.getFilter() != null) {
                    data.set("filter", om.valueToTree(this.getFilter()));
                }
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getPriority() != null) {
                    data.set("priority", om.valueToTree(this.getPriority()));
                }
                if (this.getSourceSelectionCriteria() != null) {
                    data.set("sourceSelectionCriteria", om.valueToTree(this.getSourceSelectionCriteria()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ReplicationRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationRuleProperty.Jsii$Proxy that = (ReplicationRuleProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                if (!status.equals(that.status)) return false;
                if (this.deleteMarkerReplication != null ? !this.deleteMarkerReplication.equals(that.deleteMarkerReplication) : that.deleteMarkerReplication != null) return false;
                if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
                return this.sourceSelectionCriteria != null ? this.sourceSelectionCriteria.equals(that.sourceSelectionCriteria) : that.sourceSelectionCriteria == null;
            }

            @Override
            public int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.status.hashCode());
                result = 31 * result + (this.deleteMarkerReplication != null ? this.deleteMarkerReplication.hashCode() : 0);
                result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
                result = 31 * result + (this.sourceSelectionCriteria != null ? this.sourceSelectionCriteria.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationtime.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ReplicationTimeProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicationTimeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationTimeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.ReplicationTimeProperty.Status`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationtime.html#cfn-s3-bucket-replicationtime-status
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * `CfnBucket.ReplicationTimeProperty.Time`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationtime.html#cfn-s3-bucket-replicationtime-time
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTime();

        /**
         * @return a {@link Builder} of {@link ReplicationTimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicationTimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicationTimeProperty> {
            private java.lang.String status;
            private java.lang.Object time;

            /**
             * Sets the value of {@link ReplicationTimeProperty#getStatus}
             * @param status `CfnBucket.ReplicationTimeProperty.Status`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationTimeProperty#getTime}
             * @param time `CfnBucket.ReplicationTimeProperty.Time`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder time(software.amazon.awscdk.core.IResolvable time) {
                this.time = time;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationTimeProperty#getTime}
             * @param time `CfnBucket.ReplicationTimeProperty.Time`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder time(software.amazon.awscdk.services.s3.CfnBucket.ReplicationTimeValueProperty time) {
                this.time = time;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationTimeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicationTimeProperty build() {
                return new Jsii$Proxy(status, time);
            }
        }

        /**
         * An implementation for {@link ReplicationTimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationTimeProperty {
            private final java.lang.String status;
            private final java.lang.Object time;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = this.jsiiGet("status", java.lang.String.class);
                this.time = this.jsiiGet("time", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String status, final java.lang.Object time) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(status, "status is required");
                this.time = java.util.Objects.requireNonNull(time, "time is required");
            }

            @Override
            public java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public java.lang.Object getTime() {
                return this.time;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));
                data.set("time", om.valueToTree(this.getTime()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ReplicationTimeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationTimeProperty.Jsii$Proxy that = (ReplicationTimeProperty.Jsii$Proxy) o;

                if (!status.equals(that.status)) return false;
                return this.time.equals(that.time);
            }

            @Override
            public int hashCode() {
                int result = this.status.hashCode();
                result = 31 * result + (this.time.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationtimevalue.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ReplicationTimeValueProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicationTimeValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationTimeValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.ReplicationTimeValueProperty.Minutes`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationtimevalue.html#cfn-s3-bucket-replicationtimevalue-minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinutes();

        /**
         * @return a {@link Builder} of {@link ReplicationTimeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicationTimeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicationTimeValueProperty> {
            private java.lang.Number minutes;

            /**
             * Sets the value of {@link ReplicationTimeValueProperty#getMinutes}
             * @param minutes `CfnBucket.ReplicationTimeValueProperty.Minutes`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minutes(java.lang.Number minutes) {
                this.minutes = minutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationTimeValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicationTimeValueProperty build() {
                return new Jsii$Proxy(minutes);
            }
        }

        /**
         * An implementation for {@link ReplicationTimeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationTimeValueProperty {
            private final java.lang.Number minutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.minutes = this.jsiiGet("minutes", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number minutes) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.minutes = java.util.Objects.requireNonNull(minutes, "minutes is required");
            }

            @Override
            public java.lang.Number getMinutes() {
                return this.minutes;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("minutes", om.valueToTree(this.getMinutes()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ReplicationTimeValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationTimeValueProperty.Jsii$Proxy that = (ReplicationTimeValueProperty.Jsii$Proxy) o;

                return this.minutes.equals(that.minutes);
            }

            @Override
            public int hashCode() {
                int result = this.minutes.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.RoutingRuleConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(RoutingRuleConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RoutingRuleConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpErrorCodeReturnedEquals() {
            return null;
        }

        /**
         * `CfnBucket.RoutingRuleConditionProperty.KeyPrefixEquals`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeyPrefixEquals() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RoutingRuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RoutingRuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RoutingRuleConditionProperty> {
            private java.lang.String httpErrorCodeReturnedEquals;
            private java.lang.String keyPrefixEquals;

            /**
             * Sets the value of {@link RoutingRuleConditionProperty#getHttpErrorCodeReturnedEquals}
             * @param httpErrorCodeReturnedEquals `CfnBucket.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpErrorCodeReturnedEquals(java.lang.String httpErrorCodeReturnedEquals) {
                this.httpErrorCodeReturnedEquals = httpErrorCodeReturnedEquals;
                return this;
            }

            /**
             * Sets the value of {@link RoutingRuleConditionProperty#getKeyPrefixEquals}
             * @param keyPrefixEquals `CfnBucket.RoutingRuleConditionProperty.KeyPrefixEquals`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyPrefixEquals(java.lang.String keyPrefixEquals) {
                this.keyPrefixEquals = keyPrefixEquals;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RoutingRuleConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RoutingRuleConditionProperty build() {
                return new Jsii$Proxy(httpErrorCodeReturnedEquals, keyPrefixEquals);
            }
        }

        /**
         * An implementation for {@link RoutingRuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RoutingRuleConditionProperty {
            private final java.lang.String httpErrorCodeReturnedEquals;
            private final java.lang.String keyPrefixEquals;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.httpErrorCodeReturnedEquals = this.jsiiGet("httpErrorCodeReturnedEquals", java.lang.String.class);
                this.keyPrefixEquals = this.jsiiGet("keyPrefixEquals", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String httpErrorCodeReturnedEquals, final java.lang.String keyPrefixEquals) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.httpErrorCodeReturnedEquals = httpErrorCodeReturnedEquals;
                this.keyPrefixEquals = keyPrefixEquals;
            }

            @Override
            public java.lang.String getHttpErrorCodeReturnedEquals() {
                return this.httpErrorCodeReturnedEquals;
            }

            @Override
            public java.lang.String getKeyPrefixEquals() {
                return this.keyPrefixEquals;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHttpErrorCodeReturnedEquals() != null) {
                    data.set("httpErrorCodeReturnedEquals", om.valueToTree(this.getHttpErrorCodeReturnedEquals()));
                }
                if (this.getKeyPrefixEquals() != null) {
                    data.set("keyPrefixEquals", om.valueToTree(this.getKeyPrefixEquals()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.RoutingRuleConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RoutingRuleConditionProperty.Jsii$Proxy that = (RoutingRuleConditionProperty.Jsii$Proxy) o;

                if (this.httpErrorCodeReturnedEquals != null ? !this.httpErrorCodeReturnedEquals.equals(that.httpErrorCodeReturnedEquals) : that.httpErrorCodeReturnedEquals != null) return false;
                return this.keyPrefixEquals != null ? this.keyPrefixEquals.equals(that.keyPrefixEquals) : that.keyPrefixEquals == null;
            }

            @Override
            public int hashCode() {
                int result = this.httpErrorCodeReturnedEquals != null ? this.httpErrorCodeReturnedEquals.hashCode() : 0;
                result = 31 * result + (this.keyPrefixEquals != null ? this.keyPrefixEquals.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.RoutingRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(RoutingRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RoutingRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.RoutingRuleProperty.RedirectRule`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRedirectRule();

        /**
         * `CfnBucket.RoutingRuleProperty.RoutingRuleCondition`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRoutingRuleCondition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RoutingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RoutingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RoutingRuleProperty> {
            private java.lang.Object redirectRule;
            private java.lang.Object routingRuleCondition;

            /**
             * Sets the value of {@link RoutingRuleProperty#getRedirectRule}
             * @param redirectRule `CfnBucket.RoutingRuleProperty.RedirectRule`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redirectRule(software.amazon.awscdk.core.IResolvable redirectRule) {
                this.redirectRule = redirectRule;
                return this;
            }

            /**
             * Sets the value of {@link RoutingRuleProperty#getRedirectRule}
             * @param redirectRule `CfnBucket.RoutingRuleProperty.RedirectRule`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redirectRule(software.amazon.awscdk.services.s3.CfnBucket.RedirectRuleProperty redirectRule) {
                this.redirectRule = redirectRule;
                return this;
            }

            /**
             * Sets the value of {@link RoutingRuleProperty#getRoutingRuleCondition}
             * @param routingRuleCondition `CfnBucket.RoutingRuleProperty.RoutingRuleCondition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routingRuleCondition(software.amazon.awscdk.core.IResolvable routingRuleCondition) {
                this.routingRuleCondition = routingRuleCondition;
                return this;
            }

            /**
             * Sets the value of {@link RoutingRuleProperty#getRoutingRuleCondition}
             * @param routingRuleCondition `CfnBucket.RoutingRuleProperty.RoutingRuleCondition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routingRuleCondition(software.amazon.awscdk.services.s3.CfnBucket.RoutingRuleConditionProperty routingRuleCondition) {
                this.routingRuleCondition = routingRuleCondition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RoutingRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RoutingRuleProperty build() {
                return new Jsii$Proxy(redirectRule, routingRuleCondition);
            }
        }

        /**
         * An implementation for {@link RoutingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RoutingRuleProperty {
            private final java.lang.Object redirectRule;
            private final java.lang.Object routingRuleCondition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.redirectRule = this.jsiiGet("redirectRule", java.lang.Object.class);
                this.routingRuleCondition = this.jsiiGet("routingRuleCondition", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object redirectRule, final java.lang.Object routingRuleCondition) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.redirectRule = java.util.Objects.requireNonNull(redirectRule, "redirectRule is required");
                this.routingRuleCondition = routingRuleCondition;
            }

            @Override
            public java.lang.Object getRedirectRule() {
                return this.redirectRule;
            }

            @Override
            public java.lang.Object getRoutingRuleCondition() {
                return this.routingRuleCondition;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("redirectRule", om.valueToTree(this.getRedirectRule()));
                if (this.getRoutingRuleCondition() != null) {
                    data.set("routingRuleCondition", om.valueToTree(this.getRoutingRuleCondition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.RoutingRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RoutingRuleProperty.Jsii$Proxy that = (RoutingRuleProperty.Jsii$Proxy) o;

                if (!redirectRule.equals(that.redirectRule)) return false;
                return this.routingRuleCondition != null ? this.routingRuleCondition.equals(that.routingRuleCondition) : that.routingRuleCondition == null;
            }

            @Override
            public int hashCode() {
                int result = this.redirectRule.hashCode();
                result = 31 * result + (this.routingRuleCondition != null ? this.routingRuleCondition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.RuleProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.RuleProperty.Status`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * `CfnBucket.RuleProperty.AbortIncompleteMultipartUpload`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAbortIncompleteMultipartUpload() {
            return null;
        }

        /**
         * `CfnBucket.RuleProperty.ExpirationDate`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExpirationDate() {
            return null;
        }

        /**
         * `CfnBucket.RuleProperty.ExpirationInDays`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getExpirationInDays() {
            return null;
        }

        /**
         * `CfnBucket.RuleProperty.Id`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId() {
            return null;
        }

        /**
         * `CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNoncurrentVersionExpirationInDays() {
            return null;
        }

        /**
         * `CfnBucket.RuleProperty.NoncurrentVersionTransition`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoncurrentVersionTransition() {
            return null;
        }

        /**
         * `CfnBucket.RuleProperty.NoncurrentVersionTransitions`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoncurrentVersionTransitions() {
            return null;
        }

        /**
         * `CfnBucket.RuleProperty.Prefix`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * `CfnBucket.RuleProperty.TagFilters`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagFilters() {
            return null;
        }

        /**
         * `CfnBucket.RuleProperty.Transition`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTransition() {
            return null;
        }

        /**
         * `CfnBucket.RuleProperty.Transitions`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTransitions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleProperty> {
            private java.lang.String status;
            private java.lang.Object abortIncompleteMultipartUpload;
            private java.lang.Object expirationDate;
            private java.lang.Number expirationInDays;
            private java.lang.String id;
            private java.lang.Number noncurrentVersionExpirationInDays;
            private java.lang.Object noncurrentVersionTransition;
            private java.lang.Object noncurrentVersionTransitions;
            private java.lang.String prefix;
            private java.lang.Object tagFilters;
            private java.lang.Object transition;
            private java.lang.Object transitions;

            /**
             * Sets the value of {@link RuleProperty#getStatus}
             * @param status `CfnBucket.RuleProperty.Status`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getAbortIncompleteMultipartUpload}
             * @param abortIncompleteMultipartUpload `CfnBucket.RuleProperty.AbortIncompleteMultipartUpload`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder abortIncompleteMultipartUpload(software.amazon.awscdk.core.IResolvable abortIncompleteMultipartUpload) {
                this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getAbortIncompleteMultipartUpload}
             * @param abortIncompleteMultipartUpload `CfnBucket.RuleProperty.AbortIncompleteMultipartUpload`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder abortIncompleteMultipartUpload(software.amazon.awscdk.services.s3.CfnBucket.AbortIncompleteMultipartUploadProperty abortIncompleteMultipartUpload) {
                this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getExpirationDate}
             * @param expirationDate `CfnBucket.RuleProperty.ExpirationDate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expirationDate(software.amazon.awscdk.core.IResolvable expirationDate) {
                this.expirationDate = expirationDate;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getExpirationDate}
             * @param expirationDate `CfnBucket.RuleProperty.ExpirationDate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expirationDate(java.time.Instant expirationDate) {
                this.expirationDate = expirationDate;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getExpirationInDays}
             * @param expirationInDays `CfnBucket.RuleProperty.ExpirationInDays`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expirationInDays(java.lang.Number expirationInDays) {
                this.expirationInDays = expirationInDays;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getId}
             * @param id `CfnBucket.RuleProperty.Id`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getNoncurrentVersionExpirationInDays}
             * @param noncurrentVersionExpirationInDays `CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noncurrentVersionExpirationInDays(java.lang.Number noncurrentVersionExpirationInDays) {
                this.noncurrentVersionExpirationInDays = noncurrentVersionExpirationInDays;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getNoncurrentVersionTransition}
             * @param noncurrentVersionTransition `CfnBucket.RuleProperty.NoncurrentVersionTransition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noncurrentVersionTransition(software.amazon.awscdk.core.IResolvable noncurrentVersionTransition) {
                this.noncurrentVersionTransition = noncurrentVersionTransition;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getNoncurrentVersionTransition}
             * @param noncurrentVersionTransition `CfnBucket.RuleProperty.NoncurrentVersionTransition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noncurrentVersionTransition(software.amazon.awscdk.services.s3.CfnBucket.NoncurrentVersionTransitionProperty noncurrentVersionTransition) {
                this.noncurrentVersionTransition = noncurrentVersionTransition;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getNoncurrentVersionTransitions}
             * @param noncurrentVersionTransitions `CfnBucket.RuleProperty.NoncurrentVersionTransitions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noncurrentVersionTransitions(software.amazon.awscdk.core.IResolvable noncurrentVersionTransitions) {
                this.noncurrentVersionTransitions = noncurrentVersionTransitions;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getNoncurrentVersionTransitions}
             * @param noncurrentVersionTransitions `CfnBucket.RuleProperty.NoncurrentVersionTransitions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noncurrentVersionTransitions(java.util.List<java.lang.Object> noncurrentVersionTransitions) {
                this.noncurrentVersionTransitions = noncurrentVersionTransitions;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getPrefix}
             * @param prefix `CfnBucket.RuleProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getTagFilters}
             * @param tagFilters `CfnBucket.RuleProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(software.amazon.awscdk.core.IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getTagFilters}
             * @param tagFilters `CfnBucket.RuleProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(java.util.List<java.lang.Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getTransition}
             * @param transition `CfnBucket.RuleProperty.Transition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transition(software.amazon.awscdk.core.IResolvable transition) {
                this.transition = transition;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getTransition}
             * @param transition `CfnBucket.RuleProperty.Transition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transition(software.amazon.awscdk.services.s3.CfnBucket.TransitionProperty transition) {
                this.transition = transition;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getTransitions}
             * @param transitions `CfnBucket.RuleProperty.Transitions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitions(software.amazon.awscdk.core.IResolvable transitions) {
                this.transitions = transitions;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getTransitions}
             * @param transitions `CfnBucket.RuleProperty.Transitions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitions(java.util.List<java.lang.Object> transitions) {
                this.transitions = transitions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleProperty build() {
                return new Jsii$Proxy(status, abortIncompleteMultipartUpload, expirationDate, expirationInDays, id, noncurrentVersionExpirationInDays, noncurrentVersionTransition, noncurrentVersionTransitions, prefix, tagFilters, transition, transitions);
            }
        }

        /**
         * An implementation for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleProperty {
            private final java.lang.String status;
            private final java.lang.Object abortIncompleteMultipartUpload;
            private final java.lang.Object expirationDate;
            private final java.lang.Number expirationInDays;
            private final java.lang.String id;
            private final java.lang.Number noncurrentVersionExpirationInDays;
            private final java.lang.Object noncurrentVersionTransition;
            private final java.lang.Object noncurrentVersionTransitions;
            private final java.lang.String prefix;
            private final java.lang.Object tagFilters;
            private final java.lang.Object transition;
            private final java.lang.Object transitions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = this.jsiiGet("status", java.lang.String.class);
                this.abortIncompleteMultipartUpload = this.jsiiGet("abortIncompleteMultipartUpload", java.lang.Object.class);
                this.expirationDate = this.jsiiGet("expirationDate", java.lang.Object.class);
                this.expirationInDays = this.jsiiGet("expirationInDays", java.lang.Number.class);
                this.id = this.jsiiGet("id", java.lang.String.class);
                this.noncurrentVersionExpirationInDays = this.jsiiGet("noncurrentVersionExpirationInDays", java.lang.Number.class);
                this.noncurrentVersionTransition = this.jsiiGet("noncurrentVersionTransition", java.lang.Object.class);
                this.noncurrentVersionTransitions = this.jsiiGet("noncurrentVersionTransitions", java.lang.Object.class);
                this.prefix = this.jsiiGet("prefix", java.lang.String.class);
                this.tagFilters = this.jsiiGet("tagFilters", java.lang.Object.class);
                this.transition = this.jsiiGet("transition", java.lang.Object.class);
                this.transitions = this.jsiiGet("transitions", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String status, final java.lang.Object abortIncompleteMultipartUpload, final java.lang.Object expirationDate, final java.lang.Number expirationInDays, final java.lang.String id, final java.lang.Number noncurrentVersionExpirationInDays, final java.lang.Object noncurrentVersionTransition, final java.lang.Object noncurrentVersionTransitions, final java.lang.String prefix, final java.lang.Object tagFilters, final java.lang.Object transition, final java.lang.Object transitions) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(status, "status is required");
                this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
                this.expirationDate = expirationDate;
                this.expirationInDays = expirationInDays;
                this.id = id;
                this.noncurrentVersionExpirationInDays = noncurrentVersionExpirationInDays;
                this.noncurrentVersionTransition = noncurrentVersionTransition;
                this.noncurrentVersionTransitions = noncurrentVersionTransitions;
                this.prefix = prefix;
                this.tagFilters = tagFilters;
                this.transition = transition;
                this.transitions = transitions;
            }

            @Override
            public java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public java.lang.Object getAbortIncompleteMultipartUpload() {
                return this.abortIncompleteMultipartUpload;
            }

            @Override
            public java.lang.Object getExpirationDate() {
                return this.expirationDate;
            }

            @Override
            public java.lang.Number getExpirationInDays() {
                return this.expirationInDays;
            }

            @Override
            public java.lang.String getId() {
                return this.id;
            }

            @Override
            public java.lang.Number getNoncurrentVersionExpirationInDays() {
                return this.noncurrentVersionExpirationInDays;
            }

            @Override
            public java.lang.Object getNoncurrentVersionTransition() {
                return this.noncurrentVersionTransition;
            }

            @Override
            public java.lang.Object getNoncurrentVersionTransitions() {
                return this.noncurrentVersionTransitions;
            }

            @Override
            public java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public java.lang.Object getTagFilters() {
                return this.tagFilters;
            }

            @Override
            public java.lang.Object getTransition() {
                return this.transition;
            }

            @Override
            public java.lang.Object getTransitions() {
                return this.transitions;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));
                if (this.getAbortIncompleteMultipartUpload() != null) {
                    data.set("abortIncompleteMultipartUpload", om.valueToTree(this.getAbortIncompleteMultipartUpload()));
                }
                if (this.getExpirationDate() != null) {
                    data.set("expirationDate", om.valueToTree(this.getExpirationDate()));
                }
                if (this.getExpirationInDays() != null) {
                    data.set("expirationInDays", om.valueToTree(this.getExpirationInDays()));
                }
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getNoncurrentVersionExpirationInDays() != null) {
                    data.set("noncurrentVersionExpirationInDays", om.valueToTree(this.getNoncurrentVersionExpirationInDays()));
                }
                if (this.getNoncurrentVersionTransition() != null) {
                    data.set("noncurrentVersionTransition", om.valueToTree(this.getNoncurrentVersionTransition()));
                }
                if (this.getNoncurrentVersionTransitions() != null) {
                    data.set("noncurrentVersionTransitions", om.valueToTree(this.getNoncurrentVersionTransitions()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getTagFilters() != null) {
                    data.set("tagFilters", om.valueToTree(this.getTagFilters()));
                }
                if (this.getTransition() != null) {
                    data.set("transition", om.valueToTree(this.getTransition()));
                }
                if (this.getTransitions() != null) {
                    data.set("transitions", om.valueToTree(this.getTransitions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.RuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleProperty.Jsii$Proxy that = (RuleProperty.Jsii$Proxy) o;

                if (!status.equals(that.status)) return false;
                if (this.abortIncompleteMultipartUpload != null ? !this.abortIncompleteMultipartUpload.equals(that.abortIncompleteMultipartUpload) : that.abortIncompleteMultipartUpload != null) return false;
                if (this.expirationDate != null ? !this.expirationDate.equals(that.expirationDate) : that.expirationDate != null) return false;
                if (this.expirationInDays != null ? !this.expirationInDays.equals(that.expirationInDays) : that.expirationInDays != null) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                if (this.noncurrentVersionExpirationInDays != null ? !this.noncurrentVersionExpirationInDays.equals(that.noncurrentVersionExpirationInDays) : that.noncurrentVersionExpirationInDays != null) return false;
                if (this.noncurrentVersionTransition != null ? !this.noncurrentVersionTransition.equals(that.noncurrentVersionTransition) : that.noncurrentVersionTransition != null) return false;
                if (this.noncurrentVersionTransitions != null ? !this.noncurrentVersionTransitions.equals(that.noncurrentVersionTransitions) : that.noncurrentVersionTransitions != null) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                if (this.tagFilters != null ? !this.tagFilters.equals(that.tagFilters) : that.tagFilters != null) return false;
                if (this.transition != null ? !this.transition.equals(that.transition) : that.transition != null) return false;
                return this.transitions != null ? this.transitions.equals(that.transitions) : that.transitions == null;
            }

            @Override
            public int hashCode() {
                int result = this.status.hashCode();
                result = 31 * result + (this.abortIncompleteMultipartUpload != null ? this.abortIncompleteMultipartUpload.hashCode() : 0);
                result = 31 * result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
                result = 31 * result + (this.expirationInDays != null ? this.expirationInDays.hashCode() : 0);
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.noncurrentVersionExpirationInDays != null ? this.noncurrentVersionExpirationInDays.hashCode() : 0);
                result = 31 * result + (this.noncurrentVersionTransition != null ? this.noncurrentVersionTransition.hashCode() : 0);
                result = 31 * result + (this.noncurrentVersionTransitions != null ? this.noncurrentVersionTransitions.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.tagFilters != null ? this.tagFilters.hashCode() : 0);
                result = 31 * result + (this.transition != null ? this.transition.hashCode() : 0);
                result = 31 * result + (this.transitions != null ? this.transitions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.S3KeyFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(S3KeyFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3KeyFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.S3KeyFilterProperty.Rules`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link S3KeyFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3KeyFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3KeyFilterProperty> {
            private java.lang.Object rules;

            /**
             * Sets the value of {@link S3KeyFilterProperty#getRules}
             * @param rules `CfnBucket.S3KeyFilterProperty.Rules`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(software.amazon.awscdk.core.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of {@link S3KeyFilterProperty#getRules}
             * @param rules `CfnBucket.S3KeyFilterProperty.Rules`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(java.util.List<java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3KeyFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3KeyFilterProperty build() {
                return new Jsii$Proxy(rules);
            }
        }

        /**
         * An implementation for {@link S3KeyFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3KeyFilterProperty {
            private final java.lang.Object rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rules = this.jsiiGet("rules", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object rules) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rules = java.util.Objects.requireNonNull(rules, "rules is required");
            }

            @Override
            public java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("rules", om.valueToTree(this.getRules()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.S3KeyFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3KeyFilterProperty.Jsii$Proxy that = (S3KeyFilterProperty.Jsii$Proxy) o;

                return this.rules.equals(that.rules);
            }

            @Override
            public int hashCode() {
                int result = this.rules.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ServerSideEncryptionByDefaultProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerSideEncryptionByDefaultProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerSideEncryptionByDefaultProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.ServerSideEncryptionByDefaultProperty.SSEAlgorithm`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSseAlgorithm();

        /**
         * `CfnBucket.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsMasterKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServerSideEncryptionByDefaultProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerSideEncryptionByDefaultProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerSideEncryptionByDefaultProperty> {
            private java.lang.String sseAlgorithm;
            private java.lang.String kmsMasterKeyId;

            /**
             * Sets the value of {@link ServerSideEncryptionByDefaultProperty#getSseAlgorithm}
             * @param sseAlgorithm `CfnBucket.ServerSideEncryptionByDefaultProperty.SSEAlgorithm`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sseAlgorithm(java.lang.String sseAlgorithm) {
                this.sseAlgorithm = sseAlgorithm;
                return this;
            }

            /**
             * Sets the value of {@link ServerSideEncryptionByDefaultProperty#getKmsMasterKeyId}
             * @param kmsMasterKeyId `CfnBucket.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsMasterKeyId(java.lang.String kmsMasterKeyId) {
                this.kmsMasterKeyId = kmsMasterKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerSideEncryptionByDefaultProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerSideEncryptionByDefaultProperty build() {
                return new Jsii$Proxy(sseAlgorithm, kmsMasterKeyId);
            }
        }

        /**
         * An implementation for {@link ServerSideEncryptionByDefaultProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerSideEncryptionByDefaultProperty {
            private final java.lang.String sseAlgorithm;
            private final java.lang.String kmsMasterKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sseAlgorithm = this.jsiiGet("sseAlgorithm", java.lang.String.class);
                this.kmsMasterKeyId = this.jsiiGet("kmsMasterKeyId", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String sseAlgorithm, final java.lang.String kmsMasterKeyId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sseAlgorithm = java.util.Objects.requireNonNull(sseAlgorithm, "sseAlgorithm is required");
                this.kmsMasterKeyId = kmsMasterKeyId;
            }

            @Override
            public java.lang.String getSseAlgorithm() {
                return this.sseAlgorithm;
            }

            @Override
            public java.lang.String getKmsMasterKeyId() {
                return this.kmsMasterKeyId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sseAlgorithm", om.valueToTree(this.getSseAlgorithm()));
                if (this.getKmsMasterKeyId() != null) {
                    data.set("kmsMasterKeyId", om.valueToTree(this.getKmsMasterKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ServerSideEncryptionByDefaultProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerSideEncryptionByDefaultProperty.Jsii$Proxy that = (ServerSideEncryptionByDefaultProperty.Jsii$Proxy) o;

                if (!sseAlgorithm.equals(that.sseAlgorithm)) return false;
                return this.kmsMasterKeyId != null ? this.kmsMasterKeyId.equals(that.kmsMasterKeyId) : that.kmsMasterKeyId == null;
            }

            @Override
            public int hashCode() {
                int result = this.sseAlgorithm.hashCode();
                result = 31 * result + (this.kmsMasterKeyId != null ? this.kmsMasterKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.ServerSideEncryptionRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerSideEncryptionRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerSideEncryptionRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServerSideEncryptionByDefault() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServerSideEncryptionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerSideEncryptionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerSideEncryptionRuleProperty> {
            private java.lang.Object serverSideEncryptionByDefault;

            /**
             * Sets the value of {@link ServerSideEncryptionRuleProperty#getServerSideEncryptionByDefault}
             * @param serverSideEncryptionByDefault `CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverSideEncryptionByDefault(software.amazon.awscdk.core.IResolvable serverSideEncryptionByDefault) {
                this.serverSideEncryptionByDefault = serverSideEncryptionByDefault;
                return this;
            }

            /**
             * Sets the value of {@link ServerSideEncryptionRuleProperty#getServerSideEncryptionByDefault}
             * @param serverSideEncryptionByDefault `CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverSideEncryptionByDefault(software.amazon.awscdk.services.s3.CfnBucket.ServerSideEncryptionByDefaultProperty serverSideEncryptionByDefault) {
                this.serverSideEncryptionByDefault = serverSideEncryptionByDefault;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerSideEncryptionRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerSideEncryptionRuleProperty build() {
                return new Jsii$Proxy(serverSideEncryptionByDefault);
            }
        }

        /**
         * An implementation for {@link ServerSideEncryptionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerSideEncryptionRuleProperty {
            private final java.lang.Object serverSideEncryptionByDefault;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.serverSideEncryptionByDefault = this.jsiiGet("serverSideEncryptionByDefault", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object serverSideEncryptionByDefault) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.serverSideEncryptionByDefault = serverSideEncryptionByDefault;
            }

            @Override
            public java.lang.Object getServerSideEncryptionByDefault() {
                return this.serverSideEncryptionByDefault;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getServerSideEncryptionByDefault() != null) {
                    data.set("serverSideEncryptionByDefault", om.valueToTree(this.getServerSideEncryptionByDefault()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.ServerSideEncryptionRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerSideEncryptionRuleProperty.Jsii$Proxy that = (ServerSideEncryptionRuleProperty.Jsii$Proxy) o;

                return this.serverSideEncryptionByDefault != null ? this.serverSideEncryptionByDefault.equals(that.serverSideEncryptionByDefault) : that.serverSideEncryptionByDefault == null;
            }

            @Override
            public int hashCode() {
                int result = this.serverSideEncryptionByDefault != null ? this.serverSideEncryptionByDefault.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.SourceSelectionCriteriaProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceSelectionCriteriaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceSelectionCriteriaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSseKmsEncryptedObjects();

        /**
         * @return a {@link Builder} of {@link SourceSelectionCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceSelectionCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceSelectionCriteriaProperty> {
            private java.lang.Object sseKmsEncryptedObjects;

            /**
             * Sets the value of {@link SourceSelectionCriteriaProperty#getSseKmsEncryptedObjects}
             * @param sseKmsEncryptedObjects `CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sseKmsEncryptedObjects(software.amazon.awscdk.core.IResolvable sseKmsEncryptedObjects) {
                this.sseKmsEncryptedObjects = sseKmsEncryptedObjects;
                return this;
            }

            /**
             * Sets the value of {@link SourceSelectionCriteriaProperty#getSseKmsEncryptedObjects}
             * @param sseKmsEncryptedObjects `CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sseKmsEncryptedObjects(software.amazon.awscdk.services.s3.CfnBucket.SseKmsEncryptedObjectsProperty sseKmsEncryptedObjects) {
                this.sseKmsEncryptedObjects = sseKmsEncryptedObjects;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceSelectionCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceSelectionCriteriaProperty build() {
                return new Jsii$Proxy(sseKmsEncryptedObjects);
            }
        }

        /**
         * An implementation for {@link SourceSelectionCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceSelectionCriteriaProperty {
            private final java.lang.Object sseKmsEncryptedObjects;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sseKmsEncryptedObjects = this.jsiiGet("sseKmsEncryptedObjects", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object sseKmsEncryptedObjects) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sseKmsEncryptedObjects = java.util.Objects.requireNonNull(sseKmsEncryptedObjects, "sseKmsEncryptedObjects is required");
            }

            @Override
            public java.lang.Object getSseKmsEncryptedObjects() {
                return this.sseKmsEncryptedObjects;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sseKmsEncryptedObjects", om.valueToTree(this.getSseKmsEncryptedObjects()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.SourceSelectionCriteriaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceSelectionCriteriaProperty.Jsii$Proxy that = (SourceSelectionCriteriaProperty.Jsii$Proxy) o;

                return this.sseKmsEncryptedObjects.equals(that.sseKmsEncryptedObjects);
            }

            @Override
            public int hashCode() {
                int result = this.sseKmsEncryptedObjects.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.SseKmsEncryptedObjectsProperty")
    @software.amazon.jsii.Jsii.Proxy(SseKmsEncryptedObjectsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SseKmsEncryptedObjectsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.SseKmsEncryptedObjectsProperty.Status`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * @return a {@link Builder} of {@link SseKmsEncryptedObjectsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SseKmsEncryptedObjectsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SseKmsEncryptedObjectsProperty> {
            private java.lang.String status;

            /**
             * Sets the value of {@link SseKmsEncryptedObjectsProperty#getStatus}
             * @param status `CfnBucket.SseKmsEncryptedObjectsProperty.Status`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SseKmsEncryptedObjectsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SseKmsEncryptedObjectsProperty build() {
                return new Jsii$Proxy(status);
            }
        }

        /**
         * An implementation for {@link SseKmsEncryptedObjectsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SseKmsEncryptedObjectsProperty {
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = this.jsiiGet("status", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String status) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(status, "status is required");
            }

            @Override
            public java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.SseKmsEncryptedObjectsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SseKmsEncryptedObjectsProperty.Jsii$Proxy that = (SseKmsEncryptedObjectsProperty.Jsii$Proxy) o;

                return this.status.equals(that.status);
            }

            @Override
            public int hashCode() {
                int result = this.status.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.StorageClassAnalysisProperty")
    @software.amazon.jsii.Jsii.Proxy(StorageClassAnalysisProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StorageClassAnalysisProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.StorageClassAnalysisProperty.DataExport`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataExport() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StorageClassAnalysisProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StorageClassAnalysisProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StorageClassAnalysisProperty> {
            private java.lang.Object dataExport;

            /**
             * Sets the value of {@link StorageClassAnalysisProperty#getDataExport}
             * @param dataExport `CfnBucket.StorageClassAnalysisProperty.DataExport`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataExport(software.amazon.awscdk.core.IResolvable dataExport) {
                this.dataExport = dataExport;
                return this;
            }

            /**
             * Sets the value of {@link StorageClassAnalysisProperty#getDataExport}
             * @param dataExport `CfnBucket.StorageClassAnalysisProperty.DataExport`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataExport(software.amazon.awscdk.services.s3.CfnBucket.DataExportProperty dataExport) {
                this.dataExport = dataExport;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StorageClassAnalysisProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StorageClassAnalysisProperty build() {
                return new Jsii$Proxy(dataExport);
            }
        }

        /**
         * An implementation for {@link StorageClassAnalysisProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StorageClassAnalysisProperty {
            private final java.lang.Object dataExport;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataExport = this.jsiiGet("dataExport", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object dataExport) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataExport = dataExport;
            }

            @Override
            public java.lang.Object getDataExport() {
                return this.dataExport;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDataExport() != null) {
                    data.set("dataExport", om.valueToTree(this.getDataExport()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.StorageClassAnalysisProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StorageClassAnalysisProperty.Jsii$Proxy that = (StorageClassAnalysisProperty.Jsii$Proxy) o;

                return this.dataExport != null ? this.dataExport.equals(that.dataExport) : that.dataExport == null;
            }

            @Override
            public int hashCode() {
                int result = this.dataExport != null ? this.dataExport.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.TagFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(TagFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.TagFilterProperty.Key`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * `CfnBucket.TagFilterProperty.Value`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagFilterProperty> {
            private java.lang.String key;
            private java.lang.String value;

            /**
             * Sets the value of {@link TagFilterProperty#getKey}
             * @param key `CfnBucket.TagFilterProperty.Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link TagFilterProperty#getValue}
             * @param value `CfnBucket.TagFilterProperty.Value`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagFilterProperty build() {
                return new Jsii$Proxy(key, value);
            }
        }

        /**
         * An implementation for {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagFilterProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = this.jsiiGet("key", java.lang.String.class);
                this.value = this.jsiiGet("value", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String key, final java.lang.String value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(key, "key is required");
                this.value = java.util.Objects.requireNonNull(value, "value is required");
            }

            @Override
            public java.lang.String getKey() {
                return this.key;
            }

            @Override
            public java.lang.String getValue() {
                return this.value;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.TagFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagFilterProperty.Jsii$Proxy that = (TagFilterProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.TopicConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.TopicConfigurationProperty.Event`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEvent();

        /**
         * `CfnBucket.TopicConfigurationProperty.Topic`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTopic();

        /**
         * `CfnBucket.TopicConfigurationProperty.Filter`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TopicConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicConfigurationProperty> {
            private java.lang.String event;
            private java.lang.String topic;
            private java.lang.Object filter;

            /**
             * Sets the value of {@link TopicConfigurationProperty#getEvent}
             * @param event `CfnBucket.TopicConfigurationProperty.Event`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder event(java.lang.String event) {
                this.event = event;
                return this;
            }

            /**
             * Sets the value of {@link TopicConfigurationProperty#getTopic}
             * @param topic `CfnBucket.TopicConfigurationProperty.Topic`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topic(java.lang.String topic) {
                this.topic = topic;
                return this;
            }

            /**
             * Sets the value of {@link TopicConfigurationProperty#getFilter}
             * @param filter `CfnBucket.TopicConfigurationProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.core.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link TopicConfigurationProperty#getFilter}
             * @param filter `CfnBucket.TopicConfigurationProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicConfigurationProperty build() {
                return new Jsii$Proxy(event, topic, filter);
            }
        }

        /**
         * An implementation for {@link TopicConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicConfigurationProperty {
            private final java.lang.String event;
            private final java.lang.String topic;
            private final java.lang.Object filter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.event = this.jsiiGet("event", java.lang.String.class);
                this.topic = this.jsiiGet("topic", java.lang.String.class);
                this.filter = this.jsiiGet("filter", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String event, final java.lang.String topic, final java.lang.Object filter) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.event = java.util.Objects.requireNonNull(event, "event is required");
                this.topic = java.util.Objects.requireNonNull(topic, "topic is required");
                this.filter = filter;
            }

            @Override
            public java.lang.String getEvent() {
                return this.event;
            }

            @Override
            public java.lang.String getTopic() {
                return this.topic;
            }

            @Override
            public java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("event", om.valueToTree(this.getEvent()));
                data.set("topic", om.valueToTree(this.getTopic()));
                if (this.getFilter() != null) {
                    data.set("filter", om.valueToTree(this.getFilter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.TopicConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicConfigurationProperty.Jsii$Proxy that = (TopicConfigurationProperty.Jsii$Proxy) o;

                if (!event.equals(that.event)) return false;
                if (!topic.equals(that.topic)) return false;
                return this.filter != null ? this.filter.equals(that.filter) : that.filter == null;
            }

            @Override
            public int hashCode() {
                int result = this.event.hashCode();
                result = 31 * result + (this.topic.hashCode());
                result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.TransitionProperty")
    @software.amazon.jsii.Jsii.Proxy(TransitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TransitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.TransitionProperty.StorageClass`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStorageClass();

        /**
         * `CfnBucket.TransitionProperty.TransitionDate`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTransitionDate() {
            return null;
        }

        /**
         * `CfnBucket.TransitionProperty.TransitionInDays`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTransitionInDays() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TransitionProperty> {
            private java.lang.String storageClass;
            private java.lang.Object transitionDate;
            private java.lang.Number transitionInDays;

            /**
             * Sets the value of {@link TransitionProperty#getStorageClass}
             * @param storageClass `CfnBucket.TransitionProperty.StorageClass`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageClass(java.lang.String storageClass) {
                this.storageClass = storageClass;
                return this;
            }

            /**
             * Sets the value of {@link TransitionProperty#getTransitionDate}
             * @param transitionDate `CfnBucket.TransitionProperty.TransitionDate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitionDate(software.amazon.awscdk.core.IResolvable transitionDate) {
                this.transitionDate = transitionDate;
                return this;
            }

            /**
             * Sets the value of {@link TransitionProperty#getTransitionDate}
             * @param transitionDate `CfnBucket.TransitionProperty.TransitionDate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitionDate(java.time.Instant transitionDate) {
                this.transitionDate = transitionDate;
                return this;
            }

            /**
             * Sets the value of {@link TransitionProperty#getTransitionInDays}
             * @param transitionInDays `CfnBucket.TransitionProperty.TransitionInDays`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitionInDays(java.lang.Number transitionInDays) {
                this.transitionInDays = transitionInDays;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TransitionProperty build() {
                return new Jsii$Proxy(storageClass, transitionDate, transitionInDays);
            }
        }

        /**
         * An implementation for {@link TransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransitionProperty {
            private final java.lang.String storageClass;
            private final java.lang.Object transitionDate;
            private final java.lang.Number transitionInDays;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.storageClass = this.jsiiGet("storageClass", java.lang.String.class);
                this.transitionDate = this.jsiiGet("transitionDate", java.lang.Object.class);
                this.transitionInDays = this.jsiiGet("transitionInDays", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String storageClass, final java.lang.Object transitionDate, final java.lang.Number transitionInDays) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.storageClass = java.util.Objects.requireNonNull(storageClass, "storageClass is required");
                this.transitionDate = transitionDate;
                this.transitionInDays = transitionInDays;
            }

            @Override
            public java.lang.String getStorageClass() {
                return this.storageClass;
            }

            @Override
            public java.lang.Object getTransitionDate() {
                return this.transitionDate;
            }

            @Override
            public java.lang.Number getTransitionInDays() {
                return this.transitionInDays;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("storageClass", om.valueToTree(this.getStorageClass()));
                if (this.getTransitionDate() != null) {
                    data.set("transitionDate", om.valueToTree(this.getTransitionDate()));
                }
                if (this.getTransitionInDays() != null) {
                    data.set("transitionInDays", om.valueToTree(this.getTransitionInDays()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.TransitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TransitionProperty.Jsii$Proxy that = (TransitionProperty.Jsii$Proxy) o;

                if (!storageClass.equals(that.storageClass)) return false;
                if (this.transitionDate != null ? !this.transitionDate.equals(that.transitionDate) : that.transitionDate != null) return false;
                return this.transitionInDays != null ? this.transitionInDays.equals(that.transitionInDays) : that.transitionInDays == null;
            }

            @Override
            public int hashCode() {
                int result = this.storageClass.hashCode();
                result = 31 * result + (this.transitionDate != null ? this.transitionDate.hashCode() : 0);
                result = 31 * result + (this.transitionInDays != null ? this.transitionInDays.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.VersioningConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VersioningConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VersioningConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.VersioningConfigurationProperty.Status`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * @return a {@link Builder} of {@link VersioningConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VersioningConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VersioningConfigurationProperty> {
            private java.lang.String status;

            /**
             * Sets the value of {@link VersioningConfigurationProperty#getStatus}
             * @param status `CfnBucket.VersioningConfigurationProperty.Status`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VersioningConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VersioningConfigurationProperty build() {
                return new Jsii$Proxy(status);
            }
        }

        /**
         * An implementation for {@link VersioningConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VersioningConfigurationProperty {
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = this.jsiiGet("status", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String status) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(status, "status is required");
            }

            @Override
            public java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.VersioningConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VersioningConfigurationProperty.Jsii$Proxy that = (VersioningConfigurationProperty.Jsii$Proxy) o;

                return this.status.equals(that.status);
            }

            @Override
            public int hashCode() {
                int result = this.status.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket.WebsiteConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(WebsiteConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WebsiteConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.WebsiteConfigurationProperty.ErrorDocument`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getErrorDocument() {
            return null;
        }

        /**
         * `CfnBucket.WebsiteConfigurationProperty.IndexDocument`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIndexDocument() {
            return null;
        }

        /**
         * `CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedirectAllRequestsTo() {
            return null;
        }

        /**
         * `CfnBucket.WebsiteConfigurationProperty.RoutingRules`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRoutingRules() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WebsiteConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WebsiteConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WebsiteConfigurationProperty> {
            private java.lang.String errorDocument;
            private java.lang.String indexDocument;
            private java.lang.Object redirectAllRequestsTo;
            private java.lang.Object routingRules;

            /**
             * Sets the value of {@link WebsiteConfigurationProperty#getErrorDocument}
             * @param errorDocument `CfnBucket.WebsiteConfigurationProperty.ErrorDocument`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorDocument(java.lang.String errorDocument) {
                this.errorDocument = errorDocument;
                return this;
            }

            /**
             * Sets the value of {@link WebsiteConfigurationProperty#getIndexDocument}
             * @param indexDocument `CfnBucket.WebsiteConfigurationProperty.IndexDocument`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexDocument(java.lang.String indexDocument) {
                this.indexDocument = indexDocument;
                return this;
            }

            /**
             * Sets the value of {@link WebsiteConfigurationProperty#getRedirectAllRequestsTo}
             * @param redirectAllRequestsTo `CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redirectAllRequestsTo(software.amazon.awscdk.core.IResolvable redirectAllRequestsTo) {
                this.redirectAllRequestsTo = redirectAllRequestsTo;
                return this;
            }

            /**
             * Sets the value of {@link WebsiteConfigurationProperty#getRedirectAllRequestsTo}
             * @param redirectAllRequestsTo `CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redirectAllRequestsTo(software.amazon.awscdk.services.s3.CfnBucket.RedirectAllRequestsToProperty redirectAllRequestsTo) {
                this.redirectAllRequestsTo = redirectAllRequestsTo;
                return this;
            }

            /**
             * Sets the value of {@link WebsiteConfigurationProperty#getRoutingRules}
             * @param routingRules `CfnBucket.WebsiteConfigurationProperty.RoutingRules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routingRules(software.amazon.awscdk.core.IResolvable routingRules) {
                this.routingRules = routingRules;
                return this;
            }

            /**
             * Sets the value of {@link WebsiteConfigurationProperty#getRoutingRules}
             * @param routingRules `CfnBucket.WebsiteConfigurationProperty.RoutingRules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routingRules(java.util.List<java.lang.Object> routingRules) {
                this.routingRules = routingRules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebsiteConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WebsiteConfigurationProperty build() {
                return new Jsii$Proxy(errorDocument, indexDocument, redirectAllRequestsTo, routingRules);
            }
        }

        /**
         * An implementation for {@link WebsiteConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebsiteConfigurationProperty {
            private final java.lang.String errorDocument;
            private final java.lang.String indexDocument;
            private final java.lang.Object redirectAllRequestsTo;
            private final java.lang.Object routingRules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.errorDocument = this.jsiiGet("errorDocument", java.lang.String.class);
                this.indexDocument = this.jsiiGet("indexDocument", java.lang.String.class);
                this.redirectAllRequestsTo = this.jsiiGet("redirectAllRequestsTo", java.lang.Object.class);
                this.routingRules = this.jsiiGet("routingRules", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String errorDocument, final java.lang.String indexDocument, final java.lang.Object redirectAllRequestsTo, final java.lang.Object routingRules) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.errorDocument = errorDocument;
                this.indexDocument = indexDocument;
                this.redirectAllRequestsTo = redirectAllRequestsTo;
                this.routingRules = routingRules;
            }

            @Override
            public java.lang.String getErrorDocument() {
                return this.errorDocument;
            }

            @Override
            public java.lang.String getIndexDocument() {
                return this.indexDocument;
            }

            @Override
            public java.lang.Object getRedirectAllRequestsTo() {
                return this.redirectAllRequestsTo;
            }

            @Override
            public java.lang.Object getRoutingRules() {
                return this.routingRules;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getErrorDocument() != null) {
                    data.set("errorDocument", om.valueToTree(this.getErrorDocument()));
                }
                if (this.getIndexDocument() != null) {
                    data.set("indexDocument", om.valueToTree(this.getIndexDocument()));
                }
                if (this.getRedirectAllRequestsTo() != null) {
                    data.set("redirectAllRequestsTo", om.valueToTree(this.getRedirectAllRequestsTo()));
                }
                if (this.getRoutingRules() != null) {
                    data.set("routingRules", om.valueToTree(this.getRoutingRules()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucket.WebsiteConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WebsiteConfigurationProperty.Jsii$Proxy that = (WebsiteConfigurationProperty.Jsii$Proxy) o;

                if (this.errorDocument != null ? !this.errorDocument.equals(that.errorDocument) : that.errorDocument != null) return false;
                if (this.indexDocument != null ? !this.indexDocument.equals(that.indexDocument) : that.indexDocument != null) return false;
                if (this.redirectAllRequestsTo != null ? !this.redirectAllRequestsTo.equals(that.redirectAllRequestsTo) : that.redirectAllRequestsTo != null) return false;
                return this.routingRules != null ? this.routingRules.equals(that.routingRules) : that.routingRules == null;
            }

            @Override
            public int hashCode() {
                int result = this.errorDocument != null ? this.errorDocument.hashCode() : 0;
                result = 31 * result + (this.indexDocument != null ? this.indexDocument.hashCode() : 0);
                result = 31 * result + (this.redirectAllRequestsTo != null ? this.redirectAllRequestsTo.hashCode() : 0);
                result = 31 * result + (this.routingRules != null ? this.routingRules.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.s3.CfnBucket}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.s3.CfnBucket> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.s3.CfnBucketProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * `AWS::S3::Bucket.AccelerateConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accelerateconfiguration
         * @param accelerateConfiguration `AWS::S3::Bucket.AccelerateConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accelerateConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.AccelerateConfigurationProperty accelerateConfiguration) {
            this.props().accelerateConfiguration(accelerateConfiguration);
            return this;
        }
        /**
         * `AWS::S3::Bucket.AccelerateConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accelerateconfiguration
         * @param accelerateConfiguration `AWS::S3::Bucket.AccelerateConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accelerateConfiguration(final software.amazon.awscdk.core.IResolvable accelerateConfiguration) {
            this.props().accelerateConfiguration(accelerateConfiguration);
            return this;
        }

        /**
         * `AWS::S3::Bucket.AccessControl`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accesscontrol
         * @param accessControl `AWS::S3::Bucket.AccessControl`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessControl(final java.lang.String accessControl) {
            this.props().accessControl(accessControl);
            return this;
        }

        /**
         * `AWS::S3::Bucket.AnalyticsConfigurations`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-analyticsconfigurations
         * @param analyticsConfigurations `AWS::S3::Bucket.AnalyticsConfigurations`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsConfigurations(final software.amazon.awscdk.core.IResolvable analyticsConfigurations) {
            this.props().analyticsConfigurations(analyticsConfigurations);
            return this;
        }
        /**
         * `AWS::S3::Bucket.AnalyticsConfigurations`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-analyticsconfigurations
         * @param analyticsConfigurations `AWS::S3::Bucket.AnalyticsConfigurations`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsConfigurations(final java.util.List<java.lang.Object> analyticsConfigurations) {
            this.props().analyticsConfigurations(analyticsConfigurations);
            return this;
        }

        /**
         * `AWS::S3::Bucket.BucketEncryption`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-bucketencryption
         * @param bucketEncryption `AWS::S3::Bucket.BucketEncryption`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketEncryption(final software.amazon.awscdk.core.IResolvable bucketEncryption) {
            this.props().bucketEncryption(bucketEncryption);
            return this;
        }
        /**
         * `AWS::S3::Bucket.BucketEncryption`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-bucketencryption
         * @param bucketEncryption `AWS::S3::Bucket.BucketEncryption`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketEncryption(final software.amazon.awscdk.services.s3.CfnBucket.BucketEncryptionProperty bucketEncryption) {
            this.props().bucketEncryption(bucketEncryption);
            return this;
        }

        /**
         * `AWS::S3::Bucket.BucketName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-name
         * @param bucketName `AWS::S3::Bucket.BucketName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(final java.lang.String bucketName) {
            this.props().bucketName(bucketName);
            return this;
        }

        /**
         * `AWS::S3::Bucket.CorsConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-crossoriginconfig
         * @param corsConfiguration `AWS::S3::Bucket.CorsConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsConfiguration(final software.amazon.awscdk.core.IResolvable corsConfiguration) {
            this.props().corsConfiguration(corsConfiguration);
            return this;
        }
        /**
         * `AWS::S3::Bucket.CorsConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-crossoriginconfig
         * @param corsConfiguration `AWS::S3::Bucket.CorsConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.CorsConfigurationProperty corsConfiguration) {
            this.props().corsConfiguration(corsConfiguration);
            return this;
        }

        /**
         * `AWS::S3::Bucket.InventoryConfigurations`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-inventoryconfigurations
         * @param inventoryConfigurations `AWS::S3::Bucket.InventoryConfigurations`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inventoryConfigurations(final software.amazon.awscdk.core.IResolvable inventoryConfigurations) {
            this.props().inventoryConfigurations(inventoryConfigurations);
            return this;
        }
        /**
         * `AWS::S3::Bucket.InventoryConfigurations`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-inventoryconfigurations
         * @param inventoryConfigurations `AWS::S3::Bucket.InventoryConfigurations`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inventoryConfigurations(final java.util.List<java.lang.Object> inventoryConfigurations) {
            this.props().inventoryConfigurations(inventoryConfigurations);
            return this;
        }

        /**
         * `AWS::S3::Bucket.LifecycleConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-lifecycleconfig
         * @param lifecycleConfiguration `AWS::S3::Bucket.LifecycleConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleConfiguration(final software.amazon.awscdk.core.IResolvable lifecycleConfiguration) {
            this.props().lifecycleConfiguration(lifecycleConfiguration);
            return this;
        }
        /**
         * `AWS::S3::Bucket.LifecycleConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-lifecycleconfig
         * @param lifecycleConfiguration `AWS::S3::Bucket.LifecycleConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.LifecycleConfigurationProperty lifecycleConfiguration) {
            this.props().lifecycleConfiguration(lifecycleConfiguration);
            return this;
        }

        /**
         * `AWS::S3::Bucket.LoggingConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-loggingconfig
         * @param loggingConfiguration `AWS::S3::Bucket.LoggingConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(final software.amazon.awscdk.core.IResolvable loggingConfiguration) {
            this.props().loggingConfiguration(loggingConfiguration);
            return this;
        }
        /**
         * `AWS::S3::Bucket.LoggingConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-loggingconfig
         * @param loggingConfiguration `AWS::S3::Bucket.LoggingConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.LoggingConfigurationProperty loggingConfiguration) {
            this.props().loggingConfiguration(loggingConfiguration);
            return this;
        }

        /**
         * `AWS::S3::Bucket.MetricsConfigurations`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-metricsconfigurations
         * @param metricsConfigurations `AWS::S3::Bucket.MetricsConfigurations`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsConfigurations(final software.amazon.awscdk.core.IResolvable metricsConfigurations) {
            this.props().metricsConfigurations(metricsConfigurations);
            return this;
        }
        /**
         * `AWS::S3::Bucket.MetricsConfigurations`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-metricsconfigurations
         * @param metricsConfigurations `AWS::S3::Bucket.MetricsConfigurations`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsConfigurations(final java.util.List<java.lang.Object> metricsConfigurations) {
            this.props().metricsConfigurations(metricsConfigurations);
            return this;
        }

        /**
         * `AWS::S3::Bucket.NotificationConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-notification
         * @param notificationConfiguration `AWS::S3::Bucket.NotificationConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfiguration(final software.amazon.awscdk.core.IResolvable notificationConfiguration) {
            this.props().notificationConfiguration(notificationConfiguration);
            return this;
        }
        /**
         * `AWS::S3::Bucket.NotificationConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-notification
         * @param notificationConfiguration `AWS::S3::Bucket.NotificationConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.NotificationConfigurationProperty notificationConfiguration) {
            this.props().notificationConfiguration(notificationConfiguration);
            return this;
        }

        /**
         * `AWS::S3::Bucket.ObjectLockConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockconfiguration
         * @param objectLockConfiguration `AWS::S3::Bucket.ObjectLockConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectLockConfiguration(final software.amazon.awscdk.core.IResolvable objectLockConfiguration) {
            this.props().objectLockConfiguration(objectLockConfiguration);
            return this;
        }
        /**
         * `AWS::S3::Bucket.ObjectLockConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockconfiguration
         * @param objectLockConfiguration `AWS::S3::Bucket.ObjectLockConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectLockConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.ObjectLockConfigurationProperty objectLockConfiguration) {
            this.props().objectLockConfiguration(objectLockConfiguration);
            return this;
        }

        /**
         * `AWS::S3::Bucket.ObjectLockEnabled`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockenabled
         * @param objectLockEnabled `AWS::S3::Bucket.ObjectLockEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectLockEnabled(final java.lang.Boolean objectLockEnabled) {
            this.props().objectLockEnabled(objectLockEnabled);
            return this;
        }
        /**
         * `AWS::S3::Bucket.ObjectLockEnabled`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockenabled
         * @param objectLockEnabled `AWS::S3::Bucket.ObjectLockEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectLockEnabled(final software.amazon.awscdk.core.IResolvable objectLockEnabled) {
            this.props().objectLockEnabled(objectLockEnabled);
            return this;
        }

        /**
         * `AWS::S3::Bucket.PublicAccessBlockConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-publicaccessblockconfiguration
         * @param publicAccessBlockConfiguration `AWS::S3::Bucket.PublicAccessBlockConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicAccessBlockConfiguration(final software.amazon.awscdk.core.IResolvable publicAccessBlockConfiguration) {
            this.props().publicAccessBlockConfiguration(publicAccessBlockConfiguration);
            return this;
        }
        /**
         * `AWS::S3::Bucket.PublicAccessBlockConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-publicaccessblockconfiguration
         * @param publicAccessBlockConfiguration `AWS::S3::Bucket.PublicAccessBlockConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicAccessBlockConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.PublicAccessBlockConfigurationProperty publicAccessBlockConfiguration) {
            this.props().publicAccessBlockConfiguration(publicAccessBlockConfiguration);
            return this;
        }

        /**
         * `AWS::S3::Bucket.ReplicationConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-replicationconfiguration
         * @param replicationConfiguration `AWS::S3::Bucket.ReplicationConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationConfiguration(final software.amazon.awscdk.core.IResolvable replicationConfiguration) {
            this.props().replicationConfiguration(replicationConfiguration);
            return this;
        }
        /**
         * `AWS::S3::Bucket.ReplicationConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-replicationconfiguration
         * @param replicationConfiguration `AWS::S3::Bucket.ReplicationConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.ReplicationConfigurationProperty replicationConfiguration) {
            this.props().replicationConfiguration(replicationConfiguration);
            return this;
        }

        /**
         * `AWS::S3::Bucket.Tags`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-tags
         * @param tags `AWS::S3::Bucket.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * `AWS::S3::Bucket.VersioningConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-versioning
         * @param versioningConfiguration `AWS::S3::Bucket.VersioningConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versioningConfiguration(final software.amazon.awscdk.core.IResolvable versioningConfiguration) {
            this.props().versioningConfiguration(versioningConfiguration);
            return this;
        }
        /**
         * `AWS::S3::Bucket.VersioningConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-versioning
         * @param versioningConfiguration `AWS::S3::Bucket.VersioningConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versioningConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.VersioningConfigurationProperty versioningConfiguration) {
            this.props().versioningConfiguration(versioningConfiguration);
            return this;
        }

        /**
         * `AWS::S3::Bucket.WebsiteConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-websiteconfiguration
         * @param websiteConfiguration `AWS::S3::Bucket.WebsiteConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteConfiguration(final software.amazon.awscdk.core.IResolvable websiteConfiguration) {
            this.props().websiteConfiguration(websiteConfiguration);
            return this;
        }
        /**
         * `AWS::S3::Bucket.WebsiteConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-websiteconfiguration
         * @param websiteConfiguration `AWS::S3::Bucket.WebsiteConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.WebsiteConfigurationProperty websiteConfiguration) {
            this.props().websiteConfiguration(websiteConfiguration);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.s3.CfnBucket}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.s3.CfnBucket build() {
            return new software.amazon.awscdk.services.s3.CfnBucket(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.s3.CfnBucketProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.s3.CfnBucketProps.Builder();
            }
            return this.props;
        }
    }
}
