package software.amazon.awscdk.services.s3;

/**
 * An S3 bucket with associated policy objects.
 * 
 * This bucket does not yet have all features that exposed by the underlying
 * BucketResource.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.1 (build ceff2ca)", date = "2019-08-21T10:49:49.292Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.Bucket")
public class Bucket extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.s3.IBucket {

    protected Bucket(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Bucket(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Bucket(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.s3.BucketProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props }));
    }
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Bucket(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") }));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.s3.IBucket fromBucketArn(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String bucketArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.Bucket.class, "fromBucketArn", software.amazon.awscdk.services.s3.IBucket.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(bucketArn, "bucketArn is required") });
    }

    /**
     * Creates a Bucket construct that represents an external bucket.
     * 
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attrs A `BucketAttributes` object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.s3.IBucket fromBucketAttributes(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.s3.BucketAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.Bucket.class, "fromBucketAttributes", software.amazon.awscdk.services.s3.IBucket.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.s3.IBucket fromBucketName(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String bucketName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.Bucket.class, "fromBucketName", software.amazon.awscdk.services.s3.IBucket.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(bucketName, "bucketName is required") });
    }

    /**
     * Adds a cross-origin access configuration for objects in an Amazon S3 bucket.
     * 
     * @param rule The CORS configuration rule to add.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addCorsRule(final software.amazon.awscdk.services.s3.CorsRule rule) {
        this.jsiiCall("addCorsRule", Void.class, new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * Adds a bucket notification event destination.
     * 
     * Example:
     * 
     *    bucket.addEventNotification(EventType.OnObjectCreated, myLambda, 'home/myusername/*')
     * 
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html
     * @param event The event to trigger the notification.
     * @param dest The notification destination (Lambda, SNS Topic or SQS Queue).
     * @param filters S3 object key filter rules to determine which objects trigger this event.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addEventNotification(final software.amazon.awscdk.services.s3.EventType event, final software.amazon.awscdk.services.s3.IBucketNotificationDestination dest, final software.amazon.awscdk.services.s3.NotificationKeyFilter... filters) {
        this.jsiiCall("addEventNotification", Void.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(event, "event is required"), java.util.Objects.requireNonNull(dest, "dest is required") }), java.util.Arrays.<Object>stream(filters)).toArray(Object[]::new));
    }

    /**
     * Add a lifecycle rule to the bucket.
     * 
     * @param rule The rule to add.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addLifecycleRule(final software.amazon.awscdk.services.s3.LifecycleRule rule) {
        this.jsiiCall("addLifecycleRule", Void.class, new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * Adds a metrics configuration for the CloudWatch request metrics from the bucket.
     * 
     * @param metric The metric configuration to add.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addMetric(final software.amazon.awscdk.services.s3.BucketMetrics metric) {
        this.jsiiCall("addMetric", Void.class, new Object[] { java.util.Objects.requireNonNull(metric, "metric is required") });
    }

    /**
     * Subscribes a destination to receive notificatins when an object is created in the bucket.
     * 
     * This is identical to calling
     * `onEvent(EventType.ObjectCreated)`.
     * 
     * @param dest The notification destination (see onEvent).
     * @param filters Filters (see onEvent).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addObjectCreatedNotification(final software.amazon.awscdk.services.s3.IBucketNotificationDestination dest, final software.amazon.awscdk.services.s3.NotificationKeyFilter... filters) {
        this.jsiiCall("addObjectCreatedNotification", Void.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(dest, "dest is required") }), java.util.Arrays.<Object>stream(filters)).toArray(Object[]::new));
    }

    /**
     * Subscribes a destination to receive notificatins when an object is removed from the bucket.
     * 
     * This is identical to calling
     * `onEvent(EventType.ObjectRemoved)`.
     * 
     * @param dest The notification destination (see onEvent).
     * @param filters Filters (see onEvent).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addObjectRemovedNotification(final software.amazon.awscdk.services.s3.IBucketNotificationDestination dest, final software.amazon.awscdk.services.s3.NotificationKeyFilter... filters) {
        this.jsiiCall("addObjectRemovedNotification", Void.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(dest, "dest is required") }), java.util.Arrays.<Object>stream(filters)).toArray(Object[]::new));
    }

    /**
     * Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or it's contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addToResourcePolicy(final software.amazon.awscdk.services.iam.PolicyStatement permission) {
        this.jsiiCall("addToResourcePolicy", Void.class, new Object[] { java.util.Objects.requireNonNull(permission, "permission is required") });
    }

    /**
     * Returns an ARN that represents all objects within the bucket that match the key pattern specified.
     * 
     * To represent all keys, specify ``"*"``.
     * 
     * If you specify multiple components for keyPattern, they will be concatenated::
     * 
     *    arnForObjects('home/', team, '/', user, '/*')
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public java.lang.String arnForObjects(final java.lang.String keyPattern) {
        return this.jsiiCall("arnForObjects", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(keyPattern, "keyPattern is required") });
    }

    /**
     * Grants s3:DeleteObject* permission to an IAM pricipal for objects in this bucket.
     * 
     * @param identity The principal.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantDelete(final software.amazon.awscdk.services.iam.IGrantable identity, final java.lang.Object objectsKeyPattern) {
        return this.jsiiCall("grantDelete", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
    }

    /**
     * Grants s3:DeleteObject* permission to an IAM pricipal for objects in this bucket.
     * 
     * @param identity The principal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantDelete(final software.amazon.awscdk.services.iam.IGrantable identity) {
        return this.jsiiCall("grantDelete", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Allows unrestricted access to objects from this bucket.
     * 
     * IMPORTANT: This permission allows anyone to perform actions on S3 objects
     * in this bucket, which is useful for when you configure your bucket as a
     * website and want everyone to be able to read objects in the bucket without
     * needing to authenticate.
     * 
     * Without arguments, this method will grant read ("s3:GetObject") access to
     * all objects ("*") in the bucket.
     * 
     * The method returns the `iam.Grant` object, which can then be modified
     * as needed. For example, you can add a condition that will restrict access only
     * to an IPv4 range like this:
     * 
     *      const grant = bucket.grantPublicAccess();
     *      grant.resourceStatement!.addCondition(‘IpAddress’, { “aws:SourceIp”: “54.240.143.0/24” });
     * 
     * @param keyPrefix the prefix of S3 object keys (e.g. `home/*`). Default is "*".
     * @param allowedActions the set of S3 actions to allow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantPublicAccess(final java.lang.String keyPrefix, final java.lang.String... allowedActions) {
        return this.jsiiCall("grantPublicAccess", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { keyPrefix }), java.util.Arrays.<Object>stream(allowedActions)).toArray(Object[]::new));
    }

    /**
     * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
     * 
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * 
     * @param identity The principal.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantPut(final software.amazon.awscdk.services.iam.IGrantable identity, final java.lang.Object objectsKeyPattern) {
        return this.jsiiCall("grantPut", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
    }

    /**
     * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
     * 
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * 
     * @param identity The principal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantPut(final software.amazon.awscdk.services.iam.IGrantable identity) {
        return this.jsiiCall("grantPut", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * 
     * If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.
     * 
     * @param identity The principal.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantRead(final software.amazon.awscdk.services.iam.IGrantable identity, final java.lang.Object objectsKeyPattern) {
        return this.jsiiCall("grantRead", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
    }

    /**
     * Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * 
     * If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.
     * 
     * @param identity The principal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantRead(final software.amazon.awscdk.services.iam.IGrantable identity) {
        return this.jsiiCall("grantRead", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     * 
     * @param identity The principal.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantReadWrite(final software.amazon.awscdk.services.iam.IGrantable identity, final java.lang.Object objectsKeyPattern) {
        return this.jsiiCall("grantReadWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
    }

    /**
     * Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     * 
     * @param identity The principal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantReadWrite(final software.amazon.awscdk.services.iam.IGrantable identity) {
        return this.jsiiCall("grantReadWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grant write permissions to this bucket to an IAM principal.
     * 
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * 
     * @param identity The principal.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantWrite(final software.amazon.awscdk.services.iam.IGrantable identity, final java.lang.Object objectsKeyPattern) {
        return this.jsiiCall("grantWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
    }

    /**
     * Grant write permissions to this bucket to an IAM principal.
     * 
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * 
     * @param identity The principal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantWrite(final software.amazon.awscdk.services.iam.IGrantable identity) {
        return this.jsiiCall("grantWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Define a CloudWatch event that triggers when something happens to this repository.
     * 
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     * 
     * @param id The id of the rule.
     * @param options Options for adding the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.events.Rule onCloudTrailEvent(final java.lang.String id, final software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions options) {
        return this.jsiiCall("onCloudTrailEvent", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Define a CloudWatch event that triggers when something happens to this repository.
     * 
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     * 
     * @param id The id of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.events.Rule onCloudTrailEvent(final java.lang.String id) {
        return this.jsiiCall("onCloudTrailEvent", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines an AWS CloudWatch event rule that can trigger a target when an image is pushed to this repository.
     * 
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     * 
     * @param id The id of the rule.
     * @param options Options for adding the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.events.Rule onCloudTrailPutObject(final java.lang.String id, final software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions options) {
        return this.jsiiCall("onCloudTrailPutObject", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines an AWS CloudWatch event rule that can trigger a target when an image is pushed to this repository.
     * 
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     * 
     * @param id The id of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.events.Rule onCloudTrailPutObject(final java.lang.String id) {
        return this.jsiiCall("onCloudTrailPutObject", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * The https URL of an S3 object.
     * 
     * For example:
     * 
     * Example:
     * 
     * https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey
     * 
     * @return an ObjectS3Url token
     * @param key The S3 key of the object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public java.lang.String urlForObject(final java.lang.String key) {
        return this.jsiiCall("urlForObject", java.lang.String.class, new Object[] { key });
    }

    /**
     * The https URL of an S3 object.
     * 
     * For example:
     * 
     * Example:
     * 
     * https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey
     * 
     * @return an ObjectS3Url token
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public java.lang.String urlForObject() {
        return this.jsiiCall("urlForObject", java.lang.String.class);
    }

    /**
     * The ARN of the bucket.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getBucketArn() {
        return this.jsiiGet("bucketArn", java.lang.String.class);
    }

    /**
     * The IPv4 DNS name of the specified bucket.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getBucketDomainName() {
        return this.jsiiGet("bucketDomainName", java.lang.String.class);
    }

    /**
     * The IPv6 DNS name of the specified bucket.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getBucketDualStackDomainName() {
        return this.jsiiGet("bucketDualStackDomainName", java.lang.String.class);
    }

    /**
     * The name of the bucket.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getBucketName() {
        return this.jsiiGet("bucketName", java.lang.String.class);
    }

    /**
     * The regional domain name of the specified bucket.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getBucketRegionalDomainName() {
        return this.jsiiGet("bucketRegionalDomainName", java.lang.String.class);
    }

    /**
     * The URL of the static website.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getBucketWebsiteUrl() {
        return this.jsiiGet("bucketWebsiteUrl", java.lang.String.class);
    }

    /**
     * Optional KMS encryption key associated with this bucket.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IKey.class);
    }

    /**
     * Indicates if a bucket resource policy should automatically created upon the first call to `addToResourcePolicy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.lang.Boolean getAutoCreatePolicy() {
        return this.jsiiGet("autoCreatePolicy", java.lang.Boolean.class);
    }

    /**
     * Indicates if a bucket resource policy should automatically created upon the first call to `addToResourcePolicy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setAutoCreatePolicy(final java.lang.Boolean value) {
        this.jsiiSet("autoCreatePolicy", java.util.Objects.requireNonNull(value, "autoCreatePolicy is required"));
    }

    /**
     * Whether to disallow public access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.lang.Boolean getDisallowPublicAccess() {
        return this.jsiiGet("disallowPublicAccess", java.lang.Boolean.class);
    }

    /**
     * Whether to disallow public access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setDisallowPublicAccess(final java.lang.Boolean value) {
        this.jsiiSet("disallowPublicAccess", value);
    }

    /**
     * The resource policy assoicated with this bucket.
     * 
     * If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
     * first call to addToResourcePolicy(s).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.s3.BucketPolicy getPolicy() {
        return this.jsiiGet("policy", software.amazon.awscdk.services.s3.BucketPolicy.class);
    }

    /**
     * The resource policy assoicated with this bucket.
     * 
     * If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
     * first call to addToResourcePolicy(s).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicy(final software.amazon.awscdk.services.s3.BucketPolicy value) {
        this.jsiiSet("policy", value);
    }
}
