package software.amazon.awscdk.services.s3;

/**
 * A reference to a bucket.
 * 
 * The easiest way to instantiate is to call
 * `bucket.export()`. Then, the consumer can use `Bucket.import(this, ref)` and
 * get a `Bucket`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.1 (build ceff2ca)", date = "2019-08-21T10:49:49.296Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BucketAttributes extends software.amazon.jsii.JsiiSerializable {
    /**
     * The ARN of the bucket.
     * 
     * At least one of bucketArn or bucketName must be
     * defined in order to initialize a bucket ref.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getBucketArn();

    /**
     * The domain name of the bucket.
     * 
     * Default: Inferred from bucket name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getBucketDomainName();

    /**
     * The IPv6 DNS name of the specified bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getBucketDualStackDomainName();

    /**
     * The name of the bucket.
     * 
     * If the underlying value of ARN is a string, the
     * name will be parsed from the ARN. Otherwise, the name is optional, but
     * some features that require the bucket name such as auto-creating a bucket
     * policy, won't work.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getBucketName();

    /**
     * The regional domain name of the specified bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getBucketRegionalDomainName();

    /**
     * The format of the website URL of the bucket.
     * 
     * This should be true for
     * regions launched since 2014.
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getBucketWebsiteNewUrlFormat();

    /**
     * The website URL of the bucket (if static web hosting is enabled).
     * 
     * Default: Inferred from bucket name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getBucketWebsiteUrl();

    /**
     * @return a {@link Builder} of {@link BucketAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BucketAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String bucketArn;
        private java.lang.String bucketDomainName;
        private java.lang.String bucketDualStackDomainName;
        private java.lang.String bucketName;
        private java.lang.String bucketRegionalDomainName;
        private java.lang.Boolean bucketWebsiteNewUrlFormat;
        private java.lang.String bucketWebsiteUrl;

        /**
         * Sets the value of BucketArn
         * @param bucketArn The ARN of the bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketArn(java.lang.String bucketArn) {
            this.bucketArn = bucketArn;
            return this;
        }

        /**
         * Sets the value of BucketDomainName
         * @param bucketDomainName The domain name of the bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketDomainName(java.lang.String bucketDomainName) {
            this.bucketDomainName = bucketDomainName;
            return this;
        }

        /**
         * Sets the value of BucketDualStackDomainName
         * @param bucketDualStackDomainName The IPv6 DNS name of the specified bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketDualStackDomainName(java.lang.String bucketDualStackDomainName) {
            this.bucketDualStackDomainName = bucketDualStackDomainName;
            return this;
        }

        /**
         * Sets the value of BucketName
         * @param bucketName The name of the bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(java.lang.String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        /**
         * Sets the value of BucketRegionalDomainName
         * @param bucketRegionalDomainName The regional domain name of the specified bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketRegionalDomainName(java.lang.String bucketRegionalDomainName) {
            this.bucketRegionalDomainName = bucketRegionalDomainName;
            return this;
        }

        /**
         * Sets the value of BucketWebsiteNewUrlFormat
         * @param bucketWebsiteNewUrlFormat The format of the website URL of the bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketWebsiteNewUrlFormat(java.lang.Boolean bucketWebsiteNewUrlFormat) {
            this.bucketWebsiteNewUrlFormat = bucketWebsiteNewUrlFormat;
            return this;
        }

        /**
         * Sets the value of BucketWebsiteUrl
         * @param bucketWebsiteUrl The website URL of the bucket (if static web hosting is enabled).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketWebsiteUrl(java.lang.String bucketWebsiteUrl) {
            this.bucketWebsiteUrl = bucketWebsiteUrl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public BucketAttributes build() {
            return new Jsii$Proxy(bucketArn, bucketDomainName, bucketDualStackDomainName, bucketName, bucketRegionalDomainName, bucketWebsiteNewUrlFormat, bucketWebsiteUrl);
        }

    }

    /**
     * An implementation for {@link BucketAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BucketAttributes {
        private final java.lang.String bucketArn;
        private final java.lang.String bucketDomainName;
        private final java.lang.String bucketDualStackDomainName;
        private final java.lang.String bucketName;
        private final java.lang.String bucketRegionalDomainName;
        private final java.lang.Boolean bucketWebsiteNewUrlFormat;
        private final java.lang.String bucketWebsiteUrl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.bucketArn = this.jsiiGet("bucketArn", java.lang.String.class);
            this.bucketDomainName = this.jsiiGet("bucketDomainName", java.lang.String.class);
            this.bucketDualStackDomainName = this.jsiiGet("bucketDualStackDomainName", java.lang.String.class);
            this.bucketName = this.jsiiGet("bucketName", java.lang.String.class);
            this.bucketRegionalDomainName = this.jsiiGet("bucketRegionalDomainName", java.lang.String.class);
            this.bucketWebsiteNewUrlFormat = this.jsiiGet("bucketWebsiteNewUrlFormat", java.lang.Boolean.class);
            this.bucketWebsiteUrl = this.jsiiGet("bucketWebsiteUrl", java.lang.String.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String bucketArn, java.lang.String bucketDomainName, java.lang.String bucketDualStackDomainName, java.lang.String bucketName, java.lang.String bucketRegionalDomainName, java.lang.Boolean bucketWebsiteNewUrlFormat, java.lang.String bucketWebsiteUrl) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucketArn = bucketArn;
            this.bucketDomainName = bucketDomainName;
            this.bucketDualStackDomainName = bucketDualStackDomainName;
            this.bucketName = bucketName;
            this.bucketRegionalDomainName = bucketRegionalDomainName;
            this.bucketWebsiteNewUrlFormat = bucketWebsiteNewUrlFormat;
            this.bucketWebsiteUrl = bucketWebsiteUrl;
        }

        @Override
        public java.lang.String getBucketArn() {
            return this.bucketArn;
        }

        @Override
        public java.lang.String getBucketDomainName() {
            return this.bucketDomainName;
        }

        @Override
        public java.lang.String getBucketDualStackDomainName() {
            return this.bucketDualStackDomainName;
        }

        @Override
        public java.lang.String getBucketName() {
            return this.bucketName;
        }

        @Override
        public java.lang.String getBucketRegionalDomainName() {
            return this.bucketRegionalDomainName;
        }

        @Override
        public java.lang.Boolean getBucketWebsiteNewUrlFormat() {
            return this.bucketWebsiteNewUrlFormat;
        }

        @Override
        public java.lang.String getBucketWebsiteUrl() {
            return this.bucketWebsiteUrl;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getBucketArn() != null) {
                obj.set("bucketArn", om.valueToTree(this.getBucketArn()));
            }
            if (this.getBucketDomainName() != null) {
                obj.set("bucketDomainName", om.valueToTree(this.getBucketDomainName()));
            }
            if (this.getBucketDualStackDomainName() != null) {
                obj.set("bucketDualStackDomainName", om.valueToTree(this.getBucketDualStackDomainName()));
            }
            if (this.getBucketName() != null) {
                obj.set("bucketName", om.valueToTree(this.getBucketName()));
            }
            if (this.getBucketRegionalDomainName() != null) {
                obj.set("bucketRegionalDomainName", om.valueToTree(this.getBucketRegionalDomainName()));
            }
            if (this.getBucketWebsiteNewUrlFormat() != null) {
                obj.set("bucketWebsiteNewUrlFormat", om.valueToTree(this.getBucketWebsiteNewUrlFormat()));
            }
            if (this.getBucketWebsiteUrl() != null) {
                obj.set("bucketWebsiteUrl", om.valueToTree(this.getBucketWebsiteUrl()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BucketAttributes.Jsii$Proxy that = (BucketAttributes.Jsii$Proxy) o;

            if (this.bucketArn != null ? !this.bucketArn.equals(that.bucketArn) : that.bucketArn != null) return false;
            if (this.bucketDomainName != null ? !this.bucketDomainName.equals(that.bucketDomainName) : that.bucketDomainName != null) return false;
            if (this.bucketDualStackDomainName != null ? !this.bucketDualStackDomainName.equals(that.bucketDualStackDomainName) : that.bucketDualStackDomainName != null) return false;
            if (this.bucketName != null ? !this.bucketName.equals(that.bucketName) : that.bucketName != null) return false;
            if (this.bucketRegionalDomainName != null ? !this.bucketRegionalDomainName.equals(that.bucketRegionalDomainName) : that.bucketRegionalDomainName != null) return false;
            if (this.bucketWebsiteNewUrlFormat != null ? !this.bucketWebsiteNewUrlFormat.equals(that.bucketWebsiteNewUrlFormat) : that.bucketWebsiteNewUrlFormat != null) return false;
            return this.bucketWebsiteUrl != null ? this.bucketWebsiteUrl.equals(that.bucketWebsiteUrl) : that.bucketWebsiteUrl == null;
        }

        @Override
        public int hashCode() {
            int result = this.bucketArn != null ? this.bucketArn.hashCode() : 0;
            result = 31 * result + (this.bucketDomainName != null ? this.bucketDomainName.hashCode() : 0);
            result = 31 * result + (this.bucketDualStackDomainName != null ? this.bucketDualStackDomainName.hashCode() : 0);
            result = 31 * result + (this.bucketName != null ? this.bucketName.hashCode() : 0);
            result = 31 * result + (this.bucketRegionalDomainName != null ? this.bucketRegionalDomainName.hashCode() : 0);
            result = 31 * result + (this.bucketWebsiteNewUrlFormat != null ? this.bucketWebsiteNewUrlFormat.hashCode() : 0);
            result = 31 * result + (this.bucketWebsiteUrl != null ? this.bucketWebsiteUrl.hashCode() : 0);
            return result;
        }

    }
}
