package software.amazon.awscdk.services.s3;

/**
 * Properties for defining a `AWS::S3::BucketPolicy`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.1 (build ceff2ca)", date = "2019-08-21T10:49:49.316Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnBucketPolicyProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::S3::BucketPolicy.Bucket`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-bucket
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getBucket();

    /**
     * `AWS::S3::BucketPolicy.PolicyDocument`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-policydocument
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getPolicyDocument();

    /**
     * @return a {@link Builder} of {@link CfnBucketPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnBucketPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Builder {
        private java.lang.String bucket;
        private java.lang.Object policyDocument;

        /**
         * Sets the value of Bucket
         * @param bucket `AWS::S3::BucketPolicy.Bucket`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder bucket(java.lang.String bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of PolicyDocument
         * @param policyDocument `AWS::S3::BucketPolicy.PolicyDocument`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder policyDocument(java.lang.Object policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnBucketPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnBucketPolicyProps build() {
            return new Jsii$Proxy(bucket, policyDocument);
        }

    }

    /**
     * An implementation for {@link CfnBucketPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnBucketPolicyProps {
        private final java.lang.String bucket;
        private final java.lang.Object policyDocument;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.bucket = this.jsiiGet("bucket", java.lang.String.class);
            this.policyDocument = this.jsiiGet("policyDocument", java.lang.Object.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String bucket, java.lang.Object policyDocument) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = java.util.Objects.requireNonNull(bucket, "bucket is required");
            this.policyDocument = java.util.Objects.requireNonNull(policyDocument, "policyDocument is required");
        }

        @Override
        public java.lang.String getBucket() {
            return this.bucket;
        }

        @Override
        public java.lang.Object getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("bucket", om.valueToTree(this.getBucket()));
            obj.set("policyDocument", om.valueToTree(this.getPolicyDocument()));
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnBucketPolicyProps.Jsii$Proxy that = (CfnBucketPolicyProps.Jsii$Proxy) o;

            if (!bucket.equals(that.bucket)) return false;
            return this.policyDocument.equals(that.policyDocument);
        }

        @Override
        public int hashCode() {
            int result = this.bucket.hashCode();
            result = 31 * result + (this.policyDocument.hashCode());
            return result;
        }

    }
}
