package software.amazon.awscdk.services.s3;

/**
 * Rule that define when a redirect is applied and the redirect behavior.
 * 
 * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.1 (build ceff2ca)", date = "2019-08-21T10:49:49.334Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RoutingRule extends software.amazon.jsii.JsiiSerializable {
    /**
     * Specifies a condition that must be met for the specified redirect to apply.
     * 
     * Default: - No condition
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.s3.RoutingRuleCondition getCondition();

    /**
     * The host name to use in the redirect request.
     * 
     * Default: - The host name used in the original request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getHostName();

    /**
     * The HTTP redirect code to use on the response.
     * 
     * Default: "301" - Moved Permanently
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getHttpRedirectCode();

    /**
     * Protocol to use when redirecting requests.
     * 
     * Default: - The protocol used in the original request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.s3.RedirectProtocol getProtocol();

    /**
     * Specifies the object key prefix to use in the redirect request.
     * 
     * Default: - The key will not be replaced
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.s3.ReplaceKey getReplaceKey();

    /**
     * @return a {@link Builder} of {@link RoutingRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link RoutingRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.s3.RoutingRuleCondition condition;
        private java.lang.String hostName;
        private java.lang.String httpRedirectCode;
        private software.amazon.awscdk.services.s3.RedirectProtocol protocol;
        private software.amazon.awscdk.services.s3.ReplaceKey replaceKey;

        /**
         * Sets the value of Condition
         * @param condition Specifies a condition that must be met for the specified redirect to apply.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder condition(software.amazon.awscdk.services.s3.RoutingRuleCondition condition) {
            this.condition = condition;
            return this;
        }

        /**
         * Sets the value of HostName
         * @param hostName The host name to use in the redirect request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostName(java.lang.String hostName) {
            this.hostName = hostName;
            return this;
        }

        /**
         * Sets the value of HttpRedirectCode
         * @param httpRedirectCode The HTTP redirect code to use on the response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpRedirectCode(java.lang.String httpRedirectCode) {
            this.httpRedirectCode = httpRedirectCode;
            return this;
        }

        /**
         * Sets the value of Protocol
         * @param protocol Protocol to use when redirecting requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.s3.RedirectProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of ReplaceKey
         * @param replaceKey Specifies the object key prefix to use in the redirect request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceKey(software.amazon.awscdk.services.s3.ReplaceKey replaceKey) {
            this.replaceKey = replaceKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RoutingRule}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public RoutingRule build() {
            return new Jsii$Proxy(condition, hostName, httpRedirectCode, protocol, replaceKey);
        }

    }

    /**
     * An implementation for {@link RoutingRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RoutingRule {
        private final software.amazon.awscdk.services.s3.RoutingRuleCondition condition;
        private final java.lang.String hostName;
        private final java.lang.String httpRedirectCode;
        private final software.amazon.awscdk.services.s3.RedirectProtocol protocol;
        private final software.amazon.awscdk.services.s3.ReplaceKey replaceKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.condition = this.jsiiGet("condition", software.amazon.awscdk.services.s3.RoutingRuleCondition.class);
            this.hostName = this.jsiiGet("hostName", java.lang.String.class);
            this.httpRedirectCode = this.jsiiGet("httpRedirectCode", java.lang.String.class);
            this.protocol = this.jsiiGet("protocol", software.amazon.awscdk.services.s3.RedirectProtocol.class);
            this.replaceKey = this.jsiiGet("replaceKey", software.amazon.awscdk.services.s3.ReplaceKey.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.services.s3.RoutingRuleCondition condition, java.lang.String hostName, java.lang.String httpRedirectCode, software.amazon.awscdk.services.s3.RedirectProtocol protocol, software.amazon.awscdk.services.s3.ReplaceKey replaceKey) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.condition = condition;
            this.hostName = hostName;
            this.httpRedirectCode = httpRedirectCode;
            this.protocol = protocol;
            this.replaceKey = replaceKey;
        }

        @Override
        public software.amazon.awscdk.services.s3.RoutingRuleCondition getCondition() {
            return this.condition;
        }

        @Override
        public java.lang.String getHostName() {
            return this.hostName;
        }

        @Override
        public java.lang.String getHttpRedirectCode() {
            return this.httpRedirectCode;
        }

        @Override
        public software.amazon.awscdk.services.s3.RedirectProtocol getProtocol() {
            return this.protocol;
        }

        @Override
        public software.amazon.awscdk.services.s3.ReplaceKey getReplaceKey() {
            return this.replaceKey;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getCondition() != null) {
                obj.set("condition", om.valueToTree(this.getCondition()));
            }
            if (this.getHostName() != null) {
                obj.set("hostName", om.valueToTree(this.getHostName()));
            }
            if (this.getHttpRedirectCode() != null) {
                obj.set("httpRedirectCode", om.valueToTree(this.getHttpRedirectCode()));
            }
            if (this.getProtocol() != null) {
                obj.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getReplaceKey() != null) {
                obj.set("replaceKey", om.valueToTree(this.getReplaceKey()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RoutingRule.Jsii$Proxy that = (RoutingRule.Jsii$Proxy) o;

            if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) return false;
            if (this.hostName != null ? !this.hostName.equals(that.hostName) : that.hostName != null) return false;
            if (this.httpRedirectCode != null ? !this.httpRedirectCode.equals(that.httpRedirectCode) : that.httpRedirectCode != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            return this.replaceKey != null ? this.replaceKey.equals(that.replaceKey) : that.replaceKey == null;
        }

        @Override
        public int hashCode() {
            int result = this.condition != null ? this.condition.hashCode() : 0;
            result = 31 * result + (this.hostName != null ? this.hostName.hashCode() : 0);
            result = 31 * result + (this.httpRedirectCode != null ? this.httpRedirectCode.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.replaceKey != null ? this.replaceKey.hashCode() : 0);
            return result;
        }

    }
}
