package software.amazon.awscdk.services.s3;

/**
 * Represents the properties of a notification destination.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-28T21:12:21.970Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.BucketNotificationDestinationConfig")
@software.amazon.jsii.Jsii.Proxy(BucketNotificationDestinationConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BucketNotificationDestinationConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the destination (i.e. Lambda, SNS, SQS).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getArn();

    /**
     * The notification type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.BucketNotificationDestinationType getType();

    /**
     * Any additional dependencies that should be resolved before the bucket notification can be configured (for example, the SNS Topic Policy resource).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.IDependable> getDependencies() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BucketNotificationDestinationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BucketNotificationDestinationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BucketNotificationDestinationConfig> {
        private java.lang.String arn;
        private software.amazon.awscdk.services.s3.BucketNotificationDestinationType type;
        private java.util.List<software.amazon.awscdk.core.IDependable> dependencies;

        /**
         * Sets the value of {@link BucketNotificationDestinationConfig#getArn}
         * @param arn The ARN of the destination (i.e. Lambda, SNS, SQS). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder arn(java.lang.String arn) {
            this.arn = arn;
            return this;
        }

        /**
         * Sets the value of {@link BucketNotificationDestinationConfig#getType}
         * @param type The notification type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.s3.BucketNotificationDestinationType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link BucketNotificationDestinationConfig#getDependencies}
         * @param dependencies Any additional dependencies that should be resolved before the bucket notification can be configured (for example, the SNS Topic Policy resource).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dependencies(java.util.List<software.amazon.awscdk.core.IDependable> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketNotificationDestinationConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BucketNotificationDestinationConfig build() {
            return new Jsii$Proxy(arn, type, dependencies);
        }
    }

    /**
     * An implementation for {@link BucketNotificationDestinationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BucketNotificationDestinationConfig {
        private final java.lang.String arn;
        private final software.amazon.awscdk.services.s3.BucketNotificationDestinationType type;
        private final java.util.List<software.amazon.awscdk.core.IDependable> dependencies;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.arn = this.jsiiGet("arn", java.lang.String.class);
            this.type = this.jsiiGet("type", software.amazon.awscdk.services.s3.BucketNotificationDestinationType.class);
            this.dependencies = this.jsiiGet("dependencies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IDependable.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String arn, final software.amazon.awscdk.services.s3.BucketNotificationDestinationType type, final java.util.List<software.amazon.awscdk.core.IDependable> dependencies) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.arn = java.util.Objects.requireNonNull(arn, "arn is required");
            this.type = java.util.Objects.requireNonNull(type, "type is required");
            this.dependencies = dependencies;
        }

        @Override
        public java.lang.String getArn() {
            return this.arn;
        }

        @Override
        public software.amazon.awscdk.services.s3.BucketNotificationDestinationType getType() {
            return this.type;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.IDependable> getDependencies() {
            return this.dependencies;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("arn", om.valueToTree(this.getArn()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getDependencies() != null) {
                data.set("dependencies", om.valueToTree(this.getDependencies()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.BucketNotificationDestinationConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BucketNotificationDestinationConfig.Jsii$Proxy that = (BucketNotificationDestinationConfig.Jsii$Proxy) o;

            if (!arn.equals(that.arn)) return false;
            if (!type.equals(that.type)) return false;
            return this.dependencies != null ? this.dependencies.equals(that.dependencies) : that.dependencies == null;
        }

        @Override
        public int hashCode() {
            int result = this.arn.hashCode();
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.dependencies != null ? this.dependencies.hashCode() : 0);
            return result;
        }
    }
}
