package software.amazon.awscdk.services.s3;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-28T21:12:22.002Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.IBucket")
@software.amazon.jsii.Jsii.Proxy(IBucket.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IBucket extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IResource {

    /**
     * The ARN of the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketArn();

    /**
     * The IPv4 DNS name of the specified bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketDomainName();

    /**
     * The IPv6 DNS name of the specified bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketDualStackDomainName();

    /**
     * The name of the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

    /**
     * The regional domain name of the specified bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketRegionalDomainName();

    /**
     * The Domain name of the static website.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketWebsiteDomainName();

    /**
     * The URL of the static website.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketWebsiteUrl();

    /**
     * Optional KMS encryption key associated with this bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * If this bucket has been configured for static website hosting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIsWebsite() {
        return null;
    }

    /**
     * The resource policy associated with this bucket.
     * <p>
     * If <code>autoCreatePolicy</code> is true, a <code>BucketPolicy</code> will be created upon the
     * first call to addToResourcePolicy(s).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketPolicy getPolicy() {
        return null;
    }

    /**
     * The resource policy associated with this bucket.
     * <p>
     * If <code>autoCreatePolicy</code> is true, a <code>BucketPolicy</code> will be created upon the
     * first call to addToResourcePolicy(s).
     */
    @software.amazon.jsii.Optional
    default void setPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketPolicy value) {
        throw new UnsupportedOperationException("'void " + getClass().getCanonicalName() + "#setPolicy(@org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketPolicy)' is not implemented!");
    }

    /**
     * Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or it's contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects.
     * <p>
     * @param permission This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement permission);

    /**
     * Returns an ARN that represents all objects within the bucket that match the key pattern specified.
     * <p>
     * To represent all keys, specify <code>"*"</code>.
     * <p>
     * @param keyPattern This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String arnForObjects(final @org.jetbrains.annotations.NotNull java.lang.String keyPattern);

    /**
     * Grants s3:DeleteObject* permission to an IAM pricipal for objects in this bucket.
     * <p>
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDelete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern);

    /**
     * Grants s3:DeleteObject* permission to an IAM pricipal for objects in this bucket.
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDelete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * Allows unrestricted access to objects from this bucket.
     * <p>
     * IMPORTANT: This permission allows anyone to perform actions on S3 objects
     * in this bucket, which is useful for when you configure your bucket as a
     * website and want everyone to be able to read objects in the bucket without
     * needing to authenticate.
     * <p>
     * Without arguments, this method will grant read ("s3:GetObject") access to
     * all objects ("*") in the bucket.
     * <p>
     * The method returns the <code>iam.Grant</code> object, which can then be modified
     * as needed. For example, you can add a condition that will restrict access only
     * to an IPv4 range like this:
     * <p>
     * <blockquote><pre>
     *  const grant = bucket.grantPublicAccess();
     *  grant.resourceStatement!.addCondition(‘IpAddress’, { “aws:SourceIp”: “54.240.143.0/24” });
     * </pre></blockquote>
     * <p>
     * @return The `iam.PolicyStatement` object, which can be used to apply e.g. conditions.
     * @param keyPrefix the prefix of S3 object keys (e.g. `home/*`). Default is "*".
     * @param allowedActions the set of S3 actions to allow. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPublicAccess(final @org.jetbrains.annotations.Nullable java.lang.String keyPrefix, final @org.jetbrains.annotations.NotNull java.lang.String... allowedActions);

    /**
     * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
     * <p>
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * <p>
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPut(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern);

    /**
     * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
     * <p>
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPut(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * <p>
     * If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.
     * <p>
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern);

    /**
     * Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * <p>
     * If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * <p>
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     * <p>
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern);

    /**
     * Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * <p>
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * Grant write permissions to this bucket to an IAM principal.
     * <p>
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * <p>
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern);

    /**
     * Grant write permissions to this bucket to an IAM principal.
     * <p>
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * Defines a CloudWatch event that triggers when something happens to this bucket.
     * <p>
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     * <p>
     * @param id The id of the rule. This parameter is required.
     * @param options Options for adding the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions options);

    /**
     * Defines a CloudWatch event that triggers when something happens to this bucket.
     * <p>
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     * <p>
     * @param id The id of the rule. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailEvent(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call.
     * <p>
     * Note that some tools like <code>aws s3 cp</code> will automatically use either
     * PutObject or the multipart upload API depending on the file size,
     * so using <code>onCloudTrailWriteObject</code> may be preferable.
     * <p>
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     * <p>
     * @param id The id of the rule. This parameter is required.
     * @param options Options for adding the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailPutObject(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions options);

    /**
     * Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call.
     * <p>
     * Note that some tools like <code>aws s3 cp</code> will automatically use either
     * PutObject or the multipart upload API depending on the file size,
     * so using <code>onCloudTrailWriteObject</code> may be preferable.
     * <p>
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     * <p>
     * @param id The id of the rule. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailPutObject(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to.
     * <p>
     * This includes
     * the events PutObject, CopyObject, and CompleteMultipartUpload.
     * <p>
     * Note that some tools like <code>aws s3 cp</code> will automatically use either
     * PutObject or the multipart upload API depending on the file size,
     * so using this method may be preferable to <code>onCloudTrailPutObject</code>.
     * <p>
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     * <p>
     * @param id The id of the rule. This parameter is required.
     * @param options Options for adding the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailWriteObject(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions options);

    /**
     * Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to.
     * <p>
     * This includes
     * the events PutObject, CopyObject, and CompleteMultipartUpload.
     * <p>
     * Note that some tools like <code>aws s3 cp</code> will automatically use either
     * PutObject or the multipart upload API depending on the file size,
     * so using this method may be preferable to <code>onCloudTrailPutObject</code>.
     * <p>
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     * <p>
     * @param id The id of the rule. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailWriteObject(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * The S3 URL of an S3 object.
     * <p>
     * For example:
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * s3:}</pre></blockquote>
     * <p>
     * @return an ObjectS3Url token
     * @param key The S3 key of the object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String s3UrlForObject(final @org.jetbrains.annotations.Nullable java.lang.String key);

    /**
     * The S3 URL of an S3 object.
     * <p>
     * For example:
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * s3:}</pre></blockquote>
     * <p>
     * @return an ObjectS3Url token
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String s3UrlForObject();

    /**
     * The https URL of an S3 object.
     * <p>
     * For example:
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * https:}</pre></blockquote>
     * <p>
     * @return an ObjectS3Url token
     * @param key The S3 key of the object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String urlForObject(final @org.jetbrains.annotations.Nullable java.lang.String key);

    /**
     * The https URL of an S3 object.
     * <p>
     * For example:
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * https:}</pre></blockquote>
     * <p>
     * @return an ObjectS3Url token
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String urlForObject();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.IBucket {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The ARN of the bucket.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getBucketArn() {
            return this.jsiiGet("bucketArn", java.lang.String.class);
        }

        /**
         * The IPv4 DNS name of the specified bucket.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getBucketDomainName() {
            return this.jsiiGet("bucketDomainName", java.lang.String.class);
        }

        /**
         * The IPv6 DNS name of the specified bucket.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getBucketDualStackDomainName() {
            return this.jsiiGet("bucketDualStackDomainName", java.lang.String.class);
        }

        /**
         * The name of the bucket.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getBucketName() {
            return this.jsiiGet("bucketName", java.lang.String.class);
        }

        /**
         * The regional domain name of the specified bucket.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getBucketRegionalDomainName() {
            return this.jsiiGet("bucketRegionalDomainName", java.lang.String.class);
        }

        /**
         * The Domain name of the static website.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getBucketWebsiteDomainName() {
            return this.jsiiGet("bucketWebsiteDomainName", java.lang.String.class);
        }

        /**
         * The URL of the static website.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getBucketWebsiteUrl() {
            return this.jsiiGet("bucketWebsiteUrl", java.lang.String.class);
        }

        /**
         * Optional KMS encryption key associated with this bucket.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IKey.class);
        }

        /**
         * If this bucket has been configured for static website hosting.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.Nullable java.lang.Boolean getIsWebsite() {
            return this.jsiiGet("isWebsite", java.lang.Boolean.class);
        }

        /**
         * The resource policy associated with this bucket.
         * <p>
         * If <code>autoCreatePolicy</code> is true, a <code>BucketPolicy</code> will be created upon the
         * first call to addToResourcePolicy(s).
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketPolicy getPolicy() {
            return this.jsiiGet("policy", software.amazon.awscdk.services.s3.BucketPolicy.class);
        }

        /**
         * The resource policy associated with this bucket.
         * <p>
         * If <code>autoCreatePolicy</code> is true, a <code>BucketPolicy</code> will be created upon the
         * first call to addToResourcePolicy(s).
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public void setPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketPolicy value) {
            this.jsiiSet("policy", value);
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
        }

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }

        /**
         * Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or it's contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects.
         * <p>
         * @param permission This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement permission) {
            return this.jsiiCall("addToResourcePolicy", software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class, new Object[] { java.util.Objects.requireNonNull(permission, "permission is required") });
        }

        /**
         * Returns an ARN that represents all objects within the bucket that match the key pattern specified.
         * <p>
         * To represent all keys, specify <code>"*"</code>.
         * <p>
         * @param keyPattern This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull java.lang.String arnForObjects(final @org.jetbrains.annotations.NotNull java.lang.String keyPattern) {
            return this.jsiiCall("arnForObjects", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(keyPattern, "keyPattern is required") });
        }

        /**
         * Grants s3:DeleteObject* permission to an IAM pricipal for objects in this bucket.
         * <p>
         * @param identity The principal. This parameter is required.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDelete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern) {
            return this.jsiiCall("grantDelete", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Grants s3:DeleteObject* permission to an IAM pricipal for objects in this bucket.
         * <p>
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDelete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return this.jsiiCall("grantDelete", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Allows unrestricted access to objects from this bucket.
         * <p>
         * IMPORTANT: This permission allows anyone to perform actions on S3 objects
         * in this bucket, which is useful for when you configure your bucket as a
         * website and want everyone to be able to read objects in the bucket without
         * needing to authenticate.
         * <p>
         * Without arguments, this method will grant read ("s3:GetObject") access to
         * all objects ("*") in the bucket.
         * <p>
         * The method returns the <code>iam.Grant</code> object, which can then be modified
         * as needed. For example, you can add a condition that will restrict access only
         * to an IPv4 range like this:
         * <p>
         * <blockquote><pre>
         *  const grant = bucket.grantPublicAccess();
         *  grant.resourceStatement!.addCondition(‘IpAddress’, { “aws:SourceIp”: “54.240.143.0/24” });
         * </pre></blockquote>
         * <p>
         * @return The `iam.PolicyStatement` object, which can be used to apply e.g. conditions.
         * @param keyPrefix the prefix of S3 object keys (e.g. `home/*`). Default is "*".
         * @param allowedActions the set of S3 actions to allow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPublicAccess(final @org.jetbrains.annotations.Nullable java.lang.String keyPrefix, final @org.jetbrains.annotations.NotNull java.lang.String... allowedActions) {
            return this.jsiiCall("grantPublicAccess", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { keyPrefix }), java.util.Arrays.<Object>stream(allowedActions)).toArray(Object[]::new));
        }

        /**
         * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
         * <p>
         * If encryption is used, permission to use the key to encrypt the contents
         * of written files will also be granted to the same principal.
         * <p>
         * @param identity The principal. This parameter is required.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPut(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern) {
            return this.jsiiCall("grantPut", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
         * <p>
         * If encryption is used, permission to use the key to encrypt the contents
         * of written files will also be granted to the same principal.
         * <p>
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPut(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return this.jsiiCall("grantPut", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
         * <p>
         * If encryption is used, permission to use the key to decrypt the contents
         * of the bucket will also be granted to the same principal.
         * <p>
         * @param identity The principal. This parameter is required.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern) {
            return this.jsiiCall("grantRead", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
         * <p>
         * If encryption is used, permission to use the key to decrypt the contents
         * of the bucket will also be granted to the same principal.
         * <p>
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return this.jsiiCall("grantRead", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
         * <p>
         * If an encryption key is used, permission to use the key for
         * encrypt/decrypt will also be granted.
         * <p>
         * @param identity The principal. This parameter is required.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern) {
            return this.jsiiCall("grantReadWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
         * <p>
         * If an encryption key is used, permission to use the key for
         * encrypt/decrypt will also be granted.
         * <p>
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return this.jsiiCall("grantReadWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Grant write permissions to this bucket to an IAM principal.
         * <p>
         * If encryption is used, permission to use the key to encrypt the contents
         * of written files will also be granted to the same principal.
         * <p>
         * @param identity The principal. This parameter is required.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern) {
            return this.jsiiCall("grantWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Grant write permissions to this bucket to an IAM principal.
         * <p>
         * If encryption is used, permission to use the key to encrypt the contents
         * of written files will also be granted to the same principal.
         * <p>
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return this.jsiiCall("grantWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Defines a CloudWatch event that triggers when something happens to this bucket.
         * <p>
         * Requires that there exists at least one CloudTrail Trail in your account
         * that captures the event. This method will not create the Trail.
         * <p>
         * @param id The id of the rule. This parameter is required.
         * @param options Options for adding the rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions options) {
            return this.jsiiCall("onCloudTrailEvent", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Defines a CloudWatch event that triggers when something happens to this bucket.
         * <p>
         * Requires that there exists at least one CloudTrail Trail in your account
         * that captures the event. This method will not create the Trail.
         * <p>
         * @param id The id of the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailEvent(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return this.jsiiCall("onCloudTrailEvent", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }

        /**
         * Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call.
         * <p>
         * Note that some tools like <code>aws s3 cp</code> will automatically use either
         * PutObject or the multipart upload API depending on the file size,
         * so using <code>onCloudTrailWriteObject</code> may be preferable.
         * <p>
         * Requires that there exists at least one CloudTrail Trail in your account
         * that captures the event. This method will not create the Trail.
         * <p>
         * @param id The id of the rule. This parameter is required.
         * @param options Options for adding the rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailPutObject(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions options) {
            return this.jsiiCall("onCloudTrailPutObject", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call.
         * <p>
         * Note that some tools like <code>aws s3 cp</code> will automatically use either
         * PutObject or the multipart upload API depending on the file size,
         * so using <code>onCloudTrailWriteObject</code> may be preferable.
         * <p>
         * Requires that there exists at least one CloudTrail Trail in your account
         * that captures the event. This method will not create the Trail.
         * <p>
         * @param id The id of the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailPutObject(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return this.jsiiCall("onCloudTrailPutObject", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }

        /**
         * Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to.
         * <p>
         * This includes
         * the events PutObject, CopyObject, and CompleteMultipartUpload.
         * <p>
         * Note that some tools like <code>aws s3 cp</code> will automatically use either
         * PutObject or the multipart upload API depending on the file size,
         * so using this method may be preferable to <code>onCloudTrailPutObject</code>.
         * <p>
         * Requires that there exists at least one CloudTrail Trail in your account
         * that captures the event. This method will not create the Trail.
         * <p>
         * @param id The id of the rule. This parameter is required.
         * @param options Options for adding the rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailWriteObject(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions options) {
            return this.jsiiCall("onCloudTrailWriteObject", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to.
         * <p>
         * This includes
         * the events PutObject, CopyObject, and CompleteMultipartUpload.
         * <p>
         * Note that some tools like <code>aws s3 cp</code> will automatically use either
         * PutObject or the multipart upload API depending on the file size,
         * so using this method may be preferable to <code>onCloudTrailPutObject</code>.
         * <p>
         * Requires that there exists at least one CloudTrail Trail in your account
         * that captures the event. This method will not create the Trail.
         * <p>
         * @param id The id of the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailWriteObject(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return this.jsiiCall("onCloudTrailWriteObject", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }

        /**
         * The S3 URL of an S3 object.
         * <p>
         * For example:
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * s3:}</pre></blockquote>
         * <p>
         * @return an ObjectS3Url token
         * @param key The S3 key of the object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull java.lang.String s3UrlForObject(final @org.jetbrains.annotations.Nullable java.lang.String key) {
            return this.jsiiCall("s3UrlForObject", java.lang.String.class, new Object[] { key });
        }

        /**
         * The S3 URL of an S3 object.
         * <p>
         * For example:
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * s3:}</pre></blockquote>
         * <p>
         * @return an ObjectS3Url token
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull java.lang.String s3UrlForObject() {
            return this.jsiiCall("s3UrlForObject", java.lang.String.class);
        }

        /**
         * The https URL of an S3 object.
         * <p>
         * For example:
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * https:}</pre></blockquote>
         * <p>
         * @return an ObjectS3Url token
         * @param key The S3 key of the object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull java.lang.String urlForObject(final @org.jetbrains.annotations.Nullable java.lang.String key) {
            return this.jsiiCall("urlForObject", java.lang.String.class, new Object[] { key });
        }

        /**
         * The https URL of an S3 object.
         * <p>
         * For example:
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * https:}</pre></blockquote>
         * <p>
         * @return an ObjectS3Url token
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull java.lang.String urlForObject() {
            return this.jsiiCall("urlForObject", java.lang.String.class);
        }
    }
}
