package software.amazon.awscdk.services.s3;

/**
 * Properties for defining a `AWS::S3::AccessPoint`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-07T19:41:30.788Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnAccessPointProps")
@software.amazon.jsii.Jsii.Proxy(CfnAccessPointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAccessPointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::S3::AccessPoint.Bucket`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-bucket
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucket();

    /**
     * `AWS::S3::AccessPoint.CreationDate`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-creationdate
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCreationDate() {
        return null;
    }

    /**
     * `AWS::S3::AccessPoint.Name`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * `AWS::S3::AccessPoint.NetworkOrigin`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-networkorigin
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNetworkOrigin() {
        return null;
    }

    /**
     * `AWS::S3::AccessPoint.Policy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPolicy() {
        return null;
    }

    /**
     * `AWS::S3::AccessPoint.PolicyStatus`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-policystatus
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPolicyStatus() {
        return null;
    }

    /**
     * `AWS::S3::AccessPoint.PublicAccessBlockConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-publicaccessblockconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPublicAccessBlockConfiguration() {
        return null;
    }

    /**
     * `AWS::S3::AccessPoint.VpcConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-vpcconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAccessPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAccessPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAccessPointProps> {
        private java.lang.String bucket;
        private java.lang.String creationDate;
        private java.lang.String name;
        private java.lang.String networkOrigin;
        private java.lang.Object policy;
        private java.lang.Object policyStatus;
        private java.lang.Object publicAccessBlockConfiguration;
        private java.lang.Object vpcConfiguration;

        /**
         * Sets the value of {@link CfnAccessPointProps#getBucket}
         * @param bucket `AWS::S3::AccessPoint.Bucket`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(java.lang.String bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getCreationDate}
         * @param creationDate `AWS::S3::AccessPoint.CreationDate`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creationDate(java.lang.String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getName}
         * @param name `AWS::S3::AccessPoint.Name`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getNetworkOrigin}
         * @param networkOrigin `AWS::S3::AccessPoint.NetworkOrigin`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkOrigin(java.lang.String networkOrigin) {
            this.networkOrigin = networkOrigin;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getPolicy}
         * @param policy `AWS::S3::AccessPoint.Policy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(java.lang.Object policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getPolicyStatus}
         * @param policyStatus `AWS::S3::AccessPoint.PolicyStatus`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyStatus(java.lang.Object policyStatus) {
            this.policyStatus = policyStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getPublicAccessBlockConfiguration}
         * @param publicAccessBlockConfiguration `AWS::S3::AccessPoint.PublicAccessBlockConfiguration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicAccessBlockConfiguration(software.amazon.awscdk.core.IResolvable publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getPublicAccessBlockConfiguration}
         * @param publicAccessBlockConfiguration `AWS::S3::AccessPoint.PublicAccessBlockConfiguration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicAccessBlockConfiguration(software.amazon.awscdk.services.s3.CfnAccessPoint.PublicAccessBlockConfigurationProperty publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getVpcConfiguration}
         * @param vpcConfiguration `AWS::S3::AccessPoint.VpcConfiguration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfiguration(software.amazon.awscdk.core.IResolvable vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getVpcConfiguration}
         * @param vpcConfiguration `AWS::S3::AccessPoint.VpcConfiguration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfiguration(software.amazon.awscdk.services.s3.CfnAccessPoint.VpcConfigurationProperty vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAccessPointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAccessPointProps build() {
            return new Jsii$Proxy(bucket, creationDate, name, networkOrigin, policy, policyStatus, publicAccessBlockConfiguration, vpcConfiguration);
        }
    }

    /**
     * An implementation for {@link CfnAccessPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAccessPointProps {
        private final java.lang.String bucket;
        private final java.lang.String creationDate;
        private final java.lang.String name;
        private final java.lang.String networkOrigin;
        private final java.lang.Object policy;
        private final java.lang.Object policyStatus;
        private final java.lang.Object publicAccessBlockConfiguration;
        private final java.lang.Object vpcConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = this.jsiiGet("bucket", java.lang.String.class);
            this.creationDate = this.jsiiGet("creationDate", java.lang.String.class);
            this.name = this.jsiiGet("name", java.lang.String.class);
            this.networkOrigin = this.jsiiGet("networkOrigin", java.lang.String.class);
            this.policy = this.jsiiGet("policy", java.lang.Object.class);
            this.policyStatus = this.jsiiGet("policyStatus", java.lang.Object.class);
            this.publicAccessBlockConfiguration = this.jsiiGet("publicAccessBlockConfiguration", java.lang.Object.class);
            this.vpcConfiguration = this.jsiiGet("vpcConfiguration", java.lang.Object.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String bucket, final java.lang.String creationDate, final java.lang.String name, final java.lang.String networkOrigin, final java.lang.Object policy, final java.lang.Object policyStatus, final java.lang.Object publicAccessBlockConfiguration, final java.lang.Object vpcConfiguration) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = java.util.Objects.requireNonNull(bucket, "bucket is required");
            this.creationDate = creationDate;
            this.name = name;
            this.networkOrigin = networkOrigin;
            this.policy = policy;
            this.policyStatus = policyStatus;
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration;
            this.vpcConfiguration = vpcConfiguration;
        }

        @Override
        public java.lang.String getBucket() {
            return this.bucket;
        }

        @Override
        public java.lang.String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public java.lang.String getName() {
            return this.name;
        }

        @Override
        public java.lang.String getNetworkOrigin() {
            return this.networkOrigin;
        }

        @Override
        public java.lang.Object getPolicy() {
            return this.policy;
        }

        @Override
        public java.lang.Object getPolicyStatus() {
            return this.policyStatus;
        }

        @Override
        public java.lang.Object getPublicAccessBlockConfiguration() {
            return this.publicAccessBlockConfiguration;
        }

        @Override
        public java.lang.Object getVpcConfiguration() {
            return this.vpcConfiguration;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucket", om.valueToTree(this.getBucket()));
            if (this.getCreationDate() != null) {
                data.set("creationDate", om.valueToTree(this.getCreationDate()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getNetworkOrigin() != null) {
                data.set("networkOrigin", om.valueToTree(this.getNetworkOrigin()));
            }
            if (this.getPolicy() != null) {
                data.set("policy", om.valueToTree(this.getPolicy()));
            }
            if (this.getPolicyStatus() != null) {
                data.set("policyStatus", om.valueToTree(this.getPolicyStatus()));
            }
            if (this.getPublicAccessBlockConfiguration() != null) {
                data.set("publicAccessBlockConfiguration", om.valueToTree(this.getPublicAccessBlockConfiguration()));
            }
            if (this.getVpcConfiguration() != null) {
                data.set("vpcConfiguration", om.valueToTree(this.getVpcConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnAccessPointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAccessPointProps.Jsii$Proxy that = (CfnAccessPointProps.Jsii$Proxy) o;

            if (!bucket.equals(that.bucket)) return false;
            if (this.creationDate != null ? !this.creationDate.equals(that.creationDate) : that.creationDate != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.networkOrigin != null ? !this.networkOrigin.equals(that.networkOrigin) : that.networkOrigin != null) return false;
            if (this.policy != null ? !this.policy.equals(that.policy) : that.policy != null) return false;
            if (this.policyStatus != null ? !this.policyStatus.equals(that.policyStatus) : that.policyStatus != null) return false;
            if (this.publicAccessBlockConfiguration != null ? !this.publicAccessBlockConfiguration.equals(that.publicAccessBlockConfiguration) : that.publicAccessBlockConfiguration != null) return false;
            return this.vpcConfiguration != null ? this.vpcConfiguration.equals(that.vpcConfiguration) : that.vpcConfiguration == null;
        }

        @Override
        public int hashCode() {
            int result = this.bucket.hashCode();
            result = 31 * result + (this.creationDate != null ? this.creationDate.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.networkOrigin != null ? this.networkOrigin.hashCode() : 0);
            result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
            result = 31 * result + (this.policyStatus != null ? this.policyStatus.hashCode() : 0);
            result = 31 * result + (this.publicAccessBlockConfiguration != null ? this.publicAccessBlockConfiguration.hashCode() : 0);
            result = 31 * result + (this.vpcConfiguration != null ? this.vpcConfiguration.hashCode() : 0);
            return result;
        }
    }
}
