/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.services.s3.$Module;
import software.amazon.awscdk.services.s3.CfnBucket;
import software.amazon.awscdk.services.s3.CfnBucketProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-s3.CfnBucket")
public class CfnBucket
extends CfnResource {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnBucket.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnBucket(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnBucket(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnBucket(Construct scope, String id, CfnBucketProps props) {
        super(JsiiObject.InitializationMode.JSII);
        this.setObjRef(JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props}));
    }

    public CfnBucket(Construct scope, String id) {
        super(JsiiObject.InitializationMode.JSII);
        this.setObjRef(JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")}));
    }

    protected Map<String, Object> renderProperties(Map<String, Object> props) {
        return (Map)this.jsiiCall("renderProperties", Map.class, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public String getAttrArn() {
        return (String)this.jsiiGet("attrArn", String.class);
    }

    public String getAttrDomainName() {
        return (String)this.jsiiGet("attrDomainName", String.class);
    }

    public String getAttrDualStackDomainName() {
        return (String)this.jsiiGet("attrDualStackDomainName", String.class);
    }

    public String getAttrRegionalDomainName() {
        return (String)this.jsiiGet("attrRegionalDomainName", String.class);
    }

    public String getAttrWebsiteUrl() {
        return (String)this.jsiiGet("attrWebsiteUrl", String.class);
    }

    protected Map<String, Object> getCfnProperties() {
        return (Map)this.jsiiGet("cfnProperties", Map.class);
    }

    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    public Object getAccelerateConfiguration() {
        return this.jsiiGet("accelerateConfiguration", Object.class);
    }

    public void setAccelerateConfiguration(AccelerateConfigurationProperty value) {
        this.jsiiSet("accelerateConfiguration", value);
    }

    public void setAccelerateConfiguration(IResolvable value) {
        this.jsiiSet("accelerateConfiguration", value);
    }

    public String getAccessControl() {
        return (String)this.jsiiGet("accessControl", String.class);
    }

    public void setAccessControl(String value) {
        this.jsiiSet("accessControl", value);
    }

    public Object getAnalyticsConfigurations() {
        return this.jsiiGet("analyticsConfigurations", Object.class);
    }

    public void setAnalyticsConfigurations(IResolvable value) {
        this.jsiiSet("analyticsConfigurations", value);
    }

    public void setAnalyticsConfigurations(List<Object> value) {
        this.jsiiSet("analyticsConfigurations", value);
    }

    public Object getBucketEncryption() {
        return this.jsiiGet("bucketEncryption", Object.class);
    }

    public void setBucketEncryption(IResolvable value) {
        this.jsiiSet("bucketEncryption", value);
    }

    public void setBucketEncryption(BucketEncryptionProperty value) {
        this.jsiiSet("bucketEncryption", value);
    }

    public String getBucketName() {
        return (String)this.jsiiGet("bucketName", String.class);
    }

    public void setBucketName(String value) {
        this.jsiiSet("bucketName", value);
    }

    public Object getCorsConfiguration() {
        return this.jsiiGet("corsConfiguration", Object.class);
    }

    public void setCorsConfiguration(IResolvable value) {
        this.jsiiSet("corsConfiguration", value);
    }

    public void setCorsConfiguration(CorsConfigurationProperty value) {
        this.jsiiSet("corsConfiguration", value);
    }

    public Object getInventoryConfigurations() {
        return this.jsiiGet("inventoryConfigurations", Object.class);
    }

    public void setInventoryConfigurations(IResolvable value) {
        this.jsiiSet("inventoryConfigurations", value);
    }

    public void setInventoryConfigurations(List<Object> value) {
        this.jsiiSet("inventoryConfigurations", value);
    }

    public Object getLifecycleConfiguration() {
        return this.jsiiGet("lifecycleConfiguration", Object.class);
    }

    public void setLifecycleConfiguration(IResolvable value) {
        this.jsiiSet("lifecycleConfiguration", value);
    }

    public void setLifecycleConfiguration(LifecycleConfigurationProperty value) {
        this.jsiiSet("lifecycleConfiguration", value);
    }

    public Object getLoggingConfiguration() {
        return this.jsiiGet("loggingConfiguration", Object.class);
    }

    public void setLoggingConfiguration(IResolvable value) {
        this.jsiiSet("loggingConfiguration", value);
    }

    public void setLoggingConfiguration(LoggingConfigurationProperty value) {
        this.jsiiSet("loggingConfiguration", value);
    }

    public Object getMetricsConfigurations() {
        return this.jsiiGet("metricsConfigurations", Object.class);
    }

    public void setMetricsConfigurations(IResolvable value) {
        this.jsiiSet("metricsConfigurations", value);
    }

    public void setMetricsConfigurations(List<Object> value) {
        this.jsiiSet("metricsConfigurations", value);
    }

    public Object getNotificationConfiguration() {
        return this.jsiiGet("notificationConfiguration", Object.class);
    }

    public void setNotificationConfiguration(IResolvable value) {
        this.jsiiSet("notificationConfiguration", value);
    }

    public void setNotificationConfiguration(NotificationConfigurationProperty value) {
        this.jsiiSet("notificationConfiguration", value);
    }

    public Object getObjectLockConfiguration() {
        return this.jsiiGet("objectLockConfiguration", Object.class);
    }

    public void setObjectLockConfiguration(IResolvable value) {
        this.jsiiSet("objectLockConfiguration", value);
    }

    public void setObjectLockConfiguration(ObjectLockConfigurationProperty value) {
        this.jsiiSet("objectLockConfiguration", value);
    }

    public Object getObjectLockEnabled() {
        return this.jsiiGet("objectLockEnabled", Object.class);
    }

    public void setObjectLockEnabled(Boolean value) {
        this.jsiiSet("objectLockEnabled", value);
    }

    public void setObjectLockEnabled(IResolvable value) {
        this.jsiiSet("objectLockEnabled", value);
    }

    public Object getPublicAccessBlockConfiguration() {
        return this.jsiiGet("publicAccessBlockConfiguration", Object.class);
    }

    public void setPublicAccessBlockConfiguration(IResolvable value) {
        this.jsiiSet("publicAccessBlockConfiguration", value);
    }

    public void setPublicAccessBlockConfiguration(PublicAccessBlockConfigurationProperty value) {
        this.jsiiSet("publicAccessBlockConfiguration", value);
    }

    public Object getReplicationConfiguration() {
        return this.jsiiGet("replicationConfiguration", Object.class);
    }

    public void setReplicationConfiguration(IResolvable value) {
        this.jsiiSet("replicationConfiguration", value);
    }

    public void setReplicationConfiguration(ReplicationConfigurationProperty value) {
        this.jsiiSet("replicationConfiguration", value);
    }

    public Object getVersioningConfiguration() {
        return this.jsiiGet("versioningConfiguration", Object.class);
    }

    public void setVersioningConfiguration(IResolvable value) {
        this.jsiiSet("versioningConfiguration", value);
    }

    public void setVersioningConfiguration(VersioningConfigurationProperty value) {
        this.jsiiSet("versioningConfiguration", value);
    }

    public Object getWebsiteConfiguration() {
        return this.jsiiGet("websiteConfiguration", Object.class);
    }

    public void setWebsiteConfiguration(IResolvable value) {
        this.jsiiSet("websiteConfiguration", value);
    }

    public void setWebsiteConfiguration(WebsiteConfigurationProperty value) {
        this.jsiiSet("websiteConfiguration", value);
    }

    public static interface WebsiteConfigurationProperty
    extends JsiiSerializable {
        public String getErrorDocument();

        public String getIndexDocument();

        public Object getRedirectAllRequestsTo();

        public Object getRoutingRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String errorDocument;
            private String indexDocument;
            private Object redirectAllRequestsTo;
            private Object routingRules;

            public Builder errorDocument(String errorDocument) {
                this.errorDocument = errorDocument;
                return this;
            }

            public Builder indexDocument(String indexDocument) {
                this.indexDocument = indexDocument;
                return this;
            }

            public Builder redirectAllRequestsTo(IResolvable redirectAllRequestsTo) {
                this.redirectAllRequestsTo = redirectAllRequestsTo;
                return this;
            }

            public Builder redirectAllRequestsTo(RedirectAllRequestsToProperty redirectAllRequestsTo) {
                this.redirectAllRequestsTo = redirectAllRequestsTo;
                return this;
            }

            public Builder routingRules(IResolvable routingRules) {
                this.routingRules = routingRules;
                return this;
            }

            public Builder routingRules(List<Object> routingRules) {
                this.routingRules = routingRules;
                return this;
            }

            public WebsiteConfigurationProperty build() {
                return new Jsii.Proxy(this.errorDocument, this.indexDocument, this.redirectAllRequestsTo, this.routingRules, null);
            }
        }
    }

    public static interface VersioningConfigurationProperty
    extends JsiiSerializable {
        public String getStatus();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String status;

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public VersioningConfigurationProperty build() {
                return new Jsii.Proxy(this.status, null);
            }
        }
    }

    public static interface TransitionProperty
    extends JsiiSerializable {
        public String getStorageClass();

        public Object getTransitionDate();

        public Number getTransitionInDays();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String storageClass;
            private Object transitionDate;
            private Number transitionInDays;

            public Builder storageClass(String storageClass) {
                this.storageClass = storageClass;
                return this;
            }

            public Builder transitionDate(Instant transitionDate) {
                this.transitionDate = transitionDate;
                return this;
            }

            public Builder transitionDate(IResolvable transitionDate) {
                this.transitionDate = transitionDate;
                return this;
            }

            public Builder transitionInDays(Number transitionInDays) {
                this.transitionInDays = transitionInDays;
                return this;
            }

            public TransitionProperty build() {
                return new Jsii.Proxy(this.storageClass, this.transitionDate, this.transitionInDays, null);
            }
        }
    }

    public static interface TopicConfigurationProperty
    extends JsiiSerializable {
        public String getEvent();

        public String getTopic();

        public Object getFilter();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String event;
            private String topic;
            private Object filter;

            public Builder event(String event) {
                this.event = event;
                return this;
            }

            public Builder topic(String topic) {
                this.topic = topic;
                return this;
            }

            public Builder filter(IResolvable filter) {
                this.filter = filter;
                return this;
            }

            public Builder filter(NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            public TopicConfigurationProperty build() {
                return new Jsii.Proxy(this.event, this.topic, this.filter, null);
            }
        }
    }

    public static interface TagFilterProperty
    extends JsiiSerializable {
        public String getKey();

        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public TagFilterProperty build() {
                return new Jsii.Proxy(this.key, this.value, null);
            }
        }
    }

    public static interface StorageClassAnalysisProperty
    extends JsiiSerializable {
        public Object getDataExport();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object dataExport;

            public Builder dataExport(IResolvable dataExport) {
                this.dataExport = dataExport;
                return this;
            }

            public Builder dataExport(DataExportProperty dataExport) {
                this.dataExport = dataExport;
                return this;
            }

            public StorageClassAnalysisProperty build() {
                return new Jsii.Proxy(this.dataExport, null);
            }
        }
    }

    public static interface SseKmsEncryptedObjectsProperty
    extends JsiiSerializable {
        public String getStatus();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String status;

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public SseKmsEncryptedObjectsProperty build() {
                return new Jsii.Proxy(this.status, null);
            }
        }
    }

    public static interface SourceSelectionCriteriaProperty
    extends JsiiSerializable {
        public Object getSseKmsEncryptedObjects();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object sseKmsEncryptedObjects;

            public Builder sseKmsEncryptedObjects(IResolvable sseKmsEncryptedObjects) {
                this.sseKmsEncryptedObjects = sseKmsEncryptedObjects;
                return this;
            }

            public Builder sseKmsEncryptedObjects(SseKmsEncryptedObjectsProperty sseKmsEncryptedObjects) {
                this.sseKmsEncryptedObjects = sseKmsEncryptedObjects;
                return this;
            }

            public SourceSelectionCriteriaProperty build() {
                return new Jsii.Proxy(this.sseKmsEncryptedObjects, null);
            }
        }
    }

    public static interface ServerSideEncryptionRuleProperty
    extends JsiiSerializable {
        public Object getServerSideEncryptionByDefault();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object serverSideEncryptionByDefault;

            public Builder serverSideEncryptionByDefault(IResolvable serverSideEncryptionByDefault) {
                this.serverSideEncryptionByDefault = serverSideEncryptionByDefault;
                return this;
            }

            public Builder serverSideEncryptionByDefault(ServerSideEncryptionByDefaultProperty serverSideEncryptionByDefault) {
                this.serverSideEncryptionByDefault = serverSideEncryptionByDefault;
                return this;
            }

            public ServerSideEncryptionRuleProperty build() {
                return new Jsii.Proxy(this.serverSideEncryptionByDefault, null);
            }
        }
    }

    public static interface ServerSideEncryptionByDefaultProperty
    extends JsiiSerializable {
        public String getSseAlgorithm();

        public String getKmsMasterKeyId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String sseAlgorithm;
            private String kmsMasterKeyId;

            public Builder sseAlgorithm(String sseAlgorithm) {
                this.sseAlgorithm = sseAlgorithm;
                return this;
            }

            public Builder kmsMasterKeyId(String kmsMasterKeyId) {
                this.kmsMasterKeyId = kmsMasterKeyId;
                return this;
            }

            public ServerSideEncryptionByDefaultProperty build() {
                return new Jsii.Proxy(this.sseAlgorithm, this.kmsMasterKeyId, null);
            }
        }
    }

    public static interface S3KeyFilterProperty
    extends JsiiSerializable {
        public Object getRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object rules;

            public Builder rules(IResolvable rules) {
                this.rules = rules;
                return this;
            }

            public Builder rules(List<Object> rules) {
                this.rules = rules;
                return this;
            }

            public S3KeyFilterProperty build() {
                return new Jsii.Proxy(this.rules, null);
            }
        }
    }

    public static interface RuleProperty
    extends JsiiSerializable {
        public String getStatus();

        public Object getAbortIncompleteMultipartUpload();

        public Object getExpirationDate();

        public Number getExpirationInDays();

        public String getId();

        public Number getNoncurrentVersionExpirationInDays();

        public Object getNoncurrentVersionTransition();

        public Object getNoncurrentVersionTransitions();

        public String getPrefix();

        public Object getTagFilters();

        public Object getTransition();

        public Object getTransitions();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String status;
            private Object abortIncompleteMultipartUpload;
            private Object expirationDate;
            private Number expirationInDays;
            private String id;
            private Number noncurrentVersionExpirationInDays;
            private Object noncurrentVersionTransition;
            private Object noncurrentVersionTransitions;
            private String prefix;
            private Object tagFilters;
            private Object transition;
            private Object transitions;

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public Builder abortIncompleteMultipartUpload(IResolvable abortIncompleteMultipartUpload) {
                this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
                return this;
            }

            public Builder abortIncompleteMultipartUpload(AbortIncompleteMultipartUploadProperty abortIncompleteMultipartUpload) {
                this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
                return this;
            }

            public Builder expirationDate(Instant expirationDate) {
                this.expirationDate = expirationDate;
                return this;
            }

            public Builder expirationDate(IResolvable expirationDate) {
                this.expirationDate = expirationDate;
                return this;
            }

            public Builder expirationInDays(Number expirationInDays) {
                this.expirationInDays = expirationInDays;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder noncurrentVersionExpirationInDays(Number noncurrentVersionExpirationInDays) {
                this.noncurrentVersionExpirationInDays = noncurrentVersionExpirationInDays;
                return this;
            }

            public Builder noncurrentVersionTransition(IResolvable noncurrentVersionTransition) {
                this.noncurrentVersionTransition = noncurrentVersionTransition;
                return this;
            }

            public Builder noncurrentVersionTransition(NoncurrentVersionTransitionProperty noncurrentVersionTransition) {
                this.noncurrentVersionTransition = noncurrentVersionTransition;
                return this;
            }

            public Builder noncurrentVersionTransitions(IResolvable noncurrentVersionTransitions) {
                this.noncurrentVersionTransitions = noncurrentVersionTransitions;
                return this;
            }

            public Builder noncurrentVersionTransitions(List<Object> noncurrentVersionTransitions) {
                this.noncurrentVersionTransitions = noncurrentVersionTransitions;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder tagFilters(IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public Builder tagFilters(List<Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public Builder transition(IResolvable transition) {
                this.transition = transition;
                return this;
            }

            public Builder transition(TransitionProperty transition) {
                this.transition = transition;
                return this;
            }

            public Builder transitions(IResolvable transitions) {
                this.transitions = transitions;
                return this;
            }

            public Builder transitions(List<Object> transitions) {
                this.transitions = transitions;
                return this;
            }

            public RuleProperty build() {
                return new Jsii.Proxy(this.status, this.abortIncompleteMultipartUpload, this.expirationDate, this.expirationInDays, this.id, this.noncurrentVersionExpirationInDays, this.noncurrentVersionTransition, this.noncurrentVersionTransitions, this.prefix, this.tagFilters, this.transition, this.transitions, null);
            }
        }
    }

    public static interface RoutingRuleProperty
    extends JsiiSerializable {
        public Object getRedirectRule();

        public Object getRoutingRuleCondition();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object redirectRule;
            private Object routingRuleCondition;

            public Builder redirectRule(IResolvable redirectRule) {
                this.redirectRule = redirectRule;
                return this;
            }

            public Builder redirectRule(RedirectRuleProperty redirectRule) {
                this.redirectRule = redirectRule;
                return this;
            }

            public Builder routingRuleCondition(IResolvable routingRuleCondition) {
                this.routingRuleCondition = routingRuleCondition;
                return this;
            }

            public Builder routingRuleCondition(RoutingRuleConditionProperty routingRuleCondition) {
                this.routingRuleCondition = routingRuleCondition;
                return this;
            }

            public RoutingRuleProperty build() {
                return new Jsii.Proxy(this.redirectRule, this.routingRuleCondition, null);
            }
        }
    }

    public static interface RoutingRuleConditionProperty
    extends JsiiSerializable {
        public String getHttpErrorCodeReturnedEquals();

        public String getKeyPrefixEquals();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String httpErrorCodeReturnedEquals;
            private String keyPrefixEquals;

            public Builder httpErrorCodeReturnedEquals(String httpErrorCodeReturnedEquals) {
                this.httpErrorCodeReturnedEquals = httpErrorCodeReturnedEquals;
                return this;
            }

            public Builder keyPrefixEquals(String keyPrefixEquals) {
                this.keyPrefixEquals = keyPrefixEquals;
                return this;
            }

            public RoutingRuleConditionProperty build() {
                return new Jsii.Proxy(this.httpErrorCodeReturnedEquals, this.keyPrefixEquals, null);
            }
        }
    }

    public static interface ReplicationRuleProperty
    extends JsiiSerializable {
        public Object getDestination();

        public String getPrefix();

        public String getStatus();

        public String getId();

        public Object getSourceSelectionCriteria();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object destination;
            private String prefix;
            private String status;
            private String id;
            private Object sourceSelectionCriteria;

            public Builder destination(IResolvable destination) {
                this.destination = destination;
                return this;
            }

            public Builder destination(ReplicationDestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder sourceSelectionCriteria(IResolvable sourceSelectionCriteria) {
                this.sourceSelectionCriteria = sourceSelectionCriteria;
                return this;
            }

            public Builder sourceSelectionCriteria(SourceSelectionCriteriaProperty sourceSelectionCriteria) {
                this.sourceSelectionCriteria = sourceSelectionCriteria;
                return this;
            }

            public ReplicationRuleProperty build() {
                return new Jsii.Proxy(this.destination, this.prefix, this.status, this.id, this.sourceSelectionCriteria, null);
            }
        }
    }

    public static interface ReplicationDestinationProperty
    extends JsiiSerializable {
        public String getBucket();

        public Object getAccessControlTranslation();

        public String getAccount();

        public Object getEncryptionConfiguration();

        public String getStorageClass();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String bucket;
            private Object accessControlTranslation;
            private String account;
            private Object encryptionConfiguration;
            private String storageClass;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder accessControlTranslation(IResolvable accessControlTranslation) {
                this.accessControlTranslation = accessControlTranslation;
                return this;
            }

            public Builder accessControlTranslation(AccessControlTranslationProperty accessControlTranslation) {
                this.accessControlTranslation = accessControlTranslation;
                return this;
            }

            public Builder account(String account) {
                this.account = account;
                return this;
            }

            public Builder encryptionConfiguration(IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            public Builder encryptionConfiguration(EncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            public Builder storageClass(String storageClass) {
                this.storageClass = storageClass;
                return this;
            }

            public ReplicationDestinationProperty build() {
                return new Jsii.Proxy(this.bucket, this.accessControlTranslation, this.account, this.encryptionConfiguration, this.storageClass, null);
            }
        }
    }

    public static interface ReplicationConfigurationProperty
    extends JsiiSerializable {
        public String getRole();

        public Object getRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String role;
            private Object rules;

            public Builder role(String role) {
                this.role = role;
                return this;
            }

            public Builder rules(IResolvable rules) {
                this.rules = rules;
                return this;
            }

            public Builder rules(List<Object> rules) {
                this.rules = rules;
                return this;
            }

            public ReplicationConfigurationProperty build() {
                return new Jsii.Proxy(this.role, this.rules, null);
            }
        }
    }

    public static interface RedirectRuleProperty
    extends JsiiSerializable {
        public String getHostName();

        public String getHttpRedirectCode();

        public String getProtocol();

        public String getReplaceKeyPrefixWith();

        public String getReplaceKeyWith();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String hostName;
            private String httpRedirectCode;
            private String protocol;
            private String replaceKeyPrefixWith;
            private String replaceKeyWith;

            public Builder hostName(String hostName) {
                this.hostName = hostName;
                return this;
            }

            public Builder httpRedirectCode(String httpRedirectCode) {
                this.httpRedirectCode = httpRedirectCode;
                return this;
            }

            public Builder protocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            public Builder replaceKeyPrefixWith(String replaceKeyPrefixWith) {
                this.replaceKeyPrefixWith = replaceKeyPrefixWith;
                return this;
            }

            public Builder replaceKeyWith(String replaceKeyWith) {
                this.replaceKeyWith = replaceKeyWith;
                return this;
            }

            public RedirectRuleProperty build() {
                return new Jsii.Proxy(this.hostName, this.httpRedirectCode, this.protocol, this.replaceKeyPrefixWith, this.replaceKeyWith, null);
            }
        }
    }

    public static interface RedirectAllRequestsToProperty
    extends JsiiSerializable {
        public String getHostName();

        public String getProtocol();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String hostName;
            private String protocol;

            public Builder hostName(String hostName) {
                this.hostName = hostName;
                return this;
            }

            public Builder protocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            public RedirectAllRequestsToProperty build() {
                return new Jsii.Proxy(this.hostName, this.protocol, null);
            }
        }
    }

    public static interface QueueConfigurationProperty
    extends JsiiSerializable {
        public String getEvent();

        public String getQueue();

        public Object getFilter();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String event;
            private String queue;
            private Object filter;

            public Builder event(String event) {
                this.event = event;
                return this;
            }

            public Builder queue(String queue) {
                this.queue = queue;
                return this;
            }

            public Builder filter(IResolvable filter) {
                this.filter = filter;
                return this;
            }

            public Builder filter(NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            public QueueConfigurationProperty build() {
                return new Jsii.Proxy(this.event, this.queue, this.filter, null);
            }
        }
    }

    public static interface PublicAccessBlockConfigurationProperty
    extends JsiiSerializable {
        public Object getBlockPublicAcls();

        public Object getBlockPublicPolicy();

        public Object getIgnorePublicAcls();

        public Object getRestrictPublicBuckets();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object blockPublicAcls;
            private Object blockPublicPolicy;
            private Object ignorePublicAcls;
            private Object restrictPublicBuckets;

            public Builder blockPublicAcls(Boolean blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            public Builder blockPublicAcls(IResolvable blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            public Builder blockPublicPolicy(Boolean blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            public Builder blockPublicPolicy(IResolvable blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            public Builder ignorePublicAcls(Boolean ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            public Builder ignorePublicAcls(IResolvable ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            public Builder restrictPublicBuckets(Boolean restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            public Builder restrictPublicBuckets(IResolvable restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            public PublicAccessBlockConfigurationProperty build() {
                return new Jsii.Proxy(this.blockPublicAcls, this.blockPublicPolicy, this.ignorePublicAcls, this.restrictPublicBuckets, null);
            }
        }
    }

    public static interface ObjectLockRuleProperty
    extends JsiiSerializable {
        public Object getDefaultRetention();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object defaultRetention;

            public Builder defaultRetention(IResolvable defaultRetention) {
                this.defaultRetention = defaultRetention;
                return this;
            }

            public Builder defaultRetention(DefaultRetentionProperty defaultRetention) {
                this.defaultRetention = defaultRetention;
                return this;
            }

            public ObjectLockRuleProperty build() {
                return new Jsii.Proxy(this.defaultRetention, null);
            }
        }
    }

    public static interface ObjectLockConfigurationProperty
    extends JsiiSerializable {
        public String getObjectLockEnabled();

        public Object getRule();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String objectLockEnabled;
            private Object rule;

            public Builder objectLockEnabled(String objectLockEnabled) {
                this.objectLockEnabled = objectLockEnabled;
                return this;
            }

            public Builder rule(IResolvable rule) {
                this.rule = rule;
                return this;
            }

            public Builder rule(ObjectLockRuleProperty rule) {
                this.rule = rule;
                return this;
            }

            public ObjectLockConfigurationProperty build() {
                return new Jsii.Proxy(this.objectLockEnabled, this.rule, null);
            }
        }
    }

    public static interface NotificationFilterProperty
    extends JsiiSerializable {
        public Object getS3Key();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object s3Key;

            public Builder s3Key(IResolvable s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            public Builder s3Key(S3KeyFilterProperty s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            public NotificationFilterProperty build() {
                return new Jsii.Proxy(this.s3Key, null);
            }
        }
    }

    public static interface NotificationConfigurationProperty
    extends JsiiSerializable {
        public Object getLambdaConfigurations();

        public Object getQueueConfigurations();

        public Object getTopicConfigurations();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object lambdaConfigurations;
            private Object queueConfigurations;
            private Object topicConfigurations;

            public Builder lambdaConfigurations(IResolvable lambdaConfigurations) {
                this.lambdaConfigurations = lambdaConfigurations;
                return this;
            }

            public Builder lambdaConfigurations(List<Object> lambdaConfigurations) {
                this.lambdaConfigurations = lambdaConfigurations;
                return this;
            }

            public Builder queueConfigurations(IResolvable queueConfigurations) {
                this.queueConfigurations = queueConfigurations;
                return this;
            }

            public Builder queueConfigurations(List<Object> queueConfigurations) {
                this.queueConfigurations = queueConfigurations;
                return this;
            }

            public Builder topicConfigurations(IResolvable topicConfigurations) {
                this.topicConfigurations = topicConfigurations;
                return this;
            }

            public Builder topicConfigurations(List<Object> topicConfigurations) {
                this.topicConfigurations = topicConfigurations;
                return this;
            }

            public NotificationConfigurationProperty build() {
                return new Jsii.Proxy(this.lambdaConfigurations, this.queueConfigurations, this.topicConfigurations, null);
            }
        }
    }

    public static interface NoncurrentVersionTransitionProperty
    extends JsiiSerializable {
        public String getStorageClass();

        public Number getTransitionInDays();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String storageClass;
            private Number transitionInDays;

            public Builder storageClass(String storageClass) {
                this.storageClass = storageClass;
                return this;
            }

            public Builder transitionInDays(Number transitionInDays) {
                this.transitionInDays = transitionInDays;
                return this;
            }

            public NoncurrentVersionTransitionProperty build() {
                return new Jsii.Proxy(this.storageClass, this.transitionInDays, null);
            }
        }
    }

    public static interface MetricsConfigurationProperty
    extends JsiiSerializable {
        public String getId();

        public String getPrefix();

        public Object getTagFilters();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String id;
            private String prefix;
            private Object tagFilters;

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder tagFilters(IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public Builder tagFilters(List<Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public MetricsConfigurationProperty build() {
                return new Jsii.Proxy(this.id, this.prefix, this.tagFilters, null);
            }
        }
    }

    public static interface LoggingConfigurationProperty
    extends JsiiSerializable {
        public String getDestinationBucketName();

        public String getLogFilePrefix();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String destinationBucketName;
            private String logFilePrefix;

            public Builder destinationBucketName(String destinationBucketName) {
                this.destinationBucketName = destinationBucketName;
                return this;
            }

            public Builder logFilePrefix(String logFilePrefix) {
                this.logFilePrefix = logFilePrefix;
                return this;
            }

            public LoggingConfigurationProperty build() {
                return new Jsii.Proxy(this.destinationBucketName, this.logFilePrefix, null);
            }
        }
    }

    public static interface LifecycleConfigurationProperty
    extends JsiiSerializable {
        public Object getRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object rules;

            public Builder rules(IResolvable rules) {
                this.rules = rules;
                return this;
            }

            public Builder rules(List<Object> rules) {
                this.rules = rules;
                return this;
            }

            public LifecycleConfigurationProperty build() {
                return new Jsii.Proxy(this.rules, null);
            }
        }
    }

    public static interface LambdaConfigurationProperty
    extends JsiiSerializable {
        public String getEvent();

        public String getFunction();

        public Object getFilter();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String event;
            private String function;
            private Object filter;

            public Builder event(String event) {
                this.event = event;
                return this;
            }

            public Builder function(String function) {
                this.function = function;
                return this;
            }

            public Builder filter(IResolvable filter) {
                this.filter = filter;
                return this;
            }

            public Builder filter(NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            public LambdaConfigurationProperty build() {
                return new Jsii.Proxy(this.event, this.function, this.filter, null);
            }
        }
    }

    public static interface InventoryConfigurationProperty
    extends JsiiSerializable {
        public Object getDestination();

        public Object getEnabled();

        public String getId();

        public String getIncludedObjectVersions();

        public String getScheduleFrequency();

        public List<String> getOptionalFields();

        public String getPrefix();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object destination;
            private Object enabled;
            private String id;
            private String includedObjectVersions;
            private String scheduleFrequency;
            private List<String> optionalFields;
            private String prefix;

            public Builder destination(IResolvable destination) {
                this.destination = destination;
                return this;
            }

            public Builder destination(DestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder includedObjectVersions(String includedObjectVersions) {
                this.includedObjectVersions = includedObjectVersions;
                return this;
            }

            public Builder scheduleFrequency(String scheduleFrequency) {
                this.scheduleFrequency = scheduleFrequency;
                return this;
            }

            public Builder optionalFields(List<String> optionalFields) {
                this.optionalFields = optionalFields;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public InventoryConfigurationProperty build() {
                return new Jsii.Proxy(this.destination, this.enabled, this.id, this.includedObjectVersions, this.scheduleFrequency, this.optionalFields, this.prefix, null);
            }
        }
    }

    public static interface FilterRuleProperty
    extends JsiiSerializable {
        public String getName();

        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String name;
            private String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public FilterRuleProperty build() {
                return new Jsii.Proxy(this.name, this.value, null);
            }
        }
    }

    public static interface EncryptionConfigurationProperty
    extends JsiiSerializable {
        public String getReplicaKmsKeyId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String replicaKmsKeyId;

            public Builder replicaKmsKeyId(String replicaKmsKeyId) {
                this.replicaKmsKeyId = replicaKmsKeyId;
                return this;
            }

            public EncryptionConfigurationProperty build() {
                return new Jsii.Proxy(this.replicaKmsKeyId, null);
            }
        }
    }

    public static interface DestinationProperty
    extends JsiiSerializable {
        public String getBucketArn();

        public String getFormat();

        public String getBucketAccountId();

        public String getPrefix();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String bucketArn;
            private String format;
            private String bucketAccountId;
            private String prefix;

            public Builder bucketArn(String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            public Builder format(String format) {
                this.format = format;
                return this;
            }

            public Builder bucketAccountId(String bucketAccountId) {
                this.bucketAccountId = bucketAccountId;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public DestinationProperty build() {
                return new Jsii.Proxy(this.bucketArn, this.format, this.bucketAccountId, this.prefix, null);
            }
        }
    }

    public static interface DefaultRetentionProperty
    extends JsiiSerializable {
        public Number getDays();

        public String getMode();

        public Number getYears();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Number days;
            private String mode;
            private Number years;

            public Builder days(Number days) {
                this.days = days;
                return this;
            }

            public Builder mode(String mode) {
                this.mode = mode;
                return this;
            }

            public Builder years(Number years) {
                this.years = years;
                return this;
            }

            public DefaultRetentionProperty build() {
                return new Jsii.Proxy(this.days, this.mode, this.years, null);
            }
        }
    }

    public static interface DataExportProperty
    extends JsiiSerializable {
        public Object getDestination();

        public String getOutputSchemaVersion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object destination;
            private String outputSchemaVersion;

            public Builder destination(IResolvable destination) {
                this.destination = destination;
                return this;
            }

            public Builder destination(DestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            public Builder outputSchemaVersion(String outputSchemaVersion) {
                this.outputSchemaVersion = outputSchemaVersion;
                return this;
            }

            public DataExportProperty build() {
                return new Jsii.Proxy(this.destination, this.outputSchemaVersion, null);
            }
        }
    }

    public static interface CorsRuleProperty
    extends JsiiSerializable {
        public List<String> getAllowedMethods();

        public List<String> getAllowedOrigins();

        public List<String> getAllowedHeaders();

        public List<String> getExposedHeaders();

        public String getId();

        public Number getMaxAge();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<String> allowedMethods;
            private List<String> allowedOrigins;
            private List<String> allowedHeaders;
            private List<String> exposedHeaders;
            private String id;
            private Number maxAge;

            public Builder allowedMethods(List<String> allowedMethods) {
                this.allowedMethods = allowedMethods;
                return this;
            }

            public Builder allowedOrigins(List<String> allowedOrigins) {
                this.allowedOrigins = allowedOrigins;
                return this;
            }

            public Builder allowedHeaders(List<String> allowedHeaders) {
                this.allowedHeaders = allowedHeaders;
                return this;
            }

            public Builder exposedHeaders(List<String> exposedHeaders) {
                this.exposedHeaders = exposedHeaders;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder maxAge(Number maxAge) {
                this.maxAge = maxAge;
                return this;
            }

            public CorsRuleProperty build() {
                return new Jsii.Proxy(this.allowedMethods, this.allowedOrigins, this.allowedHeaders, this.exposedHeaders, this.id, this.maxAge, null);
            }
        }
    }

    public static interface CorsConfigurationProperty
    extends JsiiSerializable {
        public Object getCorsRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object corsRules;

            public Builder corsRules(IResolvable corsRules) {
                this.corsRules = corsRules;
                return this;
            }

            public Builder corsRules(List<Object> corsRules) {
                this.corsRules = corsRules;
                return this;
            }

            public CorsConfigurationProperty build() {
                return new Jsii.Proxy(this.corsRules, null);
            }
        }
    }

    public static interface BucketEncryptionProperty
    extends JsiiSerializable {
        public Object getServerSideEncryptionConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object serverSideEncryptionConfiguration;

            public Builder serverSideEncryptionConfiguration(IResolvable serverSideEncryptionConfiguration) {
                this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
                return this;
            }

            public Builder serverSideEncryptionConfiguration(List<Object> serverSideEncryptionConfiguration) {
                this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
                return this;
            }

            public BucketEncryptionProperty build() {
                return new Jsii.Proxy(this.serverSideEncryptionConfiguration, null);
            }
        }
    }

    public static interface AnalyticsConfigurationProperty
    extends JsiiSerializable {
        public String getId();

        public Object getStorageClassAnalysis();

        public String getPrefix();

        public Object getTagFilters();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String id;
            private Object storageClassAnalysis;
            private String prefix;
            private Object tagFilters;

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder storageClassAnalysis(IResolvable storageClassAnalysis) {
                this.storageClassAnalysis = storageClassAnalysis;
                return this;
            }

            public Builder storageClassAnalysis(StorageClassAnalysisProperty storageClassAnalysis) {
                this.storageClassAnalysis = storageClassAnalysis;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder tagFilters(IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public Builder tagFilters(List<Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public AnalyticsConfigurationProperty build() {
                return new Jsii.Proxy(this.id, this.storageClassAnalysis, this.prefix, this.tagFilters, null);
            }
        }
    }

    public static interface AccessControlTranslationProperty
    extends JsiiSerializable {
        public String getOwner();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String owner;

            public Builder owner(String owner) {
                this.owner = owner;
                return this;
            }

            public AccessControlTranslationProperty build() {
                return new Jsii.Proxy(this.owner, null);
            }
        }
    }

    public static interface AccelerateConfigurationProperty
    extends JsiiSerializable {
        public String getAccelerationStatus();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String accelerationStatus;

            public Builder accelerationStatus(String accelerationStatus) {
                this.accelerationStatus = accelerationStatus;
                return this;
            }

            public AccelerateConfigurationProperty build() {
                return new Jsii.Proxy(this.accelerationStatus, null);
            }
        }
    }

    public static interface AbortIncompleteMultipartUploadProperty
    extends JsiiSerializable {
        public Number getDaysAfterInitiation();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Number daysAfterInitiation;

            public Builder daysAfterInitiation(Number daysAfterInitiation) {
                this.daysAfterInitiation = daysAfterInitiation;
                return this;
            }

            public AbortIncompleteMultipartUploadProperty build() {
                return new Jsii.Proxy(this.daysAfterInitiation, null);
            }
        }
    }
}

