package software.amazon.awscdk.services.s3;

/**
 * Specifies a metrics configuration for the CloudWatch request metrics from an Amazon S3 bucket.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.11.0 (build 1e9b8e1)", date = "2020-09-03T17:04:14.756Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.BucketMetrics")
@software.amazon.jsii.Jsii.Proxy(BucketMetrics.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BucketMetrics extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID used to identify the metrics configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getId();

    /**
     * The prefix that an object must have to be included in the metrics results.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
        return null;
    }

    /**
     * Specifies a list of tag filters to use as a metrics configuration filter.
     * <p>
     * The metrics configuration includes only objects that meet the filter's criteria.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getTagFilters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BucketMetrics}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BucketMetrics}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BucketMetrics> {
        private java.lang.String id;
        private java.lang.String prefix;
        private java.util.Map<java.lang.String, java.lang.Object> tagFilters;

        /**
         * Sets the value of {@link BucketMetrics#getId}
         * @param id The ID used to identify the metrics configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link BucketMetrics#getPrefix}
         * @param prefix The prefix that an object must have to be included in the metrics results.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefix(java.lang.String prefix) {
            this.prefix = prefix;
            return this;
        }

        /**
         * Sets the value of {@link BucketMetrics#getTagFilters}
         * @param tagFilters Specifies a list of tag filters to use as a metrics configuration filter.
         *                   The metrics configuration includes only objects that meet the filter's criteria.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagFilters(java.util.Map<java.lang.String, java.lang.Object> tagFilters) {
            this.tagFilters = tagFilters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketMetrics}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BucketMetrics build() {
            return new Jsii$Proxy(id, prefix, tagFilters);
        }
    }

    /**
     * An implementation for {@link BucketMetrics}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BucketMetrics {
        private final java.lang.String id;
        private final java.lang.String prefix;
        private final java.util.Map<java.lang.String, java.lang.Object> tagFilters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.id = this.jsiiGet("id", java.lang.String.class);
            this.prefix = this.jsiiGet("prefix", java.lang.String.class);
            this.tagFilters = this.jsiiGet("tagFilters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String id, final java.lang.String prefix, final java.util.Map<java.lang.String, java.lang.Object> tagFilters) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.id = java.util.Objects.requireNonNull(id, "id is required");
            this.prefix = prefix;
            this.tagFilters = tagFilters;
        }

        @Override
        public java.lang.String getId() {
            return this.id;
        }

        @Override
        public java.lang.String getPrefix() {
            return this.prefix;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.Object> getTagFilters() {
            return this.tagFilters;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("id", om.valueToTree(this.getId()));
            if (this.getPrefix() != null) {
                data.set("prefix", om.valueToTree(this.getPrefix()));
            }
            if (this.getTagFilters() != null) {
                data.set("tagFilters", om.valueToTree(this.getTagFilters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.BucketMetrics"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BucketMetrics.Jsii$Proxy that = (BucketMetrics.Jsii$Proxy) o;

            if (!id.equals(that.id)) return false;
            if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
            return this.tagFilters != null ? this.tagFilters.equals(that.tagFilters) : that.tagFilters == null;
        }

        @Override
        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
            result = 31 * result + (this.tagFilters != null ? this.tagFilters.hashCode() : 0);
            return result;
        }
    }
}
