/**
 * <h2>Amazon S3 Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * Define an unencrypted S3 bucket.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * new Bucket(this, "MyFirstBucket");
 * </pre></blockquote>
 * <p>
 * <code>Bucket</code> constructs expose the following deploy-time attributes:
 * <p>
 * <ul>
 * <li><code>bucketArn</code> - the ARN of the bucket (i.e. <code>arn:aws:s3:::bucket_name</code>)</li>
 * <li><code>bucketName</code> - the name of the bucket (i.e. <code>bucket_name</code>)</li>
 * <li><code>bucketWebsiteUrl</code> - the Website URL of the bucket (i.e.
 * <code>http://bucket_name.s3-website-us-west-1.amazonaws.com</code>)</li>
 * <li><code>bucketDomainName</code> - the URL of the bucket (i.e. <code>bucket_name.s3.amazonaws.com</code>)</li>
 * <li><code>bucketDualStackDomainName</code> - the dual-stack URL of the bucket (i.e.
 * <code>bucket_name.s3.dualstack.eu-west-1.amazonaws.com</code>)</li>
 * <li><code>bucketRegionalDomainName</code> - the regional URL of the bucket (i.e.
 * <code>bucket_name.s3.eu-west-1.amazonaws.com</code>)</li>
 * <li><code>arnForObjects(pattern)</code> - the ARN of an object or objects within the bucket (i.e.
 * <code>arn:aws:s3:::bucket_name/exampleobject.png</code> or
 * <code>arn:aws:s3:::bucket_name/Development/*</code>)</li>
 * <li><code>urlForObject(key)</code> - the HTTP URL of an object within the bucket (i.e.
 * <code>https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey</code>)</li>
 * <li><code>s3UrlForObject(key)</code> - the S3 URL of an object within the bucket (i.e.
 * <code>s3://bucket/mykey</code>)</li>
 * </ul>
 * <p>
 * <h3>Encryption</h3>
 * <p>
 * Define a KMS-encrypted bucket:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var bucket = Bucket.Builder.create(this, "MyUnencryptedBucket")
 *         .encryption(BucketEncryption.getKMS())
 *         .build();
 * 
 * // you can access the encryption key:
 * assert(bucket.getEncryptionKey() instanceof kms.getKey());
 * </pre></blockquote>
 * <p>
 * You can also supply your own key:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var myKmsKey = new Key(this, "MyKey");
 * 
 * var bucket = Bucket.Builder.create(this, "MyEncryptedBucket")
 *         .encryption(BucketEncryption.getKMS())
 *         .encryptionKey(myKmsKey)
 *         .build();
 * 
 * assert(bucket.getEncryptionKey() === myKmsKey);
 * </pre></blockquote>
 * <p>
 * Use <code>BucketEncryption.ManagedKms</code> to use the S3 master KMS key:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var bucket = Bucket.Builder.create(this, "Buck")
 *         .encryption(BucketEncryption.getKMS_MANAGED())
 *         .build();
 * 
 * assert(bucket.getEncryptionKey() == null);
 * </pre></blockquote>
 * <p>
 * <h3>Permissions</h3>
 * <p>
 * A bucket policy will be automatically created for the bucket upon the first call to
 * <code>addToResourcePolicy(statement)</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var bucket = new Bucket(this, "MyBucket");
 * bucket.addToResourcePolicy(PolicyStatement.Builder.create()
 *         .actions(asList("s3:GetObject"))
 *         .resources(asList(bucket.arnForObjects("file.txt")))
 *         .principals(asList(new AccountRootPrincipal()))
 *         .build());
 * </pre></blockquote>
 * <p>
 * The bucket policy can be directly accessed after creation to add statements or
 * adjust the removal policy.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * bucket.policy.applyRemovalPolicy(RemovalPolicy.getRETAIN());
 * </pre></blockquote>
 * <p>
 * Most of the time, you won't have to manipulate the bucket policy directly.
 * Instead, buckets have "grant" methods called to give prepackaged sets of permissions
 * to other resources. For example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object lambda = Function.Builder.create(this, "Lambda").build();
 * 
 * var bucket = new Bucket(this, "MyBucket");
 * bucket.grantReadWrite(lambda);
 * </pre></blockquote>
 * <p>
 * Will give the Lambda's execution role permissions to read and write
 * from the bucket.
 * <p>
 * <h3>Sharing buckets between stacks</h3>
 * <p>
 * To use a bucket in a different stack in the same CDK application, pass the object to the other stack:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * /**
 *  * Stack that defines the bucket
 *  *{@literal /}
 * public class Producer extends Stack {
 *     public final Bucket myBucket;
 * 
 *     public Producer(App scope, String id) {
 *         this(scope, id, null);
 *     }
 * 
 *     public Producer(App scope, String id, StackProps props) {
 *         super(scope, id, props);
 * 
 *         Bucket bucket = new Bucket(this, "MyBucket", new BucketProps()
 *                 .removalPolicy(cdk.RemovalPolicy.getDESTROY()));
 *         this.myBucket = bucket;
 *     }
 * }
 * 
 * public class ConsumerProps extends StackProps {
 *     private IBucket userBucket;
 *     public IBucket getUserBucket() {
 *         return this.userBucket;
 *     }
 *     public ConsumerProps userBucket(IBucket userBucket) {
 *         this.userBucket = userBucket;
 *         return this;
 *     }
 * }
 * 
 * /**
 *  * Stack that consumes the bucket
 *  *{@literal /}
 * public class Consumer extends Stack {
 *     public Consumer(App scope, String id, ConsumerProps props) {
 *         super(scope, id, props);
 * 
 *         User user = new User(this, "MyUser");
 *         props.userBucket.grantReadWrite(user);
 *     }
 * }
 * 
 * Producer producer = new Producer(app, "ProducerStack");
 * new Consumer(app, "ConsumerStack", new ConsumerProps().userBucket(producer.getMyBucket()));
 * </pre></blockquote>
 * <p>
 * <h3>Importing existing buckets</h3>
 * <p>
 * To import an existing bucket into your CDK application, use the <code>Bucket.fromBucketAttributes</code>
 * factory method. This method accepts <code>BucketAttributes</code> which describes the properties of an already
 * existing bucket:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var bucket = Bucket.fromBucketAttributes(this, "ImportedBucket", Map.of(
 *         "bucketArn", "arn:aws:s3:::my-bucket"));
 * 
 * // now you can just call methods on the bucket
 * bucket.grantReadWrite(user);
 * </pre></blockquote>
 * <p>
 * Alternatively, short-hand factories are available as <code>Bucket.fromBucketName</code> and
 * <code>Bucket.fromBucketArn</code>, which will derive all bucket attributes from the bucket
 * name or ARN respectively:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var byName = Bucket.fromBucketName(this, "BucketByName", "my-bucket");
 * var byArn = Bucket.fromBucketArn(this, "BucketByArn", "arn:aws:s3:::my-bucket");
 * </pre></blockquote>
 * <p>
 * The bucket's region defaults to the current stack's region, but can also be explicitly set in cases where one of the bucket's
 * regional properties needs to contain the correct values.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var myCrossRegionBucket = Bucket.fromBucketAttributes(this, "CrossRegionImport", Map.of(
 *         "bucketArn", "arn:aws:s3:::my-bucket",
 *         "region", "us-east-1"));
 * </pre></blockquote>
 * <p>
 * <h3>Bucket Notifications</h3>
 * <p>
 * The Amazon S3 notification feature enables you to receive notifications when
 * certain events happen in your bucket as described under [S3 Bucket
 * Notifications] of the S3 Developer Guide.
 * <p>
 * To subscribe for bucket notifications, use the <code>bucket.addEventNotification</code> method. The
 * <code>bucket.addObjectCreatedNotification</code> and <code>bucket.addObjectRemovedNotification</code> can also be used for
 * these common use cases.
 * <p>
 * The following example will subscribe an SNS topic to be notified of all <code>s3:ObjectCreated:*</code> events:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.s3.notifications.*;
 * 
 * var myTopic = new Topic(this, "MyTopic");
 * bucket.addEventNotification(s3.EventType.getOBJECT_CREATED(), new SnsDestination(topic));
 * </pre></blockquote>
 * <p>
 * This call will also ensure that the topic policy can accept notifications for
 * this specific bucket.
 * <p>
 * Supported S3 notification targets are exposed by the <code>&#64;aws-cdk/aws-s3-notifications</code> package.
 * <p>
 * It is also possible to specify S3 object key filters when subscribing. The
 * following example will notify <code>myQueue</code> when objects prefixed with <code>foo/</code> and
 * have the <code>.jpg</code> suffix are removed from the bucket.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * bucket.addEventNotification(s3.EventType.getOBJECT_REMOVED(),
 * new SqsDestination(myQueue), Map.of("prefix", "foo/", "suffix", ".jpg"));
 * </pre></blockquote>
 * <p>
 * <h3>Block Public Access</h3>
 * <p>
 * Use <code>blockPublicAccess</code> to specify <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html">block public access settings</a> on the bucket.
 * <p>
 * Enable all block public access settings:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var bucket = Bucket.Builder.create(this, "MyBlockedBucket")
 *         .blockPublicAccess(BlockPublicAccess.getBLOCK_ALL())
 *         .build();
 * </pre></blockquote>
 * <p>
 * Block and ignore public ACLs:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var bucket = Bucket.Builder.create(this, "MyBlockedBucket")
 *         .blockPublicAccess(BlockPublicAccess.getBLOCK_ACLS())
 *         .build();
 * </pre></blockquote>
 * <p>
 * Alternatively, specify the settings manually:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var bucket = Bucket.Builder.create(this, "MyBlockedBucket")
 *         .blockPublicAccess(BlockPublicAccess.Builder.create().blockPublicPolicy(true).build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * When <code>blockPublicPolicy</code> is set to <code>true</code>, <code>grantPublicRead()</code> throws an error.
 * <p>
 * <h3>Logging configuration</h3>
 * <p>
 * Use <code>serverAccessLogsBucket</code> to describe where server access logs are to be stored.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var accessLogsBucket = new Bucket(this, "AccessLogsBucket");
 * 
 * var bucket = Bucket.Builder.create(this, "MyBucket")
 *         .serverAccessLogsBucket(accessLogsBucket)
 *         .build();
 * </pre></blockquote>
 * <p>
 * It's also possible to specify a prefix for Amazon S3 to assign to all log object keys.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var bucket = Bucket.Builder.create(this, "MyBucket")
 *         .serverAccessLogsBucket(accessLogsBucket)
 *         .serverAccessLogsPrefix("logs")
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>S3 Inventory</h3>
 * <p>
 * An <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html">inventory</a> contains a list of the objects in the source bucket and metadata for each object. The inventory lists are stored in the destination bucket as a CSV file compressed with GZIP, as an Apache optimized row columnar (ORC) file compressed with ZLIB, or as an Apache Parquet (Parquet) file compressed with Snappy.
 * <p>
 * You can configure multiple inventory lists for a bucket. You can configure what object metadata to include in the inventory, whether to list all object versions or only current versions, where to store the inventory list file output, and whether to generate the inventory on a daily or weekly basis.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var inventoryBucket = new Bucket(this, "InventoryBucket");
 * 
 * var dataBucket = Bucket.Builder.create(this, "DataBucket")
 *         .inventories(asList(Map.of(
 *                 "frequency", s3.InventoryFrequency.getDAILY(),
 *                 "includeObjectVersions", s3.InventoryObjectVersion.getCURRENT(),
 *                 "destination", Map.of(
 *                         "bucket", inventoryBucket)), Map.of(
 *                 "frequency", s3.InventoryFrequency.getWEEKLY(),
 *                 "includeObjectVersions", s3.InventoryObjectVersion.getALL(),
 *                 "destination", Map.of(
 *                         "bucket", inventoryBucket,
 *                         "prefix", "with-all-versions"))))
 *         .build();
 * </pre></blockquote>
 * <p>
 * If the destination bucket is created as part of the same CDK application, the necessary permissions will be automatically added to the bucket policy.
 * However, if you use an imported bucket (i.e <code>Bucket.fromXXX()</code>), you'll have to make sure it contains the following policy document:
 * <p>
 * <blockquote><pre>
 * {
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Sid": "InventoryAndAnalyticsExamplePolicy",
 *       "Effect": "Allow",
 *       "Principal": { "Service": "s3.amazonaws.com" },
 *       "Action": "s3:PutObject",
 *       "Resource": ["arn:aws:s3:::destinationBucket/*"]
 *     }
 *   ]
 * }
 * </pre></blockquote>
 * <p>
 * <h3>Website redirection</h3>
 * <p>
 * You can use the two following properties to specify the bucket <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html#advanced-conditional-redirects">redirection policy</a>. Please note that these methods cannot both be applied to the same bucket.
 * <p>
 * <h4>Static redirection</h4>
 * <p>
 * You can statically redirect a to a given Bucket URL or any other host name with <code>websiteRedirect</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var bucket = Bucket.Builder.create(this, "MyRedirectedBucket")
 *         .websiteRedirect(Map.of("hostName", "www.example.com"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h4>Routing rules</h4>
 * <p>
 * Alternatively, you can also define multiple <code>websiteRoutingRules</code>, to define complex, conditional redirections:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var bucket = Bucket.Builder.create(this, "MyRedirectedBucket")
 *         .websiteRoutingRules(asList(Map.of(
 *                 "hostName", "www.example.com",
 *                 "httpRedirectCode", "302",
 *                 "protocol", RedirectProtocol.getHTTPS(),
 *                 "replaceKey", ReplaceKey.prefixWith("test/"),
 *                 "condition", Map.of(
 *                         "httpErrorCodeReturnedEquals", "200",
 *                         "keyPrefixEquals", "prefix"))))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Filling the bucket as part of deployment</h3>
 * <p>
 * To put files into a bucket as part of a deployment (for example, to host a
 * website), see the <code>&#64;aws-cdk/aws-s3-deployment</code> package, which provides a
 * resource that can do just that.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.s3;
