package software.amazon.awscdk.services.s3;

/**
 * A CloudFormation `AWS::S3::Bucket`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-06T01:04:00.010Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket")
public class CfnBucket extends software.amazon.awscdk.core.CfnResource {

    protected CfnBucket(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnBucket(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }
    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.s3.CfnBucket.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }
    /**
     * Create a new `AWS::S3::Bucket`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnBucket(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.s3.CfnBucketProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props }));
    }
    /**
     * Create a new `AWS::S3::Bucket`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnBucket(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") }));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrArn() {
        return this.jsiiGet("attrArn", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrDomainName() {
        return this.jsiiGet("attrDomainName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrDualStackDomainName() {
        return this.jsiiGet("attrDualStackDomainName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrRegionalDomainName() {
        return this.jsiiGet("attrRegionalDomainName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrWebsiteUrl() {
        return this.jsiiGet("attrWebsiteUrl", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return this.jsiiGet("cfnProperties", java.util.Map.class);
    }

    /**
     * `AWS::S3::Bucket.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::S3::Bucket.AccelerateConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accelerateconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getAccelerateConfiguration() {
        return this.jsiiGet("accelerateConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.AccelerateConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accelerateconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAccelerateConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.AccelerateConfigurationProperty value) {
        this.jsiiSet("accelerateConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.AccelerateConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accelerateconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAccelerateConfiguration(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("accelerateConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.AccessControl`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accesscontrol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAccessControl() {
        return this.jsiiGet("accessControl", java.lang.String.class);
    }

    /**
     * `AWS::S3::Bucket.AccessControl`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accesscontrol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAccessControl(final java.lang.String value) {
        this.jsiiSet("accessControl", value);
    }

    /**
     * `AWS::S3::Bucket.AnalyticsConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-analyticsconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getAnalyticsConfigurations() {
        return this.jsiiGet("analyticsConfigurations", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.AnalyticsConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-analyticsconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAnalyticsConfigurations(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("analyticsConfigurations", value);
    }

    /**
     * `AWS::S3::Bucket.AnalyticsConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-analyticsconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAnalyticsConfigurations(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("analyticsConfigurations", value);
    }

    /**
     * `AWS::S3::Bucket.BucketEncryption`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-bucketencryption
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getBucketEncryption() {
        return this.jsiiGet("bucketEncryption", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.BucketEncryption`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-bucketencryption
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setBucketEncryption(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("bucketEncryption", value);
    }

    /**
     * `AWS::S3::Bucket.BucketEncryption`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-bucketencryption
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setBucketEncryption(final software.amazon.awscdk.services.s3.CfnBucket.BucketEncryptionProperty value) {
        this.jsiiSet("bucketEncryption", value);
    }

    /**
     * `AWS::S3::Bucket.BucketName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getBucketName() {
        return this.jsiiGet("bucketName", java.lang.String.class);
    }

    /**
     * `AWS::S3::Bucket.BucketName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setBucketName(final java.lang.String value) {
        this.jsiiSet("bucketName", value);
    }

    /**
     * `AWS::S3::Bucket.CorsConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-crossoriginconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getCorsConfiguration() {
        return this.jsiiGet("corsConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.CorsConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-crossoriginconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCorsConfiguration(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("corsConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.CorsConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-crossoriginconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCorsConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.CorsConfigurationProperty value) {
        this.jsiiSet("corsConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.InventoryConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-inventoryconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getInventoryConfigurations() {
        return this.jsiiGet("inventoryConfigurations", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.InventoryConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-inventoryconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setInventoryConfigurations(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("inventoryConfigurations", value);
    }

    /**
     * `AWS::S3::Bucket.InventoryConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-inventoryconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setInventoryConfigurations(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("inventoryConfigurations", value);
    }

    /**
     * `AWS::S3::Bucket.LifecycleConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-lifecycleconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getLifecycleConfiguration() {
        return this.jsiiGet("lifecycleConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.LifecycleConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-lifecycleconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLifecycleConfiguration(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("lifecycleConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.LifecycleConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-lifecycleconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLifecycleConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.LifecycleConfigurationProperty value) {
        this.jsiiSet("lifecycleConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.LoggingConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-loggingconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getLoggingConfiguration() {
        return this.jsiiGet("loggingConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.LoggingConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-loggingconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLoggingConfiguration(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("loggingConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.LoggingConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-loggingconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLoggingConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.LoggingConfigurationProperty value) {
        this.jsiiSet("loggingConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.MetricsConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-metricsconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getMetricsConfigurations() {
        return this.jsiiGet("metricsConfigurations", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.MetricsConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-metricsconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMetricsConfigurations(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("metricsConfigurations", value);
    }

    /**
     * `AWS::S3::Bucket.MetricsConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-metricsconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMetricsConfigurations(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("metricsConfigurations", value);
    }

    /**
     * `AWS::S3::Bucket.NotificationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-notification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getNotificationConfiguration() {
        return this.jsiiGet("notificationConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.NotificationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-notification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setNotificationConfiguration(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("notificationConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.NotificationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-notification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setNotificationConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.NotificationConfigurationProperty value) {
        this.jsiiSet("notificationConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.ObjectLockConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getObjectLockConfiguration() {
        return this.jsiiGet("objectLockConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.ObjectLockConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setObjectLockConfiguration(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("objectLockConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.ObjectLockConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setObjectLockConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.ObjectLockConfigurationProperty value) {
        this.jsiiSet("objectLockConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.ObjectLockEnabled`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getObjectLockEnabled() {
        return this.jsiiGet("objectLockEnabled", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.ObjectLockEnabled`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setObjectLockEnabled(final java.lang.Boolean value) {
        this.jsiiSet("objectLockEnabled", value);
    }

    /**
     * `AWS::S3::Bucket.ObjectLockEnabled`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setObjectLockEnabled(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("objectLockEnabled", value);
    }

    /**
     * `AWS::S3::Bucket.PublicAccessBlockConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-publicaccessblockconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getPublicAccessBlockConfiguration() {
        return this.jsiiGet("publicAccessBlockConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.PublicAccessBlockConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-publicaccessblockconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPublicAccessBlockConfiguration(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("publicAccessBlockConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.PublicAccessBlockConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-publicaccessblockconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPublicAccessBlockConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.PublicAccessBlockConfigurationProperty value) {
        this.jsiiSet("publicAccessBlockConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.ReplicationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-replicationconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getReplicationConfiguration() {
        return this.jsiiGet("replicationConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.ReplicationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-replicationconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setReplicationConfiguration(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("replicationConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.ReplicationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-replicationconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setReplicationConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.ReplicationConfigurationProperty value) {
        this.jsiiSet("replicationConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.VersioningConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-versioning
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getVersioningConfiguration() {
        return this.jsiiGet("versioningConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.VersioningConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-versioning
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVersioningConfiguration(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("versioningConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.VersioningConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-versioning
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVersioningConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.VersioningConfigurationProperty value) {
        this.jsiiSet("versioningConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.WebsiteConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-websiteconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getWebsiteConfiguration() {
        return this.jsiiGet("websiteConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::S3::Bucket.WebsiteConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-websiteconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setWebsiteConfiguration(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("websiteConfiguration", value);
    }

    /**
     * `AWS::S3::Bucket.WebsiteConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-websiteconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setWebsiteConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.WebsiteConfigurationProperty value) {
        this.jsiiSet("websiteConfiguration", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AbortIncompleteMultipartUploadProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getDaysAfterInitiation();

        /**
         * @return a {@link Builder} of {@link AbortIncompleteMultipartUploadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AbortIncompleteMultipartUploadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Number daysAfterInitiation;

            /**
             * Sets the value of DaysAfterInitiation
             * @param daysAfterInitiation `CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder daysAfterInitiation(java.lang.Number daysAfterInitiation) {
                this.daysAfterInitiation = daysAfterInitiation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AbortIncompleteMultipartUploadProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AbortIncompleteMultipartUploadProperty build() {
                return new Jsii$Proxy(daysAfterInitiation);
            }

        }

        /**
         * An implementation for {@link AbortIncompleteMultipartUploadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AbortIncompleteMultipartUploadProperty {
            private final java.lang.Number daysAfterInitiation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.daysAfterInitiation = this.jsiiGet("daysAfterInitiation", java.lang.Number.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Number daysAfterInitiation) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.daysAfterInitiation = java.util.Objects.requireNonNull(daysAfterInitiation, "daysAfterInitiation is required");
            }

            @Override
            public java.lang.Number getDaysAfterInitiation() {
                return this.daysAfterInitiation;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("daysAfterInitiation", om.valueToTree(this.getDaysAfterInitiation()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AbortIncompleteMultipartUploadProperty.Jsii$Proxy that = (AbortIncompleteMultipartUploadProperty.Jsii$Proxy) o;

                return this.daysAfterInitiation.equals(that.daysAfterInitiation);
            }

            @Override
            public int hashCode() {
                int result = this.daysAfterInitiation.hashCode();
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AccelerateConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.AccelerateConfigurationProperty.AccelerationStatus`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getAccelerationStatus();

        /**
         * @return a {@link Builder} of {@link AccelerateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AccelerateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String accelerationStatus;

            /**
             * Sets the value of AccelerationStatus
             * @param accelerationStatus `CfnBucket.AccelerateConfigurationProperty.AccelerationStatus`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder accelerationStatus(java.lang.String accelerationStatus) {
                this.accelerationStatus = accelerationStatus;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccelerateConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AccelerateConfigurationProperty build() {
                return new Jsii$Proxy(accelerationStatus);
            }

        }

        /**
         * An implementation for {@link AccelerateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccelerateConfigurationProperty {
            private final java.lang.String accelerationStatus;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.accelerationStatus = this.jsiiGet("accelerationStatus", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String accelerationStatus) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accelerationStatus = java.util.Objects.requireNonNull(accelerationStatus, "accelerationStatus is required");
            }

            @Override
            public java.lang.String getAccelerationStatus() {
                return this.accelerationStatus;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("accelerationStatus", om.valueToTree(this.getAccelerationStatus()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccelerateConfigurationProperty.Jsii$Proxy that = (AccelerateConfigurationProperty.Jsii$Proxy) o;

                return this.accelerationStatus.equals(that.accelerationStatus);
            }

            @Override
            public int hashCode() {
                int result = this.accelerationStatus.hashCode();
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AccessControlTranslationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.AccessControlTranslationProperty.Owner`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getOwner();

        /**
         * @return a {@link Builder} of {@link AccessControlTranslationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AccessControlTranslationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String owner;

            /**
             * Sets the value of Owner
             * @param owner `CfnBucket.AccessControlTranslationProperty.Owner`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder owner(java.lang.String owner) {
                this.owner = owner;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessControlTranslationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AccessControlTranslationProperty build() {
                return new Jsii$Proxy(owner);
            }

        }

        /**
         * An implementation for {@link AccessControlTranslationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessControlTranslationProperty {
            private final java.lang.String owner;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.owner = this.jsiiGet("owner", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String owner) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.owner = java.util.Objects.requireNonNull(owner, "owner is required");
            }

            @Override
            public java.lang.String getOwner() {
                return this.owner;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("owner", om.valueToTree(this.getOwner()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessControlTranslationProperty.Jsii$Proxy that = (AccessControlTranslationProperty.Jsii$Proxy) o;

                return this.owner.equals(that.owner);
            }

            @Override
            public int hashCode() {
                int result = this.owner.hashCode();
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AnalyticsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.AnalyticsConfigurationProperty.Id`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getId();

        /**
         * `CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getStorageClassAnalysis();

        /**
         * `CfnBucket.AnalyticsConfigurationProperty.Prefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPrefix();

        /**
         * `CfnBucket.AnalyticsConfigurationProperty.TagFilters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getTagFilters();

        /**
         * @return a {@link Builder} of {@link AnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String id;
            private java.lang.Object storageClassAnalysis;
            private java.lang.String prefix;
            private java.lang.Object tagFilters;

            /**
             * Sets the value of Id
             * @param id `CfnBucket.AnalyticsConfigurationProperty.Id`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of StorageClassAnalysis
             * @param storageClassAnalysis `CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder storageClassAnalysis(software.amazon.awscdk.core.IResolvable storageClassAnalysis) {
                this.storageClassAnalysis = storageClassAnalysis;
                return this;
            }

            /**
             * Sets the value of StorageClassAnalysis
             * @param storageClassAnalysis `CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder storageClassAnalysis(software.amazon.awscdk.services.s3.CfnBucket.StorageClassAnalysisProperty storageClassAnalysis) {
                this.storageClassAnalysis = storageClassAnalysis;
                return this;
            }

            /**
             * Sets the value of Prefix
             * @param prefix `CfnBucket.AnalyticsConfigurationProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of TagFilters
             * @param tagFilters `CfnBucket.AnalyticsConfigurationProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder tagFilters(software.amazon.awscdk.core.IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Sets the value of TagFilters
             * @param tagFilters `CfnBucket.AnalyticsConfigurationProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder tagFilters(java.util.List<java.lang.Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalyticsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AnalyticsConfigurationProperty build() {
                return new Jsii$Proxy(id, storageClassAnalysis, prefix, tagFilters);
            }

        }

        /**
         * An implementation for {@link AnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalyticsConfigurationProperty {
            private final java.lang.String id;
            private final java.lang.Object storageClassAnalysis;
            private final java.lang.String prefix;
            private final java.lang.Object tagFilters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.id = this.jsiiGet("id", java.lang.String.class);
                this.storageClassAnalysis = this.jsiiGet("storageClassAnalysis", java.lang.Object.class);
                this.prefix = this.jsiiGet("prefix", java.lang.String.class);
                this.tagFilters = this.jsiiGet("tagFilters", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String id, java.lang.Object storageClassAnalysis, java.lang.String prefix, java.lang.Object tagFilters) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(id, "id is required");
                this.storageClassAnalysis = java.util.Objects.requireNonNull(storageClassAnalysis, "storageClassAnalysis is required");
                this.prefix = prefix;
                this.tagFilters = tagFilters;
            }

            @Override
            public java.lang.String getId() {
                return this.id;
            }

            @Override
            public java.lang.Object getStorageClassAnalysis() {
                return this.storageClassAnalysis;
            }

            @Override
            public java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public java.lang.Object getTagFilters() {
                return this.tagFilters;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("id", om.valueToTree(this.getId()));
                obj.set("storageClassAnalysis", om.valueToTree(this.getStorageClassAnalysis()));
                if (this.getPrefix() != null) {
                    obj.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getTagFilters() != null) {
                    obj.set("tagFilters", om.valueToTree(this.getTagFilters()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalyticsConfigurationProperty.Jsii$Proxy that = (AnalyticsConfigurationProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (!storageClassAnalysis.equals(that.storageClassAnalysis)) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                return this.tagFilters != null ? this.tagFilters.equals(that.tagFilters) : that.tagFilters == null;
            }

            @Override
            public int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.storageClassAnalysis.hashCode());
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.tagFilters != null ? this.tagFilters.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface BucketEncryptionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getServerSideEncryptionConfiguration();

        /**
         * @return a {@link Builder} of {@link BucketEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link BucketEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object serverSideEncryptionConfiguration;

            /**
             * Sets the value of ServerSideEncryptionConfiguration
             * @param serverSideEncryptionConfiguration `CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder serverSideEncryptionConfiguration(software.amazon.awscdk.core.IResolvable serverSideEncryptionConfiguration) {
                this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of ServerSideEncryptionConfiguration
             * @param serverSideEncryptionConfiguration `CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder serverSideEncryptionConfiguration(java.util.List<java.lang.Object> serverSideEncryptionConfiguration) {
                this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BucketEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public BucketEncryptionProperty build() {
                return new Jsii$Proxy(serverSideEncryptionConfiguration);
            }

        }

        /**
         * An implementation for {@link BucketEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BucketEncryptionProperty {
            private final java.lang.Object serverSideEncryptionConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.serverSideEncryptionConfiguration = this.jsiiGet("serverSideEncryptionConfiguration", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object serverSideEncryptionConfiguration) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.serverSideEncryptionConfiguration = java.util.Objects.requireNonNull(serverSideEncryptionConfiguration, "serverSideEncryptionConfiguration is required");
            }

            @Override
            public java.lang.Object getServerSideEncryptionConfiguration() {
                return this.serverSideEncryptionConfiguration;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("serverSideEncryptionConfiguration", om.valueToTree(this.getServerSideEncryptionConfiguration()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BucketEncryptionProperty.Jsii$Proxy that = (BucketEncryptionProperty.Jsii$Proxy) o;

                return this.serverSideEncryptionConfiguration.equals(that.serverSideEncryptionConfiguration);
            }

            @Override
            public int hashCode() {
                int result = this.serverSideEncryptionConfiguration.hashCode();
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CorsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.CorsConfigurationProperty.CorsRules`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getCorsRules();

        /**
         * @return a {@link Builder} of {@link CorsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CorsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object corsRules;

            /**
             * Sets the value of CorsRules
             * @param corsRules `CfnBucket.CorsConfigurationProperty.CorsRules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder corsRules(software.amazon.awscdk.core.IResolvable corsRules) {
                this.corsRules = corsRules;
                return this;
            }

            /**
             * Sets the value of CorsRules
             * @param corsRules `CfnBucket.CorsConfigurationProperty.CorsRules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder corsRules(java.util.List<java.lang.Object> corsRules) {
                this.corsRules = corsRules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CorsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CorsConfigurationProperty build() {
                return new Jsii$Proxy(corsRules);
            }

        }

        /**
         * An implementation for {@link CorsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CorsConfigurationProperty {
            private final java.lang.Object corsRules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.corsRules = this.jsiiGet("corsRules", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object corsRules) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.corsRules = java.util.Objects.requireNonNull(corsRules, "corsRules is required");
            }

            @Override
            public java.lang.Object getCorsRules() {
                return this.corsRules;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("corsRules", om.valueToTree(this.getCorsRules()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CorsConfigurationProperty.Jsii$Proxy that = (CorsConfigurationProperty.Jsii$Proxy) o;

                return this.corsRules.equals(that.corsRules);
            }

            @Override
            public int hashCode() {
                int result = this.corsRules.hashCode();
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CorsRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.CorsRuleProperty.AllowedMethods`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getAllowedMethods();

        /**
         * `CfnBucket.CorsRuleProperty.AllowedOrigins`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getAllowedOrigins();

        /**
         * `CfnBucket.CorsRuleProperty.AllowedHeaders`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getAllowedHeaders();

        /**
         * `CfnBucket.CorsRuleProperty.ExposedHeaders`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getExposedHeaders();

        /**
         * `CfnBucket.CorsRuleProperty.Id`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getId();

        /**
         * `CfnBucket.CorsRuleProperty.MaxAge`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getMaxAge();

        /**
         * @return a {@link Builder} of {@link CorsRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CorsRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.util.List<java.lang.String> allowedMethods;
            private java.util.List<java.lang.String> allowedOrigins;
            private java.util.List<java.lang.String> allowedHeaders;
            private java.util.List<java.lang.String> exposedHeaders;
            private java.lang.String id;
            private java.lang.Number maxAge;

            /**
             * Sets the value of AllowedMethods
             * @param allowedMethods `CfnBucket.CorsRuleProperty.AllowedMethods`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder allowedMethods(java.util.List<java.lang.String> allowedMethods) {
                this.allowedMethods = allowedMethods;
                return this;
            }

            /**
             * Sets the value of AllowedOrigins
             * @param allowedOrigins `CfnBucket.CorsRuleProperty.AllowedOrigins`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder allowedOrigins(java.util.List<java.lang.String> allowedOrigins) {
                this.allowedOrigins = allowedOrigins;
                return this;
            }

            /**
             * Sets the value of AllowedHeaders
             * @param allowedHeaders `CfnBucket.CorsRuleProperty.AllowedHeaders`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder allowedHeaders(java.util.List<java.lang.String> allowedHeaders) {
                this.allowedHeaders = allowedHeaders;
                return this;
            }

            /**
             * Sets the value of ExposedHeaders
             * @param exposedHeaders `CfnBucket.CorsRuleProperty.ExposedHeaders`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder exposedHeaders(java.util.List<java.lang.String> exposedHeaders) {
                this.exposedHeaders = exposedHeaders;
                return this;
            }

            /**
             * Sets the value of Id
             * @param id `CfnBucket.CorsRuleProperty.Id`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of MaxAge
             * @param maxAge `CfnBucket.CorsRuleProperty.MaxAge`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder maxAge(java.lang.Number maxAge) {
                this.maxAge = maxAge;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CorsRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CorsRuleProperty build() {
                return new Jsii$Proxy(allowedMethods, allowedOrigins, allowedHeaders, exposedHeaders, id, maxAge);
            }

        }

        /**
         * An implementation for {@link CorsRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CorsRuleProperty {
            private final java.util.List<java.lang.String> allowedMethods;
            private final java.util.List<java.lang.String> allowedOrigins;
            private final java.util.List<java.lang.String> allowedHeaders;
            private final java.util.List<java.lang.String> exposedHeaders;
            private final java.lang.String id;
            private final java.lang.Number maxAge;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.allowedMethods = this.jsiiGet("allowedMethods", java.util.List.class);
                this.allowedOrigins = this.jsiiGet("allowedOrigins", java.util.List.class);
                this.allowedHeaders = this.jsiiGet("allowedHeaders", java.util.List.class);
                this.exposedHeaders = this.jsiiGet("exposedHeaders", java.util.List.class);
                this.id = this.jsiiGet("id", java.lang.String.class);
                this.maxAge = this.jsiiGet("maxAge", java.lang.Number.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.util.List<java.lang.String> allowedMethods, java.util.List<java.lang.String> allowedOrigins, java.util.List<java.lang.String> allowedHeaders, java.util.List<java.lang.String> exposedHeaders, java.lang.String id, java.lang.Number maxAge) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowedMethods = java.util.Objects.requireNonNull(allowedMethods, "allowedMethods is required");
                this.allowedOrigins = java.util.Objects.requireNonNull(allowedOrigins, "allowedOrigins is required");
                this.allowedHeaders = allowedHeaders;
                this.exposedHeaders = exposedHeaders;
                this.id = id;
                this.maxAge = maxAge;
            }

            @Override
            public java.util.List<java.lang.String> getAllowedMethods() {
                return this.allowedMethods;
            }

            @Override
            public java.util.List<java.lang.String> getAllowedOrigins() {
                return this.allowedOrigins;
            }

            @Override
            public java.util.List<java.lang.String> getAllowedHeaders() {
                return this.allowedHeaders;
            }

            @Override
            public java.util.List<java.lang.String> getExposedHeaders() {
                return this.exposedHeaders;
            }

            @Override
            public java.lang.String getId() {
                return this.id;
            }

            @Override
            public java.lang.Number getMaxAge() {
                return this.maxAge;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
                obj.set("allowedOrigins", om.valueToTree(this.getAllowedOrigins()));
                if (this.getAllowedHeaders() != null) {
                    obj.set("allowedHeaders", om.valueToTree(this.getAllowedHeaders()));
                }
                if (this.getExposedHeaders() != null) {
                    obj.set("exposedHeaders", om.valueToTree(this.getExposedHeaders()));
                }
                if (this.getId() != null) {
                    obj.set("id", om.valueToTree(this.getId()));
                }
                if (this.getMaxAge() != null) {
                    obj.set("maxAge", om.valueToTree(this.getMaxAge()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CorsRuleProperty.Jsii$Proxy that = (CorsRuleProperty.Jsii$Proxy) o;

                if (!allowedMethods.equals(that.allowedMethods)) return false;
                if (!allowedOrigins.equals(that.allowedOrigins)) return false;
                if (this.allowedHeaders != null ? !this.allowedHeaders.equals(that.allowedHeaders) : that.allowedHeaders != null) return false;
                if (this.exposedHeaders != null ? !this.exposedHeaders.equals(that.exposedHeaders) : that.exposedHeaders != null) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                return this.maxAge != null ? this.maxAge.equals(that.maxAge) : that.maxAge == null;
            }

            @Override
            public int hashCode() {
                int result = this.allowedMethods.hashCode();
                result = 31 * result + (this.allowedOrigins.hashCode());
                result = 31 * result + (this.allowedHeaders != null ? this.allowedHeaders.hashCode() : 0);
                result = 31 * result + (this.exposedHeaders != null ? this.exposedHeaders.hashCode() : 0);
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.maxAge != null ? this.maxAge.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface DataExportProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.DataExportProperty.Destination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getDestination();

        /**
         * `CfnBucket.DataExportProperty.OutputSchemaVersion`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getOutputSchemaVersion();

        /**
         * @return a {@link Builder} of {@link DataExportProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DataExportProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object destination;
            private java.lang.String outputSchemaVersion;

            /**
             * Sets the value of Destination
             * @param destination `CfnBucket.DataExportProperty.Destination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder destination(software.amazon.awscdk.core.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of Destination
             * @param destination `CfnBucket.DataExportProperty.Destination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder destination(software.amazon.awscdk.services.s3.CfnBucket.DestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of OutputSchemaVersion
             * @param outputSchemaVersion `CfnBucket.DataExportProperty.OutputSchemaVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder outputSchemaVersion(java.lang.String outputSchemaVersion) {
                this.outputSchemaVersion = outputSchemaVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataExportProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public DataExportProperty build() {
                return new Jsii$Proxy(destination, outputSchemaVersion);
            }

        }

        /**
         * An implementation for {@link DataExportProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataExportProperty {
            private final java.lang.Object destination;
            private final java.lang.String outputSchemaVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.destination = this.jsiiGet("destination", java.lang.Object.class);
                this.outputSchemaVersion = this.jsiiGet("outputSchemaVersion", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object destination, java.lang.String outputSchemaVersion) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(destination, "destination is required");
                this.outputSchemaVersion = java.util.Objects.requireNonNull(outputSchemaVersion, "outputSchemaVersion is required");
            }

            @Override
            public java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public java.lang.String getOutputSchemaVersion() {
                return this.outputSchemaVersion;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("destination", om.valueToTree(this.getDestination()));
                obj.set("outputSchemaVersion", om.valueToTree(this.getOutputSchemaVersion()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataExportProperty.Jsii$Proxy that = (DataExportProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                return this.outputSchemaVersion.equals(that.outputSchemaVersion);
            }

            @Override
            public int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.outputSchemaVersion.hashCode());
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface DefaultRetentionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.DefaultRetentionProperty.Days`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html#cfn-s3-bucket-defaultretention-days
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getDays();

        /**
         * `CfnBucket.DefaultRetentionProperty.Mode`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html#cfn-s3-bucket-defaultretention-mode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getMode();

        /**
         * `CfnBucket.DefaultRetentionProperty.Years`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html#cfn-s3-bucket-defaultretention-years
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getYears();

        /**
         * @return a {@link Builder} of {@link DefaultRetentionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DefaultRetentionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Number days;
            private java.lang.String mode;
            private java.lang.Number years;

            /**
             * Sets the value of Days
             * @param days `CfnBucket.DefaultRetentionProperty.Days`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder days(java.lang.Number days) {
                this.days = days;
                return this;
            }

            /**
             * Sets the value of Mode
             * @param mode `CfnBucket.DefaultRetentionProperty.Mode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Sets the value of Years
             * @param years `CfnBucket.DefaultRetentionProperty.Years`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder years(java.lang.Number years) {
                this.years = years;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultRetentionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public DefaultRetentionProperty build() {
                return new Jsii$Proxy(days, mode, years);
            }

        }

        /**
         * An implementation for {@link DefaultRetentionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultRetentionProperty {
            private final java.lang.Number days;
            private final java.lang.String mode;
            private final java.lang.Number years;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.days = this.jsiiGet("days", java.lang.Number.class);
                this.mode = this.jsiiGet("mode", java.lang.String.class);
                this.years = this.jsiiGet("years", java.lang.Number.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Number days, java.lang.String mode, java.lang.Number years) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.days = days;
                this.mode = mode;
                this.years = years;
            }

            @Override
            public java.lang.Number getDays() {
                return this.days;
            }

            @Override
            public java.lang.String getMode() {
                return this.mode;
            }

            @Override
            public java.lang.Number getYears() {
                return this.years;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getDays() != null) {
                    obj.set("days", om.valueToTree(this.getDays()));
                }
                if (this.getMode() != null) {
                    obj.set("mode", om.valueToTree(this.getMode()));
                }
                if (this.getYears() != null) {
                    obj.set("years", om.valueToTree(this.getYears()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefaultRetentionProperty.Jsii$Proxy that = (DefaultRetentionProperty.Jsii$Proxy) o;

                if (this.days != null ? !this.days.equals(that.days) : that.days != null) return false;
                if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) return false;
                return this.years != null ? this.years.equals(that.years) : that.years == null;
            }

            @Override
            public int hashCode() {
                int result = this.days != null ? this.days.hashCode() : 0;
                result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
                result = 31 * result + (this.years != null ? this.years.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface DestinationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.DestinationProperty.BucketArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getBucketArn();

        /**
         * `CfnBucket.DestinationProperty.Format`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getFormat();

        /**
         * `CfnBucket.DestinationProperty.BucketAccountId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getBucketAccountId();

        /**
         * `CfnBucket.DestinationProperty.Prefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPrefix();

        /**
         * @return a {@link Builder} of {@link DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String bucketArn;
            private java.lang.String format;
            private java.lang.String bucketAccountId;
            private java.lang.String prefix;

            /**
             * Sets the value of BucketArn
             * @param bucketArn `CfnBucket.DestinationProperty.BucketArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder bucketArn(java.lang.String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            /**
             * Sets the value of Format
             * @param format `CfnBucket.DestinationProperty.Format`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Sets the value of BucketAccountId
             * @param bucketAccountId `CfnBucket.DestinationProperty.BucketAccountId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder bucketAccountId(java.lang.String bucketAccountId) {
                this.bucketAccountId = bucketAccountId;
                return this;
            }

            /**
             * Sets the value of Prefix
             * @param prefix `CfnBucket.DestinationProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public DestinationProperty build() {
                return new Jsii$Proxy(bucketArn, format, bucketAccountId, prefix);
            }

        }

        /**
         * An implementation for {@link DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationProperty {
            private final java.lang.String bucketArn;
            private final java.lang.String format;
            private final java.lang.String bucketAccountId;
            private final java.lang.String prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.bucketArn = this.jsiiGet("bucketArn", java.lang.String.class);
                this.format = this.jsiiGet("format", java.lang.String.class);
                this.bucketAccountId = this.jsiiGet("bucketAccountId", java.lang.String.class);
                this.prefix = this.jsiiGet("prefix", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String bucketArn, java.lang.String format, java.lang.String bucketAccountId, java.lang.String prefix) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketArn = java.util.Objects.requireNonNull(bucketArn, "bucketArn is required");
                this.format = java.util.Objects.requireNonNull(format, "format is required");
                this.bucketAccountId = bucketAccountId;
                this.prefix = prefix;
            }

            @Override
            public java.lang.String getBucketArn() {
                return this.bucketArn;
            }

            @Override
            public java.lang.String getFormat() {
                return this.format;
            }

            @Override
            public java.lang.String getBucketAccountId() {
                return this.bucketAccountId;
            }

            @Override
            public java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("bucketArn", om.valueToTree(this.getBucketArn()));
                obj.set("format", om.valueToTree(this.getFormat()));
                if (this.getBucketAccountId() != null) {
                    obj.set("bucketAccountId", om.valueToTree(this.getBucketAccountId()));
                }
                if (this.getPrefix() != null) {
                    obj.set("prefix", om.valueToTree(this.getPrefix()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationProperty.Jsii$Proxy that = (DestinationProperty.Jsii$Proxy) o;

                if (!bucketArn.equals(that.bucketArn)) return false;
                if (!format.equals(that.format)) return false;
                if (this.bucketAccountId != null ? !this.bucketAccountId.equals(that.bucketAccountId) : that.bucketAccountId != null) return false;
                return this.prefix != null ? this.prefix.equals(that.prefix) : that.prefix == null;
            }

            @Override
            public int hashCode() {
                int result = this.bucketArn.hashCode();
                result = 31 * result + (this.format.hashCode());
                result = 31 * result + (this.bucketAccountId != null ? this.bucketAccountId.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface EncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.EncryptionConfigurationProperty.ReplicaKmsKeyID`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getReplicaKmsKeyId();

        /**
         * @return a {@link Builder} of {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String replicaKmsKeyId;

            /**
             * Sets the value of ReplicaKmsKeyId
             * @param replicaKmsKeyId `CfnBucket.EncryptionConfigurationProperty.ReplicaKmsKeyID`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder replicaKmsKeyId(java.lang.String replicaKmsKeyId) {
                this.replicaKmsKeyId = replicaKmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public EncryptionConfigurationProperty build() {
                return new Jsii$Proxy(replicaKmsKeyId);
            }

        }

        /**
         * An implementation for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionConfigurationProperty {
            private final java.lang.String replicaKmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.replicaKmsKeyId = this.jsiiGet("replicaKmsKeyId", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String replicaKmsKeyId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.replicaKmsKeyId = java.util.Objects.requireNonNull(replicaKmsKeyId, "replicaKmsKeyId is required");
            }

            @Override
            public java.lang.String getReplicaKmsKeyId() {
                return this.replicaKmsKeyId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("replicaKmsKeyId", om.valueToTree(this.getReplicaKmsKeyId()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionConfigurationProperty.Jsii$Proxy that = (EncryptionConfigurationProperty.Jsii$Proxy) o;

                return this.replicaKmsKeyId.equals(that.replicaKmsKeyId);
            }

            @Override
            public int hashCode() {
                int result = this.replicaKmsKeyId.hashCode();
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface FilterRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.FilterRuleProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getName();

        /**
         * `CfnBucket.FilterRuleProperty.Value`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link FilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link FilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String name;
            private java.lang.String value;

            /**
             * Sets the value of Name
             * @param name `CfnBucket.FilterRuleProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of Value
             * @param value `CfnBucket.FilterRuleProperty.Value`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public FilterRuleProperty build() {
                return new Jsii$Proxy(name, value);
            }

        }

        /**
         * An implementation for {@link FilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterRuleProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.value = this.jsiiGet("value", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String name, java.lang.String value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.value = java.util.Objects.requireNonNull(value, "value is required");
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.lang.String getValue() {
                return this.value;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("name", om.valueToTree(this.getName()));
                obj.set("value", om.valueToTree(this.getValue()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterRuleProperty.Jsii$Proxy that = (FilterRuleProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface InventoryConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.InventoryConfigurationProperty.Destination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getDestination();

        /**
         * `CfnBucket.InventoryConfigurationProperty.Enabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEnabled();

        /**
         * `CfnBucket.InventoryConfigurationProperty.Id`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getId();

        /**
         * `CfnBucket.InventoryConfigurationProperty.IncludedObjectVersions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getIncludedObjectVersions();

        /**
         * `CfnBucket.InventoryConfigurationProperty.ScheduleFrequency`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getScheduleFrequency();

        /**
         * `CfnBucket.InventoryConfigurationProperty.OptionalFields`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getOptionalFields();

        /**
         * `CfnBucket.InventoryConfigurationProperty.Prefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPrefix();

        /**
         * @return a {@link Builder} of {@link InventoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InventoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object destination;
            private java.lang.Object enabled;
            private java.lang.String id;
            private java.lang.String includedObjectVersions;
            private java.lang.String scheduleFrequency;
            private java.util.List<java.lang.String> optionalFields;
            private java.lang.String prefix;

            /**
             * Sets the value of Destination
             * @param destination `CfnBucket.InventoryConfigurationProperty.Destination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder destination(software.amazon.awscdk.core.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of Destination
             * @param destination `CfnBucket.InventoryConfigurationProperty.Destination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder destination(software.amazon.awscdk.services.s3.CfnBucket.DestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of Enabled
             * @param enabled `CfnBucket.InventoryConfigurationProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of Enabled
             * @param enabled `CfnBucket.InventoryConfigurationProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of Id
             * @param id `CfnBucket.InventoryConfigurationProperty.Id`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of IncludedObjectVersions
             * @param includedObjectVersions `CfnBucket.InventoryConfigurationProperty.IncludedObjectVersions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder includedObjectVersions(java.lang.String includedObjectVersions) {
                this.includedObjectVersions = includedObjectVersions;
                return this;
            }

            /**
             * Sets the value of ScheduleFrequency
             * @param scheduleFrequency `CfnBucket.InventoryConfigurationProperty.ScheduleFrequency`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder scheduleFrequency(java.lang.String scheduleFrequency) {
                this.scheduleFrequency = scheduleFrequency;
                return this;
            }

            /**
             * Sets the value of OptionalFields
             * @param optionalFields `CfnBucket.InventoryConfigurationProperty.OptionalFields`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder optionalFields(java.util.List<java.lang.String> optionalFields) {
                this.optionalFields = optionalFields;
                return this;
            }

            /**
             * Sets the value of Prefix
             * @param prefix `CfnBucket.InventoryConfigurationProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InventoryConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public InventoryConfigurationProperty build() {
                return new Jsii$Proxy(destination, enabled, id, includedObjectVersions, scheduleFrequency, optionalFields, prefix);
            }

        }

        /**
         * An implementation for {@link InventoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InventoryConfigurationProperty {
            private final java.lang.Object destination;
            private final java.lang.Object enabled;
            private final java.lang.String id;
            private final java.lang.String includedObjectVersions;
            private final java.lang.String scheduleFrequency;
            private final java.util.List<java.lang.String> optionalFields;
            private final java.lang.String prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.destination = this.jsiiGet("destination", java.lang.Object.class);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
                this.id = this.jsiiGet("id", java.lang.String.class);
                this.includedObjectVersions = this.jsiiGet("includedObjectVersions", java.lang.String.class);
                this.scheduleFrequency = this.jsiiGet("scheduleFrequency", java.lang.String.class);
                this.optionalFields = this.jsiiGet("optionalFields", java.util.List.class);
                this.prefix = this.jsiiGet("prefix", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object destination, java.lang.Object enabled, java.lang.String id, java.lang.String includedObjectVersions, java.lang.String scheduleFrequency, java.util.List<java.lang.String> optionalFields, java.lang.String prefix) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(destination, "destination is required");
                this.enabled = java.util.Objects.requireNonNull(enabled, "enabled is required");
                this.id = java.util.Objects.requireNonNull(id, "id is required");
                this.includedObjectVersions = java.util.Objects.requireNonNull(includedObjectVersions, "includedObjectVersions is required");
                this.scheduleFrequency = java.util.Objects.requireNonNull(scheduleFrequency, "scheduleFrequency is required");
                this.optionalFields = optionalFields;
                this.prefix = prefix;
            }

            @Override
            public java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public java.lang.String getId() {
                return this.id;
            }

            @Override
            public java.lang.String getIncludedObjectVersions() {
                return this.includedObjectVersions;
            }

            @Override
            public java.lang.String getScheduleFrequency() {
                return this.scheduleFrequency;
            }

            @Override
            public java.util.List<java.lang.String> getOptionalFields() {
                return this.optionalFields;
            }

            @Override
            public java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("destination", om.valueToTree(this.getDestination()));
                obj.set("enabled", om.valueToTree(this.getEnabled()));
                obj.set("id", om.valueToTree(this.getId()));
                obj.set("includedObjectVersions", om.valueToTree(this.getIncludedObjectVersions()));
                obj.set("scheduleFrequency", om.valueToTree(this.getScheduleFrequency()));
                if (this.getOptionalFields() != null) {
                    obj.set("optionalFields", om.valueToTree(this.getOptionalFields()));
                }
                if (this.getPrefix() != null) {
                    obj.set("prefix", om.valueToTree(this.getPrefix()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InventoryConfigurationProperty.Jsii$Proxy that = (InventoryConfigurationProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                if (!enabled.equals(that.enabled)) return false;
                if (!id.equals(that.id)) return false;
                if (!includedObjectVersions.equals(that.includedObjectVersions)) return false;
                if (!scheduleFrequency.equals(that.scheduleFrequency)) return false;
                if (this.optionalFields != null ? !this.optionalFields.equals(that.optionalFields) : that.optionalFields != null) return false;
                return this.prefix != null ? this.prefix.equals(that.prefix) : that.prefix == null;
            }

            @Override
            public int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.enabled.hashCode());
                result = 31 * result + (this.id.hashCode());
                result = 31 * result + (this.includedObjectVersions.hashCode());
                result = 31 * result + (this.scheduleFrequency.hashCode());
                result = 31 * result + (this.optionalFields != null ? this.optionalFields.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface LambdaConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.LambdaConfigurationProperty.Event`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getEvent();

        /**
         * `CfnBucket.LambdaConfigurationProperty.Function`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getFunction();

        /**
         * `CfnBucket.LambdaConfigurationProperty.Filter`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getFilter();

        /**
         * @return a {@link Builder} of {@link LambdaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LambdaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String event;
            private java.lang.String function;
            private java.lang.Object filter;

            /**
             * Sets the value of Event
             * @param event `CfnBucket.LambdaConfigurationProperty.Event`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder event(java.lang.String event) {
                this.event = event;
                return this;
            }

            /**
             * Sets the value of Function
             * @param function `CfnBucket.LambdaConfigurationProperty.Function`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder function(java.lang.String function) {
                this.function = function;
                return this;
            }

            /**
             * Sets the value of Filter
             * @param filter `CfnBucket.LambdaConfigurationProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder filter(software.amazon.awscdk.core.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of Filter
             * @param filter `CfnBucket.LambdaConfigurationProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder filter(software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public LambdaConfigurationProperty build() {
                return new Jsii$Proxy(event, function, filter);
            }

        }

        /**
         * An implementation for {@link LambdaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaConfigurationProperty {
            private final java.lang.String event;
            private final java.lang.String function;
            private final java.lang.Object filter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.event = this.jsiiGet("event", java.lang.String.class);
                this.function = this.jsiiGet("function", java.lang.String.class);
                this.filter = this.jsiiGet("filter", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String event, java.lang.String function, java.lang.Object filter) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.event = java.util.Objects.requireNonNull(event, "event is required");
                this.function = java.util.Objects.requireNonNull(function, "function is required");
                this.filter = filter;
            }

            @Override
            public java.lang.String getEvent() {
                return this.event;
            }

            @Override
            public java.lang.String getFunction() {
                return this.function;
            }

            @Override
            public java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("event", om.valueToTree(this.getEvent()));
                obj.set("function", om.valueToTree(this.getFunction()));
                if (this.getFilter() != null) {
                    obj.set("filter", om.valueToTree(this.getFilter()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaConfigurationProperty.Jsii$Proxy that = (LambdaConfigurationProperty.Jsii$Proxy) o;

                if (!event.equals(that.event)) return false;
                if (!function.equals(that.function)) return false;
                return this.filter != null ? this.filter.equals(that.filter) : that.filter == null;
            }

            @Override
            public int hashCode() {
                int result = this.event.hashCode();
                result = 31 * result + (this.function.hashCode());
                result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface LifecycleConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.LifecycleConfigurationProperty.Rules`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link LifecycleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LifecycleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object rules;

            /**
             * Sets the value of Rules
             * @param rules `CfnBucket.LifecycleConfigurationProperty.Rules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder rules(software.amazon.awscdk.core.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of Rules
             * @param rules `CfnBucket.LifecycleConfigurationProperty.Rules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder rules(java.util.List<java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LifecycleConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public LifecycleConfigurationProperty build() {
                return new Jsii$Proxy(rules);
            }

        }

        /**
         * An implementation for {@link LifecycleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LifecycleConfigurationProperty {
            private final java.lang.Object rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.rules = this.jsiiGet("rules", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object rules) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rules = java.util.Objects.requireNonNull(rules, "rules is required");
            }

            @Override
            public java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("rules", om.valueToTree(this.getRules()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LifecycleConfigurationProperty.Jsii$Proxy that = (LifecycleConfigurationProperty.Jsii$Proxy) o;

                return this.rules.equals(that.rules);
            }

            @Override
            public int hashCode() {
                int result = this.rules.hashCode();
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface LoggingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.LoggingConfigurationProperty.DestinationBucketName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDestinationBucketName();

        /**
         * `CfnBucket.LoggingConfigurationProperty.LogFilePrefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getLogFilePrefix();

        /**
         * @return a {@link Builder} of {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String destinationBucketName;
            private java.lang.String logFilePrefix;

            /**
             * Sets the value of DestinationBucketName
             * @param destinationBucketName `CfnBucket.LoggingConfigurationProperty.DestinationBucketName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder destinationBucketName(java.lang.String destinationBucketName) {
                this.destinationBucketName = destinationBucketName;
                return this;
            }

            /**
             * Sets the value of LogFilePrefix
             * @param logFilePrefix `CfnBucket.LoggingConfigurationProperty.LogFilePrefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder logFilePrefix(java.lang.String logFilePrefix) {
                this.logFilePrefix = logFilePrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public LoggingConfigurationProperty build() {
                return new Jsii$Proxy(destinationBucketName, logFilePrefix);
            }

        }

        /**
         * An implementation for {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingConfigurationProperty {
            private final java.lang.String destinationBucketName;
            private final java.lang.String logFilePrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.destinationBucketName = this.jsiiGet("destinationBucketName", java.lang.String.class);
                this.logFilePrefix = this.jsiiGet("logFilePrefix", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String destinationBucketName, java.lang.String logFilePrefix) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationBucketName = destinationBucketName;
                this.logFilePrefix = logFilePrefix;
            }

            @Override
            public java.lang.String getDestinationBucketName() {
                return this.destinationBucketName;
            }

            @Override
            public java.lang.String getLogFilePrefix() {
                return this.logFilePrefix;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getDestinationBucketName() != null) {
                    obj.set("destinationBucketName", om.valueToTree(this.getDestinationBucketName()));
                }
                if (this.getLogFilePrefix() != null) {
                    obj.set("logFilePrefix", om.valueToTree(this.getLogFilePrefix()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingConfigurationProperty.Jsii$Proxy that = (LoggingConfigurationProperty.Jsii$Proxy) o;

                if (this.destinationBucketName != null ? !this.destinationBucketName.equals(that.destinationBucketName) : that.destinationBucketName != null) return false;
                return this.logFilePrefix != null ? this.logFilePrefix.equals(that.logFilePrefix) : that.logFilePrefix == null;
            }

            @Override
            public int hashCode() {
                int result = this.destinationBucketName != null ? this.destinationBucketName.hashCode() : 0;
                result = 31 * result + (this.logFilePrefix != null ? this.logFilePrefix.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface MetricsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.MetricsConfigurationProperty.Id`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getId();

        /**
         * `CfnBucket.MetricsConfigurationProperty.Prefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPrefix();

        /**
         * `CfnBucket.MetricsConfigurationProperty.TagFilters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getTagFilters();

        /**
         * @return a {@link Builder} of {@link MetricsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MetricsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String id;
            private java.lang.String prefix;
            private java.lang.Object tagFilters;

            /**
             * Sets the value of Id
             * @param id `CfnBucket.MetricsConfigurationProperty.Id`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of Prefix
             * @param prefix `CfnBucket.MetricsConfigurationProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of TagFilters
             * @param tagFilters `CfnBucket.MetricsConfigurationProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder tagFilters(software.amazon.awscdk.core.IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Sets the value of TagFilters
             * @param tagFilters `CfnBucket.MetricsConfigurationProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder tagFilters(java.util.List<java.lang.Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public MetricsConfigurationProperty build() {
                return new Jsii$Proxy(id, prefix, tagFilters);
            }

        }

        /**
         * An implementation for {@link MetricsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricsConfigurationProperty {
            private final java.lang.String id;
            private final java.lang.String prefix;
            private final java.lang.Object tagFilters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.id = this.jsiiGet("id", java.lang.String.class);
                this.prefix = this.jsiiGet("prefix", java.lang.String.class);
                this.tagFilters = this.jsiiGet("tagFilters", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String id, java.lang.String prefix, java.lang.Object tagFilters) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(id, "id is required");
                this.prefix = prefix;
                this.tagFilters = tagFilters;
            }

            @Override
            public java.lang.String getId() {
                return this.id;
            }

            @Override
            public java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public java.lang.Object getTagFilters() {
                return this.tagFilters;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("id", om.valueToTree(this.getId()));
                if (this.getPrefix() != null) {
                    obj.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getTagFilters() != null) {
                    obj.set("tagFilters", om.valueToTree(this.getTagFilters()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricsConfigurationProperty.Jsii$Proxy that = (MetricsConfigurationProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                return this.tagFilters != null ? this.tagFilters.equals(that.tagFilters) : that.tagFilters == null;
            }

            @Override
            public int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.tagFilters != null ? this.tagFilters.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface NoncurrentVersionTransitionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.NoncurrentVersionTransitionProperty.StorageClass`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStorageClass();

        /**
         * `CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getTransitionInDays();

        /**
         * @return a {@link Builder} of {@link NoncurrentVersionTransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NoncurrentVersionTransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String storageClass;
            private java.lang.Number transitionInDays;

            /**
             * Sets the value of StorageClass
             * @param storageClass `CfnBucket.NoncurrentVersionTransitionProperty.StorageClass`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder storageClass(java.lang.String storageClass) {
                this.storageClass = storageClass;
                return this;
            }

            /**
             * Sets the value of TransitionInDays
             * @param transitionInDays `CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder transitionInDays(java.lang.Number transitionInDays) {
                this.transitionInDays = transitionInDays;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NoncurrentVersionTransitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public NoncurrentVersionTransitionProperty build() {
                return new Jsii$Proxy(storageClass, transitionInDays);
            }

        }

        /**
         * An implementation for {@link NoncurrentVersionTransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NoncurrentVersionTransitionProperty {
            private final java.lang.String storageClass;
            private final java.lang.Number transitionInDays;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.storageClass = this.jsiiGet("storageClass", java.lang.String.class);
                this.transitionInDays = this.jsiiGet("transitionInDays", java.lang.Number.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String storageClass, java.lang.Number transitionInDays) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.storageClass = java.util.Objects.requireNonNull(storageClass, "storageClass is required");
                this.transitionInDays = java.util.Objects.requireNonNull(transitionInDays, "transitionInDays is required");
            }

            @Override
            public java.lang.String getStorageClass() {
                return this.storageClass;
            }

            @Override
            public java.lang.Number getTransitionInDays() {
                return this.transitionInDays;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("storageClass", om.valueToTree(this.getStorageClass()));
                obj.set("transitionInDays", om.valueToTree(this.getTransitionInDays()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NoncurrentVersionTransitionProperty.Jsii$Proxy that = (NoncurrentVersionTransitionProperty.Jsii$Proxy) o;

                if (!storageClass.equals(that.storageClass)) return false;
                return this.transitionInDays.equals(that.transitionInDays);
            }

            @Override
            public int hashCode() {
                int result = this.storageClass.hashCode();
                result = 31 * result + (this.transitionInDays.hashCode());
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface NotificationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.NotificationConfigurationProperty.LambdaConfigurations`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getLambdaConfigurations();

        /**
         * `CfnBucket.NotificationConfigurationProperty.QueueConfigurations`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getQueueConfigurations();

        /**
         * `CfnBucket.NotificationConfigurationProperty.TopicConfigurations`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getTopicConfigurations();

        /**
         * @return a {@link Builder} of {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object lambdaConfigurations;
            private java.lang.Object queueConfigurations;
            private java.lang.Object topicConfigurations;

            /**
             * Sets the value of LambdaConfigurations
             * @param lambdaConfigurations `CfnBucket.NotificationConfigurationProperty.LambdaConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder lambdaConfigurations(software.amazon.awscdk.core.IResolvable lambdaConfigurations) {
                this.lambdaConfigurations = lambdaConfigurations;
                return this;
            }

            /**
             * Sets the value of LambdaConfigurations
             * @param lambdaConfigurations `CfnBucket.NotificationConfigurationProperty.LambdaConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder lambdaConfigurations(java.util.List<java.lang.Object> lambdaConfigurations) {
                this.lambdaConfigurations = lambdaConfigurations;
                return this;
            }

            /**
             * Sets the value of QueueConfigurations
             * @param queueConfigurations `CfnBucket.NotificationConfigurationProperty.QueueConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder queueConfigurations(software.amazon.awscdk.core.IResolvable queueConfigurations) {
                this.queueConfigurations = queueConfigurations;
                return this;
            }

            /**
             * Sets the value of QueueConfigurations
             * @param queueConfigurations `CfnBucket.NotificationConfigurationProperty.QueueConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder queueConfigurations(java.util.List<java.lang.Object> queueConfigurations) {
                this.queueConfigurations = queueConfigurations;
                return this;
            }

            /**
             * Sets the value of TopicConfigurations
             * @param topicConfigurations `CfnBucket.NotificationConfigurationProperty.TopicConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder topicConfigurations(software.amazon.awscdk.core.IResolvable topicConfigurations) {
                this.topicConfigurations = topicConfigurations;
                return this;
            }

            /**
             * Sets the value of TopicConfigurations
             * @param topicConfigurations `CfnBucket.NotificationConfigurationProperty.TopicConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder topicConfigurations(java.util.List<java.lang.Object> topicConfigurations) {
                this.topicConfigurations = topicConfigurations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public NotificationConfigurationProperty build() {
                return new Jsii$Proxy(lambdaConfigurations, queueConfigurations, topicConfigurations);
            }

        }

        /**
         * An implementation for {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationConfigurationProperty {
            private final java.lang.Object lambdaConfigurations;
            private final java.lang.Object queueConfigurations;
            private final java.lang.Object topicConfigurations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.lambdaConfigurations = this.jsiiGet("lambdaConfigurations", java.lang.Object.class);
                this.queueConfigurations = this.jsiiGet("queueConfigurations", java.lang.Object.class);
                this.topicConfigurations = this.jsiiGet("topicConfigurations", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object lambdaConfigurations, java.lang.Object queueConfigurations, java.lang.Object topicConfigurations) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lambdaConfigurations = lambdaConfigurations;
                this.queueConfigurations = queueConfigurations;
                this.topicConfigurations = topicConfigurations;
            }

            @Override
            public java.lang.Object getLambdaConfigurations() {
                return this.lambdaConfigurations;
            }

            @Override
            public java.lang.Object getQueueConfigurations() {
                return this.queueConfigurations;
            }

            @Override
            public java.lang.Object getTopicConfigurations() {
                return this.topicConfigurations;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getLambdaConfigurations() != null) {
                    obj.set("lambdaConfigurations", om.valueToTree(this.getLambdaConfigurations()));
                }
                if (this.getQueueConfigurations() != null) {
                    obj.set("queueConfigurations", om.valueToTree(this.getQueueConfigurations()));
                }
                if (this.getTopicConfigurations() != null) {
                    obj.set("topicConfigurations", om.valueToTree(this.getTopicConfigurations()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotificationConfigurationProperty.Jsii$Proxy that = (NotificationConfigurationProperty.Jsii$Proxy) o;

                if (this.lambdaConfigurations != null ? !this.lambdaConfigurations.equals(that.lambdaConfigurations) : that.lambdaConfigurations != null) return false;
                if (this.queueConfigurations != null ? !this.queueConfigurations.equals(that.queueConfigurations) : that.queueConfigurations != null) return false;
                return this.topicConfigurations != null ? this.topicConfigurations.equals(that.topicConfigurations) : that.topicConfigurations == null;
            }

            @Override
            public int hashCode() {
                int result = this.lambdaConfigurations != null ? this.lambdaConfigurations.hashCode() : 0;
                result = 31 * result + (this.queueConfigurations != null ? this.queueConfigurations.hashCode() : 0);
                result = 31 * result + (this.topicConfigurations != null ? this.topicConfigurations.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface NotificationFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.NotificationFilterProperty.S3Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getS3Key();

        /**
         * @return a {@link Builder} of {@link NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object s3Key;

            /**
             * Sets the value of S3Key
             * @param s3Key `CfnBucket.NotificationFilterProperty.S3Key`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder s3Key(software.amazon.awscdk.core.IResolvable s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            /**
             * Sets the value of S3Key
             * @param s3Key `CfnBucket.NotificationFilterProperty.S3Key`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder s3Key(software.amazon.awscdk.services.s3.CfnBucket.S3KeyFilterProperty s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public NotificationFilterProperty build() {
                return new Jsii$Proxy(s3Key);
            }

        }

        /**
         * An implementation for {@link NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationFilterProperty {
            private final java.lang.Object s3Key;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.s3Key = this.jsiiGet("s3Key", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object s3Key) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Key = java.util.Objects.requireNonNull(s3Key, "s3Key is required");
            }

            @Override
            public java.lang.Object getS3Key() {
                return this.s3Key;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("s3Key", om.valueToTree(this.getS3Key()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotificationFilterProperty.Jsii$Proxy that = (NotificationFilterProperty.Jsii$Proxy) o;

                return this.s3Key.equals(that.s3Key);
            }

            @Override
            public int hashCode() {
                int result = this.s3Key.hashCode();
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ObjectLockConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.ObjectLockConfigurationProperty.ObjectLockEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockconfiguration.html#cfn-s3-bucket-objectlockconfiguration-objectlockenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getObjectLockEnabled();

        /**
         * `CfnBucket.ObjectLockConfigurationProperty.Rule`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockconfiguration.html#cfn-s3-bucket-objectlockconfiguration-rule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRule();

        /**
         * @return a {@link Builder} of {@link ObjectLockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ObjectLockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String objectLockEnabled;
            private java.lang.Object rule;

            /**
             * Sets the value of ObjectLockEnabled
             * @param objectLockEnabled `CfnBucket.ObjectLockConfigurationProperty.ObjectLockEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder objectLockEnabled(java.lang.String objectLockEnabled) {
                this.objectLockEnabled = objectLockEnabled;
                return this;
            }

            /**
             * Sets the value of Rule
             * @param rule `CfnBucket.ObjectLockConfigurationProperty.Rule`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder rule(software.amazon.awscdk.core.IResolvable rule) {
                this.rule = rule;
                return this;
            }

            /**
             * Sets the value of Rule
             * @param rule `CfnBucket.ObjectLockConfigurationProperty.Rule`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder rule(software.amazon.awscdk.services.s3.CfnBucket.ObjectLockRuleProperty rule) {
                this.rule = rule;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObjectLockConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ObjectLockConfigurationProperty build() {
                return new Jsii$Proxy(objectLockEnabled, rule);
            }

        }

        /**
         * An implementation for {@link ObjectLockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObjectLockConfigurationProperty {
            private final java.lang.String objectLockEnabled;
            private final java.lang.Object rule;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.objectLockEnabled = this.jsiiGet("objectLockEnabled", java.lang.String.class);
                this.rule = this.jsiiGet("rule", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String objectLockEnabled, java.lang.Object rule) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.objectLockEnabled = objectLockEnabled;
                this.rule = rule;
            }

            @Override
            public java.lang.String getObjectLockEnabled() {
                return this.objectLockEnabled;
            }

            @Override
            public java.lang.Object getRule() {
                return this.rule;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getObjectLockEnabled() != null) {
                    obj.set("objectLockEnabled", om.valueToTree(this.getObjectLockEnabled()));
                }
                if (this.getRule() != null) {
                    obj.set("rule", om.valueToTree(this.getRule()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ObjectLockConfigurationProperty.Jsii$Proxy that = (ObjectLockConfigurationProperty.Jsii$Proxy) o;

                if (this.objectLockEnabled != null ? !this.objectLockEnabled.equals(that.objectLockEnabled) : that.objectLockEnabled != null) return false;
                return this.rule != null ? this.rule.equals(that.rule) : that.rule == null;
            }

            @Override
            public int hashCode() {
                int result = this.objectLockEnabled != null ? this.objectLockEnabled.hashCode() : 0;
                result = 31 * result + (this.rule != null ? this.rule.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockrule.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ObjectLockRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.ObjectLockRuleProperty.DefaultRetention`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockrule.html#cfn-s3-bucket-objectlockrule-defaultretention
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getDefaultRetention();

        /**
         * @return a {@link Builder} of {@link ObjectLockRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ObjectLockRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object defaultRetention;

            /**
             * Sets the value of DefaultRetention
             * @param defaultRetention `CfnBucket.ObjectLockRuleProperty.DefaultRetention`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder defaultRetention(software.amazon.awscdk.core.IResolvable defaultRetention) {
                this.defaultRetention = defaultRetention;
                return this;
            }

            /**
             * Sets the value of DefaultRetention
             * @param defaultRetention `CfnBucket.ObjectLockRuleProperty.DefaultRetention`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder defaultRetention(software.amazon.awscdk.services.s3.CfnBucket.DefaultRetentionProperty defaultRetention) {
                this.defaultRetention = defaultRetention;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObjectLockRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ObjectLockRuleProperty build() {
                return new Jsii$Proxy(defaultRetention);
            }

        }

        /**
         * An implementation for {@link ObjectLockRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObjectLockRuleProperty {
            private final java.lang.Object defaultRetention;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.defaultRetention = this.jsiiGet("defaultRetention", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object defaultRetention) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultRetention = defaultRetention;
            }

            @Override
            public java.lang.Object getDefaultRetention() {
                return this.defaultRetention;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getDefaultRetention() != null) {
                    obj.set("defaultRetention", om.valueToTree(this.getDefaultRetention()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ObjectLockRuleProperty.Jsii$Proxy that = (ObjectLockRuleProperty.Jsii$Proxy) o;

                return this.defaultRetention != null ? this.defaultRetention.equals(that.defaultRetention) : that.defaultRetention == null;
            }

            @Override
            public int hashCode() {
                int result = this.defaultRetention != null ? this.defaultRetention.hashCode() : 0;
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface PublicAccessBlockConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicacls
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getBlockPublicAcls();

        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicpolicy
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getBlockPublicPolicy();

        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-ignorepublicacls
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getIgnorePublicAcls();

        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-restrictpublicbuckets
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRestrictPublicBuckets();

        /**
         * @return a {@link Builder} of {@link PublicAccessBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PublicAccessBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object blockPublicAcls;
            private java.lang.Object blockPublicPolicy;
            private java.lang.Object ignorePublicAcls;
            private java.lang.Object restrictPublicBuckets;

            /**
             * Sets the value of BlockPublicAcls
             * @param blockPublicAcls `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder blockPublicAcls(java.lang.Boolean blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            /**
             * Sets the value of BlockPublicAcls
             * @param blockPublicAcls `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder blockPublicAcls(software.amazon.awscdk.core.IResolvable blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            /**
             * Sets the value of BlockPublicPolicy
             * @param blockPublicPolicy `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder blockPublicPolicy(java.lang.Boolean blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            /**
             * Sets the value of BlockPublicPolicy
             * @param blockPublicPolicy `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder blockPublicPolicy(software.amazon.awscdk.core.IResolvable blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            /**
             * Sets the value of IgnorePublicAcls
             * @param ignorePublicAcls `CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ignorePublicAcls(java.lang.Boolean ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            /**
             * Sets the value of IgnorePublicAcls
             * @param ignorePublicAcls `CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ignorePublicAcls(software.amazon.awscdk.core.IResolvable ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            /**
             * Sets the value of RestrictPublicBuckets
             * @param restrictPublicBuckets `CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder restrictPublicBuckets(java.lang.Boolean restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            /**
             * Sets the value of RestrictPublicBuckets
             * @param restrictPublicBuckets `CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder restrictPublicBuckets(software.amazon.awscdk.core.IResolvable restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PublicAccessBlockConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public PublicAccessBlockConfigurationProperty build() {
                return new Jsii$Proxy(blockPublicAcls, blockPublicPolicy, ignorePublicAcls, restrictPublicBuckets);
            }

        }

        /**
         * An implementation for {@link PublicAccessBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublicAccessBlockConfigurationProperty {
            private final java.lang.Object blockPublicAcls;
            private final java.lang.Object blockPublicPolicy;
            private final java.lang.Object ignorePublicAcls;
            private final java.lang.Object restrictPublicBuckets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.blockPublicAcls = this.jsiiGet("blockPublicAcls", java.lang.Object.class);
                this.blockPublicPolicy = this.jsiiGet("blockPublicPolicy", java.lang.Object.class);
                this.ignorePublicAcls = this.jsiiGet("ignorePublicAcls", java.lang.Object.class);
                this.restrictPublicBuckets = this.jsiiGet("restrictPublicBuckets", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object blockPublicAcls, java.lang.Object blockPublicPolicy, java.lang.Object ignorePublicAcls, java.lang.Object restrictPublicBuckets) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blockPublicAcls = blockPublicAcls;
                this.blockPublicPolicy = blockPublicPolicy;
                this.ignorePublicAcls = ignorePublicAcls;
                this.restrictPublicBuckets = restrictPublicBuckets;
            }

            @Override
            public java.lang.Object getBlockPublicAcls() {
                return this.blockPublicAcls;
            }

            @Override
            public java.lang.Object getBlockPublicPolicy() {
                return this.blockPublicPolicy;
            }

            @Override
            public java.lang.Object getIgnorePublicAcls() {
                return this.ignorePublicAcls;
            }

            @Override
            public java.lang.Object getRestrictPublicBuckets() {
                return this.restrictPublicBuckets;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getBlockPublicAcls() != null) {
                    obj.set("blockPublicAcls", om.valueToTree(this.getBlockPublicAcls()));
                }
                if (this.getBlockPublicPolicy() != null) {
                    obj.set("blockPublicPolicy", om.valueToTree(this.getBlockPublicPolicy()));
                }
                if (this.getIgnorePublicAcls() != null) {
                    obj.set("ignorePublicAcls", om.valueToTree(this.getIgnorePublicAcls()));
                }
                if (this.getRestrictPublicBuckets() != null) {
                    obj.set("restrictPublicBuckets", om.valueToTree(this.getRestrictPublicBuckets()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PublicAccessBlockConfigurationProperty.Jsii$Proxy that = (PublicAccessBlockConfigurationProperty.Jsii$Proxy) o;

                if (this.blockPublicAcls != null ? !this.blockPublicAcls.equals(that.blockPublicAcls) : that.blockPublicAcls != null) return false;
                if (this.blockPublicPolicy != null ? !this.blockPublicPolicy.equals(that.blockPublicPolicy) : that.blockPublicPolicy != null) return false;
                if (this.ignorePublicAcls != null ? !this.ignorePublicAcls.equals(that.ignorePublicAcls) : that.ignorePublicAcls != null) return false;
                return this.restrictPublicBuckets != null ? this.restrictPublicBuckets.equals(that.restrictPublicBuckets) : that.restrictPublicBuckets == null;
            }

            @Override
            public int hashCode() {
                int result = this.blockPublicAcls != null ? this.blockPublicAcls.hashCode() : 0;
                result = 31 * result + (this.blockPublicPolicy != null ? this.blockPublicPolicy.hashCode() : 0);
                result = 31 * result + (this.ignorePublicAcls != null ? this.ignorePublicAcls.hashCode() : 0);
                result = 31 * result + (this.restrictPublicBuckets != null ? this.restrictPublicBuckets.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface QueueConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.QueueConfigurationProperty.Event`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getEvent();

        /**
         * `CfnBucket.QueueConfigurationProperty.Queue`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getQueue();

        /**
         * `CfnBucket.QueueConfigurationProperty.Filter`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getFilter();

        /**
         * @return a {@link Builder} of {@link QueueConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link QueueConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String event;
            private java.lang.String queue;
            private java.lang.Object filter;

            /**
             * Sets the value of Event
             * @param event `CfnBucket.QueueConfigurationProperty.Event`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder event(java.lang.String event) {
                this.event = event;
                return this;
            }

            /**
             * Sets the value of Queue
             * @param queue `CfnBucket.QueueConfigurationProperty.Queue`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder queue(java.lang.String queue) {
                this.queue = queue;
                return this;
            }

            /**
             * Sets the value of Filter
             * @param filter `CfnBucket.QueueConfigurationProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder filter(software.amazon.awscdk.core.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of Filter
             * @param filter `CfnBucket.QueueConfigurationProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder filter(software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueueConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public QueueConfigurationProperty build() {
                return new Jsii$Proxy(event, queue, filter);
            }

        }

        /**
         * An implementation for {@link QueueConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueueConfigurationProperty {
            private final java.lang.String event;
            private final java.lang.String queue;
            private final java.lang.Object filter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.event = this.jsiiGet("event", java.lang.String.class);
                this.queue = this.jsiiGet("queue", java.lang.String.class);
                this.filter = this.jsiiGet("filter", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String event, java.lang.String queue, java.lang.Object filter) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.event = java.util.Objects.requireNonNull(event, "event is required");
                this.queue = java.util.Objects.requireNonNull(queue, "queue is required");
                this.filter = filter;
            }

            @Override
            public java.lang.String getEvent() {
                return this.event;
            }

            @Override
            public java.lang.String getQueue() {
                return this.queue;
            }

            @Override
            public java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("event", om.valueToTree(this.getEvent()));
                obj.set("queue", om.valueToTree(this.getQueue()));
                if (this.getFilter() != null) {
                    obj.set("filter", om.valueToTree(this.getFilter()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueueConfigurationProperty.Jsii$Proxy that = (QueueConfigurationProperty.Jsii$Proxy) o;

                if (!event.equals(that.event)) return false;
                if (!queue.equals(that.queue)) return false;
                return this.filter != null ? this.filter.equals(that.filter) : that.filter == null;
            }

            @Override
            public int hashCode() {
                int result = this.event.hashCode();
                result = 31 * result + (this.queue.hashCode());
                result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface RedirectAllRequestsToProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.RedirectAllRequestsToProperty.HostName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getHostName();

        /**
         * `CfnBucket.RedirectAllRequestsToProperty.Protocol`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getProtocol();

        /**
         * @return a {@link Builder} of {@link RedirectAllRequestsToProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RedirectAllRequestsToProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String hostName;
            private java.lang.String protocol;

            /**
             * Sets the value of HostName
             * @param hostName `CfnBucket.RedirectAllRequestsToProperty.HostName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder hostName(java.lang.String hostName) {
                this.hostName = hostName;
                return this;
            }

            /**
             * Sets the value of Protocol
             * @param protocol `CfnBucket.RedirectAllRequestsToProperty.Protocol`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedirectAllRequestsToProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public RedirectAllRequestsToProperty build() {
                return new Jsii$Proxy(hostName, protocol);
            }

        }

        /**
         * An implementation for {@link RedirectAllRequestsToProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedirectAllRequestsToProperty {
            private final java.lang.String hostName;
            private final java.lang.String protocol;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.hostName = this.jsiiGet("hostName", java.lang.String.class);
                this.protocol = this.jsiiGet("protocol", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String hostName, java.lang.String protocol) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hostName = java.util.Objects.requireNonNull(hostName, "hostName is required");
                this.protocol = protocol;
            }

            @Override
            public java.lang.String getHostName() {
                return this.hostName;
            }

            @Override
            public java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("hostName", om.valueToTree(this.getHostName()));
                if (this.getProtocol() != null) {
                    obj.set("protocol", om.valueToTree(this.getProtocol()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedirectAllRequestsToProperty.Jsii$Proxy that = (RedirectAllRequestsToProperty.Jsii$Proxy) o;

                if (!hostName.equals(that.hostName)) return false;
                return this.protocol != null ? this.protocol.equals(that.protocol) : that.protocol == null;
            }

            @Override
            public int hashCode() {
                int result = this.hostName.hashCode();
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface RedirectRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.RedirectRuleProperty.HostName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getHostName();

        /**
         * `CfnBucket.RedirectRuleProperty.HttpRedirectCode`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getHttpRedirectCode();

        /**
         * `CfnBucket.RedirectRuleProperty.Protocol`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getProtocol();

        /**
         * `CfnBucket.RedirectRuleProperty.ReplaceKeyPrefixWith`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getReplaceKeyPrefixWith();

        /**
         * `CfnBucket.RedirectRuleProperty.ReplaceKeyWith`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getReplaceKeyWith();

        /**
         * @return a {@link Builder} of {@link RedirectRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RedirectRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String hostName;
            private java.lang.String httpRedirectCode;
            private java.lang.String protocol;
            private java.lang.String replaceKeyPrefixWith;
            private java.lang.String replaceKeyWith;

            /**
             * Sets the value of HostName
             * @param hostName `CfnBucket.RedirectRuleProperty.HostName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder hostName(java.lang.String hostName) {
                this.hostName = hostName;
                return this;
            }

            /**
             * Sets the value of HttpRedirectCode
             * @param httpRedirectCode `CfnBucket.RedirectRuleProperty.HttpRedirectCode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder httpRedirectCode(java.lang.String httpRedirectCode) {
                this.httpRedirectCode = httpRedirectCode;
                return this;
            }

            /**
             * Sets the value of Protocol
             * @param protocol `CfnBucket.RedirectRuleProperty.Protocol`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of ReplaceKeyPrefixWith
             * @param replaceKeyPrefixWith `CfnBucket.RedirectRuleProperty.ReplaceKeyPrefixWith`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder replaceKeyPrefixWith(java.lang.String replaceKeyPrefixWith) {
                this.replaceKeyPrefixWith = replaceKeyPrefixWith;
                return this;
            }

            /**
             * Sets the value of ReplaceKeyWith
             * @param replaceKeyWith `CfnBucket.RedirectRuleProperty.ReplaceKeyWith`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder replaceKeyWith(java.lang.String replaceKeyWith) {
                this.replaceKeyWith = replaceKeyWith;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedirectRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public RedirectRuleProperty build() {
                return new Jsii$Proxy(hostName, httpRedirectCode, protocol, replaceKeyPrefixWith, replaceKeyWith);
            }

        }

        /**
         * An implementation for {@link RedirectRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedirectRuleProperty {
            private final java.lang.String hostName;
            private final java.lang.String httpRedirectCode;
            private final java.lang.String protocol;
            private final java.lang.String replaceKeyPrefixWith;
            private final java.lang.String replaceKeyWith;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.hostName = this.jsiiGet("hostName", java.lang.String.class);
                this.httpRedirectCode = this.jsiiGet("httpRedirectCode", java.lang.String.class);
                this.protocol = this.jsiiGet("protocol", java.lang.String.class);
                this.replaceKeyPrefixWith = this.jsiiGet("replaceKeyPrefixWith", java.lang.String.class);
                this.replaceKeyWith = this.jsiiGet("replaceKeyWith", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String hostName, java.lang.String httpRedirectCode, java.lang.String protocol, java.lang.String replaceKeyPrefixWith, java.lang.String replaceKeyWith) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hostName = hostName;
                this.httpRedirectCode = httpRedirectCode;
                this.protocol = protocol;
                this.replaceKeyPrefixWith = replaceKeyPrefixWith;
                this.replaceKeyWith = replaceKeyWith;
            }

            @Override
            public java.lang.String getHostName() {
                return this.hostName;
            }

            @Override
            public java.lang.String getHttpRedirectCode() {
                return this.httpRedirectCode;
            }

            @Override
            public java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public java.lang.String getReplaceKeyPrefixWith() {
                return this.replaceKeyPrefixWith;
            }

            @Override
            public java.lang.String getReplaceKeyWith() {
                return this.replaceKeyWith;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getHostName() != null) {
                    obj.set("hostName", om.valueToTree(this.getHostName()));
                }
                if (this.getHttpRedirectCode() != null) {
                    obj.set("httpRedirectCode", om.valueToTree(this.getHttpRedirectCode()));
                }
                if (this.getProtocol() != null) {
                    obj.set("protocol", om.valueToTree(this.getProtocol()));
                }
                if (this.getReplaceKeyPrefixWith() != null) {
                    obj.set("replaceKeyPrefixWith", om.valueToTree(this.getReplaceKeyPrefixWith()));
                }
                if (this.getReplaceKeyWith() != null) {
                    obj.set("replaceKeyWith", om.valueToTree(this.getReplaceKeyWith()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedirectRuleProperty.Jsii$Proxy that = (RedirectRuleProperty.Jsii$Proxy) o;

                if (this.hostName != null ? !this.hostName.equals(that.hostName) : that.hostName != null) return false;
                if (this.httpRedirectCode != null ? !this.httpRedirectCode.equals(that.httpRedirectCode) : that.httpRedirectCode != null) return false;
                if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
                if (this.replaceKeyPrefixWith != null ? !this.replaceKeyPrefixWith.equals(that.replaceKeyPrefixWith) : that.replaceKeyPrefixWith != null) return false;
                return this.replaceKeyWith != null ? this.replaceKeyWith.equals(that.replaceKeyWith) : that.replaceKeyWith == null;
            }

            @Override
            public int hashCode() {
                int result = this.hostName != null ? this.hostName.hashCode() : 0;
                result = 31 * result + (this.httpRedirectCode != null ? this.httpRedirectCode.hashCode() : 0);
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                result = 31 * result + (this.replaceKeyPrefixWith != null ? this.replaceKeyPrefixWith.hashCode() : 0);
                result = 31 * result + (this.replaceKeyWith != null ? this.replaceKeyWith.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ReplicationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.ReplicationConfigurationProperty.Role`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getRole();

        /**
         * `CfnBucket.ReplicationConfigurationProperty.Rules`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link ReplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ReplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String role;
            private java.lang.Object rules;

            /**
             * Sets the value of Role
             * @param role `CfnBucket.ReplicationConfigurationProperty.Role`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder role(java.lang.String role) {
                this.role = role;
                return this;
            }

            /**
             * Sets the value of Rules
             * @param rules `CfnBucket.ReplicationConfigurationProperty.Rules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder rules(software.amazon.awscdk.core.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of Rules
             * @param rules `CfnBucket.ReplicationConfigurationProperty.Rules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder rules(java.util.List<java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ReplicationConfigurationProperty build() {
                return new Jsii$Proxy(role, rules);
            }

        }

        /**
         * An implementation for {@link ReplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationConfigurationProperty {
            private final java.lang.String role;
            private final java.lang.Object rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.role = this.jsiiGet("role", java.lang.String.class);
                this.rules = this.jsiiGet("rules", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String role, java.lang.Object rules) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.role = java.util.Objects.requireNonNull(role, "role is required");
                this.rules = java.util.Objects.requireNonNull(rules, "rules is required");
            }

            @Override
            public java.lang.String getRole() {
                return this.role;
            }

            @Override
            public java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("role", om.valueToTree(this.getRole()));
                obj.set("rules", om.valueToTree(this.getRules()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationConfigurationProperty.Jsii$Proxy that = (ReplicationConfigurationProperty.Jsii$Proxy) o;

                if (!role.equals(that.role)) return false;
                return this.rules.equals(that.rules);
            }

            @Override
            public int hashCode() {
                int result = this.role.hashCode();
                result = 31 * result + (this.rules.hashCode());
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ReplicationDestinationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.ReplicationDestinationProperty.Bucket`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getBucket();

        /**
         * `CfnBucket.ReplicationDestinationProperty.AccessControlTranslation`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getAccessControlTranslation();

        /**
         * `CfnBucket.ReplicationDestinationProperty.Account`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getAccount();

        /**
         * `CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEncryptionConfiguration();

        /**
         * `CfnBucket.ReplicationDestinationProperty.StorageClass`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStorageClass();

        /**
         * @return a {@link Builder} of {@link ReplicationDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ReplicationDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String bucket;
            private java.lang.Object accessControlTranslation;
            private java.lang.String account;
            private java.lang.Object encryptionConfiguration;
            private java.lang.String storageClass;

            /**
             * Sets the value of Bucket
             * @param bucket `CfnBucket.ReplicationDestinationProperty.Bucket`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of AccessControlTranslation
             * @param accessControlTranslation `CfnBucket.ReplicationDestinationProperty.AccessControlTranslation`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder accessControlTranslation(software.amazon.awscdk.core.IResolvable accessControlTranslation) {
                this.accessControlTranslation = accessControlTranslation;
                return this;
            }

            /**
             * Sets the value of AccessControlTranslation
             * @param accessControlTranslation `CfnBucket.ReplicationDestinationProperty.AccessControlTranslation`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder accessControlTranslation(software.amazon.awscdk.services.s3.CfnBucket.AccessControlTranslationProperty accessControlTranslation) {
                this.accessControlTranslation = accessControlTranslation;
                return this;
            }

            /**
             * Sets the value of Account
             * @param account `CfnBucket.ReplicationDestinationProperty.Account`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder account(java.lang.String account) {
                this.account = account;
                return this;
            }

            /**
             * Sets the value of EncryptionConfiguration
             * @param encryptionConfiguration `CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder encryptionConfiguration(software.amazon.awscdk.core.IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of EncryptionConfiguration
             * @param encryptionConfiguration `CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder encryptionConfiguration(software.amazon.awscdk.services.s3.CfnBucket.EncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of StorageClass
             * @param storageClass `CfnBucket.ReplicationDestinationProperty.StorageClass`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder storageClass(java.lang.String storageClass) {
                this.storageClass = storageClass;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ReplicationDestinationProperty build() {
                return new Jsii$Proxy(bucket, accessControlTranslation, account, encryptionConfiguration, storageClass);
            }

        }

        /**
         * An implementation for {@link ReplicationDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationDestinationProperty {
            private final java.lang.String bucket;
            private final java.lang.Object accessControlTranslation;
            private final java.lang.String account;
            private final java.lang.Object encryptionConfiguration;
            private final java.lang.String storageClass;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.bucket = this.jsiiGet("bucket", java.lang.String.class);
                this.accessControlTranslation = this.jsiiGet("accessControlTranslation", java.lang.Object.class);
                this.account = this.jsiiGet("account", java.lang.String.class);
                this.encryptionConfiguration = this.jsiiGet("encryptionConfiguration", java.lang.Object.class);
                this.storageClass = this.jsiiGet("storageClass", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String bucket, java.lang.Object accessControlTranslation, java.lang.String account, java.lang.Object encryptionConfiguration, java.lang.String storageClass) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(bucket, "bucket is required");
                this.accessControlTranslation = accessControlTranslation;
                this.account = account;
                this.encryptionConfiguration = encryptionConfiguration;
                this.storageClass = storageClass;
            }

            @Override
            public java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public java.lang.Object getAccessControlTranslation() {
                return this.accessControlTranslation;
            }

            @Override
            public java.lang.String getAccount() {
                return this.account;
            }

            @Override
            public java.lang.Object getEncryptionConfiguration() {
                return this.encryptionConfiguration;
            }

            @Override
            public java.lang.String getStorageClass() {
                return this.storageClass;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("bucket", om.valueToTree(this.getBucket()));
                if (this.getAccessControlTranslation() != null) {
                    obj.set("accessControlTranslation", om.valueToTree(this.getAccessControlTranslation()));
                }
                if (this.getAccount() != null) {
                    obj.set("account", om.valueToTree(this.getAccount()));
                }
                if (this.getEncryptionConfiguration() != null) {
                    obj.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
                }
                if (this.getStorageClass() != null) {
                    obj.set("storageClass", om.valueToTree(this.getStorageClass()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationDestinationProperty.Jsii$Proxy that = (ReplicationDestinationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (this.accessControlTranslation != null ? !this.accessControlTranslation.equals(that.accessControlTranslation) : that.accessControlTranslation != null) return false;
                if (this.account != null ? !this.account.equals(that.account) : that.account != null) return false;
                if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
                return this.storageClass != null ? this.storageClass.equals(that.storageClass) : that.storageClass == null;
            }

            @Override
            public int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.accessControlTranslation != null ? this.accessControlTranslation.hashCode() : 0);
                result = 31 * result + (this.account != null ? this.account.hashCode() : 0);
                result = 31 * result + (this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0);
                result = 31 * result + (this.storageClass != null ? this.storageClass.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ReplicationRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.ReplicationRuleProperty.Destination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getDestination();

        /**
         * `CfnBucket.ReplicationRuleProperty.Prefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPrefix();

        /**
         * `CfnBucket.ReplicationRuleProperty.Status`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStatus();

        /**
         * `CfnBucket.ReplicationRuleProperty.Id`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getId();

        /**
         * `CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSourceSelectionCriteria();

        /**
         * @return a {@link Builder} of {@link ReplicationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ReplicationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object destination;
            private java.lang.String prefix;
            private java.lang.String status;
            private java.lang.String id;
            private java.lang.Object sourceSelectionCriteria;

            /**
             * Sets the value of Destination
             * @param destination `CfnBucket.ReplicationRuleProperty.Destination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder destination(software.amazon.awscdk.core.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of Destination
             * @param destination `CfnBucket.ReplicationRuleProperty.Destination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder destination(software.amazon.awscdk.services.s3.CfnBucket.ReplicationDestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of Prefix
             * @param prefix `CfnBucket.ReplicationRuleProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of Status
             * @param status `CfnBucket.ReplicationRuleProperty.Status`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of Id
             * @param id `CfnBucket.ReplicationRuleProperty.Id`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of SourceSelectionCriteria
             * @param sourceSelectionCriteria `CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sourceSelectionCriteria(software.amazon.awscdk.core.IResolvable sourceSelectionCriteria) {
                this.sourceSelectionCriteria = sourceSelectionCriteria;
                return this;
            }

            /**
             * Sets the value of SourceSelectionCriteria
             * @param sourceSelectionCriteria `CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sourceSelectionCriteria(software.amazon.awscdk.services.s3.CfnBucket.SourceSelectionCriteriaProperty sourceSelectionCriteria) {
                this.sourceSelectionCriteria = sourceSelectionCriteria;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ReplicationRuleProperty build() {
                return new Jsii$Proxy(destination, prefix, status, id, sourceSelectionCriteria);
            }

        }

        /**
         * An implementation for {@link ReplicationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationRuleProperty {
            private final java.lang.Object destination;
            private final java.lang.String prefix;
            private final java.lang.String status;
            private final java.lang.String id;
            private final java.lang.Object sourceSelectionCriteria;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.destination = this.jsiiGet("destination", java.lang.Object.class);
                this.prefix = this.jsiiGet("prefix", java.lang.String.class);
                this.status = this.jsiiGet("status", java.lang.String.class);
                this.id = this.jsiiGet("id", java.lang.String.class);
                this.sourceSelectionCriteria = this.jsiiGet("sourceSelectionCriteria", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object destination, java.lang.String prefix, java.lang.String status, java.lang.String id, java.lang.Object sourceSelectionCriteria) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(destination, "destination is required");
                this.prefix = java.util.Objects.requireNonNull(prefix, "prefix is required");
                this.status = java.util.Objects.requireNonNull(status, "status is required");
                this.id = id;
                this.sourceSelectionCriteria = sourceSelectionCriteria;
            }

            @Override
            public java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public java.lang.String getId() {
                return this.id;
            }

            @Override
            public java.lang.Object getSourceSelectionCriteria() {
                return this.sourceSelectionCriteria;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("destination", om.valueToTree(this.getDestination()));
                obj.set("prefix", om.valueToTree(this.getPrefix()));
                obj.set("status", om.valueToTree(this.getStatus()));
                if (this.getId() != null) {
                    obj.set("id", om.valueToTree(this.getId()));
                }
                if (this.getSourceSelectionCriteria() != null) {
                    obj.set("sourceSelectionCriteria", om.valueToTree(this.getSourceSelectionCriteria()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationRuleProperty.Jsii$Proxy that = (ReplicationRuleProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                if (!prefix.equals(that.prefix)) return false;
                if (!status.equals(that.status)) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                return this.sourceSelectionCriteria != null ? this.sourceSelectionCriteria.equals(that.sourceSelectionCriteria) : that.sourceSelectionCriteria == null;
            }

            @Override
            public int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.prefix.hashCode());
                result = 31 * result + (this.status.hashCode());
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.sourceSelectionCriteria != null ? this.sourceSelectionCriteria.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface RoutingRuleConditionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getHttpErrorCodeReturnedEquals();

        /**
         * `CfnBucket.RoutingRuleConditionProperty.KeyPrefixEquals`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKeyPrefixEquals();

        /**
         * @return a {@link Builder} of {@link RoutingRuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RoutingRuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String httpErrorCodeReturnedEquals;
            private java.lang.String keyPrefixEquals;

            /**
             * Sets the value of HttpErrorCodeReturnedEquals
             * @param httpErrorCodeReturnedEquals `CfnBucket.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder httpErrorCodeReturnedEquals(java.lang.String httpErrorCodeReturnedEquals) {
                this.httpErrorCodeReturnedEquals = httpErrorCodeReturnedEquals;
                return this;
            }

            /**
             * Sets the value of KeyPrefixEquals
             * @param keyPrefixEquals `CfnBucket.RoutingRuleConditionProperty.KeyPrefixEquals`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder keyPrefixEquals(java.lang.String keyPrefixEquals) {
                this.keyPrefixEquals = keyPrefixEquals;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RoutingRuleConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public RoutingRuleConditionProperty build() {
                return new Jsii$Proxy(httpErrorCodeReturnedEquals, keyPrefixEquals);
            }

        }

        /**
         * An implementation for {@link RoutingRuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RoutingRuleConditionProperty {
            private final java.lang.String httpErrorCodeReturnedEquals;
            private final java.lang.String keyPrefixEquals;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.httpErrorCodeReturnedEquals = this.jsiiGet("httpErrorCodeReturnedEquals", java.lang.String.class);
                this.keyPrefixEquals = this.jsiiGet("keyPrefixEquals", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String httpErrorCodeReturnedEquals, java.lang.String keyPrefixEquals) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.httpErrorCodeReturnedEquals = httpErrorCodeReturnedEquals;
                this.keyPrefixEquals = keyPrefixEquals;
            }

            @Override
            public java.lang.String getHttpErrorCodeReturnedEquals() {
                return this.httpErrorCodeReturnedEquals;
            }

            @Override
            public java.lang.String getKeyPrefixEquals() {
                return this.keyPrefixEquals;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getHttpErrorCodeReturnedEquals() != null) {
                    obj.set("httpErrorCodeReturnedEquals", om.valueToTree(this.getHttpErrorCodeReturnedEquals()));
                }
                if (this.getKeyPrefixEquals() != null) {
                    obj.set("keyPrefixEquals", om.valueToTree(this.getKeyPrefixEquals()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RoutingRuleConditionProperty.Jsii$Proxy that = (RoutingRuleConditionProperty.Jsii$Proxy) o;

                if (this.httpErrorCodeReturnedEquals != null ? !this.httpErrorCodeReturnedEquals.equals(that.httpErrorCodeReturnedEquals) : that.httpErrorCodeReturnedEquals != null) return false;
                return this.keyPrefixEquals != null ? this.keyPrefixEquals.equals(that.keyPrefixEquals) : that.keyPrefixEquals == null;
            }

            @Override
            public int hashCode() {
                int result = this.httpErrorCodeReturnedEquals != null ? this.httpErrorCodeReturnedEquals.hashCode() : 0;
                result = 31 * result + (this.keyPrefixEquals != null ? this.keyPrefixEquals.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface RoutingRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.RoutingRuleProperty.RedirectRule`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRedirectRule();

        /**
         * `CfnBucket.RoutingRuleProperty.RoutingRuleCondition`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRoutingRuleCondition();

        /**
         * @return a {@link Builder} of {@link RoutingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RoutingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object redirectRule;
            private java.lang.Object routingRuleCondition;

            /**
             * Sets the value of RedirectRule
             * @param redirectRule `CfnBucket.RoutingRuleProperty.RedirectRule`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder redirectRule(software.amazon.awscdk.core.IResolvable redirectRule) {
                this.redirectRule = redirectRule;
                return this;
            }

            /**
             * Sets the value of RedirectRule
             * @param redirectRule `CfnBucket.RoutingRuleProperty.RedirectRule`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder redirectRule(software.amazon.awscdk.services.s3.CfnBucket.RedirectRuleProperty redirectRule) {
                this.redirectRule = redirectRule;
                return this;
            }

            /**
             * Sets the value of RoutingRuleCondition
             * @param routingRuleCondition `CfnBucket.RoutingRuleProperty.RoutingRuleCondition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder routingRuleCondition(software.amazon.awscdk.core.IResolvable routingRuleCondition) {
                this.routingRuleCondition = routingRuleCondition;
                return this;
            }

            /**
             * Sets the value of RoutingRuleCondition
             * @param routingRuleCondition `CfnBucket.RoutingRuleProperty.RoutingRuleCondition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder routingRuleCondition(software.amazon.awscdk.services.s3.CfnBucket.RoutingRuleConditionProperty routingRuleCondition) {
                this.routingRuleCondition = routingRuleCondition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RoutingRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public RoutingRuleProperty build() {
                return new Jsii$Proxy(redirectRule, routingRuleCondition);
            }

        }

        /**
         * An implementation for {@link RoutingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RoutingRuleProperty {
            private final java.lang.Object redirectRule;
            private final java.lang.Object routingRuleCondition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.redirectRule = this.jsiiGet("redirectRule", java.lang.Object.class);
                this.routingRuleCondition = this.jsiiGet("routingRuleCondition", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object redirectRule, java.lang.Object routingRuleCondition) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.redirectRule = java.util.Objects.requireNonNull(redirectRule, "redirectRule is required");
                this.routingRuleCondition = routingRuleCondition;
            }

            @Override
            public java.lang.Object getRedirectRule() {
                return this.redirectRule;
            }

            @Override
            public java.lang.Object getRoutingRuleCondition() {
                return this.routingRuleCondition;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("redirectRule", om.valueToTree(this.getRedirectRule()));
                if (this.getRoutingRuleCondition() != null) {
                    obj.set("routingRuleCondition", om.valueToTree(this.getRoutingRuleCondition()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RoutingRuleProperty.Jsii$Proxy that = (RoutingRuleProperty.Jsii$Proxy) o;

                if (!redirectRule.equals(that.redirectRule)) return false;
                return this.routingRuleCondition != null ? this.routingRuleCondition.equals(that.routingRuleCondition) : that.routingRuleCondition == null;
            }

            @Override
            public int hashCode() {
                int result = this.redirectRule.hashCode();
                result = 31 * result + (this.routingRuleCondition != null ? this.routingRuleCondition.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface RuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.RuleProperty.Status`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStatus();

        /**
         * `CfnBucket.RuleProperty.AbortIncompleteMultipartUpload`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getAbortIncompleteMultipartUpload();

        /**
         * `CfnBucket.RuleProperty.ExpirationDate`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getExpirationDate();

        /**
         * `CfnBucket.RuleProperty.ExpirationInDays`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getExpirationInDays();

        /**
         * `CfnBucket.RuleProperty.Id`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getId();

        /**
         * `CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getNoncurrentVersionExpirationInDays();

        /**
         * `CfnBucket.RuleProperty.NoncurrentVersionTransition`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getNoncurrentVersionTransition();

        /**
         * `CfnBucket.RuleProperty.NoncurrentVersionTransitions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getNoncurrentVersionTransitions();

        /**
         * `CfnBucket.RuleProperty.Prefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPrefix();

        /**
         * `CfnBucket.RuleProperty.TagFilters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getTagFilters();

        /**
         * `CfnBucket.RuleProperty.Transition`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getTransition();

        /**
         * `CfnBucket.RuleProperty.Transitions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getTransitions();

        /**
         * @return a {@link Builder} of {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String status;
            private java.lang.Object abortIncompleteMultipartUpload;
            private java.lang.Object expirationDate;
            private java.lang.Number expirationInDays;
            private java.lang.String id;
            private java.lang.Number noncurrentVersionExpirationInDays;
            private java.lang.Object noncurrentVersionTransition;
            private java.lang.Object noncurrentVersionTransitions;
            private java.lang.String prefix;
            private java.lang.Object tagFilters;
            private java.lang.Object transition;
            private java.lang.Object transitions;

            /**
             * Sets the value of Status
             * @param status `CfnBucket.RuleProperty.Status`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of AbortIncompleteMultipartUpload
             * @param abortIncompleteMultipartUpload `CfnBucket.RuleProperty.AbortIncompleteMultipartUpload`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder abortIncompleteMultipartUpload(software.amazon.awscdk.core.IResolvable abortIncompleteMultipartUpload) {
                this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
                return this;
            }

            /**
             * Sets the value of AbortIncompleteMultipartUpload
             * @param abortIncompleteMultipartUpload `CfnBucket.RuleProperty.AbortIncompleteMultipartUpload`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder abortIncompleteMultipartUpload(software.amazon.awscdk.services.s3.CfnBucket.AbortIncompleteMultipartUploadProperty abortIncompleteMultipartUpload) {
                this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
                return this;
            }

            /**
             * Sets the value of ExpirationDate
             * @param expirationDate `CfnBucket.RuleProperty.ExpirationDate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder expirationDate(java.time.Instant expirationDate) {
                this.expirationDate = expirationDate;
                return this;
            }

            /**
             * Sets the value of ExpirationDate
             * @param expirationDate `CfnBucket.RuleProperty.ExpirationDate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder expirationDate(software.amazon.awscdk.core.IResolvable expirationDate) {
                this.expirationDate = expirationDate;
                return this;
            }

            /**
             * Sets the value of ExpirationInDays
             * @param expirationInDays `CfnBucket.RuleProperty.ExpirationInDays`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder expirationInDays(java.lang.Number expirationInDays) {
                this.expirationInDays = expirationInDays;
                return this;
            }

            /**
             * Sets the value of Id
             * @param id `CfnBucket.RuleProperty.Id`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of NoncurrentVersionExpirationInDays
             * @param noncurrentVersionExpirationInDays `CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder noncurrentVersionExpirationInDays(java.lang.Number noncurrentVersionExpirationInDays) {
                this.noncurrentVersionExpirationInDays = noncurrentVersionExpirationInDays;
                return this;
            }

            /**
             * Sets the value of NoncurrentVersionTransition
             * @param noncurrentVersionTransition `CfnBucket.RuleProperty.NoncurrentVersionTransition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder noncurrentVersionTransition(software.amazon.awscdk.core.IResolvable noncurrentVersionTransition) {
                this.noncurrentVersionTransition = noncurrentVersionTransition;
                return this;
            }

            /**
             * Sets the value of NoncurrentVersionTransition
             * @param noncurrentVersionTransition `CfnBucket.RuleProperty.NoncurrentVersionTransition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder noncurrentVersionTransition(software.amazon.awscdk.services.s3.CfnBucket.NoncurrentVersionTransitionProperty noncurrentVersionTransition) {
                this.noncurrentVersionTransition = noncurrentVersionTransition;
                return this;
            }

            /**
             * Sets the value of NoncurrentVersionTransitions
             * @param noncurrentVersionTransitions `CfnBucket.RuleProperty.NoncurrentVersionTransitions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder noncurrentVersionTransitions(software.amazon.awscdk.core.IResolvable noncurrentVersionTransitions) {
                this.noncurrentVersionTransitions = noncurrentVersionTransitions;
                return this;
            }

            /**
             * Sets the value of NoncurrentVersionTransitions
             * @param noncurrentVersionTransitions `CfnBucket.RuleProperty.NoncurrentVersionTransitions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder noncurrentVersionTransitions(java.util.List<java.lang.Object> noncurrentVersionTransitions) {
                this.noncurrentVersionTransitions = noncurrentVersionTransitions;
                return this;
            }

            /**
             * Sets the value of Prefix
             * @param prefix `CfnBucket.RuleProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of TagFilters
             * @param tagFilters `CfnBucket.RuleProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder tagFilters(software.amazon.awscdk.core.IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Sets the value of TagFilters
             * @param tagFilters `CfnBucket.RuleProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder tagFilters(java.util.List<java.lang.Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Sets the value of Transition
             * @param transition `CfnBucket.RuleProperty.Transition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder transition(software.amazon.awscdk.core.IResolvable transition) {
                this.transition = transition;
                return this;
            }

            /**
             * Sets the value of Transition
             * @param transition `CfnBucket.RuleProperty.Transition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder transition(software.amazon.awscdk.services.s3.CfnBucket.TransitionProperty transition) {
                this.transition = transition;
                return this;
            }

            /**
             * Sets the value of Transitions
             * @param transitions `CfnBucket.RuleProperty.Transitions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder transitions(software.amazon.awscdk.core.IResolvable transitions) {
                this.transitions = transitions;
                return this;
            }

            /**
             * Sets the value of Transitions
             * @param transitions `CfnBucket.RuleProperty.Transitions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder transitions(java.util.List<java.lang.Object> transitions) {
                this.transitions = transitions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public RuleProperty build() {
                return new Jsii$Proxy(status, abortIncompleteMultipartUpload, expirationDate, expirationInDays, id, noncurrentVersionExpirationInDays, noncurrentVersionTransition, noncurrentVersionTransitions, prefix, tagFilters, transition, transitions);
            }

        }

        /**
         * An implementation for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleProperty {
            private final java.lang.String status;
            private final java.lang.Object abortIncompleteMultipartUpload;
            private final java.lang.Object expirationDate;
            private final java.lang.Number expirationInDays;
            private final java.lang.String id;
            private final java.lang.Number noncurrentVersionExpirationInDays;
            private final java.lang.Object noncurrentVersionTransition;
            private final java.lang.Object noncurrentVersionTransitions;
            private final java.lang.String prefix;
            private final java.lang.Object tagFilters;
            private final java.lang.Object transition;
            private final java.lang.Object transitions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.status = this.jsiiGet("status", java.lang.String.class);
                this.abortIncompleteMultipartUpload = this.jsiiGet("abortIncompleteMultipartUpload", java.lang.Object.class);
                this.expirationDate = this.jsiiGet("expirationDate", java.lang.Object.class);
                this.expirationInDays = this.jsiiGet("expirationInDays", java.lang.Number.class);
                this.id = this.jsiiGet("id", java.lang.String.class);
                this.noncurrentVersionExpirationInDays = this.jsiiGet("noncurrentVersionExpirationInDays", java.lang.Number.class);
                this.noncurrentVersionTransition = this.jsiiGet("noncurrentVersionTransition", java.lang.Object.class);
                this.noncurrentVersionTransitions = this.jsiiGet("noncurrentVersionTransitions", java.lang.Object.class);
                this.prefix = this.jsiiGet("prefix", java.lang.String.class);
                this.tagFilters = this.jsiiGet("tagFilters", java.lang.Object.class);
                this.transition = this.jsiiGet("transition", java.lang.Object.class);
                this.transitions = this.jsiiGet("transitions", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String status, java.lang.Object abortIncompleteMultipartUpload, java.lang.Object expirationDate, java.lang.Number expirationInDays, java.lang.String id, java.lang.Number noncurrentVersionExpirationInDays, java.lang.Object noncurrentVersionTransition, java.lang.Object noncurrentVersionTransitions, java.lang.String prefix, java.lang.Object tagFilters, java.lang.Object transition, java.lang.Object transitions) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(status, "status is required");
                this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
                this.expirationDate = expirationDate;
                this.expirationInDays = expirationInDays;
                this.id = id;
                this.noncurrentVersionExpirationInDays = noncurrentVersionExpirationInDays;
                this.noncurrentVersionTransition = noncurrentVersionTransition;
                this.noncurrentVersionTransitions = noncurrentVersionTransitions;
                this.prefix = prefix;
                this.tagFilters = tagFilters;
                this.transition = transition;
                this.transitions = transitions;
            }

            @Override
            public java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public java.lang.Object getAbortIncompleteMultipartUpload() {
                return this.abortIncompleteMultipartUpload;
            }

            @Override
            public java.lang.Object getExpirationDate() {
                return this.expirationDate;
            }

            @Override
            public java.lang.Number getExpirationInDays() {
                return this.expirationInDays;
            }

            @Override
            public java.lang.String getId() {
                return this.id;
            }

            @Override
            public java.lang.Number getNoncurrentVersionExpirationInDays() {
                return this.noncurrentVersionExpirationInDays;
            }

            @Override
            public java.lang.Object getNoncurrentVersionTransition() {
                return this.noncurrentVersionTransition;
            }

            @Override
            public java.lang.Object getNoncurrentVersionTransitions() {
                return this.noncurrentVersionTransitions;
            }

            @Override
            public java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public java.lang.Object getTagFilters() {
                return this.tagFilters;
            }

            @Override
            public java.lang.Object getTransition() {
                return this.transition;
            }

            @Override
            public java.lang.Object getTransitions() {
                return this.transitions;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("status", om.valueToTree(this.getStatus()));
                if (this.getAbortIncompleteMultipartUpload() != null) {
                    obj.set("abortIncompleteMultipartUpload", om.valueToTree(this.getAbortIncompleteMultipartUpload()));
                }
                if (this.getExpirationDate() != null) {
                    obj.set("expirationDate", om.valueToTree(this.getExpirationDate()));
                }
                if (this.getExpirationInDays() != null) {
                    obj.set("expirationInDays", om.valueToTree(this.getExpirationInDays()));
                }
                if (this.getId() != null) {
                    obj.set("id", om.valueToTree(this.getId()));
                }
                if (this.getNoncurrentVersionExpirationInDays() != null) {
                    obj.set("noncurrentVersionExpirationInDays", om.valueToTree(this.getNoncurrentVersionExpirationInDays()));
                }
                if (this.getNoncurrentVersionTransition() != null) {
                    obj.set("noncurrentVersionTransition", om.valueToTree(this.getNoncurrentVersionTransition()));
                }
                if (this.getNoncurrentVersionTransitions() != null) {
                    obj.set("noncurrentVersionTransitions", om.valueToTree(this.getNoncurrentVersionTransitions()));
                }
                if (this.getPrefix() != null) {
                    obj.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getTagFilters() != null) {
                    obj.set("tagFilters", om.valueToTree(this.getTagFilters()));
                }
                if (this.getTransition() != null) {
                    obj.set("transition", om.valueToTree(this.getTransition()));
                }
                if (this.getTransitions() != null) {
                    obj.set("transitions", om.valueToTree(this.getTransitions()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleProperty.Jsii$Proxy that = (RuleProperty.Jsii$Proxy) o;

                if (!status.equals(that.status)) return false;
                if (this.abortIncompleteMultipartUpload != null ? !this.abortIncompleteMultipartUpload.equals(that.abortIncompleteMultipartUpload) : that.abortIncompleteMultipartUpload != null) return false;
                if (this.expirationDate != null ? !this.expirationDate.equals(that.expirationDate) : that.expirationDate != null) return false;
                if (this.expirationInDays != null ? !this.expirationInDays.equals(that.expirationInDays) : that.expirationInDays != null) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                if (this.noncurrentVersionExpirationInDays != null ? !this.noncurrentVersionExpirationInDays.equals(that.noncurrentVersionExpirationInDays) : that.noncurrentVersionExpirationInDays != null) return false;
                if (this.noncurrentVersionTransition != null ? !this.noncurrentVersionTransition.equals(that.noncurrentVersionTransition) : that.noncurrentVersionTransition != null) return false;
                if (this.noncurrentVersionTransitions != null ? !this.noncurrentVersionTransitions.equals(that.noncurrentVersionTransitions) : that.noncurrentVersionTransitions != null) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                if (this.tagFilters != null ? !this.tagFilters.equals(that.tagFilters) : that.tagFilters != null) return false;
                if (this.transition != null ? !this.transition.equals(that.transition) : that.transition != null) return false;
                return this.transitions != null ? this.transitions.equals(that.transitions) : that.transitions == null;
            }

            @Override
            public int hashCode() {
                int result = this.status.hashCode();
                result = 31 * result + (this.abortIncompleteMultipartUpload != null ? this.abortIncompleteMultipartUpload.hashCode() : 0);
                result = 31 * result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
                result = 31 * result + (this.expirationInDays != null ? this.expirationInDays.hashCode() : 0);
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.noncurrentVersionExpirationInDays != null ? this.noncurrentVersionExpirationInDays.hashCode() : 0);
                result = 31 * result + (this.noncurrentVersionTransition != null ? this.noncurrentVersionTransition.hashCode() : 0);
                result = 31 * result + (this.noncurrentVersionTransitions != null ? this.noncurrentVersionTransitions.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.tagFilters != null ? this.tagFilters.hashCode() : 0);
                result = 31 * result + (this.transition != null ? this.transition.hashCode() : 0);
                result = 31 * result + (this.transitions != null ? this.transitions.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface S3KeyFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.S3KeyFilterProperty.Rules`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link S3KeyFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link S3KeyFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object rules;

            /**
             * Sets the value of Rules
             * @param rules `CfnBucket.S3KeyFilterProperty.Rules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder rules(software.amazon.awscdk.core.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of Rules
             * @param rules `CfnBucket.S3KeyFilterProperty.Rules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder rules(java.util.List<java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3KeyFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public S3KeyFilterProperty build() {
                return new Jsii$Proxy(rules);
            }

        }

        /**
         * An implementation for {@link S3KeyFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3KeyFilterProperty {
            private final java.lang.Object rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.rules = this.jsiiGet("rules", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object rules) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rules = java.util.Objects.requireNonNull(rules, "rules is required");
            }

            @Override
            public java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("rules", om.valueToTree(this.getRules()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3KeyFilterProperty.Jsii$Proxy that = (S3KeyFilterProperty.Jsii$Proxy) o;

                return this.rules.equals(that.rules);
            }

            @Override
            public int hashCode() {
                int result = this.rules.hashCode();
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ServerSideEncryptionByDefaultProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.ServerSideEncryptionByDefaultProperty.SSEAlgorithm`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSseAlgorithm();

        /**
         * `CfnBucket.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKmsMasterKeyId();

        /**
         * @return a {@link Builder} of {@link ServerSideEncryptionByDefaultProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ServerSideEncryptionByDefaultProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String sseAlgorithm;
            private java.lang.String kmsMasterKeyId;

            /**
             * Sets the value of SseAlgorithm
             * @param sseAlgorithm `CfnBucket.ServerSideEncryptionByDefaultProperty.SSEAlgorithm`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sseAlgorithm(java.lang.String sseAlgorithm) {
                this.sseAlgorithm = sseAlgorithm;
                return this;
            }

            /**
             * Sets the value of KmsMasterKeyId
             * @param kmsMasterKeyId `CfnBucket.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kmsMasterKeyId(java.lang.String kmsMasterKeyId) {
                this.kmsMasterKeyId = kmsMasterKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerSideEncryptionByDefaultProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ServerSideEncryptionByDefaultProperty build() {
                return new Jsii$Proxy(sseAlgorithm, kmsMasterKeyId);
            }

        }

        /**
         * An implementation for {@link ServerSideEncryptionByDefaultProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerSideEncryptionByDefaultProperty {
            private final java.lang.String sseAlgorithm;
            private final java.lang.String kmsMasterKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.sseAlgorithm = this.jsiiGet("sseAlgorithm", java.lang.String.class);
                this.kmsMasterKeyId = this.jsiiGet("kmsMasterKeyId", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String sseAlgorithm, java.lang.String kmsMasterKeyId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sseAlgorithm = java.util.Objects.requireNonNull(sseAlgorithm, "sseAlgorithm is required");
                this.kmsMasterKeyId = kmsMasterKeyId;
            }

            @Override
            public java.lang.String getSseAlgorithm() {
                return this.sseAlgorithm;
            }

            @Override
            public java.lang.String getKmsMasterKeyId() {
                return this.kmsMasterKeyId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("sseAlgorithm", om.valueToTree(this.getSseAlgorithm()));
                if (this.getKmsMasterKeyId() != null) {
                    obj.set("kmsMasterKeyId", om.valueToTree(this.getKmsMasterKeyId()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerSideEncryptionByDefaultProperty.Jsii$Proxy that = (ServerSideEncryptionByDefaultProperty.Jsii$Proxy) o;

                if (!sseAlgorithm.equals(that.sseAlgorithm)) return false;
                return this.kmsMasterKeyId != null ? this.kmsMasterKeyId.equals(that.kmsMasterKeyId) : that.kmsMasterKeyId == null;
            }

            @Override
            public int hashCode() {
                int result = this.sseAlgorithm.hashCode();
                result = 31 * result + (this.kmsMasterKeyId != null ? this.kmsMasterKeyId.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ServerSideEncryptionRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getServerSideEncryptionByDefault();

        /**
         * @return a {@link Builder} of {@link ServerSideEncryptionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ServerSideEncryptionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object serverSideEncryptionByDefault;

            /**
             * Sets the value of ServerSideEncryptionByDefault
             * @param serverSideEncryptionByDefault `CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder serverSideEncryptionByDefault(software.amazon.awscdk.core.IResolvable serverSideEncryptionByDefault) {
                this.serverSideEncryptionByDefault = serverSideEncryptionByDefault;
                return this;
            }

            /**
             * Sets the value of ServerSideEncryptionByDefault
             * @param serverSideEncryptionByDefault `CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder serverSideEncryptionByDefault(software.amazon.awscdk.services.s3.CfnBucket.ServerSideEncryptionByDefaultProperty serverSideEncryptionByDefault) {
                this.serverSideEncryptionByDefault = serverSideEncryptionByDefault;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerSideEncryptionRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ServerSideEncryptionRuleProperty build() {
                return new Jsii$Proxy(serverSideEncryptionByDefault);
            }

        }

        /**
         * An implementation for {@link ServerSideEncryptionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerSideEncryptionRuleProperty {
            private final java.lang.Object serverSideEncryptionByDefault;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.serverSideEncryptionByDefault = this.jsiiGet("serverSideEncryptionByDefault", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object serverSideEncryptionByDefault) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.serverSideEncryptionByDefault = serverSideEncryptionByDefault;
            }

            @Override
            public java.lang.Object getServerSideEncryptionByDefault() {
                return this.serverSideEncryptionByDefault;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getServerSideEncryptionByDefault() != null) {
                    obj.set("serverSideEncryptionByDefault", om.valueToTree(this.getServerSideEncryptionByDefault()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerSideEncryptionRuleProperty.Jsii$Proxy that = (ServerSideEncryptionRuleProperty.Jsii$Proxy) o;

                return this.serverSideEncryptionByDefault != null ? this.serverSideEncryptionByDefault.equals(that.serverSideEncryptionByDefault) : that.serverSideEncryptionByDefault == null;
            }

            @Override
            public int hashCode() {
                int result = this.serverSideEncryptionByDefault != null ? this.serverSideEncryptionByDefault.hashCode() : 0;
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SourceSelectionCriteriaProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSseKmsEncryptedObjects();

        /**
         * @return a {@link Builder} of {@link SourceSelectionCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SourceSelectionCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object sseKmsEncryptedObjects;

            /**
             * Sets the value of SseKmsEncryptedObjects
             * @param sseKmsEncryptedObjects `CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sseKmsEncryptedObjects(software.amazon.awscdk.core.IResolvable sseKmsEncryptedObjects) {
                this.sseKmsEncryptedObjects = sseKmsEncryptedObjects;
                return this;
            }

            /**
             * Sets the value of SseKmsEncryptedObjects
             * @param sseKmsEncryptedObjects `CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sseKmsEncryptedObjects(software.amazon.awscdk.services.s3.CfnBucket.SseKmsEncryptedObjectsProperty sseKmsEncryptedObjects) {
                this.sseKmsEncryptedObjects = sseKmsEncryptedObjects;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceSelectionCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SourceSelectionCriteriaProperty build() {
                return new Jsii$Proxy(sseKmsEncryptedObjects);
            }

        }

        /**
         * An implementation for {@link SourceSelectionCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceSelectionCriteriaProperty {
            private final java.lang.Object sseKmsEncryptedObjects;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.sseKmsEncryptedObjects = this.jsiiGet("sseKmsEncryptedObjects", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object sseKmsEncryptedObjects) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sseKmsEncryptedObjects = java.util.Objects.requireNonNull(sseKmsEncryptedObjects, "sseKmsEncryptedObjects is required");
            }

            @Override
            public java.lang.Object getSseKmsEncryptedObjects() {
                return this.sseKmsEncryptedObjects;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("sseKmsEncryptedObjects", om.valueToTree(this.getSseKmsEncryptedObjects()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceSelectionCriteriaProperty.Jsii$Proxy that = (SourceSelectionCriteriaProperty.Jsii$Proxy) o;

                return this.sseKmsEncryptedObjects.equals(that.sseKmsEncryptedObjects);
            }

            @Override
            public int hashCode() {
                int result = this.sseKmsEncryptedObjects.hashCode();
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SseKmsEncryptedObjectsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.SseKmsEncryptedObjectsProperty.Status`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStatus();

        /**
         * @return a {@link Builder} of {@link SseKmsEncryptedObjectsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SseKmsEncryptedObjectsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String status;

            /**
             * Sets the value of Status
             * @param status `CfnBucket.SseKmsEncryptedObjectsProperty.Status`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SseKmsEncryptedObjectsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SseKmsEncryptedObjectsProperty build() {
                return new Jsii$Proxy(status);
            }

        }

        /**
         * An implementation for {@link SseKmsEncryptedObjectsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SseKmsEncryptedObjectsProperty {
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.status = this.jsiiGet("status", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String status) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(status, "status is required");
            }

            @Override
            public java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("status", om.valueToTree(this.getStatus()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SseKmsEncryptedObjectsProperty.Jsii$Proxy that = (SseKmsEncryptedObjectsProperty.Jsii$Proxy) o;

                return this.status.equals(that.status);
            }

            @Override
            public int hashCode() {
                int result = this.status.hashCode();
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface StorageClassAnalysisProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.StorageClassAnalysisProperty.DataExport`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getDataExport();

        /**
         * @return a {@link Builder} of {@link StorageClassAnalysisProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link StorageClassAnalysisProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object dataExport;

            /**
             * Sets the value of DataExport
             * @param dataExport `CfnBucket.StorageClassAnalysisProperty.DataExport`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder dataExport(software.amazon.awscdk.core.IResolvable dataExport) {
                this.dataExport = dataExport;
                return this;
            }

            /**
             * Sets the value of DataExport
             * @param dataExport `CfnBucket.StorageClassAnalysisProperty.DataExport`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder dataExport(software.amazon.awscdk.services.s3.CfnBucket.DataExportProperty dataExport) {
                this.dataExport = dataExport;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StorageClassAnalysisProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public StorageClassAnalysisProperty build() {
                return new Jsii$Proxy(dataExport);
            }

        }

        /**
         * An implementation for {@link StorageClassAnalysisProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StorageClassAnalysisProperty {
            private final java.lang.Object dataExport;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.dataExport = this.jsiiGet("dataExport", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object dataExport) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataExport = dataExport;
            }

            @Override
            public java.lang.Object getDataExport() {
                return this.dataExport;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getDataExport() != null) {
                    obj.set("dataExport", om.valueToTree(this.getDataExport()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StorageClassAnalysisProperty.Jsii$Proxy that = (StorageClassAnalysisProperty.Jsii$Proxy) o;

                return this.dataExport != null ? this.dataExport.equals(that.dataExport) : that.dataExport == null;
            }

            @Override
            public int hashCode() {
                int result = this.dataExport != null ? this.dataExport.hashCode() : 0;
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TagFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.TagFilterProperty.Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKey();

        /**
         * `CfnBucket.TagFilterProperty.Value`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String key;
            private java.lang.String value;

            /**
             * Sets the value of Key
             * @param key `CfnBucket.TagFilterProperty.Key`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of Value
             * @param value `CfnBucket.TagFilterProperty.Value`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TagFilterProperty build() {
                return new Jsii$Proxy(key, value);
            }

        }

        /**
         * An implementation for {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagFilterProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.key = this.jsiiGet("key", java.lang.String.class);
                this.value = this.jsiiGet("value", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String key, java.lang.String value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(key, "key is required");
                this.value = java.util.Objects.requireNonNull(value, "value is required");
            }

            @Override
            public java.lang.String getKey() {
                return this.key;
            }

            @Override
            public java.lang.String getValue() {
                return this.value;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("key", om.valueToTree(this.getKey()));
                obj.set("value", om.valueToTree(this.getValue()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagFilterProperty.Jsii$Proxy that = (TagFilterProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TopicConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.TopicConfigurationProperty.Event`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getEvent();

        /**
         * `CfnBucket.TopicConfigurationProperty.Topic`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getTopic();

        /**
         * `CfnBucket.TopicConfigurationProperty.Filter`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getFilter();

        /**
         * @return a {@link Builder} of {@link TopicConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TopicConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String event;
            private java.lang.String topic;
            private java.lang.Object filter;

            /**
             * Sets the value of Event
             * @param event `CfnBucket.TopicConfigurationProperty.Event`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder event(java.lang.String event) {
                this.event = event;
                return this;
            }

            /**
             * Sets the value of Topic
             * @param topic `CfnBucket.TopicConfigurationProperty.Topic`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder topic(java.lang.String topic) {
                this.topic = topic;
                return this;
            }

            /**
             * Sets the value of Filter
             * @param filter `CfnBucket.TopicConfigurationProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder filter(software.amazon.awscdk.core.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of Filter
             * @param filter `CfnBucket.TopicConfigurationProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder filter(software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TopicConfigurationProperty build() {
                return new Jsii$Proxy(event, topic, filter);
            }

        }

        /**
         * An implementation for {@link TopicConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicConfigurationProperty {
            private final java.lang.String event;
            private final java.lang.String topic;
            private final java.lang.Object filter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.event = this.jsiiGet("event", java.lang.String.class);
                this.topic = this.jsiiGet("topic", java.lang.String.class);
                this.filter = this.jsiiGet("filter", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String event, java.lang.String topic, java.lang.Object filter) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.event = java.util.Objects.requireNonNull(event, "event is required");
                this.topic = java.util.Objects.requireNonNull(topic, "topic is required");
                this.filter = filter;
            }

            @Override
            public java.lang.String getEvent() {
                return this.event;
            }

            @Override
            public java.lang.String getTopic() {
                return this.topic;
            }

            @Override
            public java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("event", om.valueToTree(this.getEvent()));
                obj.set("topic", om.valueToTree(this.getTopic()));
                if (this.getFilter() != null) {
                    obj.set("filter", om.valueToTree(this.getFilter()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicConfigurationProperty.Jsii$Proxy that = (TopicConfigurationProperty.Jsii$Proxy) o;

                if (!event.equals(that.event)) return false;
                if (!topic.equals(that.topic)) return false;
                return this.filter != null ? this.filter.equals(that.filter) : that.filter == null;
            }

            @Override
            public int hashCode() {
                int result = this.event.hashCode();
                result = 31 * result + (this.topic.hashCode());
                result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TransitionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.TransitionProperty.StorageClass`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStorageClass();

        /**
         * `CfnBucket.TransitionProperty.TransitionDate`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getTransitionDate();

        /**
         * `CfnBucket.TransitionProperty.TransitionInDays`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getTransitionInDays();

        /**
         * @return a {@link Builder} of {@link TransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String storageClass;
            private java.lang.Object transitionDate;
            private java.lang.Number transitionInDays;

            /**
             * Sets the value of StorageClass
             * @param storageClass `CfnBucket.TransitionProperty.StorageClass`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder storageClass(java.lang.String storageClass) {
                this.storageClass = storageClass;
                return this;
            }

            /**
             * Sets the value of TransitionDate
             * @param transitionDate `CfnBucket.TransitionProperty.TransitionDate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder transitionDate(java.time.Instant transitionDate) {
                this.transitionDate = transitionDate;
                return this;
            }

            /**
             * Sets the value of TransitionDate
             * @param transitionDate `CfnBucket.TransitionProperty.TransitionDate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder transitionDate(software.amazon.awscdk.core.IResolvable transitionDate) {
                this.transitionDate = transitionDate;
                return this;
            }

            /**
             * Sets the value of TransitionInDays
             * @param transitionInDays `CfnBucket.TransitionProperty.TransitionInDays`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder transitionInDays(java.lang.Number transitionInDays) {
                this.transitionInDays = transitionInDays;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TransitionProperty build() {
                return new Jsii$Proxy(storageClass, transitionDate, transitionInDays);
            }

        }

        /**
         * An implementation for {@link TransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransitionProperty {
            private final java.lang.String storageClass;
            private final java.lang.Object transitionDate;
            private final java.lang.Number transitionInDays;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.storageClass = this.jsiiGet("storageClass", java.lang.String.class);
                this.transitionDate = this.jsiiGet("transitionDate", java.lang.Object.class);
                this.transitionInDays = this.jsiiGet("transitionInDays", java.lang.Number.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String storageClass, java.lang.Object transitionDate, java.lang.Number transitionInDays) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.storageClass = java.util.Objects.requireNonNull(storageClass, "storageClass is required");
                this.transitionDate = transitionDate;
                this.transitionInDays = transitionInDays;
            }

            @Override
            public java.lang.String getStorageClass() {
                return this.storageClass;
            }

            @Override
            public java.lang.Object getTransitionDate() {
                return this.transitionDate;
            }

            @Override
            public java.lang.Number getTransitionInDays() {
                return this.transitionInDays;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("storageClass", om.valueToTree(this.getStorageClass()));
                if (this.getTransitionDate() != null) {
                    obj.set("transitionDate", om.valueToTree(this.getTransitionDate()));
                }
                if (this.getTransitionInDays() != null) {
                    obj.set("transitionInDays", om.valueToTree(this.getTransitionInDays()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TransitionProperty.Jsii$Proxy that = (TransitionProperty.Jsii$Proxy) o;

                if (!storageClass.equals(that.storageClass)) return false;
                if (this.transitionDate != null ? !this.transitionDate.equals(that.transitionDate) : that.transitionDate != null) return false;
                return this.transitionInDays != null ? this.transitionInDays.equals(that.transitionInDays) : that.transitionInDays == null;
            }

            @Override
            public int hashCode() {
                int result = this.storageClass.hashCode();
                result = 31 * result + (this.transitionDate != null ? this.transitionDate.hashCode() : 0);
                result = 31 * result + (this.transitionInDays != null ? this.transitionInDays.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface VersioningConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.VersioningConfigurationProperty.Status`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStatus();

        /**
         * @return a {@link Builder} of {@link VersioningConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link VersioningConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String status;

            /**
             * Sets the value of Status
             * @param status `CfnBucket.VersioningConfigurationProperty.Status`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VersioningConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public VersioningConfigurationProperty build() {
                return new Jsii$Proxy(status);
            }

        }

        /**
         * An implementation for {@link VersioningConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VersioningConfigurationProperty {
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.status = this.jsiiGet("status", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String status) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(status, "status is required");
            }

            @Override
            public java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("status", om.valueToTree(this.getStatus()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VersioningConfigurationProperty.Jsii$Proxy that = (VersioningConfigurationProperty.Jsii$Proxy) o;

                return this.status.equals(that.status);
            }

            @Override
            public int hashCode() {
                int result = this.status.hashCode();
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface WebsiteConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.WebsiteConfigurationProperty.ErrorDocument`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getErrorDocument();

        /**
         * `CfnBucket.WebsiteConfigurationProperty.IndexDocument`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getIndexDocument();

        /**
         * `CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRedirectAllRequestsTo();

        /**
         * `CfnBucket.WebsiteConfigurationProperty.RoutingRules`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRoutingRules();

        /**
         * @return a {@link Builder} of {@link WebsiteConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link WebsiteConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String errorDocument;
            private java.lang.String indexDocument;
            private java.lang.Object redirectAllRequestsTo;
            private java.lang.Object routingRules;

            /**
             * Sets the value of ErrorDocument
             * @param errorDocument `CfnBucket.WebsiteConfigurationProperty.ErrorDocument`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder errorDocument(java.lang.String errorDocument) {
                this.errorDocument = errorDocument;
                return this;
            }

            /**
             * Sets the value of IndexDocument
             * @param indexDocument `CfnBucket.WebsiteConfigurationProperty.IndexDocument`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder indexDocument(java.lang.String indexDocument) {
                this.indexDocument = indexDocument;
                return this;
            }

            /**
             * Sets the value of RedirectAllRequestsTo
             * @param redirectAllRequestsTo `CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder redirectAllRequestsTo(software.amazon.awscdk.core.IResolvable redirectAllRequestsTo) {
                this.redirectAllRequestsTo = redirectAllRequestsTo;
                return this;
            }

            /**
             * Sets the value of RedirectAllRequestsTo
             * @param redirectAllRequestsTo `CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder redirectAllRequestsTo(software.amazon.awscdk.services.s3.CfnBucket.RedirectAllRequestsToProperty redirectAllRequestsTo) {
                this.redirectAllRequestsTo = redirectAllRequestsTo;
                return this;
            }

            /**
             * Sets the value of RoutingRules
             * @param routingRules `CfnBucket.WebsiteConfigurationProperty.RoutingRules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder routingRules(software.amazon.awscdk.core.IResolvable routingRules) {
                this.routingRules = routingRules;
                return this;
            }

            /**
             * Sets the value of RoutingRules
             * @param routingRules `CfnBucket.WebsiteConfigurationProperty.RoutingRules`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder routingRules(java.util.List<java.lang.Object> routingRules) {
                this.routingRules = routingRules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebsiteConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public WebsiteConfigurationProperty build() {
                return new Jsii$Proxy(errorDocument, indexDocument, redirectAllRequestsTo, routingRules);
            }

        }

        /**
         * An implementation for {@link WebsiteConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebsiteConfigurationProperty {
            private final java.lang.String errorDocument;
            private final java.lang.String indexDocument;
            private final java.lang.Object redirectAllRequestsTo;
            private final java.lang.Object routingRules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.errorDocument = this.jsiiGet("errorDocument", java.lang.String.class);
                this.indexDocument = this.jsiiGet("indexDocument", java.lang.String.class);
                this.redirectAllRequestsTo = this.jsiiGet("redirectAllRequestsTo", java.lang.Object.class);
                this.routingRules = this.jsiiGet("routingRules", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String errorDocument, java.lang.String indexDocument, java.lang.Object redirectAllRequestsTo, java.lang.Object routingRules) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.errorDocument = errorDocument;
                this.indexDocument = indexDocument;
                this.redirectAllRequestsTo = redirectAllRequestsTo;
                this.routingRules = routingRules;
            }

            @Override
            public java.lang.String getErrorDocument() {
                return this.errorDocument;
            }

            @Override
            public java.lang.String getIndexDocument() {
                return this.indexDocument;
            }

            @Override
            public java.lang.Object getRedirectAllRequestsTo() {
                return this.redirectAllRequestsTo;
            }

            @Override
            public java.lang.Object getRoutingRules() {
                return this.routingRules;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getErrorDocument() != null) {
                    obj.set("errorDocument", om.valueToTree(this.getErrorDocument()));
                }
                if (this.getIndexDocument() != null) {
                    obj.set("indexDocument", om.valueToTree(this.getIndexDocument()));
                }
                if (this.getRedirectAllRequestsTo() != null) {
                    obj.set("redirectAllRequestsTo", om.valueToTree(this.getRedirectAllRequestsTo()));
                }
                if (this.getRoutingRules() != null) {
                    obj.set("routingRules", om.valueToTree(this.getRoutingRules()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WebsiteConfigurationProperty.Jsii$Proxy that = (WebsiteConfigurationProperty.Jsii$Proxy) o;

                if (this.errorDocument != null ? !this.errorDocument.equals(that.errorDocument) : that.errorDocument != null) return false;
                if (this.indexDocument != null ? !this.indexDocument.equals(that.indexDocument) : that.indexDocument != null) return false;
                if (this.redirectAllRequestsTo != null ? !this.redirectAllRequestsTo.equals(that.redirectAllRequestsTo) : that.redirectAllRequestsTo != null) return false;
                return this.routingRules != null ? this.routingRules.equals(that.routingRules) : that.routingRules == null;
            }

            @Override
            public int hashCode() {
                int result = this.errorDocument != null ? this.errorDocument.hashCode() : 0;
                result = 31 * result + (this.indexDocument != null ? this.indexDocument.hashCode() : 0);
                result = 31 * result + (this.redirectAllRequestsTo != null ? this.redirectAllRequestsTo.hashCode() : 0);
                result = 31 * result + (this.routingRules != null ? this.routingRules.hashCode() : 0);
                return result;
            }

        }
    }
}
