/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import java.util.List;
import software.amazon.awscdk.services.s3.CorsRule;
import software.amazon.awscdk.services.s3.HttpMethods;
import software.amazon.jsii.JsiiSerializable;

public interface CorsRule
extends JsiiSerializable {
    public List<HttpMethods> getAllowedMethods();

    public List<String> getAllowedOrigins();

    public List<String> getAllowedHeaders();

    public List<String> getExposedHeaders();

    public String getId();

    public Number getMaxAge();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<HttpMethods> allowedMethods;
        private List<String> allowedOrigins;
        private List<String> allowedHeaders;
        private List<String> exposedHeaders;
        private String id;
        private Number maxAge;

        public Builder allowedMethods(List<HttpMethods> allowedMethods) {
            this.allowedMethods = allowedMethods;
            return this;
        }

        public Builder allowedOrigins(List<String> allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
            return this;
        }

        public Builder allowedHeaders(List<String> allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
            return this;
        }

        public Builder exposedHeaders(List<String> exposedHeaders) {
            this.exposedHeaders = exposedHeaders;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder maxAge(Number maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public CorsRule build() {
            return new Jsii.Proxy(this.allowedMethods, this.allowedOrigins, this.allowedHeaders, this.exposedHeaders, this.id, this.maxAge, null);
        }
    }
}

