package software.amazon.awscdk.services.s3;

/**
 * Specifies the inventory configuration of an S3 Bucket.
 * <p>
 * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2021-01-27T11:16:42.219Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.Inventory")
@software.amazon.jsii.Jsii.Proxy(Inventory.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Inventory extends software.amazon.jsii.JsiiSerializable {

    /**
     * The destination of the inventory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.InventoryDestination getDestination();

    /**
     * Whether the inventory is enabled or disabled.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * The format of the inventory.
     * <p>
     * Default: InventoryFormat.CSV
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.InventoryFormat getFormat() {
        return null;
    }

    /**
     * Frequency at which the inventory should be generated.
     * <p>
     * Default: InventoryFrequency.WEEKLY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.InventoryFrequency getFrequency() {
        return null;
    }

    /**
     * If the inventory should contain all the object versions or only the current one.
     * <p>
     * Default: InventoryObjectVersion.ALL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.InventoryObjectVersion getIncludeObjectVersions() {
        return null;
    }

    /**
     * The inventory configuration ID.
     * <p>
     * Default: - generated ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInventoryId() {
        return null;
    }

    /**
     * The inventory will only include objects that meet the prefix filter criteria.
     * <p>
     * Default: - No objects prefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getObjectsPrefix() {
        return null;
    }

    /**
     * A list of optional fields to be included in the inventory result.
     * <p>
     * Default: - No optional fields.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOptionalFields() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Inventory}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Inventory}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<Inventory> {
        private software.amazon.awscdk.services.s3.InventoryDestination destination;
        private java.lang.Boolean enabled;
        private software.amazon.awscdk.services.s3.InventoryFormat format;
        private software.amazon.awscdk.services.s3.InventoryFrequency frequency;
        private software.amazon.awscdk.services.s3.InventoryObjectVersion includeObjectVersions;
        private java.lang.String inventoryId;
        private java.lang.String objectsPrefix;
        private java.util.List<java.lang.String> optionalFields;

        /**
         * Sets the value of {@link Inventory#getDestination}
         * @param destination The destination of the inventory. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(software.amazon.awscdk.services.s3.InventoryDestination destination) {
            this.destination = destination;
            return this;
        }

        /**
         * Sets the value of {@link Inventory#getEnabled}
         * @param enabled Whether the inventory is enabled or disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link Inventory#getFormat}
         * @param format The format of the inventory.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder format(software.amazon.awscdk.services.s3.InventoryFormat format) {
            this.format = format;
            return this;
        }

        /**
         * Sets the value of {@link Inventory#getFrequency}
         * @param frequency Frequency at which the inventory should be generated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder frequency(software.amazon.awscdk.services.s3.InventoryFrequency frequency) {
            this.frequency = frequency;
            return this;
        }

        /**
         * Sets the value of {@link Inventory#getIncludeObjectVersions}
         * @param includeObjectVersions If the inventory should contain all the object versions or only the current one.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeObjectVersions(software.amazon.awscdk.services.s3.InventoryObjectVersion includeObjectVersions) {
            this.includeObjectVersions = includeObjectVersions;
            return this;
        }

        /**
         * Sets the value of {@link Inventory#getInventoryId}
         * @param inventoryId The inventory configuration ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inventoryId(java.lang.String inventoryId) {
            this.inventoryId = inventoryId;
            return this;
        }

        /**
         * Sets the value of {@link Inventory#getObjectsPrefix}
         * @param objectsPrefix The inventory will only include objects that meet the prefix filter criteria.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectsPrefix(java.lang.String objectsPrefix) {
            this.objectsPrefix = objectsPrefix;
            return this;
        }

        /**
         * Sets the value of {@link Inventory#getOptionalFields}
         * @param optionalFields A list of optional fields to be included in the inventory result.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionalFields(java.util.List<java.lang.String> optionalFields) {
            this.optionalFields = optionalFields;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Inventory}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public Inventory build() {
            return new Jsii$Proxy(destination, enabled, format, frequency, includeObjectVersions, inventoryId, objectsPrefix, optionalFields);
        }
    }

    /**
     * An implementation for {@link Inventory}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Inventory {
        private final software.amazon.awscdk.services.s3.InventoryDestination destination;
        private final java.lang.Boolean enabled;
        private final software.amazon.awscdk.services.s3.InventoryFormat format;
        private final software.amazon.awscdk.services.s3.InventoryFrequency frequency;
        private final software.amazon.awscdk.services.s3.InventoryObjectVersion includeObjectVersions;
        private final java.lang.String inventoryId;
        private final java.lang.String objectsPrefix;
        private final java.util.List<java.lang.String> optionalFields;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.InventoryDestination.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.InventoryFormat.class));
            this.frequency = software.amazon.jsii.Kernel.get(this, "frequency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.InventoryFrequency.class));
            this.includeObjectVersions = software.amazon.jsii.Kernel.get(this, "includeObjectVersions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.InventoryObjectVersion.class));
            this.inventoryId = software.amazon.jsii.Kernel.get(this, "inventoryId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.objectsPrefix = software.amazon.jsii.Kernel.get(this, "objectsPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.optionalFields = software.amazon.jsii.Kernel.get(this, "optionalFields", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.s3.InventoryDestination destination, final java.lang.Boolean enabled, final software.amazon.awscdk.services.s3.InventoryFormat format, final software.amazon.awscdk.services.s3.InventoryFrequency frequency, final software.amazon.awscdk.services.s3.InventoryObjectVersion includeObjectVersions, final java.lang.String inventoryId, final java.lang.String objectsPrefix, final java.util.List<java.lang.String> optionalFields) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destination = java.util.Objects.requireNonNull(destination, "destination is required");
            this.enabled = enabled;
            this.format = format;
            this.frequency = frequency;
            this.includeObjectVersions = includeObjectVersions;
            this.inventoryId = inventoryId;
            this.objectsPrefix = objectsPrefix;
            this.optionalFields = optionalFields;
        }

        @Override
        public final software.amazon.awscdk.services.s3.InventoryDestination getDestination() {
            return this.destination;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final software.amazon.awscdk.services.s3.InventoryFormat getFormat() {
            return this.format;
        }

        @Override
        public final software.amazon.awscdk.services.s3.InventoryFrequency getFrequency() {
            return this.frequency;
        }

        @Override
        public final software.amazon.awscdk.services.s3.InventoryObjectVersion getIncludeObjectVersions() {
            return this.includeObjectVersions;
        }

        @Override
        public final java.lang.String getInventoryId() {
            return this.inventoryId;
        }

        @Override
        public final java.lang.String getObjectsPrefix() {
            return this.objectsPrefix;
        }

        @Override
        public final java.util.List<java.lang.String> getOptionalFields() {
            return this.optionalFields;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destination", om.valueToTree(this.getDestination()));
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getFormat() != null) {
                data.set("format", om.valueToTree(this.getFormat()));
            }
            if (this.getFrequency() != null) {
                data.set("frequency", om.valueToTree(this.getFrequency()));
            }
            if (this.getIncludeObjectVersions() != null) {
                data.set("includeObjectVersions", om.valueToTree(this.getIncludeObjectVersions()));
            }
            if (this.getInventoryId() != null) {
                data.set("inventoryId", om.valueToTree(this.getInventoryId()));
            }
            if (this.getObjectsPrefix() != null) {
                data.set("objectsPrefix", om.valueToTree(this.getObjectsPrefix()));
            }
            if (this.getOptionalFields() != null) {
                data.set("optionalFields", om.valueToTree(this.getOptionalFields()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.Inventory"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Inventory.Jsii$Proxy that = (Inventory.Jsii$Proxy) o;

            if (!destination.equals(that.destination)) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.format != null ? !this.format.equals(that.format) : that.format != null) return false;
            if (this.frequency != null ? !this.frequency.equals(that.frequency) : that.frequency != null) return false;
            if (this.includeObjectVersions != null ? !this.includeObjectVersions.equals(that.includeObjectVersions) : that.includeObjectVersions != null) return false;
            if (this.inventoryId != null ? !this.inventoryId.equals(that.inventoryId) : that.inventoryId != null) return false;
            if (this.objectsPrefix != null ? !this.objectsPrefix.equals(that.objectsPrefix) : that.objectsPrefix != null) return false;
            return this.optionalFields != null ? this.optionalFields.equals(that.optionalFields) : that.optionalFields == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destination.hashCode();
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
            result = 31 * result + (this.frequency != null ? this.frequency.hashCode() : 0);
            result = 31 * result + (this.includeObjectVersions != null ? this.includeObjectVersions.hashCode() : 0);
            result = 31 * result + (this.inventoryId != null ? this.inventoryId.hashCode() : 0);
            result = 31 * result + (this.objectsPrefix != null ? this.objectsPrefix.hashCode() : 0);
            result = 31 * result + (this.optionalFields != null ? this.optionalFields.hashCode() : 0);
            return result;
        }
    }
}
