package software.amazon.awscdk.services.sagemaker.cloudformation;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-12-04T12:17:32.542Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.cloudformation.EndpointConfigResource")
public class EndpointConfigResource extends software.amazon.awscdk.Resource {
    protected EndpointConfigResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.cloudformation.EndpointConfigResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::SageMaker::EndpointConfig``.
     * @param parent the ``cdk.Construct`` this ``EndpointConfigResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``EndpointConfigResource``
     */
    public EndpointConfigResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.sagemaker.cloudformation.EndpointConfigResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getEndpointConfigArn() {
        return this.jsiiGet("endpointConfigArn", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute EndpointConfigName
     */
    public java.lang.String getEndpointConfigName() {
        return this.jsiiGet("endpointConfigName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.sagemaker.cloudformation.EndpointConfigResourceProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.sagemaker.cloudformation.EndpointConfigResourceProps.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html
     */
    public static interface ProductionVariantProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``EndpointConfigResource.ProductionVariantProperty.InitialInstanceCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialinstancecount
         */
        java.lang.Object getInitialInstanceCount();
        /**
         * ``EndpointConfigResource.ProductionVariantProperty.InitialInstanceCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialinstancecount
         */
        void setInitialInstanceCount(final java.lang.Number value);
        /**
         * ``EndpointConfigResource.ProductionVariantProperty.InitialInstanceCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialinstancecount
         */
        void setInitialInstanceCount(final software.amazon.awscdk.Token value);
        /**
         * ``EndpointConfigResource.ProductionVariantProperty.InitialVariantWeight``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialvariantweight
         */
        java.lang.Object getInitialVariantWeight();
        /**
         * ``EndpointConfigResource.ProductionVariantProperty.InitialVariantWeight``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialvariantweight
         */
        void setInitialVariantWeight(final java.lang.Number value);
        /**
         * ``EndpointConfigResource.ProductionVariantProperty.InitialVariantWeight``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialvariantweight
         */
        void setInitialVariantWeight(final software.amazon.awscdk.Token value);
        /**
         * ``EndpointConfigResource.ProductionVariantProperty.InstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-instancetype
         */
        java.lang.Object getInstanceType();
        /**
         * ``EndpointConfigResource.ProductionVariantProperty.InstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-instancetype
         */
        void setInstanceType(final java.lang.String value);
        /**
         * ``EndpointConfigResource.ProductionVariantProperty.InstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-instancetype
         */
        void setInstanceType(final software.amazon.awscdk.Token value);
        /**
         * ``EndpointConfigResource.ProductionVariantProperty.ModelName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modelname
         */
        java.lang.Object getModelName();
        /**
         * ``EndpointConfigResource.ProductionVariantProperty.ModelName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modelname
         */
        void setModelName(final java.lang.String value);
        /**
         * ``EndpointConfigResource.ProductionVariantProperty.ModelName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modelname
         */
        void setModelName(final software.amazon.awscdk.Token value);
        /**
         * ``EndpointConfigResource.ProductionVariantProperty.VariantName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-variantname
         */
        java.lang.Object getVariantName();
        /**
         * ``EndpointConfigResource.ProductionVariantProperty.VariantName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-variantname
         */
        void setVariantName(final java.lang.String value);
        /**
         * ``EndpointConfigResource.ProductionVariantProperty.VariantName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-variantname
         */
        void setVariantName(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link ProductionVariantProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ProductionVariantProperty}
         */
        final class Builder {
            private java.lang.Object _initialInstanceCount;
            private java.lang.Object _initialVariantWeight;
            private java.lang.Object _instanceType;
            private java.lang.Object _modelName;
            private java.lang.Object _variantName;

            /**
             * Sets the value of InitialInstanceCount
             * @param value ``EndpointConfigResource.ProductionVariantProperty.InitialInstanceCount``
             * @return {@code this}
             */
            public Builder withInitialInstanceCount(final java.lang.Number value) {
                this._initialInstanceCount = java.util.Objects.requireNonNull(value, "initialInstanceCount is required");
                return this;
            }
            /**
             * Sets the value of InitialInstanceCount
             * @param value ``EndpointConfigResource.ProductionVariantProperty.InitialInstanceCount``
             * @return {@code this}
             */
            public Builder withInitialInstanceCount(final software.amazon.awscdk.Token value) {
                this._initialInstanceCount = java.util.Objects.requireNonNull(value, "initialInstanceCount is required");
                return this;
            }
            /**
             * Sets the value of InitialVariantWeight
             * @param value ``EndpointConfigResource.ProductionVariantProperty.InitialVariantWeight``
             * @return {@code this}
             */
            public Builder withInitialVariantWeight(final java.lang.Number value) {
                this._initialVariantWeight = java.util.Objects.requireNonNull(value, "initialVariantWeight is required");
                return this;
            }
            /**
             * Sets the value of InitialVariantWeight
             * @param value ``EndpointConfigResource.ProductionVariantProperty.InitialVariantWeight``
             * @return {@code this}
             */
            public Builder withInitialVariantWeight(final software.amazon.awscdk.Token value) {
                this._initialVariantWeight = java.util.Objects.requireNonNull(value, "initialVariantWeight is required");
                return this;
            }
            /**
             * Sets the value of InstanceType
             * @param value ``EndpointConfigResource.ProductionVariantProperty.InstanceType``
             * @return {@code this}
             */
            public Builder withInstanceType(final java.lang.String value) {
                this._instanceType = java.util.Objects.requireNonNull(value, "instanceType is required");
                return this;
            }
            /**
             * Sets the value of InstanceType
             * @param value ``EndpointConfigResource.ProductionVariantProperty.InstanceType``
             * @return {@code this}
             */
            public Builder withInstanceType(final software.amazon.awscdk.Token value) {
                this._instanceType = java.util.Objects.requireNonNull(value, "instanceType is required");
                return this;
            }
            /**
             * Sets the value of ModelName
             * @param value ``EndpointConfigResource.ProductionVariantProperty.ModelName``
             * @return {@code this}
             */
            public Builder withModelName(final java.lang.String value) {
                this._modelName = java.util.Objects.requireNonNull(value, "modelName is required");
                return this;
            }
            /**
             * Sets the value of ModelName
             * @param value ``EndpointConfigResource.ProductionVariantProperty.ModelName``
             * @return {@code this}
             */
            public Builder withModelName(final software.amazon.awscdk.Token value) {
                this._modelName = java.util.Objects.requireNonNull(value, "modelName is required");
                return this;
            }
            /**
             * Sets the value of VariantName
             * @param value ``EndpointConfigResource.ProductionVariantProperty.VariantName``
             * @return {@code this}
             */
            public Builder withVariantName(final java.lang.String value) {
                this._variantName = java.util.Objects.requireNonNull(value, "variantName is required");
                return this;
            }
            /**
             * Sets the value of VariantName
             * @param value ``EndpointConfigResource.ProductionVariantProperty.VariantName``
             * @return {@code this}
             */
            public Builder withVariantName(final software.amazon.awscdk.Token value) {
                this._variantName = java.util.Objects.requireNonNull(value, "variantName is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProductionVariantProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ProductionVariantProperty build() {
                return new ProductionVariantProperty() {
                    private java.lang.Object $initialInstanceCount = java.util.Objects.requireNonNull(_initialInstanceCount, "initialInstanceCount is required");
                    private java.lang.Object $initialVariantWeight = java.util.Objects.requireNonNull(_initialVariantWeight, "initialVariantWeight is required");
                    private java.lang.Object $instanceType = java.util.Objects.requireNonNull(_instanceType, "instanceType is required");
                    private java.lang.Object $modelName = java.util.Objects.requireNonNull(_modelName, "modelName is required");
                    private java.lang.Object $variantName = java.util.Objects.requireNonNull(_variantName, "variantName is required");

                    @Override
                    public java.lang.Object getInitialInstanceCount() {
                        return this.$initialInstanceCount;
                    }

                    @Override
                    public void setInitialInstanceCount(final java.lang.Number value) {
                        this.$initialInstanceCount = java.util.Objects.requireNonNull(value, "initialInstanceCount is required");
                    }

                    @Override
                    public void setInitialInstanceCount(final software.amazon.awscdk.Token value) {
                        this.$initialInstanceCount = java.util.Objects.requireNonNull(value, "initialInstanceCount is required");
                    }

                    @Override
                    public java.lang.Object getInitialVariantWeight() {
                        return this.$initialVariantWeight;
                    }

                    @Override
                    public void setInitialVariantWeight(final java.lang.Number value) {
                        this.$initialVariantWeight = java.util.Objects.requireNonNull(value, "initialVariantWeight is required");
                    }

                    @Override
                    public void setInitialVariantWeight(final software.amazon.awscdk.Token value) {
                        this.$initialVariantWeight = java.util.Objects.requireNonNull(value, "initialVariantWeight is required");
                    }

                    @Override
                    public java.lang.Object getInstanceType() {
                        return this.$instanceType;
                    }

                    @Override
                    public void setInstanceType(final java.lang.String value) {
                        this.$instanceType = java.util.Objects.requireNonNull(value, "instanceType is required");
                    }

                    @Override
                    public void setInstanceType(final software.amazon.awscdk.Token value) {
                        this.$instanceType = java.util.Objects.requireNonNull(value, "instanceType is required");
                    }

                    @Override
                    public java.lang.Object getModelName() {
                        return this.$modelName;
                    }

                    @Override
                    public void setModelName(final java.lang.String value) {
                        this.$modelName = java.util.Objects.requireNonNull(value, "modelName is required");
                    }

                    @Override
                    public void setModelName(final software.amazon.awscdk.Token value) {
                        this.$modelName = java.util.Objects.requireNonNull(value, "modelName is required");
                    }

                    @Override
                    public java.lang.Object getVariantName() {
                        return this.$variantName;
                    }

                    @Override
                    public void setVariantName(final java.lang.String value) {
                        this.$variantName = java.util.Objects.requireNonNull(value, "variantName is required");
                    }

                    @Override
                    public void setVariantName(final software.amazon.awscdk.Token value) {
                        this.$variantName = java.util.Objects.requireNonNull(value, "variantName is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sagemaker.cloudformation.EndpointConfigResource.ProductionVariantProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``EndpointConfigResource.ProductionVariantProperty.InitialInstanceCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialinstancecount
             */
            @Override
            public java.lang.Object getInitialInstanceCount() {
                return this.jsiiGet("initialInstanceCount", java.lang.Object.class);
            }

            /**
             * ``EndpointConfigResource.ProductionVariantProperty.InitialInstanceCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialinstancecount
             */
            @Override
            public void setInitialInstanceCount(final java.lang.Number value) {
                this.jsiiSet("initialInstanceCount", java.util.Objects.requireNonNull(value, "initialInstanceCount is required"));
            }

            /**
             * ``EndpointConfigResource.ProductionVariantProperty.InitialInstanceCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialinstancecount
             */
            @Override
            public void setInitialInstanceCount(final software.amazon.awscdk.Token value) {
                this.jsiiSet("initialInstanceCount", java.util.Objects.requireNonNull(value, "initialInstanceCount is required"));
            }

            /**
             * ``EndpointConfigResource.ProductionVariantProperty.InitialVariantWeight``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialvariantweight
             */
            @Override
            public java.lang.Object getInitialVariantWeight() {
                return this.jsiiGet("initialVariantWeight", java.lang.Object.class);
            }

            /**
             * ``EndpointConfigResource.ProductionVariantProperty.InitialVariantWeight``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialvariantweight
             */
            @Override
            public void setInitialVariantWeight(final java.lang.Number value) {
                this.jsiiSet("initialVariantWeight", java.util.Objects.requireNonNull(value, "initialVariantWeight is required"));
            }

            /**
             * ``EndpointConfigResource.ProductionVariantProperty.InitialVariantWeight``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialvariantweight
             */
            @Override
            public void setInitialVariantWeight(final software.amazon.awscdk.Token value) {
                this.jsiiSet("initialVariantWeight", java.util.Objects.requireNonNull(value, "initialVariantWeight is required"));
            }

            /**
             * ``EndpointConfigResource.ProductionVariantProperty.InstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-instancetype
             */
            @Override
            public java.lang.Object getInstanceType() {
                return this.jsiiGet("instanceType", java.lang.Object.class);
            }

            /**
             * ``EndpointConfigResource.ProductionVariantProperty.InstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-instancetype
             */
            @Override
            public void setInstanceType(final java.lang.String value) {
                this.jsiiSet("instanceType", java.util.Objects.requireNonNull(value, "instanceType is required"));
            }

            /**
             * ``EndpointConfigResource.ProductionVariantProperty.InstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-instancetype
             */
            @Override
            public void setInstanceType(final software.amazon.awscdk.Token value) {
                this.jsiiSet("instanceType", java.util.Objects.requireNonNull(value, "instanceType is required"));
            }

            /**
             * ``EndpointConfigResource.ProductionVariantProperty.ModelName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modelname
             */
            @Override
            public java.lang.Object getModelName() {
                return this.jsiiGet("modelName", java.lang.Object.class);
            }

            /**
             * ``EndpointConfigResource.ProductionVariantProperty.ModelName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modelname
             */
            @Override
            public void setModelName(final java.lang.String value) {
                this.jsiiSet("modelName", java.util.Objects.requireNonNull(value, "modelName is required"));
            }

            /**
             * ``EndpointConfigResource.ProductionVariantProperty.ModelName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modelname
             */
            @Override
            public void setModelName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("modelName", java.util.Objects.requireNonNull(value, "modelName is required"));
            }

            /**
             * ``EndpointConfigResource.ProductionVariantProperty.VariantName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-variantname
             */
            @Override
            public java.lang.Object getVariantName() {
                return this.jsiiGet("variantName", java.lang.Object.class);
            }

            /**
             * ``EndpointConfigResource.ProductionVariantProperty.VariantName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-variantname
             */
            @Override
            public void setVariantName(final java.lang.String value) {
                this.jsiiSet("variantName", java.util.Objects.requireNonNull(value, "variantName is required"));
            }

            /**
             * ``EndpointConfigResource.ProductionVariantProperty.VariantName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-variantname
             */
            @Override
            public void setVariantName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("variantName", java.util.Objects.requireNonNull(value, "variantName is required"));
            }
        }
    }
}
