package software.amazon.awscdk.services.sagemaker;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.12 (build 82990c5)", date = "2018-12-20T13:28:27.675Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModel")
public class CfnModel extends software.amazon.awscdk.Resource {
    protected CfnModel(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnModel.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::SageMaker::Model``.
     * @param parent the ``cdk.Construct`` this ``CfnModel`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``CfnModel``
     */
    public CfnModel(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.sagemaker.CfnModelProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getModelArn() {
        return this.jsiiGet("modelArn", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute ModelName
     */
    public java.lang.String getModelName() {
        return this.jsiiGet("modelName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.sagemaker.CfnModelProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.sagemaker.CfnModelProps.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html
     */
    public static interface ContainerDefinitionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnModel.ContainerDefinitionProperty.Image``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-image
         */
        java.lang.Object getImage();
        /**
         * ``CfnModel.ContainerDefinitionProperty.Image``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-image
         */
        void setImage(final java.lang.String value);
        /**
         * ``CfnModel.ContainerDefinitionProperty.Image``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-image
         */
        void setImage(final software.amazon.awscdk.Token value);
        /**
         * ``CfnModel.ContainerDefinitionProperty.ContainerHostname``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-containerhostname
         */
        java.lang.Object getContainerHostname();
        /**
         * ``CfnModel.ContainerDefinitionProperty.ContainerHostname``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-containerhostname
         */
        void setContainerHostname(final java.lang.String value);
        /**
         * ``CfnModel.ContainerDefinitionProperty.ContainerHostname``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-containerhostname
         */
        void setContainerHostname(final software.amazon.awscdk.Token value);
        /**
         * ``CfnModel.ContainerDefinitionProperty.Environment``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-environment
         */
        java.lang.Object getEnvironment();
        /**
         * ``CfnModel.ContainerDefinitionProperty.Environment``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-environment
         */
        void setEnvironment(final com.fasterxml.jackson.databind.node.ObjectNode value);
        /**
         * ``CfnModel.ContainerDefinitionProperty.Environment``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-environment
         */
        void setEnvironment(final software.amazon.awscdk.Token value);
        /**
         * ``CfnModel.ContainerDefinitionProperty.ModelDataUrl``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-modeldataurl
         */
        java.lang.Object getModelDataUrl();
        /**
         * ``CfnModel.ContainerDefinitionProperty.ModelDataUrl``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-modeldataurl
         */
        void setModelDataUrl(final java.lang.String value);
        /**
         * ``CfnModel.ContainerDefinitionProperty.ModelDataUrl``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-modeldataurl
         */
        void setModelDataUrl(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link ContainerDefinitionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ContainerDefinitionProperty}
         */
        final class Builder {
            private java.lang.Object _image;
            @javax.annotation.Nullable
            private java.lang.Object _containerHostname;
            @javax.annotation.Nullable
            private java.lang.Object _environment;
            @javax.annotation.Nullable
            private java.lang.Object _modelDataUrl;

            /**
             * Sets the value of Image
             * @param value ``CfnModel.ContainerDefinitionProperty.Image``
             * @return {@code this}
             */
            public Builder withImage(final java.lang.String value) {
                this._image = java.util.Objects.requireNonNull(value, "image is required");
                return this;
            }
            /**
             * Sets the value of Image
             * @param value ``CfnModel.ContainerDefinitionProperty.Image``
             * @return {@code this}
             */
            public Builder withImage(final software.amazon.awscdk.Token value) {
                this._image = java.util.Objects.requireNonNull(value, "image is required");
                return this;
            }
            /**
             * Sets the value of ContainerHostname
             * @param value ``CfnModel.ContainerDefinitionProperty.ContainerHostname``
             * @return {@code this}
             */
            public Builder withContainerHostname(@javax.annotation.Nullable final java.lang.String value) {
                this._containerHostname = value;
                return this;
            }
            /**
             * Sets the value of ContainerHostname
             * @param value ``CfnModel.ContainerDefinitionProperty.ContainerHostname``
             * @return {@code this}
             */
            public Builder withContainerHostname(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._containerHostname = value;
                return this;
            }
            /**
             * Sets the value of Environment
             * @param value ``CfnModel.ContainerDefinitionProperty.Environment``
             * @return {@code this}
             */
            public Builder withEnvironment(@javax.annotation.Nullable final com.fasterxml.jackson.databind.node.ObjectNode value) {
                this._environment = value;
                return this;
            }
            /**
             * Sets the value of Environment
             * @param value ``CfnModel.ContainerDefinitionProperty.Environment``
             * @return {@code this}
             */
            public Builder withEnvironment(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._environment = value;
                return this;
            }
            /**
             * Sets the value of ModelDataUrl
             * @param value ``CfnModel.ContainerDefinitionProperty.ModelDataUrl``
             * @return {@code this}
             */
            public Builder withModelDataUrl(@javax.annotation.Nullable final java.lang.String value) {
                this._modelDataUrl = value;
                return this;
            }
            /**
             * Sets the value of ModelDataUrl
             * @param value ``CfnModel.ContainerDefinitionProperty.ModelDataUrl``
             * @return {@code this}
             */
            public Builder withModelDataUrl(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._modelDataUrl = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ContainerDefinitionProperty build() {
                return new ContainerDefinitionProperty() {
                    private java.lang.Object $image = java.util.Objects.requireNonNull(_image, "image is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $containerHostname = _containerHostname;
                    @javax.annotation.Nullable
                    private java.lang.Object $environment = _environment;
                    @javax.annotation.Nullable
                    private java.lang.Object $modelDataUrl = _modelDataUrl;

                    @Override
                    public java.lang.Object getImage() {
                        return this.$image;
                    }

                    @Override
                    public void setImage(final java.lang.String value) {
                        this.$image = java.util.Objects.requireNonNull(value, "image is required");
                    }

                    @Override
                    public void setImage(final software.amazon.awscdk.Token value) {
                        this.$image = java.util.Objects.requireNonNull(value, "image is required");
                    }

                    @Override
                    public java.lang.Object getContainerHostname() {
                        return this.$containerHostname;
                    }

                    @Override
                    public void setContainerHostname(@javax.annotation.Nullable final java.lang.String value) {
                        this.$containerHostname = value;
                    }

                    @Override
                    public void setContainerHostname(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$containerHostname = value;
                    }

                    @Override
                    public java.lang.Object getEnvironment() {
                        return this.$environment;
                    }

                    @Override
                    public void setEnvironment(@javax.annotation.Nullable final com.fasterxml.jackson.databind.node.ObjectNode value) {
                        this.$environment = value;
                    }

                    @Override
                    public void setEnvironment(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$environment = value;
                    }

                    @Override
                    public java.lang.Object getModelDataUrl() {
                        return this.$modelDataUrl;
                    }

                    @Override
                    public void setModelDataUrl(@javax.annotation.Nullable final java.lang.String value) {
                        this.$modelDataUrl = value;
                    }

                    @Override
                    public void setModelDataUrl(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$modelDataUrl = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sagemaker.CfnModel.ContainerDefinitionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnModel.ContainerDefinitionProperty.Image``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-image
             */
            @Override
            public java.lang.Object getImage() {
                return this.jsiiGet("image", java.lang.Object.class);
            }

            /**
             * ``CfnModel.ContainerDefinitionProperty.Image``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-image
             */
            @Override
            public void setImage(final java.lang.String value) {
                this.jsiiSet("image", java.util.Objects.requireNonNull(value, "image is required"));
            }

            /**
             * ``CfnModel.ContainerDefinitionProperty.Image``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-image
             */
            @Override
            public void setImage(final software.amazon.awscdk.Token value) {
                this.jsiiSet("image", java.util.Objects.requireNonNull(value, "image is required"));
            }

            /**
             * ``CfnModel.ContainerDefinitionProperty.ContainerHostname``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-containerhostname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getContainerHostname() {
                return this.jsiiGet("containerHostname", java.lang.Object.class);
            }

            /**
             * ``CfnModel.ContainerDefinitionProperty.ContainerHostname``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-containerhostname
             */
            @Override
            public void setContainerHostname(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("containerHostname", value);
            }

            /**
             * ``CfnModel.ContainerDefinitionProperty.ContainerHostname``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-containerhostname
             */
            @Override
            public void setContainerHostname(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("containerHostname", value);
            }

            /**
             * ``CfnModel.ContainerDefinitionProperty.Environment``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-environment
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEnvironment() {
                return this.jsiiGet("environment", java.lang.Object.class);
            }

            /**
             * ``CfnModel.ContainerDefinitionProperty.Environment``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-environment
             */
            @Override
            public void setEnvironment(@javax.annotation.Nullable final com.fasterxml.jackson.databind.node.ObjectNode value) {
                this.jsiiSet("environment", value);
            }

            /**
             * ``CfnModel.ContainerDefinitionProperty.Environment``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-environment
             */
            @Override
            public void setEnvironment(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("environment", value);
            }

            /**
             * ``CfnModel.ContainerDefinitionProperty.ModelDataUrl``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-modeldataurl
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getModelDataUrl() {
                return this.jsiiGet("modelDataUrl", java.lang.Object.class);
            }

            /**
             * ``CfnModel.ContainerDefinitionProperty.ModelDataUrl``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-modeldataurl
             */
            @Override
            public void setModelDataUrl(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("modelDataUrl", value);
            }

            /**
             * ``CfnModel.ContainerDefinitionProperty.ModelDataUrl``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-modeldataurl
             */
            @Override
            public void setModelDataUrl(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("modelDataUrl", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html
     */
    public static interface VpcConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnModel.VpcConfigProperty.SecurityGroupIds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-securitygroupids
         */
        java.lang.Object getSecurityGroupIds();
        /**
         * ``CfnModel.VpcConfigProperty.SecurityGroupIds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-securitygroupids
         */
        void setSecurityGroupIds(final software.amazon.awscdk.Token value);
        /**
         * ``CfnModel.VpcConfigProperty.SecurityGroupIds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-securitygroupids
         */
        void setSecurityGroupIds(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnModel.VpcConfigProperty.Subnets``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-subnets
         */
        java.lang.Object getSubnets();
        /**
         * ``CfnModel.VpcConfigProperty.Subnets``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-subnets
         */
        void setSubnets(final software.amazon.awscdk.Token value);
        /**
         * ``CfnModel.VpcConfigProperty.Subnets``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-subnets
         */
        void setSubnets(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link VpcConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link VpcConfigProperty}
         */
        final class Builder {
            private java.lang.Object _securityGroupIds;
            private java.lang.Object _subnets;

            /**
             * Sets the value of SecurityGroupIds
             * @param value ``CfnModel.VpcConfigProperty.SecurityGroupIds``
             * @return {@code this}
             */
            public Builder withSecurityGroupIds(final software.amazon.awscdk.Token value) {
                this._securityGroupIds = java.util.Objects.requireNonNull(value, "securityGroupIds is required");
                return this;
            }
            /**
             * Sets the value of SecurityGroupIds
             * @param value ``CfnModel.VpcConfigProperty.SecurityGroupIds``
             * @return {@code this}
             */
            public Builder withSecurityGroupIds(final java.util.List<java.lang.Object> value) {
                this._securityGroupIds = java.util.Objects.requireNonNull(value, "securityGroupIds is required");
                return this;
            }
            /**
             * Sets the value of Subnets
             * @param value ``CfnModel.VpcConfigProperty.Subnets``
             * @return {@code this}
             */
            public Builder withSubnets(final software.amazon.awscdk.Token value) {
                this._subnets = java.util.Objects.requireNonNull(value, "subnets is required");
                return this;
            }
            /**
             * Sets the value of Subnets
             * @param value ``CfnModel.VpcConfigProperty.Subnets``
             * @return {@code this}
             */
            public Builder withSubnets(final java.util.List<java.lang.Object> value) {
                this._subnets = java.util.Objects.requireNonNull(value, "subnets is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public VpcConfigProperty build() {
                return new VpcConfigProperty() {
                    private java.lang.Object $securityGroupIds = java.util.Objects.requireNonNull(_securityGroupIds, "securityGroupIds is required");
                    private java.lang.Object $subnets = java.util.Objects.requireNonNull(_subnets, "subnets is required");

                    @Override
                    public java.lang.Object getSecurityGroupIds() {
                        return this.$securityGroupIds;
                    }

                    @Override
                    public void setSecurityGroupIds(final software.amazon.awscdk.Token value) {
                        this.$securityGroupIds = java.util.Objects.requireNonNull(value, "securityGroupIds is required");
                    }

                    @Override
                    public void setSecurityGroupIds(final java.util.List<java.lang.Object> value) {
                        this.$securityGroupIds = java.util.Objects.requireNonNull(value, "securityGroupIds is required");
                    }

                    @Override
                    public java.lang.Object getSubnets() {
                        return this.$subnets;
                    }

                    @Override
                    public void setSubnets(final software.amazon.awscdk.Token value) {
                        this.$subnets = java.util.Objects.requireNonNull(value, "subnets is required");
                    }

                    @Override
                    public void setSubnets(final java.util.List<java.lang.Object> value) {
                        this.$subnets = java.util.Objects.requireNonNull(value, "subnets is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sagemaker.CfnModel.VpcConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnModel.VpcConfigProperty.SecurityGroupIds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-securitygroupids
             */
            @Override
            public java.lang.Object getSecurityGroupIds() {
                return this.jsiiGet("securityGroupIds", java.lang.Object.class);
            }

            /**
             * ``CfnModel.VpcConfigProperty.SecurityGroupIds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-securitygroupids
             */
            @Override
            public void setSecurityGroupIds(final software.amazon.awscdk.Token value) {
                this.jsiiSet("securityGroupIds", java.util.Objects.requireNonNull(value, "securityGroupIds is required"));
            }

            /**
             * ``CfnModel.VpcConfigProperty.SecurityGroupIds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-securitygroupids
             */
            @Override
            public void setSecurityGroupIds(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("securityGroupIds", java.util.Objects.requireNonNull(value, "securityGroupIds is required"));
            }

            /**
             * ``CfnModel.VpcConfigProperty.Subnets``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-subnets
             */
            @Override
            public java.lang.Object getSubnets() {
                return this.jsiiGet("subnets", java.lang.Object.class);
            }

            /**
             * ``CfnModel.VpcConfigProperty.Subnets``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-subnets
             */
            @Override
            public void setSubnets(final software.amazon.awscdk.Token value) {
                this.jsiiSet("subnets", java.util.Objects.requireNonNull(value, "subnets is required"));
            }

            /**
             * ``CfnModel.VpcConfigProperty.Subnets``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-subnets
             */
            @Override
            public void setSubnets(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("subnets", java.util.Objects.requireNonNull(value, "subnets is required"));
            }
        }
    }
}
