package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a `AWS::SageMaker::EndpointConfig`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-04-24T21:03:00.246Z")
public interface CfnEndpointConfigProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::SageMaker::EndpointConfig.ProductionVariants`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
     */
    java.lang.Object getProductionVariants();
    /**
     * `AWS::SageMaker::EndpointConfig.EndpointConfigName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
     */
    java.lang.String getEndpointConfigName();
    /**
     * `AWS::SageMaker::EndpointConfig.KmsKeyId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
     */
    java.lang.String getKmsKeyId();
    /**
     * `AWS::SageMaker::EndpointConfig.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
     */
    java.util.List<software.amazon.awscdk.CfnTag> getTags();

    /**
     * @return a {@link Builder} of {@link CfnEndpointConfigProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnEndpointConfigProps}
     */
    final class Builder {
        private java.lang.Object _productionVariants;
        @javax.annotation.Nullable
        private java.lang.String _endpointConfigName;
        @javax.annotation.Nullable
        private java.lang.String _kmsKeyId;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.CfnTag> _tags;

        /**
         * Sets the value of ProductionVariants
         * @param value `AWS::SageMaker::EndpointConfig.ProductionVariants`.
         * @return {@code this}
         */
        public Builder withProductionVariants(final software.amazon.awscdk.Token value) {
            this._productionVariants = java.util.Objects.requireNonNull(value, "productionVariants is required");
            return this;
        }
        /**
         * Sets the value of ProductionVariants
         * @param value `AWS::SageMaker::EndpointConfig.ProductionVariants`.
         * @return {@code this}
         */
        public Builder withProductionVariants(final java.util.List<java.lang.Object> value) {
            this._productionVariants = java.util.Objects.requireNonNull(value, "productionVariants is required");
            return this;
        }
        /**
         * Sets the value of EndpointConfigName
         * @param value `AWS::SageMaker::EndpointConfig.EndpointConfigName`.
         * @return {@code this}
         */
        public Builder withEndpointConfigName(@javax.annotation.Nullable final java.lang.String value) {
            this._endpointConfigName = value;
            return this;
        }
        /**
         * Sets the value of KmsKeyId
         * @param value `AWS::SageMaker::EndpointConfig.KmsKeyId`.
         * @return {@code this}
         */
        public Builder withKmsKeyId(@javax.annotation.Nullable final java.lang.String value) {
            this._kmsKeyId = value;
            return this;
        }
        /**
         * Sets the value of Tags
         * @param value `AWS::SageMaker::EndpointConfig.Tags`.
         * @return {@code this}
         */
        public Builder withTags(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.CfnTag> value) {
            this._tags = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEndpointConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CfnEndpointConfigProps build() {
            return new CfnEndpointConfigProps() {
                private final java.lang.Object $productionVariants = java.util.Objects.requireNonNull(_productionVariants, "productionVariants is required");
                @javax.annotation.Nullable
                private final java.lang.String $endpointConfigName = _endpointConfigName;
                @javax.annotation.Nullable
                private final java.lang.String $kmsKeyId = _kmsKeyId;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.CfnTag> $tags = _tags;

                @Override
                public java.lang.Object getProductionVariants() {
                    return this.$productionVariants;
                }

                @Override
                public java.lang.String getEndpointConfigName() {
                    return this.$endpointConfigName;
                }

                @Override
                public java.lang.String getKmsKeyId() {
                    return this.$kmsKeyId;
                }

                @Override
                public java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                    return this.$tags;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("productionVariants", om.valueToTree(this.getProductionVariants()));
                    obj.set("endpointConfigName", om.valueToTree(this.getEndpointConfigName()));
                    obj.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                    obj.set("tags", om.valueToTree(this.getTags()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sagemaker.CfnEndpointConfigProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::SageMaker::EndpointConfig.ProductionVariants`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
         */
        @Override
        public java.lang.Object getProductionVariants() {
            return this.jsiiGet("productionVariants", java.lang.Object.class);
        }

        /**
         * `AWS::SageMaker::EndpointConfig.EndpointConfigName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getEndpointConfigName() {
            return this.jsiiGet("endpointConfigName", java.lang.String.class);
        }

        /**
         * `AWS::SageMaker::EndpointConfig.KmsKeyId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getKmsKeyId() {
            return this.jsiiGet("kmsKeyId", java.lang.String.class);
        }

        /**
         * `AWS::SageMaker::EndpointConfig.Tags`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.jsiiGet("tags", java.util.List.class);
        }
    }
}
