package software.amazon.awscdk.services.sagemaker;

/**
 * A CloudFormation `AWS::SageMaker::Model`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-04-24T21:03:00.248Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModel")
public class CfnModel extends software.amazon.awscdk.CfnResource {
    protected CfnModel(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnModel.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::SageMaker::Model`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnModel(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.sagemaker.CfnModelProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getModelArn() {
        return this.jsiiGet("modelArn", java.lang.String.class);
    }

    /**
     */
    public java.lang.String getModelName() {
        return this.jsiiGet("modelName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.sagemaker.CfnModelProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.sagemaker.CfnModelProps.class);
    }

    /**
     * The `TagManager` handles setting, removing and formatting tags.
     * 
     * Tags should be managed either passing them as properties during
     * initiation or by calling methods on this object. If both techniques are
     * used only the tags from the TagManager will be used. `Tag` (aspect)
     * will use the manager.
     */
    public software.amazon.awscdk.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.TagManager.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html
     */
    public static interface ContainerDefinitionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnModel.ContainerDefinitionProperty.Image`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-image
         */
        java.lang.String getImage();
        /**
         * `CfnModel.ContainerDefinitionProperty.ContainerHostname`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-containerhostname
         */
        java.lang.String getContainerHostname();
        /**
         * `CfnModel.ContainerDefinitionProperty.Environment`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-environment
         */
        java.lang.Object getEnvironment();
        /**
         * `CfnModel.ContainerDefinitionProperty.ModelDataUrl`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-modeldataurl
         */
        java.lang.String getModelDataUrl();

        /**
         * @return a {@link Builder} of {@link ContainerDefinitionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ContainerDefinitionProperty}
         */
        final class Builder {
            private java.lang.String _image;
            @javax.annotation.Nullable
            private java.lang.String _containerHostname;
            @javax.annotation.Nullable
            private java.lang.Object _environment;
            @javax.annotation.Nullable
            private java.lang.String _modelDataUrl;

            /**
             * Sets the value of Image
             * @param value `CfnModel.ContainerDefinitionProperty.Image`.
             * @return {@code this}
             */
            public Builder withImage(final java.lang.String value) {
                this._image = java.util.Objects.requireNonNull(value, "image is required");
                return this;
            }
            /**
             * Sets the value of ContainerHostname
             * @param value `CfnModel.ContainerDefinitionProperty.ContainerHostname`.
             * @return {@code this}
             */
            public Builder withContainerHostname(@javax.annotation.Nullable final java.lang.String value) {
                this._containerHostname = value;
                return this;
            }
            /**
             * Sets the value of Environment
             * @param value `CfnModel.ContainerDefinitionProperty.Environment`.
             * @return {@code this}
             */
            public Builder withEnvironment(@javax.annotation.Nullable final com.fasterxml.jackson.databind.node.ObjectNode value) {
                this._environment = value;
                return this;
            }
            /**
             * Sets the value of Environment
             * @param value `CfnModel.ContainerDefinitionProperty.Environment`.
             * @return {@code this}
             */
            public Builder withEnvironment(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._environment = value;
                return this;
            }
            /**
             * Sets the value of ModelDataUrl
             * @param value `CfnModel.ContainerDefinitionProperty.ModelDataUrl`.
             * @return {@code this}
             */
            public Builder withModelDataUrl(@javax.annotation.Nullable final java.lang.String value) {
                this._modelDataUrl = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ContainerDefinitionProperty build() {
                return new ContainerDefinitionProperty() {
                    private final java.lang.String $image = java.util.Objects.requireNonNull(_image, "image is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $containerHostname = _containerHostname;
                    @javax.annotation.Nullable
                    private final java.lang.Object $environment = _environment;
                    @javax.annotation.Nullable
                    private final java.lang.String $modelDataUrl = _modelDataUrl;

                    @Override
                    public java.lang.String getImage() {
                        return this.$image;
                    }

                    @Override
                    public java.lang.String getContainerHostname() {
                        return this.$containerHostname;
                    }

                    @Override
                    public java.lang.Object getEnvironment() {
                        return this.$environment;
                    }

                    @Override
                    public java.lang.String getModelDataUrl() {
                        return this.$modelDataUrl;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("image", om.valueToTree(this.getImage()));
                        obj.set("containerHostname", om.valueToTree(this.getContainerHostname()));
                        obj.set("environment", om.valueToTree(this.getEnvironment()));
                        obj.set("modelDataUrl", om.valueToTree(this.getModelDataUrl()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sagemaker.CfnModel.ContainerDefinitionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnModel.ContainerDefinitionProperty.Image`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-image
             */
            @Override
            public java.lang.String getImage() {
                return this.jsiiGet("image", java.lang.String.class);
            }

            /**
             * `CfnModel.ContainerDefinitionProperty.ContainerHostname`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-containerhostname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getContainerHostname() {
                return this.jsiiGet("containerHostname", java.lang.String.class);
            }

            /**
             * `CfnModel.ContainerDefinitionProperty.Environment`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-environment
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEnvironment() {
                return this.jsiiGet("environment", java.lang.Object.class);
            }

            /**
             * `CfnModel.ContainerDefinitionProperty.ModelDataUrl`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-modeldataurl
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getModelDataUrl() {
                return this.jsiiGet("modelDataUrl", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html
     */
    public static interface VpcConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnModel.VpcConfigProperty.SecurityGroupIds`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-securitygroupids
         */
        java.util.List<java.lang.String> getSecurityGroupIds();
        /**
         * `CfnModel.VpcConfigProperty.Subnets`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-subnets
         */
        java.util.List<java.lang.String> getSubnets();

        /**
         * @return a {@link Builder} of {@link VpcConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link VpcConfigProperty}
         */
        final class Builder {
            private java.util.List<java.lang.String> _securityGroupIds;
            private java.util.List<java.lang.String> _subnets;

            /**
             * Sets the value of SecurityGroupIds
             * @param value `CfnModel.VpcConfigProperty.SecurityGroupIds`.
             * @return {@code this}
             */
            public Builder withSecurityGroupIds(final java.util.List<java.lang.String> value) {
                this._securityGroupIds = java.util.Objects.requireNonNull(value, "securityGroupIds is required");
                return this;
            }
            /**
             * Sets the value of Subnets
             * @param value `CfnModel.VpcConfigProperty.Subnets`.
             * @return {@code this}
             */
            public Builder withSubnets(final java.util.List<java.lang.String> value) {
                this._subnets = java.util.Objects.requireNonNull(value, "subnets is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public VpcConfigProperty build() {
                return new VpcConfigProperty() {
                    private final java.util.List<java.lang.String> $securityGroupIds = java.util.Objects.requireNonNull(_securityGroupIds, "securityGroupIds is required");
                    private final java.util.List<java.lang.String> $subnets = java.util.Objects.requireNonNull(_subnets, "subnets is required");

                    @Override
                    public java.util.List<java.lang.String> getSecurityGroupIds() {
                        return this.$securityGroupIds;
                    }

                    @Override
                    public java.util.List<java.lang.String> getSubnets() {
                        return this.$subnets;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                        obj.set("subnets", om.valueToTree(this.getSubnets()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sagemaker.CfnModel.VpcConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnModel.VpcConfigProperty.SecurityGroupIds`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-securitygroupids
             */
            @Override
            public java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.jsiiGet("securityGroupIds", java.util.List.class);
            }

            /**
             * `CfnModel.VpcConfigProperty.Subnets`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-subnets
             */
            @Override
            public java.util.List<java.lang.String> getSubnets() {
                return this.jsiiGet("subnets", java.util.List.class);
            }
        }
    }
}
