package software.amazon.awscdk.services.sagemaker;

/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-06T20:51:48.425Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnEndpointConfig")
public class CfnEndpointConfig extends software.amazon.awscdk.CfnResource {
    protected CfnEndpointConfig(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::SageMaker::EndpointConfig`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnEndpointConfig(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.sagemaker.CfnEndpointConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getEndpointConfigArn() {
        return this.jsiiGet("endpointConfigArn", java.lang.String.class);
    }

    /**
     */
    public java.lang.String getEndpointConfigName() {
        return this.jsiiGet("endpointConfigName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.sagemaker.CfnEndpointConfigProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.sagemaker.CfnEndpointConfigProps.class);
    }

    /**
     * The `TagManager` handles setting, removing and formatting tags.
     * 
     * Tags should be managed either passing them as properties during
     * initiation or by calling methods on this object. If both techniques are
     * used only the tags from the TagManager will be used. `Tag` (aspect)
     * will use the manager.
     */
    public software.amazon.awscdk.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.TagManager.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html
     */
    public static interface ProductionVariantProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InitialInstanceCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialinstancecount
         */
        java.lang.Object getInitialInstanceCount();
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InitialVariantWeight`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialvariantweight
         */
        java.lang.Object getInitialVariantWeight();
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InstanceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-instancetype
         */
        java.lang.String getInstanceType();
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.ModelName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modelname
         */
        java.lang.String getModelName();
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.VariantName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-variantname
         */
        java.lang.String getVariantName();
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.AcceleratorType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-acceleratortype
         */
        java.lang.String getAcceleratorType();

        /**
         * @return a {@link Builder} of {@link ProductionVariantProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ProductionVariantProperty}
         */
        final class Builder {
            private java.lang.Object _initialInstanceCount;
            private java.lang.Object _initialVariantWeight;
            private java.lang.String _instanceType;
            private java.lang.String _modelName;
            private java.lang.String _variantName;
            @javax.annotation.Nullable
            private java.lang.String _acceleratorType;

            /**
             * Sets the value of InitialInstanceCount
             * @param value `CfnEndpointConfig.ProductionVariantProperty.InitialInstanceCount`.
             * @return {@code this}
             */
            public Builder withInitialInstanceCount(final java.lang.Number value) {
                this._initialInstanceCount = java.util.Objects.requireNonNull(value, "initialInstanceCount is required");
                return this;
            }
            /**
             * Sets the value of InitialInstanceCount
             * @param value `CfnEndpointConfig.ProductionVariantProperty.InitialInstanceCount`.
             * @return {@code this}
             */
            public Builder withInitialInstanceCount(final software.amazon.awscdk.Token value) {
                this._initialInstanceCount = java.util.Objects.requireNonNull(value, "initialInstanceCount is required");
                return this;
            }
            /**
             * Sets the value of InitialVariantWeight
             * @param value `CfnEndpointConfig.ProductionVariantProperty.InitialVariantWeight`.
             * @return {@code this}
             */
            public Builder withInitialVariantWeight(final java.lang.Number value) {
                this._initialVariantWeight = java.util.Objects.requireNonNull(value, "initialVariantWeight is required");
                return this;
            }
            /**
             * Sets the value of InitialVariantWeight
             * @param value `CfnEndpointConfig.ProductionVariantProperty.InitialVariantWeight`.
             * @return {@code this}
             */
            public Builder withInitialVariantWeight(final software.amazon.awscdk.Token value) {
                this._initialVariantWeight = java.util.Objects.requireNonNull(value, "initialVariantWeight is required");
                return this;
            }
            /**
             * Sets the value of InstanceType
             * @param value `CfnEndpointConfig.ProductionVariantProperty.InstanceType`.
             * @return {@code this}
             */
            public Builder withInstanceType(final java.lang.String value) {
                this._instanceType = java.util.Objects.requireNonNull(value, "instanceType is required");
                return this;
            }
            /**
             * Sets the value of ModelName
             * @param value `CfnEndpointConfig.ProductionVariantProperty.ModelName`.
             * @return {@code this}
             */
            public Builder withModelName(final java.lang.String value) {
                this._modelName = java.util.Objects.requireNonNull(value, "modelName is required");
                return this;
            }
            /**
             * Sets the value of VariantName
             * @param value `CfnEndpointConfig.ProductionVariantProperty.VariantName`.
             * @return {@code this}
             */
            public Builder withVariantName(final java.lang.String value) {
                this._variantName = java.util.Objects.requireNonNull(value, "variantName is required");
                return this;
            }
            /**
             * Sets the value of AcceleratorType
             * @param value `CfnEndpointConfig.ProductionVariantProperty.AcceleratorType`.
             * @return {@code this}
             */
            public Builder withAcceleratorType(@javax.annotation.Nullable final java.lang.String value) {
                this._acceleratorType = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProductionVariantProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ProductionVariantProperty build() {
                return new ProductionVariantProperty() {
                    private final java.lang.Object $initialInstanceCount = java.util.Objects.requireNonNull(_initialInstanceCount, "initialInstanceCount is required");
                    private final java.lang.Object $initialVariantWeight = java.util.Objects.requireNonNull(_initialVariantWeight, "initialVariantWeight is required");
                    private final java.lang.String $instanceType = java.util.Objects.requireNonNull(_instanceType, "instanceType is required");
                    private final java.lang.String $modelName = java.util.Objects.requireNonNull(_modelName, "modelName is required");
                    private final java.lang.String $variantName = java.util.Objects.requireNonNull(_variantName, "variantName is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $acceleratorType = _acceleratorType;

                    @Override
                    public java.lang.Object getInitialInstanceCount() {
                        return this.$initialInstanceCount;
                    }

                    @Override
                    public java.lang.Object getInitialVariantWeight() {
                        return this.$initialVariantWeight;
                    }

                    @Override
                    public java.lang.String getInstanceType() {
                        return this.$instanceType;
                    }

                    @Override
                    public java.lang.String getModelName() {
                        return this.$modelName;
                    }

                    @Override
                    public java.lang.String getVariantName() {
                        return this.$variantName;
                    }

                    @Override
                    public java.lang.String getAcceleratorType() {
                        return this.$acceleratorType;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("initialInstanceCount", om.valueToTree(this.getInitialInstanceCount()));
                        obj.set("initialVariantWeight", om.valueToTree(this.getInitialVariantWeight()));
                        obj.set("instanceType", om.valueToTree(this.getInstanceType()));
                        obj.set("modelName", om.valueToTree(this.getModelName()));
                        obj.set("variantName", om.valueToTree(this.getVariantName()));
                        obj.set("acceleratorType", om.valueToTree(this.getAcceleratorType()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ProductionVariantProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnEndpointConfig.ProductionVariantProperty.InitialInstanceCount`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialinstancecount
             */
            @Override
            public java.lang.Object getInitialInstanceCount() {
                return this.jsiiGet("initialInstanceCount", java.lang.Object.class);
            }

            /**
             * `CfnEndpointConfig.ProductionVariantProperty.InitialVariantWeight`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialvariantweight
             */
            @Override
            public java.lang.Object getInitialVariantWeight() {
                return this.jsiiGet("initialVariantWeight", java.lang.Object.class);
            }

            /**
             * `CfnEndpointConfig.ProductionVariantProperty.InstanceType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-instancetype
             */
            @Override
            public java.lang.String getInstanceType() {
                return this.jsiiGet("instanceType", java.lang.String.class);
            }

            /**
             * `CfnEndpointConfig.ProductionVariantProperty.ModelName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modelname
             */
            @Override
            public java.lang.String getModelName() {
                return this.jsiiGet("modelName", java.lang.String.class);
            }

            /**
             * `CfnEndpointConfig.ProductionVariantProperty.VariantName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-variantname
             */
            @Override
            public java.lang.String getVariantName() {
                return this.jsiiGet("variantName", java.lang.String.class);
            }

            /**
             * `CfnEndpointConfig.ProductionVariantProperty.AcceleratorType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-acceleratortype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getAcceleratorType() {
                return this.jsiiGet("acceleratorType", java.lang.String.class);
            }
        }
    }
}
