package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a `AWS::SageMaker::NotebookInstance`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-06T20:51:48.443Z")
public interface CfnNotebookInstanceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::SageMaker::NotebookInstance.InstanceType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-instancetype
     */
    java.lang.String getInstanceType();
    /**
     * `AWS::SageMaker::NotebookInstance.RoleArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rolearn
     */
    java.lang.String getRoleArn();
    /**
     * `AWS::SageMaker::NotebookInstance.DirectInternetAccess`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-directinternetaccess
     */
    java.lang.String getDirectInternetAccess();
    /**
     * `AWS::SageMaker::NotebookInstance.KmsKeyId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-kmskeyid
     */
    java.lang.String getKmsKeyId();
    /**
     * `AWS::SageMaker::NotebookInstance.LifecycleConfigName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-lifecycleconfigname
     */
    java.lang.String getLifecycleConfigName();
    /**
     * `AWS::SageMaker::NotebookInstance.NotebookInstanceName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-notebookinstancename
     */
    java.lang.String getNotebookInstanceName();
    /**
     * `AWS::SageMaker::NotebookInstance.RootAccess`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rootaccess
     */
    java.lang.String getRootAccess();
    /**
     * `AWS::SageMaker::NotebookInstance.SecurityGroupIds`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-securitygroupids
     */
    java.util.List<java.lang.String> getSecurityGroupIds();
    /**
     * `AWS::SageMaker::NotebookInstance.SubnetId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-subnetid
     */
    java.lang.String getSubnetId();
    /**
     * `AWS::SageMaker::NotebookInstance.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-tags
     */
    java.util.List<software.amazon.awscdk.CfnTag> getTags();
    /**
     * `AWS::SageMaker::NotebookInstance.VolumeSizeInGB`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-volumesizeingb
     */
    java.lang.Object getVolumeSizeInGb();

    /**
     * @return a {@link Builder} of {@link CfnNotebookInstanceProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnNotebookInstanceProps}
     */
    final class Builder {
        private java.lang.String _instanceType;
        private java.lang.String _roleArn;
        @javax.annotation.Nullable
        private java.lang.String _directInternetAccess;
        @javax.annotation.Nullable
        private java.lang.String _kmsKeyId;
        @javax.annotation.Nullable
        private java.lang.String _lifecycleConfigName;
        @javax.annotation.Nullable
        private java.lang.String _notebookInstanceName;
        @javax.annotation.Nullable
        private java.lang.String _rootAccess;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _securityGroupIds;
        @javax.annotation.Nullable
        private java.lang.String _subnetId;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.CfnTag> _tags;
        @javax.annotation.Nullable
        private java.lang.Object _volumeSizeInGb;

        /**
         * Sets the value of InstanceType
         * @param value `AWS::SageMaker::NotebookInstance.InstanceType`.
         * @return {@code this}
         */
        public Builder withInstanceType(final java.lang.String value) {
            this._instanceType = java.util.Objects.requireNonNull(value, "instanceType is required");
            return this;
        }
        /**
         * Sets the value of RoleArn
         * @param value `AWS::SageMaker::NotebookInstance.RoleArn`.
         * @return {@code this}
         */
        public Builder withRoleArn(final java.lang.String value) {
            this._roleArn = java.util.Objects.requireNonNull(value, "roleArn is required");
            return this;
        }
        /**
         * Sets the value of DirectInternetAccess
         * @param value `AWS::SageMaker::NotebookInstance.DirectInternetAccess`.
         * @return {@code this}
         */
        public Builder withDirectInternetAccess(@javax.annotation.Nullable final java.lang.String value) {
            this._directInternetAccess = value;
            return this;
        }
        /**
         * Sets the value of KmsKeyId
         * @param value `AWS::SageMaker::NotebookInstance.KmsKeyId`.
         * @return {@code this}
         */
        public Builder withKmsKeyId(@javax.annotation.Nullable final java.lang.String value) {
            this._kmsKeyId = value;
            return this;
        }
        /**
         * Sets the value of LifecycleConfigName
         * @param value `AWS::SageMaker::NotebookInstance.LifecycleConfigName`.
         * @return {@code this}
         */
        public Builder withLifecycleConfigName(@javax.annotation.Nullable final java.lang.String value) {
            this._lifecycleConfigName = value;
            return this;
        }
        /**
         * Sets the value of NotebookInstanceName
         * @param value `AWS::SageMaker::NotebookInstance.NotebookInstanceName`.
         * @return {@code this}
         */
        public Builder withNotebookInstanceName(@javax.annotation.Nullable final java.lang.String value) {
            this._notebookInstanceName = value;
            return this;
        }
        /**
         * Sets the value of RootAccess
         * @param value `AWS::SageMaker::NotebookInstance.RootAccess`.
         * @return {@code this}
         */
        public Builder withRootAccess(@javax.annotation.Nullable final java.lang.String value) {
            this._rootAccess = value;
            return this;
        }
        /**
         * Sets the value of SecurityGroupIds
         * @param value `AWS::SageMaker::NotebookInstance.SecurityGroupIds`.
         * @return {@code this}
         */
        public Builder withSecurityGroupIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._securityGroupIds = value;
            return this;
        }
        /**
         * Sets the value of SubnetId
         * @param value `AWS::SageMaker::NotebookInstance.SubnetId`.
         * @return {@code this}
         */
        public Builder withSubnetId(@javax.annotation.Nullable final java.lang.String value) {
            this._subnetId = value;
            return this;
        }
        /**
         * Sets the value of Tags
         * @param value `AWS::SageMaker::NotebookInstance.Tags`.
         * @return {@code this}
         */
        public Builder withTags(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.CfnTag> value) {
            this._tags = value;
            return this;
        }
        /**
         * Sets the value of VolumeSizeInGb
         * @param value `AWS::SageMaker::NotebookInstance.VolumeSizeInGB`.
         * @return {@code this}
         */
        public Builder withVolumeSizeInGb(@javax.annotation.Nullable final java.lang.Number value) {
            this._volumeSizeInGb = value;
            return this;
        }
        /**
         * Sets the value of VolumeSizeInGb
         * @param value `AWS::SageMaker::NotebookInstance.VolumeSizeInGB`.
         * @return {@code this}
         */
        public Builder withVolumeSizeInGb(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this._volumeSizeInGb = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNotebookInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CfnNotebookInstanceProps build() {
            return new CfnNotebookInstanceProps() {
                private final java.lang.String $instanceType = java.util.Objects.requireNonNull(_instanceType, "instanceType is required");
                private final java.lang.String $roleArn = java.util.Objects.requireNonNull(_roleArn, "roleArn is required");
                @javax.annotation.Nullable
                private final java.lang.String $directInternetAccess = _directInternetAccess;
                @javax.annotation.Nullable
                private final java.lang.String $kmsKeyId = _kmsKeyId;
                @javax.annotation.Nullable
                private final java.lang.String $lifecycleConfigName = _lifecycleConfigName;
                @javax.annotation.Nullable
                private final java.lang.String $notebookInstanceName = _notebookInstanceName;
                @javax.annotation.Nullable
                private final java.lang.String $rootAccess = _rootAccess;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $securityGroupIds = _securityGroupIds;
                @javax.annotation.Nullable
                private final java.lang.String $subnetId = _subnetId;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.CfnTag> $tags = _tags;
                @javax.annotation.Nullable
                private final java.lang.Object $volumeSizeInGb = _volumeSizeInGb;

                @Override
                public java.lang.String getInstanceType() {
                    return this.$instanceType;
                }

                @Override
                public java.lang.String getRoleArn() {
                    return this.$roleArn;
                }

                @Override
                public java.lang.String getDirectInternetAccess() {
                    return this.$directInternetAccess;
                }

                @Override
                public java.lang.String getKmsKeyId() {
                    return this.$kmsKeyId;
                }

                @Override
                public java.lang.String getLifecycleConfigName() {
                    return this.$lifecycleConfigName;
                }

                @Override
                public java.lang.String getNotebookInstanceName() {
                    return this.$notebookInstanceName;
                }

                @Override
                public java.lang.String getRootAccess() {
                    return this.$rootAccess;
                }

                @Override
                public java.util.List<java.lang.String> getSecurityGroupIds() {
                    return this.$securityGroupIds;
                }

                @Override
                public java.lang.String getSubnetId() {
                    return this.$subnetId;
                }

                @Override
                public java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                    return this.$tags;
                }

                @Override
                public java.lang.Object getVolumeSizeInGb() {
                    return this.$volumeSizeInGb;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("instanceType", om.valueToTree(this.getInstanceType()));
                    obj.set("roleArn", om.valueToTree(this.getRoleArn()));
                    obj.set("directInternetAccess", om.valueToTree(this.getDirectInternetAccess()));
                    obj.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                    obj.set("lifecycleConfigName", om.valueToTree(this.getLifecycleConfigName()));
                    obj.set("notebookInstanceName", om.valueToTree(this.getNotebookInstanceName()));
                    obj.set("rootAccess", om.valueToTree(this.getRootAccess()));
                    obj.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                    obj.set("subnetId", om.valueToTree(this.getSubnetId()));
                    obj.set("tags", om.valueToTree(this.getTags()));
                    obj.set("volumeSizeInGb", om.valueToTree(this.getVolumeSizeInGb()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sagemaker.CfnNotebookInstanceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::SageMaker::NotebookInstance.InstanceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-instancetype
         */
        @Override
        public java.lang.String getInstanceType() {
            return this.jsiiGet("instanceType", java.lang.String.class);
        }

        /**
         * `AWS::SageMaker::NotebookInstance.RoleArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rolearn
         */
        @Override
        public java.lang.String getRoleArn() {
            return this.jsiiGet("roleArn", java.lang.String.class);
        }

        /**
         * `AWS::SageMaker::NotebookInstance.DirectInternetAccess`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-directinternetaccess
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDirectInternetAccess() {
            return this.jsiiGet("directInternetAccess", java.lang.String.class);
        }

        /**
         * `AWS::SageMaker::NotebookInstance.KmsKeyId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-kmskeyid
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getKmsKeyId() {
            return this.jsiiGet("kmsKeyId", java.lang.String.class);
        }

        /**
         * `AWS::SageMaker::NotebookInstance.LifecycleConfigName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-lifecycleconfigname
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getLifecycleConfigName() {
            return this.jsiiGet("lifecycleConfigName", java.lang.String.class);
        }

        /**
         * `AWS::SageMaker::NotebookInstance.NotebookInstanceName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-notebookinstancename
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getNotebookInstanceName() {
            return this.jsiiGet("notebookInstanceName", java.lang.String.class);
        }

        /**
         * `AWS::SageMaker::NotebookInstance.RootAccess`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rootaccess
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getRootAccess() {
            return this.jsiiGet("rootAccess", java.lang.String.class);
        }

        /**
         * `AWS::SageMaker::NotebookInstance.SecurityGroupIds`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-securitygroupids
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.jsiiGet("securityGroupIds", java.util.List.class);
        }

        /**
         * `AWS::SageMaker::NotebookInstance.SubnetId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-subnetid
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getSubnetId() {
            return this.jsiiGet("subnetId", java.lang.String.class);
        }

        /**
         * `AWS::SageMaker::NotebookInstance.Tags`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-tags
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.jsiiGet("tags", java.util.List.class);
        }

        /**
         * `AWS::SageMaker::NotebookInstance.VolumeSizeInGB`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-volumesizeingb
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getVolumeSizeInGb() {
            return this.jsiiGet("volumeSizeInGb", java.lang.Object.class);
        }
    }
}
