package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a `AWS::SageMaker::CodeRepository`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.18.0 (build f29d29c)", date = "2019-10-07T15:37:07.739Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnCodeRepositoryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::SageMaker::CodeRepository.GitConfig`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-gitconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getGitConfig();

    /**
     * `AWS::SageMaker::CodeRepository.CodeRepositoryName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-coderepositoryname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getCodeRepositoryName();

    /**
     * @return a {@link Builder} of {@link CfnCodeRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCodeRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.Object gitConfig;
        private java.lang.String codeRepositoryName;

        /**
         * Sets the value of GitConfig
         * @param gitConfig `AWS::SageMaker::CodeRepository.GitConfig`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder gitConfig(software.amazon.awscdk.services.sagemaker.CfnCodeRepository.GitConfigProperty gitConfig) {
            this.gitConfig = gitConfig;
            return this;
        }

        /**
         * Sets the value of GitConfig
         * @param gitConfig `AWS::SageMaker::CodeRepository.GitConfig`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder gitConfig(software.amazon.awscdk.core.IResolvable gitConfig) {
            this.gitConfig = gitConfig;
            return this;
        }

        /**
         * Sets the value of CodeRepositoryName
         * @param codeRepositoryName `AWS::SageMaker::CodeRepository.CodeRepositoryName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder codeRepositoryName(java.lang.String codeRepositoryName) {
            this.codeRepositoryName = codeRepositoryName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCodeRepositoryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnCodeRepositoryProps build() {
            return new Jsii$Proxy(gitConfig, codeRepositoryName);
        }
    }

    /**
     * An implementation for {@link CfnCodeRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCodeRepositoryProps {
        private final java.lang.Object gitConfig;
        private final java.lang.String codeRepositoryName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.gitConfig = this.jsiiGet("gitConfig", java.lang.Object.class);
            this.codeRepositoryName = this.jsiiGet("codeRepositoryName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Object gitConfig, java.lang.String codeRepositoryName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.gitConfig = java.util.Objects.requireNonNull(gitConfig, "gitConfig is required");
            this.codeRepositoryName = codeRepositoryName;
        }

        @Override
        public java.lang.Object getGitConfig() {
            return this.gitConfig;
        }

        @Override
        public java.lang.String getCodeRepositoryName() {
            return this.codeRepositoryName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("gitConfig", om.valueToTree(this.getGitConfig()));
            if (this.getCodeRepositoryName() != null) {
                obj.set("codeRepositoryName", om.valueToTree(this.getCodeRepositoryName()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCodeRepositoryProps.Jsii$Proxy that = (CfnCodeRepositoryProps.Jsii$Proxy) o;

            if (!gitConfig.equals(that.gitConfig)) return false;
            return this.codeRepositoryName != null ? this.codeRepositoryName.equals(that.codeRepositoryName) : that.codeRepositoryName == null;
        }

        @Override
        public int hashCode() {
            int result = this.gitConfig.hashCode();
            result = 31 * result + (this.codeRepositoryName != null ? this.codeRepositoryName.hashCode() : 0);
            return result;
        }
    }
}
