package software.amazon.awscdk.services.sagemaker;

/**
 * A CloudFormation `AWS::SageMaker::Workteam`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T19:51:55.581Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnWorkteam")
public class CfnWorkteam extends software.amazon.awscdk.core.CfnResource {

    protected CfnWorkteam(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWorkteam(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnWorkteam.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::SageMaker::Workteam`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnWorkteam(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.sagemaker.CfnWorkteamProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props }));
    }

    /**
     * Create a new `AWS::SageMaker::Workteam`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnWorkteam(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") }));
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrWorkteamName() {
        return this.jsiiGet("attrWorkteamName", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::SageMaker::Workteam.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::SageMaker::Workteam.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * `AWS::SageMaker::Workteam.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDescription(final java.lang.String value) {
        this.jsiiSet("description", value);
    }

    /**
     * `AWS::SageMaker::Workteam.MemberDefinitions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-memberdefinitions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getMemberDefinitions() {
        return this.jsiiGet("memberDefinitions", java.lang.Object.class);
    }

    /**
     * `AWS::SageMaker::Workteam.MemberDefinitions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-memberdefinitions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMemberDefinitions(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("memberDefinitions", value);
    }

    /**
     * `AWS::SageMaker::Workteam.MemberDefinitions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-memberdefinitions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMemberDefinitions(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("memberDefinitions", value);
    }

    /**
     * `AWS::SageMaker::Workteam.NotificationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-notificationconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getNotificationConfiguration() {
        return this.jsiiGet("notificationConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::SageMaker::Workteam.NotificationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-notificationconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setNotificationConfiguration(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("notificationConfiguration", value);
    }

    /**
     * `AWS::SageMaker::Workteam.NotificationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-notificationconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setNotificationConfiguration(final software.amazon.awscdk.services.sagemaker.CfnWorkteam.NotificationConfigurationProperty value) {
        this.jsiiSet("notificationConfiguration", value);
    }

    /**
     * `AWS::SageMaker::Workteam.WorkteamName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-workteamname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getWorkteamName() {
        return this.jsiiGet("workteamName", java.lang.String.class);
    }

    /**
     * `AWS::SageMaker::Workteam.WorkteamName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-workteamname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setWorkteamName(final java.lang.String value) {
        this.jsiiSet("workteamName", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CognitoMemberDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoClientId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html#cfn-sagemaker-workteam-cognitomemberdefinition-cognitoclientid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCognitoClientId();

        /**
         * `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoUserGroup`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html#cfn-sagemaker-workteam-cognitomemberdefinition-cognitousergroup
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCognitoUserGroup();

        /**
         * `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoUserPool`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html#cfn-sagemaker-workteam-cognitomemberdefinition-cognitouserpool
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCognitoUserPool();

        /**
         * @return a {@link Builder} of {@link CognitoMemberDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CognitoMemberDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String cognitoClientId;
            private java.lang.String cognitoUserGroup;
            private java.lang.String cognitoUserPool;

            /**
             * Sets the value of CognitoClientId
             * @param cognitoClientId `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoClientId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cognitoClientId(java.lang.String cognitoClientId) {
                this.cognitoClientId = cognitoClientId;
                return this;
            }

            /**
             * Sets the value of CognitoUserGroup
             * @param cognitoUserGroup `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoUserGroup`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cognitoUserGroup(java.lang.String cognitoUserGroup) {
                this.cognitoUserGroup = cognitoUserGroup;
                return this;
            }

            /**
             * Sets the value of CognitoUserPool
             * @param cognitoUserPool `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoUserPool`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cognitoUserPool(java.lang.String cognitoUserPool) {
                this.cognitoUserPool = cognitoUserPool;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CognitoMemberDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CognitoMemberDefinitionProperty build() {
                return new Jsii$Proxy(cognitoClientId, cognitoUserGroup, cognitoUserPool);
            }
        }

        /**
         * An implementation for {@link CognitoMemberDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CognitoMemberDefinitionProperty {
            private final java.lang.String cognitoClientId;
            private final java.lang.String cognitoUserGroup;
            private final java.lang.String cognitoUserPool;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.cognitoClientId = this.jsiiGet("cognitoClientId", java.lang.String.class);
                this.cognitoUserGroup = this.jsiiGet("cognitoUserGroup", java.lang.String.class);
                this.cognitoUserPool = this.jsiiGet("cognitoUserPool", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String cognitoClientId, java.lang.String cognitoUserGroup, java.lang.String cognitoUserPool) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cognitoClientId = java.util.Objects.requireNonNull(cognitoClientId, "cognitoClientId is required");
                this.cognitoUserGroup = java.util.Objects.requireNonNull(cognitoUserGroup, "cognitoUserGroup is required");
                this.cognitoUserPool = java.util.Objects.requireNonNull(cognitoUserPool, "cognitoUserPool is required");
            }

            @Override
            public java.lang.String getCognitoClientId() {
                return this.cognitoClientId;
            }

            @Override
            public java.lang.String getCognitoUserGroup() {
                return this.cognitoUserGroup;
            }

            @Override
            public java.lang.String getCognitoUserPool() {
                return this.cognitoUserPool;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("cognitoClientId", om.valueToTree(this.getCognitoClientId()));
                obj.set("cognitoUserGroup", om.valueToTree(this.getCognitoUserGroup()));
                obj.set("cognitoUserPool", om.valueToTree(this.getCognitoUserPool()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CognitoMemberDefinitionProperty.Jsii$Proxy that = (CognitoMemberDefinitionProperty.Jsii$Proxy) o;

                if (!cognitoClientId.equals(that.cognitoClientId)) return false;
                if (!cognitoUserGroup.equals(that.cognitoUserGroup)) return false;
                return this.cognitoUserPool.equals(that.cognitoUserPool);
            }

            @Override
            public int hashCode() {
                int result = this.cognitoClientId.hashCode();
                result = 31 * result + (this.cognitoUserGroup.hashCode());
                result = 31 * result + (this.cognitoUserPool.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-memberdefinition.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface MemberDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnWorkteam.MemberDefinitionProperty.CognitoMemberDefinition`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-memberdefinition.html#cfn-sagemaker-workteam-memberdefinition-cognitomemberdefinition
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getCognitoMemberDefinition();

        /**
         * @return a {@link Builder} of {@link MemberDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemberDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object cognitoMemberDefinition;

            /**
             * Sets the value of CognitoMemberDefinition
             * @param cognitoMemberDefinition `CfnWorkteam.MemberDefinitionProperty.CognitoMemberDefinition`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cognitoMemberDefinition(software.amazon.awscdk.core.IResolvable cognitoMemberDefinition) {
                this.cognitoMemberDefinition = cognitoMemberDefinition;
                return this;
            }

            /**
             * Sets the value of CognitoMemberDefinition
             * @param cognitoMemberDefinition `CfnWorkteam.MemberDefinitionProperty.CognitoMemberDefinition`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cognitoMemberDefinition(software.amazon.awscdk.services.sagemaker.CfnWorkteam.CognitoMemberDefinitionProperty cognitoMemberDefinition) {
                this.cognitoMemberDefinition = cognitoMemberDefinition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemberDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public MemberDefinitionProperty build() {
                return new Jsii$Proxy(cognitoMemberDefinition);
            }
        }

        /**
         * An implementation for {@link MemberDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemberDefinitionProperty {
            private final java.lang.Object cognitoMemberDefinition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.cognitoMemberDefinition = this.jsiiGet("cognitoMemberDefinition", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object cognitoMemberDefinition) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cognitoMemberDefinition = java.util.Objects.requireNonNull(cognitoMemberDefinition, "cognitoMemberDefinition is required");
            }

            @Override
            public java.lang.Object getCognitoMemberDefinition() {
                return this.cognitoMemberDefinition;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("cognitoMemberDefinition", om.valueToTree(this.getCognitoMemberDefinition()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemberDefinitionProperty.Jsii$Proxy that = (MemberDefinitionProperty.Jsii$Proxy) o;

                return this.cognitoMemberDefinition.equals(that.cognitoMemberDefinition);
            }

            @Override
            public int hashCode() {
                int result = this.cognitoMemberDefinition.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-notificationconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface NotificationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnWorkteam.NotificationConfigurationProperty.NotificationTopicArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-notificationconfiguration.html#cfn-sagemaker-workteam-notificationconfiguration-notificationtopicarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getNotificationTopicArn();

        /**
         * @return a {@link Builder} of {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String notificationTopicArn;

            /**
             * Sets the value of NotificationTopicArn
             * @param notificationTopicArn `CfnWorkteam.NotificationConfigurationProperty.NotificationTopicArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder notificationTopicArn(java.lang.String notificationTopicArn) {
                this.notificationTopicArn = notificationTopicArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public NotificationConfigurationProperty build() {
                return new Jsii$Proxy(notificationTopicArn);
            }
        }

        /**
         * An implementation for {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationConfigurationProperty {
            private final java.lang.String notificationTopicArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.notificationTopicArn = this.jsiiGet("notificationTopicArn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String notificationTopicArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.notificationTopicArn = java.util.Objects.requireNonNull(notificationTopicArn, "notificationTopicArn is required");
            }

            @Override
            public java.lang.String getNotificationTopicArn() {
                return this.notificationTopicArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("notificationTopicArn", om.valueToTree(this.getNotificationTopicArn()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotificationConfigurationProperty.Jsii$Proxy that = (NotificationConfigurationProperty.Jsii$Proxy) o;

                return this.notificationTopicArn.equals(that.notificationTopicArn);
            }

            @Override
            public int hashCode() {
                int result = this.notificationTopicArn.hashCode();
                return result;
            }
        }
    }
}
