package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a `AWS::SageMaker::EndpointConfig`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnEndpointConfigProps cfnEndpointConfigProps = CfnEndpointConfigProps.builder()
 *         .productionVariants(List.of(ProductionVariantProperty.builder()
 *                 .initialVariantWeight(123)
 *                 .modelName("modelName")
 *                 .variantName("variantName")
 *                 // the properties below are optional
 *                 .acceleratorType("acceleratorType")
 *                 .initialInstanceCount(123)
 *                 .instanceType("instanceType")
 *                 .serverlessConfig(ServerlessConfigProperty.builder()
 *                         .maxConcurrency(123)
 *                         .memorySizeInMb(123)
 *                         .build())
 *                 .build()))
 *         // the properties below are optional
 *         .asyncInferenceConfig(AsyncInferenceConfigProperty.builder()
 *                 .outputConfig(AsyncInferenceOutputConfigProperty.builder()
 *                         .s3OutputPath("s3OutputPath")
 *                         // the properties below are optional
 *                         .kmsKeyId("kmsKeyId")
 *                         .notificationConfig(AsyncInferenceNotificationConfigProperty.builder()
 *                                 .errorTopic("errorTopic")
 *                                 .successTopic("successTopic")
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .clientConfig(AsyncInferenceClientConfigProperty.builder()
 *                         .maxConcurrentInvocationsPerInstance(123)
 *                         .build())
 *                 .build())
 *         .dataCaptureConfig(DataCaptureConfigProperty.builder()
 *                 .captureOptions(List.of(CaptureOptionProperty.builder()
 *                         .captureMode("captureMode")
 *                         .build()))
 *                 .destinationS3Uri("destinationS3Uri")
 *                 .initialSamplingPercentage(123)
 *                 // the properties below are optional
 *                 .captureContentTypeHeader(CaptureContentTypeHeaderProperty.builder()
 *                         .csvContentTypes(List.of("csvContentTypes"))
 *                         .jsonContentTypes(List.of("jsonContentTypes"))
 *                         .build())
 *                 .enableCapture(false)
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .endpointConfigName("endpointConfigName")
 *         .kmsKeyId("kmsKeyId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-10T18:02:00.017Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnEndpointConfigProps")
@software.amazon.jsii.Jsii.Proxy(CfnEndpointConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEndpointConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::SageMaker::EndpointConfig.AsyncInferenceConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAsyncInferenceConfig() {
        return null;
    }

    /**
     * `AWS::SageMaker::EndpointConfig.DataCaptureConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataCaptureConfig() {
        return null;
    }

    /**
     * `AWS::SageMaker::EndpointConfig.EndpointConfigName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndpointConfigName() {
        return null;
    }

    /**
     * `AWS::SageMaker::EndpointConfig.KmsKeyId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * `AWS::SageMaker::EndpointConfig.ProductionVariants`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getProductionVariants();

    /**
     * `AWS::SageMaker::EndpointConfig.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEndpointConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEndpointConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEndpointConfigProps> {
        java.lang.Object asyncInferenceConfig;
        java.lang.Object dataCaptureConfig;
        java.lang.String endpointConfigName;
        java.lang.String kmsKeyId;
        java.lang.Object productionVariants;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getAsyncInferenceConfig}
         * @param asyncInferenceConfig `AWS::SageMaker::EndpointConfig.AsyncInferenceConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder asyncInferenceConfig(software.amazon.awscdk.core.IResolvable asyncInferenceConfig) {
            this.asyncInferenceConfig = asyncInferenceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getAsyncInferenceConfig}
         * @param asyncInferenceConfig `AWS::SageMaker::EndpointConfig.AsyncInferenceConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder asyncInferenceConfig(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty asyncInferenceConfig) {
            this.asyncInferenceConfig = asyncInferenceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getDataCaptureConfig}
         * @param dataCaptureConfig `AWS::SageMaker::EndpointConfig.DataCaptureConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCaptureConfig(software.amazon.awscdk.core.IResolvable dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getDataCaptureConfig}
         * @param dataCaptureConfig `AWS::SageMaker::EndpointConfig.DataCaptureConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCaptureConfig(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.DataCaptureConfigProperty dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getEndpointConfigName}
         * @param endpointConfigName `AWS::SageMaker::EndpointConfig.EndpointConfigName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfigName(java.lang.String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getKmsKeyId}
         * @param kmsKeyId `AWS::SageMaker::EndpointConfig.KmsKeyId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getProductionVariants}
         * @param productionVariants `AWS::SageMaker::EndpointConfig.ProductionVariants`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productionVariants(software.amazon.awscdk.core.IResolvable productionVariants) {
            this.productionVariants = productionVariants;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getProductionVariants}
         * @param productionVariants `AWS::SageMaker::EndpointConfig.ProductionVariants`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productionVariants(java.util.List<? extends java.lang.Object> productionVariants) {
            this.productionVariants = productionVariants;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getTags}
         * @param tags `AWS::SageMaker::EndpointConfig.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEndpointConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEndpointConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEndpointConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEndpointConfigProps {
        private final java.lang.Object asyncInferenceConfig;
        private final java.lang.Object dataCaptureConfig;
        private final java.lang.String endpointConfigName;
        private final java.lang.String kmsKeyId;
        private final java.lang.Object productionVariants;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.asyncInferenceConfig = software.amazon.jsii.Kernel.get(this, "asyncInferenceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataCaptureConfig = software.amazon.jsii.Kernel.get(this, "dataCaptureConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.endpointConfigName = software.amazon.jsii.Kernel.get(this, "endpointConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.productionVariants = software.amazon.jsii.Kernel.get(this, "productionVariants", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.asyncInferenceConfig = builder.asyncInferenceConfig;
            this.dataCaptureConfig = builder.dataCaptureConfig;
            this.endpointConfigName = builder.endpointConfigName;
            this.kmsKeyId = builder.kmsKeyId;
            this.productionVariants = java.util.Objects.requireNonNull(builder.productionVariants, "productionVariants is required");
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getAsyncInferenceConfig() {
            return this.asyncInferenceConfig;
        }

        @Override
        public final java.lang.Object getDataCaptureConfig() {
            return this.dataCaptureConfig;
        }

        @Override
        public final java.lang.String getEndpointConfigName() {
            return this.endpointConfigName;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.Object getProductionVariants() {
            return this.productionVariants;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAsyncInferenceConfig() != null) {
                data.set("asyncInferenceConfig", om.valueToTree(this.getAsyncInferenceConfig()));
            }
            if (this.getDataCaptureConfig() != null) {
                data.set("dataCaptureConfig", om.valueToTree(this.getDataCaptureConfig()));
            }
            if (this.getEndpointConfigName() != null) {
                data.set("endpointConfigName", om.valueToTree(this.getEndpointConfigName()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            data.set("productionVariants", om.valueToTree(this.getProductionVariants()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnEndpointConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEndpointConfigProps.Jsii$Proxy that = (CfnEndpointConfigProps.Jsii$Proxy) o;

            if (this.asyncInferenceConfig != null ? !this.asyncInferenceConfig.equals(that.asyncInferenceConfig) : that.asyncInferenceConfig != null) return false;
            if (this.dataCaptureConfig != null ? !this.dataCaptureConfig.equals(that.dataCaptureConfig) : that.dataCaptureConfig != null) return false;
            if (this.endpointConfigName != null ? !this.endpointConfigName.equals(that.endpointConfigName) : that.endpointConfigName != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (!productionVariants.equals(that.productionVariants)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.asyncInferenceConfig != null ? this.asyncInferenceConfig.hashCode() : 0;
            result = 31 * result + (this.dataCaptureConfig != null ? this.dataCaptureConfig.hashCode() : 0);
            result = 31 * result + (this.endpointConfigName != null ? this.endpointConfigName.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.productionVariants.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
