package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a `AWS::SageMaker::Endpoint`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnEndpointProps cfnEndpointProps = CfnEndpointProps.builder()
 *         .endpointConfigName("endpointConfigName")
 *         // the properties below are optional
 *         .deploymentConfig(DeploymentConfigProperty.builder()
 *                 .blueGreenUpdatePolicy(BlueGreenUpdatePolicyProperty.builder()
 *                         .trafficRoutingConfiguration(TrafficRoutingConfigProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .canarySize(CapacitySizeProperty.builder()
 *                                         .type("type")
 *                                         .value(123)
 *                                         .build())
 *                                 .linearStepSize(CapacitySizeProperty.builder()
 *                                         .type("type")
 *                                         .value(123)
 *                                         .build())
 *                                 .waitIntervalInSeconds(123)
 *                                 .build())
 *                         // the properties below are optional
 *                         .maximumExecutionTimeoutInSeconds(123)
 *                         .terminationWaitInSeconds(123)
 *                         .build())
 *                 // the properties below are optional
 *                 .autoRollbackConfiguration(AutoRollbackConfigProperty.builder()
 *                         .alarms(List.of(AlarmProperty.builder()
 *                                 .alarmName("alarmName")
 *                                 .build()))
 *                         .build())
 *                 .build())
 *         .endpointName("endpointName")
 *         .excludeRetainedVariantProperties(List.of(VariantPropertyProperty.builder()
 *                 .variantPropertyType("variantPropertyType")
 *                 .build()))
 *         .retainAllVariantProperties(false)
 *         .retainDeploymentConfig(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-10T18:02:00.017Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnEndpointProps")
@software.amazon.jsii.Jsii.Proxy(CfnEndpointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEndpointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::SageMaker::Endpoint.DeploymentConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentConfig() {
        return null;
    }

    /**
     * `AWS::SageMaker::Endpoint.EndpointConfigName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEndpointConfigName();

    /**
     * `AWS::SageMaker::Endpoint.EndpointName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndpointName() {
        return null;
    }

    /**
     * `AWS::SageMaker::Endpoint.ExcludeRetainedVariantProperties`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getExcludeRetainedVariantProperties() {
        return null;
    }

    /**
     * `AWS::SageMaker::Endpoint.RetainAllVariantProperties`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRetainAllVariantProperties() {
        return null;
    }

    /**
     * `AWS::SageMaker::Endpoint.RetainDeploymentConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRetainDeploymentConfig() {
        return null;
    }

    /**
     * `AWS::SageMaker::Endpoint.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEndpointProps> {
        java.lang.Object deploymentConfig;
        java.lang.String endpointConfigName;
        java.lang.String endpointName;
        java.lang.Object excludeRetainedVariantProperties;
        java.lang.Object retainAllVariantProperties;
        java.lang.Object retainDeploymentConfig;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnEndpointProps#getDeploymentConfig}
         * @param deploymentConfig `AWS::SageMaker::Endpoint.DeploymentConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfig(software.amazon.awscdk.core.IResolvable deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getDeploymentConfig}
         * @param deploymentConfig `AWS::SageMaker::Endpoint.DeploymentConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfig(software.amazon.awscdk.services.sagemaker.CfnEndpoint.DeploymentConfigProperty deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getEndpointConfigName}
         * @param endpointConfigName `AWS::SageMaker::Endpoint.EndpointConfigName`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfigName(java.lang.String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getEndpointName}
         * @param endpointName `AWS::SageMaker::Endpoint.EndpointName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointName(java.lang.String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getExcludeRetainedVariantProperties}
         * @param excludeRetainedVariantProperties `AWS::SageMaker::Endpoint.ExcludeRetainedVariantProperties`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeRetainedVariantProperties(software.amazon.awscdk.core.IResolvable excludeRetainedVariantProperties) {
            this.excludeRetainedVariantProperties = excludeRetainedVariantProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getExcludeRetainedVariantProperties}
         * @param excludeRetainedVariantProperties `AWS::SageMaker::Endpoint.ExcludeRetainedVariantProperties`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeRetainedVariantProperties(java.util.List<? extends java.lang.Object> excludeRetainedVariantProperties) {
            this.excludeRetainedVariantProperties = excludeRetainedVariantProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getRetainAllVariantProperties}
         * @param retainAllVariantProperties `AWS::SageMaker::Endpoint.RetainAllVariantProperties`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainAllVariantProperties(java.lang.Boolean retainAllVariantProperties) {
            this.retainAllVariantProperties = retainAllVariantProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getRetainAllVariantProperties}
         * @param retainAllVariantProperties `AWS::SageMaker::Endpoint.RetainAllVariantProperties`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainAllVariantProperties(software.amazon.awscdk.core.IResolvable retainAllVariantProperties) {
            this.retainAllVariantProperties = retainAllVariantProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getRetainDeploymentConfig}
         * @param retainDeploymentConfig `AWS::SageMaker::Endpoint.RetainDeploymentConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainDeploymentConfig(java.lang.Boolean retainDeploymentConfig) {
            this.retainDeploymentConfig = retainDeploymentConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getRetainDeploymentConfig}
         * @param retainDeploymentConfig `AWS::SageMaker::Endpoint.RetainDeploymentConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainDeploymentConfig(software.amazon.awscdk.core.IResolvable retainDeploymentConfig) {
            this.retainDeploymentConfig = retainDeploymentConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getTags}
         * @param tags `AWS::SageMaker::Endpoint.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEndpointProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEndpointProps {
        private final java.lang.Object deploymentConfig;
        private final java.lang.String endpointConfigName;
        private final java.lang.String endpointName;
        private final java.lang.Object excludeRetainedVariantProperties;
        private final java.lang.Object retainAllVariantProperties;
        private final java.lang.Object retainDeploymentConfig;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deploymentConfig = software.amazon.jsii.Kernel.get(this, "deploymentConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.endpointConfigName = software.amazon.jsii.Kernel.get(this, "endpointConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endpointName = software.amazon.jsii.Kernel.get(this, "endpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.excludeRetainedVariantProperties = software.amazon.jsii.Kernel.get(this, "excludeRetainedVariantProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.retainAllVariantProperties = software.amazon.jsii.Kernel.get(this, "retainAllVariantProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.retainDeploymentConfig = software.amazon.jsii.Kernel.get(this, "retainDeploymentConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deploymentConfig = builder.deploymentConfig;
            this.endpointConfigName = java.util.Objects.requireNonNull(builder.endpointConfigName, "endpointConfigName is required");
            this.endpointName = builder.endpointName;
            this.excludeRetainedVariantProperties = builder.excludeRetainedVariantProperties;
            this.retainAllVariantProperties = builder.retainAllVariantProperties;
            this.retainDeploymentConfig = builder.retainDeploymentConfig;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getDeploymentConfig() {
            return this.deploymentConfig;
        }

        @Override
        public final java.lang.String getEndpointConfigName() {
            return this.endpointConfigName;
        }

        @Override
        public final java.lang.String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final java.lang.Object getExcludeRetainedVariantProperties() {
            return this.excludeRetainedVariantProperties;
        }

        @Override
        public final java.lang.Object getRetainAllVariantProperties() {
            return this.retainAllVariantProperties;
        }

        @Override
        public final java.lang.Object getRetainDeploymentConfig() {
            return this.retainDeploymentConfig;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDeploymentConfig() != null) {
                data.set("deploymentConfig", om.valueToTree(this.getDeploymentConfig()));
            }
            data.set("endpointConfigName", om.valueToTree(this.getEndpointConfigName()));
            if (this.getEndpointName() != null) {
                data.set("endpointName", om.valueToTree(this.getEndpointName()));
            }
            if (this.getExcludeRetainedVariantProperties() != null) {
                data.set("excludeRetainedVariantProperties", om.valueToTree(this.getExcludeRetainedVariantProperties()));
            }
            if (this.getRetainAllVariantProperties() != null) {
                data.set("retainAllVariantProperties", om.valueToTree(this.getRetainAllVariantProperties()));
            }
            if (this.getRetainDeploymentConfig() != null) {
                data.set("retainDeploymentConfig", om.valueToTree(this.getRetainDeploymentConfig()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnEndpointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEndpointProps.Jsii$Proxy that = (CfnEndpointProps.Jsii$Proxy) o;

            if (this.deploymentConfig != null ? !this.deploymentConfig.equals(that.deploymentConfig) : that.deploymentConfig != null) return false;
            if (!endpointConfigName.equals(that.endpointConfigName)) return false;
            if (this.endpointName != null ? !this.endpointName.equals(that.endpointName) : that.endpointName != null) return false;
            if (this.excludeRetainedVariantProperties != null ? !this.excludeRetainedVariantProperties.equals(that.excludeRetainedVariantProperties) : that.excludeRetainedVariantProperties != null) return false;
            if (this.retainAllVariantProperties != null ? !this.retainAllVariantProperties.equals(that.retainAllVariantProperties) : that.retainAllVariantProperties != null) return false;
            if (this.retainDeploymentConfig != null ? !this.retainDeploymentConfig.equals(that.retainDeploymentConfig) : that.retainDeploymentConfig != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.deploymentConfig != null ? this.deploymentConfig.hashCode() : 0;
            result = 31 * result + (this.endpointConfigName.hashCode());
            result = 31 * result + (this.endpointName != null ? this.endpointName.hashCode() : 0);
            result = 31 * result + (this.excludeRetainedVariantProperties != null ? this.excludeRetainedVariantProperties.hashCode() : 0);
            result = 31 * result + (this.retainAllVariantProperties != null ? this.retainAllVariantProperties.hashCode() : 0);
            result = 31 * result + (this.retainDeploymentConfig != null ? this.retainDeploymentConfig.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
