package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a `AWS::SageMaker::ModelBiasJobDefinition`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnModelBiasJobDefinitionProps cfnModelBiasJobDefinitionProps = CfnModelBiasJobDefinitionProps.builder()
 *         .jobResources(MonitoringResourcesProperty.builder()
 *                 .clusterConfig(ClusterConfigProperty.builder()
 *                         .instanceCount(123)
 *                         .instanceType("instanceType")
 *                         .volumeSizeInGb(123)
 *                         // the properties below are optional
 *                         .volumeKmsKeyId("volumeKmsKeyId")
 *                         .build())
 *                 .build())
 *         .modelBiasAppSpecification(ModelBiasAppSpecificationProperty.builder()
 *                 .configUri("configUri")
 *                 .imageUri("imageUri")
 *                 // the properties below are optional
 *                 .environment(Map.of(
 *                         "environmentKey", "environment"))
 *                 .build())
 *         .modelBiasJobInput(ModelBiasJobInputProperty.builder()
 *                 .endpointInput(EndpointInputProperty.builder()
 *                         .endpointName("endpointName")
 *                         .localPath("localPath")
 *                         // the properties below are optional
 *                         .endTimeOffset("endTimeOffset")
 *                         .featuresAttribute("featuresAttribute")
 *                         .inferenceAttribute("inferenceAttribute")
 *                         .probabilityAttribute("probabilityAttribute")
 *                         .probabilityThresholdAttribute(123)
 *                         .s3DataDistributionType("s3DataDistributionType")
 *                         .s3InputMode("s3InputMode")
 *                         .startTimeOffset("startTimeOffset")
 *                         .build())
 *                 .groundTruthS3Input(MonitoringGroundTruthS3InputProperty.builder()
 *                         .s3Uri("s3Uri")
 *                         .build())
 *                 .build())
 *         .modelBiasJobOutputConfig(MonitoringOutputConfigProperty.builder()
 *                 .monitoringOutputs(List.of(MonitoringOutputProperty.builder()
 *                         .s3Output(S3OutputProperty.builder()
 *                                 .localPath("localPath")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .s3UploadMode("s3UploadMode")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .jobDefinitionName("jobDefinitionName")
 *         .modelBiasBaselineConfig(ModelBiasBaselineConfigProperty.builder()
 *                 .baseliningJobName("baseliningJobName")
 *                 .constraintsResource(ConstraintsResourceProperty.builder()
 *                         .s3Uri("s3Uri")
 *                         .build())
 *                 .build())
 *         .networkConfig(NetworkConfigProperty.builder()
 *                 .enableInterContainerTrafficEncryption(false)
 *                 .enableNetworkIsolation(false)
 *                 .vpcConfig(VpcConfigProperty.builder()
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnets(List.of("subnets"))
 *                         .build())
 *                 .build())
 *         .stoppingCondition(StoppingConditionProperty.builder()
 *                 .maxRuntimeInSeconds(123)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-10T18:02:00.025Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(CfnModelBiasJobDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnModelBiasJobDefinitionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.JobDefinitionName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getJobDefinitionName() {
        return null;
    }

    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.JobResources`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getJobResources();

    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasAppSpecification`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getModelBiasAppSpecification();

    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasBaselineConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getModelBiasBaselineConfig() {
        return null;
    }

    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasJobInput`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getModelBiasJobInput();

    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasJobOutputConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getModelBiasJobOutputConfig();

    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.NetworkConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfig() {
        return null;
    }

    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.RoleArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.StoppingCondition`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStoppingCondition() {
        return null;
    }

    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnModelBiasJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnModelBiasJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnModelBiasJobDefinitionProps> {
        java.lang.String jobDefinitionName;
        java.lang.Object jobResources;
        java.lang.Object modelBiasAppSpecification;
        java.lang.Object modelBiasBaselineConfig;
        java.lang.Object modelBiasJobInput;
        java.lang.Object modelBiasJobOutputConfig;
        java.lang.Object networkConfig;
        java.lang.String roleArn;
        java.lang.Object stoppingCondition;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnModelBiasJobDefinitionProps#getJobDefinitionName}
         * @param jobDefinitionName `AWS::SageMaker::ModelBiasJobDefinition.JobDefinitionName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDefinitionName(java.lang.String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelBiasJobDefinitionProps#getJobResources}
         * @param jobResources `AWS::SageMaker::ModelBiasJobDefinition.JobResources`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobResources(software.amazon.awscdk.core.IResolvable jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelBiasJobDefinitionProps#getJobResources}
         * @param jobResources `AWS::SageMaker::ModelBiasJobDefinition.JobResources`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobResources(software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.MonitoringResourcesProperty jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelBiasJobDefinitionProps#getModelBiasAppSpecification}
         * @param modelBiasAppSpecification `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasAppSpecification`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelBiasAppSpecification(software.amazon.awscdk.core.IResolvable modelBiasAppSpecification) {
            this.modelBiasAppSpecification = modelBiasAppSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelBiasJobDefinitionProps#getModelBiasAppSpecification}
         * @param modelBiasAppSpecification `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasAppSpecification`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelBiasAppSpecification(software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty modelBiasAppSpecification) {
            this.modelBiasAppSpecification = modelBiasAppSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelBiasJobDefinitionProps#getModelBiasBaselineConfig}
         * @param modelBiasBaselineConfig `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasBaselineConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelBiasBaselineConfig(software.amazon.awscdk.core.IResolvable modelBiasBaselineConfig) {
            this.modelBiasBaselineConfig = modelBiasBaselineConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelBiasJobDefinitionProps#getModelBiasBaselineConfig}
         * @param modelBiasBaselineConfig `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasBaselineConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelBiasBaselineConfig(software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty modelBiasBaselineConfig) {
            this.modelBiasBaselineConfig = modelBiasBaselineConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelBiasJobDefinitionProps#getModelBiasJobInput}
         * @param modelBiasJobInput `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasJobInput`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelBiasJobInput(software.amazon.awscdk.core.IResolvable modelBiasJobInput) {
            this.modelBiasJobInput = modelBiasJobInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelBiasJobDefinitionProps#getModelBiasJobInput}
         * @param modelBiasJobInput `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasJobInput`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelBiasJobInput(software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.ModelBiasJobInputProperty modelBiasJobInput) {
            this.modelBiasJobInput = modelBiasJobInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelBiasJobDefinitionProps#getModelBiasJobOutputConfig}
         * @param modelBiasJobOutputConfig `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasJobOutputConfig`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelBiasJobOutputConfig(software.amazon.awscdk.core.IResolvable modelBiasJobOutputConfig) {
            this.modelBiasJobOutputConfig = modelBiasJobOutputConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelBiasJobDefinitionProps#getModelBiasJobOutputConfig}
         * @param modelBiasJobOutputConfig `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasJobOutputConfig`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelBiasJobOutputConfig(software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.MonitoringOutputConfigProperty modelBiasJobOutputConfig) {
            this.modelBiasJobOutputConfig = modelBiasJobOutputConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelBiasJobDefinitionProps#getNetworkConfig}
         * @param networkConfig `AWS::SageMaker::ModelBiasJobDefinition.NetworkConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfig(software.amazon.awscdk.core.IResolvable networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelBiasJobDefinitionProps#getNetworkConfig}
         * @param networkConfig `AWS::SageMaker::ModelBiasJobDefinition.NetworkConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfig(software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.NetworkConfigProperty networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelBiasJobDefinitionProps#getRoleArn}
         * @param roleArn `AWS::SageMaker::ModelBiasJobDefinition.RoleArn`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelBiasJobDefinitionProps#getStoppingCondition}
         * @param stoppingCondition `AWS::SageMaker::ModelBiasJobDefinition.StoppingCondition`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stoppingCondition(software.amazon.awscdk.core.IResolvable stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelBiasJobDefinitionProps#getStoppingCondition}
         * @param stoppingCondition `AWS::SageMaker::ModelBiasJobDefinition.StoppingCondition`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stoppingCondition(software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.StoppingConditionProperty stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelBiasJobDefinitionProps#getTags}
         * @param tags `AWS::SageMaker::ModelBiasJobDefinition.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnModelBiasJobDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnModelBiasJobDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnModelBiasJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnModelBiasJobDefinitionProps {
        private final java.lang.String jobDefinitionName;
        private final java.lang.Object jobResources;
        private final java.lang.Object modelBiasAppSpecification;
        private final java.lang.Object modelBiasBaselineConfig;
        private final java.lang.Object modelBiasJobInput;
        private final java.lang.Object modelBiasJobOutputConfig;
        private final java.lang.Object networkConfig;
        private final java.lang.String roleArn;
        private final java.lang.Object stoppingCondition;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.jobDefinitionName = software.amazon.jsii.Kernel.get(this, "jobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.jobResources = software.amazon.jsii.Kernel.get(this, "jobResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.modelBiasAppSpecification = software.amazon.jsii.Kernel.get(this, "modelBiasAppSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.modelBiasBaselineConfig = software.amazon.jsii.Kernel.get(this, "modelBiasBaselineConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.modelBiasJobInput = software.amazon.jsii.Kernel.get(this, "modelBiasJobInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.modelBiasJobOutputConfig = software.amazon.jsii.Kernel.get(this, "modelBiasJobOutputConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.networkConfig = software.amazon.jsii.Kernel.get(this, "networkConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stoppingCondition = software.amazon.jsii.Kernel.get(this, "stoppingCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.jobDefinitionName = builder.jobDefinitionName;
            this.jobResources = java.util.Objects.requireNonNull(builder.jobResources, "jobResources is required");
            this.modelBiasAppSpecification = java.util.Objects.requireNonNull(builder.modelBiasAppSpecification, "modelBiasAppSpecification is required");
            this.modelBiasBaselineConfig = builder.modelBiasBaselineConfig;
            this.modelBiasJobInput = java.util.Objects.requireNonNull(builder.modelBiasJobInput, "modelBiasJobInput is required");
            this.modelBiasJobOutputConfig = java.util.Objects.requireNonNull(builder.modelBiasJobOutputConfig, "modelBiasJobOutputConfig is required");
            this.networkConfig = builder.networkConfig;
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.stoppingCondition = builder.stoppingCondition;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        @Override
        public final java.lang.Object getJobResources() {
            return this.jobResources;
        }

        @Override
        public final java.lang.Object getModelBiasAppSpecification() {
            return this.modelBiasAppSpecification;
        }

        @Override
        public final java.lang.Object getModelBiasBaselineConfig() {
            return this.modelBiasBaselineConfig;
        }

        @Override
        public final java.lang.Object getModelBiasJobInput() {
            return this.modelBiasJobInput;
        }

        @Override
        public final java.lang.Object getModelBiasJobOutputConfig() {
            return this.modelBiasJobOutputConfig;
        }

        @Override
        public final java.lang.Object getNetworkConfig() {
            return this.networkConfig;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getStoppingCondition() {
            return this.stoppingCondition;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getJobDefinitionName() != null) {
                data.set("jobDefinitionName", om.valueToTree(this.getJobDefinitionName()));
            }
            data.set("jobResources", om.valueToTree(this.getJobResources()));
            data.set("modelBiasAppSpecification", om.valueToTree(this.getModelBiasAppSpecification()));
            if (this.getModelBiasBaselineConfig() != null) {
                data.set("modelBiasBaselineConfig", om.valueToTree(this.getModelBiasBaselineConfig()));
            }
            data.set("modelBiasJobInput", om.valueToTree(this.getModelBiasJobInput()));
            data.set("modelBiasJobOutputConfig", om.valueToTree(this.getModelBiasJobOutputConfig()));
            if (this.getNetworkConfig() != null) {
                data.set("networkConfig", om.valueToTree(this.getNetworkConfig()));
            }
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getStoppingCondition() != null) {
                data.set("stoppingCondition", om.valueToTree(this.getStoppingCondition()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnModelBiasJobDefinitionProps.Jsii$Proxy that = (CfnModelBiasJobDefinitionProps.Jsii$Proxy) o;

            if (this.jobDefinitionName != null ? !this.jobDefinitionName.equals(that.jobDefinitionName) : that.jobDefinitionName != null) return false;
            if (!jobResources.equals(that.jobResources)) return false;
            if (!modelBiasAppSpecification.equals(that.modelBiasAppSpecification)) return false;
            if (this.modelBiasBaselineConfig != null ? !this.modelBiasBaselineConfig.equals(that.modelBiasBaselineConfig) : that.modelBiasBaselineConfig != null) return false;
            if (!modelBiasJobInput.equals(that.modelBiasJobInput)) return false;
            if (!modelBiasJobOutputConfig.equals(that.modelBiasJobOutputConfig)) return false;
            if (this.networkConfig != null ? !this.networkConfig.equals(that.networkConfig) : that.networkConfig != null) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.stoppingCondition != null ? !this.stoppingCondition.equals(that.stoppingCondition) : that.stoppingCondition != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.jobDefinitionName != null ? this.jobDefinitionName.hashCode() : 0;
            result = 31 * result + (this.jobResources.hashCode());
            result = 31 * result + (this.modelBiasAppSpecification.hashCode());
            result = 31 * result + (this.modelBiasBaselineConfig != null ? this.modelBiasBaselineConfig.hashCode() : 0);
            result = 31 * result + (this.modelBiasJobInput.hashCode());
            result = 31 * result + (this.modelBiasJobOutputConfig.hashCode());
            result = 31 * result + (this.networkConfig != null ? this.networkConfig.hashCode() : 0);
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.stoppingCondition != null ? this.stoppingCondition.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
