package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnModelExplainabilityJobDefinitionProps cfnModelExplainabilityJobDefinitionProps = CfnModelExplainabilityJobDefinitionProps.builder()
 *         .jobResources(MonitoringResourcesProperty.builder()
 *                 .clusterConfig(ClusterConfigProperty.builder()
 *                         .instanceCount(123)
 *                         .instanceType("instanceType")
 *                         .volumeSizeInGb(123)
 *                         // the properties below are optional
 *                         .volumeKmsKeyId("volumeKmsKeyId")
 *                         .build())
 *                 .build())
 *         .modelExplainabilityAppSpecification(ModelExplainabilityAppSpecificationProperty.builder()
 *                 .configUri("configUri")
 *                 .imageUri("imageUri")
 *                 // the properties below are optional
 *                 .environment(Map.of(
 *                         "environmentKey", "environment"))
 *                 .build())
 *         .modelExplainabilityJobInput(ModelExplainabilityJobInputProperty.builder()
 *                 .endpointInput(EndpointInputProperty.builder()
 *                         .endpointName("endpointName")
 *                         .localPath("localPath")
 *                         // the properties below are optional
 *                         .featuresAttribute("featuresAttribute")
 *                         .inferenceAttribute("inferenceAttribute")
 *                         .probabilityAttribute("probabilityAttribute")
 *                         .s3DataDistributionType("s3DataDistributionType")
 *                         .s3InputMode("s3InputMode")
 *                         .build())
 *                 .build())
 *         .modelExplainabilityJobOutputConfig(MonitoringOutputConfigProperty.builder()
 *                 .monitoringOutputs(List.of(MonitoringOutputProperty.builder()
 *                         .s3Output(S3OutputProperty.builder()
 *                                 .localPath("localPath")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .s3UploadMode("s3UploadMode")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .jobDefinitionName("jobDefinitionName")
 *         .modelExplainabilityBaselineConfig(ModelExplainabilityBaselineConfigProperty.builder()
 *                 .baseliningJobName("baseliningJobName")
 *                 .constraintsResource(ConstraintsResourceProperty.builder()
 *                         .s3Uri("s3Uri")
 *                         .build())
 *                 .build())
 *         .networkConfig(NetworkConfigProperty.builder()
 *                 .enableInterContainerTrafficEncryption(false)
 *                 .enableNetworkIsolation(false)
 *                 .vpcConfig(VpcConfigProperty.builder()
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnets(List.of("subnets"))
 *                         .build())
 *                 .build())
 *         .stoppingCondition(StoppingConditionProperty.builder()
 *                 .maxRuntimeInSeconds(123)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-10T18:02:00.028Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelExplainabilityJobDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(CfnModelExplainabilityJobDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnModelExplainabilityJobDefinitionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.JobDefinitionName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getJobDefinitionName() {
        return null;
    }

    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.JobResources`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getJobResources();

    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityAppSpecification`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getModelExplainabilityAppSpecification();

    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getModelExplainabilityBaselineConfig() {
        return null;
    }

    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityJobInput`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getModelExplainabilityJobInput();

    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityJobOutputConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getModelExplainabilityJobOutputConfig();

    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.NetworkConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfig() {
        return null;
    }

    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.RoleArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.StoppingCondition`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStoppingCondition() {
        return null;
    }

    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnModelExplainabilityJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnModelExplainabilityJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnModelExplainabilityJobDefinitionProps> {
        java.lang.String jobDefinitionName;
        java.lang.Object jobResources;
        java.lang.Object modelExplainabilityAppSpecification;
        java.lang.Object modelExplainabilityBaselineConfig;
        java.lang.Object modelExplainabilityJobInput;
        java.lang.Object modelExplainabilityJobOutputConfig;
        java.lang.Object networkConfig;
        java.lang.String roleArn;
        java.lang.Object stoppingCondition;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getJobDefinitionName}
         * @param jobDefinitionName `AWS::SageMaker::ModelExplainabilityJobDefinition.JobDefinitionName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDefinitionName(java.lang.String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getJobResources}
         * @param jobResources `AWS::SageMaker::ModelExplainabilityJobDefinition.JobResources`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobResources(software.amazon.awscdk.core.IResolvable jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getJobResources}
         * @param jobResources `AWS::SageMaker::ModelExplainabilityJobDefinition.JobResources`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobResources(software.amazon.awscdk.services.sagemaker.CfnModelExplainabilityJobDefinition.MonitoringResourcesProperty jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getModelExplainabilityAppSpecification}
         * @param modelExplainabilityAppSpecification `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityAppSpecification`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelExplainabilityAppSpecification(software.amazon.awscdk.core.IResolvable modelExplainabilityAppSpecification) {
            this.modelExplainabilityAppSpecification = modelExplainabilityAppSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getModelExplainabilityAppSpecification}
         * @param modelExplainabilityAppSpecification `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityAppSpecification`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelExplainabilityAppSpecification(software.amazon.awscdk.services.sagemaker.CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty modelExplainabilityAppSpecification) {
            this.modelExplainabilityAppSpecification = modelExplainabilityAppSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getModelExplainabilityBaselineConfig}
         * @param modelExplainabilityBaselineConfig `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelExplainabilityBaselineConfig(software.amazon.awscdk.core.IResolvable modelExplainabilityBaselineConfig) {
            this.modelExplainabilityBaselineConfig = modelExplainabilityBaselineConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getModelExplainabilityBaselineConfig}
         * @param modelExplainabilityBaselineConfig `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelExplainabilityBaselineConfig(software.amazon.awscdk.services.sagemaker.CfnModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfigProperty modelExplainabilityBaselineConfig) {
            this.modelExplainabilityBaselineConfig = modelExplainabilityBaselineConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getModelExplainabilityJobInput}
         * @param modelExplainabilityJobInput `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityJobInput`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelExplainabilityJobInput(software.amazon.awscdk.core.IResolvable modelExplainabilityJobInput) {
            this.modelExplainabilityJobInput = modelExplainabilityJobInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getModelExplainabilityJobInput}
         * @param modelExplainabilityJobInput `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityJobInput`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelExplainabilityJobInput(software.amazon.awscdk.services.sagemaker.CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty modelExplainabilityJobInput) {
            this.modelExplainabilityJobInput = modelExplainabilityJobInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getModelExplainabilityJobOutputConfig}
         * @param modelExplainabilityJobOutputConfig `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityJobOutputConfig`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelExplainabilityJobOutputConfig(software.amazon.awscdk.core.IResolvable modelExplainabilityJobOutputConfig) {
            this.modelExplainabilityJobOutputConfig = modelExplainabilityJobOutputConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getModelExplainabilityJobOutputConfig}
         * @param modelExplainabilityJobOutputConfig `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityJobOutputConfig`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelExplainabilityJobOutputConfig(software.amazon.awscdk.services.sagemaker.CfnModelExplainabilityJobDefinition.MonitoringOutputConfigProperty modelExplainabilityJobOutputConfig) {
            this.modelExplainabilityJobOutputConfig = modelExplainabilityJobOutputConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getNetworkConfig}
         * @param networkConfig `AWS::SageMaker::ModelExplainabilityJobDefinition.NetworkConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfig(software.amazon.awscdk.core.IResolvable networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getNetworkConfig}
         * @param networkConfig `AWS::SageMaker::ModelExplainabilityJobDefinition.NetworkConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfig(software.amazon.awscdk.services.sagemaker.CfnModelExplainabilityJobDefinition.NetworkConfigProperty networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getRoleArn}
         * @param roleArn `AWS::SageMaker::ModelExplainabilityJobDefinition.RoleArn`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getStoppingCondition}
         * @param stoppingCondition `AWS::SageMaker::ModelExplainabilityJobDefinition.StoppingCondition`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stoppingCondition(software.amazon.awscdk.core.IResolvable stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getStoppingCondition}
         * @param stoppingCondition `AWS::SageMaker::ModelExplainabilityJobDefinition.StoppingCondition`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stoppingCondition(software.amazon.awscdk.services.sagemaker.CfnModelExplainabilityJobDefinition.StoppingConditionProperty stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getTags}
         * @param tags `AWS::SageMaker::ModelExplainabilityJobDefinition.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnModelExplainabilityJobDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnModelExplainabilityJobDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnModelExplainabilityJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnModelExplainabilityJobDefinitionProps {
        private final java.lang.String jobDefinitionName;
        private final java.lang.Object jobResources;
        private final java.lang.Object modelExplainabilityAppSpecification;
        private final java.lang.Object modelExplainabilityBaselineConfig;
        private final java.lang.Object modelExplainabilityJobInput;
        private final java.lang.Object modelExplainabilityJobOutputConfig;
        private final java.lang.Object networkConfig;
        private final java.lang.String roleArn;
        private final java.lang.Object stoppingCondition;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.jobDefinitionName = software.amazon.jsii.Kernel.get(this, "jobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.jobResources = software.amazon.jsii.Kernel.get(this, "jobResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.modelExplainabilityAppSpecification = software.amazon.jsii.Kernel.get(this, "modelExplainabilityAppSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.modelExplainabilityBaselineConfig = software.amazon.jsii.Kernel.get(this, "modelExplainabilityBaselineConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.modelExplainabilityJobInput = software.amazon.jsii.Kernel.get(this, "modelExplainabilityJobInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.modelExplainabilityJobOutputConfig = software.amazon.jsii.Kernel.get(this, "modelExplainabilityJobOutputConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.networkConfig = software.amazon.jsii.Kernel.get(this, "networkConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stoppingCondition = software.amazon.jsii.Kernel.get(this, "stoppingCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.jobDefinitionName = builder.jobDefinitionName;
            this.jobResources = java.util.Objects.requireNonNull(builder.jobResources, "jobResources is required");
            this.modelExplainabilityAppSpecification = java.util.Objects.requireNonNull(builder.modelExplainabilityAppSpecification, "modelExplainabilityAppSpecification is required");
            this.modelExplainabilityBaselineConfig = builder.modelExplainabilityBaselineConfig;
            this.modelExplainabilityJobInput = java.util.Objects.requireNonNull(builder.modelExplainabilityJobInput, "modelExplainabilityJobInput is required");
            this.modelExplainabilityJobOutputConfig = java.util.Objects.requireNonNull(builder.modelExplainabilityJobOutputConfig, "modelExplainabilityJobOutputConfig is required");
            this.networkConfig = builder.networkConfig;
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.stoppingCondition = builder.stoppingCondition;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        @Override
        public final java.lang.Object getJobResources() {
            return this.jobResources;
        }

        @Override
        public final java.lang.Object getModelExplainabilityAppSpecification() {
            return this.modelExplainabilityAppSpecification;
        }

        @Override
        public final java.lang.Object getModelExplainabilityBaselineConfig() {
            return this.modelExplainabilityBaselineConfig;
        }

        @Override
        public final java.lang.Object getModelExplainabilityJobInput() {
            return this.modelExplainabilityJobInput;
        }

        @Override
        public final java.lang.Object getModelExplainabilityJobOutputConfig() {
            return this.modelExplainabilityJobOutputConfig;
        }

        @Override
        public final java.lang.Object getNetworkConfig() {
            return this.networkConfig;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getStoppingCondition() {
            return this.stoppingCondition;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getJobDefinitionName() != null) {
                data.set("jobDefinitionName", om.valueToTree(this.getJobDefinitionName()));
            }
            data.set("jobResources", om.valueToTree(this.getJobResources()));
            data.set("modelExplainabilityAppSpecification", om.valueToTree(this.getModelExplainabilityAppSpecification()));
            if (this.getModelExplainabilityBaselineConfig() != null) {
                data.set("modelExplainabilityBaselineConfig", om.valueToTree(this.getModelExplainabilityBaselineConfig()));
            }
            data.set("modelExplainabilityJobInput", om.valueToTree(this.getModelExplainabilityJobInput()));
            data.set("modelExplainabilityJobOutputConfig", om.valueToTree(this.getModelExplainabilityJobOutputConfig()));
            if (this.getNetworkConfig() != null) {
                data.set("networkConfig", om.valueToTree(this.getNetworkConfig()));
            }
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getStoppingCondition() != null) {
                data.set("stoppingCondition", om.valueToTree(this.getStoppingCondition()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelExplainabilityJobDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnModelExplainabilityJobDefinitionProps.Jsii$Proxy that = (CfnModelExplainabilityJobDefinitionProps.Jsii$Proxy) o;

            if (this.jobDefinitionName != null ? !this.jobDefinitionName.equals(that.jobDefinitionName) : that.jobDefinitionName != null) return false;
            if (!jobResources.equals(that.jobResources)) return false;
            if (!modelExplainabilityAppSpecification.equals(that.modelExplainabilityAppSpecification)) return false;
            if (this.modelExplainabilityBaselineConfig != null ? !this.modelExplainabilityBaselineConfig.equals(that.modelExplainabilityBaselineConfig) : that.modelExplainabilityBaselineConfig != null) return false;
            if (!modelExplainabilityJobInput.equals(that.modelExplainabilityJobInput)) return false;
            if (!modelExplainabilityJobOutputConfig.equals(that.modelExplainabilityJobOutputConfig)) return false;
            if (this.networkConfig != null ? !this.networkConfig.equals(that.networkConfig) : that.networkConfig != null) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.stoppingCondition != null ? !this.stoppingCondition.equals(that.stoppingCondition) : that.stoppingCondition != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.jobDefinitionName != null ? this.jobDefinitionName.hashCode() : 0;
            result = 31 * result + (this.jobResources.hashCode());
            result = 31 * result + (this.modelExplainabilityAppSpecification.hashCode());
            result = 31 * result + (this.modelExplainabilityBaselineConfig != null ? this.modelExplainabilityBaselineConfig.hashCode() : 0);
            result = 31 * result + (this.modelExplainabilityJobInput.hashCode());
            result = 31 * result + (this.modelExplainabilityJobOutputConfig.hashCode());
            result = 31 * result + (this.networkConfig != null ? this.networkConfig.hashCode() : 0);
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.stoppingCondition != null ? this.stoppingCondition.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
