package software.amazon.awscdk.services.sagemaker;

/**
 * A CloudFormation `AWS::SageMaker::Workteam`.
 * <p>
 * Creates a new work team for labeling your data. A work team is defined by one or more Amazon Cognito user pools. You must first create the user pools before you can create a work team.
 * <p>
 * You cannot create more than 25 work teams in an account and region.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnWorkteam cfnWorkteam = CfnWorkteam.Builder.create(this, "MyCfnWorkteam")
 *         .description("description")
 *         .memberDefinitions(List.of(MemberDefinitionProperty.builder()
 *                 .cognitoMemberDefinition(CognitoMemberDefinitionProperty.builder()
 *                         .cognitoClientId("cognitoClientId")
 *                         .cognitoUserGroup("cognitoUserGroup")
 *                         .cognitoUserPool("cognitoUserPool")
 *                         .build())
 *                 .build()))
 *         .notificationConfiguration(NotificationConfigurationProperty.builder()
 *                 .notificationTopicArn("notificationTopicArn")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .workteamName("workteamName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.50.0 (build d1830a4)", date = "2022-01-07T14:33:50.210Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnWorkteam")
public class CfnWorkteam extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnWorkteam(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWorkteam(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnWorkteam.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::SageMaker::Workteam`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnWorkteam(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnWorkteamProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::SageMaker::Workteam`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnWorkteam(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWorkteamName() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkteamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::SageMaker::Workteam.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * A description of the work team.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the work team.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * A list of `MemberDefinition` objects that contains objects that identify the workers that make up the work team.
     * <p>
     * Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code> . For workforces created using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMemberDefinitions() {
        return software.amazon.jsii.Kernel.get(this, "memberDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of `MemberDefinition` objects that contains objects that identify the workers that make up the work team.
     * <p>
     * Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code> . For workforces created using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMemberDefinitions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "memberDefinitions", value);
    }

    /**
     * A list of `MemberDefinition` objects that contains objects that identify the workers that make up the work team.
     * <p>
     * Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code> . For workforces created using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMemberDefinitions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "memberDefinitions", value);
    }

    /**
     * Configures SNS notifications of available or expiring work items for work teams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNotificationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "notificationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configures SNS notifications of available or expiring work items for work teams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "notificationConfiguration", value);
    }

    /**
     * Configures SNS notifications of available or expiring work items for work teams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnWorkteam.NotificationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "notificationConfiguration", value);
    }

    /**
     * The name of the work team.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getWorkteamName() {
        return software.amazon.jsii.Kernel.get(this, "workteamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the work team.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkteamName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "workteamName", value);
    }
    /**
     * Identifies a Amazon Cognito user group.
     * <p>
     * A user group can be used in on or more work teams.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CognitoMemberDefinitionProperty cognitoMemberDefinitionProperty = CognitoMemberDefinitionProperty.builder()
     *         .cognitoClientId("cognitoClientId")
     *         .cognitoUserGroup("cognitoUserGroup")
     *         .cognitoUserPool("cognitoUserPool")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnWorkteam.CognitoMemberDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(CognitoMemberDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CognitoMemberDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoClientId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCognitoClientId();

        /**
         * `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoUserGroup`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCognitoUserGroup();

        /**
         * `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoUserPool`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCognitoUserPool();

        /**
         * @return a {@link Builder} of {@link CognitoMemberDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CognitoMemberDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CognitoMemberDefinitionProperty> {
            java.lang.String cognitoClientId;
            java.lang.String cognitoUserGroup;
            java.lang.String cognitoUserPool;

            /**
             * Sets the value of {@link CognitoMemberDefinitionProperty#getCognitoClientId}
             * @param cognitoClientId `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoClientId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cognitoClientId(java.lang.String cognitoClientId) {
                this.cognitoClientId = cognitoClientId;
                return this;
            }

            /**
             * Sets the value of {@link CognitoMemberDefinitionProperty#getCognitoUserGroup}
             * @param cognitoUserGroup `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoUserGroup`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cognitoUserGroup(java.lang.String cognitoUserGroup) {
                this.cognitoUserGroup = cognitoUserGroup;
                return this;
            }

            /**
             * Sets the value of {@link CognitoMemberDefinitionProperty#getCognitoUserPool}
             * @param cognitoUserPool `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoUserPool`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cognitoUserPool(java.lang.String cognitoUserPool) {
                this.cognitoUserPool = cognitoUserPool;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CognitoMemberDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CognitoMemberDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CognitoMemberDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CognitoMemberDefinitionProperty {
            private final java.lang.String cognitoClientId;
            private final java.lang.String cognitoUserGroup;
            private final java.lang.String cognitoUserPool;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cognitoClientId = software.amazon.jsii.Kernel.get(this, "cognitoClientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cognitoUserGroup = software.amazon.jsii.Kernel.get(this, "cognitoUserGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cognitoUserPool = software.amazon.jsii.Kernel.get(this, "cognitoUserPool", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cognitoClientId = java.util.Objects.requireNonNull(builder.cognitoClientId, "cognitoClientId is required");
                this.cognitoUserGroup = java.util.Objects.requireNonNull(builder.cognitoUserGroup, "cognitoUserGroup is required");
                this.cognitoUserPool = java.util.Objects.requireNonNull(builder.cognitoUserPool, "cognitoUserPool is required");
            }

            @Override
            public final java.lang.String getCognitoClientId() {
                return this.cognitoClientId;
            }

            @Override
            public final java.lang.String getCognitoUserGroup() {
                return this.cognitoUserGroup;
            }

            @Override
            public final java.lang.String getCognitoUserPool() {
                return this.cognitoUserPool;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cognitoClientId", om.valueToTree(this.getCognitoClientId()));
                data.set("cognitoUserGroup", om.valueToTree(this.getCognitoUserGroup()));
                data.set("cognitoUserPool", om.valueToTree(this.getCognitoUserPool()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnWorkteam.CognitoMemberDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CognitoMemberDefinitionProperty.Jsii$Proxy that = (CognitoMemberDefinitionProperty.Jsii$Proxy) o;

                if (!cognitoClientId.equals(that.cognitoClientId)) return false;
                if (!cognitoUserGroup.equals(that.cognitoUserGroup)) return false;
                return this.cognitoUserPool.equals(that.cognitoUserPool);
            }

            @Override
            public final int hashCode() {
                int result = this.cognitoClientId.hashCode();
                result = 31 * result + (this.cognitoUserGroup.hashCode());
                result = 31 * result + (this.cognitoUserPool.hashCode());
                return result;
            }
        }
    }
    /**
     * Defines an Amazon Cognito or your own OIDC IdP user group that is part of a work team.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * MemberDefinitionProperty memberDefinitionProperty = MemberDefinitionProperty.builder()
     *         .cognitoMemberDefinition(CognitoMemberDefinitionProperty.builder()
     *                 .cognitoClientId("cognitoClientId")
     *                 .cognitoUserGroup("cognitoUserGroup")
     *                 .cognitoUserPool("cognitoUserPool")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnWorkteam.MemberDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(MemberDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemberDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Cognito user group that is part of the work team.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCognitoMemberDefinition();

        /**
         * @return a {@link Builder} of {@link MemberDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemberDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemberDefinitionProperty> {
            java.lang.Object cognitoMemberDefinition;

            /**
             * Sets the value of {@link MemberDefinitionProperty#getCognitoMemberDefinition}
             * @param cognitoMemberDefinition The Amazon Cognito user group that is part of the work team. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cognitoMemberDefinition(software.amazon.awscdk.core.IResolvable cognitoMemberDefinition) {
                this.cognitoMemberDefinition = cognitoMemberDefinition;
                return this;
            }

            /**
             * Sets the value of {@link MemberDefinitionProperty#getCognitoMemberDefinition}
             * @param cognitoMemberDefinition The Amazon Cognito user group that is part of the work team. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cognitoMemberDefinition(software.amazon.awscdk.services.sagemaker.CfnWorkteam.CognitoMemberDefinitionProperty cognitoMemberDefinition) {
                this.cognitoMemberDefinition = cognitoMemberDefinition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemberDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemberDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemberDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemberDefinitionProperty {
            private final java.lang.Object cognitoMemberDefinition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cognitoMemberDefinition = software.amazon.jsii.Kernel.get(this, "cognitoMemberDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cognitoMemberDefinition = java.util.Objects.requireNonNull(builder.cognitoMemberDefinition, "cognitoMemberDefinition is required");
            }

            @Override
            public final java.lang.Object getCognitoMemberDefinition() {
                return this.cognitoMemberDefinition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cognitoMemberDefinition", om.valueToTree(this.getCognitoMemberDefinition()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnWorkteam.MemberDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemberDefinitionProperty.Jsii$Proxy that = (MemberDefinitionProperty.Jsii$Proxy) o;

                return this.cognitoMemberDefinition.equals(that.cognitoMemberDefinition);
            }

            @Override
            public final int hashCode() {
                int result = this.cognitoMemberDefinition.hashCode();
                return result;
            }
        }
    }
    /**
     * Configures Amazon SNS notifications of available or expiring work items for work teams.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * NotificationConfigurationProperty notificationConfigurationProperty = NotificationConfigurationProperty.builder()
     *         .notificationTopicArn("notificationTopicArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnWorkteam.NotificationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NotificationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotificationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN for the Amazon SNS topic to which notifications should be published.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNotificationTopicArn();

        /**
         * @return a {@link Builder} of {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NotificationConfigurationProperty> {
            java.lang.String notificationTopicArn;

            /**
             * Sets the value of {@link NotificationConfigurationProperty#getNotificationTopicArn}
             * @param notificationTopicArn The ARN for the Amazon SNS topic to which notifications should be published. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notificationTopicArn(java.lang.String notificationTopicArn) {
                this.notificationTopicArn = notificationTopicArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NotificationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationConfigurationProperty {
            private final java.lang.String notificationTopicArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.notificationTopicArn = software.amazon.jsii.Kernel.get(this, "notificationTopicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.notificationTopicArn = java.util.Objects.requireNonNull(builder.notificationTopicArn, "notificationTopicArn is required");
            }

            @Override
            public final java.lang.String getNotificationTopicArn() {
                return this.notificationTopicArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("notificationTopicArn", om.valueToTree(this.getNotificationTopicArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnWorkteam.NotificationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotificationConfigurationProperty.Jsii$Proxy that = (NotificationConfigurationProperty.Jsii$Proxy) o;

                return this.notificationTopicArn.equals(that.notificationTopicArn);
            }

            @Override
            public final int hashCode() {
                int result = this.notificationTopicArn.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnWorkteam}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnWorkteam> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.sagemaker.CfnWorkteamProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A description of the work team.
         * <p>
         * @return {@code this}
         * @param description A description of the work team. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * A list of `MemberDefinition` objects that contains objects that identify the workers that make up the work team.
         * <p>
         * Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code> . For workforces created using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code> .
         * <p>
         * @return {@code this}
         * @param memberDefinitions A list of `MemberDefinition` objects that contains objects that identify the workers that make up the work team. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memberDefinitions(final software.amazon.awscdk.core.IResolvable memberDefinitions) {
            this.props().memberDefinitions(memberDefinitions);
            return this;
        }
        /**
         * A list of `MemberDefinition` objects that contains objects that identify the workers that make up the work team.
         * <p>
         * Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code> . For workforces created using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code> .
         * <p>
         * @return {@code this}
         * @param memberDefinitions A list of `MemberDefinition` objects that contains objects that identify the workers that make up the work team. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memberDefinitions(final java.util.List<? extends java.lang.Object> memberDefinitions) {
            this.props().memberDefinitions(memberDefinitions);
            return this;
        }

        /**
         * Configures SNS notifications of available or expiring work items for work teams.
         * <p>
         * @return {@code this}
         * @param notificationConfiguration Configures SNS notifications of available or expiring work items for work teams. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfiguration(final software.amazon.awscdk.core.IResolvable notificationConfiguration) {
            this.props().notificationConfiguration(notificationConfiguration);
            return this;
        }
        /**
         * Configures SNS notifications of available or expiring work items for work teams.
         * <p>
         * @return {@code this}
         * @param notificationConfiguration Configures SNS notifications of available or expiring work items for work teams. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfiguration(final software.amazon.awscdk.services.sagemaker.CfnWorkteam.NotificationConfigurationProperty notificationConfiguration) {
            this.props().notificationConfiguration(notificationConfiguration);
            return this;
        }

        /**
         * `AWS::SageMaker::Workteam.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::SageMaker::Workteam.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The name of the work team.
         * <p>
         * @return {@code this}
         * @param workteamName The name of the work team. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workteamName(final java.lang.String workteamName) {
            this.props().workteamName(workteamName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnWorkteam}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnWorkteam build() {
            return new software.amazon.awscdk.services.sagemaker.CfnWorkteam(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.sagemaker.CfnWorkteamProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.sagemaker.CfnWorkteamProps.Builder();
            }
            return this.props;
        }
    }
}
