package software.amazon.awscdk.services.sagemaker;

/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`.
 * <p>
 * The <code>AWS::SageMaker::EndpointConfig</code> resource creates a configuration for an Amazon SageMaker endpoint. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html">CreateEndpointConfig</a> in the <em>SageMaker Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnEndpointConfig cfnEndpointConfig = CfnEndpointConfig.Builder.create(this, "MyCfnEndpointConfig")
 *         .productionVariants(List.of(ProductionVariantProperty.builder()
 *                 .initialVariantWeight(123)
 *                 .modelName("modelName")
 *                 .variantName("variantName")
 *                 // the properties below are optional
 *                 .acceleratorType("acceleratorType")
 *                 .initialInstanceCount(123)
 *                 .instanceType("instanceType")
 *                 .serverlessConfig(ServerlessConfigProperty.builder()
 *                         .maxConcurrency(123)
 *                         .memorySizeInMb(123)
 *                         .build())
 *                 .build()))
 *         // the properties below are optional
 *         .asyncInferenceConfig(AsyncInferenceConfigProperty.builder()
 *                 .outputConfig(AsyncInferenceOutputConfigProperty.builder()
 *                         .s3OutputPath("s3OutputPath")
 *                         // the properties below are optional
 *                         .kmsKeyId("kmsKeyId")
 *                         .notificationConfig(AsyncInferenceNotificationConfigProperty.builder()
 *                                 .errorTopic("errorTopic")
 *                                 .successTopic("successTopic")
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .clientConfig(AsyncInferenceClientConfigProperty.builder()
 *                         .maxConcurrentInvocationsPerInstance(123)
 *                         .build())
 *                 .build())
 *         .dataCaptureConfig(DataCaptureConfigProperty.builder()
 *                 .captureOptions(List.of(CaptureOptionProperty.builder()
 *                         .captureMode("captureMode")
 *                         .build()))
 *                 .destinationS3Uri("destinationS3Uri")
 *                 .initialSamplingPercentage(123)
 *                 // the properties below are optional
 *                 .captureContentTypeHeader(CaptureContentTypeHeaderProperty.builder()
 *                         .csvContentTypes(List.of("csvContentTypes"))
 *                         .jsonContentTypes(List.of("jsonContentTypes"))
 *                         .build())
 *                 .enableCapture(false)
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .endpointConfigName("endpointConfigName")
 *         .kmsKeyId("kmsKeyId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-10T02:24:07.335Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnEndpointConfig")
public class CfnEndpointConfig extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnEndpointConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEndpointConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::SageMaker::EndpointConfig`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEndpointConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnEndpointConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The name of the endpoint configuration, such as `MyEndpointConfiguration` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointConfigName() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpointConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource Tag</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * A list of `ProductionVariant` objects, one for each model that you want to host at this endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getProductionVariants() {
        return software.amazon.jsii.Kernel.get(this, "productionVariants", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of `ProductionVariant` objects, one for each model that you want to host at this endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProductionVariants(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "productionVariants", java.util.Objects.requireNonNull(value, "productionVariants is required"));
    }

    /**
     * A list of `ProductionVariant` objects, one for each model that you want to host at this endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProductionVariants(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "productionVariants", java.util.Objects.requireNonNull(value, "productionVariants is required"));
    }

    /**
     * Specifies configuration for how an endpoint performs asynchronous inference.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAsyncInferenceConfig() {
        return software.amazon.jsii.Kernel.get(this, "asyncInferenceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies configuration for how an endpoint performs asynchronous inference.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAsyncInferenceConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "asyncInferenceConfig", value);
    }

    /**
     * Specifies configuration for how an endpoint performs asynchronous inference.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAsyncInferenceConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "asyncInferenceConfig", value);
    }

    /**
     * Specifies how to capture endpoint data for model monitor.
     * <p>
     * The data capture configuration applies to all production variants hosted at the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataCaptureConfig() {
        return software.amazon.jsii.Kernel.get(this, "dataCaptureConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies how to capture endpoint data for model monitor.
     * <p>
     * The data capture configuration applies to all production variants hosted at the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataCaptureConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataCaptureConfig", value);
    }

    /**
     * Specifies how to capture endpoint data for model monitor.
     * <p>
     * The data capture configuration applies to all production variants hosted at the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataCaptureConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.DataCaptureConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "dataCaptureConfig", value);
    }

    /**
     * The name of the endpoint configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndpointConfigName() {
        return software.amazon.jsii.Kernel.get(this, "endpointConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the endpoint configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointConfigName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endpointConfigName", value);
    }

    /**
     * The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
     * <p>
     * <ul>
     * <li>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
     * <li>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
     * <li>Alias name: <code>alias/ExampleAlias</code></li>
     * <li>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code></li>
     * </ul>
     * <p>
     * The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateEndpoint</code> , <code>UpdateEndpoint</code> requests. For more information, refer to the AWS Key Management Service section <a href="https://docs.aws.amazon.com//kms/latest/developerguide/key-policies.html">Using Key Policies in AWS KMS</a>
     * <p>
     * <blockquote>
     * <p>
     * Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a <code>KmsKeyId</code> when using an instance type with local storage. If any of the models that you specify in the <code>ProductionVariants</code> parameter use nitro-based instances with local storage, do not specify a value for the <code>KmsKeyId</code> parameter. If you specify a value for <code>KmsKeyId</code> when using any nitro-based instances with local storage, the call to <code>CreateEndpointConfig</code> fails.
     * <p>
     * For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a> .
     * <p>
     * For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
     * <p>
     * <ul>
     * <li>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
     * <li>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
     * <li>Alias name: <code>alias/ExampleAlias</code></li>
     * <li>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code></li>
     * </ul>
     * <p>
     * The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateEndpoint</code> , <code>UpdateEndpoint</code> requests. For more information, refer to the AWS Key Management Service section <a href="https://docs.aws.amazon.com//kms/latest/developerguide/key-policies.html">Using Key Policies in AWS KMS</a>
     * <p>
     * <blockquote>
     * <p>
     * Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a <code>KmsKeyId</code> when using an instance type with local storage. If any of the models that you specify in the <code>ProductionVariants</code> parameter use nitro-based instances with local storage, do not specify a value for the <code>KmsKeyId</code> parameter. If you specify a value for <code>KmsKeyId</code> when using any nitro-based instances with local storage, the call to <code>CreateEndpointConfig</code> fails.
     * <p>
     * For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a> .
     * <p>
     * For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }
    /**
     * Configures the behavior of the client used by SageMaker to interact with the model container during asynchronous inference.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * AsyncInferenceClientConfigProperty asyncInferenceClientConfigProperty = AsyncInferenceClientConfigProperty.builder()
     *         .maxConcurrentInvocationsPerInstance(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AsyncInferenceClientConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AsyncInferenceClientConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of concurrent requests sent by the SageMaker client to the model container.
         * <p>
         * If no value is provided, SageMaker will choose an optimal value for you.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxConcurrentInvocationsPerInstance() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AsyncInferenceClientConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AsyncInferenceClientConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AsyncInferenceClientConfigProperty> {
            java.lang.Number maxConcurrentInvocationsPerInstance;

            /**
             * Sets the value of {@link AsyncInferenceClientConfigProperty#getMaxConcurrentInvocationsPerInstance}
             * @param maxConcurrentInvocationsPerInstance The maximum number of concurrent requests sent by the SageMaker client to the model container.
             *                                            If no value is provided, SageMaker will choose an optimal value for you.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxConcurrentInvocationsPerInstance(java.lang.Number maxConcurrentInvocationsPerInstance) {
                this.maxConcurrentInvocationsPerInstance = maxConcurrentInvocationsPerInstance;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AsyncInferenceClientConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AsyncInferenceClientConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AsyncInferenceClientConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AsyncInferenceClientConfigProperty {
            private final java.lang.Number maxConcurrentInvocationsPerInstance;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxConcurrentInvocationsPerInstance = software.amazon.jsii.Kernel.get(this, "maxConcurrentInvocationsPerInstance", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxConcurrentInvocationsPerInstance = builder.maxConcurrentInvocationsPerInstance;
            }

            @Override
            public final java.lang.Number getMaxConcurrentInvocationsPerInstance() {
                return this.maxConcurrentInvocationsPerInstance;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxConcurrentInvocationsPerInstance() != null) {
                    data.set("maxConcurrentInvocationsPerInstance", om.valueToTree(this.getMaxConcurrentInvocationsPerInstance()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AsyncInferenceClientConfigProperty.Jsii$Proxy that = (AsyncInferenceClientConfigProperty.Jsii$Proxy) o;

                return this.maxConcurrentInvocationsPerInstance != null ? this.maxConcurrentInvocationsPerInstance.equals(that.maxConcurrentInvocationsPerInstance) : that.maxConcurrentInvocationsPerInstance == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxConcurrentInvocationsPerInstance != null ? this.maxConcurrentInvocationsPerInstance.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies configuration for how an endpoint performs asynchronous inference.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * AsyncInferenceConfigProperty asyncInferenceConfigProperty = AsyncInferenceConfigProperty.builder()
     *         .outputConfig(AsyncInferenceOutputConfigProperty.builder()
     *                 .s3OutputPath("s3OutputPath")
     *                 // the properties below are optional
     *                 .kmsKeyId("kmsKeyId")
     *                 .notificationConfig(AsyncInferenceNotificationConfigProperty.builder()
     *                         .errorTopic("errorTopic")
     *                         .successTopic("successTopic")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .clientConfig(AsyncInferenceClientConfigProperty.builder()
     *                 .maxConcurrentInvocationsPerInstance(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AsyncInferenceConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AsyncInferenceConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the configuration for asynchronous inference invocation outputs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOutputConfig();

        /**
         * Configures the behavior of the client used by SageMaker to interact with the model container during asynchronous inference.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getClientConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AsyncInferenceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AsyncInferenceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AsyncInferenceConfigProperty> {
            java.lang.Object outputConfig;
            java.lang.Object clientConfig;

            /**
             * Sets the value of {@link AsyncInferenceConfigProperty#getOutputConfig}
             * @param outputConfig Specifies the configuration for asynchronous inference invocation outputs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputConfig(software.amazon.awscdk.core.IResolvable outputConfig) {
                this.outputConfig = outputConfig;
                return this;
            }

            /**
             * Sets the value of {@link AsyncInferenceConfigProperty#getOutputConfig}
             * @param outputConfig Specifies the configuration for asynchronous inference invocation outputs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputConfig(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty outputConfig) {
                this.outputConfig = outputConfig;
                return this;
            }

            /**
             * Sets the value of {@link AsyncInferenceConfigProperty#getClientConfig}
             * @param clientConfig Configures the behavior of the client used by SageMaker to interact with the model container during asynchronous inference.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientConfig(software.amazon.awscdk.core.IResolvable clientConfig) {
                this.clientConfig = clientConfig;
                return this;
            }

            /**
             * Sets the value of {@link AsyncInferenceConfigProperty#getClientConfig}
             * @param clientConfig Configures the behavior of the client used by SageMaker to interact with the model container during asynchronous inference.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientConfig(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty clientConfig) {
                this.clientConfig = clientConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AsyncInferenceConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AsyncInferenceConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AsyncInferenceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AsyncInferenceConfigProperty {
            private final java.lang.Object outputConfig;
            private final java.lang.Object clientConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.outputConfig = software.amazon.jsii.Kernel.get(this, "outputConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.clientConfig = software.amazon.jsii.Kernel.get(this, "clientConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.outputConfig = java.util.Objects.requireNonNull(builder.outputConfig, "outputConfig is required");
                this.clientConfig = builder.clientConfig;
            }

            @Override
            public final java.lang.Object getOutputConfig() {
                return this.outputConfig;
            }

            @Override
            public final java.lang.Object getClientConfig() {
                return this.clientConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("outputConfig", om.valueToTree(this.getOutputConfig()));
                if (this.getClientConfig() != null) {
                    data.set("clientConfig", om.valueToTree(this.getClientConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AsyncInferenceConfigProperty.Jsii$Proxy that = (AsyncInferenceConfigProperty.Jsii$Proxy) o;

                if (!outputConfig.equals(that.outputConfig)) return false;
                return this.clientConfig != null ? this.clientConfig.equals(that.clientConfig) : that.clientConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.outputConfig.hashCode();
                result = 31 * result + (this.clientConfig != null ? this.clientConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration for notifications of inference results for asynchronous inference.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * AsyncInferenceNotificationConfigProperty asyncInferenceNotificationConfigProperty = AsyncInferenceNotificationConfigProperty.builder()
     *         .errorTopic("errorTopic")
     *         .successTopic("successTopic")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AsyncInferenceNotificationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AsyncInferenceNotificationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Amazon SNS topic to post a notification to when an inference fails.
         * <p>
         * If no topic is provided, no notification is sent on failure.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getErrorTopic() {
            return null;
        }

        /**
         * Amazon SNS topic to post a notification to when an inference completes successfully.
         * <p>
         * If no topic is provided, no notification is sent on success.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSuccessTopic() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AsyncInferenceNotificationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AsyncInferenceNotificationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AsyncInferenceNotificationConfigProperty> {
            java.lang.String errorTopic;
            java.lang.String successTopic;

            /**
             * Sets the value of {@link AsyncInferenceNotificationConfigProperty#getErrorTopic}
             * @param errorTopic Amazon SNS topic to post a notification to when an inference fails.
             *                   If no topic is provided, no notification is sent on failure.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorTopic(java.lang.String errorTopic) {
                this.errorTopic = errorTopic;
                return this;
            }

            /**
             * Sets the value of {@link AsyncInferenceNotificationConfigProperty#getSuccessTopic}
             * @param successTopic Amazon SNS topic to post a notification to when an inference completes successfully.
             *                     If no topic is provided, no notification is sent on success.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successTopic(java.lang.String successTopic) {
                this.successTopic = successTopic;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AsyncInferenceNotificationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AsyncInferenceNotificationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AsyncInferenceNotificationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AsyncInferenceNotificationConfigProperty {
            private final java.lang.String errorTopic;
            private final java.lang.String successTopic;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.errorTopic = software.amazon.jsii.Kernel.get(this, "errorTopic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.successTopic = software.amazon.jsii.Kernel.get(this, "successTopic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.errorTopic = builder.errorTopic;
                this.successTopic = builder.successTopic;
            }

            @Override
            public final java.lang.String getErrorTopic() {
                return this.errorTopic;
            }

            @Override
            public final java.lang.String getSuccessTopic() {
                return this.successTopic;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getErrorTopic() != null) {
                    data.set("errorTopic", om.valueToTree(this.getErrorTopic()));
                }
                if (this.getSuccessTopic() != null) {
                    data.set("successTopic", om.valueToTree(this.getSuccessTopic()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AsyncInferenceNotificationConfigProperty.Jsii$Proxy that = (AsyncInferenceNotificationConfigProperty.Jsii$Proxy) o;

                if (this.errorTopic != null ? !this.errorTopic.equals(that.errorTopic) : that.errorTopic != null) return false;
                return this.successTopic != null ? this.successTopic.equals(that.successTopic) : that.successTopic == null;
            }

            @Override
            public final int hashCode() {
                int result = this.errorTopic != null ? this.errorTopic.hashCode() : 0;
                result = 31 * result + (this.successTopic != null ? this.successTopic.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration for asynchronous inference invocation outputs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * AsyncInferenceOutputConfigProperty asyncInferenceOutputConfigProperty = AsyncInferenceOutputConfigProperty.builder()
     *         .s3OutputPath("s3OutputPath")
     *         // the properties below are optional
     *         .kmsKeyId("kmsKeyId")
     *         .notificationConfig(AsyncInferenceNotificationConfigProperty.builder()
     *                 .errorTopic("errorTopic")
     *                 .successTopic("successTopic")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AsyncInferenceOutputConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AsyncInferenceOutputConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 location to upload inference responses to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3OutputPath();

        /**
         * The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the asynchronous inference output in Amazon S3.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * Specifies the configuration for notifications of inference results for asynchronous inference.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNotificationConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AsyncInferenceOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AsyncInferenceOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AsyncInferenceOutputConfigProperty> {
            java.lang.String s3OutputPath;
            java.lang.String kmsKeyId;
            java.lang.Object notificationConfig;

            /**
             * Sets the value of {@link AsyncInferenceOutputConfigProperty#getS3OutputPath}
             * @param s3OutputPath The Amazon S3 location to upload inference responses to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OutputPath(java.lang.String s3OutputPath) {
                this.s3OutputPath = s3OutputPath;
                return this;
            }

            /**
             * Sets the value of {@link AsyncInferenceOutputConfigProperty#getKmsKeyId}
             * @param kmsKeyId The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the asynchronous inference output in Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link AsyncInferenceOutputConfigProperty#getNotificationConfig}
             * @param notificationConfig Specifies the configuration for notifications of inference results for asynchronous inference.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notificationConfig(software.amazon.awscdk.core.IResolvable notificationConfig) {
                this.notificationConfig = notificationConfig;
                return this;
            }

            /**
             * Sets the value of {@link AsyncInferenceOutputConfigProperty#getNotificationConfig}
             * @param notificationConfig Specifies the configuration for notifications of inference results for asynchronous inference.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notificationConfig(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty notificationConfig) {
                this.notificationConfig = notificationConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AsyncInferenceOutputConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AsyncInferenceOutputConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AsyncInferenceOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AsyncInferenceOutputConfigProperty {
            private final java.lang.String s3OutputPath;
            private final java.lang.String kmsKeyId;
            private final java.lang.Object notificationConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3OutputPath = software.amazon.jsii.Kernel.get(this, "s3OutputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.notificationConfig = software.amazon.jsii.Kernel.get(this, "notificationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3OutputPath = java.util.Objects.requireNonNull(builder.s3OutputPath, "s3OutputPath is required");
                this.kmsKeyId = builder.kmsKeyId;
                this.notificationConfig = builder.notificationConfig;
            }

            @Override
            public final java.lang.String getS3OutputPath() {
                return this.s3OutputPath;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public final java.lang.Object getNotificationConfig() {
                return this.notificationConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3OutputPath", om.valueToTree(this.getS3OutputPath()));
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getNotificationConfig() != null) {
                    data.set("notificationConfig", om.valueToTree(this.getNotificationConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AsyncInferenceOutputConfigProperty.Jsii$Proxy that = (AsyncInferenceOutputConfigProperty.Jsii$Proxy) o;

                if (!s3OutputPath.equals(that.s3OutputPath)) return false;
                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                return this.notificationConfig != null ? this.notificationConfig.equals(that.notificationConfig) : that.notificationConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3OutputPath.hashCode();
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                result = 31 * result + (this.notificationConfig != null ? this.notificationConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the JSON and CSV content types of the data that the endpoint captures.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CaptureContentTypeHeaderProperty captureContentTypeHeaderProperty = CaptureContentTypeHeaderProperty.builder()
     *         .csvContentTypes(List.of("csvContentTypes"))
     *         .jsonContentTypes(List.of("jsonContentTypes"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty")
    @software.amazon.jsii.Jsii.Proxy(CaptureContentTypeHeaderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CaptureContentTypeHeaderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of the CSV content types of the data that the endpoint captures.
         * <p>
         * For the endpoint to capture the data, you must also specify the content type when you invoke the endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCsvContentTypes() {
            return null;
        }

        /**
         * A list of the JSON content types of the data that the endpoint captures.
         * <p>
         * For the endpoint to capture the data, you must also specify the content type when you invoke the endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getJsonContentTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CaptureContentTypeHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CaptureContentTypeHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CaptureContentTypeHeaderProperty> {
            java.util.List<java.lang.String> csvContentTypes;
            java.util.List<java.lang.String> jsonContentTypes;

            /**
             * Sets the value of {@link CaptureContentTypeHeaderProperty#getCsvContentTypes}
             * @param csvContentTypes A list of the CSV content types of the data that the endpoint captures.
             *                        For the endpoint to capture the data, you must also specify the content type when you invoke the endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csvContentTypes(java.util.List<java.lang.String> csvContentTypes) {
                this.csvContentTypes = csvContentTypes;
                return this;
            }

            /**
             * Sets the value of {@link CaptureContentTypeHeaderProperty#getJsonContentTypes}
             * @param jsonContentTypes A list of the JSON content types of the data that the endpoint captures.
             *                         For the endpoint to capture the data, you must also specify the content type when you invoke the endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonContentTypes(java.util.List<java.lang.String> jsonContentTypes) {
                this.jsonContentTypes = jsonContentTypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CaptureContentTypeHeaderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CaptureContentTypeHeaderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CaptureContentTypeHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaptureContentTypeHeaderProperty {
            private final java.util.List<java.lang.String> csvContentTypes;
            private final java.util.List<java.lang.String> jsonContentTypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.csvContentTypes = software.amazon.jsii.Kernel.get(this, "csvContentTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.jsonContentTypes = software.amazon.jsii.Kernel.get(this, "jsonContentTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.csvContentTypes = builder.csvContentTypes;
                this.jsonContentTypes = builder.jsonContentTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getCsvContentTypes() {
                return this.csvContentTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getJsonContentTypes() {
                return this.jsonContentTypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCsvContentTypes() != null) {
                    data.set("csvContentTypes", om.valueToTree(this.getCsvContentTypes()));
                }
                if (this.getJsonContentTypes() != null) {
                    data.set("jsonContentTypes", om.valueToTree(this.getJsonContentTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CaptureContentTypeHeaderProperty.Jsii$Proxy that = (CaptureContentTypeHeaderProperty.Jsii$Proxy) o;

                if (this.csvContentTypes != null ? !this.csvContentTypes.equals(that.csvContentTypes) : that.csvContentTypes != null) return false;
                return this.jsonContentTypes != null ? this.jsonContentTypes.equals(that.jsonContentTypes) : that.jsonContentTypes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.csvContentTypes != null ? this.csvContentTypes.hashCode() : 0;
                result = 31 * result + (this.jsonContentTypes != null ? this.jsonContentTypes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies whether the endpoint captures input data or output data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CaptureOptionProperty captureOptionProperty = CaptureOptionProperty.builder()
     *         .captureMode("captureMode")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnEndpointConfig.CaptureOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(CaptureOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CaptureOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the endpoint captures input data or output data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCaptureMode();

        /**
         * @return a {@link Builder} of {@link CaptureOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CaptureOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CaptureOptionProperty> {
            java.lang.String captureMode;

            /**
             * Sets the value of {@link CaptureOptionProperty#getCaptureMode}
             * @param captureMode Specifies whether the endpoint captures input data or output data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureMode(java.lang.String captureMode) {
                this.captureMode = captureMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CaptureOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CaptureOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CaptureOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaptureOptionProperty {
            private final java.lang.String captureMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.captureMode = software.amazon.jsii.Kernel.get(this, "captureMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.captureMode = java.util.Objects.requireNonNull(builder.captureMode, "captureMode is required");
            }

            @Override
            public final java.lang.String getCaptureMode() {
                return this.captureMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("captureMode", om.valueToTree(this.getCaptureMode()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnEndpointConfig.CaptureOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CaptureOptionProperty.Jsii$Proxy that = (CaptureOptionProperty.Jsii$Proxy) o;

                return this.captureMode.equals(that.captureMode);
            }

            @Override
            public final int hashCode() {
                int result = this.captureMode.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the configuration of your endpoint for model monitor data capture.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DataCaptureConfigProperty dataCaptureConfigProperty = DataCaptureConfigProperty.builder()
     *         .captureOptions(List.of(CaptureOptionProperty.builder()
     *                 .captureMode("captureMode")
     *                 .build()))
     *         .destinationS3Uri("destinationS3Uri")
     *         .initialSamplingPercentage(123)
     *         // the properties below are optional
     *         .captureContentTypeHeader(CaptureContentTypeHeaderProperty.builder()
     *                 .csvContentTypes(List.of("csvContentTypes"))
     *                 .jsonContentTypes(List.of("jsonContentTypes"))
     *                 .build())
     *         .enableCapture(false)
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnEndpointConfig.DataCaptureConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DataCaptureConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataCaptureConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the endpoint captures input data to your model, output data from your model, or both.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCaptureOptions();

        /**
         * The S3 bucket where model monitor stores captured data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestinationS3Uri();

        /**
         * The percentage of data to capture.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInitialSamplingPercentage();

        /**
         * A list of the JSON and CSV content type that the endpoint captures.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCaptureContentTypeHeader() {
            return null;
        }

        /**
         * Set to `True` to enable data capture.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableCapture() {
            return null;
        }

        /**
         * The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the captured data at rest using Amazon S3 server-side encryption.
         * <p>
         * The KmsKeyId can be any of the following formats: Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab Alias name: alias/ExampleAlias Alias name ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account. For more information, see KMS-Managed Encryption Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the Amazon Simple Storage Service Developer Guide. The KMS key policy must grant permission to the IAM role that you specify in your CreateModel (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html) request. For more information, see Using Key Policies in AWS KMS (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the AWS Key Management Service Developer Guide.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataCaptureConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataCaptureConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataCaptureConfigProperty> {
            java.lang.Object captureOptions;
            java.lang.String destinationS3Uri;
            java.lang.Number initialSamplingPercentage;
            java.lang.Object captureContentTypeHeader;
            java.lang.Object enableCapture;
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getCaptureOptions}
             * @param captureOptions Specifies whether the endpoint captures input data to your model, output data from your model, or both. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureOptions(software.amazon.awscdk.core.IResolvable captureOptions) {
                this.captureOptions = captureOptions;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getCaptureOptions}
             * @param captureOptions Specifies whether the endpoint captures input data to your model, output data from your model, or both. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureOptions(java.util.List<? extends java.lang.Object> captureOptions) {
                this.captureOptions = captureOptions;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getDestinationS3Uri}
             * @param destinationS3Uri The S3 bucket where model monitor stores captured data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationS3Uri(java.lang.String destinationS3Uri) {
                this.destinationS3Uri = destinationS3Uri;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getInitialSamplingPercentage}
             * @param initialSamplingPercentage The percentage of data to capture. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initialSamplingPercentage(java.lang.Number initialSamplingPercentage) {
                this.initialSamplingPercentage = initialSamplingPercentage;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getCaptureContentTypeHeader}
             * @param captureContentTypeHeader A list of the JSON and CSV content type that the endpoint captures.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureContentTypeHeader(software.amazon.awscdk.core.IResolvable captureContentTypeHeader) {
                this.captureContentTypeHeader = captureContentTypeHeader;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getCaptureContentTypeHeader}
             * @param captureContentTypeHeader A list of the JSON and CSV content type that the endpoint captures.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureContentTypeHeader(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty captureContentTypeHeader) {
                this.captureContentTypeHeader = captureContentTypeHeader;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getEnableCapture}
             * @param enableCapture Set to `True` to enable data capture.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableCapture(java.lang.Boolean enableCapture) {
                this.enableCapture = enableCapture;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getEnableCapture}
             * @param enableCapture Set to `True` to enable data capture.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableCapture(software.amazon.awscdk.core.IResolvable enableCapture) {
                this.enableCapture = enableCapture;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getKmsKeyId}
             * @param kmsKeyId The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the captured data at rest using Amazon S3 server-side encryption.
             *                 The KmsKeyId can be any of the following formats: Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab Alias name: alias/ExampleAlias Alias name ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account. For more information, see KMS-Managed Encryption Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the Amazon Simple Storage Service Developer Guide. The KMS key policy must grant permission to the IAM role that you specify in your CreateModel (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html) request. For more information, see Using Key Policies in AWS KMS (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the AWS Key Management Service Developer Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataCaptureConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataCaptureConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataCaptureConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataCaptureConfigProperty {
            private final java.lang.Object captureOptions;
            private final java.lang.String destinationS3Uri;
            private final java.lang.Number initialSamplingPercentage;
            private final java.lang.Object captureContentTypeHeader;
            private final java.lang.Object enableCapture;
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.captureOptions = software.amazon.jsii.Kernel.get(this, "captureOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destinationS3Uri = software.amazon.jsii.Kernel.get(this, "destinationS3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.initialSamplingPercentage = software.amazon.jsii.Kernel.get(this, "initialSamplingPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.captureContentTypeHeader = software.amazon.jsii.Kernel.get(this, "captureContentTypeHeader", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableCapture = software.amazon.jsii.Kernel.get(this, "enableCapture", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.captureOptions = java.util.Objects.requireNonNull(builder.captureOptions, "captureOptions is required");
                this.destinationS3Uri = java.util.Objects.requireNonNull(builder.destinationS3Uri, "destinationS3Uri is required");
                this.initialSamplingPercentage = java.util.Objects.requireNonNull(builder.initialSamplingPercentage, "initialSamplingPercentage is required");
                this.captureContentTypeHeader = builder.captureContentTypeHeader;
                this.enableCapture = builder.enableCapture;
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.Object getCaptureOptions() {
                return this.captureOptions;
            }

            @Override
            public final java.lang.String getDestinationS3Uri() {
                return this.destinationS3Uri;
            }

            @Override
            public final java.lang.Number getInitialSamplingPercentage() {
                return this.initialSamplingPercentage;
            }

            @Override
            public final java.lang.Object getCaptureContentTypeHeader() {
                return this.captureContentTypeHeader;
            }

            @Override
            public final java.lang.Object getEnableCapture() {
                return this.enableCapture;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("captureOptions", om.valueToTree(this.getCaptureOptions()));
                data.set("destinationS3Uri", om.valueToTree(this.getDestinationS3Uri()));
                data.set("initialSamplingPercentage", om.valueToTree(this.getInitialSamplingPercentage()));
                if (this.getCaptureContentTypeHeader() != null) {
                    data.set("captureContentTypeHeader", om.valueToTree(this.getCaptureContentTypeHeader()));
                }
                if (this.getEnableCapture() != null) {
                    data.set("enableCapture", om.valueToTree(this.getEnableCapture()));
                }
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnEndpointConfig.DataCaptureConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataCaptureConfigProperty.Jsii$Proxy that = (DataCaptureConfigProperty.Jsii$Proxy) o;

                if (!captureOptions.equals(that.captureOptions)) return false;
                if (!destinationS3Uri.equals(that.destinationS3Uri)) return false;
                if (!initialSamplingPercentage.equals(that.initialSamplingPercentage)) return false;
                if (this.captureContentTypeHeader != null ? !this.captureContentTypeHeader.equals(that.captureContentTypeHeader) : that.captureContentTypeHeader != null) return false;
                if (this.enableCapture != null ? !this.enableCapture.equals(that.enableCapture) : that.enableCapture != null) return false;
                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.captureOptions.hashCode();
                result = 31 * result + (this.destinationS3Uri.hashCode());
                result = 31 * result + (this.initialSamplingPercentage.hashCode());
                result = 31 * result + (this.captureContentTypeHeader != null ? this.captureContentTypeHeader.hashCode() : 0);
                result = 31 * result + (this.enableCapture != null ? this.enableCapture.hashCode() : 0);
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a model that you want to host and the resources to deploy for hosting it.
     * <p>
     * If you are deploying multiple models, tell Amazon SageMaker how to distribute traffic among the models by specifying the <code>InitialVariantWeight</code> objects.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ProductionVariantProperty productionVariantProperty = ProductionVariantProperty.builder()
     *         .initialVariantWeight(123)
     *         .modelName("modelName")
     *         .variantName("variantName")
     *         // the properties below are optional
     *         .acceleratorType("acceleratorType")
     *         .initialInstanceCount(123)
     *         .instanceType("instanceType")
     *         .serverlessConfig(ServerlessConfigProperty.builder()
     *                 .maxConcurrency(123)
     *                 .memorySizeInMb(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnEndpointConfig.ProductionVariantProperty")
    @software.amazon.jsii.Jsii.Proxy(ProductionVariantProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProductionVariantProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines initial traffic distribution among all of the models that you specify in the endpoint configuration.
         * <p>
         * The traffic to a production variant is determined by the ratio of the <code>VariantWeight</code> to the sum of all <code>VariantWeight</code> values across all ProductionVariants. If unspecified, it defaults to 1.0.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInitialVariantWeight();

        /**
         * The name of the model that you want to host.
         * <p>
         * This is the name that you specified when creating the model.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getModelName();

        /**
         * The name of the production variant.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVariantName();

        /**
         * The size of the Elastic Inference (EI) instance to use for the production variant.
         * <p>
         * EI instances provide on-demand GPU computing for inference. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a> . For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAcceleratorType() {
            return null;
        }

        /**
         * Number of instances to launch initially.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInitialInstanceCount() {
            return null;
        }

        /**
         * The ML compute instance type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * The serverless configuration for an endpoint. Specifies a serverless endpoint configuration instead of an instance-based endpoint configuration.
         * <p>
         * <blockquote>
         * <p>
         * Serverless Inference is in preview release for Amazon SageMaker and is subject to change. We do not recommend using this feature in production environments.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServerlessConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProductionVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProductionVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProductionVariantProperty> {
            java.lang.Number initialVariantWeight;
            java.lang.String modelName;
            java.lang.String variantName;
            java.lang.String acceleratorType;
            java.lang.Number initialInstanceCount;
            java.lang.String instanceType;
            java.lang.Object serverlessConfig;

            /**
             * Sets the value of {@link ProductionVariantProperty#getInitialVariantWeight}
             * @param initialVariantWeight Determines initial traffic distribution among all of the models that you specify in the endpoint configuration. This parameter is required.
             *                             The traffic to a production variant is determined by the ratio of the <code>VariantWeight</code> to the sum of all <code>VariantWeight</code> values across all ProductionVariants. If unspecified, it defaults to 1.0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initialVariantWeight(java.lang.Number initialVariantWeight) {
                this.initialVariantWeight = initialVariantWeight;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getModelName}
             * @param modelName The name of the model that you want to host. This parameter is required.
             *                  This is the name that you specified when creating the model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelName(java.lang.String modelName) {
                this.modelName = modelName;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getVariantName}
             * @param variantName The name of the production variant. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variantName(java.lang.String variantName) {
                this.variantName = variantName;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getAcceleratorType}
             * @param acceleratorType The size of the Elastic Inference (EI) instance to use for the production variant.
             *                        EI instances provide on-demand GPU computing for inference. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a> . For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorType(java.lang.String acceleratorType) {
                this.acceleratorType = acceleratorType;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getInitialInstanceCount}
             * @param initialInstanceCount Number of instances to launch initially.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initialInstanceCount(java.lang.Number initialInstanceCount) {
                this.initialInstanceCount = initialInstanceCount;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getInstanceType}
             * @param instanceType The ML compute instance type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getServerlessConfig}
             * @param serverlessConfig The serverless configuration for an endpoint. Specifies a serverless endpoint configuration instead of an instance-based endpoint configuration.
             *                         <blockquote>
             *                         <p>
             *                         Serverless Inference is in preview release for Amazon SageMaker and is subject to change. We do not recommend using this feature in production environments.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverlessConfig(software.amazon.awscdk.core.IResolvable serverlessConfig) {
                this.serverlessConfig = serverlessConfig;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getServerlessConfig}
             * @param serverlessConfig The serverless configuration for an endpoint. Specifies a serverless endpoint configuration instead of an instance-based endpoint configuration.
             *                         <blockquote>
             *                         <p>
             *                         Serverless Inference is in preview release for Amazon SageMaker and is subject to change. We do not recommend using this feature in production environments.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverlessConfig(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ServerlessConfigProperty serverlessConfig) {
                this.serverlessConfig = serverlessConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProductionVariantProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProductionVariantProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProductionVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProductionVariantProperty {
            private final java.lang.Number initialVariantWeight;
            private final java.lang.String modelName;
            private final java.lang.String variantName;
            private final java.lang.String acceleratorType;
            private final java.lang.Number initialInstanceCount;
            private final java.lang.String instanceType;
            private final java.lang.Object serverlessConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.initialVariantWeight = software.amazon.jsii.Kernel.get(this, "initialVariantWeight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.modelName = software.amazon.jsii.Kernel.get(this, "modelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.variantName = software.amazon.jsii.Kernel.get(this, "variantName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.acceleratorType = software.amazon.jsii.Kernel.get(this, "acceleratorType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.initialInstanceCount = software.amazon.jsii.Kernel.get(this, "initialInstanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serverlessConfig = software.amazon.jsii.Kernel.get(this, "serverlessConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.initialVariantWeight = java.util.Objects.requireNonNull(builder.initialVariantWeight, "initialVariantWeight is required");
                this.modelName = java.util.Objects.requireNonNull(builder.modelName, "modelName is required");
                this.variantName = java.util.Objects.requireNonNull(builder.variantName, "variantName is required");
                this.acceleratorType = builder.acceleratorType;
                this.initialInstanceCount = builder.initialInstanceCount;
                this.instanceType = builder.instanceType;
                this.serverlessConfig = builder.serverlessConfig;
            }

            @Override
            public final java.lang.Number getInitialVariantWeight() {
                return this.initialVariantWeight;
            }

            @Override
            public final java.lang.String getModelName() {
                return this.modelName;
            }

            @Override
            public final java.lang.String getVariantName() {
                return this.variantName;
            }

            @Override
            public final java.lang.String getAcceleratorType() {
                return this.acceleratorType;
            }

            @Override
            public final java.lang.Number getInitialInstanceCount() {
                return this.initialInstanceCount;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.Object getServerlessConfig() {
                return this.serverlessConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("initialVariantWeight", om.valueToTree(this.getInitialVariantWeight()));
                data.set("modelName", om.valueToTree(this.getModelName()));
                data.set("variantName", om.valueToTree(this.getVariantName()));
                if (this.getAcceleratorType() != null) {
                    data.set("acceleratorType", om.valueToTree(this.getAcceleratorType()));
                }
                if (this.getInitialInstanceCount() != null) {
                    data.set("initialInstanceCount", om.valueToTree(this.getInitialInstanceCount()));
                }
                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getServerlessConfig() != null) {
                    data.set("serverlessConfig", om.valueToTree(this.getServerlessConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnEndpointConfig.ProductionVariantProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProductionVariantProperty.Jsii$Proxy that = (ProductionVariantProperty.Jsii$Proxy) o;

                if (!initialVariantWeight.equals(that.initialVariantWeight)) return false;
                if (!modelName.equals(that.modelName)) return false;
                if (!variantName.equals(that.variantName)) return false;
                if (this.acceleratorType != null ? !this.acceleratorType.equals(that.acceleratorType) : that.acceleratorType != null) return false;
                if (this.initialInstanceCount != null ? !this.initialInstanceCount.equals(that.initialInstanceCount) : that.initialInstanceCount != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                return this.serverlessConfig != null ? this.serverlessConfig.equals(that.serverlessConfig) : that.serverlessConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.initialVariantWeight.hashCode();
                result = 31 * result + (this.modelName.hashCode());
                result = 31 * result + (this.variantName.hashCode());
                result = 31 * result + (this.acceleratorType != null ? this.acceleratorType.hashCode() : 0);
                result = 31 * result + (this.initialInstanceCount != null ? this.initialInstanceCount.hashCode() : 0);
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.serverlessConfig != null ? this.serverlessConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * > Serverless Inference is in preview release for Amazon SageMaker and is subject to change.
     * <p>
     * We do not recommend using this feature in production environments.
     * <p>
     * Specifies the serverless configuration for an endpoint variant.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ServerlessConfigProperty serverlessConfigProperty = ServerlessConfigProperty.builder()
     *         .maxConcurrency(123)
     *         .memorySizeInMb(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnEndpointConfig.ServerlessConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerlessConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerlessConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of concurrent invocations your serverless endpoint can process.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxConcurrency();

        /**
         * The memory size of your serverless endpoint.
         * <p>
         * Valid values are in 1 GB increments: 1024 MB, 2048 MB, 3072 MB, 4096 MB, 5120 MB, or 6144 MB.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMemorySizeInMb();

        /**
         * @return a {@link Builder} of {@link ServerlessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerlessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerlessConfigProperty> {
            java.lang.Number maxConcurrency;
            java.lang.Number memorySizeInMb;

            /**
             * Sets the value of {@link ServerlessConfigProperty#getMaxConcurrency}
             * @param maxConcurrency The maximum number of concurrent invocations your serverless endpoint can process. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxConcurrency(java.lang.Number maxConcurrency) {
                this.maxConcurrency = maxConcurrency;
                return this;
            }

            /**
             * Sets the value of {@link ServerlessConfigProperty#getMemorySizeInMb}
             * @param memorySizeInMb The memory size of your serverless endpoint. This parameter is required.
             *                       Valid values are in 1 GB increments: 1024 MB, 2048 MB, 3072 MB, 4096 MB, 5120 MB, or 6144 MB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memorySizeInMb(java.lang.Number memorySizeInMb) {
                this.memorySizeInMb = memorySizeInMb;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerlessConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerlessConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServerlessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerlessConfigProperty {
            private final java.lang.Number maxConcurrency;
            private final java.lang.Number memorySizeInMb;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxConcurrency = software.amazon.jsii.Kernel.get(this, "maxConcurrency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.memorySizeInMb = software.amazon.jsii.Kernel.get(this, "memorySizeInMb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxConcurrency = java.util.Objects.requireNonNull(builder.maxConcurrency, "maxConcurrency is required");
                this.memorySizeInMb = java.util.Objects.requireNonNull(builder.memorySizeInMb, "memorySizeInMb is required");
            }

            @Override
            public final java.lang.Number getMaxConcurrency() {
                return this.maxConcurrency;
            }

            @Override
            public final java.lang.Number getMemorySizeInMb() {
                return this.memorySizeInMb;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxConcurrency", om.valueToTree(this.getMaxConcurrency()));
                data.set("memorySizeInMb", om.valueToTree(this.getMemorySizeInMb()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnEndpointConfig.ServerlessConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerlessConfigProperty.Jsii$Proxy that = (ServerlessConfigProperty.Jsii$Proxy) o;

                if (!maxConcurrency.equals(that.maxConcurrency)) return false;
                return this.memorySizeInMb.equals(that.memorySizeInMb);
            }

            @Override
            public final int hashCode() {
                int result = this.maxConcurrency.hashCode();
                result = 31 * result + (this.memorySizeInMb.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnEndpointConfig> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnEndpointConfigProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnEndpointConfigProps.Builder();
        }

        /**
         * A list of `ProductionVariant` objects, one for each model that you want to host at this endpoint.
         * <p>
         * @return {@code this}
         * @param productionVariants A list of `ProductionVariant` objects, one for each model that you want to host at this endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productionVariants(final software.amazon.awscdk.core.IResolvable productionVariants) {
            this.props.productionVariants(productionVariants);
            return this;
        }
        /**
         * A list of `ProductionVariant` objects, one for each model that you want to host at this endpoint.
         * <p>
         * @return {@code this}
         * @param productionVariants A list of `ProductionVariant` objects, one for each model that you want to host at this endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productionVariants(final java.util.List<? extends java.lang.Object> productionVariants) {
            this.props.productionVariants(productionVariants);
            return this;
        }

        /**
         * Specifies configuration for how an endpoint performs asynchronous inference.
         * <p>
         * @return {@code this}
         * @param asyncInferenceConfig Specifies configuration for how an endpoint performs asynchronous inference. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder asyncInferenceConfig(final software.amazon.awscdk.core.IResolvable asyncInferenceConfig) {
            this.props.asyncInferenceConfig(asyncInferenceConfig);
            return this;
        }
        /**
         * Specifies configuration for how an endpoint performs asynchronous inference.
         * <p>
         * @return {@code this}
         * @param asyncInferenceConfig Specifies configuration for how an endpoint performs asynchronous inference. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder asyncInferenceConfig(final software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty asyncInferenceConfig) {
            this.props.asyncInferenceConfig(asyncInferenceConfig);
            return this;
        }

        /**
         * Specifies how to capture endpoint data for model monitor.
         * <p>
         * The data capture configuration applies to all production variants hosted at the endpoint.
         * <p>
         * @return {@code this}
         * @param dataCaptureConfig Specifies how to capture endpoint data for model monitor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCaptureConfig(final software.amazon.awscdk.core.IResolvable dataCaptureConfig) {
            this.props.dataCaptureConfig(dataCaptureConfig);
            return this;
        }
        /**
         * Specifies how to capture endpoint data for model monitor.
         * <p>
         * The data capture configuration applies to all production variants hosted at the endpoint.
         * <p>
         * @return {@code this}
         * @param dataCaptureConfig Specifies how to capture endpoint data for model monitor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCaptureConfig(final software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.DataCaptureConfigProperty dataCaptureConfig) {
            this.props.dataCaptureConfig(dataCaptureConfig);
            return this;
        }

        /**
         * The name of the endpoint configuration.
         * <p>
         * @return {@code this}
         * @param endpointConfigName The name of the endpoint configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfigName(final java.lang.String endpointConfigName) {
            this.props.endpointConfigName(endpointConfigName);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
         * <p>
         * <ul>
         * <li>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
         * <li>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
         * <li>Alias name: <code>alias/ExampleAlias</code></li>
         * <li>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code></li>
         * </ul>
         * <p>
         * The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateEndpoint</code> , <code>UpdateEndpoint</code> requests. For more information, refer to the AWS Key Management Service section <a href="https://docs.aws.amazon.com//kms/latest/developerguide/key-policies.html">Using Key Policies in AWS KMS</a>
         * <p>
         * <blockquote>
         * <p>
         * Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a <code>KmsKeyId</code> when using an instance type with local storage. If any of the models that you specify in the <code>ProductionVariants</code> parameter use nitro-based instances with local storage, do not specify a value for the <code>KmsKeyId</code> parameter. If you specify a value for <code>KmsKeyId</code> when using any nitro-based instances with local storage, the call to <code>CreateEndpointConfig</code> fails.
         * <p>
         * For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a> .
         * <p>
         * For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param kmsKeyId The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * A list of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource Tag</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> .
         * <p>
         * @return {@code this}
         * @param tags A list of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnEndpointConfig build() {
            return new software.amazon.awscdk.services.sagemaker.CfnEndpointConfig(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
