package software.amazon.awscdk.services.sagemaker;

/**
 * A CloudFormation `AWS::SageMaker::DeviceFleet`.
 * <p>
 * The <code>AWS::SageMaker::DeviceFleet</code> resource is an Amazon SageMaker resource type that allows you to create a DeviceFleet that manages your SageMaker Edge Manager Devices. You must register your devices against the <code>DeviceFleet</code> separately.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnDeviceFleet cfnDeviceFleet = CfnDeviceFleet.Builder.create(this, "MyCfnDeviceFleet")
 *         .deviceFleetName("deviceFleetName")
 *         .outputConfig(EdgeOutputConfigProperty.builder()
 *                 .s3OutputLocation("s3OutputLocation")
 *                 // the properties below are optional
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-13T01:13:30.219Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnDeviceFleet")
public class CfnDeviceFleet extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnDeviceFleet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDeviceFleet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnDeviceFleet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::SageMaker::DeviceFleet`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDeviceFleet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnDeviceFleetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of key-value pairs that contain metadata to help you categorize and organize your device fleets.
     * <p>
     * Each tag consists of a key and a value, both of which you define.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * Name of the device fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDeviceFleetName() {
        return software.amazon.jsii.Kernel.get(this, "deviceFleetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Name of the device fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeviceFleetName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deviceFleetName", java.util.Objects.requireNonNull(value, "deviceFleetName is required"));
    }

    /**
     * The output configuration for storing sample data collected by the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getOutputConfig() {
        return software.amazon.jsii.Kernel.get(this, "outputConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The output configuration for storing sample data collected by the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "outputConfig", java.util.Objects.requireNonNull(value, "outputConfig is required"));
    }

    /**
     * The output configuration for storing sample data collected by the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnDeviceFleet.EdgeOutputConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "outputConfig", java.util.Objects.requireNonNull(value, "outputConfig is required"));
    }

    /**
     * The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * A description of the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }
    /**
     * The output configuration for storing sample data collected by the fleet.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * EdgeOutputConfigProperty edgeOutputConfigProperty = EdgeOutputConfigProperty.builder()
     *         .s3OutputLocation("s3OutputLocation")
     *         // the properties below are optional
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnDeviceFleet.EdgeOutputConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EdgeOutputConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EdgeOutputConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Simple Storage (S3) bucket URI.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3OutputLocation();

        /**
         * The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job.
         * <p>
         * If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EdgeOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EdgeOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EdgeOutputConfigProperty> {
            java.lang.String s3OutputLocation;
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link EdgeOutputConfigProperty#getS3OutputLocation}
             * @param s3OutputLocation The Amazon Simple Storage (S3) bucket URI. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OutputLocation(java.lang.String s3OutputLocation) {
                this.s3OutputLocation = s3OutputLocation;
                return this;
            }

            /**
             * Sets the value of {@link EdgeOutputConfigProperty#getKmsKeyId}
             * @param kmsKeyId The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job.
             *                 If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EdgeOutputConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EdgeOutputConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EdgeOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EdgeOutputConfigProperty {
            private final java.lang.String s3OutputLocation;
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3OutputLocation = software.amazon.jsii.Kernel.get(this, "s3OutputLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3OutputLocation = java.util.Objects.requireNonNull(builder.s3OutputLocation, "s3OutputLocation is required");
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.String getS3OutputLocation() {
                return this.s3OutputLocation;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3OutputLocation", om.valueToTree(this.getS3OutputLocation()));
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnDeviceFleet.EdgeOutputConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EdgeOutputConfigProperty.Jsii$Proxy that = (EdgeOutputConfigProperty.Jsii$Proxy) o;

                if (!s3OutputLocation.equals(that.s3OutputLocation)) return false;
                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3OutputLocation.hashCode();
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnDeviceFleet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnDeviceFleet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnDeviceFleetProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnDeviceFleetProps.Builder();
        }

        /**
         * Name of the device fleet.
         * <p>
         * @return {@code this}
         * @param deviceFleetName Name of the device fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceFleetName(final java.lang.String deviceFleetName) {
            this.props.deviceFleetName(deviceFleetName);
            return this;
        }

        /**
         * The output configuration for storing sample data collected by the fleet.
         * <p>
         * @return {@code this}
         * @param outputConfig The output configuration for storing sample data collected by the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputConfig(final software.amazon.awscdk.core.IResolvable outputConfig) {
            this.props.outputConfig(outputConfig);
            return this;
        }
        /**
         * The output configuration for storing sample data collected by the fleet.
         * <p>
         * @return {@code this}
         * @param outputConfig The output configuration for storing sample data collected by the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputConfig(final software.amazon.awscdk.services.sagemaker.CfnDeviceFleet.EdgeOutputConfigProperty outputConfig) {
            this.props.outputConfig(outputConfig);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).
         * <p>
         * @return {@code this}
         * @param roleArn The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * A description of the fleet.
         * <p>
         * @return {@code this}
         * @param description A description of the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * An array of key-value pairs that contain metadata to help you categorize and organize your device fleets.
         * <p>
         * Each tag consists of a key and a value, both of which you define.
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs that contain metadata to help you categorize and organize your device fleets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnDeviceFleet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnDeviceFleet build() {
            return new software.amazon.awscdk.services.sagemaker.CfnDeviceFleet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
