package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a `CfnImage`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnImageProps cfnImageProps = CfnImageProps.builder()
 *         .imageName("imageName")
 *         .imageRoleArn("imageRoleArn")
 *         // the properties below are optional
 *         .imageDescription("imageDescription")
 *         .imageDisplayName("imageDisplayName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-06-03T00:11:29.094Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnImageProps")
@software.amazon.jsii.Jsii.Proxy(CfnImageProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnImageProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Image. Must be unique by region in your account.
     * <p>
     * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 63.
     * <p>
     * <em>Pattern</em> : <code>^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getImageName();

    /**
     * The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.
     * <p>
     * <em>Length Constraints</em> : Minimum length of 20. Maximum length of 2048.
     * <p>
     * <em>Pattern</em> : <code>^arn:aws[a-z\-]*:iam::\d{12}:role/?[a-zA-Z_0-9+=,.&#64;\-_/]+$</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getImageRoleArn();

    /**
     * The description of the image.
     * <p>
     * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 512.
     * <p>
     * <em>Pattern</em> : <code>.*</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageDescription() {
        return null;
    }

    /**
     * The display name of the image.
     * <p>
     * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 128.
     * <p>
     * <em>Pattern</em> : <code>^\S(.*\S)?$</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageDisplayName() {
        return null;
    }

    /**
     * A list of key-value pairs to apply to this resource.
     * <p>
     * <em>Array Members</em> : Minimum number of 0 items. Maximum number of 50 items.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnImageProps> {
        java.lang.String imageName;
        java.lang.String imageRoleArn;
        java.lang.String imageDescription;
        java.lang.String imageDisplayName;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnImageProps#getImageName}
         * @param imageName The name of the Image. Must be unique by region in your account. This parameter is required.
         *                  <em>Length Constraints</em> : Minimum length of 1. Maximum length of 63.
         *                  <p>
         *                  <em>Pattern</em> : <code>^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageName(java.lang.String imageName) {
            this.imageName = imageName;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getImageRoleArn}
         * @param imageRoleArn The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf. This parameter is required.
         *                     <em>Length Constraints</em> : Minimum length of 20. Maximum length of 2048.
         *                     <p>
         *                     <em>Pattern</em> : <code>^arn:aws[a-z\-]*:iam::\d{12}:role/?[a-zA-Z_0-9+=,.&#64;\-_/]+$</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageRoleArn(java.lang.String imageRoleArn) {
            this.imageRoleArn = imageRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getImageDescription}
         * @param imageDescription The description of the image.
         *                         <em>Length Constraints</em> : Minimum length of 1. Maximum length of 512.
         *                         <p>
         *                         <em>Pattern</em> : <code>.*</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageDescription(java.lang.String imageDescription) {
            this.imageDescription = imageDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getImageDisplayName}
         * @param imageDisplayName The display name of the image.
         *                         <em>Length Constraints</em> : Minimum length of 1. Maximum length of 128.
         *                         <p>
         *                         <em>Pattern</em> : <code>^\S(.*\S)?$</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageDisplayName(java.lang.String imageDisplayName) {
            this.imageDisplayName = imageDisplayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getTags}
         * @param tags A list of key-value pairs to apply to this resource.
         *             <em>Array Members</em> : Minimum number of 0 items. Maximum number of 50 items.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnImageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnImageProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnImageProps {
        private final java.lang.String imageName;
        private final java.lang.String imageRoleArn;
        private final java.lang.String imageDescription;
        private final java.lang.String imageDisplayName;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.imageName = software.amazon.jsii.Kernel.get(this, "imageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageRoleArn = software.amazon.jsii.Kernel.get(this, "imageRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageDescription = software.amazon.jsii.Kernel.get(this, "imageDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageDisplayName = software.amazon.jsii.Kernel.get(this, "imageDisplayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.imageName = java.util.Objects.requireNonNull(builder.imageName, "imageName is required");
            this.imageRoleArn = java.util.Objects.requireNonNull(builder.imageRoleArn, "imageRoleArn is required");
            this.imageDescription = builder.imageDescription;
            this.imageDisplayName = builder.imageDisplayName;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getImageName() {
            return this.imageName;
        }

        @Override
        public final java.lang.String getImageRoleArn() {
            return this.imageRoleArn;
        }

        @Override
        public final java.lang.String getImageDescription() {
            return this.imageDescription;
        }

        @Override
        public final java.lang.String getImageDisplayName() {
            return this.imageDisplayName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("imageName", om.valueToTree(this.getImageName()));
            data.set("imageRoleArn", om.valueToTree(this.getImageRoleArn()));
            if (this.getImageDescription() != null) {
                data.set("imageDescription", om.valueToTree(this.getImageDescription()));
            }
            if (this.getImageDisplayName() != null) {
                data.set("imageDisplayName", om.valueToTree(this.getImageDisplayName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnImageProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnImageProps.Jsii$Proxy that = (CfnImageProps.Jsii$Proxy) o;

            if (!imageName.equals(that.imageName)) return false;
            if (!imageRoleArn.equals(that.imageRoleArn)) return false;
            if (this.imageDescription != null ? !this.imageDescription.equals(that.imageDescription) : that.imageDescription != null) return false;
            if (this.imageDisplayName != null ? !this.imageDisplayName.equals(that.imageDisplayName) : that.imageDisplayName != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.imageName.hashCode();
            result = 31 * result + (this.imageRoleArn.hashCode());
            result = 31 * result + (this.imageDescription != null ? this.imageDescription.hashCode() : 0);
            result = 31 * result + (this.imageDisplayName != null ? this.imageDisplayName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
