package software.amazon.awscdk.services.sagemaker;

/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 * <p>
 * Creates the definition for a model bias job.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnModelBiasJobDefinition cfnModelBiasJobDefinition = CfnModelBiasJobDefinition.Builder.create(this, "MyCfnModelBiasJobDefinition")
 *         .jobResources(MonitoringResourcesProperty.builder()
 *                 .clusterConfig(ClusterConfigProperty.builder()
 *                         .instanceCount(123)
 *                         .instanceType("instanceType")
 *                         .volumeSizeInGb(123)
 *                         // the properties below are optional
 *                         .volumeKmsKeyId("volumeKmsKeyId")
 *                         .build())
 *                 .build())
 *         .modelBiasAppSpecification(ModelBiasAppSpecificationProperty.builder()
 *                 .configUri("configUri")
 *                 .imageUri("imageUri")
 *                 // the properties below are optional
 *                 .environment(Map.of(
 *                         "environmentKey", "environment"))
 *                 .build())
 *         .modelBiasJobInput(ModelBiasJobInputProperty.builder()
 *                 .endpointInput(EndpointInputProperty.builder()
 *                         .endpointName("endpointName")
 *                         .localPath("localPath")
 *                         // the properties below are optional
 *                         .endTimeOffset("endTimeOffset")
 *                         .featuresAttribute("featuresAttribute")
 *                         .inferenceAttribute("inferenceAttribute")
 *                         .probabilityAttribute("probabilityAttribute")
 *                         .probabilityThresholdAttribute(123)
 *                         .s3DataDistributionType("s3DataDistributionType")
 *                         .s3InputMode("s3InputMode")
 *                         .startTimeOffset("startTimeOffset")
 *                         .build())
 *                 .groundTruthS3Input(MonitoringGroundTruthS3InputProperty.builder()
 *                         .s3Uri("s3Uri")
 *                         .build())
 *                 .build())
 *         .modelBiasJobOutputConfig(MonitoringOutputConfigProperty.builder()
 *                 .monitoringOutputs(List.of(MonitoringOutputProperty.builder()
 *                         .s3Output(S3OutputProperty.builder()
 *                                 .localPath("localPath")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .s3UploadMode("s3UploadMode")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .jobDefinitionName("jobDefinitionName")
 *         .modelBiasBaselineConfig(ModelBiasBaselineConfigProperty.builder()
 *                 .baseliningJobName("baseliningJobName")
 *                 .constraintsResource(ConstraintsResourceProperty.builder()
 *                         .s3Uri("s3Uri")
 *                         .build())
 *                 .build())
 *         .networkConfig(NetworkConfigProperty.builder()
 *                 .enableInterContainerTrafficEncryption(false)
 *                 .enableNetworkIsolation(false)
 *                 .vpcConfig(VpcConfigProperty.builder()
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnets(List.of("subnets"))
 *                         .build())
 *                 .build())
 *         .stoppingCondition(StoppingConditionProperty.builder()
 *                 .maxRuntimeInSeconds(123)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-07-09T01:30:39.177Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition")
public class CfnModelBiasJobDefinition extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnModelBiasJobDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnModelBiasJobDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::SageMaker::ModelBiasJobDefinition`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnModelBiasJobDefinition(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The time when the job definition was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrJobDefinitionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrJobDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * Identifies the resources to deploy for a monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getJobResources() {
        return software.amazon.jsii.Kernel.get(this, "jobResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Identifies the resources to deploy for a monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobResources(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "jobResources", java.util.Objects.requireNonNull(value, "jobResources is required"));
    }

    /**
     * Identifies the resources to deploy for a monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobResources(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.MonitoringResourcesProperty value) {
        software.amazon.jsii.Kernel.set(this, "jobResources", java.util.Objects.requireNonNull(value, "jobResources is required"));
    }

    /**
     * Configures the model bias job to run a specified Docker container image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getModelBiasAppSpecification() {
        return software.amazon.jsii.Kernel.get(this, "modelBiasAppSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configures the model bias job to run a specified Docker container image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelBiasAppSpecification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "modelBiasAppSpecification", java.util.Objects.requireNonNull(value, "modelBiasAppSpecification is required"));
    }

    /**
     * Configures the model bias job to run a specified Docker container image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelBiasAppSpecification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "modelBiasAppSpecification", java.util.Objects.requireNonNull(value, "modelBiasAppSpecification is required"));
    }

    /**
     * Inputs for the model bias job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getModelBiasJobInput() {
        return software.amazon.jsii.Kernel.get(this, "modelBiasJobInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Inputs for the model bias job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelBiasJobInput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "modelBiasJobInput", java.util.Objects.requireNonNull(value, "modelBiasJobInput is required"));
    }

    /**
     * Inputs for the model bias job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelBiasJobInput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.ModelBiasJobInputProperty value) {
        software.amazon.jsii.Kernel.set(this, "modelBiasJobInput", java.util.Objects.requireNonNull(value, "modelBiasJobInput is required"));
    }

    /**
     * The output configuration for monitoring jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getModelBiasJobOutputConfig() {
        return software.amazon.jsii.Kernel.get(this, "modelBiasJobOutputConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The output configuration for monitoring jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelBiasJobOutputConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "modelBiasJobOutputConfig", java.util.Objects.requireNonNull(value, "modelBiasJobOutputConfig is required"));
    }

    /**
     * The output configuration for monitoring jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelBiasJobOutputConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.MonitoringOutputConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "modelBiasJobOutputConfig", java.util.Objects.requireNonNull(value, "modelBiasJobOutputConfig is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * The name of the bias job definition.
     * <p>
     * The name must be unique within an AWS Region in the AWS account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getJobDefinitionName() {
        return software.amazon.jsii.Kernel.get(this, "jobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the bias job definition.
     * <p>
     * The name must be unique within an AWS Region in the AWS account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobDefinitionName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "jobDefinitionName", value);
    }

    /**
     * The baseline configuration for a model bias job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getModelBiasBaselineConfig() {
        return software.amazon.jsii.Kernel.get(this, "modelBiasBaselineConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The baseline configuration for a model bias job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelBiasBaselineConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "modelBiasBaselineConfig", value);
    }

    /**
     * The baseline configuration for a model bias job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelBiasBaselineConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "modelBiasBaselineConfig", value);
    }

    /**
     * Networking options for a model bias job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfig() {
        return software.amazon.jsii.Kernel.get(this, "networkConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Networking options for a model bias job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "networkConfig", value);
    }

    /**
     * Networking options for a model bias job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.NetworkConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "networkConfig", value);
    }

    /**
     * A time limit for how long the monitoring job is allowed to run before stopping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStoppingCondition() {
        return software.amazon.jsii.Kernel.get(this, "stoppingCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A time limit for how long the monitoring job is allowed to run before stopping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStoppingCondition(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "stoppingCondition", value);
    }

    /**
     * A time limit for how long the monitoring job is allowed to run before stopping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStoppingCondition(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.StoppingConditionProperty value) {
        software.amazon.jsii.Kernel.set(this, "stoppingCondition", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ClusterConfigProperty clusterConfigProperty = ClusterConfigProperty.builder()
     *         .instanceCount(123)
     *         .instanceType("instanceType")
     *         .volumeSizeInGb(123)
     *         // the properties below are optional
     *         .volumeKmsKeyId("volumeKmsKeyId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.ClusterConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnModelBiasJobDefinition.ClusterConfigProperty.InstanceCount`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInstanceCount();

        /**
         * `CfnModelBiasJobDefinition.ClusterConfigProperty.InstanceType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

        /**
         * `CfnModelBiasJobDefinition.ClusterConfigProperty.VolumeSizeInGB`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getVolumeSizeInGb();

        /**
         * `CfnModelBiasJobDefinition.ClusterConfigProperty.VolumeKmsKeyId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVolumeKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterConfigProperty> {
            java.lang.Number instanceCount;
            java.lang.String instanceType;
            java.lang.Number volumeSizeInGb;
            java.lang.String volumeKmsKeyId;

            /**
             * Sets the value of {@link ClusterConfigProperty#getInstanceCount}
             * @param instanceCount `CfnModelBiasJobDefinition.ClusterConfigProperty.InstanceCount`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceCount(java.lang.Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getInstanceType}
             * @param instanceType `CfnModelBiasJobDefinition.ClusterConfigProperty.InstanceType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getVolumeSizeInGb}
             * @param volumeSizeInGb `CfnModelBiasJobDefinition.ClusterConfigProperty.VolumeSizeInGB`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSizeInGb(java.lang.Number volumeSizeInGb) {
                this.volumeSizeInGb = volumeSizeInGb;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getVolumeKmsKeyId}
             * @param volumeKmsKeyId `CfnModelBiasJobDefinition.ClusterConfigProperty.VolumeKmsKeyId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeKmsKeyId(java.lang.String volumeKmsKeyId) {
                this.volumeKmsKeyId = volumeKmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterConfigProperty {
            private final java.lang.Number instanceCount;
            private final java.lang.String instanceType;
            private final java.lang.Number volumeSizeInGb;
            private final java.lang.String volumeKmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceCount = software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.volumeSizeInGb = software.amazon.jsii.Kernel.get(this, "volumeSizeInGb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeKmsKeyId = software.amazon.jsii.Kernel.get(this, "volumeKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceCount = java.util.Objects.requireNonNull(builder.instanceCount, "instanceCount is required");
                this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
                this.volumeSizeInGb = java.util.Objects.requireNonNull(builder.volumeSizeInGb, "volumeSizeInGb is required");
                this.volumeKmsKeyId = builder.volumeKmsKeyId;
            }

            @Override
            public final java.lang.Number getInstanceCount() {
                return this.instanceCount;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.Number getVolumeSizeInGb() {
                return this.volumeSizeInGb;
            }

            @Override
            public final java.lang.String getVolumeKmsKeyId() {
                return this.volumeKmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
                data.set("volumeSizeInGb", om.valueToTree(this.getVolumeSizeInGb()));
                if (this.getVolumeKmsKeyId() != null) {
                    data.set("volumeKmsKeyId", om.valueToTree(this.getVolumeKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.ClusterConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterConfigProperty.Jsii$Proxy that = (ClusterConfigProperty.Jsii$Proxy) o;

                if (!instanceCount.equals(that.instanceCount)) return false;
                if (!instanceType.equals(that.instanceType)) return false;
                if (!volumeSizeInGb.equals(that.volumeSizeInGb)) return false;
                return this.volumeKmsKeyId != null ? this.volumeKmsKeyId.equals(that.volumeKmsKeyId) : that.volumeKmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceCount.hashCode();
                result = 31 * result + (this.instanceType.hashCode());
                result = 31 * result + (this.volumeSizeInGb.hashCode());
                result = 31 * result + (this.volumeKmsKeyId != null ? this.volumeKmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The constraints resource for a monitoring job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ConstraintsResourceProperty constraintsResourceProperty = ConstraintsResourceProperty.builder()
     *         .s3Uri("s3Uri")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.ConstraintsResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(ConstraintsResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConstraintsResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 URI for the constraints resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3Uri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConstraintsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConstraintsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConstraintsResourceProperty> {
            java.lang.String s3Uri;

            /**
             * Sets the value of {@link ConstraintsResourceProperty#getS3Uri}
             * @param s3Uri The Amazon S3 URI for the constraints resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConstraintsResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConstraintsResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConstraintsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConstraintsResourceProperty {
            private final java.lang.String s3Uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Uri = builder.s3Uri;
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3Uri() != null) {
                    data.set("s3Uri", om.valueToTree(this.getS3Uri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.ConstraintsResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConstraintsResourceProperty.Jsii$Proxy that = (ConstraintsResourceProperty.Jsii$Proxy) o;

                return this.s3Uri != null ? this.s3Uri.equals(that.s3Uri) : that.s3Uri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Uri != null ? this.s3Uri.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Input object for the endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * EndpointInputProperty endpointInputProperty = EndpointInputProperty.builder()
     *         .endpointName("endpointName")
     *         .localPath("localPath")
     *         // the properties below are optional
     *         .endTimeOffset("endTimeOffset")
     *         .featuresAttribute("featuresAttribute")
     *         .inferenceAttribute("inferenceAttribute")
     *         .probabilityAttribute("probabilityAttribute")
     *         .probabilityThresholdAttribute(123)
     *         .s3DataDistributionType("s3DataDistributionType")
     *         .s3InputMode("s3InputMode")
     *         .startTimeOffset("startTimeOffset")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.EndpointInputProperty")
    @software.amazon.jsii.Jsii.Proxy(EndpointInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EndpointInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An endpoint in customer's account which has enabled `DataCaptureConfig` enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndpointName();

        /**
         * Path to the filesystem where the endpoint data is available to the container.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocalPath();

        /**
         * If specified, monitoring jobs substract this time from the end time.
         * <p>
         * For information about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model Quality Monitoring Jobs</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEndTimeOffset() {
            return null;
        }

        /**
         * The attributes of the input data that are the input features.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFeaturesAttribute() {
            return null;
        }

        /**
         * The attribute of the input data that represents the ground truth label.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInferenceAttribute() {
            return null;
        }

        /**
         * In a classification problem, the attribute that represents the class probability.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProbabilityAttribute() {
            return null;
        }

        /**
         * The threshold for the class probability to be evaluated as a positive result.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getProbabilityThresholdAttribute() {
            return null;
        }

        /**
         * Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key.
         * <p>
         * Defaults to <code>FullyReplicated</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3DataDistributionType() {
            return null;
        }

        /**
         * Whether the `Pipe` or `File` is used as the input mode for transferring data for the monitoring job.
         * <p>
         * <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful for small files that fit in memory. Defaults to <code>File</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3InputMode() {
            return null;
        }

        /**
         * If specified, monitoring jobs substract this time from the start time.
         * <p>
         * For information about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model Quality Monitoring Jobs</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStartTimeOffset() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EndpointInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EndpointInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EndpointInputProperty> {
            java.lang.String endpointName;
            java.lang.String localPath;
            java.lang.String endTimeOffset;
            java.lang.String featuresAttribute;
            java.lang.String inferenceAttribute;
            java.lang.String probabilityAttribute;
            java.lang.Number probabilityThresholdAttribute;
            java.lang.String s3DataDistributionType;
            java.lang.String s3InputMode;
            java.lang.String startTimeOffset;

            /**
             * Sets the value of {@link EndpointInputProperty#getEndpointName}
             * @param endpointName An endpoint in customer's account which has enabled `DataCaptureConfig` enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointName(java.lang.String endpointName) {
                this.endpointName = endpointName;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getLocalPath}
             * @param localPath Path to the filesystem where the endpoint data is available to the container. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localPath(java.lang.String localPath) {
                this.localPath = localPath;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getEndTimeOffset}
             * @param endTimeOffset If specified, monitoring jobs substract this time from the end time.
             *                      For information about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model Quality Monitoring Jobs</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endTimeOffset(java.lang.String endTimeOffset) {
                this.endTimeOffset = endTimeOffset;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getFeaturesAttribute}
             * @param featuresAttribute The attributes of the input data that are the input features.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featuresAttribute(java.lang.String featuresAttribute) {
                this.featuresAttribute = featuresAttribute;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getInferenceAttribute}
             * @param inferenceAttribute The attribute of the input data that represents the ground truth label.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inferenceAttribute(java.lang.String inferenceAttribute) {
                this.inferenceAttribute = inferenceAttribute;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getProbabilityAttribute}
             * @param probabilityAttribute In a classification problem, the attribute that represents the class probability.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder probabilityAttribute(java.lang.String probabilityAttribute) {
                this.probabilityAttribute = probabilityAttribute;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getProbabilityThresholdAttribute}
             * @param probabilityThresholdAttribute The threshold for the class probability to be evaluated as a positive result.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder probabilityThresholdAttribute(java.lang.Number probabilityThresholdAttribute) {
                this.probabilityThresholdAttribute = probabilityThresholdAttribute;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getS3DataDistributionType}
             * @param s3DataDistributionType Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key.
             *                               Defaults to <code>FullyReplicated</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3DataDistributionType(java.lang.String s3DataDistributionType) {
                this.s3DataDistributionType = s3DataDistributionType;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getS3InputMode}
             * @param s3InputMode Whether the `Pipe` or `File` is used as the input mode for transferring data for the monitoring job.
             *                    <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful for small files that fit in memory. Defaults to <code>File</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3InputMode(java.lang.String s3InputMode) {
                this.s3InputMode = s3InputMode;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getStartTimeOffset}
             * @param startTimeOffset If specified, monitoring jobs substract this time from the start time.
             *                        For information about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model Quality Monitoring Jobs</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTimeOffset(java.lang.String startTimeOffset) {
                this.startTimeOffset = startTimeOffset;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EndpointInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EndpointInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EndpointInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EndpointInputProperty {
            private final java.lang.String endpointName;
            private final java.lang.String localPath;
            private final java.lang.String endTimeOffset;
            private final java.lang.String featuresAttribute;
            private final java.lang.String inferenceAttribute;
            private final java.lang.String probabilityAttribute;
            private final java.lang.Number probabilityThresholdAttribute;
            private final java.lang.String s3DataDistributionType;
            private final java.lang.String s3InputMode;
            private final java.lang.String startTimeOffset;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endpointName = software.amazon.jsii.Kernel.get(this, "endpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localPath = software.amazon.jsii.Kernel.get(this, "localPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endTimeOffset = software.amazon.jsii.Kernel.get(this, "endTimeOffset", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.featuresAttribute = software.amazon.jsii.Kernel.get(this, "featuresAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inferenceAttribute = software.amazon.jsii.Kernel.get(this, "inferenceAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.probabilityAttribute = software.amazon.jsii.Kernel.get(this, "probabilityAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.probabilityThresholdAttribute = software.amazon.jsii.Kernel.get(this, "probabilityThresholdAttribute", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.s3DataDistributionType = software.amazon.jsii.Kernel.get(this, "s3DataDistributionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3InputMode = software.amazon.jsii.Kernel.get(this, "s3InputMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startTimeOffset = software.amazon.jsii.Kernel.get(this, "startTimeOffset", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endpointName = java.util.Objects.requireNonNull(builder.endpointName, "endpointName is required");
                this.localPath = java.util.Objects.requireNonNull(builder.localPath, "localPath is required");
                this.endTimeOffset = builder.endTimeOffset;
                this.featuresAttribute = builder.featuresAttribute;
                this.inferenceAttribute = builder.inferenceAttribute;
                this.probabilityAttribute = builder.probabilityAttribute;
                this.probabilityThresholdAttribute = builder.probabilityThresholdAttribute;
                this.s3DataDistributionType = builder.s3DataDistributionType;
                this.s3InputMode = builder.s3InputMode;
                this.startTimeOffset = builder.startTimeOffset;
            }

            @Override
            public final java.lang.String getEndpointName() {
                return this.endpointName;
            }

            @Override
            public final java.lang.String getLocalPath() {
                return this.localPath;
            }

            @Override
            public final java.lang.String getEndTimeOffset() {
                return this.endTimeOffset;
            }

            @Override
            public final java.lang.String getFeaturesAttribute() {
                return this.featuresAttribute;
            }

            @Override
            public final java.lang.String getInferenceAttribute() {
                return this.inferenceAttribute;
            }

            @Override
            public final java.lang.String getProbabilityAttribute() {
                return this.probabilityAttribute;
            }

            @Override
            public final java.lang.Number getProbabilityThresholdAttribute() {
                return this.probabilityThresholdAttribute;
            }

            @Override
            public final java.lang.String getS3DataDistributionType() {
                return this.s3DataDistributionType;
            }

            @Override
            public final java.lang.String getS3InputMode() {
                return this.s3InputMode;
            }

            @Override
            public final java.lang.String getStartTimeOffset() {
                return this.startTimeOffset;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endpointName", om.valueToTree(this.getEndpointName()));
                data.set("localPath", om.valueToTree(this.getLocalPath()));
                if (this.getEndTimeOffset() != null) {
                    data.set("endTimeOffset", om.valueToTree(this.getEndTimeOffset()));
                }
                if (this.getFeaturesAttribute() != null) {
                    data.set("featuresAttribute", om.valueToTree(this.getFeaturesAttribute()));
                }
                if (this.getInferenceAttribute() != null) {
                    data.set("inferenceAttribute", om.valueToTree(this.getInferenceAttribute()));
                }
                if (this.getProbabilityAttribute() != null) {
                    data.set("probabilityAttribute", om.valueToTree(this.getProbabilityAttribute()));
                }
                if (this.getProbabilityThresholdAttribute() != null) {
                    data.set("probabilityThresholdAttribute", om.valueToTree(this.getProbabilityThresholdAttribute()));
                }
                if (this.getS3DataDistributionType() != null) {
                    data.set("s3DataDistributionType", om.valueToTree(this.getS3DataDistributionType()));
                }
                if (this.getS3InputMode() != null) {
                    data.set("s3InputMode", om.valueToTree(this.getS3InputMode()));
                }
                if (this.getStartTimeOffset() != null) {
                    data.set("startTimeOffset", om.valueToTree(this.getStartTimeOffset()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.EndpointInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EndpointInputProperty.Jsii$Proxy that = (EndpointInputProperty.Jsii$Proxy) o;

                if (!endpointName.equals(that.endpointName)) return false;
                if (!localPath.equals(that.localPath)) return false;
                if (this.endTimeOffset != null ? !this.endTimeOffset.equals(that.endTimeOffset) : that.endTimeOffset != null) return false;
                if (this.featuresAttribute != null ? !this.featuresAttribute.equals(that.featuresAttribute) : that.featuresAttribute != null) return false;
                if (this.inferenceAttribute != null ? !this.inferenceAttribute.equals(that.inferenceAttribute) : that.inferenceAttribute != null) return false;
                if (this.probabilityAttribute != null ? !this.probabilityAttribute.equals(that.probabilityAttribute) : that.probabilityAttribute != null) return false;
                if (this.probabilityThresholdAttribute != null ? !this.probabilityThresholdAttribute.equals(that.probabilityThresholdAttribute) : that.probabilityThresholdAttribute != null) return false;
                if (this.s3DataDistributionType != null ? !this.s3DataDistributionType.equals(that.s3DataDistributionType) : that.s3DataDistributionType != null) return false;
                if (this.s3InputMode != null ? !this.s3InputMode.equals(that.s3InputMode) : that.s3InputMode != null) return false;
                return this.startTimeOffset != null ? this.startTimeOffset.equals(that.startTimeOffset) : that.startTimeOffset == null;
            }

            @Override
            public final int hashCode() {
                int result = this.endpointName.hashCode();
                result = 31 * result + (this.localPath.hashCode());
                result = 31 * result + (this.endTimeOffset != null ? this.endTimeOffset.hashCode() : 0);
                result = 31 * result + (this.featuresAttribute != null ? this.featuresAttribute.hashCode() : 0);
                result = 31 * result + (this.inferenceAttribute != null ? this.inferenceAttribute.hashCode() : 0);
                result = 31 * result + (this.probabilityAttribute != null ? this.probabilityAttribute.hashCode() : 0);
                result = 31 * result + (this.probabilityThresholdAttribute != null ? this.probabilityThresholdAttribute.hashCode() : 0);
                result = 31 * result + (this.s3DataDistributionType != null ? this.s3DataDistributionType.hashCode() : 0);
                result = 31 * result + (this.s3InputMode != null ? this.s3InputMode.hashCode() : 0);
                result = 31 * result + (this.startTimeOffset != null ? this.startTimeOffset.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Docker container image configuration object for the model bias job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ModelBiasAppSpecificationProperty modelBiasAppSpecificationProperty = ModelBiasAppSpecificationProperty.builder()
     *         .configUri("configUri")
     *         .imageUri("imageUri")
     *         // the properties below are optional
     *         .environment(Map.of(
     *                 "environmentKey", "environment"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(ModelBiasAppSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ModelBiasAppSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * JSON formatted S3 file that defines bias parameters.
         * <p>
         * For more information on this JSON configuration file, see <a href="https://docs.aws.amazon.com/sagemaker/latest/json-bias-parameter-config.html">Configure bias parameters</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConfigUri();

        /**
         * The container image to be run by the model bias job.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImageUri();

        /**
         * Sets the environment variables in the Docker container.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ModelBiasAppSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ModelBiasAppSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ModelBiasAppSpecificationProperty> {
            java.lang.String configUri;
            java.lang.String imageUri;
            java.lang.Object environment;

            /**
             * Sets the value of {@link ModelBiasAppSpecificationProperty#getConfigUri}
             * @param configUri JSON formatted S3 file that defines bias parameters. This parameter is required.
             *                  For more information on this JSON configuration file, see <a href="https://docs.aws.amazon.com/sagemaker/latest/json-bias-parameter-config.html">Configure bias parameters</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configUri(java.lang.String configUri) {
                this.configUri = configUri;
                return this;
            }

            /**
             * Sets the value of {@link ModelBiasAppSpecificationProperty#getImageUri}
             * @param imageUri The container image to be run by the model bias job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageUri(java.lang.String imageUri) {
                this.imageUri = imageUri;
                return this;
            }

            /**
             * Sets the value of {@link ModelBiasAppSpecificationProperty#getEnvironment}
             * @param environment Sets the environment variables in the Docker container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(software.amazon.awscdk.core.IResolvable environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link ModelBiasAppSpecificationProperty#getEnvironment}
             * @param environment Sets the environment variables in the Docker container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ModelBiasAppSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ModelBiasAppSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ModelBiasAppSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModelBiasAppSpecificationProperty {
            private final java.lang.String configUri;
            private final java.lang.String imageUri;
            private final java.lang.Object environment;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configUri = software.amazon.jsii.Kernel.get(this, "configUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageUri = software.amazon.jsii.Kernel.get(this, "imageUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configUri = java.util.Objects.requireNonNull(builder.configUri, "configUri is required");
                this.imageUri = java.util.Objects.requireNonNull(builder.imageUri, "imageUri is required");
                this.environment = builder.environment;
            }

            @Override
            public final java.lang.String getConfigUri() {
                return this.configUri;
            }

            @Override
            public final java.lang.String getImageUri() {
                return this.imageUri;
            }

            @Override
            public final java.lang.Object getEnvironment() {
                return this.environment;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("configUri", om.valueToTree(this.getConfigUri()));
                data.set("imageUri", om.valueToTree(this.getImageUri()));
                if (this.getEnvironment() != null) {
                    data.set("environment", om.valueToTree(this.getEnvironment()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ModelBiasAppSpecificationProperty.Jsii$Proxy that = (ModelBiasAppSpecificationProperty.Jsii$Proxy) o;

                if (!configUri.equals(that.configUri)) return false;
                if (!imageUri.equals(that.imageUri)) return false;
                return this.environment != null ? this.environment.equals(that.environment) : that.environment == null;
            }

            @Override
            public final int hashCode() {
                int result = this.configUri.hashCode();
                result = 31 * result + (this.imageUri.hashCode());
                result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for a baseline model bias job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ModelBiasBaselineConfigProperty modelBiasBaselineConfigProperty = ModelBiasBaselineConfigProperty.builder()
     *         .baseliningJobName("baseliningJobName")
     *         .constraintsResource(ConstraintsResourceProperty.builder()
     *                 .s3Uri("s3Uri")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ModelBiasBaselineConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ModelBiasBaselineConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the baseline model bias job.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBaseliningJobName() {
            return null;
        }

        /**
         * The constraints resource for a monitoring job.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConstraintsResource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ModelBiasBaselineConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ModelBiasBaselineConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ModelBiasBaselineConfigProperty> {
            java.lang.String baseliningJobName;
            java.lang.Object constraintsResource;

            /**
             * Sets the value of {@link ModelBiasBaselineConfigProperty#getBaseliningJobName}
             * @param baseliningJobName The name of the baseline model bias job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baseliningJobName(java.lang.String baseliningJobName) {
                this.baseliningJobName = baseliningJobName;
                return this;
            }

            /**
             * Sets the value of {@link ModelBiasBaselineConfigProperty#getConstraintsResource}
             * @param constraintsResource The constraints resource for a monitoring job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraintsResource(software.amazon.awscdk.core.IResolvable constraintsResource) {
                this.constraintsResource = constraintsResource;
                return this;
            }

            /**
             * Sets the value of {@link ModelBiasBaselineConfigProperty#getConstraintsResource}
             * @param constraintsResource The constraints resource for a monitoring job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraintsResource(software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.ConstraintsResourceProperty constraintsResource) {
                this.constraintsResource = constraintsResource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ModelBiasBaselineConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ModelBiasBaselineConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ModelBiasBaselineConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModelBiasBaselineConfigProperty {
            private final java.lang.String baseliningJobName;
            private final java.lang.Object constraintsResource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.baseliningJobName = software.amazon.jsii.Kernel.get(this, "baseliningJobName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.constraintsResource = software.amazon.jsii.Kernel.get(this, "constraintsResource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.baseliningJobName = builder.baseliningJobName;
                this.constraintsResource = builder.constraintsResource;
            }

            @Override
            public final java.lang.String getBaseliningJobName() {
                return this.baseliningJobName;
            }

            @Override
            public final java.lang.Object getConstraintsResource() {
                return this.constraintsResource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBaseliningJobName() != null) {
                    data.set("baseliningJobName", om.valueToTree(this.getBaseliningJobName()));
                }
                if (this.getConstraintsResource() != null) {
                    data.set("constraintsResource", om.valueToTree(this.getConstraintsResource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ModelBiasBaselineConfigProperty.Jsii$Proxy that = (ModelBiasBaselineConfigProperty.Jsii$Proxy) o;

                if (this.baseliningJobName != null ? !this.baseliningJobName.equals(that.baseliningJobName) : that.baseliningJobName != null) return false;
                return this.constraintsResource != null ? this.constraintsResource.equals(that.constraintsResource) : that.constraintsResource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.baseliningJobName != null ? this.baseliningJobName.hashCode() : 0;
                result = 31 * result + (this.constraintsResource != null ? this.constraintsResource.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Inputs for the model bias job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ModelBiasJobInputProperty modelBiasJobInputProperty = ModelBiasJobInputProperty.builder()
     *         .endpointInput(EndpointInputProperty.builder()
     *                 .endpointName("endpointName")
     *                 .localPath("localPath")
     *                 // the properties below are optional
     *                 .endTimeOffset("endTimeOffset")
     *                 .featuresAttribute("featuresAttribute")
     *                 .inferenceAttribute("inferenceAttribute")
     *                 .probabilityAttribute("probabilityAttribute")
     *                 .probabilityThresholdAttribute(123)
     *                 .s3DataDistributionType("s3DataDistributionType")
     *                 .s3InputMode("s3InputMode")
     *                 .startTimeOffset("startTimeOffset")
     *                 .build())
     *         .groundTruthS3Input(MonitoringGroundTruthS3InputProperty.builder()
     *                 .s3Uri("s3Uri")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.ModelBiasJobInputProperty")
    @software.amazon.jsii.Jsii.Proxy(ModelBiasJobInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ModelBiasJobInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Input object for the endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEndpointInput();

        /**
         * Location of ground truth labels to use in model bias job.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getGroundTruthS3Input();

        /**
         * @return a {@link Builder} of {@link ModelBiasJobInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ModelBiasJobInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ModelBiasJobInputProperty> {
            java.lang.Object endpointInput;
            java.lang.Object groundTruthS3Input;

            /**
             * Sets the value of {@link ModelBiasJobInputProperty#getEndpointInput}
             * @param endpointInput Input object for the endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointInput(software.amazon.awscdk.core.IResolvable endpointInput) {
                this.endpointInput = endpointInput;
                return this;
            }

            /**
             * Sets the value of {@link ModelBiasJobInputProperty#getEndpointInput}
             * @param endpointInput Input object for the endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointInput(software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.EndpointInputProperty endpointInput) {
                this.endpointInput = endpointInput;
                return this;
            }

            /**
             * Sets the value of {@link ModelBiasJobInputProperty#getGroundTruthS3Input}
             * @param groundTruthS3Input Location of ground truth labels to use in model bias job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groundTruthS3Input(software.amazon.awscdk.core.IResolvable groundTruthS3Input) {
                this.groundTruthS3Input = groundTruthS3Input;
                return this;
            }

            /**
             * Sets the value of {@link ModelBiasJobInputProperty#getGroundTruthS3Input}
             * @param groundTruthS3Input Location of ground truth labels to use in model bias job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groundTruthS3Input(software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty groundTruthS3Input) {
                this.groundTruthS3Input = groundTruthS3Input;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ModelBiasJobInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ModelBiasJobInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ModelBiasJobInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModelBiasJobInputProperty {
            private final java.lang.Object endpointInput;
            private final java.lang.Object groundTruthS3Input;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endpointInput = software.amazon.jsii.Kernel.get(this, "endpointInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.groundTruthS3Input = software.amazon.jsii.Kernel.get(this, "groundTruthS3Input", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endpointInput = java.util.Objects.requireNonNull(builder.endpointInput, "endpointInput is required");
                this.groundTruthS3Input = java.util.Objects.requireNonNull(builder.groundTruthS3Input, "groundTruthS3Input is required");
            }

            @Override
            public final java.lang.Object getEndpointInput() {
                return this.endpointInput;
            }

            @Override
            public final java.lang.Object getGroundTruthS3Input() {
                return this.groundTruthS3Input;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endpointInput", om.valueToTree(this.getEndpointInput()));
                data.set("groundTruthS3Input", om.valueToTree(this.getGroundTruthS3Input()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.ModelBiasJobInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ModelBiasJobInputProperty.Jsii$Proxy that = (ModelBiasJobInputProperty.Jsii$Proxy) o;

                if (!endpointInput.equals(that.endpointInput)) return false;
                return this.groundTruthS3Input.equals(that.groundTruthS3Input);
            }

            @Override
            public final int hashCode() {
                int result = this.endpointInput.hashCode();
                result = 31 * result + (this.groundTruthS3Input.hashCode());
                return result;
            }
        }
    }
    /**
     * The ground truth labels for the dataset used for the monitoring job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * MonitoringGroundTruthS3InputProperty monitoringGroundTruthS3InputProperty = MonitoringGroundTruthS3InputProperty.builder()
     *         .s3Uri("s3Uri")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringGroundTruthS3InputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringGroundTruthS3InputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The address of the Amazon S3 location of the ground truth labels.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Uri();

        /**
         * @return a {@link Builder} of {@link MonitoringGroundTruthS3InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringGroundTruthS3InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringGroundTruthS3InputProperty> {
            java.lang.String s3Uri;

            /**
             * Sets the value of {@link MonitoringGroundTruthS3InputProperty#getS3Uri}
             * @param s3Uri The address of the Amazon S3 location of the ground truth labels. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringGroundTruthS3InputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringGroundTruthS3InputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoringGroundTruthS3InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringGroundTruthS3InputProperty {
            private final java.lang.String s3Uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Uri = java.util.Objects.requireNonNull(builder.s3Uri, "s3Uri is required");
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Uri", om.valueToTree(this.getS3Uri()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringGroundTruthS3InputProperty.Jsii$Proxy that = (MonitoringGroundTruthS3InputProperty.Jsii$Proxy) o;

                return this.s3Uri.equals(that.s3Uri);
            }

            @Override
            public final int hashCode() {
                int result = this.s3Uri.hashCode();
                return result;
            }
        }
    }
    /**
     * The output configuration for monitoring jobs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * MonitoringOutputConfigProperty monitoringOutputConfigProperty = MonitoringOutputConfigProperty.builder()
     *         .monitoringOutputs(List.of(MonitoringOutputProperty.builder()
     *                 .s3Output(S3OutputProperty.builder()
     *                         .localPath("localPath")
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .s3UploadMode("s3UploadMode")
     *                         .build())
     *                 .build()))
     *         // the properties below are optional
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.MonitoringOutputConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringOutputConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringOutputConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Monitoring outputs for monitoring jobs.
         * <p>
         * This is where the output of the periodic monitoring jobs is uploaded.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMonitoringOutputs();

        /**
         * The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonitoringOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringOutputConfigProperty> {
            java.lang.Object monitoringOutputs;
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link MonitoringOutputConfigProperty#getMonitoringOutputs}
             * @param monitoringOutputs Monitoring outputs for monitoring jobs. This parameter is required.
             *                          This is where the output of the periodic monitoring jobs is uploaded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringOutputs(software.amazon.awscdk.core.IResolvable monitoringOutputs) {
                this.monitoringOutputs = monitoringOutputs;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringOutputConfigProperty#getMonitoringOutputs}
             * @param monitoringOutputs Monitoring outputs for monitoring jobs. This parameter is required.
             *                          This is where the output of the periodic monitoring jobs is uploaded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringOutputs(java.util.List<? extends java.lang.Object> monitoringOutputs) {
                this.monitoringOutputs = monitoringOutputs;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringOutputConfigProperty#getKmsKeyId}
             * @param kmsKeyId The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringOutputConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringOutputConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoringOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringOutputConfigProperty {
            private final java.lang.Object monitoringOutputs;
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.monitoringOutputs = software.amazon.jsii.Kernel.get(this, "monitoringOutputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.monitoringOutputs = java.util.Objects.requireNonNull(builder.monitoringOutputs, "monitoringOutputs is required");
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.Object getMonitoringOutputs() {
                return this.monitoringOutputs;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("monitoringOutputs", om.valueToTree(this.getMonitoringOutputs()));
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.MonitoringOutputConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringOutputConfigProperty.Jsii$Proxy that = (MonitoringOutputConfigProperty.Jsii$Proxy) o;

                if (!monitoringOutputs.equals(that.monitoringOutputs)) return false;
                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.monitoringOutputs.hashCode();
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The output object for a monitoring job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * MonitoringOutputProperty monitoringOutputProperty = MonitoringOutputProperty.builder()
     *         .s3Output(S3OutputProperty.builder()
     *                 .localPath("localPath")
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .s3UploadMode("s3UploadMode")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.MonitoringOutputProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringOutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 storage location where the results of a monitoring job are saved.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Output();

        /**
         * @return a {@link Builder} of {@link MonitoringOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringOutputProperty> {
            java.lang.Object s3Output;

            /**
             * Sets the value of {@link MonitoringOutputProperty#getS3Output}
             * @param s3Output The Amazon S3 storage location where the results of a monitoring job are saved. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Output(software.amazon.awscdk.core.IResolvable s3Output) {
                this.s3Output = s3Output;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringOutputProperty#getS3Output}
             * @param s3Output The Amazon S3 storage location where the results of a monitoring job are saved. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Output(software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.S3OutputProperty s3Output) {
                this.s3Output = s3Output;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringOutputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoringOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringOutputProperty {
            private final java.lang.Object s3Output;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Output = software.amazon.jsii.Kernel.get(this, "s3Output", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Output = java.util.Objects.requireNonNull(builder.s3Output, "s3Output is required");
            }

            @Override
            public final java.lang.Object getS3Output() {
                return this.s3Output;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Output", om.valueToTree(this.getS3Output()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.MonitoringOutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringOutputProperty.Jsii$Proxy that = (MonitoringOutputProperty.Jsii$Proxy) o;

                return this.s3Output.equals(that.s3Output);
            }

            @Override
            public final int hashCode() {
                int result = this.s3Output.hashCode();
                return result;
            }
        }
    }
    /**
     * Identifies the resources to deploy for a monitoring job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * MonitoringResourcesProperty monitoringResourcesProperty = MonitoringResourcesProperty.builder()
     *         .clusterConfig(ClusterConfigProperty.builder()
     *                 .instanceCount(123)
     *                 .instanceType("instanceType")
     *                 .volumeSizeInGb(123)
     *                 // the properties below are optional
     *                 .volumeKmsKeyId("volumeKmsKeyId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.MonitoringResourcesProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringResourcesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringResourcesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration for the cluster resources used to run the processing job.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getClusterConfig();

        /**
         * @return a {@link Builder} of {@link MonitoringResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringResourcesProperty> {
            java.lang.Object clusterConfig;

            /**
             * Sets the value of {@link MonitoringResourcesProperty#getClusterConfig}
             * @param clusterConfig The configuration for the cluster resources used to run the processing job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterConfig(software.amazon.awscdk.core.IResolvable clusterConfig) {
                this.clusterConfig = clusterConfig;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringResourcesProperty#getClusterConfig}
             * @param clusterConfig The configuration for the cluster resources used to run the processing job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterConfig(software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.ClusterConfigProperty clusterConfig) {
                this.clusterConfig = clusterConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringResourcesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringResourcesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoringResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringResourcesProperty {
            private final java.lang.Object clusterConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterConfig = software.amazon.jsii.Kernel.get(this, "clusterConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterConfig = java.util.Objects.requireNonNull(builder.clusterConfig, "clusterConfig is required");
            }

            @Override
            public final java.lang.Object getClusterConfig() {
                return this.clusterConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clusterConfig", om.valueToTree(this.getClusterConfig()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.MonitoringResourcesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringResourcesProperty.Jsii$Proxy that = (MonitoringResourcesProperty.Jsii$Proxy) o;

                return this.clusterConfig.equals(that.clusterConfig);
            }

            @Override
            public final int hashCode() {
                int result = this.clusterConfig.hashCode();
                return result;
            }
        }
    }
    /**
     * Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * NetworkConfigProperty networkConfigProperty = NetworkConfigProperty.builder()
     *         .enableInterContainerTrafficEncryption(false)
     *         .enableNetworkIsolation(false)
     *         .vpcConfig(VpcConfigProperty.builder()
     *                 .securityGroupIds(List.of("securityGroupIds"))
     *                 .subnets(List.of("subnets"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.NetworkConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether to encrypt all communications between distributed processing jobs.
         * <p>
         * Choose <code>True</code> to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableInterContainerTrafficEncryption() {
            return null;
        }

        /**
         * Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableNetworkIsolation() {
            return null;
        }

        /**
         * Specifies a VPC that your training jobs and hosted models have access to.
         * <p>
         * Control access to and from your training and model containers by configuring the VPC.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkConfigProperty> {
            java.lang.Object enableInterContainerTrafficEncryption;
            java.lang.Object enableNetworkIsolation;
            java.lang.Object vpcConfig;

            /**
             * Sets the value of {@link NetworkConfigProperty#getEnableInterContainerTrafficEncryption}
             * @param enableInterContainerTrafficEncryption Whether to encrypt all communications between distributed processing jobs.
             *                                              Choose <code>True</code> to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableInterContainerTrafficEncryption(java.lang.Boolean enableInterContainerTrafficEncryption) {
                this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getEnableInterContainerTrafficEncryption}
             * @param enableInterContainerTrafficEncryption Whether to encrypt all communications between distributed processing jobs.
             *                                              Choose <code>True</code> to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableInterContainerTrafficEncryption(software.amazon.awscdk.core.IResolvable enableInterContainerTrafficEncryption) {
                this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getEnableNetworkIsolation}
             * @param enableNetworkIsolation Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableNetworkIsolation(java.lang.Boolean enableNetworkIsolation) {
                this.enableNetworkIsolation = enableNetworkIsolation;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getEnableNetworkIsolation}
             * @param enableNetworkIsolation Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableNetworkIsolation(software.amazon.awscdk.core.IResolvable enableNetworkIsolation) {
                this.enableNetworkIsolation = enableNetworkIsolation;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getVpcConfig}
             * @param vpcConfig Specifies a VPC that your training jobs and hosted models have access to.
             *                  Control access to and from your training and model containers by configuring the VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfig(software.amazon.awscdk.core.IResolvable vpcConfig) {
                this.vpcConfig = vpcConfig;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getVpcConfig}
             * @param vpcConfig Specifies a VPC that your training jobs and hosted models have access to.
             *                  Control access to and from your training and model containers by configuring the VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfig(software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.VpcConfigProperty vpcConfig) {
                this.vpcConfig = vpcConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkConfigProperty {
            private final java.lang.Object enableInterContainerTrafficEncryption;
            private final java.lang.Object enableNetworkIsolation;
            private final java.lang.Object vpcConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableInterContainerTrafficEncryption = software.amazon.jsii.Kernel.get(this, "enableInterContainerTrafficEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableNetworkIsolation = software.amazon.jsii.Kernel.get(this, "enableNetworkIsolation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpcConfig = software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableInterContainerTrafficEncryption = builder.enableInterContainerTrafficEncryption;
                this.enableNetworkIsolation = builder.enableNetworkIsolation;
                this.vpcConfig = builder.vpcConfig;
            }

            @Override
            public final java.lang.Object getEnableInterContainerTrafficEncryption() {
                return this.enableInterContainerTrafficEncryption;
            }

            @Override
            public final java.lang.Object getEnableNetworkIsolation() {
                return this.enableNetworkIsolation;
            }

            @Override
            public final java.lang.Object getVpcConfig() {
                return this.vpcConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnableInterContainerTrafficEncryption() != null) {
                    data.set("enableInterContainerTrafficEncryption", om.valueToTree(this.getEnableInterContainerTrafficEncryption()));
                }
                if (this.getEnableNetworkIsolation() != null) {
                    data.set("enableNetworkIsolation", om.valueToTree(this.getEnableNetworkIsolation()));
                }
                if (this.getVpcConfig() != null) {
                    data.set("vpcConfig", om.valueToTree(this.getVpcConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.NetworkConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkConfigProperty.Jsii$Proxy that = (NetworkConfigProperty.Jsii$Proxy) o;

                if (this.enableInterContainerTrafficEncryption != null ? !this.enableInterContainerTrafficEncryption.equals(that.enableInterContainerTrafficEncryption) : that.enableInterContainerTrafficEncryption != null) return false;
                if (this.enableNetworkIsolation != null ? !this.enableNetworkIsolation.equals(that.enableNetworkIsolation) : that.enableNetworkIsolation != null) return false;
                return this.vpcConfig != null ? this.vpcConfig.equals(that.vpcConfig) : that.vpcConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableInterContainerTrafficEncryption != null ? this.enableInterContainerTrafficEncryption.hashCode() : 0;
                result = 31 * result + (this.enableNetworkIsolation != null ? this.enableNetworkIsolation.hashCode() : 0);
                result = 31 * result + (this.vpcConfig != null ? this.vpcConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Amazon S3 storage location where the results of a monitoring job are saved.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * S3OutputProperty s3OutputProperty = S3OutputProperty.builder()
     *         .localPath("localPath")
     *         .s3Uri("s3Uri")
     *         // the properties below are optional
     *         .s3UploadMode("s3UploadMode")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.S3OutputProperty")
    @software.amazon.jsii.Jsii.Proxy(S3OutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3OutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
         * <p>
         * <code>LocalPath</code> is an absolute path for the output data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocalPath();

        /**
         * A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Uri();

        /**
         * Whether to upload the results of the monitoring job continuously or after the job completes.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3UploadMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3OutputProperty> {
            java.lang.String localPath;
            java.lang.String s3Uri;
            java.lang.String s3UploadMode;

            /**
             * Sets the value of {@link S3OutputProperty#getLocalPath}
             * @param localPath The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. This parameter is required.
             *                  <code>LocalPath</code> is an absolute path for the output data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localPath(java.lang.String localPath) {
                this.localPath = localPath;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputProperty#getS3Uri}
             * @param s3Uri A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputProperty#getS3UploadMode}
             * @param s3UploadMode Whether to upload the results of the monitoring job continuously or after the job completes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3UploadMode(java.lang.String s3UploadMode) {
                this.s3UploadMode = s3UploadMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3OutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3OutputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3OutputProperty {
            private final java.lang.String localPath;
            private final java.lang.String s3Uri;
            private final java.lang.String s3UploadMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.localPath = software.amazon.jsii.Kernel.get(this, "localPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3UploadMode = software.amazon.jsii.Kernel.get(this, "s3UploadMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.localPath = java.util.Objects.requireNonNull(builder.localPath, "localPath is required");
                this.s3Uri = java.util.Objects.requireNonNull(builder.s3Uri, "s3Uri is required");
                this.s3UploadMode = builder.s3UploadMode;
            }

            @Override
            public final java.lang.String getLocalPath() {
                return this.localPath;
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            public final java.lang.String getS3UploadMode() {
                return this.s3UploadMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("localPath", om.valueToTree(this.getLocalPath()));
                data.set("s3Uri", om.valueToTree(this.getS3Uri()));
                if (this.getS3UploadMode() != null) {
                    data.set("s3UploadMode", om.valueToTree(this.getS3UploadMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.S3OutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3OutputProperty.Jsii$Proxy that = (S3OutputProperty.Jsii$Proxy) o;

                if (!localPath.equals(that.localPath)) return false;
                if (!s3Uri.equals(that.s3Uri)) return false;
                return this.s3UploadMode != null ? this.s3UploadMode.equals(that.s3UploadMode) : that.s3UploadMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.localPath.hashCode();
                result = 31 * result + (this.s3Uri.hashCode());
                result = 31 * result + (this.s3UploadMode != null ? this.s3UploadMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a limit to how long a model training job or model compilation job can run.
     * <p>
     * It also specifies how long a managed spot training job has to complete. When the job reaches the time limit, SageMaker ends the training or compilation job. Use this API to cap model training costs.
     * <p>
     * To stop a training job, SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost.
     * <p>
     * The training algorithms provided by SageMaker automatically save the intermediate results of a model training job when possible. This attempt to save artifacts is only a best effort case as model might not be in a state from which it can be saved. For example, if training has just started, the model might not be ready to save. When saved, this intermediate data is a valid model artifact. You can use it to create a model with <code>CreateModel</code> .
     * <p>
     * <blockquote>
     * <p>
     * The Neural Topic Model (NTM) currently does not support saving intermediate model artifacts. When training NTMs, make sure that the maximum runtime is sufficient for the training job to complete.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * StoppingConditionProperty stoppingConditionProperty = StoppingConditionProperty.builder()
     *         .maxRuntimeInSeconds(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.StoppingConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(StoppingConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StoppingConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum length of time, in seconds, that a training or compilation job can run.
         * <p>
         * For compilation jobs, if the job does not complete during this time, a <code>TimeOut</code> error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model.
         * <p>
         * For all other jobs, if the job does not complete during this time, SageMaker ends the job. When <code>RetryStrategy</code> is specified in the job request, <code>MaxRuntimeInSeconds</code> specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxRuntimeInSeconds();

        /**
         * @return a {@link Builder} of {@link StoppingConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StoppingConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StoppingConditionProperty> {
            java.lang.Number maxRuntimeInSeconds;

            /**
             * Sets the value of {@link StoppingConditionProperty#getMaxRuntimeInSeconds}
             * @param maxRuntimeInSeconds The maximum length of time, in seconds, that a training or compilation job can run. This parameter is required.
             *                            For compilation jobs, if the job does not complete during this time, a <code>TimeOut</code> error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model.
             *                            <p>
             *                            For all other jobs, if the job does not complete during this time, SageMaker ends the job. When <code>RetryStrategy</code> is specified in the job request, <code>MaxRuntimeInSeconds</code> specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxRuntimeInSeconds(java.lang.Number maxRuntimeInSeconds) {
                this.maxRuntimeInSeconds = maxRuntimeInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StoppingConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StoppingConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StoppingConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StoppingConditionProperty {
            private final java.lang.Number maxRuntimeInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxRuntimeInSeconds = software.amazon.jsii.Kernel.get(this, "maxRuntimeInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxRuntimeInSeconds = java.util.Objects.requireNonNull(builder.maxRuntimeInSeconds, "maxRuntimeInSeconds is required");
            }

            @Override
            public final java.lang.Number getMaxRuntimeInSeconds() {
                return this.maxRuntimeInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxRuntimeInSeconds", om.valueToTree(this.getMaxRuntimeInSeconds()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.StoppingConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StoppingConditionProperty.Jsii$Proxy that = (StoppingConditionProperty.Jsii$Proxy) o;

                return this.maxRuntimeInSeconds.equals(that.maxRuntimeInSeconds);
            }

            @Override
            public final int hashCode() {
                int result = this.maxRuntimeInSeconds.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies a VPC that your training jobs and hosted models have access to.
     * <p>
     * Control access to and from your training and model containers by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * VpcConfigProperty vpcConfigProperty = VpcConfigProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnets(List.of("subnets"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.VpcConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The VPC security group IDs, in the form sg-xxxxxxxx.
         * <p>
         * Specify the security groups for the VPC that is specified in the <code>Subnets</code> field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * The ID of the subnets in the VPC to which you want to connect your training job or model.
         * <p>
         * For information about the availability of specific instance types, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html">Supported Instance Types and Availability Zones</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnets();

        /**
         * @return a {@link Builder} of {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcConfigProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnets;

            /**
             * Sets the value of {@link VpcConfigProperty#getSecurityGroupIds}
             * @param securityGroupIds The VPC security group IDs, in the form sg-xxxxxxxx. This parameter is required.
             *                         Specify the security groups for the VPC that is specified in the <code>Subnets</code> field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigProperty#getSubnets}
             * @param subnets The ID of the subnets in the VPC to which you want to connect your training job or model. This parameter is required.
             *                For information about the availability of specific instance types, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html">Supported Instance Types and Availability Zones</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConfigProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = java.util.Objects.requireNonNull(builder.securityGroupIds, "securityGroupIds is required");
                this.subnets = java.util.Objects.requireNonNull(builder.subnets, "subnets is required");
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                data.set("subnets", om.valueToTree(this.getSubnets()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition.VpcConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConfigProperty.Jsii$Proxy that = (VpcConfigProperty.Jsii$Proxy) o;

                if (!securityGroupIds.equals(that.securityGroupIds)) return false;
                return this.subnets.equals(that.subnets);
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds.hashCode();
                result = 31 * result + (this.subnets.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinitionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinitionProps.Builder();
        }

        /**
         * Identifies the resources to deploy for a monitoring job.
         * <p>
         * @return {@code this}
         * @param jobResources Identifies the resources to deploy for a monitoring job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobResources(final software.amazon.awscdk.core.IResolvable jobResources) {
            this.props.jobResources(jobResources);
            return this;
        }
        /**
         * Identifies the resources to deploy for a monitoring job.
         * <p>
         * @return {@code this}
         * @param jobResources Identifies the resources to deploy for a monitoring job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobResources(final software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.MonitoringResourcesProperty jobResources) {
            this.props.jobResources(jobResources);
            return this;
        }

        /**
         * Configures the model bias job to run a specified Docker container image.
         * <p>
         * @return {@code this}
         * @param modelBiasAppSpecification Configures the model bias job to run a specified Docker container image. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelBiasAppSpecification(final software.amazon.awscdk.core.IResolvable modelBiasAppSpecification) {
            this.props.modelBiasAppSpecification(modelBiasAppSpecification);
            return this;
        }
        /**
         * Configures the model bias job to run a specified Docker container image.
         * <p>
         * @return {@code this}
         * @param modelBiasAppSpecification Configures the model bias job to run a specified Docker container image. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelBiasAppSpecification(final software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty modelBiasAppSpecification) {
            this.props.modelBiasAppSpecification(modelBiasAppSpecification);
            return this;
        }

        /**
         * Inputs for the model bias job.
         * <p>
         * @return {@code this}
         * @param modelBiasJobInput Inputs for the model bias job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelBiasJobInput(final software.amazon.awscdk.core.IResolvable modelBiasJobInput) {
            this.props.modelBiasJobInput(modelBiasJobInput);
            return this;
        }
        /**
         * Inputs for the model bias job.
         * <p>
         * @return {@code this}
         * @param modelBiasJobInput Inputs for the model bias job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelBiasJobInput(final software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.ModelBiasJobInputProperty modelBiasJobInput) {
            this.props.modelBiasJobInput(modelBiasJobInput);
            return this;
        }

        /**
         * The output configuration for monitoring jobs.
         * <p>
         * @return {@code this}
         * @param modelBiasJobOutputConfig The output configuration for monitoring jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelBiasJobOutputConfig(final software.amazon.awscdk.core.IResolvable modelBiasJobOutputConfig) {
            this.props.modelBiasJobOutputConfig(modelBiasJobOutputConfig);
            return this;
        }
        /**
         * The output configuration for monitoring jobs.
         * <p>
         * @return {@code this}
         * @param modelBiasJobOutputConfig The output configuration for monitoring jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelBiasJobOutputConfig(final software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.MonitoringOutputConfigProperty modelBiasJobOutputConfig) {
            this.props.modelBiasJobOutputConfig(modelBiasJobOutputConfig);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
         * <p>
         * @return {@code this}
         * @param roleArn The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * The name of the bias job definition.
         * <p>
         * The name must be unique within an AWS Region in the AWS account.
         * <p>
         * @return {@code this}
         * @param jobDefinitionName The name of the bias job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDefinitionName(final java.lang.String jobDefinitionName) {
            this.props.jobDefinitionName(jobDefinitionName);
            return this;
        }

        /**
         * The baseline configuration for a model bias job.
         * <p>
         * @return {@code this}
         * @param modelBiasBaselineConfig The baseline configuration for a model bias job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelBiasBaselineConfig(final software.amazon.awscdk.core.IResolvable modelBiasBaselineConfig) {
            this.props.modelBiasBaselineConfig(modelBiasBaselineConfig);
            return this;
        }
        /**
         * The baseline configuration for a model bias job.
         * <p>
         * @return {@code this}
         * @param modelBiasBaselineConfig The baseline configuration for a model bias job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelBiasBaselineConfig(final software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty modelBiasBaselineConfig) {
            this.props.modelBiasBaselineConfig(modelBiasBaselineConfig);
            return this;
        }

        /**
         * Networking options for a model bias job.
         * <p>
         * @return {@code this}
         * @param networkConfig Networking options for a model bias job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfig(final software.amazon.awscdk.core.IResolvable networkConfig) {
            this.props.networkConfig(networkConfig);
            return this;
        }
        /**
         * Networking options for a model bias job.
         * <p>
         * @return {@code this}
         * @param networkConfig Networking options for a model bias job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfig(final software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.NetworkConfigProperty networkConfig) {
            this.props.networkConfig(networkConfig);
            return this;
        }

        /**
         * A time limit for how long the monitoring job is allowed to run before stopping.
         * <p>
         * @return {@code this}
         * @param stoppingCondition A time limit for how long the monitoring job is allowed to run before stopping. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stoppingCondition(final software.amazon.awscdk.core.IResolvable stoppingCondition) {
            this.props.stoppingCondition(stoppingCondition);
            return this;
        }
        /**
         * A time limit for how long the monitoring job is allowed to run before stopping.
         * <p>
         * @return {@code this}
         * @param stoppingCondition A time limit for how long the monitoring job is allowed to run before stopping. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stoppingCondition(final software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.StoppingConditionProperty stoppingCondition) {
            this.props.stoppingCondition(stoppingCondition);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition build() {
            return new software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
