package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a `CfnModelQualityJobDefinition`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnModelQualityJobDefinitionProps cfnModelQualityJobDefinitionProps = CfnModelQualityJobDefinitionProps.builder()
 *         .jobResources(MonitoringResourcesProperty.builder()
 *                 .clusterConfig(ClusterConfigProperty.builder()
 *                         .instanceCount(123)
 *                         .instanceType("instanceType")
 *                         .volumeSizeInGb(123)
 *                         // the properties below are optional
 *                         .volumeKmsKeyId("volumeKmsKeyId")
 *                         .build())
 *                 .build())
 *         .modelQualityAppSpecification(ModelQualityAppSpecificationProperty.builder()
 *                 .imageUri("imageUri")
 *                 .problemType("problemType")
 *                 // the properties below are optional
 *                 .containerArguments(List.of("containerArguments"))
 *                 .containerEntrypoint(List.of("containerEntrypoint"))
 *                 .environment(Map.of(
 *                         "environmentKey", "environment"))
 *                 .postAnalyticsProcessorSourceUri("postAnalyticsProcessorSourceUri")
 *                 .recordPreprocessorSourceUri("recordPreprocessorSourceUri")
 *                 .build())
 *         .modelQualityJobInput(ModelQualityJobInputProperty.builder()
 *                 .endpointInput(EndpointInputProperty.builder()
 *                         .endpointName("endpointName")
 *                         .localPath("localPath")
 *                         // the properties below are optional
 *                         .endTimeOffset("endTimeOffset")
 *                         .inferenceAttribute("inferenceAttribute")
 *                         .probabilityAttribute("probabilityAttribute")
 *                         .probabilityThresholdAttribute(123)
 *                         .s3DataDistributionType("s3DataDistributionType")
 *                         .s3InputMode("s3InputMode")
 *                         .startTimeOffset("startTimeOffset")
 *                         .build())
 *                 .groundTruthS3Input(MonitoringGroundTruthS3InputProperty.builder()
 *                         .s3Uri("s3Uri")
 *                         .build())
 *                 .build())
 *         .modelQualityJobOutputConfig(MonitoringOutputConfigProperty.builder()
 *                 .monitoringOutputs(List.of(MonitoringOutputProperty.builder()
 *                         .s3Output(S3OutputProperty.builder()
 *                                 .localPath("localPath")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .s3UploadMode("s3UploadMode")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .jobDefinitionName("jobDefinitionName")
 *         .modelQualityBaselineConfig(ModelQualityBaselineConfigProperty.builder()
 *                 .baseliningJobName("baseliningJobName")
 *                 .constraintsResource(ConstraintsResourceProperty.builder()
 *                         .s3Uri("s3Uri")
 *                         .build())
 *                 .build())
 *         .networkConfig(NetworkConfigProperty.builder()
 *                 .enableInterContainerTrafficEncryption(false)
 *                 .enableNetworkIsolation(false)
 *                 .vpcConfig(VpcConfigProperty.builder()
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnets(List.of("subnets"))
 *                         .build())
 *                 .build())
 *         .stoppingCondition(StoppingConditionProperty.builder()
 *                 .maxRuntimeInSeconds(123)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-07-13T22:11:51.636Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelQualityJobDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(CfnModelQualityJobDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnModelQualityJobDefinitionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Identifies the resources to deploy for a monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getJobResources();

    /**
     * Container image configuration object for the monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getModelQualityAppSpecification();

    /**
     * A list of the inputs that are monitored.
     * <p>
     * Currently endpoints are supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getModelQualityJobInput();

    /**
     * The output configuration for monitoring jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getModelQualityJobOutputConfig();

    /**
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The name of the monitoring job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getJobDefinitionName() {
        return null;
    }

    /**
     * Specifies the constraints and baselines for the monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getModelQualityBaselineConfig() {
        return null;
    }

    /**
     * Specifies the network configuration for the monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfig() {
        return null;
    }

    /**
     * A time limit for how long the monitoring job is allowed to run before stopping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStoppingCondition() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnModelQualityJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnModelQualityJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnModelQualityJobDefinitionProps> {
        java.lang.Object jobResources;
        java.lang.Object modelQualityAppSpecification;
        java.lang.Object modelQualityJobInput;
        java.lang.Object modelQualityJobOutputConfig;
        java.lang.String roleArn;
        java.lang.String jobDefinitionName;
        java.lang.Object modelQualityBaselineConfig;
        java.lang.Object networkConfig;
        java.lang.Object stoppingCondition;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnModelQualityJobDefinitionProps#getJobResources}
         * @param jobResources Identifies the resources to deploy for a monitoring job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobResources(software.amazon.awscdk.core.IResolvable jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelQualityJobDefinitionProps#getJobResources}
         * @param jobResources Identifies the resources to deploy for a monitoring job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobResources(software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.MonitoringResourcesProperty jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelQualityJobDefinitionProps#getModelQualityAppSpecification}
         * @param modelQualityAppSpecification Container image configuration object for the monitoring job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelQualityAppSpecification(software.amazon.awscdk.core.IResolvable modelQualityAppSpecification) {
            this.modelQualityAppSpecification = modelQualityAppSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelQualityJobDefinitionProps#getModelQualityAppSpecification}
         * @param modelQualityAppSpecification Container image configuration object for the monitoring job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelQualityAppSpecification(software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty modelQualityAppSpecification) {
            this.modelQualityAppSpecification = modelQualityAppSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelQualityJobDefinitionProps#getModelQualityJobInput}
         * @param modelQualityJobInput A list of the inputs that are monitored. This parameter is required.
         *                             Currently endpoints are supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelQualityJobInput(software.amazon.awscdk.core.IResolvable modelQualityJobInput) {
            this.modelQualityJobInput = modelQualityJobInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelQualityJobDefinitionProps#getModelQualityJobInput}
         * @param modelQualityJobInput A list of the inputs that are monitored. This parameter is required.
         *                             Currently endpoints are supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelQualityJobInput(software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.ModelQualityJobInputProperty modelQualityJobInput) {
            this.modelQualityJobInput = modelQualityJobInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelQualityJobDefinitionProps#getModelQualityJobOutputConfig}
         * @param modelQualityJobOutputConfig The output configuration for monitoring jobs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelQualityJobOutputConfig(software.amazon.awscdk.core.IResolvable modelQualityJobOutputConfig) {
            this.modelQualityJobOutputConfig = modelQualityJobOutputConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelQualityJobDefinitionProps#getModelQualityJobOutputConfig}
         * @param modelQualityJobOutputConfig The output configuration for monitoring jobs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelQualityJobOutputConfig(software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.MonitoringOutputConfigProperty modelQualityJobOutputConfig) {
            this.modelQualityJobOutputConfig = modelQualityJobOutputConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelQualityJobDefinitionProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelQualityJobDefinitionProps#getJobDefinitionName}
         * @param jobDefinitionName The name of the monitoring job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDefinitionName(java.lang.String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelQualityJobDefinitionProps#getModelQualityBaselineConfig}
         * @param modelQualityBaselineConfig Specifies the constraints and baselines for the monitoring job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelQualityBaselineConfig(software.amazon.awscdk.core.IResolvable modelQualityBaselineConfig) {
            this.modelQualityBaselineConfig = modelQualityBaselineConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelQualityJobDefinitionProps#getModelQualityBaselineConfig}
         * @param modelQualityBaselineConfig Specifies the constraints and baselines for the monitoring job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelQualityBaselineConfig(software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.ModelQualityBaselineConfigProperty modelQualityBaselineConfig) {
            this.modelQualityBaselineConfig = modelQualityBaselineConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelQualityJobDefinitionProps#getNetworkConfig}
         * @param networkConfig Specifies the network configuration for the monitoring job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfig(software.amazon.awscdk.core.IResolvable networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelQualityJobDefinitionProps#getNetworkConfig}
         * @param networkConfig Specifies the network configuration for the monitoring job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfig(software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.NetworkConfigProperty networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelQualityJobDefinitionProps#getStoppingCondition}
         * @param stoppingCondition A time limit for how long the monitoring job is allowed to run before stopping.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stoppingCondition(software.amazon.awscdk.core.IResolvable stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelQualityJobDefinitionProps#getStoppingCondition}
         * @param stoppingCondition A time limit for how long the monitoring job is allowed to run before stopping.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stoppingCondition(software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.StoppingConditionProperty stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelQualityJobDefinitionProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnModelQualityJobDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnModelQualityJobDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnModelQualityJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnModelQualityJobDefinitionProps {
        private final java.lang.Object jobResources;
        private final java.lang.Object modelQualityAppSpecification;
        private final java.lang.Object modelQualityJobInput;
        private final java.lang.Object modelQualityJobOutputConfig;
        private final java.lang.String roleArn;
        private final java.lang.String jobDefinitionName;
        private final java.lang.Object modelQualityBaselineConfig;
        private final java.lang.Object networkConfig;
        private final java.lang.Object stoppingCondition;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.jobResources = software.amazon.jsii.Kernel.get(this, "jobResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.modelQualityAppSpecification = software.amazon.jsii.Kernel.get(this, "modelQualityAppSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.modelQualityJobInput = software.amazon.jsii.Kernel.get(this, "modelQualityJobInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.modelQualityJobOutputConfig = software.amazon.jsii.Kernel.get(this, "modelQualityJobOutputConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.jobDefinitionName = software.amazon.jsii.Kernel.get(this, "jobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modelQualityBaselineConfig = software.amazon.jsii.Kernel.get(this, "modelQualityBaselineConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.networkConfig = software.amazon.jsii.Kernel.get(this, "networkConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.stoppingCondition = software.amazon.jsii.Kernel.get(this, "stoppingCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.jobResources = java.util.Objects.requireNonNull(builder.jobResources, "jobResources is required");
            this.modelQualityAppSpecification = java.util.Objects.requireNonNull(builder.modelQualityAppSpecification, "modelQualityAppSpecification is required");
            this.modelQualityJobInput = java.util.Objects.requireNonNull(builder.modelQualityJobInput, "modelQualityJobInput is required");
            this.modelQualityJobOutputConfig = java.util.Objects.requireNonNull(builder.modelQualityJobOutputConfig, "modelQualityJobOutputConfig is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.jobDefinitionName = builder.jobDefinitionName;
            this.modelQualityBaselineConfig = builder.modelQualityBaselineConfig;
            this.networkConfig = builder.networkConfig;
            this.stoppingCondition = builder.stoppingCondition;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getJobResources() {
            return this.jobResources;
        }

        @Override
        public final java.lang.Object getModelQualityAppSpecification() {
            return this.modelQualityAppSpecification;
        }

        @Override
        public final java.lang.Object getModelQualityJobInput() {
            return this.modelQualityJobInput;
        }

        @Override
        public final java.lang.Object getModelQualityJobOutputConfig() {
            return this.modelQualityJobOutputConfig;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        @Override
        public final java.lang.Object getModelQualityBaselineConfig() {
            return this.modelQualityBaselineConfig;
        }

        @Override
        public final java.lang.Object getNetworkConfig() {
            return this.networkConfig;
        }

        @Override
        public final java.lang.Object getStoppingCondition() {
            return this.stoppingCondition;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("jobResources", om.valueToTree(this.getJobResources()));
            data.set("modelQualityAppSpecification", om.valueToTree(this.getModelQualityAppSpecification()));
            data.set("modelQualityJobInput", om.valueToTree(this.getModelQualityJobInput()));
            data.set("modelQualityJobOutputConfig", om.valueToTree(this.getModelQualityJobOutputConfig()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getJobDefinitionName() != null) {
                data.set("jobDefinitionName", om.valueToTree(this.getJobDefinitionName()));
            }
            if (this.getModelQualityBaselineConfig() != null) {
                data.set("modelQualityBaselineConfig", om.valueToTree(this.getModelQualityBaselineConfig()));
            }
            if (this.getNetworkConfig() != null) {
                data.set("networkConfig", om.valueToTree(this.getNetworkConfig()));
            }
            if (this.getStoppingCondition() != null) {
                data.set("stoppingCondition", om.valueToTree(this.getStoppingCondition()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelQualityJobDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnModelQualityJobDefinitionProps.Jsii$Proxy that = (CfnModelQualityJobDefinitionProps.Jsii$Proxy) o;

            if (!jobResources.equals(that.jobResources)) return false;
            if (!modelQualityAppSpecification.equals(that.modelQualityAppSpecification)) return false;
            if (!modelQualityJobInput.equals(that.modelQualityJobInput)) return false;
            if (!modelQualityJobOutputConfig.equals(that.modelQualityJobOutputConfig)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.jobDefinitionName != null ? !this.jobDefinitionName.equals(that.jobDefinitionName) : that.jobDefinitionName != null) return false;
            if (this.modelQualityBaselineConfig != null ? !this.modelQualityBaselineConfig.equals(that.modelQualityBaselineConfig) : that.modelQualityBaselineConfig != null) return false;
            if (this.networkConfig != null ? !this.networkConfig.equals(that.networkConfig) : that.networkConfig != null) return false;
            if (this.stoppingCondition != null ? !this.stoppingCondition.equals(that.stoppingCondition) : that.stoppingCondition != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.jobResources.hashCode();
            result = 31 * result + (this.modelQualityAppSpecification.hashCode());
            result = 31 * result + (this.modelQualityJobInput.hashCode());
            result = 31 * result + (this.modelQualityJobOutputConfig.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.jobDefinitionName != null ? this.jobDefinitionName.hashCode() : 0);
            result = 31 * result + (this.modelQualityBaselineConfig != null ? this.modelQualityBaselineConfig.hashCode() : 0);
            result = 31 * result + (this.networkConfig != null ? this.networkConfig.hashCode() : 0);
            result = 31 * result + (this.stoppingCondition != null ? this.stoppingCondition.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
