package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a `CfnImageVersion`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnImageVersionProps cfnImageVersionProps = CfnImageVersionProps.builder()
 *         .baseImage("baseImage")
 *         .imageName("imageName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.62.0 (build 293ac17)", date = "2022-07-29T14:47:22.590Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnImageVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnImageVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnImageVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The container image that the SageMaker image version is based on.
     * <p>
     * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 255.
     * <p>
     * <em>Pattern</em> : <code>.*</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBaseImage();

    /**
     * The name of the parent image.
     * <p>
     * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 63.
     * <p>
     * <em>Pattern</em> : <code>^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getImageName();

    /**
     * @return a {@link Builder} of {@link CfnImageVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnImageVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnImageVersionProps> {
        java.lang.String baseImage;
        java.lang.String imageName;

        /**
         * Sets the value of {@link CfnImageVersionProps#getBaseImage}
         * @param baseImage The container image that the SageMaker image version is based on. This parameter is required.
         *                  <em>Length Constraints</em> : Minimum length of 1. Maximum length of 255.
         *                  <p>
         *                  <em>Pattern</em> : <code>.*</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baseImage(java.lang.String baseImage) {
            this.baseImage = baseImage;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageVersionProps#getImageName}
         * @param imageName The name of the parent image. This parameter is required.
         *                  <em>Length Constraints</em> : Minimum length of 1. Maximum length of 63.
         *                  <p>
         *                  <em>Pattern</em> : <code>^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageName(java.lang.String imageName) {
            this.imageName = imageName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnImageVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnImageVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnImageVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnImageVersionProps {
        private final java.lang.String baseImage;
        private final java.lang.String imageName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.baseImage = software.amazon.jsii.Kernel.get(this, "baseImage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageName = software.amazon.jsii.Kernel.get(this, "imageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.baseImage = java.util.Objects.requireNonNull(builder.baseImage, "baseImage is required");
            this.imageName = java.util.Objects.requireNonNull(builder.imageName, "imageName is required");
        }

        @Override
        public final java.lang.String getBaseImage() {
            return this.baseImage;
        }

        @Override
        public final java.lang.String getImageName() {
            return this.imageName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("baseImage", om.valueToTree(this.getBaseImage()));
            data.set("imageName", om.valueToTree(this.getImageName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnImageVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnImageVersionProps.Jsii$Proxy that = (CfnImageVersionProps.Jsii$Proxy) o;

            if (!baseImage.equals(that.baseImage)) return false;
            return this.imageName.equals(that.imageName);
        }

        @Override
        public final int hashCode() {
            int result = this.baseImage.hashCode();
            result = 31 * result + (this.imageName.hashCode());
            return result;
        }
    }
}
