package software.amazon.awscdk.services.sagemaker;

/**
 * A CloudFormation `AWS::SageMaker::FeatureGroup`.
 * <p>
 * Create a new <code>FeatureGroup</code> . A <code>FeatureGroup</code> is a group of <code>Features</code> defined in the <code>FeatureStore</code> to describe a <code>Record</code> .
 * <p>
 * The <code>FeatureGroup</code> defines the schema and features contained in the FeatureGroup. A <code>FeatureGroup</code> definition is composed of a list of <code>Features</code> , a <code>RecordIdentifierFeatureName</code> , an <code>EventTimeFeatureName</code> and configurations for its <code>OnlineStore</code> and <code>OfflineStore</code> . Check <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">AWS service quotas</a> to see the <code>FeatureGroup</code> s quota for your AWS account.
 * <p>
 * <blockquote>
 * <p>
 * You must include at least one of <code>OnlineStoreConfig</code> and <code>OfflineStoreConfig</code> to create a <code>FeatureGroup</code> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * Object offlineStoreConfig;
 * Object onlineStoreConfig;
 * CfnFeatureGroup cfnFeatureGroup = CfnFeatureGroup.Builder.create(this, "MyCfnFeatureGroup")
 *         .eventTimeFeatureName("eventTimeFeatureName")
 *         .featureDefinitions(List.of(FeatureDefinitionProperty.builder()
 *                 .featureName("featureName")
 *                 .featureType("featureType")
 *                 .build()))
 *         .featureGroupName("featureGroupName")
 *         .recordIdentifierFeatureName("recordIdentifierFeatureName")
 *         // the properties below are optional
 *         .description("description")
 *         .offlineStoreConfig(offlineStoreConfig)
 *         .onlineStoreConfig(onlineStoreConfig)
 *         .roleArn("roleArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T20:25:27.767Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnFeatureGroup")
public class CfnFeatureGroup extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnFeatureGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFeatureGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnFeatureGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::SageMaker::FeatureGroup`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFeatureGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnFeatureGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tags used to define a `FeatureGroup` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The name of the feature that stores the `EventTime` of a Record in a `FeatureGroup` .
     * <p>
     * A <code>EventTime</code> is point in time when a new event occurs that corresponds to the creation or update of a <code>Record</code> in <code>FeatureGroup</code> . All <code>Records</code> in the <code>FeatureGroup</code> must have a corresponding <code>EventTime</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEventTimeFeatureName() {
        return software.amazon.jsii.Kernel.get(this, "eventTimeFeatureName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the feature that stores the `EventTime` of a Record in a `FeatureGroup` .
     * <p>
     * A <code>EventTime</code> is point in time when a new event occurs that corresponds to the creation or update of a <code>Record</code> in <code>FeatureGroup</code> . All <code>Records</code> in the <code>FeatureGroup</code> must have a corresponding <code>EventTime</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventTimeFeatureName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "eventTimeFeatureName", java.util.Objects.requireNonNull(value, "eventTimeFeatureName is required"));
    }

    /**
     * A list of `Feature` s. Each `Feature` must include a `FeatureName` and a `FeatureType` .
     * <p>
     * Valid <code>FeatureType</code> s are <code>Integral</code> , <code>Fractional</code> and <code>String</code> .
     * <p>
     * <code>FeatureName</code> s cannot be any of the following: <code>is_deleted</code> , <code>write_time</code> , <code>api_invocation_time</code> .
     * <p>
     * You can create up to 2,500 <code>FeatureDefinition</code> s per <code>FeatureGroup</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getFeatureDefinitions() {
        return software.amazon.jsii.Kernel.get(this, "featureDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of `Feature` s. Each `Feature` must include a `FeatureName` and a `FeatureType` .
     * <p>
     * Valid <code>FeatureType</code> s are <code>Integral</code> , <code>Fractional</code> and <code>String</code> .
     * <p>
     * <code>FeatureName</code> s cannot be any of the following: <code>is_deleted</code> , <code>write_time</code> , <code>api_invocation_time</code> .
     * <p>
     * You can create up to 2,500 <code>FeatureDefinition</code> s per <code>FeatureGroup</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFeatureDefinitions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "featureDefinitions", java.util.Objects.requireNonNull(value, "featureDefinitions is required"));
    }

    /**
     * A list of `Feature` s. Each `Feature` must include a `FeatureName` and a `FeatureType` .
     * <p>
     * Valid <code>FeatureType</code> s are <code>Integral</code> , <code>Fractional</code> and <code>String</code> .
     * <p>
     * <code>FeatureName</code> s cannot be any of the following: <code>is_deleted</code> , <code>write_time</code> , <code>api_invocation_time</code> .
     * <p>
     * You can create up to 2,500 <code>FeatureDefinition</code> s per <code>FeatureGroup</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFeatureDefinitions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "featureDefinitions", java.util.Objects.requireNonNull(value, "featureDefinitions is required"));
    }

    /**
     * The name of the `FeatureGroup` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFeatureGroupName() {
        return software.amazon.jsii.Kernel.get(this, "featureGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the `FeatureGroup` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFeatureGroupName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "featureGroupName", java.util.Objects.requireNonNull(value, "featureGroupName is required"));
    }

    /**
     * The configuration of an `OfflineStore` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getOfflineStoreConfig() {
        return software.amazon.jsii.Kernel.get(this, "offlineStoreConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of an `OfflineStore` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOfflineStoreConfig(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "offlineStoreConfig", java.util.Objects.requireNonNull(value, "offlineStoreConfig is required"));
    }

    /**
     * The configuration of an `OnlineStore` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getOnlineStoreConfig() {
        return software.amazon.jsii.Kernel.get(this, "onlineStoreConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of an `OnlineStore` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnlineStoreConfig(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "onlineStoreConfig", java.util.Objects.requireNonNull(value, "onlineStoreConfig is required"));
    }

    /**
     * The name of the `Feature` whose value uniquely identifies a `Record` defined in the `FeatureGroup` `FeatureDefinitions` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRecordIdentifierFeatureName() {
        return software.amazon.jsii.Kernel.get(this, "recordIdentifierFeatureName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the `Feature` whose value uniquely identifies a `Record` defined in the `FeatureGroup` `FeatureDefinitions` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecordIdentifierFeatureName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "recordIdentifierFeatureName", java.util.Objects.requireNonNull(value, "recordIdentifierFeatureName is required"));
    }

    /**
     * A free form description of a `FeatureGroup` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A free form description of a `FeatureGroup` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", value);
    }
    /**
     * A list of features.
     * <p>
     * You must include <code>FeatureName</code> and <code>FeatureType</code> . Valid feature <code>FeatureType</code> s are <code>Integral</code> , <code>Fractional</code> and <code>String</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * FeatureDefinitionProperty featureDefinitionProperty = FeatureDefinitionProperty.builder()
     *         .featureName("featureName")
     *         .featureType("featureType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnFeatureGroup.FeatureDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(FeatureDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FeatureDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of a feature.
         * <p>
         * The type must be a string. <code>FeatureName</code> cannot be any of the following: <code>is_deleted</code> , <code>write_time</code> , <code>api_invocation_time</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFeatureName();

        /**
         * The value type of a feature.
         * <p>
         * Valid values are Integral, Fractional, or String.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFeatureType();

        /**
         * @return a {@link Builder} of {@link FeatureDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FeatureDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FeatureDefinitionProperty> {
            java.lang.String featureName;
            java.lang.String featureType;

            /**
             * Sets the value of {@link FeatureDefinitionProperty#getFeatureName}
             * @param featureName The name of a feature. This parameter is required.
             *                    The type must be a string. <code>FeatureName</code> cannot be any of the following: <code>is_deleted</code> , <code>write_time</code> , <code>api_invocation_time</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featureName(java.lang.String featureName) {
                this.featureName = featureName;
                return this;
            }

            /**
             * Sets the value of {@link FeatureDefinitionProperty#getFeatureType}
             * @param featureType The value type of a feature. This parameter is required.
             *                    Valid values are Integral, Fractional, or String.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featureType(java.lang.String featureType) {
                this.featureType = featureType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FeatureDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FeatureDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FeatureDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FeatureDefinitionProperty {
            private final java.lang.String featureName;
            private final java.lang.String featureType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.featureName = software.amazon.jsii.Kernel.get(this, "featureName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.featureType = software.amazon.jsii.Kernel.get(this, "featureType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.featureName = java.util.Objects.requireNonNull(builder.featureName, "featureName is required");
                this.featureType = java.util.Objects.requireNonNull(builder.featureType, "featureType is required");
            }

            @Override
            public final java.lang.String getFeatureName() {
                return this.featureName;
            }

            @Override
            public final java.lang.String getFeatureType() {
                return this.featureType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("featureName", om.valueToTree(this.getFeatureName()));
                data.set("featureType", om.valueToTree(this.getFeatureType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnFeatureGroup.FeatureDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FeatureDefinitionProperty.Jsii$Proxy that = (FeatureDefinitionProperty.Jsii$Proxy) o;

                if (!featureName.equals(that.featureName)) return false;
                return this.featureType.equals(that.featureType);
            }

            @Override
            public final int hashCode() {
                int result = this.featureName.hashCode();
                result = 31 * result + (this.featureType.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnFeatureGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnFeatureGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnFeatureGroupProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnFeatureGroupProps.Builder();
        }

        /**
         * The name of the feature that stores the `EventTime` of a Record in a `FeatureGroup` .
         * <p>
         * A <code>EventTime</code> is point in time when a new event occurs that corresponds to the creation or update of a <code>Record</code> in <code>FeatureGroup</code> . All <code>Records</code> in the <code>FeatureGroup</code> must have a corresponding <code>EventTime</code> .
         * <p>
         * @return {@code this}
         * @param eventTimeFeatureName The name of the feature that stores the `EventTime` of a Record in a `FeatureGroup` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventTimeFeatureName(final java.lang.String eventTimeFeatureName) {
            this.props.eventTimeFeatureName(eventTimeFeatureName);
            return this;
        }

        /**
         * A list of `Feature` s. Each `Feature` must include a `FeatureName` and a `FeatureType` .
         * <p>
         * Valid <code>FeatureType</code> s are <code>Integral</code> , <code>Fractional</code> and <code>String</code> .
         * <p>
         * <code>FeatureName</code> s cannot be any of the following: <code>is_deleted</code> , <code>write_time</code> , <code>api_invocation_time</code> .
         * <p>
         * You can create up to 2,500 <code>FeatureDefinition</code> s per <code>FeatureGroup</code> .
         * <p>
         * @return {@code this}
         * @param featureDefinitions A list of `Feature` s. Each `Feature` must include a `FeatureName` and a `FeatureType` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder featureDefinitions(final software.amazon.awscdk.core.IResolvable featureDefinitions) {
            this.props.featureDefinitions(featureDefinitions);
            return this;
        }
        /**
         * A list of `Feature` s. Each `Feature` must include a `FeatureName` and a `FeatureType` .
         * <p>
         * Valid <code>FeatureType</code> s are <code>Integral</code> , <code>Fractional</code> and <code>String</code> .
         * <p>
         * <code>FeatureName</code> s cannot be any of the following: <code>is_deleted</code> , <code>write_time</code> , <code>api_invocation_time</code> .
         * <p>
         * You can create up to 2,500 <code>FeatureDefinition</code> s per <code>FeatureGroup</code> .
         * <p>
         * @return {@code this}
         * @param featureDefinitions A list of `Feature` s. Each `Feature` must include a `FeatureName` and a `FeatureType` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder featureDefinitions(final java.util.List<? extends java.lang.Object> featureDefinitions) {
            this.props.featureDefinitions(featureDefinitions);
            return this;
        }

        /**
         * The name of the `FeatureGroup` .
         * <p>
         * @return {@code this}
         * @param featureGroupName The name of the `FeatureGroup` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder featureGroupName(final java.lang.String featureGroupName) {
            this.props.featureGroupName(featureGroupName);
            return this;
        }

        /**
         * The name of the `Feature` whose value uniquely identifies a `Record` defined in the `FeatureGroup` `FeatureDefinitions` .
         * <p>
         * @return {@code this}
         * @param recordIdentifierFeatureName The name of the `Feature` whose value uniquely identifies a `Record` defined in the `FeatureGroup` `FeatureDefinitions` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordIdentifierFeatureName(final java.lang.String recordIdentifierFeatureName) {
            this.props.recordIdentifierFeatureName(recordIdentifierFeatureName);
            return this;
        }

        /**
         * A free form description of a `FeatureGroup` .
         * <p>
         * @return {@code this}
         * @param description A free form description of a `FeatureGroup` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The configuration of an `OfflineStore` .
         * <p>
         * @return {@code this}
         * @param offlineStoreConfig The configuration of an `OfflineStore` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder offlineStoreConfig(final java.lang.Object offlineStoreConfig) {
            this.props.offlineStoreConfig(offlineStoreConfig);
            return this;
        }

        /**
         * The configuration of an `OnlineStore` .
         * <p>
         * @return {@code this}
         * @param onlineStoreConfig The configuration of an `OnlineStore` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onlineStoreConfig(final java.lang.Object onlineStoreConfig) {
            this.props.onlineStoreConfig(onlineStoreConfig);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.
         * <p>
         * @return {@code this}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * Tags used to define a `FeatureGroup` .
         * <p>
         * @return {@code this}
         * @param tags Tags used to define a `FeatureGroup` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnFeatureGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnFeatureGroup build() {
            return new software.amazon.awscdk.services.sagemaker.CfnFeatureGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
