package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a `CfnDataQualityJobDefinition`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnDataQualityJobDefinitionProps cfnDataQualityJobDefinitionProps = CfnDataQualityJobDefinitionProps.builder()
 *         .dataQualityAppSpecification(DataQualityAppSpecificationProperty.builder()
 *                 .imageUri("imageUri")
 *                 // the properties below are optional
 *                 .containerArguments(List.of("containerArguments"))
 *                 .containerEntrypoint(List.of("containerEntrypoint"))
 *                 .environment(Map.of(
 *                         "environmentKey", "environment"))
 *                 .postAnalyticsProcessorSourceUri("postAnalyticsProcessorSourceUri")
 *                 .recordPreprocessorSourceUri("recordPreprocessorSourceUri")
 *                 .build())
 *         .dataQualityJobInput(DataQualityJobInputProperty.builder()
 *                 .endpointInput(EndpointInputProperty.builder()
 *                         .endpointName("endpointName")
 *                         .localPath("localPath")
 *                         // the properties below are optional
 *                         .s3DataDistributionType("s3DataDistributionType")
 *                         .s3InputMode("s3InputMode")
 *                         .build())
 *                 .build())
 *         .dataQualityJobOutputConfig(MonitoringOutputConfigProperty.builder()
 *                 .monitoringOutputs(List.of(MonitoringOutputProperty.builder()
 *                         .s3Output(S3OutputProperty.builder()
 *                                 .localPath("localPath")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .s3UploadMode("s3UploadMode")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .jobResources(MonitoringResourcesProperty.builder()
 *                 .clusterConfig(ClusterConfigProperty.builder()
 *                         .instanceCount(123)
 *                         .instanceType("instanceType")
 *                         .volumeSizeInGb(123)
 *                         // the properties below are optional
 *                         .volumeKmsKeyId("volumeKmsKeyId")
 *                         .build())
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .dataQualityBaselineConfig(DataQualityBaselineConfigProperty.builder()
 *                 .baseliningJobName("baseliningJobName")
 *                 .constraintsResource(ConstraintsResourceProperty.builder()
 *                         .s3Uri("s3Uri")
 *                         .build())
 *                 .statisticsResource(StatisticsResourceProperty.builder()
 *                         .s3Uri("s3Uri")
 *                         .build())
 *                 .build())
 *         .jobDefinitionName("jobDefinitionName")
 *         .networkConfig(NetworkConfigProperty.builder()
 *                 .enableInterContainerTrafficEncryption(false)
 *                 .enableNetworkIsolation(false)
 *                 .vpcConfig(VpcConfigProperty.builder()
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnets(List.of("subnets"))
 *                         .build())
 *                 .build())
 *         .stoppingCondition(StoppingConditionProperty.builder()
 *                 .maxRuntimeInSeconds(123)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.66.0 (build 3c9512b)", date = "2022-08-31T20:25:10.680Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnDataQualityJobDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(CfnDataQualityJobDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDataQualityJobDefinitionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the container that runs the monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDataQualityAppSpecification();

    /**
     * A list of inputs for the monitoring job.
     * <p>
     * Currently endpoints are supported as monitoring inputs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDataQualityJobInput();

    /**
     * The output configuration for monitoring jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDataQualityJobOutputConfig();

    /**
     * Identifies the resources to deploy for a monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getJobResources();

    /**
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * Configures the constraints and baselines for the monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataQualityBaselineConfig() {
        return null;
    }

    /**
     * The name for the monitoring job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getJobDefinitionName() {
        return null;
    }

    /**
     * Specifies networking configuration for the monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfig() {
        return null;
    }

    /**
     * A time limit for how long the monitoring job is allowed to run before stopping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStoppingCondition() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDataQualityJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDataQualityJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDataQualityJobDefinitionProps> {
        java.lang.Object dataQualityAppSpecification;
        java.lang.Object dataQualityJobInput;
        java.lang.Object dataQualityJobOutputConfig;
        java.lang.Object jobResources;
        java.lang.String roleArn;
        java.lang.Object dataQualityBaselineConfig;
        java.lang.String jobDefinitionName;
        java.lang.Object networkConfig;
        java.lang.Object stoppingCondition;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDataQualityJobDefinitionProps#getDataQualityAppSpecification}
         * @param dataQualityAppSpecification Specifies the container that runs the monitoring job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataQualityAppSpecification(software.amazon.awscdk.core.IResolvable dataQualityAppSpecification) {
            this.dataQualityAppSpecification = dataQualityAppSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataQualityJobDefinitionProps#getDataQualityAppSpecification}
         * @param dataQualityAppSpecification Specifies the container that runs the monitoring job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataQualityAppSpecification(software.amazon.awscdk.services.sagemaker.CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty dataQualityAppSpecification) {
            this.dataQualityAppSpecification = dataQualityAppSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataQualityJobDefinitionProps#getDataQualityJobInput}
         * @param dataQualityJobInput A list of inputs for the monitoring job. This parameter is required.
         *                            Currently endpoints are supported as monitoring inputs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataQualityJobInput(software.amazon.awscdk.core.IResolvable dataQualityJobInput) {
            this.dataQualityJobInput = dataQualityJobInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataQualityJobDefinitionProps#getDataQualityJobInput}
         * @param dataQualityJobInput A list of inputs for the monitoring job. This parameter is required.
         *                            Currently endpoints are supported as monitoring inputs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataQualityJobInput(software.amazon.awscdk.services.sagemaker.CfnDataQualityJobDefinition.DataQualityJobInputProperty dataQualityJobInput) {
            this.dataQualityJobInput = dataQualityJobInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataQualityJobDefinitionProps#getDataQualityJobOutputConfig}
         * @param dataQualityJobOutputConfig The output configuration for monitoring jobs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataQualityJobOutputConfig(software.amazon.awscdk.core.IResolvable dataQualityJobOutputConfig) {
            this.dataQualityJobOutputConfig = dataQualityJobOutputConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataQualityJobDefinitionProps#getDataQualityJobOutputConfig}
         * @param dataQualityJobOutputConfig The output configuration for monitoring jobs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataQualityJobOutputConfig(software.amazon.awscdk.services.sagemaker.CfnDataQualityJobDefinition.MonitoringOutputConfigProperty dataQualityJobOutputConfig) {
            this.dataQualityJobOutputConfig = dataQualityJobOutputConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataQualityJobDefinitionProps#getJobResources}
         * @param jobResources Identifies the resources to deploy for a monitoring job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobResources(software.amazon.awscdk.core.IResolvable jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataQualityJobDefinitionProps#getJobResources}
         * @param jobResources Identifies the resources to deploy for a monitoring job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobResources(software.amazon.awscdk.services.sagemaker.CfnDataQualityJobDefinition.MonitoringResourcesProperty jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataQualityJobDefinitionProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataQualityJobDefinitionProps#getDataQualityBaselineConfig}
         * @param dataQualityBaselineConfig Configures the constraints and baselines for the monitoring job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataQualityBaselineConfig(software.amazon.awscdk.core.IResolvable dataQualityBaselineConfig) {
            this.dataQualityBaselineConfig = dataQualityBaselineConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataQualityJobDefinitionProps#getDataQualityBaselineConfig}
         * @param dataQualityBaselineConfig Configures the constraints and baselines for the monitoring job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataQualityBaselineConfig(software.amazon.awscdk.services.sagemaker.CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty dataQualityBaselineConfig) {
            this.dataQualityBaselineConfig = dataQualityBaselineConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataQualityJobDefinitionProps#getJobDefinitionName}
         * @param jobDefinitionName The name for the monitoring job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDefinitionName(java.lang.String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataQualityJobDefinitionProps#getNetworkConfig}
         * @param networkConfig Specifies networking configuration for the monitoring job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfig(software.amazon.awscdk.core.IResolvable networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataQualityJobDefinitionProps#getNetworkConfig}
         * @param networkConfig Specifies networking configuration for the monitoring job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfig(software.amazon.awscdk.services.sagemaker.CfnDataQualityJobDefinition.NetworkConfigProperty networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataQualityJobDefinitionProps#getStoppingCondition}
         * @param stoppingCondition A time limit for how long the monitoring job is allowed to run before stopping.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stoppingCondition(software.amazon.awscdk.core.IResolvable stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataQualityJobDefinitionProps#getStoppingCondition}
         * @param stoppingCondition A time limit for how long the monitoring job is allowed to run before stopping.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stoppingCondition(software.amazon.awscdk.services.sagemaker.CfnDataQualityJobDefinition.StoppingConditionProperty stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataQualityJobDefinitionProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDataQualityJobDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDataQualityJobDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDataQualityJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDataQualityJobDefinitionProps {
        private final java.lang.Object dataQualityAppSpecification;
        private final java.lang.Object dataQualityJobInput;
        private final java.lang.Object dataQualityJobOutputConfig;
        private final java.lang.Object jobResources;
        private final java.lang.String roleArn;
        private final java.lang.Object dataQualityBaselineConfig;
        private final java.lang.String jobDefinitionName;
        private final java.lang.Object networkConfig;
        private final java.lang.Object stoppingCondition;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataQualityAppSpecification = software.amazon.jsii.Kernel.get(this, "dataQualityAppSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataQualityJobInput = software.amazon.jsii.Kernel.get(this, "dataQualityJobInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataQualityJobOutputConfig = software.amazon.jsii.Kernel.get(this, "dataQualityJobOutputConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.jobResources = software.amazon.jsii.Kernel.get(this, "jobResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataQualityBaselineConfig = software.amazon.jsii.Kernel.get(this, "dataQualityBaselineConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.jobDefinitionName = software.amazon.jsii.Kernel.get(this, "jobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkConfig = software.amazon.jsii.Kernel.get(this, "networkConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.stoppingCondition = software.amazon.jsii.Kernel.get(this, "stoppingCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataQualityAppSpecification = java.util.Objects.requireNonNull(builder.dataQualityAppSpecification, "dataQualityAppSpecification is required");
            this.dataQualityJobInput = java.util.Objects.requireNonNull(builder.dataQualityJobInput, "dataQualityJobInput is required");
            this.dataQualityJobOutputConfig = java.util.Objects.requireNonNull(builder.dataQualityJobOutputConfig, "dataQualityJobOutputConfig is required");
            this.jobResources = java.util.Objects.requireNonNull(builder.jobResources, "jobResources is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.dataQualityBaselineConfig = builder.dataQualityBaselineConfig;
            this.jobDefinitionName = builder.jobDefinitionName;
            this.networkConfig = builder.networkConfig;
            this.stoppingCondition = builder.stoppingCondition;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getDataQualityAppSpecification() {
            return this.dataQualityAppSpecification;
        }

        @Override
        public final java.lang.Object getDataQualityJobInput() {
            return this.dataQualityJobInput;
        }

        @Override
        public final java.lang.Object getDataQualityJobOutputConfig() {
            return this.dataQualityJobOutputConfig;
        }

        @Override
        public final java.lang.Object getJobResources() {
            return this.jobResources;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getDataQualityBaselineConfig() {
            return this.dataQualityBaselineConfig;
        }

        @Override
        public final java.lang.String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        @Override
        public final java.lang.Object getNetworkConfig() {
            return this.networkConfig;
        }

        @Override
        public final java.lang.Object getStoppingCondition() {
            return this.stoppingCondition;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataQualityAppSpecification", om.valueToTree(this.getDataQualityAppSpecification()));
            data.set("dataQualityJobInput", om.valueToTree(this.getDataQualityJobInput()));
            data.set("dataQualityJobOutputConfig", om.valueToTree(this.getDataQualityJobOutputConfig()));
            data.set("jobResources", om.valueToTree(this.getJobResources()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getDataQualityBaselineConfig() != null) {
                data.set("dataQualityBaselineConfig", om.valueToTree(this.getDataQualityBaselineConfig()));
            }
            if (this.getJobDefinitionName() != null) {
                data.set("jobDefinitionName", om.valueToTree(this.getJobDefinitionName()));
            }
            if (this.getNetworkConfig() != null) {
                data.set("networkConfig", om.valueToTree(this.getNetworkConfig()));
            }
            if (this.getStoppingCondition() != null) {
                data.set("stoppingCondition", om.valueToTree(this.getStoppingCondition()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnDataQualityJobDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDataQualityJobDefinitionProps.Jsii$Proxy that = (CfnDataQualityJobDefinitionProps.Jsii$Proxy) o;

            if (!dataQualityAppSpecification.equals(that.dataQualityAppSpecification)) return false;
            if (!dataQualityJobInput.equals(that.dataQualityJobInput)) return false;
            if (!dataQualityJobOutputConfig.equals(that.dataQualityJobOutputConfig)) return false;
            if (!jobResources.equals(that.jobResources)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.dataQualityBaselineConfig != null ? !this.dataQualityBaselineConfig.equals(that.dataQualityBaselineConfig) : that.dataQualityBaselineConfig != null) return false;
            if (this.jobDefinitionName != null ? !this.jobDefinitionName.equals(that.jobDefinitionName) : that.jobDefinitionName != null) return false;
            if (this.networkConfig != null ? !this.networkConfig.equals(that.networkConfig) : that.networkConfig != null) return false;
            if (this.stoppingCondition != null ? !this.stoppingCondition.equals(that.stoppingCondition) : that.stoppingCondition != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataQualityAppSpecification.hashCode();
            result = 31 * result + (this.dataQualityJobInput.hashCode());
            result = 31 * result + (this.dataQualityJobOutputConfig.hashCode());
            result = 31 * result + (this.jobResources.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.dataQualityBaselineConfig != null ? this.dataQualityBaselineConfig.hashCode() : 0);
            result = 31 * result + (this.jobDefinitionName != null ? this.jobDefinitionName.hashCode() : 0);
            result = 31 * result + (this.networkConfig != null ? this.networkConfig.hashCode() : 0);
            result = 31 * result + (this.stoppingCondition != null ? this.stoppingCondition.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
