package software.amazon.awscdk.services.sagemaker;

/**
 * A CloudFormation `AWS::SageMaker::ModelPackage`.
 * <p>
 * A versioned model that can be deployed for SageMaker inference.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * Object environment;
 * Object modelInput;
 * CfnModelPackage cfnModelPackage = CfnModelPackage.Builder.create(this, "MyCfnModelPackage")
 *         .additionalInferenceSpecificationDefinition(AdditionalInferenceSpecificationDefinitionProperty.builder()
 *                 .containers(List.of(ModelPackageContainerDefinitionProperty.builder()
 *                         .image("image")
 *                         // the properties below are optional
 *                         .containerHostname("containerHostname")
 *                         .environment(environment)
 *                         .framework("framework")
 *                         .frameworkVersion("frameworkVersion")
 *                         .imageDigest("imageDigest")
 *                         .modelDataUrl("modelDataUrl")
 *                         .modelInput(modelInput)
 *                         .nearestModelName("nearestModelName")
 *                         .productId("productId")
 *                         .build()))
 *                 .name("name")
 *                 // the properties below are optional
 *                 .description("description")
 *                 .supportedContentTypes(List.of("supportedContentTypes"))
 *                 .supportedRealtimeInferenceInstanceTypes(List.of("supportedRealtimeInferenceInstanceTypes"))
 *                 .supportedResponseMimeTypes(List.of("supportedResponseMimeTypes"))
 *                 .supportedTransformInstanceTypes(List.of("supportedTransformInstanceTypes"))
 *                 .build())
 *         .additionalInferenceSpecifications(List.of(AdditionalInferenceSpecificationDefinitionProperty.builder()
 *                 .containers(List.of(ModelPackageContainerDefinitionProperty.builder()
 *                         .image("image")
 *                         // the properties below are optional
 *                         .containerHostname("containerHostname")
 *                         .environment(environment)
 *                         .framework("framework")
 *                         .frameworkVersion("frameworkVersion")
 *                         .imageDigest("imageDigest")
 *                         .modelDataUrl("modelDataUrl")
 *                         .modelInput(modelInput)
 *                         .nearestModelName("nearestModelName")
 *                         .productId("productId")
 *                         .build()))
 *                 .name("name")
 *                 // the properties below are optional
 *                 .description("description")
 *                 .supportedContentTypes(List.of("supportedContentTypes"))
 *                 .supportedRealtimeInferenceInstanceTypes(List.of("supportedRealtimeInferenceInstanceTypes"))
 *                 .supportedResponseMimeTypes(List.of("supportedResponseMimeTypes"))
 *                 .supportedTransformInstanceTypes(List.of("supportedTransformInstanceTypes"))
 *                 .build()))
 *         .additionalInferenceSpecificationsToAdd(List.of(AdditionalInferenceSpecificationDefinitionProperty.builder()
 *                 .containers(List.of(ModelPackageContainerDefinitionProperty.builder()
 *                         .image("image")
 *                         // the properties below are optional
 *                         .containerHostname("containerHostname")
 *                         .environment(environment)
 *                         .framework("framework")
 *                         .frameworkVersion("frameworkVersion")
 *                         .imageDigest("imageDigest")
 *                         .modelDataUrl("modelDataUrl")
 *                         .modelInput(modelInput)
 *                         .nearestModelName("nearestModelName")
 *                         .productId("productId")
 *                         .build()))
 *                 .name("name")
 *                 // the properties below are optional
 *                 .description("description")
 *                 .supportedContentTypes(List.of("supportedContentTypes"))
 *                 .supportedRealtimeInferenceInstanceTypes(List.of("supportedRealtimeInferenceInstanceTypes"))
 *                 .supportedResponseMimeTypes(List.of("supportedResponseMimeTypes"))
 *                 .supportedTransformInstanceTypes(List.of("supportedTransformInstanceTypes"))
 *                 .build()))
 *         .approvalDescription("approvalDescription")
 *         .certifyForMarketplace(false)
 *         .clientToken("clientToken")
 *         .createdBy(UserContextProperty.builder()
 *                 .domainId("domainId")
 *                 .userProfileArn("userProfileArn")
 *                 .userProfileName("userProfileName")
 *                 .build())
 *         .customerMetadataProperties(Map.of(
 *                 "customerMetadataPropertiesKey", "customerMetadataProperties"))
 *         .domain("domain")
 *         .driftCheckBaselines(DriftCheckBaselinesProperty.builder()
 *                 .bias(DriftCheckBiasProperty.builder()
 *                         .configFile(FileSourceProperty.builder()
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .contentType("contentType")
 *                                 .build())
 *                         .postTrainingConstraints(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .preTrainingConstraints(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .build())
 *                 .explainability(DriftCheckExplainabilityProperty.builder()
 *                         .configFile(FileSourceProperty.builder()
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .contentType("contentType")
 *                                 .build())
 *                         .constraints(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .build())
 *                 .modelDataQuality(DriftCheckModelDataQualityProperty.builder()
 *                         .constraints(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .statistics(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .build())
 *                 .modelQuality(DriftCheckModelQualityProperty.builder()
 *                         .constraints(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .statistics(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .environment(Map.of(
 *                 "environmentKey", "environment"))
 *         .inferenceSpecification(InferenceSpecificationProperty.builder()
 *                 .containers(List.of(ModelPackageContainerDefinitionProperty.builder()
 *                         .image("image")
 *                         // the properties below are optional
 *                         .containerHostname("containerHostname")
 *                         .environment(environment)
 *                         .framework("framework")
 *                         .frameworkVersion("frameworkVersion")
 *                         .imageDigest("imageDigest")
 *                         .modelDataUrl("modelDataUrl")
 *                         .modelInput(modelInput)
 *                         .nearestModelName("nearestModelName")
 *                         .productId("productId")
 *                         .build()))
 *                 .supportedContentTypes(List.of("supportedContentTypes"))
 *                 .supportedResponseMimeTypes(List.of("supportedResponseMimeTypes"))
 *                 // the properties below are optional
 *                 .supportedRealtimeInferenceInstanceTypes(List.of("supportedRealtimeInferenceInstanceTypes"))
 *                 .supportedTransformInstanceTypes(List.of("supportedTransformInstanceTypes"))
 *                 .build())
 *         .lastModifiedBy(UserContextProperty.builder()
 *                 .domainId("domainId")
 *                 .userProfileArn("userProfileArn")
 *                 .userProfileName("userProfileName")
 *                 .build())
 *         .lastModifiedTime("lastModifiedTime")
 *         .metadataProperties(MetadataPropertiesProperty.builder()
 *                 .commitId("commitId")
 *                 .generatedBy("generatedBy")
 *                 .projectId("projectId")
 *                 .repository("repository")
 *                 .build())
 *         .modelApprovalStatus("modelApprovalStatus")
 *         .modelMetrics(ModelMetricsProperty.builder()
 *                 .bias(BiasProperty.builder()
 *                         .postTrainingReport(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .preTrainingReport(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .report(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .build())
 *                 .explainability(ExplainabilityProperty.builder()
 *                         .report(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .build())
 *                 .modelDataQuality(ModelDataQualityProperty.builder()
 *                         .constraints(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .statistics(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .build())
 *                 .modelQuality(ModelQualityProperty.builder()
 *                         .constraints(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .statistics(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .modelPackageDescription("modelPackageDescription")
 *         .modelPackageGroupName("modelPackageGroupName")
 *         .modelPackageName("modelPackageName")
 *         .modelPackageStatusDetails(ModelPackageStatusDetailsProperty.builder()
 *                 .validationStatuses(List.of(ModelPackageStatusItemProperty.builder()
 *                         .name("name")
 *                         .status("status")
 *                         // the properties below are optional
 *                         .failureReason("failureReason")
 *                         .build()))
 *                 // the properties below are optional
 *                 .imageScanStatuses(List.of(ModelPackageStatusItemProperty.builder()
 *                         .name("name")
 *                         .status("status")
 *                         // the properties below are optional
 *                         .failureReason("failureReason")
 *                         .build()))
 *                 .build())
 *         .modelPackageStatusItem(ModelPackageStatusItemProperty.builder()
 *                 .name("name")
 *                 .status("status")
 *                 // the properties below are optional
 *                 .failureReason("failureReason")
 *                 .build())
 *         .modelPackageVersion(123)
 *         .samplePayloadUrl("samplePayloadUrl")
 *         .sourceAlgorithmSpecification(SourceAlgorithmSpecificationProperty.builder()
 *                 .sourceAlgorithms(List.of(SourceAlgorithmProperty.builder()
 *                         .algorithmName("algorithmName")
 *                         // the properties below are optional
 *                         .modelDataUrl("modelDataUrl")
 *                         .build()))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .task("task")
 *         .validationSpecification(ValidationSpecificationProperty.builder()
 *                 .validationProfiles(List.of(ValidationProfileProperty.builder()
 *                         .profileName("profileName")
 *                         .transformJobDefinition(TransformJobDefinitionProperty.builder()
 *                                 .transformInput(TransformInputProperty.builder()
 *                                         .dataSource(DataSourceProperty.builder()
 *                                                 .s3DataSource(S3DataSourceProperty.builder()
 *                                                         .s3DataType("s3DataType")
 *                                                         .s3Uri("s3Uri")
 *                                                         .build())
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .compressionType("compressionType")
 *                                         .contentType("contentType")
 *                                         .splitType("splitType")
 *                                         .build())
 *                                 .transformOutput(TransformOutputProperty.builder()
 *                                         .s3OutputPath("s3OutputPath")
 *                                         // the properties below are optional
 *                                         .accept("accept")
 *                                         .assembleWith("assembleWith")
 *                                         .kmsKeyId("kmsKeyId")
 *                                         .build())
 *                                 .transformResources(TransformResourcesProperty.builder()
 *                                         .instanceCount(123)
 *                                         .instanceType("instanceType")
 *                                         // the properties below are optional
 *                                         .volumeKmsKeyId("volumeKmsKeyId")
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .batchStrategy("batchStrategy")
 *                                 .environment(environment)
 *                                 .maxConcurrentTransforms(123)
 *                                 .maxPayloadInMb(123)
 *                                 .build())
 *                         .build()))
 *                 .validationRole("validationRole")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T02:14:06.824Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage")
public class CfnModelPackage extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnModelPackage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnModelPackage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnModelPackage.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::SageMaker::ModelPackage`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnModelPackage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnModelPackageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::SageMaker::ModelPackage`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnModelPackage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrModelPackageArn() {
        return software.amazon.jsii.Kernel.get(this, "attrModelPackageArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrModelPackageStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrModelPackageStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of the tags associated with the model package.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> in the <em>AWS General Reference Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * `AWS::SageMaker::ModelPackage.AdditionalInferenceSpecificationDefinition`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalInferenceSpecificationDefinition() {
        return software.amazon.jsii.Kernel.get(this, "additionalInferenceSpecificationDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SageMaker::ModelPackage.AdditionalInferenceSpecificationDefinition`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalInferenceSpecificationDefinition(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "additionalInferenceSpecificationDefinition", value);
    }

    /**
     * `AWS::SageMaker::ModelPackage.AdditionalInferenceSpecificationDefinition`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalInferenceSpecificationDefinition(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnModelPackage.AdditionalInferenceSpecificationDefinitionProperty value) {
        software.amazon.jsii.Kernel.set(this, "additionalInferenceSpecificationDefinition", value);
    }

    /**
     * An array of additional Inference Specification objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalInferenceSpecifications() {
        return software.amazon.jsii.Kernel.get(this, "additionalInferenceSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of additional Inference Specification objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalInferenceSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "additionalInferenceSpecifications", value);
    }

    /**
     * An array of additional Inference Specification objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalInferenceSpecifications(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.sagemaker.CfnModelPackage.AdditionalInferenceSpecificationDefinitionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.sagemaker.CfnModelPackage.AdditionalInferenceSpecificationDefinitionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "additionalInferenceSpecifications", value);
    }

    /**
     * `AWS::SageMaker::ModelPackage.AdditionalInferenceSpecificationsToAdd`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalInferenceSpecificationsToAdd() {
        return software.amazon.jsii.Kernel.get(this, "additionalInferenceSpecificationsToAdd", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SageMaker::ModelPackage.AdditionalInferenceSpecificationsToAdd`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalInferenceSpecificationsToAdd(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "additionalInferenceSpecificationsToAdd", value);
    }

    /**
     * `AWS::SageMaker::ModelPackage.AdditionalInferenceSpecificationsToAdd`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalInferenceSpecificationsToAdd(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.sagemaker.CfnModelPackage.AdditionalInferenceSpecificationDefinitionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.sagemaker.CfnModelPackage.AdditionalInferenceSpecificationDefinitionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "additionalInferenceSpecificationsToAdd", value);
    }

    /**
     * A description provided when the model approval is set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getApprovalDescription() {
        return software.amazon.jsii.Kernel.get(this, "approvalDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description provided when the model approval is set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApprovalDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "approvalDescription", value);
    }

    /**
     * Whether the model package is to be certified to be listed on AWS Marketplace.
     * <p>
     * For information about listing model packages on AWS Marketplace, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html">List Your Algorithm or Model Package on AWS Marketplace</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCertifyForMarketplace() {
        return software.amazon.jsii.Kernel.get(this, "certifyForMarketplace", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether the model package is to be certified to be listed on AWS Marketplace.
     * <p>
     * For information about listing model packages on AWS Marketplace, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html">List Your Algorithm or Model Package on AWS Marketplace</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertifyForMarketplace(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "certifyForMarketplace", value);
    }

    /**
     * Whether the model package is to be certified to be listed on AWS Marketplace.
     * <p>
     * For information about listing model packages on AWS Marketplace, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html">List Your Algorithm or Model Package on AWS Marketplace</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertifyForMarketplace(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "certifyForMarketplace", value);
    }

    /**
     * `AWS::SageMaker::ModelPackage.ClientToken`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClientToken() {
        return software.amazon.jsii.Kernel.get(this, "clientToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::SageMaker::ModelPackage.ClientToken`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientToken(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clientToken", value);
    }

    /**
     * `AWS::SageMaker::ModelPackage.CreatedBy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCreatedBy() {
        return software.amazon.jsii.Kernel.get(this, "createdBy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SageMaker::ModelPackage.CreatedBy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCreatedBy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "createdBy", value);
    }

    /**
     * `AWS::SageMaker::ModelPackage.CreatedBy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCreatedBy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnModelPackage.UserContextProperty value) {
        software.amazon.jsii.Kernel.set(this, "createdBy", value);
    }

    /**
     * The metadata properties for the model package.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCustomerMetadataProperties() {
        return software.amazon.jsii.Kernel.get(this, "customerMetadataProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The metadata properties for the model package.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomerMetadataProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "customerMetadataProperties", value);
    }

    /**
     * The metadata properties for the model package.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomerMetadataProperties(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "customerMetadataProperties", value);
    }

    /**
     * The machine learning domain of your model package and its components.
     * <p>
     * Common machine learning domains include computer vision and natural language processing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomain() {
        return software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The machine learning domain of your model package and its components.
     * <p>
     * Common machine learning domains include computer vision and natural language processing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomain(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domain", value);
    }

    /**
     * Represents the drift check baselines that can be used when the model monitor is set using the model package.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDriftCheckBaselines() {
        return software.amazon.jsii.Kernel.get(this, "driftCheckBaselines", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Represents the drift check baselines that can be used when the model monitor is set using the model package.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDriftCheckBaselines(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "driftCheckBaselines", value);
    }

    /**
     * Represents the drift check baselines that can be used when the model monitor is set using the model package.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDriftCheckBaselines(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnModelPackage.DriftCheckBaselinesProperty value) {
        software.amazon.jsii.Kernel.set(this, "driftCheckBaselines", value);
    }

    /**
     * The environment variables to set in the Docker container.
     * <p>
     * Each key and value in the <code>Environment</code> string to string map can have length of up to 1024. We support up to 16 entries in the map.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
        return software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The environment variables to set in the Docker container.
     * <p>
     * Each key and value in the <code>Environment</code> string to string map can have length of up to 1024. We support up to 16 entries in the map.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironment(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "environment", value);
    }

    /**
     * The environment variables to set in the Docker container.
     * <p>
     * Each key and value in the <code>Environment</code> string to string map can have length of up to 1024. We support up to 16 entries in the map.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironment(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "environment", value);
    }

    /**
     * `AWS::SageMaker::ModelPackage.InferenceSpecification`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInferenceSpecification() {
        return software.amazon.jsii.Kernel.get(this, "inferenceSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SageMaker::ModelPackage.InferenceSpecification`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInferenceSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "inferenceSpecification", value);
    }

    /**
     * `AWS::SageMaker::ModelPackage.InferenceSpecification`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInferenceSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnModelPackage.InferenceSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "inferenceSpecification", value);
    }

    /**
     * `AWS::SageMaker::ModelPackage.LastModifiedBy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLastModifiedBy() {
        return software.amazon.jsii.Kernel.get(this, "lastModifiedBy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SageMaker::ModelPackage.LastModifiedBy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLastModifiedBy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lastModifiedBy", value);
    }

    /**
     * `AWS::SageMaker::ModelPackage.LastModifiedBy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLastModifiedBy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnModelPackage.UserContextProperty value) {
        software.amazon.jsii.Kernel.set(this, "lastModifiedBy", value);
    }

    /**
     * The last time the model package was modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLastModifiedTime() {
        return software.amazon.jsii.Kernel.get(this, "lastModifiedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The last time the model package was modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLastModifiedTime(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "lastModifiedTime", value);
    }

    /**
     * `AWS::SageMaker::ModelPackage.MetadataProperties`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMetadataProperties() {
        return software.amazon.jsii.Kernel.get(this, "metadataProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SageMaker::ModelPackage.MetadataProperties`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetadataProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "metadataProperties", value);
    }

    /**
     * `AWS::SageMaker::ModelPackage.MetadataProperties`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetadataProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnModelPackage.MetadataPropertiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "metadataProperties", value);
    }

    /**
     * The approval status of the model. This can be one of the following values.
     * <p>
     * <ul>
     * <li><code>APPROVED</code> - The model is approved</li>
     * <li><code>REJECTED</code> - The model is rejected.</li>
     * <li><code>PENDING_MANUAL_APPROVAL</code> - The model is waiting for manual approval.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getModelApprovalStatus() {
        return software.amazon.jsii.Kernel.get(this, "modelApprovalStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The approval status of the model. This can be one of the following values.
     * <p>
     * <ul>
     * <li><code>APPROVED</code> - The model is approved</li>
     * <li><code>REJECTED</code> - The model is rejected.</li>
     * <li><code>PENDING_MANUAL_APPROVAL</code> - The model is waiting for manual approval.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelApprovalStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "modelApprovalStatus", value);
    }

    /**
     * Metrics for the model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getModelMetrics() {
        return software.amazon.jsii.Kernel.get(this, "modelMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Metrics for the model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelMetrics(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "modelMetrics", value);
    }

    /**
     * Metrics for the model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelMetrics(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnModelPackage.ModelMetricsProperty value) {
        software.amazon.jsii.Kernel.set(this, "modelMetrics", value);
    }

    /**
     * The description of the model package.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getModelPackageDescription() {
        return software.amazon.jsii.Kernel.get(this, "modelPackageDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the model package.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelPackageDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "modelPackageDescription", value);
    }

    /**
     * The model group to which the model belongs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getModelPackageGroupName() {
        return software.amazon.jsii.Kernel.get(this, "modelPackageGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The model group to which the model belongs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelPackageGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "modelPackageGroupName", value);
    }

    /**
     * The name of the model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getModelPackageName() {
        return software.amazon.jsii.Kernel.get(this, "modelPackageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelPackageName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "modelPackageName", value);
    }

    /**
     * `AWS::SageMaker::ModelPackage.ModelPackageStatusDetails`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getModelPackageStatusDetails() {
        return software.amazon.jsii.Kernel.get(this, "modelPackageStatusDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SageMaker::ModelPackage.ModelPackageStatusDetails`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelPackageStatusDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "modelPackageStatusDetails", value);
    }

    /**
     * `AWS::SageMaker::ModelPackage.ModelPackageStatusDetails`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelPackageStatusDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnModelPackage.ModelPackageStatusDetailsProperty value) {
        software.amazon.jsii.Kernel.set(this, "modelPackageStatusDetails", value);
    }

    /**
     * `AWS::SageMaker::ModelPackage.ModelPackageStatusItem`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getModelPackageStatusItem() {
        return software.amazon.jsii.Kernel.get(this, "modelPackageStatusItem", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SageMaker::ModelPackage.ModelPackageStatusItem`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelPackageStatusItem(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "modelPackageStatusItem", value);
    }

    /**
     * `AWS::SageMaker::ModelPackage.ModelPackageStatusItem`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelPackageStatusItem(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnModelPackage.ModelPackageStatusItemProperty value) {
        software.amazon.jsii.Kernel.set(this, "modelPackageStatusItem", value);
    }

    /**
     * The version number of a versioned model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getModelPackageVersion() {
        return software.amazon.jsii.Kernel.get(this, "modelPackageVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The version number of a versioned model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelPackageVersion(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "modelPackageVersion", value);
    }

    /**
     * The Amazon Simple Storage Service path where the sample payload are stored.
     * <p>
     * This path must point to a single gzip compressed tar archive (.tar.gz suffix).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSamplePayloadUrl() {
        return software.amazon.jsii.Kernel.get(this, "samplePayloadUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Simple Storage Service path where the sample payload are stored.
     * <p>
     * This path must point to a single gzip compressed tar archive (.tar.gz suffix).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSamplePayloadUrl(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "samplePayloadUrl", value);
    }

    /**
     * `AWS::SageMaker::ModelPackage.SourceAlgorithmSpecification`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSourceAlgorithmSpecification() {
        return software.amazon.jsii.Kernel.get(this, "sourceAlgorithmSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SageMaker::ModelPackage.SourceAlgorithmSpecification`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceAlgorithmSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sourceAlgorithmSpecification", value);
    }

    /**
     * `AWS::SageMaker::ModelPackage.SourceAlgorithmSpecification`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceAlgorithmSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnModelPackage.SourceAlgorithmSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "sourceAlgorithmSpecification", value);
    }

    /**
     * The machine learning task your model package accomplishes.
     * <p>
     * Common machine learning tasks include object detection and image classification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTask() {
        return software.amazon.jsii.Kernel.get(this, "task", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The machine learning task your model package accomplishes.
     * <p>
     * Common machine learning tasks include object detection and image classification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTask(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "task", value);
    }

    /**
     * `AWS::SageMaker::ModelPackage.ValidationSpecification`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getValidationSpecification() {
        return software.amazon.jsii.Kernel.get(this, "validationSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SageMaker::ModelPackage.ValidationSpecification`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidationSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "validationSpecification", value);
    }

    /**
     * `AWS::SageMaker::ModelPackage.ValidationSpecification`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidationSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnModelPackage.ValidationSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "validationSpecification", value);
    }
    /**
     * A structure of additional Inference Specification.
     * <p>
     * Additional Inference Specification specifies details about inference jobs that can be run with models based on this model package
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * Object environment;
     * Object modelInput;
     * AdditionalInferenceSpecificationDefinitionProperty additionalInferenceSpecificationDefinitionProperty = AdditionalInferenceSpecificationDefinitionProperty.builder()
     *         .containers(List.of(ModelPackageContainerDefinitionProperty.builder()
     *                 .image("image")
     *                 // the properties below are optional
     *                 .containerHostname("containerHostname")
     *                 .environment(environment)
     *                 .framework("framework")
     *                 .frameworkVersion("frameworkVersion")
     *                 .imageDigest("imageDigest")
     *                 .modelDataUrl("modelDataUrl")
     *                 .modelInput(modelInput)
     *                 .nearestModelName("nearestModelName")
     *                 .productId("productId")
     *                 .build()))
     *         .name("name")
     *         // the properties below are optional
     *         .description("description")
     *         .supportedContentTypes(List.of("supportedContentTypes"))
     *         .supportedRealtimeInferenceInstanceTypes(List.of("supportedRealtimeInferenceInstanceTypes"))
     *         .supportedResponseMimeTypes(List.of("supportedResponseMimeTypes"))
     *         .supportedTransformInstanceTypes(List.of("supportedTransformInstanceTypes"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.AdditionalInferenceSpecificationDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(AdditionalInferenceSpecificationDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdditionalInferenceSpecificationDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon ECR registry path of the Docker image that contains the inference code.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getContainers();

        /**
         * A unique name to identify the additional inference specification.
         * <p>
         * The name must be unique within the list of your additional inference specifications for a particular model package.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * A description of the additional Inference specification.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The supported MIME types for the input data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSupportedContentTypes() {
            return null;
        }

        /**
         * A list of the instance types that are used to generate inferences in real-time.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSupportedRealtimeInferenceInstanceTypes() {
            return null;
        }

        /**
         * The supported MIME types for the output data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSupportedResponseMimeTypes() {
            return null;
        }

        /**
         * A list of the instance types on which a transformation job can be run or on which an endpoint can be deployed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSupportedTransformInstanceTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdditionalInferenceSpecificationDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdditionalInferenceSpecificationDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdditionalInferenceSpecificationDefinitionProperty> {
            java.lang.Object containers;
            java.lang.String name;
            java.lang.String description;
            java.util.List<java.lang.String> supportedContentTypes;
            java.util.List<java.lang.String> supportedRealtimeInferenceInstanceTypes;
            java.util.List<java.lang.String> supportedResponseMimeTypes;
            java.util.List<java.lang.String> supportedTransformInstanceTypes;

            /**
             * Sets the value of {@link AdditionalInferenceSpecificationDefinitionProperty#getContainers}
             * @param containers The Amazon ECR registry path of the Docker image that contains the inference code. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containers(software.amazon.awscdk.core.IResolvable containers) {
                this.containers = containers;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalInferenceSpecificationDefinitionProperty#getContainers}
             * @param containers The Amazon ECR registry path of the Docker image that contains the inference code. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containers(java.util.List<? extends java.lang.Object> containers) {
                this.containers = containers;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalInferenceSpecificationDefinitionProperty#getName}
             * @param name A unique name to identify the additional inference specification. This parameter is required.
             *             The name must be unique within the list of your additional inference specifications for a particular model package.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalInferenceSpecificationDefinitionProperty#getDescription}
             * @param description A description of the additional Inference specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalInferenceSpecificationDefinitionProperty#getSupportedContentTypes}
             * @param supportedContentTypes The supported MIME types for the input data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supportedContentTypes(java.util.List<java.lang.String> supportedContentTypes) {
                this.supportedContentTypes = supportedContentTypes;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalInferenceSpecificationDefinitionProperty#getSupportedRealtimeInferenceInstanceTypes}
             * @param supportedRealtimeInferenceInstanceTypes A list of the instance types that are used to generate inferences in real-time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supportedRealtimeInferenceInstanceTypes(java.util.List<java.lang.String> supportedRealtimeInferenceInstanceTypes) {
                this.supportedRealtimeInferenceInstanceTypes = supportedRealtimeInferenceInstanceTypes;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalInferenceSpecificationDefinitionProperty#getSupportedResponseMimeTypes}
             * @param supportedResponseMimeTypes The supported MIME types for the output data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supportedResponseMimeTypes(java.util.List<java.lang.String> supportedResponseMimeTypes) {
                this.supportedResponseMimeTypes = supportedResponseMimeTypes;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalInferenceSpecificationDefinitionProperty#getSupportedTransformInstanceTypes}
             * @param supportedTransformInstanceTypes A list of the instance types on which a transformation job can be run or on which an endpoint can be deployed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supportedTransformInstanceTypes(java.util.List<java.lang.String> supportedTransformInstanceTypes) {
                this.supportedTransformInstanceTypes = supportedTransformInstanceTypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdditionalInferenceSpecificationDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdditionalInferenceSpecificationDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdditionalInferenceSpecificationDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdditionalInferenceSpecificationDefinitionProperty {
            private final java.lang.Object containers;
            private final java.lang.String name;
            private final java.lang.String description;
            private final java.util.List<java.lang.String> supportedContentTypes;
            private final java.util.List<java.lang.String> supportedRealtimeInferenceInstanceTypes;
            private final java.util.List<java.lang.String> supportedResponseMimeTypes;
            private final java.util.List<java.lang.String> supportedTransformInstanceTypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containers = software.amazon.jsii.Kernel.get(this, "containers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.supportedContentTypes = software.amazon.jsii.Kernel.get(this, "supportedContentTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.supportedRealtimeInferenceInstanceTypes = software.amazon.jsii.Kernel.get(this, "supportedRealtimeInferenceInstanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.supportedResponseMimeTypes = software.amazon.jsii.Kernel.get(this, "supportedResponseMimeTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.supportedTransformInstanceTypes = software.amazon.jsii.Kernel.get(this, "supportedTransformInstanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containers = java.util.Objects.requireNonNull(builder.containers, "containers is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.description = builder.description;
                this.supportedContentTypes = builder.supportedContentTypes;
                this.supportedRealtimeInferenceInstanceTypes = builder.supportedRealtimeInferenceInstanceTypes;
                this.supportedResponseMimeTypes = builder.supportedResponseMimeTypes;
                this.supportedTransformInstanceTypes = builder.supportedTransformInstanceTypes;
            }

            @Override
            public final java.lang.Object getContainers() {
                return this.containers;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.util.List<java.lang.String> getSupportedContentTypes() {
                return this.supportedContentTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getSupportedRealtimeInferenceInstanceTypes() {
                return this.supportedRealtimeInferenceInstanceTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getSupportedResponseMimeTypes() {
                return this.supportedResponseMimeTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getSupportedTransformInstanceTypes() {
                return this.supportedTransformInstanceTypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("containers", om.valueToTree(this.getContainers()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getSupportedContentTypes() != null) {
                    data.set("supportedContentTypes", om.valueToTree(this.getSupportedContentTypes()));
                }
                if (this.getSupportedRealtimeInferenceInstanceTypes() != null) {
                    data.set("supportedRealtimeInferenceInstanceTypes", om.valueToTree(this.getSupportedRealtimeInferenceInstanceTypes()));
                }
                if (this.getSupportedResponseMimeTypes() != null) {
                    data.set("supportedResponseMimeTypes", om.valueToTree(this.getSupportedResponseMimeTypes()));
                }
                if (this.getSupportedTransformInstanceTypes() != null) {
                    data.set("supportedTransformInstanceTypes", om.valueToTree(this.getSupportedTransformInstanceTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.AdditionalInferenceSpecificationDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdditionalInferenceSpecificationDefinitionProperty.Jsii$Proxy that = (AdditionalInferenceSpecificationDefinitionProperty.Jsii$Proxy) o;

                if (!containers.equals(that.containers)) return false;
                if (!name.equals(that.name)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.supportedContentTypes != null ? !this.supportedContentTypes.equals(that.supportedContentTypes) : that.supportedContentTypes != null) return false;
                if (this.supportedRealtimeInferenceInstanceTypes != null ? !this.supportedRealtimeInferenceInstanceTypes.equals(that.supportedRealtimeInferenceInstanceTypes) : that.supportedRealtimeInferenceInstanceTypes != null) return false;
                if (this.supportedResponseMimeTypes != null ? !this.supportedResponseMimeTypes.equals(that.supportedResponseMimeTypes) : that.supportedResponseMimeTypes != null) return false;
                return this.supportedTransformInstanceTypes != null ? this.supportedTransformInstanceTypes.equals(that.supportedTransformInstanceTypes) : that.supportedTransformInstanceTypes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containers.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.supportedContentTypes != null ? this.supportedContentTypes.hashCode() : 0);
                result = 31 * result + (this.supportedRealtimeInferenceInstanceTypes != null ? this.supportedRealtimeInferenceInstanceTypes.hashCode() : 0);
                result = 31 * result + (this.supportedResponseMimeTypes != null ? this.supportedResponseMimeTypes.hashCode() : 0);
                result = 31 * result + (this.supportedTransformInstanceTypes != null ? this.supportedTransformInstanceTypes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains bias metrics for a model.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * BiasProperty biasProperty = BiasProperty.builder()
     *         .postTrainingReport(MetricsSourceProperty.builder()
     *                 .contentType("contentType")
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .contentDigest("contentDigest")
     *                 .build())
     *         .preTrainingReport(MetricsSourceProperty.builder()
     *                 .contentType("contentType")
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .contentDigest("contentDigest")
     *                 .build())
     *         .report(MetricsSourceProperty.builder()
     *                 .contentType("contentType")
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .contentDigest("contentDigest")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.BiasProperty")
    @software.amazon.jsii.Jsii.Proxy(BiasProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BiasProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnModelPackage.BiasProperty.PostTrainingReport`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPostTrainingReport() {
            return null;
        }

        /**
         * `CfnModelPackage.BiasProperty.PreTrainingReport`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPreTrainingReport() {
            return null;
        }

        /**
         * The bias report for a model.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReport() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BiasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BiasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BiasProperty> {
            java.lang.Object postTrainingReport;
            java.lang.Object preTrainingReport;
            java.lang.Object report;

            /**
             * Sets the value of {@link BiasProperty#getPostTrainingReport}
             * @param postTrainingReport `CfnModelPackage.BiasProperty.PostTrainingReport`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postTrainingReport(software.amazon.awscdk.core.IResolvable postTrainingReport) {
                this.postTrainingReport = postTrainingReport;
                return this;
            }

            /**
             * Sets the value of {@link BiasProperty#getPostTrainingReport}
             * @param postTrainingReport `CfnModelPackage.BiasProperty.PostTrainingReport`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postTrainingReport(software.amazon.awscdk.services.sagemaker.CfnModelPackage.MetricsSourceProperty postTrainingReport) {
                this.postTrainingReport = postTrainingReport;
                return this;
            }

            /**
             * Sets the value of {@link BiasProperty#getPreTrainingReport}
             * @param preTrainingReport `CfnModelPackage.BiasProperty.PreTrainingReport`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preTrainingReport(software.amazon.awscdk.core.IResolvable preTrainingReport) {
                this.preTrainingReport = preTrainingReport;
                return this;
            }

            /**
             * Sets the value of {@link BiasProperty#getPreTrainingReport}
             * @param preTrainingReport `CfnModelPackage.BiasProperty.PreTrainingReport`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preTrainingReport(software.amazon.awscdk.services.sagemaker.CfnModelPackage.MetricsSourceProperty preTrainingReport) {
                this.preTrainingReport = preTrainingReport;
                return this;
            }

            /**
             * Sets the value of {@link BiasProperty#getReport}
             * @param report The bias report for a model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder report(software.amazon.awscdk.core.IResolvable report) {
                this.report = report;
                return this;
            }

            /**
             * Sets the value of {@link BiasProperty#getReport}
             * @param report The bias report for a model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder report(software.amazon.awscdk.services.sagemaker.CfnModelPackage.MetricsSourceProperty report) {
                this.report = report;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BiasProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BiasProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BiasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BiasProperty {
            private final java.lang.Object postTrainingReport;
            private final java.lang.Object preTrainingReport;
            private final java.lang.Object report;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.postTrainingReport = software.amazon.jsii.Kernel.get(this, "postTrainingReport", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.preTrainingReport = software.amazon.jsii.Kernel.get(this, "preTrainingReport", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.report = software.amazon.jsii.Kernel.get(this, "report", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.postTrainingReport = builder.postTrainingReport;
                this.preTrainingReport = builder.preTrainingReport;
                this.report = builder.report;
            }

            @Override
            public final java.lang.Object getPostTrainingReport() {
                return this.postTrainingReport;
            }

            @Override
            public final java.lang.Object getPreTrainingReport() {
                return this.preTrainingReport;
            }

            @Override
            public final java.lang.Object getReport() {
                return this.report;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPostTrainingReport() != null) {
                    data.set("postTrainingReport", om.valueToTree(this.getPostTrainingReport()));
                }
                if (this.getPreTrainingReport() != null) {
                    data.set("preTrainingReport", om.valueToTree(this.getPreTrainingReport()));
                }
                if (this.getReport() != null) {
                    data.set("report", om.valueToTree(this.getReport()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.BiasProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BiasProperty.Jsii$Proxy that = (BiasProperty.Jsii$Proxy) o;

                if (this.postTrainingReport != null ? !this.postTrainingReport.equals(that.postTrainingReport) : that.postTrainingReport != null) return false;
                if (this.preTrainingReport != null ? !this.preTrainingReport.equals(that.preTrainingReport) : that.preTrainingReport != null) return false;
                return this.report != null ? this.report.equals(that.report) : that.report == null;
            }

            @Override
            public final int hashCode() {
                int result = this.postTrainingReport != null ? this.postTrainingReport.hashCode() : 0;
                result = 31 * result + (this.preTrainingReport != null ? this.preTrainingReport.hashCode() : 0);
                result = 31 * result + (this.report != null ? this.report.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the location of the channel data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DataSourceProperty dataSourceProperty = DataSourceProperty.builder()
     *         .s3DataSource(S3DataSourceProperty.builder()
     *                 .s3DataType("s3DataType")
     *                 .s3Uri("s3Uri")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.DataSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 location of the data source that is associated with a channel.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3DataSource();

        /**
         * @return a {@link Builder} of {@link DataSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSourceProperty> {
            java.lang.Object s3DataSource;

            /**
             * Sets the value of {@link DataSourceProperty#getS3DataSource}
             * @param s3DataSource The S3 location of the data source that is associated with a channel. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3DataSource(software.amazon.awscdk.core.IResolvable s3DataSource) {
                this.s3DataSource = s3DataSource;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceProperty#getS3DataSource}
             * @param s3DataSource The S3 location of the data source that is associated with a channel. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3DataSource(software.amazon.awscdk.services.sagemaker.CfnModelPackage.S3DataSourceProperty s3DataSource) {
                this.s3DataSource = s3DataSource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSourceProperty {
            private final java.lang.Object s3DataSource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3DataSource = software.amazon.jsii.Kernel.get(this, "s3DataSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3DataSource = java.util.Objects.requireNonNull(builder.s3DataSource, "s3DataSource is required");
            }

            @Override
            public final java.lang.Object getS3DataSource() {
                return this.s3DataSource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3DataSource", om.valueToTree(this.getS3DataSource()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.DataSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSourceProperty.Jsii$Proxy that = (DataSourceProperty.Jsii$Proxy) o;

                return this.s3DataSource.equals(that.s3DataSource);
            }

            @Override
            public final int hashCode() {
                int result = this.s3DataSource.hashCode();
                return result;
            }
        }
    }
    /**
     * Represents the drift check baselines that can be used when the model monitor is set using the model package.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DriftCheckBaselinesProperty driftCheckBaselinesProperty = DriftCheckBaselinesProperty.builder()
     *         .bias(DriftCheckBiasProperty.builder()
     *                 .configFile(FileSourceProperty.builder()
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .contentDigest("contentDigest")
     *                         .contentType("contentType")
     *                         .build())
     *                 .postTrainingConstraints(MetricsSourceProperty.builder()
     *                         .contentType("contentType")
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .contentDigest("contentDigest")
     *                         .build())
     *                 .preTrainingConstraints(MetricsSourceProperty.builder()
     *                         .contentType("contentType")
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .contentDigest("contentDigest")
     *                         .build())
     *                 .build())
     *         .explainability(DriftCheckExplainabilityProperty.builder()
     *                 .configFile(FileSourceProperty.builder()
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .contentDigest("contentDigest")
     *                         .contentType("contentType")
     *                         .build())
     *                 .constraints(MetricsSourceProperty.builder()
     *                         .contentType("contentType")
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .contentDigest("contentDigest")
     *                         .build())
     *                 .build())
     *         .modelDataQuality(DriftCheckModelDataQualityProperty.builder()
     *                 .constraints(MetricsSourceProperty.builder()
     *                         .contentType("contentType")
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .contentDigest("contentDigest")
     *                         .build())
     *                 .statistics(MetricsSourceProperty.builder()
     *                         .contentType("contentType")
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .contentDigest("contentDigest")
     *                         .build())
     *                 .build())
     *         .modelQuality(DriftCheckModelQualityProperty.builder()
     *                 .constraints(MetricsSourceProperty.builder()
     *                         .contentType("contentType")
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .contentDigest("contentDigest")
     *                         .build())
     *                 .statistics(MetricsSourceProperty.builder()
     *                         .contentType("contentType")
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .contentDigest("contentDigest")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.DriftCheckBaselinesProperty")
    @software.amazon.jsii.Jsii.Proxy(DriftCheckBaselinesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DriftCheckBaselinesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Represents the drift check bias baselines that can be used when the model monitor is set using the model package.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBias() {
            return null;
        }

        /**
         * Represents the drift check explainability baselines that can be used when the model monitor is set using the model package.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExplainability() {
            return null;
        }

        /**
         * Represents the drift check model data quality baselines that can be used when the model monitor is set using the model package.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getModelDataQuality() {
            return null;
        }

        /**
         * Represents the drift check model quality baselines that can be used when the model monitor is set using the model package.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getModelQuality() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DriftCheckBaselinesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DriftCheckBaselinesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DriftCheckBaselinesProperty> {
            java.lang.Object bias;
            java.lang.Object explainability;
            java.lang.Object modelDataQuality;
            java.lang.Object modelQuality;

            /**
             * Sets the value of {@link DriftCheckBaselinesProperty#getBias}
             * @param bias Represents the drift check bias baselines that can be used when the model monitor is set using the model package.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bias(software.amazon.awscdk.core.IResolvable bias) {
                this.bias = bias;
                return this;
            }

            /**
             * Sets the value of {@link DriftCheckBaselinesProperty#getBias}
             * @param bias Represents the drift check bias baselines that can be used when the model monitor is set using the model package.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bias(software.amazon.awscdk.services.sagemaker.CfnModelPackage.DriftCheckBiasProperty bias) {
                this.bias = bias;
                return this;
            }

            /**
             * Sets the value of {@link DriftCheckBaselinesProperty#getExplainability}
             * @param explainability Represents the drift check explainability baselines that can be used when the model monitor is set using the model package.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder explainability(software.amazon.awscdk.core.IResolvable explainability) {
                this.explainability = explainability;
                return this;
            }

            /**
             * Sets the value of {@link DriftCheckBaselinesProperty#getExplainability}
             * @param explainability Represents the drift check explainability baselines that can be used when the model monitor is set using the model package.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder explainability(software.amazon.awscdk.services.sagemaker.CfnModelPackage.DriftCheckExplainabilityProperty explainability) {
                this.explainability = explainability;
                return this;
            }

            /**
             * Sets the value of {@link DriftCheckBaselinesProperty#getModelDataQuality}
             * @param modelDataQuality Represents the drift check model data quality baselines that can be used when the model monitor is set using the model package.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelDataQuality(software.amazon.awscdk.core.IResolvable modelDataQuality) {
                this.modelDataQuality = modelDataQuality;
                return this;
            }

            /**
             * Sets the value of {@link DriftCheckBaselinesProperty#getModelDataQuality}
             * @param modelDataQuality Represents the drift check model data quality baselines that can be used when the model monitor is set using the model package.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelDataQuality(software.amazon.awscdk.services.sagemaker.CfnModelPackage.DriftCheckModelDataQualityProperty modelDataQuality) {
                this.modelDataQuality = modelDataQuality;
                return this;
            }

            /**
             * Sets the value of {@link DriftCheckBaselinesProperty#getModelQuality}
             * @param modelQuality Represents the drift check model quality baselines that can be used when the model monitor is set using the model package.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelQuality(software.amazon.awscdk.core.IResolvable modelQuality) {
                this.modelQuality = modelQuality;
                return this;
            }

            /**
             * Sets the value of {@link DriftCheckBaselinesProperty#getModelQuality}
             * @param modelQuality Represents the drift check model quality baselines that can be used when the model monitor is set using the model package.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelQuality(software.amazon.awscdk.services.sagemaker.CfnModelPackage.DriftCheckModelQualityProperty modelQuality) {
                this.modelQuality = modelQuality;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DriftCheckBaselinesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DriftCheckBaselinesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DriftCheckBaselinesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DriftCheckBaselinesProperty {
            private final java.lang.Object bias;
            private final java.lang.Object explainability;
            private final java.lang.Object modelDataQuality;
            private final java.lang.Object modelQuality;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bias = software.amazon.jsii.Kernel.get(this, "bias", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.explainability = software.amazon.jsii.Kernel.get(this, "explainability", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.modelDataQuality = software.amazon.jsii.Kernel.get(this, "modelDataQuality", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.modelQuality = software.amazon.jsii.Kernel.get(this, "modelQuality", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bias = builder.bias;
                this.explainability = builder.explainability;
                this.modelDataQuality = builder.modelDataQuality;
                this.modelQuality = builder.modelQuality;
            }

            @Override
            public final java.lang.Object getBias() {
                return this.bias;
            }

            @Override
            public final java.lang.Object getExplainability() {
                return this.explainability;
            }

            @Override
            public final java.lang.Object getModelDataQuality() {
                return this.modelDataQuality;
            }

            @Override
            public final java.lang.Object getModelQuality() {
                return this.modelQuality;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBias() != null) {
                    data.set("bias", om.valueToTree(this.getBias()));
                }
                if (this.getExplainability() != null) {
                    data.set("explainability", om.valueToTree(this.getExplainability()));
                }
                if (this.getModelDataQuality() != null) {
                    data.set("modelDataQuality", om.valueToTree(this.getModelDataQuality()));
                }
                if (this.getModelQuality() != null) {
                    data.set("modelQuality", om.valueToTree(this.getModelQuality()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.DriftCheckBaselinesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DriftCheckBaselinesProperty.Jsii$Proxy that = (DriftCheckBaselinesProperty.Jsii$Proxy) o;

                if (this.bias != null ? !this.bias.equals(that.bias) : that.bias != null) return false;
                if (this.explainability != null ? !this.explainability.equals(that.explainability) : that.explainability != null) return false;
                if (this.modelDataQuality != null ? !this.modelDataQuality.equals(that.modelDataQuality) : that.modelDataQuality != null) return false;
                return this.modelQuality != null ? this.modelQuality.equals(that.modelQuality) : that.modelQuality == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bias != null ? this.bias.hashCode() : 0;
                result = 31 * result + (this.explainability != null ? this.explainability.hashCode() : 0);
                result = 31 * result + (this.modelDataQuality != null ? this.modelDataQuality.hashCode() : 0);
                result = 31 * result + (this.modelQuality != null ? this.modelQuality.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents the drift check bias baselines that can be used when the model monitor is set using the model package.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DriftCheckBiasProperty driftCheckBiasProperty = DriftCheckBiasProperty.builder()
     *         .configFile(FileSourceProperty.builder()
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .contentDigest("contentDigest")
     *                 .contentType("contentType")
     *                 .build())
     *         .postTrainingConstraints(MetricsSourceProperty.builder()
     *                 .contentType("contentType")
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .contentDigest("contentDigest")
     *                 .build())
     *         .preTrainingConstraints(MetricsSourceProperty.builder()
     *                 .contentType("contentType")
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .contentDigest("contentDigest")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.DriftCheckBiasProperty")
    @software.amazon.jsii.Jsii.Proxy(DriftCheckBiasProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DriftCheckBiasProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The bias config file for a model.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfigFile() {
            return null;
        }

        /**
         * `CfnModelPackage.DriftCheckBiasProperty.PostTrainingConstraints`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPostTrainingConstraints() {
            return null;
        }

        /**
         * `CfnModelPackage.DriftCheckBiasProperty.PreTrainingConstraints`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPreTrainingConstraints() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DriftCheckBiasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DriftCheckBiasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DriftCheckBiasProperty> {
            java.lang.Object configFile;
            java.lang.Object postTrainingConstraints;
            java.lang.Object preTrainingConstraints;

            /**
             * Sets the value of {@link DriftCheckBiasProperty#getConfigFile}
             * @param configFile The bias config file for a model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configFile(software.amazon.awscdk.core.IResolvable configFile) {
                this.configFile = configFile;
                return this;
            }

            /**
             * Sets the value of {@link DriftCheckBiasProperty#getConfigFile}
             * @param configFile The bias config file for a model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configFile(software.amazon.awscdk.services.sagemaker.CfnModelPackage.FileSourceProperty configFile) {
                this.configFile = configFile;
                return this;
            }

            /**
             * Sets the value of {@link DriftCheckBiasProperty#getPostTrainingConstraints}
             * @param postTrainingConstraints `CfnModelPackage.DriftCheckBiasProperty.PostTrainingConstraints`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postTrainingConstraints(software.amazon.awscdk.core.IResolvable postTrainingConstraints) {
                this.postTrainingConstraints = postTrainingConstraints;
                return this;
            }

            /**
             * Sets the value of {@link DriftCheckBiasProperty#getPostTrainingConstraints}
             * @param postTrainingConstraints `CfnModelPackage.DriftCheckBiasProperty.PostTrainingConstraints`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postTrainingConstraints(software.amazon.awscdk.services.sagemaker.CfnModelPackage.MetricsSourceProperty postTrainingConstraints) {
                this.postTrainingConstraints = postTrainingConstraints;
                return this;
            }

            /**
             * Sets the value of {@link DriftCheckBiasProperty#getPreTrainingConstraints}
             * @param preTrainingConstraints `CfnModelPackage.DriftCheckBiasProperty.PreTrainingConstraints`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preTrainingConstraints(software.amazon.awscdk.core.IResolvable preTrainingConstraints) {
                this.preTrainingConstraints = preTrainingConstraints;
                return this;
            }

            /**
             * Sets the value of {@link DriftCheckBiasProperty#getPreTrainingConstraints}
             * @param preTrainingConstraints `CfnModelPackage.DriftCheckBiasProperty.PreTrainingConstraints`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preTrainingConstraints(software.amazon.awscdk.services.sagemaker.CfnModelPackage.MetricsSourceProperty preTrainingConstraints) {
                this.preTrainingConstraints = preTrainingConstraints;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DriftCheckBiasProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DriftCheckBiasProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DriftCheckBiasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DriftCheckBiasProperty {
            private final java.lang.Object configFile;
            private final java.lang.Object postTrainingConstraints;
            private final java.lang.Object preTrainingConstraints;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configFile = software.amazon.jsii.Kernel.get(this, "configFile", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.postTrainingConstraints = software.amazon.jsii.Kernel.get(this, "postTrainingConstraints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.preTrainingConstraints = software.amazon.jsii.Kernel.get(this, "preTrainingConstraints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configFile = builder.configFile;
                this.postTrainingConstraints = builder.postTrainingConstraints;
                this.preTrainingConstraints = builder.preTrainingConstraints;
            }

            @Override
            public final java.lang.Object getConfigFile() {
                return this.configFile;
            }

            @Override
            public final java.lang.Object getPostTrainingConstraints() {
                return this.postTrainingConstraints;
            }

            @Override
            public final java.lang.Object getPreTrainingConstraints() {
                return this.preTrainingConstraints;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConfigFile() != null) {
                    data.set("configFile", om.valueToTree(this.getConfigFile()));
                }
                if (this.getPostTrainingConstraints() != null) {
                    data.set("postTrainingConstraints", om.valueToTree(this.getPostTrainingConstraints()));
                }
                if (this.getPreTrainingConstraints() != null) {
                    data.set("preTrainingConstraints", om.valueToTree(this.getPreTrainingConstraints()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.DriftCheckBiasProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DriftCheckBiasProperty.Jsii$Proxy that = (DriftCheckBiasProperty.Jsii$Proxy) o;

                if (this.configFile != null ? !this.configFile.equals(that.configFile) : that.configFile != null) return false;
                if (this.postTrainingConstraints != null ? !this.postTrainingConstraints.equals(that.postTrainingConstraints) : that.postTrainingConstraints != null) return false;
                return this.preTrainingConstraints != null ? this.preTrainingConstraints.equals(that.preTrainingConstraints) : that.preTrainingConstraints == null;
            }

            @Override
            public final int hashCode() {
                int result = this.configFile != null ? this.configFile.hashCode() : 0;
                result = 31 * result + (this.postTrainingConstraints != null ? this.postTrainingConstraints.hashCode() : 0);
                result = 31 * result + (this.preTrainingConstraints != null ? this.preTrainingConstraints.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents the drift check explainability baselines that can be used when the model monitor is set using the model package.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DriftCheckExplainabilityProperty driftCheckExplainabilityProperty = DriftCheckExplainabilityProperty.builder()
     *         .configFile(FileSourceProperty.builder()
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .contentDigest("contentDigest")
     *                 .contentType("contentType")
     *                 .build())
     *         .constraints(MetricsSourceProperty.builder()
     *                 .contentType("contentType")
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .contentDigest("contentDigest")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.DriftCheckExplainabilityProperty")
    @software.amazon.jsii.Jsii.Proxy(DriftCheckExplainabilityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DriftCheckExplainabilityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The explainability config file for the model.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfigFile() {
            return null;
        }

        /**
         * `CfnModelPackage.DriftCheckExplainabilityProperty.Constraints`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConstraints() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DriftCheckExplainabilityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DriftCheckExplainabilityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DriftCheckExplainabilityProperty> {
            java.lang.Object configFile;
            java.lang.Object constraints;

            /**
             * Sets the value of {@link DriftCheckExplainabilityProperty#getConfigFile}
             * @param configFile The explainability config file for the model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configFile(software.amazon.awscdk.core.IResolvable configFile) {
                this.configFile = configFile;
                return this;
            }

            /**
             * Sets the value of {@link DriftCheckExplainabilityProperty#getConfigFile}
             * @param configFile The explainability config file for the model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configFile(software.amazon.awscdk.services.sagemaker.CfnModelPackage.FileSourceProperty configFile) {
                this.configFile = configFile;
                return this;
            }

            /**
             * Sets the value of {@link DriftCheckExplainabilityProperty#getConstraints}
             * @param constraints `CfnModelPackage.DriftCheckExplainabilityProperty.Constraints`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraints(software.amazon.awscdk.core.IResolvable constraints) {
                this.constraints = constraints;
                return this;
            }

            /**
             * Sets the value of {@link DriftCheckExplainabilityProperty#getConstraints}
             * @param constraints `CfnModelPackage.DriftCheckExplainabilityProperty.Constraints`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraints(software.amazon.awscdk.services.sagemaker.CfnModelPackage.MetricsSourceProperty constraints) {
                this.constraints = constraints;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DriftCheckExplainabilityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DriftCheckExplainabilityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DriftCheckExplainabilityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DriftCheckExplainabilityProperty {
            private final java.lang.Object configFile;
            private final java.lang.Object constraints;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configFile = software.amazon.jsii.Kernel.get(this, "configFile", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.constraints = software.amazon.jsii.Kernel.get(this, "constraints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configFile = builder.configFile;
                this.constraints = builder.constraints;
            }

            @Override
            public final java.lang.Object getConfigFile() {
                return this.configFile;
            }

            @Override
            public final java.lang.Object getConstraints() {
                return this.constraints;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConfigFile() != null) {
                    data.set("configFile", om.valueToTree(this.getConfigFile()));
                }
                if (this.getConstraints() != null) {
                    data.set("constraints", om.valueToTree(this.getConstraints()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.DriftCheckExplainabilityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DriftCheckExplainabilityProperty.Jsii$Proxy that = (DriftCheckExplainabilityProperty.Jsii$Proxy) o;

                if (this.configFile != null ? !this.configFile.equals(that.configFile) : that.configFile != null) return false;
                return this.constraints != null ? this.constraints.equals(that.constraints) : that.constraints == null;
            }

            @Override
            public final int hashCode() {
                int result = this.configFile != null ? this.configFile.hashCode() : 0;
                result = 31 * result + (this.constraints != null ? this.constraints.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents the drift check data quality baselines that can be used when the model monitor is set using the model package.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DriftCheckModelDataQualityProperty driftCheckModelDataQualityProperty = DriftCheckModelDataQualityProperty.builder()
     *         .constraints(MetricsSourceProperty.builder()
     *                 .contentType("contentType")
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .contentDigest("contentDigest")
     *                 .build())
     *         .statistics(MetricsSourceProperty.builder()
     *                 .contentType("contentType")
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .contentDigest("contentDigest")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.DriftCheckModelDataQualityProperty")
    @software.amazon.jsii.Jsii.Proxy(DriftCheckModelDataQualityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DriftCheckModelDataQualityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnModelPackage.DriftCheckModelDataQualityProperty.Constraints`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConstraints() {
            return null;
        }

        /**
         * `CfnModelPackage.DriftCheckModelDataQualityProperty.Statistics`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStatistics() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DriftCheckModelDataQualityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DriftCheckModelDataQualityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DriftCheckModelDataQualityProperty> {
            java.lang.Object constraints;
            java.lang.Object statistics;

            /**
             * Sets the value of {@link DriftCheckModelDataQualityProperty#getConstraints}
             * @param constraints `CfnModelPackage.DriftCheckModelDataQualityProperty.Constraints`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraints(software.amazon.awscdk.core.IResolvable constraints) {
                this.constraints = constraints;
                return this;
            }

            /**
             * Sets the value of {@link DriftCheckModelDataQualityProperty#getConstraints}
             * @param constraints `CfnModelPackage.DriftCheckModelDataQualityProperty.Constraints`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraints(software.amazon.awscdk.services.sagemaker.CfnModelPackage.MetricsSourceProperty constraints) {
                this.constraints = constraints;
                return this;
            }

            /**
             * Sets the value of {@link DriftCheckModelDataQualityProperty#getStatistics}
             * @param statistics `CfnModelPackage.DriftCheckModelDataQualityProperty.Statistics`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistics(software.amazon.awscdk.core.IResolvable statistics) {
                this.statistics = statistics;
                return this;
            }

            /**
             * Sets the value of {@link DriftCheckModelDataQualityProperty#getStatistics}
             * @param statistics `CfnModelPackage.DriftCheckModelDataQualityProperty.Statistics`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistics(software.amazon.awscdk.services.sagemaker.CfnModelPackage.MetricsSourceProperty statistics) {
                this.statistics = statistics;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DriftCheckModelDataQualityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DriftCheckModelDataQualityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DriftCheckModelDataQualityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DriftCheckModelDataQualityProperty {
            private final java.lang.Object constraints;
            private final java.lang.Object statistics;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.constraints = software.amazon.jsii.Kernel.get(this, "constraints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.statistics = software.amazon.jsii.Kernel.get(this, "statistics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.constraints = builder.constraints;
                this.statistics = builder.statistics;
            }

            @Override
            public final java.lang.Object getConstraints() {
                return this.constraints;
            }

            @Override
            public final java.lang.Object getStatistics() {
                return this.statistics;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConstraints() != null) {
                    data.set("constraints", om.valueToTree(this.getConstraints()));
                }
                if (this.getStatistics() != null) {
                    data.set("statistics", om.valueToTree(this.getStatistics()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.DriftCheckModelDataQualityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DriftCheckModelDataQualityProperty.Jsii$Proxy that = (DriftCheckModelDataQualityProperty.Jsii$Proxy) o;

                if (this.constraints != null ? !this.constraints.equals(that.constraints) : that.constraints != null) return false;
                return this.statistics != null ? this.statistics.equals(that.statistics) : that.statistics == null;
            }

            @Override
            public final int hashCode() {
                int result = this.constraints != null ? this.constraints.hashCode() : 0;
                result = 31 * result + (this.statistics != null ? this.statistics.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents the drift check model quality baselines that can be used when the model monitor is set using the model package.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DriftCheckModelQualityProperty driftCheckModelQualityProperty = DriftCheckModelQualityProperty.builder()
     *         .constraints(MetricsSourceProperty.builder()
     *                 .contentType("contentType")
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .contentDigest("contentDigest")
     *                 .build())
     *         .statistics(MetricsSourceProperty.builder()
     *                 .contentType("contentType")
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .contentDigest("contentDigest")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.DriftCheckModelQualityProperty")
    @software.amazon.jsii.Jsii.Proxy(DriftCheckModelQualityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DriftCheckModelQualityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnModelPackage.DriftCheckModelQualityProperty.Constraints`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConstraints() {
            return null;
        }

        /**
         * `CfnModelPackage.DriftCheckModelQualityProperty.Statistics`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStatistics() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DriftCheckModelQualityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DriftCheckModelQualityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DriftCheckModelQualityProperty> {
            java.lang.Object constraints;
            java.lang.Object statistics;

            /**
             * Sets the value of {@link DriftCheckModelQualityProperty#getConstraints}
             * @param constraints `CfnModelPackage.DriftCheckModelQualityProperty.Constraints`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraints(software.amazon.awscdk.core.IResolvable constraints) {
                this.constraints = constraints;
                return this;
            }

            /**
             * Sets the value of {@link DriftCheckModelQualityProperty#getConstraints}
             * @param constraints `CfnModelPackage.DriftCheckModelQualityProperty.Constraints`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraints(software.amazon.awscdk.services.sagemaker.CfnModelPackage.MetricsSourceProperty constraints) {
                this.constraints = constraints;
                return this;
            }

            /**
             * Sets the value of {@link DriftCheckModelQualityProperty#getStatistics}
             * @param statistics `CfnModelPackage.DriftCheckModelQualityProperty.Statistics`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistics(software.amazon.awscdk.core.IResolvable statistics) {
                this.statistics = statistics;
                return this;
            }

            /**
             * Sets the value of {@link DriftCheckModelQualityProperty#getStatistics}
             * @param statistics `CfnModelPackage.DriftCheckModelQualityProperty.Statistics`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistics(software.amazon.awscdk.services.sagemaker.CfnModelPackage.MetricsSourceProperty statistics) {
                this.statistics = statistics;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DriftCheckModelQualityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DriftCheckModelQualityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DriftCheckModelQualityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DriftCheckModelQualityProperty {
            private final java.lang.Object constraints;
            private final java.lang.Object statistics;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.constraints = software.amazon.jsii.Kernel.get(this, "constraints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.statistics = software.amazon.jsii.Kernel.get(this, "statistics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.constraints = builder.constraints;
                this.statistics = builder.statistics;
            }

            @Override
            public final java.lang.Object getConstraints() {
                return this.constraints;
            }

            @Override
            public final java.lang.Object getStatistics() {
                return this.statistics;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConstraints() != null) {
                    data.set("constraints", om.valueToTree(this.getConstraints()));
                }
                if (this.getStatistics() != null) {
                    data.set("statistics", om.valueToTree(this.getStatistics()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.DriftCheckModelQualityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DriftCheckModelQualityProperty.Jsii$Proxy that = (DriftCheckModelQualityProperty.Jsii$Proxy) o;

                if (this.constraints != null ? !this.constraints.equals(that.constraints) : that.constraints != null) return false;
                return this.statistics != null ? this.statistics.equals(that.statistics) : that.statistics == null;
            }

            @Override
            public final int hashCode() {
                int result = this.constraints != null ? this.constraints.hashCode() : 0;
                result = 31 * result + (this.statistics != null ? this.statistics.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains explainability metrics for a model.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ExplainabilityProperty explainabilityProperty = ExplainabilityProperty.builder()
     *         .report(MetricsSourceProperty.builder()
     *                 .contentType("contentType")
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .contentDigest("contentDigest")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.ExplainabilityProperty")
    @software.amazon.jsii.Jsii.Proxy(ExplainabilityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExplainabilityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The explainability report for a model.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReport() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExplainabilityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExplainabilityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExplainabilityProperty> {
            java.lang.Object report;

            /**
             * Sets the value of {@link ExplainabilityProperty#getReport}
             * @param report The explainability report for a model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder report(software.amazon.awscdk.core.IResolvable report) {
                this.report = report;
                return this;
            }

            /**
             * Sets the value of {@link ExplainabilityProperty#getReport}
             * @param report The explainability report for a model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder report(software.amazon.awscdk.services.sagemaker.CfnModelPackage.MetricsSourceProperty report) {
                this.report = report;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExplainabilityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExplainabilityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExplainabilityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExplainabilityProperty {
            private final java.lang.Object report;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.report = software.amazon.jsii.Kernel.get(this, "report", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.report = builder.report;
            }

            @Override
            public final java.lang.Object getReport() {
                return this.report;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReport() != null) {
                    data.set("report", om.valueToTree(this.getReport()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.ExplainabilityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExplainabilityProperty.Jsii$Proxy that = (ExplainabilityProperty.Jsii$Proxy) o;

                return this.report != null ? this.report.equals(that.report) : that.report == null;
            }

            @Override
            public final int hashCode() {
                int result = this.report != null ? this.report.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains details regarding the file source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * FileSourceProperty fileSourceProperty = FileSourceProperty.builder()
     *         .s3Uri("s3Uri")
     *         // the properties below are optional
     *         .contentDigest("contentDigest")
     *         .contentType("contentType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.FileSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(FileSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FileSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 URI for the file source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Uri();

        /**
         * The digest of the file source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContentDigest() {
            return null;
        }

        /**
         * The type of content stored in the file source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContentType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FileSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FileSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FileSourceProperty> {
            java.lang.String s3Uri;
            java.lang.String contentDigest;
            java.lang.String contentType;

            /**
             * Sets the value of {@link FileSourceProperty#getS3Uri}
             * @param s3Uri The Amazon S3 URI for the file source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Sets the value of {@link FileSourceProperty#getContentDigest}
             * @param contentDigest The digest of the file source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentDigest(java.lang.String contentDigest) {
                this.contentDigest = contentDigest;
                return this;
            }

            /**
             * Sets the value of {@link FileSourceProperty#getContentType}
             * @param contentType The type of content stored in the file source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentType(java.lang.String contentType) {
                this.contentType = contentType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FileSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FileSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FileSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileSourceProperty {
            private final java.lang.String s3Uri;
            private final java.lang.String contentDigest;
            private final java.lang.String contentType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.contentDigest = software.amazon.jsii.Kernel.get(this, "contentDigest", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.contentType = software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Uri = java.util.Objects.requireNonNull(builder.s3Uri, "s3Uri is required");
                this.contentDigest = builder.contentDigest;
                this.contentType = builder.contentType;
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            public final java.lang.String getContentDigest() {
                return this.contentDigest;
            }

            @Override
            public final java.lang.String getContentType() {
                return this.contentType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Uri", om.valueToTree(this.getS3Uri()));
                if (this.getContentDigest() != null) {
                    data.set("contentDigest", om.valueToTree(this.getContentDigest()));
                }
                if (this.getContentType() != null) {
                    data.set("contentType", om.valueToTree(this.getContentType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.FileSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FileSourceProperty.Jsii$Proxy that = (FileSourceProperty.Jsii$Proxy) o;

                if (!s3Uri.equals(that.s3Uri)) return false;
                if (this.contentDigest != null ? !this.contentDigest.equals(that.contentDigest) : that.contentDigest != null) return false;
                return this.contentType != null ? this.contentType.equals(that.contentType) : that.contentType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Uri.hashCode();
                result = 31 * result + (this.contentDigest != null ? this.contentDigest.hashCode() : 0);
                result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines how to perform inference generation after a training job is run.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * Object environment;
     * Object modelInput;
     * InferenceSpecificationProperty inferenceSpecificationProperty = InferenceSpecificationProperty.builder()
     *         .containers(List.of(ModelPackageContainerDefinitionProperty.builder()
     *                 .image("image")
     *                 // the properties below are optional
     *                 .containerHostname("containerHostname")
     *                 .environment(environment)
     *                 .framework("framework")
     *                 .frameworkVersion("frameworkVersion")
     *                 .imageDigest("imageDigest")
     *                 .modelDataUrl("modelDataUrl")
     *                 .modelInput(modelInput)
     *                 .nearestModelName("nearestModelName")
     *                 .productId("productId")
     *                 .build()))
     *         .supportedContentTypes(List.of("supportedContentTypes"))
     *         .supportedResponseMimeTypes(List.of("supportedResponseMimeTypes"))
     *         // the properties below are optional
     *         .supportedRealtimeInferenceInstanceTypes(List.of("supportedRealtimeInferenceInstanceTypes"))
     *         .supportedTransformInstanceTypes(List.of("supportedTransformInstanceTypes"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.InferenceSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(InferenceSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InferenceSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon ECR registry path of the Docker image that contains the inference code.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getContainers();

        /**
         * The supported MIME types for the input data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSupportedContentTypes();

        /**
         * The supported MIME types for the output data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSupportedResponseMimeTypes();

        /**
         * A list of the instance types that are used to generate inferences in real-time.
         * <p>
         * This parameter is required for unversioned models, and optional for versioned models.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSupportedRealtimeInferenceInstanceTypes() {
            return null;
        }

        /**
         * A list of the instance types on which a transformation job can be run or on which an endpoint can be deployed.
         * <p>
         * This parameter is required for unversioned models, and optional for versioned models.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSupportedTransformInstanceTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InferenceSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InferenceSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InferenceSpecificationProperty> {
            java.lang.Object containers;
            java.util.List<java.lang.String> supportedContentTypes;
            java.util.List<java.lang.String> supportedResponseMimeTypes;
            java.util.List<java.lang.String> supportedRealtimeInferenceInstanceTypes;
            java.util.List<java.lang.String> supportedTransformInstanceTypes;

            /**
             * Sets the value of {@link InferenceSpecificationProperty#getContainers}
             * @param containers The Amazon ECR registry path of the Docker image that contains the inference code. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containers(software.amazon.awscdk.core.IResolvable containers) {
                this.containers = containers;
                return this;
            }

            /**
             * Sets the value of {@link InferenceSpecificationProperty#getContainers}
             * @param containers The Amazon ECR registry path of the Docker image that contains the inference code. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containers(java.util.List<? extends java.lang.Object> containers) {
                this.containers = containers;
                return this;
            }

            /**
             * Sets the value of {@link InferenceSpecificationProperty#getSupportedContentTypes}
             * @param supportedContentTypes The supported MIME types for the input data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supportedContentTypes(java.util.List<java.lang.String> supportedContentTypes) {
                this.supportedContentTypes = supportedContentTypes;
                return this;
            }

            /**
             * Sets the value of {@link InferenceSpecificationProperty#getSupportedResponseMimeTypes}
             * @param supportedResponseMimeTypes The supported MIME types for the output data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supportedResponseMimeTypes(java.util.List<java.lang.String> supportedResponseMimeTypes) {
                this.supportedResponseMimeTypes = supportedResponseMimeTypes;
                return this;
            }

            /**
             * Sets the value of {@link InferenceSpecificationProperty#getSupportedRealtimeInferenceInstanceTypes}
             * @param supportedRealtimeInferenceInstanceTypes A list of the instance types that are used to generate inferences in real-time.
             *                                                This parameter is required for unversioned models, and optional for versioned models.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supportedRealtimeInferenceInstanceTypes(java.util.List<java.lang.String> supportedRealtimeInferenceInstanceTypes) {
                this.supportedRealtimeInferenceInstanceTypes = supportedRealtimeInferenceInstanceTypes;
                return this;
            }

            /**
             * Sets the value of {@link InferenceSpecificationProperty#getSupportedTransformInstanceTypes}
             * @param supportedTransformInstanceTypes A list of the instance types on which a transformation job can be run or on which an endpoint can be deployed.
             *                                        This parameter is required for unversioned models, and optional for versioned models.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supportedTransformInstanceTypes(java.util.List<java.lang.String> supportedTransformInstanceTypes) {
                this.supportedTransformInstanceTypes = supportedTransformInstanceTypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InferenceSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InferenceSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InferenceSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InferenceSpecificationProperty {
            private final java.lang.Object containers;
            private final java.util.List<java.lang.String> supportedContentTypes;
            private final java.util.List<java.lang.String> supportedResponseMimeTypes;
            private final java.util.List<java.lang.String> supportedRealtimeInferenceInstanceTypes;
            private final java.util.List<java.lang.String> supportedTransformInstanceTypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containers = software.amazon.jsii.Kernel.get(this, "containers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.supportedContentTypes = software.amazon.jsii.Kernel.get(this, "supportedContentTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.supportedResponseMimeTypes = software.amazon.jsii.Kernel.get(this, "supportedResponseMimeTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.supportedRealtimeInferenceInstanceTypes = software.amazon.jsii.Kernel.get(this, "supportedRealtimeInferenceInstanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.supportedTransformInstanceTypes = software.amazon.jsii.Kernel.get(this, "supportedTransformInstanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containers = java.util.Objects.requireNonNull(builder.containers, "containers is required");
                this.supportedContentTypes = java.util.Objects.requireNonNull(builder.supportedContentTypes, "supportedContentTypes is required");
                this.supportedResponseMimeTypes = java.util.Objects.requireNonNull(builder.supportedResponseMimeTypes, "supportedResponseMimeTypes is required");
                this.supportedRealtimeInferenceInstanceTypes = builder.supportedRealtimeInferenceInstanceTypes;
                this.supportedTransformInstanceTypes = builder.supportedTransformInstanceTypes;
            }

            @Override
            public final java.lang.Object getContainers() {
                return this.containers;
            }

            @Override
            public final java.util.List<java.lang.String> getSupportedContentTypes() {
                return this.supportedContentTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getSupportedResponseMimeTypes() {
                return this.supportedResponseMimeTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getSupportedRealtimeInferenceInstanceTypes() {
                return this.supportedRealtimeInferenceInstanceTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getSupportedTransformInstanceTypes() {
                return this.supportedTransformInstanceTypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("containers", om.valueToTree(this.getContainers()));
                data.set("supportedContentTypes", om.valueToTree(this.getSupportedContentTypes()));
                data.set("supportedResponseMimeTypes", om.valueToTree(this.getSupportedResponseMimeTypes()));
                if (this.getSupportedRealtimeInferenceInstanceTypes() != null) {
                    data.set("supportedRealtimeInferenceInstanceTypes", om.valueToTree(this.getSupportedRealtimeInferenceInstanceTypes()));
                }
                if (this.getSupportedTransformInstanceTypes() != null) {
                    data.set("supportedTransformInstanceTypes", om.valueToTree(this.getSupportedTransformInstanceTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.InferenceSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InferenceSpecificationProperty.Jsii$Proxy that = (InferenceSpecificationProperty.Jsii$Proxy) o;

                if (!containers.equals(that.containers)) return false;
                if (!supportedContentTypes.equals(that.supportedContentTypes)) return false;
                if (!supportedResponseMimeTypes.equals(that.supportedResponseMimeTypes)) return false;
                if (this.supportedRealtimeInferenceInstanceTypes != null ? !this.supportedRealtimeInferenceInstanceTypes.equals(that.supportedRealtimeInferenceInstanceTypes) : that.supportedRealtimeInferenceInstanceTypes != null) return false;
                return this.supportedTransformInstanceTypes != null ? this.supportedTransformInstanceTypes.equals(that.supportedTransformInstanceTypes) : that.supportedTransformInstanceTypes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containers.hashCode();
                result = 31 * result + (this.supportedContentTypes.hashCode());
                result = 31 * result + (this.supportedResponseMimeTypes.hashCode());
                result = 31 * result + (this.supportedRealtimeInferenceInstanceTypes != null ? this.supportedRealtimeInferenceInstanceTypes.hashCode() : 0);
                result = 31 * result + (this.supportedTransformInstanceTypes != null ? this.supportedTransformInstanceTypes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Metadata properties of the tracking entity, trial, or trial component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * MetadataPropertiesProperty metadataPropertiesProperty = MetadataPropertiesProperty.builder()
     *         .commitId("commitId")
     *         .generatedBy("generatedBy")
     *         .projectId("projectId")
     *         .repository("repository")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.MetadataPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(MetadataPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetadataPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The commit ID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCommitId() {
            return null;
        }

        /**
         * The entity this entity was generated by.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGeneratedBy() {
            return null;
        }

        /**
         * The project ID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProjectId() {
            return null;
        }

        /**
         * The repository.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRepository() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetadataPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetadataPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetadataPropertiesProperty> {
            java.lang.String commitId;
            java.lang.String generatedBy;
            java.lang.String projectId;
            java.lang.String repository;

            /**
             * Sets the value of {@link MetadataPropertiesProperty#getCommitId}
             * @param commitId The commit ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder commitId(java.lang.String commitId) {
                this.commitId = commitId;
                return this;
            }

            /**
             * Sets the value of {@link MetadataPropertiesProperty#getGeneratedBy}
             * @param generatedBy The entity this entity was generated by.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generatedBy(java.lang.String generatedBy) {
                this.generatedBy = generatedBy;
                return this;
            }

            /**
             * Sets the value of {@link MetadataPropertiesProperty#getProjectId}
             * @param projectId The project ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projectId(java.lang.String projectId) {
                this.projectId = projectId;
                return this;
            }

            /**
             * Sets the value of {@link MetadataPropertiesProperty#getRepository}
             * @param repository The repository.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repository(java.lang.String repository) {
                this.repository = repository;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetadataPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetadataPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetadataPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetadataPropertiesProperty {
            private final java.lang.String commitId;
            private final java.lang.String generatedBy;
            private final java.lang.String projectId;
            private final java.lang.String repository;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.commitId = software.amazon.jsii.Kernel.get(this, "commitId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.generatedBy = software.amazon.jsii.Kernel.get(this, "generatedBy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.projectId = software.amazon.jsii.Kernel.get(this, "projectId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.repository = software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.commitId = builder.commitId;
                this.generatedBy = builder.generatedBy;
                this.projectId = builder.projectId;
                this.repository = builder.repository;
            }

            @Override
            public final java.lang.String getCommitId() {
                return this.commitId;
            }

            @Override
            public final java.lang.String getGeneratedBy() {
                return this.generatedBy;
            }

            @Override
            public final java.lang.String getProjectId() {
                return this.projectId;
            }

            @Override
            public final java.lang.String getRepository() {
                return this.repository;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCommitId() != null) {
                    data.set("commitId", om.valueToTree(this.getCommitId()));
                }
                if (this.getGeneratedBy() != null) {
                    data.set("generatedBy", om.valueToTree(this.getGeneratedBy()));
                }
                if (this.getProjectId() != null) {
                    data.set("projectId", om.valueToTree(this.getProjectId()));
                }
                if (this.getRepository() != null) {
                    data.set("repository", om.valueToTree(this.getRepository()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.MetadataPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetadataPropertiesProperty.Jsii$Proxy that = (MetadataPropertiesProperty.Jsii$Proxy) o;

                if (this.commitId != null ? !this.commitId.equals(that.commitId) : that.commitId != null) return false;
                if (this.generatedBy != null ? !this.generatedBy.equals(that.generatedBy) : that.generatedBy != null) return false;
                if (this.projectId != null ? !this.projectId.equals(that.projectId) : that.projectId != null) return false;
                return this.repository != null ? this.repository.equals(that.repository) : that.repository == null;
            }

            @Override
            public final int hashCode() {
                int result = this.commitId != null ? this.commitId.hashCode() : 0;
                result = 31 * result + (this.generatedBy != null ? this.generatedBy.hashCode() : 0);
                result = 31 * result + (this.projectId != null ? this.projectId.hashCode() : 0);
                result = 31 * result + (this.repository != null ? this.repository.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * MetricsSourceProperty metricsSourceProperty = MetricsSourceProperty.builder()
     *         .contentType("contentType")
     *         .s3Uri("s3Uri")
     *         // the properties below are optional
     *         .contentDigest("contentDigest")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.MetricsSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricsSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricsSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnModelPackage.MetricsSourceProperty.ContentType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContentType();

        /**
         * `CfnModelPackage.MetricsSourceProperty.S3Uri`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Uri();

        /**
         * `CfnModelPackage.MetricsSourceProperty.ContentDigest`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContentDigest() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricsSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricsSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricsSourceProperty> {
            java.lang.String contentType;
            java.lang.String s3Uri;
            java.lang.String contentDigest;

            /**
             * Sets the value of {@link MetricsSourceProperty#getContentType}
             * @param contentType `CfnModelPackage.MetricsSourceProperty.ContentType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentType(java.lang.String contentType) {
                this.contentType = contentType;
                return this;
            }

            /**
             * Sets the value of {@link MetricsSourceProperty#getS3Uri}
             * @param s3Uri `CfnModelPackage.MetricsSourceProperty.S3Uri`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Sets the value of {@link MetricsSourceProperty#getContentDigest}
             * @param contentDigest `CfnModelPackage.MetricsSourceProperty.ContentDigest`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentDigest(java.lang.String contentDigest) {
                this.contentDigest = contentDigest;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricsSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricsSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricsSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricsSourceProperty {
            private final java.lang.String contentType;
            private final java.lang.String s3Uri;
            private final java.lang.String contentDigest;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.contentType = software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.contentDigest = software.amazon.jsii.Kernel.get(this, "contentDigest", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.contentType = java.util.Objects.requireNonNull(builder.contentType, "contentType is required");
                this.s3Uri = java.util.Objects.requireNonNull(builder.s3Uri, "s3Uri is required");
                this.contentDigest = builder.contentDigest;
            }

            @Override
            public final java.lang.String getContentType() {
                return this.contentType;
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            public final java.lang.String getContentDigest() {
                return this.contentDigest;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("contentType", om.valueToTree(this.getContentType()));
                data.set("s3Uri", om.valueToTree(this.getS3Uri()));
                if (this.getContentDigest() != null) {
                    data.set("contentDigest", om.valueToTree(this.getContentDigest()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.MetricsSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricsSourceProperty.Jsii$Proxy that = (MetricsSourceProperty.Jsii$Proxy) o;

                if (!contentType.equals(that.contentType)) return false;
                if (!s3Uri.equals(that.s3Uri)) return false;
                return this.contentDigest != null ? this.contentDigest.equals(that.contentDigest) : that.contentDigest == null;
            }

            @Override
            public final int hashCode() {
                int result = this.contentType.hashCode();
                result = 31 * result + (this.s3Uri.hashCode());
                result = 31 * result + (this.contentDigest != null ? this.contentDigest.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Data quality constraints and statistics for a model.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ModelDataQualityProperty modelDataQualityProperty = ModelDataQualityProperty.builder()
     *         .constraints(MetricsSourceProperty.builder()
     *                 .contentType("contentType")
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .contentDigest("contentDigest")
     *                 .build())
     *         .statistics(MetricsSourceProperty.builder()
     *                 .contentType("contentType")
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .contentDigest("contentDigest")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.ModelDataQualityProperty")
    @software.amazon.jsii.Jsii.Proxy(ModelDataQualityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ModelDataQualityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Data quality constraints for a model.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConstraints() {
            return null;
        }

        /**
         * Data quality statistics for a model.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStatistics() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ModelDataQualityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ModelDataQualityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ModelDataQualityProperty> {
            java.lang.Object constraints;
            java.lang.Object statistics;

            /**
             * Sets the value of {@link ModelDataQualityProperty#getConstraints}
             * @param constraints Data quality constraints for a model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraints(software.amazon.awscdk.core.IResolvable constraints) {
                this.constraints = constraints;
                return this;
            }

            /**
             * Sets the value of {@link ModelDataQualityProperty#getConstraints}
             * @param constraints Data quality constraints for a model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraints(software.amazon.awscdk.services.sagemaker.CfnModelPackage.MetricsSourceProperty constraints) {
                this.constraints = constraints;
                return this;
            }

            /**
             * Sets the value of {@link ModelDataQualityProperty#getStatistics}
             * @param statistics Data quality statistics for a model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistics(software.amazon.awscdk.core.IResolvable statistics) {
                this.statistics = statistics;
                return this;
            }

            /**
             * Sets the value of {@link ModelDataQualityProperty#getStatistics}
             * @param statistics Data quality statistics for a model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistics(software.amazon.awscdk.services.sagemaker.CfnModelPackage.MetricsSourceProperty statistics) {
                this.statistics = statistics;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ModelDataQualityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ModelDataQualityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ModelDataQualityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModelDataQualityProperty {
            private final java.lang.Object constraints;
            private final java.lang.Object statistics;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.constraints = software.amazon.jsii.Kernel.get(this, "constraints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.statistics = software.amazon.jsii.Kernel.get(this, "statistics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.constraints = builder.constraints;
                this.statistics = builder.statistics;
            }

            @Override
            public final java.lang.Object getConstraints() {
                return this.constraints;
            }

            @Override
            public final java.lang.Object getStatistics() {
                return this.statistics;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConstraints() != null) {
                    data.set("constraints", om.valueToTree(this.getConstraints()));
                }
                if (this.getStatistics() != null) {
                    data.set("statistics", om.valueToTree(this.getStatistics()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.ModelDataQualityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ModelDataQualityProperty.Jsii$Proxy that = (ModelDataQualityProperty.Jsii$Proxy) o;

                if (this.constraints != null ? !this.constraints.equals(that.constraints) : that.constraints != null) return false;
                return this.statistics != null ? this.statistics.equals(that.statistics) : that.statistics == null;
            }

            @Override
            public final int hashCode() {
                int result = this.constraints != null ? this.constraints.hashCode() : 0;
                result = 31 * result + (this.statistics != null ? this.statistics.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains metrics captured from a model.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ModelMetricsProperty modelMetricsProperty = ModelMetricsProperty.builder()
     *         .bias(BiasProperty.builder()
     *                 .postTrainingReport(MetricsSourceProperty.builder()
     *                         .contentType("contentType")
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .contentDigest("contentDigest")
     *                         .build())
     *                 .preTrainingReport(MetricsSourceProperty.builder()
     *                         .contentType("contentType")
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .contentDigest("contentDigest")
     *                         .build())
     *                 .report(MetricsSourceProperty.builder()
     *                         .contentType("contentType")
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .contentDigest("contentDigest")
     *                         .build())
     *                 .build())
     *         .explainability(ExplainabilityProperty.builder()
     *                 .report(MetricsSourceProperty.builder()
     *                         .contentType("contentType")
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .contentDigest("contentDigest")
     *                         .build())
     *                 .build())
     *         .modelDataQuality(ModelDataQualityProperty.builder()
     *                 .constraints(MetricsSourceProperty.builder()
     *                         .contentType("contentType")
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .contentDigest("contentDigest")
     *                         .build())
     *                 .statistics(MetricsSourceProperty.builder()
     *                         .contentType("contentType")
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .contentDigest("contentDigest")
     *                         .build())
     *                 .build())
     *         .modelQuality(ModelQualityProperty.builder()
     *                 .constraints(MetricsSourceProperty.builder()
     *                         .contentType("contentType")
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .contentDigest("contentDigest")
     *                         .build())
     *                 .statistics(MetricsSourceProperty.builder()
     *                         .contentType("contentType")
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .contentDigest("contentDigest")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.ModelMetricsProperty")
    @software.amazon.jsii.Jsii.Proxy(ModelMetricsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ModelMetricsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Metrics that measure bais in a model.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBias() {
            return null;
        }

        /**
         * Metrics that help explain a model.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExplainability() {
            return null;
        }

        /**
         * Metrics that measure the quality of the input data for a model.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getModelDataQuality() {
            return null;
        }

        /**
         * Metrics that measure the quality of a model.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getModelQuality() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ModelMetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ModelMetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ModelMetricsProperty> {
            java.lang.Object bias;
            java.lang.Object explainability;
            java.lang.Object modelDataQuality;
            java.lang.Object modelQuality;

            /**
             * Sets the value of {@link ModelMetricsProperty#getBias}
             * @param bias Metrics that measure bais in a model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bias(software.amazon.awscdk.core.IResolvable bias) {
                this.bias = bias;
                return this;
            }

            /**
             * Sets the value of {@link ModelMetricsProperty#getBias}
             * @param bias Metrics that measure bais in a model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bias(software.amazon.awscdk.services.sagemaker.CfnModelPackage.BiasProperty bias) {
                this.bias = bias;
                return this;
            }

            /**
             * Sets the value of {@link ModelMetricsProperty#getExplainability}
             * @param explainability Metrics that help explain a model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder explainability(software.amazon.awscdk.core.IResolvable explainability) {
                this.explainability = explainability;
                return this;
            }

            /**
             * Sets the value of {@link ModelMetricsProperty#getExplainability}
             * @param explainability Metrics that help explain a model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder explainability(software.amazon.awscdk.services.sagemaker.CfnModelPackage.ExplainabilityProperty explainability) {
                this.explainability = explainability;
                return this;
            }

            /**
             * Sets the value of {@link ModelMetricsProperty#getModelDataQuality}
             * @param modelDataQuality Metrics that measure the quality of the input data for a model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelDataQuality(software.amazon.awscdk.core.IResolvable modelDataQuality) {
                this.modelDataQuality = modelDataQuality;
                return this;
            }

            /**
             * Sets the value of {@link ModelMetricsProperty#getModelDataQuality}
             * @param modelDataQuality Metrics that measure the quality of the input data for a model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelDataQuality(software.amazon.awscdk.services.sagemaker.CfnModelPackage.ModelDataQualityProperty modelDataQuality) {
                this.modelDataQuality = modelDataQuality;
                return this;
            }

            /**
             * Sets the value of {@link ModelMetricsProperty#getModelQuality}
             * @param modelQuality Metrics that measure the quality of a model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelQuality(software.amazon.awscdk.core.IResolvable modelQuality) {
                this.modelQuality = modelQuality;
                return this;
            }

            /**
             * Sets the value of {@link ModelMetricsProperty#getModelQuality}
             * @param modelQuality Metrics that measure the quality of a model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelQuality(software.amazon.awscdk.services.sagemaker.CfnModelPackage.ModelQualityProperty modelQuality) {
                this.modelQuality = modelQuality;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ModelMetricsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ModelMetricsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ModelMetricsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModelMetricsProperty {
            private final java.lang.Object bias;
            private final java.lang.Object explainability;
            private final java.lang.Object modelDataQuality;
            private final java.lang.Object modelQuality;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bias = software.amazon.jsii.Kernel.get(this, "bias", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.explainability = software.amazon.jsii.Kernel.get(this, "explainability", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.modelDataQuality = software.amazon.jsii.Kernel.get(this, "modelDataQuality", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.modelQuality = software.amazon.jsii.Kernel.get(this, "modelQuality", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bias = builder.bias;
                this.explainability = builder.explainability;
                this.modelDataQuality = builder.modelDataQuality;
                this.modelQuality = builder.modelQuality;
            }

            @Override
            public final java.lang.Object getBias() {
                return this.bias;
            }

            @Override
            public final java.lang.Object getExplainability() {
                return this.explainability;
            }

            @Override
            public final java.lang.Object getModelDataQuality() {
                return this.modelDataQuality;
            }

            @Override
            public final java.lang.Object getModelQuality() {
                return this.modelQuality;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBias() != null) {
                    data.set("bias", om.valueToTree(this.getBias()));
                }
                if (this.getExplainability() != null) {
                    data.set("explainability", om.valueToTree(this.getExplainability()));
                }
                if (this.getModelDataQuality() != null) {
                    data.set("modelDataQuality", om.valueToTree(this.getModelDataQuality()));
                }
                if (this.getModelQuality() != null) {
                    data.set("modelQuality", om.valueToTree(this.getModelQuality()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.ModelMetricsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ModelMetricsProperty.Jsii$Proxy that = (ModelMetricsProperty.Jsii$Proxy) o;

                if (this.bias != null ? !this.bias.equals(that.bias) : that.bias != null) return false;
                if (this.explainability != null ? !this.explainability.equals(that.explainability) : that.explainability != null) return false;
                if (this.modelDataQuality != null ? !this.modelDataQuality.equals(that.modelDataQuality) : that.modelDataQuality != null) return false;
                return this.modelQuality != null ? this.modelQuality.equals(that.modelQuality) : that.modelQuality == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bias != null ? this.bias.hashCode() : 0;
                result = 31 * result + (this.explainability != null ? this.explainability.hashCode() : 0);
                result = 31 * result + (this.modelDataQuality != null ? this.modelDataQuality.hashCode() : 0);
                result = 31 * result + (this.modelQuality != null ? this.modelQuality.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the Docker container for the model package.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * Object environment;
     * Object modelInput;
     * ModelPackageContainerDefinitionProperty modelPackageContainerDefinitionProperty = ModelPackageContainerDefinitionProperty.builder()
     *         .image("image")
     *         // the properties below are optional
     *         .containerHostname("containerHostname")
     *         .environment(environment)
     *         .framework("framework")
     *         .frameworkVersion("frameworkVersion")
     *         .imageDigest("imageDigest")
     *         .modelDataUrl("modelDataUrl")
     *         .modelInput(modelInput)
     *         .nearestModelName("nearestModelName")
     *         .productId("productId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.ModelPackageContainerDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(ModelPackageContainerDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ModelPackageContainerDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.
         * <p>
         * If you are using your own custom algorithm instead of an algorithm provided by SageMaker, the inference code must meet SageMaker requirements. SageMaker supports both <code>registry/repository[:tag]</code> and <code>registry/repository[&#64;digest]</code> image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImage();

        /**
         * The DNS host name for the Docker container.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerHostname() {
            return null;
        }

        /**
         * The environment variables to set in the Docker container.
         * <p>
         * Each key and value in the <code>Environment</code> string to string map can have length of up to 1024. We support up to 16 entries in the map.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
            return null;
        }

        /**
         * The machine learning framework of the model package container image.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFramework() {
            return null;
        }

        /**
         * The framework version of the Model Package Container Image.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFrameworkVersion() {
            return null;
        }

        /**
         * An MD5 hash of the training algorithm that identifies the Docker image used for training.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImageDigest() {
            return null;
        }

        /**
         * The Amazon S3 path where the model artifacts, which result from model training, are stored.
         * <p>
         * This path must point to a single <code>gzip</code> compressed tar archive ( <code>.tar.gz</code> suffix).
         * <p>
         * <blockquote>
         * <p>
         * The model artifacts must be in an S3 bucket that is in the same region as the model package.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getModelDataUrl() {
            return null;
        }

        /**
         * A structure with Model Input details.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getModelInput() {
            return null;
        }

        /**
         * The name of a pre-trained machine learning benchmarked by Amazon SageMaker Inference Recommender model that matches your model.
         * <p>
         * You can find a list of benchmarked models by calling <code>ListModelMetadata</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNearestModelName() {
            return null;
        }

        /**
         * The AWS Marketplace product ID of the model package.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProductId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ModelPackageContainerDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ModelPackageContainerDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ModelPackageContainerDefinitionProperty> {
            java.lang.String image;
            java.lang.String containerHostname;
            java.lang.Object environment;
            java.lang.String framework;
            java.lang.String frameworkVersion;
            java.lang.String imageDigest;
            java.lang.String modelDataUrl;
            java.lang.Object modelInput;
            java.lang.String nearestModelName;
            java.lang.String productId;

            /**
             * Sets the value of {@link ModelPackageContainerDefinitionProperty#getImage}
             * @param image The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored. This parameter is required.
             *              If you are using your own custom algorithm instead of an algorithm provided by SageMaker, the inference code must meet SageMaker requirements. SageMaker supports both <code>registry/repository[:tag]</code> and <code>registry/repository[&#64;digest]</code> image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder image(java.lang.String image) {
                this.image = image;
                return this;
            }

            /**
             * Sets the value of {@link ModelPackageContainerDefinitionProperty#getContainerHostname}
             * @param containerHostname The DNS host name for the Docker container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerHostname(java.lang.String containerHostname) {
                this.containerHostname = containerHostname;
                return this;
            }

            /**
             * Sets the value of {@link ModelPackageContainerDefinitionProperty#getEnvironment}
             * @param environment The environment variables to set in the Docker container.
             *                    Each key and value in the <code>Environment</code> string to string map can have length of up to 1024. We support up to 16 entries in the map.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(java.lang.Object environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link ModelPackageContainerDefinitionProperty#getFramework}
             * @param framework The machine learning framework of the model package container image.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder framework(java.lang.String framework) {
                this.framework = framework;
                return this;
            }

            /**
             * Sets the value of {@link ModelPackageContainerDefinitionProperty#getFrameworkVersion}
             * @param frameworkVersion The framework version of the Model Package Container Image.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frameworkVersion(java.lang.String frameworkVersion) {
                this.frameworkVersion = frameworkVersion;
                return this;
            }

            /**
             * Sets the value of {@link ModelPackageContainerDefinitionProperty#getImageDigest}
             * @param imageDigest An MD5 hash of the training algorithm that identifies the Docker image used for training.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageDigest(java.lang.String imageDigest) {
                this.imageDigest = imageDigest;
                return this;
            }

            /**
             * Sets the value of {@link ModelPackageContainerDefinitionProperty#getModelDataUrl}
             * @param modelDataUrl The Amazon S3 path where the model artifacts, which result from model training, are stored.
             *                     This path must point to a single <code>gzip</code> compressed tar archive ( <code>.tar.gz</code> suffix).
             *                     <p>
             *                     <blockquote>
             *                     <p>
             *                     The model artifacts must be in an S3 bucket that is in the same region as the model package.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelDataUrl(java.lang.String modelDataUrl) {
                this.modelDataUrl = modelDataUrl;
                return this;
            }

            /**
             * Sets the value of {@link ModelPackageContainerDefinitionProperty#getModelInput}
             * @param modelInput A structure with Model Input details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelInput(java.lang.Object modelInput) {
                this.modelInput = modelInput;
                return this;
            }

            /**
             * Sets the value of {@link ModelPackageContainerDefinitionProperty#getNearestModelName}
             * @param nearestModelName The name of a pre-trained machine learning benchmarked by Amazon SageMaker Inference Recommender model that matches your model.
             *                         You can find a list of benchmarked models by calling <code>ListModelMetadata</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nearestModelName(java.lang.String nearestModelName) {
                this.nearestModelName = nearestModelName;
                return this;
            }

            /**
             * Sets the value of {@link ModelPackageContainerDefinitionProperty#getProductId}
             * @param productId The AWS Marketplace product ID of the model package.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder productId(java.lang.String productId) {
                this.productId = productId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ModelPackageContainerDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ModelPackageContainerDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ModelPackageContainerDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModelPackageContainerDefinitionProperty {
            private final java.lang.String image;
            private final java.lang.String containerHostname;
            private final java.lang.Object environment;
            private final java.lang.String framework;
            private final java.lang.String frameworkVersion;
            private final java.lang.String imageDigest;
            private final java.lang.String modelDataUrl;
            private final java.lang.Object modelInput;
            private final java.lang.String nearestModelName;
            private final java.lang.String productId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.containerHostname = software.amazon.jsii.Kernel.get(this, "containerHostname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.framework = software.amazon.jsii.Kernel.get(this, "framework", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.frameworkVersion = software.amazon.jsii.Kernel.get(this, "frameworkVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageDigest = software.amazon.jsii.Kernel.get(this, "imageDigest", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.modelDataUrl = software.amazon.jsii.Kernel.get(this, "modelDataUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.modelInput = software.amazon.jsii.Kernel.get(this, "modelInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.nearestModelName = software.amazon.jsii.Kernel.get(this, "nearestModelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.productId = software.amazon.jsii.Kernel.get(this, "productId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.image = java.util.Objects.requireNonNull(builder.image, "image is required");
                this.containerHostname = builder.containerHostname;
                this.environment = builder.environment;
                this.framework = builder.framework;
                this.frameworkVersion = builder.frameworkVersion;
                this.imageDigest = builder.imageDigest;
                this.modelDataUrl = builder.modelDataUrl;
                this.modelInput = builder.modelInput;
                this.nearestModelName = builder.nearestModelName;
                this.productId = builder.productId;
            }

            @Override
            public final java.lang.String getImage() {
                return this.image;
            }

            @Override
            public final java.lang.String getContainerHostname() {
                return this.containerHostname;
            }

            @Override
            public final java.lang.Object getEnvironment() {
                return this.environment;
            }

            @Override
            public final java.lang.String getFramework() {
                return this.framework;
            }

            @Override
            public final java.lang.String getFrameworkVersion() {
                return this.frameworkVersion;
            }

            @Override
            public final java.lang.String getImageDigest() {
                return this.imageDigest;
            }

            @Override
            public final java.lang.String getModelDataUrl() {
                return this.modelDataUrl;
            }

            @Override
            public final java.lang.Object getModelInput() {
                return this.modelInput;
            }

            @Override
            public final java.lang.String getNearestModelName() {
                return this.nearestModelName;
            }

            @Override
            public final java.lang.String getProductId() {
                return this.productId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("image", om.valueToTree(this.getImage()));
                if (this.getContainerHostname() != null) {
                    data.set("containerHostname", om.valueToTree(this.getContainerHostname()));
                }
                if (this.getEnvironment() != null) {
                    data.set("environment", om.valueToTree(this.getEnvironment()));
                }
                if (this.getFramework() != null) {
                    data.set("framework", om.valueToTree(this.getFramework()));
                }
                if (this.getFrameworkVersion() != null) {
                    data.set("frameworkVersion", om.valueToTree(this.getFrameworkVersion()));
                }
                if (this.getImageDigest() != null) {
                    data.set("imageDigest", om.valueToTree(this.getImageDigest()));
                }
                if (this.getModelDataUrl() != null) {
                    data.set("modelDataUrl", om.valueToTree(this.getModelDataUrl()));
                }
                if (this.getModelInput() != null) {
                    data.set("modelInput", om.valueToTree(this.getModelInput()));
                }
                if (this.getNearestModelName() != null) {
                    data.set("nearestModelName", om.valueToTree(this.getNearestModelName()));
                }
                if (this.getProductId() != null) {
                    data.set("productId", om.valueToTree(this.getProductId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.ModelPackageContainerDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ModelPackageContainerDefinitionProperty.Jsii$Proxy that = (ModelPackageContainerDefinitionProperty.Jsii$Proxy) o;

                if (!image.equals(that.image)) return false;
                if (this.containerHostname != null ? !this.containerHostname.equals(that.containerHostname) : that.containerHostname != null) return false;
                if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
                if (this.framework != null ? !this.framework.equals(that.framework) : that.framework != null) return false;
                if (this.frameworkVersion != null ? !this.frameworkVersion.equals(that.frameworkVersion) : that.frameworkVersion != null) return false;
                if (this.imageDigest != null ? !this.imageDigest.equals(that.imageDigest) : that.imageDigest != null) return false;
                if (this.modelDataUrl != null ? !this.modelDataUrl.equals(that.modelDataUrl) : that.modelDataUrl != null) return false;
                if (this.modelInput != null ? !this.modelInput.equals(that.modelInput) : that.modelInput != null) return false;
                if (this.nearestModelName != null ? !this.nearestModelName.equals(that.nearestModelName) : that.nearestModelName != null) return false;
                return this.productId != null ? this.productId.equals(that.productId) : that.productId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.image.hashCode();
                result = 31 * result + (this.containerHostname != null ? this.containerHostname.hashCode() : 0);
                result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
                result = 31 * result + (this.framework != null ? this.framework.hashCode() : 0);
                result = 31 * result + (this.frameworkVersion != null ? this.frameworkVersion.hashCode() : 0);
                result = 31 * result + (this.imageDigest != null ? this.imageDigest.hashCode() : 0);
                result = 31 * result + (this.modelDataUrl != null ? this.modelDataUrl.hashCode() : 0);
                result = 31 * result + (this.modelInput != null ? this.modelInput.hashCode() : 0);
                result = 31 * result + (this.nearestModelName != null ? this.nearestModelName.hashCode() : 0);
                result = 31 * result + (this.productId != null ? this.productId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the validation and image scan statuses of the model package.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ModelPackageStatusDetailsProperty modelPackageStatusDetailsProperty = ModelPackageStatusDetailsProperty.builder()
     *         .validationStatuses(List.of(ModelPackageStatusItemProperty.builder()
     *                 .name("name")
     *                 .status("status")
     *                 // the properties below are optional
     *                 .failureReason("failureReason")
     *                 .build()))
     *         // the properties below are optional
     *         .imageScanStatuses(List.of(ModelPackageStatusItemProperty.builder()
     *                 .name("name")
     *                 .status("status")
     *                 // the properties below are optional
     *                 .failureReason("failureReason")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.ModelPackageStatusDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(ModelPackageStatusDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ModelPackageStatusDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The validation status of the model package.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValidationStatuses();

        /**
         * The status of the scan of the Docker image container for the model package.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getImageScanStatuses() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ModelPackageStatusDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ModelPackageStatusDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ModelPackageStatusDetailsProperty> {
            java.lang.Object validationStatuses;
            java.lang.Object imageScanStatuses;

            /**
             * Sets the value of {@link ModelPackageStatusDetailsProperty#getValidationStatuses}
             * @param validationStatuses The validation status of the model package. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validationStatuses(software.amazon.awscdk.core.IResolvable validationStatuses) {
                this.validationStatuses = validationStatuses;
                return this;
            }

            /**
             * Sets the value of {@link ModelPackageStatusDetailsProperty#getValidationStatuses}
             * @param validationStatuses The validation status of the model package. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validationStatuses(java.util.List<? extends java.lang.Object> validationStatuses) {
                this.validationStatuses = validationStatuses;
                return this;
            }

            /**
             * Sets the value of {@link ModelPackageStatusDetailsProperty#getImageScanStatuses}
             * @param imageScanStatuses The status of the scan of the Docker image container for the model package.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageScanStatuses(software.amazon.awscdk.core.IResolvable imageScanStatuses) {
                this.imageScanStatuses = imageScanStatuses;
                return this;
            }

            /**
             * Sets the value of {@link ModelPackageStatusDetailsProperty#getImageScanStatuses}
             * @param imageScanStatuses The status of the scan of the Docker image container for the model package.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageScanStatuses(java.util.List<? extends java.lang.Object> imageScanStatuses) {
                this.imageScanStatuses = imageScanStatuses;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ModelPackageStatusDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ModelPackageStatusDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ModelPackageStatusDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModelPackageStatusDetailsProperty {
            private final java.lang.Object validationStatuses;
            private final java.lang.Object imageScanStatuses;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.validationStatuses = software.amazon.jsii.Kernel.get(this, "validationStatuses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.imageScanStatuses = software.amazon.jsii.Kernel.get(this, "imageScanStatuses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.validationStatuses = java.util.Objects.requireNonNull(builder.validationStatuses, "validationStatuses is required");
                this.imageScanStatuses = builder.imageScanStatuses;
            }

            @Override
            public final java.lang.Object getValidationStatuses() {
                return this.validationStatuses;
            }

            @Override
            public final java.lang.Object getImageScanStatuses() {
                return this.imageScanStatuses;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("validationStatuses", om.valueToTree(this.getValidationStatuses()));
                if (this.getImageScanStatuses() != null) {
                    data.set("imageScanStatuses", om.valueToTree(this.getImageScanStatuses()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.ModelPackageStatusDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ModelPackageStatusDetailsProperty.Jsii$Proxy that = (ModelPackageStatusDetailsProperty.Jsii$Proxy) o;

                if (!validationStatuses.equals(that.validationStatuses)) return false;
                return this.imageScanStatuses != null ? this.imageScanStatuses.equals(that.imageScanStatuses) : that.imageScanStatuses == null;
            }

            @Override
            public final int hashCode() {
                int result = this.validationStatuses.hashCode();
                result = 31 * result + (this.imageScanStatuses != null ? this.imageScanStatuses.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents the overall status of a model package.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ModelPackageStatusItemProperty modelPackageStatusItemProperty = ModelPackageStatusItemProperty.builder()
     *         .name("name")
     *         .status("status")
     *         // the properties below are optional
     *         .failureReason("failureReason")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.ModelPackageStatusItemProperty")
    @software.amazon.jsii.Jsii.Proxy(ModelPackageStatusItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ModelPackageStatusItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the model package for which the overall status is being reported.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The current status.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * if the overall status is `Failed` , the reason for the failure.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFailureReason() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ModelPackageStatusItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ModelPackageStatusItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ModelPackageStatusItemProperty> {
            java.lang.String name;
            java.lang.String status;
            java.lang.String failureReason;

            /**
             * Sets the value of {@link ModelPackageStatusItemProperty#getName}
             * @param name The name of the model package for which the overall status is being reported. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ModelPackageStatusItemProperty#getStatus}
             * @param status The current status. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link ModelPackageStatusItemProperty#getFailureReason}
             * @param failureReason if the overall status is `Failed` , the reason for the failure.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureReason(java.lang.String failureReason) {
                this.failureReason = failureReason;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ModelPackageStatusItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ModelPackageStatusItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ModelPackageStatusItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModelPackageStatusItemProperty {
            private final java.lang.String name;
            private final java.lang.String status;
            private final java.lang.String failureReason;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.failureReason = software.amazon.jsii.Kernel.get(this, "failureReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
                this.failureReason = builder.failureReason;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.String getFailureReason() {
                return this.failureReason;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("status", om.valueToTree(this.getStatus()));
                if (this.getFailureReason() != null) {
                    data.set("failureReason", om.valueToTree(this.getFailureReason()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.ModelPackageStatusItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ModelPackageStatusItemProperty.Jsii$Proxy that = (ModelPackageStatusItemProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!status.equals(that.status)) return false;
                return this.failureReason != null ? this.failureReason.equals(that.failureReason) : that.failureReason == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.status.hashCode());
                result = 31 * result + (this.failureReason != null ? this.failureReason.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Model quality statistics and constraints.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ModelQualityProperty modelQualityProperty = ModelQualityProperty.builder()
     *         .constraints(MetricsSourceProperty.builder()
     *                 .contentType("contentType")
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .contentDigest("contentDigest")
     *                 .build())
     *         .statistics(MetricsSourceProperty.builder()
     *                 .contentType("contentType")
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .contentDigest("contentDigest")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.ModelQualityProperty")
    @software.amazon.jsii.Jsii.Proxy(ModelQualityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ModelQualityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Model quality constraints.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConstraints() {
            return null;
        }

        /**
         * Model quality statistics.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStatistics() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ModelQualityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ModelQualityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ModelQualityProperty> {
            java.lang.Object constraints;
            java.lang.Object statistics;

            /**
             * Sets the value of {@link ModelQualityProperty#getConstraints}
             * @param constraints Model quality constraints.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraints(software.amazon.awscdk.core.IResolvable constraints) {
                this.constraints = constraints;
                return this;
            }

            /**
             * Sets the value of {@link ModelQualityProperty#getConstraints}
             * @param constraints Model quality constraints.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraints(software.amazon.awscdk.services.sagemaker.CfnModelPackage.MetricsSourceProperty constraints) {
                this.constraints = constraints;
                return this;
            }

            /**
             * Sets the value of {@link ModelQualityProperty#getStatistics}
             * @param statistics Model quality statistics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistics(software.amazon.awscdk.core.IResolvable statistics) {
                this.statistics = statistics;
                return this;
            }

            /**
             * Sets the value of {@link ModelQualityProperty#getStatistics}
             * @param statistics Model quality statistics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistics(software.amazon.awscdk.services.sagemaker.CfnModelPackage.MetricsSourceProperty statistics) {
                this.statistics = statistics;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ModelQualityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ModelQualityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ModelQualityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModelQualityProperty {
            private final java.lang.Object constraints;
            private final java.lang.Object statistics;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.constraints = software.amazon.jsii.Kernel.get(this, "constraints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.statistics = software.amazon.jsii.Kernel.get(this, "statistics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.constraints = builder.constraints;
                this.statistics = builder.statistics;
            }

            @Override
            public final java.lang.Object getConstraints() {
                return this.constraints;
            }

            @Override
            public final java.lang.Object getStatistics() {
                return this.statistics;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConstraints() != null) {
                    data.set("constraints", om.valueToTree(this.getConstraints()));
                }
                if (this.getStatistics() != null) {
                    data.set("statistics", om.valueToTree(this.getStatistics()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.ModelQualityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ModelQualityProperty.Jsii$Proxy that = (ModelQualityProperty.Jsii$Proxy) o;

                if (this.constraints != null ? !this.constraints.equals(that.constraints) : that.constraints != null) return false;
                return this.statistics != null ? this.statistics.equals(that.statistics) : that.statistics == null;
            }

            @Override
            public final int hashCode() {
                int result = this.constraints != null ? this.constraints.hashCode() : 0;
                result = 31 * result + (this.statistics != null ? this.statistics.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the S3 data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * S3DataSourceProperty s3DataSourceProperty = S3DataSourceProperty.builder()
     *         .s3DataType("s3DataType")
     *         .s3Uri("s3Uri")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.S3DataSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(S3DataSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3DataSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If you choose `S3Prefix` , `S3Uri` identifies a key name prefix.
         * <p>
         * SageMaker uses all objects that match the specified key name prefix for model training.
         * <p>
         * If you choose <code>ManifestFile</code> , <code>S3Uri</code> identifies an object that is a manifest file containing a list of object keys that you want SageMaker to use for model training.
         * <p>
         * If you choose <code>AugmentedManifestFile</code> , S3Uri identifies an object that is an augmented manifest file in JSON lines format. This file contains the data you want to use for model training. <code>AugmentedManifestFile</code> can only be used if the Channel's input mode is <code>Pipe</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3DataType();

        /**
         * Depending on the value specified for the `S3DataType` , identifies either a key name prefix or a manifest.
         * <p>
         * For example:
         * <p>
         * <ul>
         * <li>A key name prefix might look like this: <code>s3://bucketname/exampleprefix</code></li>
         * <li>A manifest might look like this: <code>s3://bucketname/example.manifest</code></li>
         * </ul>
         * <p>
         * A manifest is an S3 object which is a JSON file consisting of an array of elements. The first element is a prefix which is followed by one or more suffixes. SageMaker appends the suffix elements to the prefix to get a full set of <code>S3Uri</code> . Note that the prefix must be a valid non-empty <code>S3Uri</code> that precludes users from specifying a manifest whose individual <code>S3Uri</code> is sourced from different S3 buckets.
         * <p>
         * The following code example shows a valid manifest format:
         * <p>
         * <code>[ {"prefix": "s3://customer_bucket/some/prefix/"},</code>
         * <p>
         * <code>"relative/path/to/custdata-1",</code>
         * <p>
         * <code>"relative/path/custdata-2",</code>
         * <p>
         * <code>...</code>
         * <p>
         * <code>"relative/path/custdata-N"</code>
         * <p>
         * <code>]</code>
         * <p>
         * This JSON is equivalent to the following <code>S3Uri</code> list:
         * <p>
         * <code>s3://customer_bucket/some/prefix/relative/path/to/custdata-1</code>
         * <p>
         * <code>s3://customer_bucket/some/prefix/relative/path/custdata-2</code>
         * <p>
         * <code>...</code>
         * <p>
         * <code>s3://customer_bucket/some/prefix/relative/path/custdata-N</code>
         * <p>
         * The complete set of <code>S3Uri</code> in this manifest is the input data for the channel for this data source. The object that each <code>S3Uri</code> points to must be readable by the IAM role that SageMaker uses to perform tasks on your behalf.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Uri();

        /**
         * @return a {@link Builder} of {@link S3DataSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3DataSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3DataSourceProperty> {
            java.lang.String s3DataType;
            java.lang.String s3Uri;

            /**
             * Sets the value of {@link S3DataSourceProperty#getS3DataType}
             * @param s3DataType If you choose `S3Prefix` , `S3Uri` identifies a key name prefix. This parameter is required.
             *                   SageMaker uses all objects that match the specified key name prefix for model training.
             *                   <p>
             *                   If you choose <code>ManifestFile</code> , <code>S3Uri</code> identifies an object that is a manifest file containing a list of object keys that you want SageMaker to use for model training.
             *                   <p>
             *                   If you choose <code>AugmentedManifestFile</code> , S3Uri identifies an object that is an augmented manifest file in JSON lines format. This file contains the data you want to use for model training. <code>AugmentedManifestFile</code> can only be used if the Channel's input mode is <code>Pipe</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3DataType(java.lang.String s3DataType) {
                this.s3DataType = s3DataType;
                return this;
            }

            /**
             * Sets the value of {@link S3DataSourceProperty#getS3Uri}
             * @param s3Uri Depending on the value specified for the `S3DataType` , identifies either a key name prefix or a manifest. This parameter is required.
             *              For example:
             *              <p>
             *              <ul>
             *              <li>A key name prefix might look like this: <code>s3://bucketname/exampleprefix</code></li>
             *              <li>A manifest might look like this: <code>s3://bucketname/example.manifest</code></li>
             *              </ul>
             *              <p>
             *              A manifest is an S3 object which is a JSON file consisting of an array of elements. The first element is a prefix which is followed by one or more suffixes. SageMaker appends the suffix elements to the prefix to get a full set of <code>S3Uri</code> . Note that the prefix must be a valid non-empty <code>S3Uri</code> that precludes users from specifying a manifest whose individual <code>S3Uri</code> is sourced from different S3 buckets.
             *              <p>
             *              The following code example shows a valid manifest format:
             *              <p>
             *              <code>[ {"prefix": "s3://customer_bucket/some/prefix/"},</code>
             *              <p>
             *              <code>"relative/path/to/custdata-1",</code>
             *              <p>
             *              <code>"relative/path/custdata-2",</code>
             *              <p>
             *              <code>...</code>
             *              <p>
             *              <code>"relative/path/custdata-N"</code>
             *              <p>
             *              <code>]</code>
             *              <p>
             *              This JSON is equivalent to the following <code>S3Uri</code> list:
             *              <p>
             *              <code>s3://customer_bucket/some/prefix/relative/path/to/custdata-1</code>
             *              <p>
             *              <code>s3://customer_bucket/some/prefix/relative/path/custdata-2</code>
             *              <p>
             *              <code>...</code>
             *              <p>
             *              <code>s3://customer_bucket/some/prefix/relative/path/custdata-N</code>
             *              <p>
             *              The complete set of <code>S3Uri</code> in this manifest is the input data for the channel for this data source. The object that each <code>S3Uri</code> points to must be readable by the IAM role that SageMaker uses to perform tasks on your behalf.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3DataSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3DataSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3DataSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3DataSourceProperty {
            private final java.lang.String s3DataType;
            private final java.lang.String s3Uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3DataType = software.amazon.jsii.Kernel.get(this, "s3DataType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3DataType = java.util.Objects.requireNonNull(builder.s3DataType, "s3DataType is required");
                this.s3Uri = java.util.Objects.requireNonNull(builder.s3Uri, "s3Uri is required");
            }

            @Override
            public final java.lang.String getS3DataType() {
                return this.s3DataType;
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3DataType", om.valueToTree(this.getS3DataType()));
                data.set("s3Uri", om.valueToTree(this.getS3Uri()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.S3DataSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3DataSourceProperty.Jsii$Proxy that = (S3DataSourceProperty.Jsii$Proxy) o;

                if (!s3DataType.equals(that.s3DataType)) return false;
                return this.s3Uri.equals(that.s3Uri);
            }

            @Override
            public final int hashCode() {
                int result = this.s3DataType.hashCode();
                result = 31 * result + (this.s3Uri.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies an algorithm that was used to create the model package.
     * <p>
     * The algorithm must be either an algorithm resource in your SageMaker account or an algorithm in AWS Marketplace that you are subscribed to.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * SourceAlgorithmProperty sourceAlgorithmProperty = SourceAlgorithmProperty.builder()
     *         .algorithmName("algorithmName")
     *         // the properties below are optional
     *         .modelDataUrl("modelDataUrl")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.SourceAlgorithmProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceAlgorithmProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceAlgorithmProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of an algorithm that was used to create the model package.
         * <p>
         * The algorithm must be either an algorithm resource in your SageMaker account or an algorithm in AWS Marketplace that you are subscribed to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlgorithmName();

        /**
         * The Amazon S3 path where the model artifacts, which result from model training, are stored.
         * <p>
         * This path must point to a single <code>gzip</code> compressed tar archive ( <code>.tar.gz</code> suffix).
         * <p>
         * <blockquote>
         * <p>
         * The model artifacts must be in an S3 bucket that is in the same region as the algorithm.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getModelDataUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceAlgorithmProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceAlgorithmProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceAlgorithmProperty> {
            java.lang.String algorithmName;
            java.lang.String modelDataUrl;

            /**
             * Sets the value of {@link SourceAlgorithmProperty#getAlgorithmName}
             * @param algorithmName The name of an algorithm that was used to create the model package. This parameter is required.
             *                      The algorithm must be either an algorithm resource in your SageMaker account or an algorithm in AWS Marketplace that you are subscribed to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder algorithmName(java.lang.String algorithmName) {
                this.algorithmName = algorithmName;
                return this;
            }

            /**
             * Sets the value of {@link SourceAlgorithmProperty#getModelDataUrl}
             * @param modelDataUrl The Amazon S3 path where the model artifacts, which result from model training, are stored.
             *                     This path must point to a single <code>gzip</code> compressed tar archive ( <code>.tar.gz</code> suffix).
             *                     <p>
             *                     <blockquote>
             *                     <p>
             *                     The model artifacts must be in an S3 bucket that is in the same region as the algorithm.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelDataUrl(java.lang.String modelDataUrl) {
                this.modelDataUrl = modelDataUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceAlgorithmProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceAlgorithmProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceAlgorithmProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceAlgorithmProperty {
            private final java.lang.String algorithmName;
            private final java.lang.String modelDataUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.algorithmName = software.amazon.jsii.Kernel.get(this, "algorithmName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.modelDataUrl = software.amazon.jsii.Kernel.get(this, "modelDataUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.algorithmName = java.util.Objects.requireNonNull(builder.algorithmName, "algorithmName is required");
                this.modelDataUrl = builder.modelDataUrl;
            }

            @Override
            public final java.lang.String getAlgorithmName() {
                return this.algorithmName;
            }

            @Override
            public final java.lang.String getModelDataUrl() {
                return this.modelDataUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("algorithmName", om.valueToTree(this.getAlgorithmName()));
                if (this.getModelDataUrl() != null) {
                    data.set("modelDataUrl", om.valueToTree(this.getModelDataUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.SourceAlgorithmProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceAlgorithmProperty.Jsii$Proxy that = (SourceAlgorithmProperty.Jsii$Proxy) o;

                if (!algorithmName.equals(that.algorithmName)) return false;
                return this.modelDataUrl != null ? this.modelDataUrl.equals(that.modelDataUrl) : that.modelDataUrl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.algorithmName.hashCode();
                result = 31 * result + (this.modelDataUrl != null ? this.modelDataUrl.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A list of algorithms that were used to create a model package.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * SourceAlgorithmSpecificationProperty sourceAlgorithmSpecificationProperty = SourceAlgorithmSpecificationProperty.builder()
     *         .sourceAlgorithms(List.of(SourceAlgorithmProperty.builder()
     *                 .algorithmName("algorithmName")
     *                 // the properties below are optional
     *                 .modelDataUrl("modelDataUrl")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.SourceAlgorithmSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceAlgorithmSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceAlgorithmSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of the algorithms that were used to create a model package.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSourceAlgorithms();

        /**
         * @return a {@link Builder} of {@link SourceAlgorithmSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceAlgorithmSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceAlgorithmSpecificationProperty> {
            java.lang.Object sourceAlgorithms;

            /**
             * Sets the value of {@link SourceAlgorithmSpecificationProperty#getSourceAlgorithms}
             * @param sourceAlgorithms A list of the algorithms that were used to create a model package. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceAlgorithms(software.amazon.awscdk.core.IResolvable sourceAlgorithms) {
                this.sourceAlgorithms = sourceAlgorithms;
                return this;
            }

            /**
             * Sets the value of {@link SourceAlgorithmSpecificationProperty#getSourceAlgorithms}
             * @param sourceAlgorithms A list of the algorithms that were used to create a model package. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceAlgorithms(java.util.List<? extends java.lang.Object> sourceAlgorithms) {
                this.sourceAlgorithms = sourceAlgorithms;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceAlgorithmSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceAlgorithmSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceAlgorithmSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceAlgorithmSpecificationProperty {
            private final java.lang.Object sourceAlgorithms;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceAlgorithms = software.amazon.jsii.Kernel.get(this, "sourceAlgorithms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceAlgorithms = java.util.Objects.requireNonNull(builder.sourceAlgorithms, "sourceAlgorithms is required");
            }

            @Override
            public final java.lang.Object getSourceAlgorithms() {
                return this.sourceAlgorithms;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceAlgorithms", om.valueToTree(this.getSourceAlgorithms()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.SourceAlgorithmSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceAlgorithmSpecificationProperty.Jsii$Proxy that = (SourceAlgorithmSpecificationProperty.Jsii$Proxy) o;

                return this.sourceAlgorithms.equals(that.sourceAlgorithms);
            }

            @Override
            public final int hashCode() {
                int result = this.sourceAlgorithms.hashCode();
                return result;
            }
        }
    }
    /**
     * Describes the input source of a transform job and the way the transform job consumes it.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * TransformInputProperty transformInputProperty = TransformInputProperty.builder()
     *         .dataSource(DataSourceProperty.builder()
     *                 .s3DataSource(S3DataSourceProperty.builder()
     *                         .s3DataType("s3DataType")
     *                         .s3Uri("s3Uri")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .compressionType("compressionType")
     *         .contentType("contentType")
     *         .splitType("splitType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.TransformInputProperty")
    @software.amazon.jsii.Jsii.Proxy(TransformInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TransformInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes the location of the channel data, which is, the S3 location of the input data that the model can consume.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDataSource();

        /**
         * If your transform data is compressed, specify the compression type.
         * <p>
         * Amazon SageMaker automatically decompresses the data for the transform job accordingly. The default value is <code>None</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCompressionType() {
            return null;
        }

        /**
         * The multipurpose internet mail extension (MIME) type of the data.
         * <p>
         * Amazon SageMaker uses the MIME type with each http call to transfer data to the transform job.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContentType() {
            return null;
        }

        /**
         * The method to use to split the transform job's data files into smaller batches.
         * <p>
         * Splitting is necessary when the total size of each object is too large to fit in a single request. You can also use data splitting to improve performance by processing multiple concurrent mini-batches. The default value for <code>SplitType</code> is <code>None</code> , which indicates that input data files are not split, and request payloads contain the entire contents of an input object. Set the value of this parameter to <code>Line</code> to split records on a newline character boundary. <code>SplitType</code> also supports a number of record-oriented binary data formats. Currently, the supported record formats are:
         * <p>
         * <ul>
         * <li>RecordIO</li>
         * <li>TFRecord</li>
         * </ul>
         * <p>
         * When splitting is enabled, the size of a mini-batch depends on the values of the <code>BatchStrategy</code> and <code>MaxPayloadInMB</code> parameters. When the value of <code>BatchStrategy</code> is <code>MultiRecord</code> , Amazon SageMaker sends the maximum number of records in each request, up to the <code>MaxPayloadInMB</code> limit. If the value of <code>BatchStrategy</code> is <code>SingleRecord</code> , Amazon SageMaker sends individual records in each request.
         * <p>
         * <blockquote>
         * <p>
         * Some data formats represent a record as a binary payload wrapped with extra padding bytes. When splitting is applied to a binary data format, padding is removed if the value of <code>BatchStrategy</code> is set to <code>SingleRecord</code> . Padding is not removed if the value of <code>BatchStrategy</code> is set to <code>MultiRecord</code> .
         * <p>
         * For more information about <code>RecordIO</code> , see <a href="https://docs.aws.amazon.com/https://mxnet.apache.org/api/faq/recordio">Create a Dataset Using RecordIO</a> in the MXNet documentation. For more information about <code>TFRecord</code> , see <a href="https://docs.aws.amazon.com/https://www.tensorflow.org/guide/data#consuming_tfrecord_data">Consuming TFRecord data</a> in the TensorFlow documentation.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSplitType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TransformInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TransformInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TransformInputProperty> {
            java.lang.Object dataSource;
            java.lang.String compressionType;
            java.lang.String contentType;
            java.lang.String splitType;

            /**
             * Sets the value of {@link TransformInputProperty#getDataSource}
             * @param dataSource Describes the location of the channel data, which is, the S3 location of the input data that the model can consume. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSource(software.amazon.awscdk.core.IResolvable dataSource) {
                this.dataSource = dataSource;
                return this;
            }

            /**
             * Sets the value of {@link TransformInputProperty#getDataSource}
             * @param dataSource Describes the location of the channel data, which is, the S3 location of the input data that the model can consume. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSource(software.amazon.awscdk.services.sagemaker.CfnModelPackage.DataSourceProperty dataSource) {
                this.dataSource = dataSource;
                return this;
            }

            /**
             * Sets the value of {@link TransformInputProperty#getCompressionType}
             * @param compressionType If your transform data is compressed, specify the compression type.
             *                        Amazon SageMaker automatically decompresses the data for the transform job accordingly. The default value is <code>None</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compressionType(java.lang.String compressionType) {
                this.compressionType = compressionType;
                return this;
            }

            /**
             * Sets the value of {@link TransformInputProperty#getContentType}
             * @param contentType The multipurpose internet mail extension (MIME) type of the data.
             *                    Amazon SageMaker uses the MIME type with each http call to transfer data to the transform job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentType(java.lang.String contentType) {
                this.contentType = contentType;
                return this;
            }

            /**
             * Sets the value of {@link TransformInputProperty#getSplitType}
             * @param splitType The method to use to split the transform job's data files into smaller batches.
             *                  Splitting is necessary when the total size of each object is too large to fit in a single request. You can also use data splitting to improve performance by processing multiple concurrent mini-batches. The default value for <code>SplitType</code> is <code>None</code> , which indicates that input data files are not split, and request payloads contain the entire contents of an input object. Set the value of this parameter to <code>Line</code> to split records on a newline character boundary. <code>SplitType</code> also supports a number of record-oriented binary data formats. Currently, the supported record formats are:
             *                  <p>
             *                  <ul>
             *                  <li>RecordIO</li>
             *                  <li>TFRecord</li>
             *                  </ul>
             *                  <p>
             *                  When splitting is enabled, the size of a mini-batch depends on the values of the <code>BatchStrategy</code> and <code>MaxPayloadInMB</code> parameters. When the value of <code>BatchStrategy</code> is <code>MultiRecord</code> , Amazon SageMaker sends the maximum number of records in each request, up to the <code>MaxPayloadInMB</code> limit. If the value of <code>BatchStrategy</code> is <code>SingleRecord</code> , Amazon SageMaker sends individual records in each request.
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  Some data formats represent a record as a binary payload wrapped with extra padding bytes. When splitting is applied to a binary data format, padding is removed if the value of <code>BatchStrategy</code> is set to <code>SingleRecord</code> . Padding is not removed if the value of <code>BatchStrategy</code> is set to <code>MultiRecord</code> .
             *                  <p>
             *                  For more information about <code>RecordIO</code> , see <a href="https://docs.aws.amazon.com/https://mxnet.apache.org/api/faq/recordio">Create a Dataset Using RecordIO</a> in the MXNet documentation. For more information about <code>TFRecord</code> , see <a href="https://docs.aws.amazon.com/https://www.tensorflow.org/guide/data#consuming_tfrecord_data">Consuming TFRecord data</a> in the TensorFlow documentation.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder splitType(java.lang.String splitType) {
                this.splitType = splitType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransformInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TransformInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TransformInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransformInputProperty {
            private final java.lang.Object dataSource;
            private final java.lang.String compressionType;
            private final java.lang.String contentType;
            private final java.lang.String splitType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSource = software.amazon.jsii.Kernel.get(this, "dataSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.compressionType = software.amazon.jsii.Kernel.get(this, "compressionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.contentType = software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.splitType = software.amazon.jsii.Kernel.get(this, "splitType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSource = java.util.Objects.requireNonNull(builder.dataSource, "dataSource is required");
                this.compressionType = builder.compressionType;
                this.contentType = builder.contentType;
                this.splitType = builder.splitType;
            }

            @Override
            public final java.lang.Object getDataSource() {
                return this.dataSource;
            }

            @Override
            public final java.lang.String getCompressionType() {
                return this.compressionType;
            }

            @Override
            public final java.lang.String getContentType() {
                return this.contentType;
            }

            @Override
            public final java.lang.String getSplitType() {
                return this.splitType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataSource", om.valueToTree(this.getDataSource()));
                if (this.getCompressionType() != null) {
                    data.set("compressionType", om.valueToTree(this.getCompressionType()));
                }
                if (this.getContentType() != null) {
                    data.set("contentType", om.valueToTree(this.getContentType()));
                }
                if (this.getSplitType() != null) {
                    data.set("splitType", om.valueToTree(this.getSplitType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.TransformInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TransformInputProperty.Jsii$Proxy that = (TransformInputProperty.Jsii$Proxy) o;

                if (!dataSource.equals(that.dataSource)) return false;
                if (this.compressionType != null ? !this.compressionType.equals(that.compressionType) : that.compressionType != null) return false;
                if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) return false;
                return this.splitType != null ? this.splitType.equals(that.splitType) : that.splitType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataSource.hashCode();
                result = 31 * result + (this.compressionType != null ? this.compressionType.hashCode() : 0);
                result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
                result = 31 * result + (this.splitType != null ? this.splitType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the input needed to run a transform job using the inference specification specified in the algorithm.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * Object environment;
     * TransformJobDefinitionProperty transformJobDefinitionProperty = TransformJobDefinitionProperty.builder()
     *         .transformInput(TransformInputProperty.builder()
     *                 .dataSource(DataSourceProperty.builder()
     *                         .s3DataSource(S3DataSourceProperty.builder()
     *                                 .s3DataType("s3DataType")
     *                                 .s3Uri("s3Uri")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .compressionType("compressionType")
     *                 .contentType("contentType")
     *                 .splitType("splitType")
     *                 .build())
     *         .transformOutput(TransformOutputProperty.builder()
     *                 .s3OutputPath("s3OutputPath")
     *                 // the properties below are optional
     *                 .accept("accept")
     *                 .assembleWith("assembleWith")
     *                 .kmsKeyId("kmsKeyId")
     *                 .build())
     *         .transformResources(TransformResourcesProperty.builder()
     *                 .instanceCount(123)
     *                 .instanceType("instanceType")
     *                 // the properties below are optional
     *                 .volumeKmsKeyId("volumeKmsKeyId")
     *                 .build())
     *         // the properties below are optional
     *         .batchStrategy("batchStrategy")
     *         .environment(environment)
     *         .maxConcurrentTransforms(123)
     *         .maxPayloadInMb(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.TransformJobDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(TransformJobDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TransformJobDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A description of the input source and the way the transform job consumes it.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTransformInput();

        /**
         * Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTransformOutput();

        /**
         * Identifies the ML compute instances for the transform job.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTransformResources();

        /**
         * A string that determines the number of records included in a single mini-batch.
         * <p>
         * <code>SingleRecord</code> means only one record is used per mini-batch. <code>MultiRecord</code> means a mini-batch is set to contain as many records that can fit within the <code>MaxPayloadInMB</code> limit.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBatchStrategy() {
            return null;
        }

        /**
         * The environment variables to set in the Docker container.
         * <p>
         * We support up to 16 key and values entries in the map.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
            return null;
        }

        /**
         * The maximum number of parallel requests that can be sent to each instance in a transform job.
         * <p>
         * The default value is 1.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxConcurrentTransforms() {
            return null;
        }

        /**
         * The maximum payload size allowed, in MB.
         * <p>
         * A payload is the data portion of a record (without metadata).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxPayloadInMb() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TransformJobDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TransformJobDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TransformJobDefinitionProperty> {
            java.lang.Object transformInput;
            java.lang.Object transformOutput;
            java.lang.Object transformResources;
            java.lang.String batchStrategy;
            java.lang.Object environment;
            java.lang.Number maxConcurrentTransforms;
            java.lang.Number maxPayloadInMb;

            /**
             * Sets the value of {@link TransformJobDefinitionProperty#getTransformInput}
             * @param transformInput A description of the input source and the way the transform job consumes it. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transformInput(software.amazon.awscdk.core.IResolvable transformInput) {
                this.transformInput = transformInput;
                return this;
            }

            /**
             * Sets the value of {@link TransformJobDefinitionProperty#getTransformInput}
             * @param transformInput A description of the input source and the way the transform job consumes it. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transformInput(software.amazon.awscdk.services.sagemaker.CfnModelPackage.TransformInputProperty transformInput) {
                this.transformInput = transformInput;
                return this;
            }

            /**
             * Sets the value of {@link TransformJobDefinitionProperty#getTransformOutput}
             * @param transformOutput Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transformOutput(software.amazon.awscdk.core.IResolvable transformOutput) {
                this.transformOutput = transformOutput;
                return this;
            }

            /**
             * Sets the value of {@link TransformJobDefinitionProperty#getTransformOutput}
             * @param transformOutput Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transformOutput(software.amazon.awscdk.services.sagemaker.CfnModelPackage.TransformOutputProperty transformOutput) {
                this.transformOutput = transformOutput;
                return this;
            }

            /**
             * Sets the value of {@link TransformJobDefinitionProperty#getTransformResources}
             * @param transformResources Identifies the ML compute instances for the transform job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transformResources(software.amazon.awscdk.core.IResolvable transformResources) {
                this.transformResources = transformResources;
                return this;
            }

            /**
             * Sets the value of {@link TransformJobDefinitionProperty#getTransformResources}
             * @param transformResources Identifies the ML compute instances for the transform job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transformResources(software.amazon.awscdk.services.sagemaker.CfnModelPackage.TransformResourcesProperty transformResources) {
                this.transformResources = transformResources;
                return this;
            }

            /**
             * Sets the value of {@link TransformJobDefinitionProperty#getBatchStrategy}
             * @param batchStrategy A string that determines the number of records included in a single mini-batch.
             *                      <code>SingleRecord</code> means only one record is used per mini-batch. <code>MultiRecord</code> means a mini-batch is set to contain as many records that can fit within the <code>MaxPayloadInMB</code> limit.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchStrategy(java.lang.String batchStrategy) {
                this.batchStrategy = batchStrategy;
                return this;
            }

            /**
             * Sets the value of {@link TransformJobDefinitionProperty#getEnvironment}
             * @param environment The environment variables to set in the Docker container.
             *                    We support up to 16 key and values entries in the map.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(java.lang.Object environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link TransformJobDefinitionProperty#getMaxConcurrentTransforms}
             * @param maxConcurrentTransforms The maximum number of parallel requests that can be sent to each instance in a transform job.
             *                                The default value is 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxConcurrentTransforms(java.lang.Number maxConcurrentTransforms) {
                this.maxConcurrentTransforms = maxConcurrentTransforms;
                return this;
            }

            /**
             * Sets the value of {@link TransformJobDefinitionProperty#getMaxPayloadInMb}
             * @param maxPayloadInMb The maximum payload size allowed, in MB.
             *                       A payload is the data portion of a record (without metadata).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxPayloadInMb(java.lang.Number maxPayloadInMb) {
                this.maxPayloadInMb = maxPayloadInMb;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransformJobDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TransformJobDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TransformJobDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransformJobDefinitionProperty {
            private final java.lang.Object transformInput;
            private final java.lang.Object transformOutput;
            private final java.lang.Object transformResources;
            private final java.lang.String batchStrategy;
            private final java.lang.Object environment;
            private final java.lang.Number maxConcurrentTransforms;
            private final java.lang.Number maxPayloadInMb;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.transformInput = software.amazon.jsii.Kernel.get(this, "transformInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.transformOutput = software.amazon.jsii.Kernel.get(this, "transformOutput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.transformResources = software.amazon.jsii.Kernel.get(this, "transformResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.batchStrategy = software.amazon.jsii.Kernel.get(this, "batchStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxConcurrentTransforms = software.amazon.jsii.Kernel.get(this, "maxConcurrentTransforms", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxPayloadInMb = software.amazon.jsii.Kernel.get(this, "maxPayloadInMb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.transformInput = java.util.Objects.requireNonNull(builder.transformInput, "transformInput is required");
                this.transformOutput = java.util.Objects.requireNonNull(builder.transformOutput, "transformOutput is required");
                this.transformResources = java.util.Objects.requireNonNull(builder.transformResources, "transformResources is required");
                this.batchStrategy = builder.batchStrategy;
                this.environment = builder.environment;
                this.maxConcurrentTransforms = builder.maxConcurrentTransforms;
                this.maxPayloadInMb = builder.maxPayloadInMb;
            }

            @Override
            public final java.lang.Object getTransformInput() {
                return this.transformInput;
            }

            @Override
            public final java.lang.Object getTransformOutput() {
                return this.transformOutput;
            }

            @Override
            public final java.lang.Object getTransformResources() {
                return this.transformResources;
            }

            @Override
            public final java.lang.String getBatchStrategy() {
                return this.batchStrategy;
            }

            @Override
            public final java.lang.Object getEnvironment() {
                return this.environment;
            }

            @Override
            public final java.lang.Number getMaxConcurrentTransforms() {
                return this.maxConcurrentTransforms;
            }

            @Override
            public final java.lang.Number getMaxPayloadInMb() {
                return this.maxPayloadInMb;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("transformInput", om.valueToTree(this.getTransformInput()));
                data.set("transformOutput", om.valueToTree(this.getTransformOutput()));
                data.set("transformResources", om.valueToTree(this.getTransformResources()));
                if (this.getBatchStrategy() != null) {
                    data.set("batchStrategy", om.valueToTree(this.getBatchStrategy()));
                }
                if (this.getEnvironment() != null) {
                    data.set("environment", om.valueToTree(this.getEnvironment()));
                }
                if (this.getMaxConcurrentTransforms() != null) {
                    data.set("maxConcurrentTransforms", om.valueToTree(this.getMaxConcurrentTransforms()));
                }
                if (this.getMaxPayloadInMb() != null) {
                    data.set("maxPayloadInMb", om.valueToTree(this.getMaxPayloadInMb()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.TransformJobDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TransformJobDefinitionProperty.Jsii$Proxy that = (TransformJobDefinitionProperty.Jsii$Proxy) o;

                if (!transformInput.equals(that.transformInput)) return false;
                if (!transformOutput.equals(that.transformOutput)) return false;
                if (!transformResources.equals(that.transformResources)) return false;
                if (this.batchStrategy != null ? !this.batchStrategy.equals(that.batchStrategy) : that.batchStrategy != null) return false;
                if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
                if (this.maxConcurrentTransforms != null ? !this.maxConcurrentTransforms.equals(that.maxConcurrentTransforms) : that.maxConcurrentTransforms != null) return false;
                return this.maxPayloadInMb != null ? this.maxPayloadInMb.equals(that.maxPayloadInMb) : that.maxPayloadInMb == null;
            }

            @Override
            public final int hashCode() {
                int result = this.transformInput.hashCode();
                result = 31 * result + (this.transformOutput.hashCode());
                result = 31 * result + (this.transformResources.hashCode());
                result = 31 * result + (this.batchStrategy != null ? this.batchStrategy.hashCode() : 0);
                result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
                result = 31 * result + (this.maxConcurrentTransforms != null ? this.maxConcurrentTransforms.hashCode() : 0);
                result = 31 * result + (this.maxPayloadInMb != null ? this.maxPayloadInMb.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the results of a transform job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * TransformOutputProperty transformOutputProperty = TransformOutputProperty.builder()
     *         .s3OutputPath("s3OutputPath")
     *         // the properties below are optional
     *         .accept("accept")
     *         .assembleWith("assembleWith")
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.TransformOutputProperty")
    @software.amazon.jsii.Jsii.Proxy(TransformOutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TransformOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 path where you want Amazon SageMaker to store the results of the transform job.
         * <p>
         * For example, <code>s3://bucket-name/key-name-prefix</code> .
         * <p>
         * For every S3 object used as input for the transform job, batch transform stores the transformed data with an . <code>out</code> suffix in a corresponding subfolder in the location in the output prefix. For example, for the input data stored at <code>s3://bucket-name/input-name-prefix/dataset01/data.csv</code> , batch transform stores the transformed data at <code>s3://bucket-name/output-name-prefix/input-name-prefix/data.csv.out</code> . Batch transform doesn't upload partially processed objects. For an input S3 object that contains multiple records, it creates an . <code>out</code> file only if the transform job succeeds on the entire file. When the input contains multiple S3 objects, the batch transform job processes the listed S3 objects and uploads only the output for successfully processed objects. If any object fails in the transform job batch transform marks the job as failed to prompt investigation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3OutputPath();

        /**
         * The MIME type used to specify the output data.
         * <p>
         * Amazon SageMaker uses the MIME type with each http call to transfer data from the transform job.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccept() {
            return null;
        }

        /**
         * Defines how to assemble the results of the transform job as a single S3 object.
         * <p>
         * Choose a format that is most convenient to you. To concatenate the results in binary format, specify <code>None</code> . To add a newline character at the end of every transformed record, specify <code>Line</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAssembleWith() {
            return null;
        }

        /**
         * The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
         * <p>
         * The <code>KmsKeyId</code> can be any of the following formats:
         * <p>
         * <ul>
         * <li>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
         * <li>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
         * <li>Alias name: <code>alias/ExampleAlias</code></li>
         * <li>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code></li>
         * </ul>
         * <p>
         * If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the <em>Amazon Simple Storage Service Developer Guide.</em>
         * <p>
         * The KMS key policy must grant permission to the IAM role that you specify in your <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html">CreateModel</a> request. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using Key Policies in AWS KMS</a> in the <em>AWS Key Management Service Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TransformOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TransformOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TransformOutputProperty> {
            java.lang.String s3OutputPath;
            java.lang.String accept;
            java.lang.String assembleWith;
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link TransformOutputProperty#getS3OutputPath}
             * @param s3OutputPath The Amazon S3 path where you want Amazon SageMaker to store the results of the transform job. This parameter is required.
             *                     For example, <code>s3://bucket-name/key-name-prefix</code> .
             *                     <p>
             *                     For every S3 object used as input for the transform job, batch transform stores the transformed data with an . <code>out</code> suffix in a corresponding subfolder in the location in the output prefix. For example, for the input data stored at <code>s3://bucket-name/input-name-prefix/dataset01/data.csv</code> , batch transform stores the transformed data at <code>s3://bucket-name/output-name-prefix/input-name-prefix/data.csv.out</code> . Batch transform doesn't upload partially processed objects. For an input S3 object that contains multiple records, it creates an . <code>out</code> file only if the transform job succeeds on the entire file. When the input contains multiple S3 objects, the batch transform job processes the listed S3 objects and uploads only the output for successfully processed objects. If any object fails in the transform job batch transform marks the job as failed to prompt investigation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OutputPath(java.lang.String s3OutputPath) {
                this.s3OutputPath = s3OutputPath;
                return this;
            }

            /**
             * Sets the value of {@link TransformOutputProperty#getAccept}
             * @param accept The MIME type used to specify the output data.
             *               Amazon SageMaker uses the MIME type with each http call to transfer data from the transform job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accept(java.lang.String accept) {
                this.accept = accept;
                return this;
            }

            /**
             * Sets the value of {@link TransformOutputProperty#getAssembleWith}
             * @param assembleWith Defines how to assemble the results of the transform job as a single S3 object.
             *                     Choose a format that is most convenient to you. To concatenate the results in binary format, specify <code>None</code> . To add a newline character at the end of every transformed record, specify <code>Line</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assembleWith(java.lang.String assembleWith) {
                this.assembleWith = assembleWith;
                return this;
            }

            /**
             * Sets the value of {@link TransformOutputProperty#getKmsKeyId}
             * @param kmsKeyId The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
             *                 The <code>KmsKeyId</code> can be any of the following formats:
             *                 <p>
             *                 <ul>
             *                 <li>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
             *                 <li>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
             *                 <li>Alias name: <code>alias/ExampleAlias</code></li>
             *                 <li>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code></li>
             *                 </ul>
             *                 <p>
             *                 If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the <em>Amazon Simple Storage Service Developer Guide.</em>
             *                 <p>
             *                 The KMS key policy must grant permission to the IAM role that you specify in your <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html">CreateModel</a> request. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using Key Policies in AWS KMS</a> in the <em>AWS Key Management Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransformOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TransformOutputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TransformOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransformOutputProperty {
            private final java.lang.String s3OutputPath;
            private final java.lang.String accept;
            private final java.lang.String assembleWith;
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3OutputPath = software.amazon.jsii.Kernel.get(this, "s3OutputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accept = software.amazon.jsii.Kernel.get(this, "accept", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.assembleWith = software.amazon.jsii.Kernel.get(this, "assembleWith", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3OutputPath = java.util.Objects.requireNonNull(builder.s3OutputPath, "s3OutputPath is required");
                this.accept = builder.accept;
                this.assembleWith = builder.assembleWith;
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.String getS3OutputPath() {
                return this.s3OutputPath;
            }

            @Override
            public final java.lang.String getAccept() {
                return this.accept;
            }

            @Override
            public final java.lang.String getAssembleWith() {
                return this.assembleWith;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3OutputPath", om.valueToTree(this.getS3OutputPath()));
                if (this.getAccept() != null) {
                    data.set("accept", om.valueToTree(this.getAccept()));
                }
                if (this.getAssembleWith() != null) {
                    data.set("assembleWith", om.valueToTree(this.getAssembleWith()));
                }
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.TransformOutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TransformOutputProperty.Jsii$Proxy that = (TransformOutputProperty.Jsii$Proxy) o;

                if (!s3OutputPath.equals(that.s3OutputPath)) return false;
                if (this.accept != null ? !this.accept.equals(that.accept) : that.accept != null) return false;
                if (this.assembleWith != null ? !this.assembleWith.equals(that.assembleWith) : that.assembleWith != null) return false;
                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3OutputPath.hashCode();
                result = 31 * result + (this.accept != null ? this.accept.hashCode() : 0);
                result = 31 * result + (this.assembleWith != null ? this.assembleWith.hashCode() : 0);
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the resources, including ML instance types and ML instance count, to use for transform job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * TransformResourcesProperty transformResourcesProperty = TransformResourcesProperty.builder()
     *         .instanceCount(123)
     *         .instanceType("instanceType")
     *         // the properties below are optional
     *         .volumeKmsKeyId("volumeKmsKeyId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.TransformResourcesProperty")
    @software.amazon.jsii.Jsii.Proxy(TransformResourcesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TransformResourcesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of ML compute instances to use in the transform job.
         * <p>
         * For distributed transform jobs, specify a value greater than 1. The default value is <code>1</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInstanceCount();

        /**
         * The ML compute instance type for the transform job.
         * <p>
         * If you are using built-in algorithms to transform moderately sized datasets, we recommend using ml.m4.xlarge or <code>ml.m5.large</code> instance types.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

        /**
         * The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt model data on the storage volume attached to the ML compute instance(s) that run the batch transform job.
         * <p>
         * <blockquote>
         * <p>
         * Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a <code>VolumeKmsKeyId</code> when using an instance type with local storage.
         * <p>
         * For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a> .
         * <p>
         * For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a> .
         * <p>
         * </blockquote>
         * <p>
         * The <code>VolumeKmsKeyId</code> can be any of the following formats:
         * <p>
         * <ul>
         * <li>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
         * <li>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
         * <li>Alias name: <code>alias/ExampleAlias</code></li>
         * <li>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code></li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVolumeKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TransformResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TransformResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TransformResourcesProperty> {
            java.lang.Number instanceCount;
            java.lang.String instanceType;
            java.lang.String volumeKmsKeyId;

            /**
             * Sets the value of {@link TransformResourcesProperty#getInstanceCount}
             * @param instanceCount The number of ML compute instances to use in the transform job. This parameter is required.
             *                      For distributed transform jobs, specify a value greater than 1. The default value is <code>1</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceCount(java.lang.Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            /**
             * Sets the value of {@link TransformResourcesProperty#getInstanceType}
             * @param instanceType The ML compute instance type for the transform job. This parameter is required.
             *                     If you are using built-in algorithms to transform moderately sized datasets, we recommend using ml.m4.xlarge or <code>ml.m5.large</code> instance types.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link TransformResourcesProperty#getVolumeKmsKeyId}
             * @param volumeKmsKeyId The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt model data on the storage volume attached to the ML compute instance(s) that run the batch transform job.
             *                       <blockquote>
             *                       <p>
             *                       Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a <code>VolumeKmsKeyId</code> when using an instance type with local storage.
             *                       <p>
             *                       For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a> .
             *                       <p>
             *                       For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a> .
             *                       <p>
             *                       </blockquote>
             *                       <p>
             *                       The <code>VolumeKmsKeyId</code> can be any of the following formats:
             *                       <p>
             *                       <ul>
             *                       <li>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
             *                       <li>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
             *                       <li>Alias name: <code>alias/ExampleAlias</code></li>
             *                       <li>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code></li>
             *                       </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeKmsKeyId(java.lang.String volumeKmsKeyId) {
                this.volumeKmsKeyId = volumeKmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransformResourcesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TransformResourcesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TransformResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransformResourcesProperty {
            private final java.lang.Number instanceCount;
            private final java.lang.String instanceType;
            private final java.lang.String volumeKmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceCount = software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.volumeKmsKeyId = software.amazon.jsii.Kernel.get(this, "volumeKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceCount = java.util.Objects.requireNonNull(builder.instanceCount, "instanceCount is required");
                this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
                this.volumeKmsKeyId = builder.volumeKmsKeyId;
            }

            @Override
            public final java.lang.Number getInstanceCount() {
                return this.instanceCount;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.String getVolumeKmsKeyId() {
                return this.volumeKmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
                if (this.getVolumeKmsKeyId() != null) {
                    data.set("volumeKmsKeyId", om.valueToTree(this.getVolumeKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.TransformResourcesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TransformResourcesProperty.Jsii$Proxy that = (TransformResourcesProperty.Jsii$Proxy) o;

                if (!instanceCount.equals(that.instanceCount)) return false;
                if (!instanceType.equals(that.instanceType)) return false;
                return this.volumeKmsKeyId != null ? this.volumeKmsKeyId.equals(that.volumeKmsKeyId) : that.volumeKmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceCount.hashCode();
                result = 31 * result + (this.instanceType.hashCode());
                result = 31 * result + (this.volumeKmsKeyId != null ? this.volumeKmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * UserContextProperty userContextProperty = UserContextProperty.builder()
     *         .domainId("domainId")
     *         .userProfileArn("userProfileArn")
     *         .userProfileName("userProfileName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.UserContextProperty")
    @software.amazon.jsii.Jsii.Proxy(UserContextProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserContextProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnModelPackage.UserContextProperty.DomainId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDomainId() {
            return null;
        }

        /**
         * `CfnModelPackage.UserContextProperty.UserProfileArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserProfileArn() {
            return null;
        }

        /**
         * `CfnModelPackage.UserContextProperty.UserProfileName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserProfileName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UserContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserContextProperty> {
            java.lang.String domainId;
            java.lang.String userProfileArn;
            java.lang.String userProfileName;

            /**
             * Sets the value of {@link UserContextProperty#getDomainId}
             * @param domainId `CfnModelPackage.UserContextProperty.DomainId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainId(java.lang.String domainId) {
                this.domainId = domainId;
                return this;
            }

            /**
             * Sets the value of {@link UserContextProperty#getUserProfileArn}
             * @param userProfileArn `CfnModelPackage.UserContextProperty.UserProfileArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userProfileArn(java.lang.String userProfileArn) {
                this.userProfileArn = userProfileArn;
                return this;
            }

            /**
             * Sets the value of {@link UserContextProperty#getUserProfileName}
             * @param userProfileName `CfnModelPackage.UserContextProperty.UserProfileName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userProfileName(java.lang.String userProfileName) {
                this.userProfileName = userProfileName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserContextProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserContextProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UserContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserContextProperty {
            private final java.lang.String domainId;
            private final java.lang.String userProfileArn;
            private final java.lang.String userProfileName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainId = software.amazon.jsii.Kernel.get(this, "domainId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userProfileArn = software.amazon.jsii.Kernel.get(this, "userProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userProfileName = software.amazon.jsii.Kernel.get(this, "userProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainId = builder.domainId;
                this.userProfileArn = builder.userProfileArn;
                this.userProfileName = builder.userProfileName;
            }

            @Override
            public final java.lang.String getDomainId() {
                return this.domainId;
            }

            @Override
            public final java.lang.String getUserProfileArn() {
                return this.userProfileArn;
            }

            @Override
            public final java.lang.String getUserProfileName() {
                return this.userProfileName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDomainId() != null) {
                    data.set("domainId", om.valueToTree(this.getDomainId()));
                }
                if (this.getUserProfileArn() != null) {
                    data.set("userProfileArn", om.valueToTree(this.getUserProfileArn()));
                }
                if (this.getUserProfileName() != null) {
                    data.set("userProfileName", om.valueToTree(this.getUserProfileName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.UserContextProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserContextProperty.Jsii$Proxy that = (UserContextProperty.Jsii$Proxy) o;

                if (this.domainId != null ? !this.domainId.equals(that.domainId) : that.domainId != null) return false;
                if (this.userProfileArn != null ? !this.userProfileArn.equals(that.userProfileArn) : that.userProfileArn != null) return false;
                return this.userProfileName != null ? this.userProfileName.equals(that.userProfileName) : that.userProfileName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.domainId != null ? this.domainId.hashCode() : 0;
                result = 31 * result + (this.userProfileArn != null ? this.userProfileArn.hashCode() : 0);
                result = 31 * result + (this.userProfileName != null ? this.userProfileName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * Object environment;
     * ValidationProfileProperty validationProfileProperty = ValidationProfileProperty.builder()
     *         .profileName("profileName")
     *         .transformJobDefinition(TransformJobDefinitionProperty.builder()
     *                 .transformInput(TransformInputProperty.builder()
     *                         .dataSource(DataSourceProperty.builder()
     *                                 .s3DataSource(S3DataSourceProperty.builder()
     *                                         .s3DataType("s3DataType")
     *                                         .s3Uri("s3Uri")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .compressionType("compressionType")
     *                         .contentType("contentType")
     *                         .splitType("splitType")
     *                         .build())
     *                 .transformOutput(TransformOutputProperty.builder()
     *                         .s3OutputPath("s3OutputPath")
     *                         // the properties below are optional
     *                         .accept("accept")
     *                         .assembleWith("assembleWith")
     *                         .kmsKeyId("kmsKeyId")
     *                         .build())
     *                 .transformResources(TransformResourcesProperty.builder()
     *                         .instanceCount(123)
     *                         .instanceType("instanceType")
     *                         // the properties below are optional
     *                         .volumeKmsKeyId("volumeKmsKeyId")
     *                         .build())
     *                 // the properties below are optional
     *                 .batchStrategy("batchStrategy")
     *                 .environment(environment)
     *                 .maxConcurrentTransforms(123)
     *                 .maxPayloadInMb(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.ValidationProfileProperty")
    @software.amazon.jsii.Jsii.Proxy(ValidationProfileProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ValidationProfileProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnModelPackage.ValidationProfileProperty.ProfileName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProfileName();

        /**
         * `CfnModelPackage.ValidationProfileProperty.TransformJobDefinition`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTransformJobDefinition();

        /**
         * @return a {@link Builder} of {@link ValidationProfileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ValidationProfileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ValidationProfileProperty> {
            java.lang.String profileName;
            java.lang.Object transformJobDefinition;

            /**
             * Sets the value of {@link ValidationProfileProperty#getProfileName}
             * @param profileName `CfnModelPackage.ValidationProfileProperty.ProfileName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder profileName(java.lang.String profileName) {
                this.profileName = profileName;
                return this;
            }

            /**
             * Sets the value of {@link ValidationProfileProperty#getTransformJobDefinition}
             * @param transformJobDefinition `CfnModelPackage.ValidationProfileProperty.TransformJobDefinition`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transformJobDefinition(software.amazon.awscdk.core.IResolvable transformJobDefinition) {
                this.transformJobDefinition = transformJobDefinition;
                return this;
            }

            /**
             * Sets the value of {@link ValidationProfileProperty#getTransformJobDefinition}
             * @param transformJobDefinition `CfnModelPackage.ValidationProfileProperty.TransformJobDefinition`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transformJobDefinition(software.amazon.awscdk.services.sagemaker.CfnModelPackage.TransformJobDefinitionProperty transformJobDefinition) {
                this.transformJobDefinition = transformJobDefinition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ValidationProfileProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ValidationProfileProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ValidationProfileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ValidationProfileProperty {
            private final java.lang.String profileName;
            private final java.lang.Object transformJobDefinition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.profileName = software.amazon.jsii.Kernel.get(this, "profileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.transformJobDefinition = software.amazon.jsii.Kernel.get(this, "transformJobDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.profileName = java.util.Objects.requireNonNull(builder.profileName, "profileName is required");
                this.transformJobDefinition = java.util.Objects.requireNonNull(builder.transformJobDefinition, "transformJobDefinition is required");
            }

            @Override
            public final java.lang.String getProfileName() {
                return this.profileName;
            }

            @Override
            public final java.lang.Object getTransformJobDefinition() {
                return this.transformJobDefinition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("profileName", om.valueToTree(this.getProfileName()));
                data.set("transformJobDefinition", om.valueToTree(this.getTransformJobDefinition()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.ValidationProfileProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ValidationProfileProperty.Jsii$Proxy that = (ValidationProfileProperty.Jsii$Proxy) o;

                if (!profileName.equals(that.profileName)) return false;
                return this.transformJobDefinition.equals(that.transformJobDefinition);
            }

            @Override
            public final int hashCode() {
                int result = this.profileName.hashCode();
                result = 31 * result + (this.transformJobDefinition.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * Object environment;
     * ValidationSpecificationProperty validationSpecificationProperty = ValidationSpecificationProperty.builder()
     *         .validationProfiles(List.of(ValidationProfileProperty.builder()
     *                 .profileName("profileName")
     *                 .transformJobDefinition(TransformJobDefinitionProperty.builder()
     *                         .transformInput(TransformInputProperty.builder()
     *                                 .dataSource(DataSourceProperty.builder()
     *                                         .s3DataSource(S3DataSourceProperty.builder()
     *                                                 .s3DataType("s3DataType")
     *                                                 .s3Uri("s3Uri")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .compressionType("compressionType")
     *                                 .contentType("contentType")
     *                                 .splitType("splitType")
     *                                 .build())
     *                         .transformOutput(TransformOutputProperty.builder()
     *                                 .s3OutputPath("s3OutputPath")
     *                                 // the properties below are optional
     *                                 .accept("accept")
     *                                 .assembleWith("assembleWith")
     *                                 .kmsKeyId("kmsKeyId")
     *                                 .build())
     *                         .transformResources(TransformResourcesProperty.builder()
     *                                 .instanceCount(123)
     *                                 .instanceType("instanceType")
     *                                 // the properties below are optional
     *                                 .volumeKmsKeyId("volumeKmsKeyId")
     *                                 .build())
     *                         // the properties below are optional
     *                         .batchStrategy("batchStrategy")
     *                         .environment(environment)
     *                         .maxConcurrentTransforms(123)
     *                         .maxPayloadInMb(123)
     *                         .build())
     *                 .build()))
     *         .validationRole("validationRole")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnModelPackage.ValidationSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(ValidationSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ValidationSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnModelPackage.ValidationSpecificationProperty.ValidationProfiles`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValidationProfiles();

        /**
         * `CfnModelPackage.ValidationSpecificationProperty.ValidationRole`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValidationRole();

        /**
         * @return a {@link Builder} of {@link ValidationSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ValidationSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ValidationSpecificationProperty> {
            java.lang.Object validationProfiles;
            java.lang.String validationRole;

            /**
             * Sets the value of {@link ValidationSpecificationProperty#getValidationProfiles}
             * @param validationProfiles `CfnModelPackage.ValidationSpecificationProperty.ValidationProfiles`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validationProfiles(software.amazon.awscdk.core.IResolvable validationProfiles) {
                this.validationProfiles = validationProfiles;
                return this;
            }

            /**
             * Sets the value of {@link ValidationSpecificationProperty#getValidationProfiles}
             * @param validationProfiles `CfnModelPackage.ValidationSpecificationProperty.ValidationProfiles`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validationProfiles(java.util.List<? extends java.lang.Object> validationProfiles) {
                this.validationProfiles = validationProfiles;
                return this;
            }

            /**
             * Sets the value of {@link ValidationSpecificationProperty#getValidationRole}
             * @param validationRole `CfnModelPackage.ValidationSpecificationProperty.ValidationRole`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validationRole(java.lang.String validationRole) {
                this.validationRole = validationRole;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ValidationSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ValidationSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ValidationSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ValidationSpecificationProperty {
            private final java.lang.Object validationProfiles;
            private final java.lang.String validationRole;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.validationProfiles = software.amazon.jsii.Kernel.get(this, "validationProfiles", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.validationRole = software.amazon.jsii.Kernel.get(this, "validationRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.validationProfiles = java.util.Objects.requireNonNull(builder.validationProfiles, "validationProfiles is required");
                this.validationRole = java.util.Objects.requireNonNull(builder.validationRole, "validationRole is required");
            }

            @Override
            public final java.lang.Object getValidationProfiles() {
                return this.validationProfiles;
            }

            @Override
            public final java.lang.String getValidationRole() {
                return this.validationRole;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("validationProfiles", om.valueToTree(this.getValidationProfiles()));
                data.set("validationRole", om.valueToTree(this.getValidationRole()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnModelPackage.ValidationSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ValidationSpecificationProperty.Jsii$Proxy that = (ValidationSpecificationProperty.Jsii$Proxy) o;

                if (!validationProfiles.equals(that.validationProfiles)) return false;
                return this.validationRole.equals(that.validationRole);
            }

            @Override
            public final int hashCode() {
                int result = this.validationProfiles.hashCode();
                result = 31 * result + (this.validationRole.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnModelPackage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnModelPackage> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.sagemaker.CfnModelPackageProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * `AWS::SageMaker::ModelPackage.AdditionalInferenceSpecificationDefinition`.
         * <p>
         * @return {@code this}
         * @param additionalInferenceSpecificationDefinition `AWS::SageMaker::ModelPackage.AdditionalInferenceSpecificationDefinition`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalInferenceSpecificationDefinition(final software.amazon.awscdk.core.IResolvable additionalInferenceSpecificationDefinition) {
            this.props().additionalInferenceSpecificationDefinition(additionalInferenceSpecificationDefinition);
            return this;
        }
        /**
         * `AWS::SageMaker::ModelPackage.AdditionalInferenceSpecificationDefinition`.
         * <p>
         * @return {@code this}
         * @param additionalInferenceSpecificationDefinition `AWS::SageMaker::ModelPackage.AdditionalInferenceSpecificationDefinition`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalInferenceSpecificationDefinition(final software.amazon.awscdk.services.sagemaker.CfnModelPackage.AdditionalInferenceSpecificationDefinitionProperty additionalInferenceSpecificationDefinition) {
            this.props().additionalInferenceSpecificationDefinition(additionalInferenceSpecificationDefinition);
            return this;
        }

        /**
         * An array of additional Inference Specification objects.
         * <p>
         * @return {@code this}
         * @param additionalInferenceSpecifications An array of additional Inference Specification objects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalInferenceSpecifications(final software.amazon.awscdk.core.IResolvable additionalInferenceSpecifications) {
            this.props().additionalInferenceSpecifications(additionalInferenceSpecifications);
            return this;
        }
        /**
         * An array of additional Inference Specification objects.
         * <p>
         * @return {@code this}
         * @param additionalInferenceSpecifications An array of additional Inference Specification objects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalInferenceSpecifications(final java.util.List<? extends java.lang.Object> additionalInferenceSpecifications) {
            this.props().additionalInferenceSpecifications(additionalInferenceSpecifications);
            return this;
        }

        /**
         * `AWS::SageMaker::ModelPackage.AdditionalInferenceSpecificationsToAdd`.
         * <p>
         * @return {@code this}
         * @param additionalInferenceSpecificationsToAdd `AWS::SageMaker::ModelPackage.AdditionalInferenceSpecificationsToAdd`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalInferenceSpecificationsToAdd(final software.amazon.awscdk.core.IResolvable additionalInferenceSpecificationsToAdd) {
            this.props().additionalInferenceSpecificationsToAdd(additionalInferenceSpecificationsToAdd);
            return this;
        }
        /**
         * `AWS::SageMaker::ModelPackage.AdditionalInferenceSpecificationsToAdd`.
         * <p>
         * @return {@code this}
         * @param additionalInferenceSpecificationsToAdd `AWS::SageMaker::ModelPackage.AdditionalInferenceSpecificationsToAdd`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalInferenceSpecificationsToAdd(final java.util.List<? extends java.lang.Object> additionalInferenceSpecificationsToAdd) {
            this.props().additionalInferenceSpecificationsToAdd(additionalInferenceSpecificationsToAdd);
            return this;
        }

        /**
         * A description provided when the model approval is set.
         * <p>
         * @return {@code this}
         * @param approvalDescription A description provided when the model approval is set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder approvalDescription(final java.lang.String approvalDescription) {
            this.props().approvalDescription(approvalDescription);
            return this;
        }

        /**
         * Whether the model package is to be certified to be listed on AWS Marketplace.
         * <p>
         * For information about listing model packages on AWS Marketplace, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html">List Your Algorithm or Model Package on AWS Marketplace</a> .
         * <p>
         * @return {@code this}
         * @param certifyForMarketplace Whether the model package is to be certified to be listed on AWS Marketplace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certifyForMarketplace(final java.lang.Boolean certifyForMarketplace) {
            this.props().certifyForMarketplace(certifyForMarketplace);
            return this;
        }
        /**
         * Whether the model package is to be certified to be listed on AWS Marketplace.
         * <p>
         * For information about listing model packages on AWS Marketplace, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html">List Your Algorithm or Model Package on AWS Marketplace</a> .
         * <p>
         * @return {@code this}
         * @param certifyForMarketplace Whether the model package is to be certified to be listed on AWS Marketplace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certifyForMarketplace(final software.amazon.awscdk.core.IResolvable certifyForMarketplace) {
            this.props().certifyForMarketplace(certifyForMarketplace);
            return this;
        }

        /**
         * `AWS::SageMaker::ModelPackage.ClientToken`.
         * <p>
         * @return {@code this}
         * @param clientToken `AWS::SageMaker::ModelPackage.ClientToken`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientToken(final java.lang.String clientToken) {
            this.props().clientToken(clientToken);
            return this;
        }

        /**
         * `AWS::SageMaker::ModelPackage.CreatedBy`.
         * <p>
         * @return {@code this}
         * @param createdBy `AWS::SageMaker::ModelPackage.CreatedBy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createdBy(final software.amazon.awscdk.core.IResolvable createdBy) {
            this.props().createdBy(createdBy);
            return this;
        }
        /**
         * `AWS::SageMaker::ModelPackage.CreatedBy`.
         * <p>
         * @return {@code this}
         * @param createdBy `AWS::SageMaker::ModelPackage.CreatedBy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createdBy(final software.amazon.awscdk.services.sagemaker.CfnModelPackage.UserContextProperty createdBy) {
            this.props().createdBy(createdBy);
            return this;
        }

        /**
         * The metadata properties for the model package.
         * <p>
         * @return {@code this}
         * @param customerMetadataProperties The metadata properties for the model package. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerMetadataProperties(final software.amazon.awscdk.core.IResolvable customerMetadataProperties) {
            this.props().customerMetadataProperties(customerMetadataProperties);
            return this;
        }
        /**
         * The metadata properties for the model package.
         * <p>
         * @return {@code this}
         * @param customerMetadataProperties The metadata properties for the model package. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerMetadataProperties(final java.util.Map<java.lang.String, java.lang.String> customerMetadataProperties) {
            this.props().customerMetadataProperties(customerMetadataProperties);
            return this;
        }

        /**
         * The machine learning domain of your model package and its components.
         * <p>
         * Common machine learning domains include computer vision and natural language processing.
         * <p>
         * @return {@code this}
         * @param domain The machine learning domain of your model package and its components. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(final java.lang.String domain) {
            this.props().domain(domain);
            return this;
        }

        /**
         * Represents the drift check baselines that can be used when the model monitor is set using the model package.
         * <p>
         * @return {@code this}
         * @param driftCheckBaselines Represents the drift check baselines that can be used when the model monitor is set using the model package. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder driftCheckBaselines(final software.amazon.awscdk.core.IResolvable driftCheckBaselines) {
            this.props().driftCheckBaselines(driftCheckBaselines);
            return this;
        }
        /**
         * Represents the drift check baselines that can be used when the model monitor is set using the model package.
         * <p>
         * @return {@code this}
         * @param driftCheckBaselines Represents the drift check baselines that can be used when the model monitor is set using the model package. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder driftCheckBaselines(final software.amazon.awscdk.services.sagemaker.CfnModelPackage.DriftCheckBaselinesProperty driftCheckBaselines) {
            this.props().driftCheckBaselines(driftCheckBaselines);
            return this;
        }

        /**
         * The environment variables to set in the Docker container.
         * <p>
         * Each key and value in the <code>Environment</code> string to string map can have length of up to 1024. We support up to 16 entries in the map.
         * <p>
         * @return {@code this}
         * @param environment The environment variables to set in the Docker container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final software.amazon.awscdk.core.IResolvable environment) {
            this.props().environment(environment);
            return this;
        }
        /**
         * The environment variables to set in the Docker container.
         * <p>
         * Each key and value in the <code>Environment</code> string to string map can have length of up to 1024. We support up to 16 entries in the map.
         * <p>
         * @return {@code this}
         * @param environment The environment variables to set in the Docker container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final java.util.Map<java.lang.String, java.lang.String> environment) {
            this.props().environment(environment);
            return this;
        }

        /**
         * `AWS::SageMaker::ModelPackage.InferenceSpecification`.
         * <p>
         * @return {@code this}
         * @param inferenceSpecification `AWS::SageMaker::ModelPackage.InferenceSpecification`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceSpecification(final software.amazon.awscdk.core.IResolvable inferenceSpecification) {
            this.props().inferenceSpecification(inferenceSpecification);
            return this;
        }
        /**
         * `AWS::SageMaker::ModelPackage.InferenceSpecification`.
         * <p>
         * @return {@code this}
         * @param inferenceSpecification `AWS::SageMaker::ModelPackage.InferenceSpecification`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceSpecification(final software.amazon.awscdk.services.sagemaker.CfnModelPackage.InferenceSpecificationProperty inferenceSpecification) {
            this.props().inferenceSpecification(inferenceSpecification);
            return this;
        }

        /**
         * `AWS::SageMaker::ModelPackage.LastModifiedBy`.
         * <p>
         * @return {@code this}
         * @param lastModifiedBy `AWS::SageMaker::ModelPackage.LastModifiedBy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lastModifiedBy(final software.amazon.awscdk.core.IResolvable lastModifiedBy) {
            this.props().lastModifiedBy(lastModifiedBy);
            return this;
        }
        /**
         * `AWS::SageMaker::ModelPackage.LastModifiedBy`.
         * <p>
         * @return {@code this}
         * @param lastModifiedBy `AWS::SageMaker::ModelPackage.LastModifiedBy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lastModifiedBy(final software.amazon.awscdk.services.sagemaker.CfnModelPackage.UserContextProperty lastModifiedBy) {
            this.props().lastModifiedBy(lastModifiedBy);
            return this;
        }

        /**
         * The last time the model package was modified.
         * <p>
         * @return {@code this}
         * @param lastModifiedTime The last time the model package was modified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lastModifiedTime(final java.lang.String lastModifiedTime) {
            this.props().lastModifiedTime(lastModifiedTime);
            return this;
        }

        /**
         * `AWS::SageMaker::ModelPackage.MetadataProperties`.
         * <p>
         * @return {@code this}
         * @param metadataProperties `AWS::SageMaker::ModelPackage.MetadataProperties`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadataProperties(final software.amazon.awscdk.core.IResolvable metadataProperties) {
            this.props().metadataProperties(metadataProperties);
            return this;
        }
        /**
         * `AWS::SageMaker::ModelPackage.MetadataProperties`.
         * <p>
         * @return {@code this}
         * @param metadataProperties `AWS::SageMaker::ModelPackage.MetadataProperties`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadataProperties(final software.amazon.awscdk.services.sagemaker.CfnModelPackage.MetadataPropertiesProperty metadataProperties) {
            this.props().metadataProperties(metadataProperties);
            return this;
        }

        /**
         * The approval status of the model. This can be one of the following values.
         * <p>
         * <ul>
         * <li><code>APPROVED</code> - The model is approved</li>
         * <li><code>REJECTED</code> - The model is rejected.</li>
         * <li><code>PENDING_MANUAL_APPROVAL</code> - The model is waiting for manual approval.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param modelApprovalStatus The approval status of the model. This can be one of the following values. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelApprovalStatus(final java.lang.String modelApprovalStatus) {
            this.props().modelApprovalStatus(modelApprovalStatus);
            return this;
        }

        /**
         * Metrics for the model.
         * <p>
         * @return {@code this}
         * @param modelMetrics Metrics for the model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelMetrics(final software.amazon.awscdk.core.IResolvable modelMetrics) {
            this.props().modelMetrics(modelMetrics);
            return this;
        }
        /**
         * Metrics for the model.
         * <p>
         * @return {@code this}
         * @param modelMetrics Metrics for the model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelMetrics(final software.amazon.awscdk.services.sagemaker.CfnModelPackage.ModelMetricsProperty modelMetrics) {
            this.props().modelMetrics(modelMetrics);
            return this;
        }

        /**
         * The description of the model package.
         * <p>
         * @return {@code this}
         * @param modelPackageDescription The description of the model package. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelPackageDescription(final java.lang.String modelPackageDescription) {
            this.props().modelPackageDescription(modelPackageDescription);
            return this;
        }

        /**
         * The model group to which the model belongs.
         * <p>
         * @return {@code this}
         * @param modelPackageGroupName The model group to which the model belongs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelPackageGroupName(final java.lang.String modelPackageGroupName) {
            this.props().modelPackageGroupName(modelPackageGroupName);
            return this;
        }

        /**
         * The name of the model.
         * <p>
         * @return {@code this}
         * @param modelPackageName The name of the model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelPackageName(final java.lang.String modelPackageName) {
            this.props().modelPackageName(modelPackageName);
            return this;
        }

        /**
         * `AWS::SageMaker::ModelPackage.ModelPackageStatusDetails`.
         * <p>
         * @return {@code this}
         * @param modelPackageStatusDetails `AWS::SageMaker::ModelPackage.ModelPackageStatusDetails`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelPackageStatusDetails(final software.amazon.awscdk.core.IResolvable modelPackageStatusDetails) {
            this.props().modelPackageStatusDetails(modelPackageStatusDetails);
            return this;
        }
        /**
         * `AWS::SageMaker::ModelPackage.ModelPackageStatusDetails`.
         * <p>
         * @return {@code this}
         * @param modelPackageStatusDetails `AWS::SageMaker::ModelPackage.ModelPackageStatusDetails`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelPackageStatusDetails(final software.amazon.awscdk.services.sagemaker.CfnModelPackage.ModelPackageStatusDetailsProperty modelPackageStatusDetails) {
            this.props().modelPackageStatusDetails(modelPackageStatusDetails);
            return this;
        }

        /**
         * `AWS::SageMaker::ModelPackage.ModelPackageStatusItem`.
         * <p>
         * @return {@code this}
         * @param modelPackageStatusItem `AWS::SageMaker::ModelPackage.ModelPackageStatusItem`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelPackageStatusItem(final software.amazon.awscdk.core.IResolvable modelPackageStatusItem) {
            this.props().modelPackageStatusItem(modelPackageStatusItem);
            return this;
        }
        /**
         * `AWS::SageMaker::ModelPackage.ModelPackageStatusItem`.
         * <p>
         * @return {@code this}
         * @param modelPackageStatusItem `AWS::SageMaker::ModelPackage.ModelPackageStatusItem`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelPackageStatusItem(final software.amazon.awscdk.services.sagemaker.CfnModelPackage.ModelPackageStatusItemProperty modelPackageStatusItem) {
            this.props().modelPackageStatusItem(modelPackageStatusItem);
            return this;
        }

        /**
         * The version number of a versioned model.
         * <p>
         * @return {@code this}
         * @param modelPackageVersion The version number of a versioned model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelPackageVersion(final java.lang.Number modelPackageVersion) {
            this.props().modelPackageVersion(modelPackageVersion);
            return this;
        }

        /**
         * The Amazon Simple Storage Service path where the sample payload are stored.
         * <p>
         * This path must point to a single gzip compressed tar archive (.tar.gz suffix).
         * <p>
         * @return {@code this}
         * @param samplePayloadUrl The Amazon Simple Storage Service path where the sample payload are stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samplePayloadUrl(final java.lang.String samplePayloadUrl) {
            this.props().samplePayloadUrl(samplePayloadUrl);
            return this;
        }

        /**
         * `AWS::SageMaker::ModelPackage.SourceAlgorithmSpecification`.
         * <p>
         * @return {@code this}
         * @param sourceAlgorithmSpecification `AWS::SageMaker::ModelPackage.SourceAlgorithmSpecification`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceAlgorithmSpecification(final software.amazon.awscdk.core.IResolvable sourceAlgorithmSpecification) {
            this.props().sourceAlgorithmSpecification(sourceAlgorithmSpecification);
            return this;
        }
        /**
         * `AWS::SageMaker::ModelPackage.SourceAlgorithmSpecification`.
         * <p>
         * @return {@code this}
         * @param sourceAlgorithmSpecification `AWS::SageMaker::ModelPackage.SourceAlgorithmSpecification`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceAlgorithmSpecification(final software.amazon.awscdk.services.sagemaker.CfnModelPackage.SourceAlgorithmSpecificationProperty sourceAlgorithmSpecification) {
            this.props().sourceAlgorithmSpecification(sourceAlgorithmSpecification);
            return this;
        }

        /**
         * A list of the tags associated with the model package.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> in the <em>AWS General Reference Guide</em> .
         * <p>
         * @return {@code this}
         * @param tags A list of the tags associated with the model package. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The machine learning task your model package accomplishes.
         * <p>
         * Common machine learning tasks include object detection and image classification.
         * <p>
         * @return {@code this}
         * @param task The machine learning task your model package accomplishes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder task(final java.lang.String task) {
            this.props().task(task);
            return this;
        }

        /**
         * `AWS::SageMaker::ModelPackage.ValidationSpecification`.
         * <p>
         * @return {@code this}
         * @param validationSpecification `AWS::SageMaker::ModelPackage.ValidationSpecification`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationSpecification(final software.amazon.awscdk.core.IResolvable validationSpecification) {
            this.props().validationSpecification(validationSpecification);
            return this;
        }
        /**
         * `AWS::SageMaker::ModelPackage.ValidationSpecification`.
         * <p>
         * @return {@code this}
         * @param validationSpecification `AWS::SageMaker::ModelPackage.ValidationSpecification`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationSpecification(final software.amazon.awscdk.services.sagemaker.CfnModelPackage.ValidationSpecificationProperty validationSpecification) {
            this.props().validationSpecification(validationSpecification);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnModelPackage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnModelPackage build() {
            return new software.amazon.awscdk.services.sagemaker.CfnModelPackage(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.sagemaker.CfnModelPackageProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.sagemaker.CfnModelPackageProps.Builder();
            }
            return this.props;
        }
    }
}
