package software.amazon.awscdk.services.sagemaker;

/**
 * A CloudFormation `AWS::SageMaker::Project`.
 * <p>
 * Creates a machine learning (ML) project that can contain one or more templates that set up an ML pipeline from training to deploying an approved model.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnProject cfnProject = CfnProject.Builder.create(this, "MyCfnProject")
 *         .projectName("projectName")
 *         .serviceCatalogProvisioningDetails(ServiceCatalogProvisioningDetailsProperty.builder()
 *                 .productId("productId")
 *                 // the properties below are optional
 *                 .pathId("pathId")
 *                 .provisioningArtifactId("provisioningArtifactId")
 *                 .provisioningParameters(List.of(ProvisioningParameterProperty.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         // the properties below are optional
 *         .projectDescription("projectDescription")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-21T20:56:23.242Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnProject")
public class CfnProject extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnProject(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnProject(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnProject.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::SageMaker::Project`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnProject(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnProjectProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The time that the project was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrProjectArn() {
        return software.amazon.jsii.Kernel.get(this, "attrProjectArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the project.
     * <p>
     * This ID is prepended to all entities associated with this project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrProjectId() {
        return software.amazon.jsii.Kernel.get(this, "attrProjectId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrProjectStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrProjectStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServiceCatalogProvisionedProductDetailsProvisionedProductId() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceCatalogProvisionedProductDetailsProvisionedProductId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServiceCatalogProvisionedProductDetailsProvisionedProductStatusMessage() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceCatalogProvisionedProductDetailsProvisionedProductStatusMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource Tag</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <em>AWS Billing and Cost Management User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The name of the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProjectName() {
        return software.amazon.jsii.Kernel.get(this, "projectName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProjectName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "projectName", java.util.Objects.requireNonNull(value, "projectName is required"));
    }

    /**
     * The product ID and provisioning artifact ID to provision a service catalog.
     * <p>
     * For information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is AWS Service Catalog</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getServiceCatalogProvisioningDetails() {
        return software.amazon.jsii.Kernel.get(this, "serviceCatalogProvisioningDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The product ID and provisioning artifact ID to provision a service catalog.
     * <p>
     * For information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is AWS Service Catalog</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceCatalogProvisioningDetails(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "serviceCatalogProvisioningDetails", java.util.Objects.requireNonNull(value, "serviceCatalogProvisioningDetails is required"));
    }

    /**
     * The product ID and provisioning artifact ID to provision a service catalog.
     * <p>
     * For information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is AWS Service Catalog</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceCatalogProvisioningDetails(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnProject.ServiceCatalogProvisioningDetailsProperty value) {
        software.amazon.jsii.Kernel.set(this, "serviceCatalogProvisioningDetails", java.util.Objects.requireNonNull(value, "serviceCatalogProvisioningDetails is required"));
    }

    /**
     * The description of the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getProjectDescription() {
        return software.amazon.jsii.Kernel.get(this, "projectDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProjectDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "projectDescription", value);
    }
    /**
     * A key value pair used when you provision a project as a service catalog product.
     * <p>
     * For information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is AWS Service Catalog</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ProvisioningParameterProperty provisioningParameterProperty = ProvisioningParameterProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnProject.ProvisioningParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(ProvisioningParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProvisioningParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key that identifies a provisioning parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value of the provisioning parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link ProvisioningParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProvisioningParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProvisioningParameterProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link ProvisioningParameterProperty#getKey}
             * @param key The key that identifies a provisioning parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link ProvisioningParameterProperty#getValue}
             * @param value The value of the provisioning parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProvisioningParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProvisioningParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProvisioningParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProvisioningParameterProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnProject.ProvisioningParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProvisioningParameterProperty.Jsii$Proxy that = (ProvisioningParameterProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Details of a provisioned service catalog product.
     * <p>
     * For information about service catalog, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is AWS Service Catalog</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ServiceCatalogProvisionedProductDetailsProperty serviceCatalogProvisionedProductDetailsProperty = ServiceCatalogProvisionedProductDetailsProperty.builder()
     *         .provisionedProductId("provisionedProductId")
     *         .provisionedProductStatusMessage("provisionedProductStatusMessage")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnProject.ServiceCatalogProvisionedProductDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceCatalogProvisionedProductDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceCatalogProvisionedProductDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the provisioned product.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProvisionedProductId() {
            return null;
        }

        /**
         * The current status of the product.
         * <p>
         * <ul>
         * <li><code>AVAILABLE</code> - Stable state, ready to perform any operation. The most recent operation succeeded and completed.</li>
         * <li><code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results. Wait for an AVAILABLE status before performing operations.</li>
         * <li><code>TAINTED</code> - Stable state, ready to perform any operation. The stack has completed the requested operation but is not exactly what was requested. For example, a request to update to a new version failed and the stack rolled back to the current version.</li>
         * <li><code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not running. For example, CloudFormation received a parameter value that was not valid and could not launch the stack.</li>
         * <li><code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new product, but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an AVAILABLE status before performing operations.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProvisionedProductStatusMessage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceCatalogProvisionedProductDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceCatalogProvisionedProductDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceCatalogProvisionedProductDetailsProperty> {
            java.lang.String provisionedProductId;
            java.lang.String provisionedProductStatusMessage;

            /**
             * Sets the value of {@link ServiceCatalogProvisionedProductDetailsProperty#getProvisionedProductId}
             * @param provisionedProductId The ID of the provisioned product.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisionedProductId(java.lang.String provisionedProductId) {
                this.provisionedProductId = provisionedProductId;
                return this;
            }

            /**
             * Sets the value of {@link ServiceCatalogProvisionedProductDetailsProperty#getProvisionedProductStatusMessage}
             * @param provisionedProductStatusMessage The current status of the product.
             *                                        <ul>
             *                                        <li><code>AVAILABLE</code> - Stable state, ready to perform any operation. The most recent operation succeeded and completed.</li>
             *                                        <li><code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results. Wait for an AVAILABLE status before performing operations.</li>
             *                                        <li><code>TAINTED</code> - Stable state, ready to perform any operation. The stack has completed the requested operation but is not exactly what was requested. For example, a request to update to a new version failed and the stack rolled back to the current version.</li>
             *                                        <li><code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not running. For example, CloudFormation received a parameter value that was not valid and could not launch the stack.</li>
             *                                        <li><code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new product, but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an AVAILABLE status before performing operations.</li>
             *                                        </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisionedProductStatusMessage(java.lang.String provisionedProductStatusMessage) {
                this.provisionedProductStatusMessage = provisionedProductStatusMessage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceCatalogProvisionedProductDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceCatalogProvisionedProductDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceCatalogProvisionedProductDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceCatalogProvisionedProductDetailsProperty {
            private final java.lang.String provisionedProductId;
            private final java.lang.String provisionedProductStatusMessage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.provisionedProductId = software.amazon.jsii.Kernel.get(this, "provisionedProductId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.provisionedProductStatusMessage = software.amazon.jsii.Kernel.get(this, "provisionedProductStatusMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.provisionedProductId = builder.provisionedProductId;
                this.provisionedProductStatusMessage = builder.provisionedProductStatusMessage;
            }

            @Override
            public final java.lang.String getProvisionedProductId() {
                return this.provisionedProductId;
            }

            @Override
            public final java.lang.String getProvisionedProductStatusMessage() {
                return this.provisionedProductStatusMessage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getProvisionedProductId() != null) {
                    data.set("provisionedProductId", om.valueToTree(this.getProvisionedProductId()));
                }
                if (this.getProvisionedProductStatusMessage() != null) {
                    data.set("provisionedProductStatusMessage", om.valueToTree(this.getProvisionedProductStatusMessage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnProject.ServiceCatalogProvisionedProductDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceCatalogProvisionedProductDetailsProperty.Jsii$Proxy that = (ServiceCatalogProvisionedProductDetailsProperty.Jsii$Proxy) o;

                if (this.provisionedProductId != null ? !this.provisionedProductId.equals(that.provisionedProductId) : that.provisionedProductId != null) return false;
                return this.provisionedProductStatusMessage != null ? this.provisionedProductStatusMessage.equals(that.provisionedProductStatusMessage) : that.provisionedProductStatusMessage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.provisionedProductId != null ? this.provisionedProductId.hashCode() : 0;
                result = 31 * result + (this.provisionedProductStatusMessage != null ? this.provisionedProductStatusMessage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details that you specify to provision a service catalog product.
     * <p>
     * For information about service catalog, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is AWS Service Catalog</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ServiceCatalogProvisioningDetailsProperty serviceCatalogProvisioningDetailsProperty = ServiceCatalogProvisioningDetailsProperty.builder()
     *         .productId("productId")
     *         // the properties below are optional
     *         .pathId("pathId")
     *         .provisioningArtifactId("provisioningArtifactId")
     *         .provisioningParameters(List.of(ProvisioningParameterProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnProject.ServiceCatalogProvisioningDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceCatalogProvisioningDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceCatalogProvisioningDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the product to provision.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProductId();

        /**
         * The path identifier of the product.
         * <p>
         * This value is optional if the product has a default path, and required if the product has more than one path.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPathId() {
            return null;
        }

        /**
         * The ID of the provisioning artifact.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProvisioningArtifactId() {
            return null;
        }

        /**
         * A list of key value pairs that you specify when you provision a product.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProvisioningParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceCatalogProvisioningDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceCatalogProvisioningDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceCatalogProvisioningDetailsProperty> {
            java.lang.String productId;
            java.lang.String pathId;
            java.lang.String provisioningArtifactId;
            java.lang.Object provisioningParameters;

            /**
             * Sets the value of {@link ServiceCatalogProvisioningDetailsProperty#getProductId}
             * @param productId The ID of the product to provision. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder productId(java.lang.String productId) {
                this.productId = productId;
                return this;
            }

            /**
             * Sets the value of {@link ServiceCatalogProvisioningDetailsProperty#getPathId}
             * @param pathId The path identifier of the product.
             *               This value is optional if the product has a default path, and required if the product has more than one path.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pathId(java.lang.String pathId) {
                this.pathId = pathId;
                return this;
            }

            /**
             * Sets the value of {@link ServiceCatalogProvisioningDetailsProperty#getProvisioningArtifactId}
             * @param provisioningArtifactId The ID of the provisioning artifact.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisioningArtifactId(java.lang.String provisioningArtifactId) {
                this.provisioningArtifactId = provisioningArtifactId;
                return this;
            }

            /**
             * Sets the value of {@link ServiceCatalogProvisioningDetailsProperty#getProvisioningParameters}
             * @param provisioningParameters A list of key value pairs that you specify when you provision a product.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisioningParameters(software.amazon.awscdk.core.IResolvable provisioningParameters) {
                this.provisioningParameters = provisioningParameters;
                return this;
            }

            /**
             * Sets the value of {@link ServiceCatalogProvisioningDetailsProperty#getProvisioningParameters}
             * @param provisioningParameters A list of key value pairs that you specify when you provision a product.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisioningParameters(java.util.List<? extends java.lang.Object> provisioningParameters) {
                this.provisioningParameters = provisioningParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceCatalogProvisioningDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceCatalogProvisioningDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceCatalogProvisioningDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceCatalogProvisioningDetailsProperty {
            private final java.lang.String productId;
            private final java.lang.String pathId;
            private final java.lang.String provisioningArtifactId;
            private final java.lang.Object provisioningParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.productId = software.amazon.jsii.Kernel.get(this, "productId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pathId = software.amazon.jsii.Kernel.get(this, "pathId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.provisioningArtifactId = software.amazon.jsii.Kernel.get(this, "provisioningArtifactId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.provisioningParameters = software.amazon.jsii.Kernel.get(this, "provisioningParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.productId = java.util.Objects.requireNonNull(builder.productId, "productId is required");
                this.pathId = builder.pathId;
                this.provisioningArtifactId = builder.provisioningArtifactId;
                this.provisioningParameters = builder.provisioningParameters;
            }

            @Override
            public final java.lang.String getProductId() {
                return this.productId;
            }

            @Override
            public final java.lang.String getPathId() {
                return this.pathId;
            }

            @Override
            public final java.lang.String getProvisioningArtifactId() {
                return this.provisioningArtifactId;
            }

            @Override
            public final java.lang.Object getProvisioningParameters() {
                return this.provisioningParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("productId", om.valueToTree(this.getProductId()));
                if (this.getPathId() != null) {
                    data.set("pathId", om.valueToTree(this.getPathId()));
                }
                if (this.getProvisioningArtifactId() != null) {
                    data.set("provisioningArtifactId", om.valueToTree(this.getProvisioningArtifactId()));
                }
                if (this.getProvisioningParameters() != null) {
                    data.set("provisioningParameters", om.valueToTree(this.getProvisioningParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnProject.ServiceCatalogProvisioningDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceCatalogProvisioningDetailsProperty.Jsii$Proxy that = (ServiceCatalogProvisioningDetailsProperty.Jsii$Proxy) o;

                if (!productId.equals(that.productId)) return false;
                if (this.pathId != null ? !this.pathId.equals(that.pathId) : that.pathId != null) return false;
                if (this.provisioningArtifactId != null ? !this.provisioningArtifactId.equals(that.provisioningArtifactId) : that.provisioningArtifactId != null) return false;
                return this.provisioningParameters != null ? this.provisioningParameters.equals(that.provisioningParameters) : that.provisioningParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.productId.hashCode();
                result = 31 * result + (this.pathId != null ? this.pathId.hashCode() : 0);
                result = 31 * result + (this.provisioningArtifactId != null ? this.provisioningArtifactId.hashCode() : 0);
                result = 31 * result + (this.provisioningParameters != null ? this.provisioningParameters.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnProject}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnProject> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnProjectProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnProjectProps.Builder();
        }

        /**
         * The name of the project.
         * <p>
         * @return {@code this}
         * @param projectName The name of the project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectName(final java.lang.String projectName) {
            this.props.projectName(projectName);
            return this;
        }

        /**
         * The product ID and provisioning artifact ID to provision a service catalog.
         * <p>
         * For information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is AWS Service Catalog</a> .
         * <p>
         * @return {@code this}
         * @param serviceCatalogProvisioningDetails The product ID and provisioning artifact ID to provision a service catalog. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceCatalogProvisioningDetails(final software.amazon.awscdk.core.IResolvable serviceCatalogProvisioningDetails) {
            this.props.serviceCatalogProvisioningDetails(serviceCatalogProvisioningDetails);
            return this;
        }
        /**
         * The product ID and provisioning artifact ID to provision a service catalog.
         * <p>
         * For information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is AWS Service Catalog</a> .
         * <p>
         * @return {@code this}
         * @param serviceCatalogProvisioningDetails The product ID and provisioning artifact ID to provision a service catalog. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceCatalogProvisioningDetails(final software.amazon.awscdk.services.sagemaker.CfnProject.ServiceCatalogProvisioningDetailsProperty serviceCatalogProvisioningDetails) {
            this.props.serviceCatalogProvisioningDetails(serviceCatalogProvisioningDetails);
            return this;
        }

        /**
         * The description of the project.
         * <p>
         * @return {@code this}
         * @param projectDescription The description of the project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectDescription(final java.lang.String projectDescription) {
            this.props.projectDescription(projectDescription);
            return this;
        }

        /**
         * A list of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource Tag</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <em>AWS Billing and Cost Management User Guide</em> .
         * <p>
         * @return {@code this}
         * @param tags A list of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnProject}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnProject build() {
            return new software.amazon.awscdk.services.sagemaker.CfnProject(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
