package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a `CfnAppImageConfig`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnAppImageConfigProps cfnAppImageConfigProps = CfnAppImageConfigProps.builder()
 *         .appImageConfigName("appImageConfigName")
 *         // the properties below are optional
 *         .kernelGatewayImageConfig(KernelGatewayImageConfigProperty.builder()
 *                 .kernelSpecs(List.of(KernelSpecProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .displayName("displayName")
 *                         .build()))
 *                 // the properties below are optional
 *                 .fileSystemConfig(FileSystemConfigProperty.builder()
 *                         .defaultGid(123)
 *                         .defaultUid(123)
 *                         .mountPath("mountPath")
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-23T19:56:53.243Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnAppImageConfigProps")
@software.amazon.jsii.Jsii.Proxy(CfnAppImageConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAppImageConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the AppImageConfig.
     * <p>
     * Must be unique to your account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAppImageConfigName();

    /**
     * The configuration for the file system and kernels in the SageMaker image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getKernelGatewayImageConfig() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAppImageConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAppImageConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAppImageConfigProps> {
        java.lang.String appImageConfigName;
        java.lang.Object kernelGatewayImageConfig;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnAppImageConfigProps#getAppImageConfigName}
         * @param appImageConfigName The name of the AppImageConfig. This parameter is required.
         *                           Must be unique to your account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appImageConfigName(java.lang.String appImageConfigName) {
            this.appImageConfigName = appImageConfigName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppImageConfigProps#getKernelGatewayImageConfig}
         * @param kernelGatewayImageConfig The configuration for the file system and kernels in the SageMaker image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kernelGatewayImageConfig(software.amazon.awscdk.core.IResolvable kernelGatewayImageConfig) {
            this.kernelGatewayImageConfig = kernelGatewayImageConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppImageConfigProps#getKernelGatewayImageConfig}
         * @param kernelGatewayImageConfig The configuration for the file system and kernels in the SageMaker image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kernelGatewayImageConfig(software.amazon.awscdk.services.sagemaker.CfnAppImageConfig.KernelGatewayImageConfigProperty kernelGatewayImageConfig) {
            this.kernelGatewayImageConfig = kernelGatewayImageConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppImageConfigProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAppImageConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAppImageConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAppImageConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAppImageConfigProps {
        private final java.lang.String appImageConfigName;
        private final java.lang.Object kernelGatewayImageConfig;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.appImageConfigName = software.amazon.jsii.Kernel.get(this, "appImageConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kernelGatewayImageConfig = software.amazon.jsii.Kernel.get(this, "kernelGatewayImageConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.appImageConfigName = java.util.Objects.requireNonNull(builder.appImageConfigName, "appImageConfigName is required");
            this.kernelGatewayImageConfig = builder.kernelGatewayImageConfig;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAppImageConfigName() {
            return this.appImageConfigName;
        }

        @Override
        public final java.lang.Object getKernelGatewayImageConfig() {
            return this.kernelGatewayImageConfig;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("appImageConfigName", om.valueToTree(this.getAppImageConfigName()));
            if (this.getKernelGatewayImageConfig() != null) {
                data.set("kernelGatewayImageConfig", om.valueToTree(this.getKernelGatewayImageConfig()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnAppImageConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAppImageConfigProps.Jsii$Proxy that = (CfnAppImageConfigProps.Jsii$Proxy) o;

            if (!appImageConfigName.equals(that.appImageConfigName)) return false;
            if (this.kernelGatewayImageConfig != null ? !this.kernelGatewayImageConfig.equals(that.kernelGatewayImageConfig) : that.kernelGatewayImageConfig != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.appImageConfigName.hashCode();
            result = 31 * result + (this.kernelGatewayImageConfig != null ? this.kernelGatewayImageConfig.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
