package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a `CfnDomain`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnDomainProps cfnDomainProps = CfnDomainProps.builder()
 *         .authMode("authMode")
 *         .defaultUserSettings(UserSettingsProperty.builder()
 *                 .executionRole("executionRole")
 *                 .jupyterServerAppSettings(JupyterServerAppSettingsProperty.builder()
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .build())
 *                 .kernelGatewayAppSettings(KernelGatewayAppSettingsProperty.builder()
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .build())
 *                 .rSessionAppSettings(RSessionAppSettingsProperty.builder()
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .build())
 *                 .rStudioServerProAppSettings(RStudioServerProAppSettingsProperty.builder()
 *                         .accessStatus("accessStatus")
 *                         .userGroup("userGroup")
 *                         .build())
 *                 .securityGroups(List.of("securityGroups"))
 *                 .sharingSettings(SharingSettingsProperty.builder()
 *                         .notebookOutputOption("notebookOutputOption")
 *                         .s3KmsKeyId("s3KmsKeyId")
 *                         .s3OutputPath("s3OutputPath")
 *                         .build())
 *                 .build())
 *         .domainName("domainName")
 *         .subnetIds(List.of("subnetIds"))
 *         .vpcId("vpcId")
 *         // the properties below are optional
 *         .appNetworkAccessType("appNetworkAccessType")
 *         .appSecurityGroupManagement("appSecurityGroupManagement")
 *         .defaultSpaceSettings(DefaultSpaceSettingsProperty.builder()
 *                 .executionRole("executionRole")
 *                 .jupyterServerAppSettings(JupyterServerAppSettingsProperty.builder()
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .build())
 *                 .kernelGatewayAppSettings(KernelGatewayAppSettingsProperty.builder()
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .build())
 *                 .securityGroups(List.of("securityGroups"))
 *                 .build())
 *         .domainSettings(DomainSettingsProperty.builder()
 *                 .rStudioServerProDomainSettings(RStudioServerProDomainSettingsProperty.builder()
 *                         .domainExecutionRoleArn("domainExecutionRoleArn")
 *                         // the properties below are optional
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .rStudioConnectUrl("rStudioConnectUrl")
 *                         .rStudioPackageManagerUrl("rStudioPackageManagerUrl")
 *                         .build())
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .build())
 *         .kmsKeyId("kmsKeyId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-04-20T17:18:02.934Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnDomainProps")
@software.amazon.jsii.Jsii.Proxy(CfnDomainProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDomainProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The mode of authentication that members use to access the Domain.
     * <p>
     * <em>Valid Values</em> : <code>SSO | IAM</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthMode();

    /**
     * The default user settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDefaultUserSettings();

    /**
     * The domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * The VPC subnets that Studio uses for communication.
     * <p>
     * <em>Length Constraints</em> : Maximum length of 32.
     * <p>
     * <em>Array members</em> : Minimum number of 1 item. Maximum number of 16 items.
     * <p>
     * <em>Pattern</em> : <code>[-0-9a-zA-Z]+</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds();

    /**
     * The ID of the Amazon Virtual Private Cloud (Amazon VPC) that Studio uses for communication.
     * <p>
     * <em>Length Constraints</em> : Maximum length of 32.
     * <p>
     * <em>Pattern</em> : <code>[-0-9a-zA-Z]+</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcId();

    /**
     * Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly` .
     * <p>
     * <ul>
     * <li><code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker , which allows direct internet access</li>
     * <li><code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets</li>
     * </ul>
     * <p>
     * <em>Valid Values</em> : <code>PublicInternetOnly | VpcOnly</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAppNetworkAccessType() {
        return null;
    }

    /**
     * The entity that creates and manages the required security groups for inter-app communication in `VpcOnly` mode.
     * <p>
     * Required when <code>CreateDomain.AppNetworkAccessType</code> is <code>VpcOnly</code> and <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAppSecurityGroupManagement() {
        return null;
    }

    /**
     * `AWS::SageMaker::Domain.DefaultSpaceSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultSpaceSettings() {
        return null;
    }

    /**
     * A collection of settings that apply to the `SageMaker Domain` .
     * <p>
     * These settings are specified through the <code>CreateDomain</code> API call.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDomainSettings() {
        return null;
    }

    /**
     * SageMaker uses AWS KMS to encrypt the EFS volume attached to the Domain with an AWS managed customer master key (CMK) by default.
     * <p>
     * For more control, specify a customer managed CMK.
     * <p>
     * <em>Length Constraints</em> : Maximum length of 2048.
     * <p>
     * <em>Pattern</em> : <code>.*</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * Tags to associated with the Domain.
     * <p>
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API.
     * <p>
     * Tags that you specify for the Domain are also added to all apps that are launched in the Domain.
     * <p>
     * <em>Array members</em> : Minimum number of 0 items. Maximum number of 50 items.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDomainProps> {
        java.lang.String authMode;
        java.lang.Object defaultUserSettings;
        java.lang.String domainName;
        java.util.List<java.lang.String> subnetIds;
        java.lang.String vpcId;
        java.lang.String appNetworkAccessType;
        java.lang.String appSecurityGroupManagement;
        java.lang.Object defaultSpaceSettings;
        java.lang.Object domainSettings;
        java.lang.String kmsKeyId;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDomainProps#getAuthMode}
         * @param authMode The mode of authentication that members use to access the Domain. This parameter is required.
         *                 <em>Valid Values</em> : <code>SSO | IAM</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authMode(java.lang.String authMode) {
            this.authMode = authMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDefaultUserSettings}
         * @param defaultUserSettings The default user settings. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultUserSettings(software.amazon.awscdk.core.IResolvable defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDefaultUserSettings}
         * @param defaultUserSettings The default user settings. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultUserSettings(software.amazon.awscdk.services.sagemaker.CfnDomain.UserSettingsProperty defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDomainName}
         * @param domainName The domain name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getSubnetIds}
         * @param subnetIds The VPC subnets that Studio uses for communication. This parameter is required.
         *                  <em>Length Constraints</em> : Maximum length of 32.
         *                  <p>
         *                  <em>Array members</em> : Minimum number of 1 item. Maximum number of 16 items.
         *                  <p>
         *                  <em>Pattern</em> : <code>[-0-9a-zA-Z]+</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getVpcId}
         * @param vpcId The ID of the Amazon Virtual Private Cloud (Amazon VPC) that Studio uses for communication. This parameter is required.
         *              <em>Length Constraints</em> : Maximum length of 32.
         *              <p>
         *              <em>Pattern</em> : <code>[-0-9a-zA-Z]+</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getAppNetworkAccessType}
         * @param appNetworkAccessType Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly` .
         *                             <ul>
         *                             <li><code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker , which allows direct internet access</li>
         *                             <li><code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets</li>
         *                             </ul>
         *                             <p>
         *                             <em>Valid Values</em> : <code>PublicInternetOnly | VpcOnly</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appNetworkAccessType(java.lang.String appNetworkAccessType) {
            this.appNetworkAccessType = appNetworkAccessType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getAppSecurityGroupManagement}
         * @param appSecurityGroupManagement The entity that creates and manages the required security groups for inter-app communication in `VpcOnly` mode.
         *                                   Required when <code>CreateDomain.AppNetworkAccessType</code> is <code>VpcOnly</code> and <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appSecurityGroupManagement(java.lang.String appSecurityGroupManagement) {
            this.appSecurityGroupManagement = appSecurityGroupManagement;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDefaultSpaceSettings}
         * @param defaultSpaceSettings `AWS::SageMaker::Domain.DefaultSpaceSettings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultSpaceSettings(software.amazon.awscdk.core.IResolvable defaultSpaceSettings) {
            this.defaultSpaceSettings = defaultSpaceSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDefaultSpaceSettings}
         * @param defaultSpaceSettings `AWS::SageMaker::Domain.DefaultSpaceSettings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultSpaceSettings(software.amazon.awscdk.services.sagemaker.CfnDomain.DefaultSpaceSettingsProperty defaultSpaceSettings) {
            this.defaultSpaceSettings = defaultSpaceSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDomainSettings}
         * @param domainSettings A collection of settings that apply to the `SageMaker Domain` .
         *                       These settings are specified through the <code>CreateDomain</code> API call.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainSettings(software.amazon.awscdk.core.IResolvable domainSettings) {
            this.domainSettings = domainSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDomainSettings}
         * @param domainSettings A collection of settings that apply to the `SageMaker Domain` .
         *                       These settings are specified through the <code>CreateDomain</code> API call.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainSettings(software.amazon.awscdk.services.sagemaker.CfnDomain.DomainSettingsProperty domainSettings) {
            this.domainSettings = domainSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getKmsKeyId}
         * @param kmsKeyId SageMaker uses AWS KMS to encrypt the EFS volume attached to the Domain with an AWS managed customer master key (CMK) by default.
         *                 For more control, specify a customer managed CMK.
         *                 <p>
         *                 <em>Length Constraints</em> : Maximum length of 2048.
         *                 <p>
         *                 <em>Pattern</em> : <code>.*</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getTags}
         * @param tags Tags to associated with the Domain.
         *             Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API.
         *             <p>
         *             Tags that you specify for the Domain are also added to all apps that are launched in the Domain.
         *             <p>
         *             <em>Array members</em> : Minimum number of 0 items. Maximum number of 50 items.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDomainProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDomainProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDomainProps {
        private final java.lang.String authMode;
        private final java.lang.Object defaultUserSettings;
        private final java.lang.String domainName;
        private final java.util.List<java.lang.String> subnetIds;
        private final java.lang.String vpcId;
        private final java.lang.String appNetworkAccessType;
        private final java.lang.String appSecurityGroupManagement;
        private final java.lang.Object defaultSpaceSettings;
        private final java.lang.Object domainSettings;
        private final java.lang.String kmsKeyId;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authMode = software.amazon.jsii.Kernel.get(this, "authMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultUserSettings = software.amazon.jsii.Kernel.get(this, "defaultUserSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.appNetworkAccessType = software.amazon.jsii.Kernel.get(this, "appNetworkAccessType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.appSecurityGroupManagement = software.amazon.jsii.Kernel.get(this, "appSecurityGroupManagement", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultSpaceSettings = software.amazon.jsii.Kernel.get(this, "defaultSpaceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.domainSettings = software.amazon.jsii.Kernel.get(this, "domainSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authMode = java.util.Objects.requireNonNull(builder.authMode, "authMode is required");
            this.defaultUserSettings = java.util.Objects.requireNonNull(builder.defaultUserSettings, "defaultUserSettings is required");
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.subnetIds = java.util.Objects.requireNonNull(builder.subnetIds, "subnetIds is required");
            this.vpcId = java.util.Objects.requireNonNull(builder.vpcId, "vpcId is required");
            this.appNetworkAccessType = builder.appNetworkAccessType;
            this.appSecurityGroupManagement = builder.appSecurityGroupManagement;
            this.defaultSpaceSettings = builder.defaultSpaceSettings;
            this.domainSettings = builder.domainSettings;
            this.kmsKeyId = builder.kmsKeyId;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAuthMode() {
            return this.authMode;
        }

        @Override
        public final java.lang.Object getDefaultUserSettings() {
            return this.defaultUserSettings;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.util.List<java.lang.String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final java.lang.String getAppNetworkAccessType() {
            return this.appNetworkAccessType;
        }

        @Override
        public final java.lang.String getAppSecurityGroupManagement() {
            return this.appSecurityGroupManagement;
        }

        @Override
        public final java.lang.Object getDefaultSpaceSettings() {
            return this.defaultSpaceSettings;
        }

        @Override
        public final java.lang.Object getDomainSettings() {
            return this.domainSettings;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authMode", om.valueToTree(this.getAuthMode()));
            data.set("defaultUserSettings", om.valueToTree(this.getDefaultUserSettings()));
            data.set("domainName", om.valueToTree(this.getDomainName()));
            data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
            data.set("vpcId", om.valueToTree(this.getVpcId()));
            if (this.getAppNetworkAccessType() != null) {
                data.set("appNetworkAccessType", om.valueToTree(this.getAppNetworkAccessType()));
            }
            if (this.getAppSecurityGroupManagement() != null) {
                data.set("appSecurityGroupManagement", om.valueToTree(this.getAppSecurityGroupManagement()));
            }
            if (this.getDefaultSpaceSettings() != null) {
                data.set("defaultSpaceSettings", om.valueToTree(this.getDefaultSpaceSettings()));
            }
            if (this.getDomainSettings() != null) {
                data.set("domainSettings", om.valueToTree(this.getDomainSettings()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnDomainProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDomainProps.Jsii$Proxy that = (CfnDomainProps.Jsii$Proxy) o;

            if (!authMode.equals(that.authMode)) return false;
            if (!defaultUserSettings.equals(that.defaultUserSettings)) return false;
            if (!domainName.equals(that.domainName)) return false;
            if (!subnetIds.equals(that.subnetIds)) return false;
            if (!vpcId.equals(that.vpcId)) return false;
            if (this.appNetworkAccessType != null ? !this.appNetworkAccessType.equals(that.appNetworkAccessType) : that.appNetworkAccessType != null) return false;
            if (this.appSecurityGroupManagement != null ? !this.appSecurityGroupManagement.equals(that.appSecurityGroupManagement) : that.appSecurityGroupManagement != null) return false;
            if (this.defaultSpaceSettings != null ? !this.defaultSpaceSettings.equals(that.defaultSpaceSettings) : that.defaultSpaceSettings != null) return false;
            if (this.domainSettings != null ? !this.domainSettings.equals(that.domainSettings) : that.domainSettings != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authMode.hashCode();
            result = 31 * result + (this.defaultUserSettings.hashCode());
            result = 31 * result + (this.domainName.hashCode());
            result = 31 * result + (this.subnetIds.hashCode());
            result = 31 * result + (this.vpcId.hashCode());
            result = 31 * result + (this.appNetworkAccessType != null ? this.appNetworkAccessType.hashCode() : 0);
            result = 31 * result + (this.appSecurityGroupManagement != null ? this.appSecurityGroupManagement.hashCode() : 0);
            result = 31 * result + (this.defaultSpaceSettings != null ? this.defaultSpaceSettings.hashCode() : 0);
            result = 31 * result + (this.domainSettings != null ? this.domainSettings.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
