package software.amazon.awscdk.services.sagemaker;

/**
 * A CloudFormation `AWS::SageMaker::Space`.
 * <p>
 * Creates a space used for real time collaboration in a Domain.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnSpace cfnSpace = CfnSpace.Builder.create(this, "MyCfnSpace")
 *         .domainId("domainId")
 *         .spaceName("spaceName")
 *         // the properties below are optional
 *         .spaceSettings(SpaceSettingsProperty.builder()
 *                 .jupyterServerAppSettings(JupyterServerAppSettingsProperty.builder()
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .build())
 *                 .kernelGatewayAppSettings(KernelGatewayAppSettingsProperty.builder()
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-04-20T17:18:03.238Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnSpace")
public class CfnSpace extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnSpace(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSpace(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnSpace.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::SageMaker::Space`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSpace(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnSpaceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The space's Amazon Resource Name (ARN).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSpaceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrSpaceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The ID of the associated Domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainId() {
        return software.amazon.jsii.Kernel.get(this, "domainId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the associated Domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainId", java.util.Objects.requireNonNull(value, "domainId is required"));
    }

    /**
     * The name of the space.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSpaceName() {
        return software.amazon.jsii.Kernel.get(this, "spaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the space.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpaceName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "spaceName", java.util.Objects.requireNonNull(value, "spaceName is required"));
    }

    /**
     * A collection of space settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSpaceSettings() {
        return software.amazon.jsii.Kernel.get(this, "spaceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A collection of space settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpaceSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "spaceSettings", value);
    }

    /**
     * A collection of space settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpaceSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnSpace.SpaceSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "spaceSettings", value);
    }
    /**
     * A custom SageMaker image.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html">Bring your own SageMaker image</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CustomImageProperty customImageProperty = CustomImageProperty.builder()
     *         .appImageConfigName("appImageConfigName")
     *         .imageName("imageName")
     *         // the properties below are optional
     *         .imageVersionNumber(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnSpace.CustomImageProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomImageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomImageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the AppImageConfig.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAppImageConfigName();

        /**
         * The name of the CustomImage.
         * <p>
         * Must be unique to your account.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImageName();

        /**
         * The version number of the CustomImage.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getImageVersionNumber() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomImageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomImageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomImageProperty> {
            java.lang.String appImageConfigName;
            java.lang.String imageName;
            java.lang.Number imageVersionNumber;

            /**
             * Sets the value of {@link CustomImageProperty#getAppImageConfigName}
             * @param appImageConfigName The name of the AppImageConfig. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appImageConfigName(java.lang.String appImageConfigName) {
                this.appImageConfigName = appImageConfigName;
                return this;
            }

            /**
             * Sets the value of {@link CustomImageProperty#getImageName}
             * @param imageName The name of the CustomImage. This parameter is required.
             *                  Must be unique to your account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageName(java.lang.String imageName) {
                this.imageName = imageName;
                return this;
            }

            /**
             * Sets the value of {@link CustomImageProperty#getImageVersionNumber}
             * @param imageVersionNumber The version number of the CustomImage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageVersionNumber(java.lang.Number imageVersionNumber) {
                this.imageVersionNumber = imageVersionNumber;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomImageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomImageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomImageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomImageProperty {
            private final java.lang.String appImageConfigName;
            private final java.lang.String imageName;
            private final java.lang.Number imageVersionNumber;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appImageConfigName = software.amazon.jsii.Kernel.get(this, "appImageConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageName = software.amazon.jsii.Kernel.get(this, "imageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageVersionNumber = software.amazon.jsii.Kernel.get(this, "imageVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appImageConfigName = java.util.Objects.requireNonNull(builder.appImageConfigName, "appImageConfigName is required");
                this.imageName = java.util.Objects.requireNonNull(builder.imageName, "imageName is required");
                this.imageVersionNumber = builder.imageVersionNumber;
            }

            @Override
            public final java.lang.String getAppImageConfigName() {
                return this.appImageConfigName;
            }

            @Override
            public final java.lang.String getImageName() {
                return this.imageName;
            }

            @Override
            public final java.lang.Number getImageVersionNumber() {
                return this.imageVersionNumber;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("appImageConfigName", om.valueToTree(this.getAppImageConfigName()));
                data.set("imageName", om.valueToTree(this.getImageName()));
                if (this.getImageVersionNumber() != null) {
                    data.set("imageVersionNumber", om.valueToTree(this.getImageVersionNumber()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnSpace.CustomImageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomImageProperty.Jsii$Proxy that = (CustomImageProperty.Jsii$Proxy) o;

                if (!appImageConfigName.equals(that.appImageConfigName)) return false;
                if (!imageName.equals(that.imageName)) return false;
                return this.imageVersionNumber != null ? this.imageVersionNumber.equals(that.imageVersionNumber) : that.imageVersionNumber == null;
            }

            @Override
            public final int hashCode() {
                int result = this.appImageConfigName.hashCode();
                result = 31 * result + (this.imageName.hashCode());
                result = 31 * result + (this.imageVersionNumber != null ? this.imageVersionNumber.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The JupyterServer app settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * JupyterServerAppSettingsProperty jupyterServerAppSettingsProperty = JupyterServerAppSettingsProperty.builder()
     *         .defaultResourceSpec(ResourceSpecProperty.builder()
     *                 .instanceType("instanceType")
     *                 .sageMakerImageArn("sageMakerImageArn")
     *                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnSpace.JupyterServerAppSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(JupyterServerAppSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JupyterServerAppSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.
         * <p>
         * If you use the <code>LifecycleConfigArns</code> parameter, then this parameter is also required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultResourceSpec() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JupyterServerAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JupyterServerAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JupyterServerAppSettingsProperty> {
            java.lang.Object defaultResourceSpec;

            /**
             * Sets the value of {@link JupyterServerAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.
             *                            If you use the <code>LifecycleConfigArns</code> parameter, then this parameter is also required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.core.IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link JupyterServerAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.
             *                            If you use the <code>LifecycleConfigArns</code> parameter, then this parameter is also required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.services.sagemaker.CfnSpace.ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JupyterServerAppSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JupyterServerAppSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JupyterServerAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JupyterServerAppSettingsProperty {
            private final java.lang.Object defaultResourceSpec;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultResourceSpec = software.amazon.jsii.Kernel.get(this, "defaultResourceSpec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultResourceSpec = builder.defaultResourceSpec;
            }

            @Override
            public final java.lang.Object getDefaultResourceSpec() {
                return this.defaultResourceSpec;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefaultResourceSpec() != null) {
                    data.set("defaultResourceSpec", om.valueToTree(this.getDefaultResourceSpec()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnSpace.JupyterServerAppSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JupyterServerAppSettingsProperty.Jsii$Proxy that = (JupyterServerAppSettingsProperty.Jsii$Proxy) o;

                return this.defaultResourceSpec != null ? this.defaultResourceSpec.equals(that.defaultResourceSpec) : that.defaultResourceSpec == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultResourceSpec != null ? this.defaultResourceSpec.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The KernelGateway app settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * KernelGatewayAppSettingsProperty kernelGatewayAppSettingsProperty = KernelGatewayAppSettingsProperty.builder()
     *         .customImages(List.of(CustomImageProperty.builder()
     *                 .appImageConfigName("appImageConfigName")
     *                 .imageName("imageName")
     *                 // the properties below are optional
     *                 .imageVersionNumber(123)
     *                 .build()))
     *         .defaultResourceSpec(ResourceSpecProperty.builder()
     *                 .instanceType("instanceType")
     *                 .sageMakerImageArn("sageMakerImageArn")
     *                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnSpace.KernelGatewayAppSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(KernelGatewayAppSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KernelGatewayAppSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of custom SageMaker images that are configured to run as a KernelGateway app.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomImages() {
            return null;
        }

        /**
         * The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
         * <p>
         * <blockquote>
         * <p>
         * The Amazon SageMaker Studio UI does not use the default instance type value set here. The default instance type set here is used when Apps are created using the AWS Command Line Interface or AWS CloudFormation and the instance type parameter value is not passed.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultResourceSpec() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KernelGatewayAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KernelGatewayAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KernelGatewayAppSettingsProperty> {
            java.lang.Object customImages;
            java.lang.Object defaultResourceSpec;

            /**
             * Sets the value of {@link KernelGatewayAppSettingsProperty#getCustomImages}
             * @param customImages A list of custom SageMaker images that are configured to run as a KernelGateway app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customImages(software.amazon.awscdk.core.IResolvable customImages) {
                this.customImages = customImages;
                return this;
            }

            /**
             * Sets the value of {@link KernelGatewayAppSettingsProperty#getCustomImages}
             * @param customImages A list of custom SageMaker images that are configured to run as a KernelGateway app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customImages(java.util.List<? extends java.lang.Object> customImages) {
                this.customImages = customImages;
                return this;
            }

            /**
             * Sets the value of {@link KernelGatewayAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
             *                            <blockquote>
             *                            <p>
             *                            The Amazon SageMaker Studio UI does not use the default instance type value set here. The default instance type set here is used when Apps are created using the AWS Command Line Interface or AWS CloudFormation and the instance type parameter value is not passed.
             *                            <p>
             *                            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.core.IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link KernelGatewayAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
             *                            <blockquote>
             *                            <p>
             *                            The Amazon SageMaker Studio UI does not use the default instance type value set here. The default instance type set here is used when Apps are created using the AWS Command Line Interface or AWS CloudFormation and the instance type parameter value is not passed.
             *                            <p>
             *                            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.services.sagemaker.CfnSpace.ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KernelGatewayAppSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KernelGatewayAppSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KernelGatewayAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KernelGatewayAppSettingsProperty {
            private final java.lang.Object customImages;
            private final java.lang.Object defaultResourceSpec;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customImages = software.amazon.jsii.Kernel.get(this, "customImages", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultResourceSpec = software.amazon.jsii.Kernel.get(this, "defaultResourceSpec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customImages = builder.customImages;
                this.defaultResourceSpec = builder.defaultResourceSpec;
            }

            @Override
            public final java.lang.Object getCustomImages() {
                return this.customImages;
            }

            @Override
            public final java.lang.Object getDefaultResourceSpec() {
                return this.defaultResourceSpec;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomImages() != null) {
                    data.set("customImages", om.valueToTree(this.getCustomImages()));
                }
                if (this.getDefaultResourceSpec() != null) {
                    data.set("defaultResourceSpec", om.valueToTree(this.getDefaultResourceSpec()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnSpace.KernelGatewayAppSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KernelGatewayAppSettingsProperty.Jsii$Proxy that = (KernelGatewayAppSettingsProperty.Jsii$Proxy) o;

                if (this.customImages != null ? !this.customImages.equals(that.customImages) : that.customImages != null) return false;
                return this.defaultResourceSpec != null ? this.defaultResourceSpec.equals(that.defaultResourceSpec) : that.defaultResourceSpec == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customImages != null ? this.customImages.hashCode() : 0;
                result = 31 * result + (this.defaultResourceSpec != null ? this.defaultResourceSpec.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the ARN's of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ResourceSpecProperty resourceSpecProperty = ResourceSpecProperty.builder()
     *         .instanceType("instanceType")
     *         .sageMakerImageArn("sageMakerImageArn")
     *         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnSpace.ResourceSpecProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceSpecProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceSpecProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The instance type that the image version runs on.
         * <p>
         * <blockquote>
         * <p>
         * <em>JupyterServer apps</em> only support the <code>system</code> value.
         * <p>
         * For <em>KernelGateway apps</em> , the <code>system</code> value is translated to <code>ml.t3.medium</code> . KernelGateway apps also support all other values for available instance types.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * The ARN of the SageMaker image that the image version belongs to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSageMakerImageArn() {
            return null;
        }

        /**
         * The ARN of the image version created on the instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSageMakerImageVersionArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceSpecProperty> {
            java.lang.String instanceType;
            java.lang.String sageMakerImageArn;
            java.lang.String sageMakerImageVersionArn;

            /**
             * Sets the value of {@link ResourceSpecProperty#getInstanceType}
             * @param instanceType The instance type that the image version runs on.
             *                     <blockquote>
             *                     <p>
             *                     <em>JupyterServer apps</em> only support the <code>system</code> value.
             *                     <p>
             *                     For <em>KernelGateway apps</em> , the <code>system</code> value is translated to <code>ml.t3.medium</code> . KernelGateway apps also support all other values for available instance types.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ResourceSpecProperty#getSageMakerImageArn}
             * @param sageMakerImageArn The ARN of the SageMaker image that the image version belongs to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sageMakerImageArn(java.lang.String sageMakerImageArn) {
                this.sageMakerImageArn = sageMakerImageArn;
                return this;
            }

            /**
             * Sets the value of {@link ResourceSpecProperty#getSageMakerImageVersionArn}
             * @param sageMakerImageVersionArn The ARN of the image version created on the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sageMakerImageVersionArn(java.lang.String sageMakerImageVersionArn) {
                this.sageMakerImageVersionArn = sageMakerImageVersionArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceSpecProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceSpecProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceSpecProperty {
            private final java.lang.String instanceType;
            private final java.lang.String sageMakerImageArn;
            private final java.lang.String sageMakerImageVersionArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sageMakerImageArn = software.amazon.jsii.Kernel.get(this, "sageMakerImageArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sageMakerImageVersionArn = software.amazon.jsii.Kernel.get(this, "sageMakerImageVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceType = builder.instanceType;
                this.sageMakerImageArn = builder.sageMakerImageArn;
                this.sageMakerImageVersionArn = builder.sageMakerImageVersionArn;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.String getSageMakerImageArn() {
                return this.sageMakerImageArn;
            }

            @Override
            public final java.lang.String getSageMakerImageVersionArn() {
                return this.sageMakerImageVersionArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getSageMakerImageArn() != null) {
                    data.set("sageMakerImageArn", om.valueToTree(this.getSageMakerImageArn()));
                }
                if (this.getSageMakerImageVersionArn() != null) {
                    data.set("sageMakerImageVersionArn", om.valueToTree(this.getSageMakerImageVersionArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnSpace.ResourceSpecProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceSpecProperty.Jsii$Proxy that = (ResourceSpecProperty.Jsii$Proxy) o;

                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.sageMakerImageArn != null ? !this.sageMakerImageArn.equals(that.sageMakerImageArn) : that.sageMakerImageArn != null) return false;
                return this.sageMakerImageVersionArn != null ? this.sageMakerImageVersionArn.equals(that.sageMakerImageVersionArn) : that.sageMakerImageVersionArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceType != null ? this.instanceType.hashCode() : 0;
                result = 31 * result + (this.sageMakerImageArn != null ? this.sageMakerImageArn.hashCode() : 0);
                result = 31 * result + (this.sageMakerImageVersionArn != null ? this.sageMakerImageVersionArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A collection of space settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * SpaceSettingsProperty spaceSettingsProperty = SpaceSettingsProperty.builder()
     *         .jupyterServerAppSettings(JupyterServerAppSettingsProperty.builder()
     *                 .defaultResourceSpec(ResourceSpecProperty.builder()
     *                         .instanceType("instanceType")
     *                         .sageMakerImageArn("sageMakerImageArn")
     *                         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                         .build())
     *                 .build())
     *         .kernelGatewayAppSettings(KernelGatewayAppSettingsProperty.builder()
     *                 .customImages(List.of(CustomImageProperty.builder()
     *                         .appImageConfigName("appImageConfigName")
     *                         .imageName("imageName")
     *                         // the properties below are optional
     *                         .imageVersionNumber(123)
     *                         .build()))
     *                 .defaultResourceSpec(ResourceSpecProperty.builder()
     *                         .instanceType("instanceType")
     *                         .sageMakerImageArn("sageMakerImageArn")
     *                         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnSpace.SpaceSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(SpaceSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpaceSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The JupyterServer app settings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJupyterServerAppSettings() {
            return null;
        }

        /**
         * The KernelGateway app settings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKernelGatewayAppSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpaceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpaceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpaceSettingsProperty> {
            java.lang.Object jupyterServerAppSettings;
            java.lang.Object kernelGatewayAppSettings;

            /**
             * Sets the value of {@link SpaceSettingsProperty#getJupyterServerAppSettings}
             * @param jupyterServerAppSettings The JupyterServer app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jupyterServerAppSettings(software.amazon.awscdk.core.IResolvable jupyterServerAppSettings) {
                this.jupyterServerAppSettings = jupyterServerAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link SpaceSettingsProperty#getJupyterServerAppSettings}
             * @param jupyterServerAppSettings The JupyterServer app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jupyterServerAppSettings(software.amazon.awscdk.services.sagemaker.CfnSpace.JupyterServerAppSettingsProperty jupyterServerAppSettings) {
                this.jupyterServerAppSettings = jupyterServerAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link SpaceSettingsProperty#getKernelGatewayAppSettings}
             * @param kernelGatewayAppSettings The KernelGateway app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kernelGatewayAppSettings(software.amazon.awscdk.core.IResolvable kernelGatewayAppSettings) {
                this.kernelGatewayAppSettings = kernelGatewayAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link SpaceSettingsProperty#getKernelGatewayAppSettings}
             * @param kernelGatewayAppSettings The KernelGateway app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kernelGatewayAppSettings(software.amazon.awscdk.services.sagemaker.CfnSpace.KernelGatewayAppSettingsProperty kernelGatewayAppSettings) {
                this.kernelGatewayAppSettings = kernelGatewayAppSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpaceSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpaceSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpaceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpaceSettingsProperty {
            private final java.lang.Object jupyterServerAppSettings;
            private final java.lang.Object kernelGatewayAppSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.jupyterServerAppSettings = software.amazon.jsii.Kernel.get(this, "jupyterServerAppSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kernelGatewayAppSettings = software.amazon.jsii.Kernel.get(this, "kernelGatewayAppSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.jupyterServerAppSettings = builder.jupyterServerAppSettings;
                this.kernelGatewayAppSettings = builder.kernelGatewayAppSettings;
            }

            @Override
            public final java.lang.Object getJupyterServerAppSettings() {
                return this.jupyterServerAppSettings;
            }

            @Override
            public final java.lang.Object getKernelGatewayAppSettings() {
                return this.kernelGatewayAppSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getJupyterServerAppSettings() != null) {
                    data.set("jupyterServerAppSettings", om.valueToTree(this.getJupyterServerAppSettings()));
                }
                if (this.getKernelGatewayAppSettings() != null) {
                    data.set("kernelGatewayAppSettings", om.valueToTree(this.getKernelGatewayAppSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnSpace.SpaceSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpaceSettingsProperty.Jsii$Proxy that = (SpaceSettingsProperty.Jsii$Proxy) o;

                if (this.jupyterServerAppSettings != null ? !this.jupyterServerAppSettings.equals(that.jupyterServerAppSettings) : that.jupyterServerAppSettings != null) return false;
                return this.kernelGatewayAppSettings != null ? this.kernelGatewayAppSettings.equals(that.kernelGatewayAppSettings) : that.kernelGatewayAppSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.jupyterServerAppSettings != null ? this.jupyterServerAppSettings.hashCode() : 0;
                result = 31 * result + (this.kernelGatewayAppSettings != null ? this.kernelGatewayAppSettings.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnSpace}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnSpace> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnSpaceProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnSpaceProps.Builder();
        }

        /**
         * The ID of the associated Domain.
         * <p>
         * @return {@code this}
         * @param domainId The ID of the associated Domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainId(final java.lang.String domainId) {
            this.props.domainId(domainId);
            return this;
        }

        /**
         * The name of the space.
         * <p>
         * @return {@code this}
         * @param spaceName The name of the space. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spaceName(final java.lang.String spaceName) {
            this.props.spaceName(spaceName);
            return this;
        }

        /**
         * A collection of space settings.
         * <p>
         * @return {@code this}
         * @param spaceSettings A collection of space settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spaceSettings(final software.amazon.awscdk.core.IResolvable spaceSettings) {
            this.props.spaceSettings(spaceSettings);
            return this;
        }
        /**
         * A collection of space settings.
         * <p>
         * @return {@code this}
         * @param spaceSettings A collection of space settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spaceSettings(final software.amazon.awscdk.services.sagemaker.CfnSpace.SpaceSettingsProperty spaceSettings) {
            this.props.spaceSettings(spaceSettings);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnSpace}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnSpace build() {
            return new software.amazon.awscdk.services.sagemaker.CfnSpace(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
