package software.amazon.awscdk.services.sagemaker;

/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-05-21T11:01:35.580Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnEndpointConfig")
public class CfnEndpointConfig extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnEndpointConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEndpointConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::SageMaker::EndpointConfig`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnEndpointConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnEndpointConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A factory method that creates a new instance of this class from an object containing the CloudFormation properties of this resource.
     * <p>
     * Used in the &#64;aws-cdk/cloudformation-include module.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param resourceAttributes This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnEndpointConfig fromCloudFormation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.Object resourceAttributes, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FromCloudFormationOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.class, "fromCloudFormation", software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), resourceAttributes, java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointConfigName() {
        return this.jsiiGet("attrEndpointConfigName", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::SageMaker::EndpointConfig.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::SageMaker::EndpointConfig.ProductionVariants`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.Object getProductionVariants() {
        return this.jsiiGet("productionVariants", java.lang.Object.class);
    }

    /**
     * `AWS::SageMaker::EndpointConfig.ProductionVariants`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setProductionVariants(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("productionVariants", java.util.Objects.requireNonNull(value, "productionVariants is required"));
    }

    /**
     * `AWS::SageMaker::EndpointConfig.ProductionVariants`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setProductionVariants(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        this.jsiiSet("productionVariants", java.util.Objects.requireNonNull(value, "productionVariants is required"));
    }

    /**
     * `AWS::SageMaker::EndpointConfig.EndpointConfigName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndpointConfigName() {
        return this.jsiiGet("endpointConfigName", java.lang.String.class);
    }

    /**
     * `AWS::SageMaker::EndpointConfig.EndpointConfigName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEndpointConfigName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("endpointConfigName", value);
    }

    /**
     * `AWS::SageMaker::EndpointConfig.KmsKeyId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return this.jsiiGet("kmsKeyId", java.lang.String.class);
    }

    /**
     * `AWS::SageMaker::EndpointConfig.KmsKeyId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("kmsKeyId", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnEndpointConfig.ProductionVariantProperty")
    @software.amazon.jsii.Jsii.Proxy(ProductionVariantProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ProductionVariantProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InitialInstanceCount`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialinstancecount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.Number getInitialInstanceCount();

        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InitialVariantWeight`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialvariantweight
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.Number getInitialVariantWeight();

        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InstanceType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-instancetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

        /**
         * `CfnEndpointConfig.ProductionVariantProperty.ModelName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modelname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getModelName();

        /**
         * `CfnEndpointConfig.ProductionVariantProperty.VariantName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-variantname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getVariantName();

        /**
         * `CfnEndpointConfig.ProductionVariantProperty.AcceleratorType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-acceleratortype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getAcceleratorType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProductionVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProductionVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Number initialInstanceCount;
            private java.lang.Number initialVariantWeight;
            private java.lang.String instanceType;
            private java.lang.String modelName;
            private java.lang.String variantName;
            private java.lang.String acceleratorType;

            /**
             * Sets the value of {@link ProductionVariantProperty#getInitialInstanceCount}
             * @param initialInstanceCount `CfnEndpointConfig.ProductionVariantProperty.InitialInstanceCount`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder initialInstanceCount(java.lang.Number initialInstanceCount) {
                this.initialInstanceCount = initialInstanceCount;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getInitialVariantWeight}
             * @param initialVariantWeight `CfnEndpointConfig.ProductionVariantProperty.InitialVariantWeight`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder initialVariantWeight(java.lang.Number initialVariantWeight) {
                this.initialVariantWeight = initialVariantWeight;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getInstanceType}
             * @param instanceType `CfnEndpointConfig.ProductionVariantProperty.InstanceType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getModelName}
             * @param modelName `CfnEndpointConfig.ProductionVariantProperty.ModelName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder modelName(java.lang.String modelName) {
                this.modelName = modelName;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getVariantName}
             * @param variantName `CfnEndpointConfig.ProductionVariantProperty.VariantName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder variantName(java.lang.String variantName) {
                this.variantName = variantName;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getAcceleratorType}
             * @param acceleratorType `CfnEndpointConfig.ProductionVariantProperty.AcceleratorType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder acceleratorType(java.lang.String acceleratorType) {
                this.acceleratorType = acceleratorType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProductionVariantProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ProductionVariantProperty build() {
                return new Jsii$Proxy(initialInstanceCount, initialVariantWeight, instanceType, modelName, variantName, acceleratorType);
            }
        }

        /**
         * An implementation for {@link ProductionVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProductionVariantProperty {
            private final java.lang.Number initialInstanceCount;
            private final java.lang.Number initialVariantWeight;
            private final java.lang.String instanceType;
            private final java.lang.String modelName;
            private final java.lang.String variantName;
            private final java.lang.String acceleratorType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.initialInstanceCount = this.jsiiGet("initialInstanceCount", java.lang.Number.class);
                this.initialVariantWeight = this.jsiiGet("initialVariantWeight", java.lang.Number.class);
                this.instanceType = this.jsiiGet("instanceType", java.lang.String.class);
                this.modelName = this.jsiiGet("modelName", java.lang.String.class);
                this.variantName = this.jsiiGet("variantName", java.lang.String.class);
                this.acceleratorType = this.jsiiGet("acceleratorType", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number initialInstanceCount, final java.lang.Number initialVariantWeight, final java.lang.String instanceType, final java.lang.String modelName, final java.lang.String variantName, final java.lang.String acceleratorType) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.initialInstanceCount = java.util.Objects.requireNonNull(initialInstanceCount, "initialInstanceCount is required");
                this.initialVariantWeight = java.util.Objects.requireNonNull(initialVariantWeight, "initialVariantWeight is required");
                this.instanceType = java.util.Objects.requireNonNull(instanceType, "instanceType is required");
                this.modelName = java.util.Objects.requireNonNull(modelName, "modelName is required");
                this.variantName = java.util.Objects.requireNonNull(variantName, "variantName is required");
                this.acceleratorType = acceleratorType;
            }

            @Override
            public java.lang.Number getInitialInstanceCount() {
                return this.initialInstanceCount;
            }

            @Override
            public java.lang.Number getInitialVariantWeight() {
                return this.initialVariantWeight;
            }

            @Override
            public java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public java.lang.String getModelName() {
                return this.modelName;
            }

            @Override
            public java.lang.String getVariantName() {
                return this.variantName;
            }

            @Override
            public java.lang.String getAcceleratorType() {
                return this.acceleratorType;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("initialInstanceCount", om.valueToTree(this.getInitialInstanceCount()));
                data.set("initialVariantWeight", om.valueToTree(this.getInitialVariantWeight()));
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
                data.set("modelName", om.valueToTree(this.getModelName()));
                data.set("variantName", om.valueToTree(this.getVariantName()));
                if (this.getAcceleratorType() != null) {
                    data.set("acceleratorType", om.valueToTree(this.getAcceleratorType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnEndpointConfig.ProductionVariantProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProductionVariantProperty.Jsii$Proxy that = (ProductionVariantProperty.Jsii$Proxy) o;

                if (!initialInstanceCount.equals(that.initialInstanceCount)) return false;
                if (!initialVariantWeight.equals(that.initialVariantWeight)) return false;
                if (!instanceType.equals(that.instanceType)) return false;
                if (!modelName.equals(that.modelName)) return false;
                if (!variantName.equals(that.variantName)) return false;
                return this.acceleratorType != null ? this.acceleratorType.equals(that.acceleratorType) : that.acceleratorType == null;
            }

            @Override
            public int hashCode() {
                int result = this.initialInstanceCount.hashCode();
                result = 31 * result + (this.initialVariantWeight.hashCode());
                result = 31 * result + (this.instanceType.hashCode());
                result = 31 * result + (this.modelName.hashCode());
                result = 31 * result + (this.variantName.hashCode());
                result = 31 * result + (this.acceleratorType != null ? this.acceleratorType.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnEndpointConfigProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnEndpointConfigProps.Builder();
        }

        /**
         * `AWS::SageMaker::EndpointConfig.ProductionVariants`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
         * @param productionVariants `AWS::SageMaker::EndpointConfig.ProductionVariants`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder productionVariants(final software.amazon.awscdk.core.IResolvable productionVariants) {
            this.props.productionVariants(productionVariants);
            return this;
        }
        /**
         * `AWS::SageMaker::EndpointConfig.ProductionVariants`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
         * @param productionVariants `AWS::SageMaker::EndpointConfig.ProductionVariants`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder productionVariants(final java.util.List<java.lang.Object> productionVariants) {
            this.props.productionVariants(productionVariants);
            return this;
        }

        /**
         * `AWS::SageMaker::EndpointConfig.EndpointConfigName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
         * @param endpointConfigName `AWS::SageMaker::EndpointConfig.EndpointConfigName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder endpointConfigName(final java.lang.String endpointConfigName) {
            this.props.endpointConfigName(endpointConfigName);
            return this;
        }

        /**
         * `AWS::SageMaker::EndpointConfig.KmsKeyId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
         * @param kmsKeyId `AWS::SageMaker::EndpointConfig.KmsKeyId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * `AWS::SageMaker::EndpointConfig.Tags`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
         * @param tags `AWS::SageMaker::EndpointConfig.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.sagemaker.CfnEndpointConfig build() {
            return new software.amazon.awscdk.services.sagemaker.CfnEndpointConfig(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
